/**
* @javaClass net.minecraft.class_1268
*/
declare class Hand extends Internal.Enum<Hand> {
    static valueOf($$0: string): Hand;
    static values(): Hand[];
    static readonly "MAIN_HAND" : Hand;
    static readonly "OFF_HAND" : Hand;
}
type Hand_ = "main_hand" | "off_hand" | Hand;
/**
* @javaClass net.minecraft.class_2960
*/
declare class ResourceLocation implements Internal.Comparable<ResourceLocation>, Internal.ResourceLocationExtensions, Internal.IdentifierAccessor, Internal.ResourceLocationAccess, Internal.IdentifierHooks, Internal.SpecialEquality {
    static read($$0: string): Internal.DataResult<ResourceLocation>;
    static read($$0: Internal.StringReader_): ResourceLocation;
    static validPathChar($$0: string): boolean;
    static tryParse($$0: string): ResourceLocation;
    static isAllowedInResourceLocation($$0: string): boolean;
    compareTo($$0: ResourceLocation_): number;
    static isValidResourceLocation($$0: string): boolean;
    getNamespace(): string;
    hashCode(): number;
    compareNamespaced(o: ResourceLocation_): number;
    static of($$0: string, $$1: string): ResourceLocation;
    equals($$0: any): boolean;
    getPath(): string;
    toString(): string;
    specialEquals(o: any, shallow: boolean): boolean;
    toDebugFileName(): string;
    static readonly "CODEC" : Internal.Codec<ResourceLocation>;
    static readonly "REALMS_NAMESPACE" : "realms";
    static readonly "NAMESPACE_SEPARATOR" : ":";
    static readonly "DEFAULT_NAMESPACE" : "minecraft";
    get path(): string;
    get namespace(): string;
    constructor($$0: string, $$1: string);
    constructor($$0: string);
}
type ResourceLocation_ = string | ResourceLocation;
/**
* @javaClass net.minecraft.class_2338
*/
declare class BlockPos extends Vec3i {
    static randomBetweenClosed($$0: Internal.Random_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): Internal.Iterable<BlockPos>;
    rotate($$0: Internal.Rotation_): this;
    static withinManhattanStream($$0: BlockPos_, $$1: number, $$2: number, $$3: number): Internal.Stream<BlockPos>;
    south($$0: number): this;
    south(): this;
    north($$0: number): this;
    north(): this;
    atY($$0: number): this;
    static betweenClosedStream($$0: BlockPos_, $$1: BlockPos_): Internal.Stream<BlockPos>;
    static betweenClosedStream($$0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    static betweenClosedStream($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.Stream<BlockPos>;
    static betweenClosedStream($$0: Internal.AABB_): Internal.Stream<BlockPos>;
    static findClosestMatch($$0: BlockPos_, $$1: number, $$2: number, $$3: Internal.Predicate_<BlockPos_>): Internal.Optional<BlockPos>;
    east($$0: number): this;
    east(): this;
    static spiralAround($$0: BlockPos_, $$1: number, $$2: Internal.Direction_, $$3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    static betweenClosed($$0: BlockPos_, $$1: BlockPos_): Internal.Iterable<BlockPos>;
    static betweenClosed($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.Iterable<BlockPos>;
    static of($$0: number): BlockPos;
    above(): this;
    above($$0: number): this;
    west($$0: number): this;
    west(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    multiply($$0: number): this;
    static withinManhattan($$0: BlockPos_, $$1: number, $$2: number, $$3: number): Internal.Iterable<BlockPos>;
    static offset($$0: number, $$1: Internal.Direction_): number;
    static offset($$0: number, $$1: number, $$2: number, $$3: number): number;
    offset($$0: Vec3i_): this;
    offset($$0: number, $$1: number, $$2: number): this;
    below(): this;
    below($$0: number): this;
    subtract($$0: Vec3i_): this;
    cross($$0: Vec3i_): this;
    static randomInCube($$0: Internal.Random_, $$1: number, $$2: BlockPos_, $$3: number): Internal.Iterable<BlockPos>;
    static asLong($$0: number, $$1: number, $$2: number): number;
    asLong(): number;
    immutable(): this;
    static getX($$0: number): number;
    static getY($$0: number): number;
    static getZ($$0: number): number;
    static getFlatIndex($$0: number): number;
    relative($$0: Internal.Direction_, $$1: number): this;
    relative($$0: Internal.Direction$Axis_, $$1: number): this;
    relative($$0: Internal.Direction_): this;
    static readonly "ZERO" : BlockPos;
    static readonly "CODEC" : Internal.Codec<BlockPos>;
    static readonly "PACKED_Y_LENGTH" : 12;
    constructor($$0: Vec3i);
    constructor($$0: Internal.Position);
    constructor($$0: Vec3);
    constructor($$0: number, $$1: number, $$2: number);
    constructor($$0: number, $$1: number, $$2: number);
}
type BlockPos_ = BlockPos;
/**
* @javaClass net.minecraft.class_1304
*/
declare class EquipmentSlot extends Internal.Enum<EquipmentSlot> {
    getFilterFlag(): number;
    static byTypeAndIndex($$0: Internal.EquipmentSlot$Type_, $$1: number): EquipmentSlot;
    getName(): string;
    getIndex($$0: number): number;
    getIndex(): number;
    getType(): Internal.EquipmentSlot$Type;
    static valueOf($$0: string): EquipmentSlot;
    static values(): EquipmentSlot[];
    static byName($$0: string): EquipmentSlot;
    static readonly "CHEST" : EquipmentSlot;
    static readonly "HEAD" : EquipmentSlot;
    static readonly "OFFHAND" : EquipmentSlot;
    static readonly "MAINHAND" : EquipmentSlot;
    static readonly "LEGS" : EquipmentSlot;
    static readonly "FEET" : EquipmentSlot;
    get filterFlag(): number;
    get name(): string;
    get index(): number;
    get type(): Internal.EquipmentSlot$Type;
}
type EquipmentSlot_ = "mainhand" | "head" | "feet" | "chest" | "legs" | "offhand" | EquipmentSlot;
/**
* @javaClass dev.latvian.mods.kubejs.bindings.ItemWrapper
*/
declare class Item {
    static clearListCache(): void;
    static getList(): Internal.ListJS;
    static getEmpty(): Internal.ItemStackJS;
    static of(in_: Internal.ItemStackJS_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStackJS;
    static of(in_: Internal.ItemStackJS_, tag: Internal.CompoundTag_): Internal.ItemStackJS;
    static of(in_: Internal.ItemStackJS_, count: number): Internal.ItemStackJS;
    static of(in_: Internal.ItemStackJS_): Internal.ItemStackJS;
    static getTypeList(): Internal.ListJS;
    static isItem(o: any): boolean;
    static findGroup(id: string): Internal.CreativeModeTab;
    static getItem(id: ResourceLocation_): Internal.Item;
    static exists(id: ResourceLocation_): boolean;
    static withChance(in_: Internal.ItemStackJS_, c: number): Internal.ItemStackJS;
    static fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    static withNBT(in_: Internal.ItemStackJS_, nbt: Internal.CompoundTag_): Internal.ItemStackJS;
    get typeList(): Internal.ListJS;
    get list(): Internal.ListJS;
    get empty(): Internal.ItemStackJS;
    constructor();
}
type Item_ = Item;
/**
* @javaClass net.minecraft.class_1814
*/
declare class Rarity extends Internal.Enum<Rarity> {
    static valueOf($$0: string): Rarity;
    static values(): Rarity[];
    static readonly "TWILIGHT" : Rarity;
    static readonly "RARE" : Rarity;
    readonly "color" : Internal.ChatFormatting;
    static readonly "EPIC" : Rarity;
    static readonly "UNCOMMON" : Rarity;
    static readonly "COMMON" : Rarity;
}
type Rarity_ = "uncommon" | "common" | "rare" | "epic" | "twilight" | Rarity;
/**
* @javaClass dev.latvian.mods.kubejs.block.state.BlockStatePredicate
*/
declare interface BlockStatePredicate {
    test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    /**
    */
    of(o: BlockStatePredicate_): this;
    getBlocks(): Internal.Collection<Internal.Block>;
    fromString(s: string): this;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState_>): boolean;
    getBlockIds(): Internal.Set<ResourceLocation>;
    asRuleTest(): Internal.RuleTest;
    ruleTestOf(o: any): Internal.RuleTest;
    readonly "AIR_ID" : ResourceLocation;
}
/**
*/
type BlockStatePredicate_ = BlockStatePredicate_[] | {or?: BlockStatePredicate_, not?: BlockStatePredicate_} | Internal.Block_ | Internal.BlockState_ | `#${Special.BlockTag}` | RegExp | BlockStatePredicate;
declare const BlockStatePredicate: BlockStatePredicate;
/**
* @javaClass com.almostreliable.lootjs.filters.ItemFilter
*/
declare interface ItemFilter extends Internal.Predicate<Internal.ItemStack> {
    not(itemFilter: ItemFilter_): this;
    or(other: ItemFilter_): this;
    or(...itemFilters: ItemFilter_[]): this;
    or(arg0: Internal.Predicate_<Internal.ItemStack_>): Internal.Predicate<Internal.ItemStack>;
    test(arg0: Internal.ItemStack_): boolean;
    and(...itemFilters: ItemFilter_[]): this;
    and(other: ItemFilter_): this;
    and(arg0: Internal.Predicate_<Internal.ItemStack_>): Internal.Predicate<Internal.ItemStack>;
    negate(): this;
    custom(predicate: Internal.Predicate_<Internal.ItemStack_>): this;
    equipmentSlot(slot: EquipmentSlot_): this;
    hasEnchantment(filter: Internal.ResourceLocationFilter_, min: number, max: number): this;
    hasEnchantment(filter: Internal.ResourceLocationFilter_): this;
    readonly "ALWAYS_TRUE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "HEAD_ARMOR" : ((arg0: Internal.ItemStack) => boolean);
    readonly "ARMOR" : ((arg0: Internal.ItemStack) => boolean);
    readonly "SWORD" : ((arg0: Internal.ItemStack) => boolean);
    readonly "BLOCK" : ((arg0: Internal.ItemStack) => boolean);
    readonly "ALWAYS_FALSE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "HAS_TIER" : ((arg0: Internal.ItemStack) => boolean);
    readonly "LEGS_ARMOR" : ((arg0: Internal.ItemStack) => boolean);
    readonly "PROJECTILE_WEAPON" : ((arg0: Internal.ItemStack) => boolean);
    readonly "DAMAGEABLE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "AXE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "FEET_ARMOR" : ((arg0: Internal.ItemStack) => boolean);
    readonly "POTION" : ((arg0: Internal.ItemStack) => boolean);
    readonly "CHEST_ARMOR" : ((arg0: Internal.ItemStack) => boolean);
    readonly "PICKAXE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "DAMAGED" : ((arg0: Internal.ItemStack) => boolean);
    readonly "WEAPON" : ((arg0: Internal.ItemStack) => boolean);
    readonly "ENCHANTABLE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "ENCHANTED" : ((arg0: Internal.ItemStack) => boolean);
    readonly "SHOVEL" : ((arg0: Internal.ItemStack) => boolean);
    readonly "HOE" : ((arg0: Internal.ItemStack) => boolean);
    readonly "TOOL" : ((arg0: Internal.ItemStack) => boolean);
    readonly "FOOD" : ((arg0: Internal.ItemStack) => boolean);
}
type ItemFilter_ = ((arg0: Internal.ItemStack) => boolean) | ItemFilter;
declare const ItemFilter: ItemFilter;
/**
* @javaClass dev.latvian.mods.kubejs.bindings.IngredientWrapper
*/
declare class Ingredient {
    static customNBT(in_: Internal.IngredientJS_, predicate: Internal.Predicate_<Internal.CompoundTag_>): Internal.IngredientJS;
    static getAll(): Internal.IngredientJS;
    static matchAny(objects: any): Internal.IngredientJS;
    static isIngredient(o: any): boolean;
    static custom(in_: Internal.IngredientJS_, predicate: Internal.Predicate_<Internal.ItemStackJS_>): Internal.IngredientJS;
    static custom(predicate: Internal.Predicate_<Internal.ItemStackJS_>): Internal.IngredientJS;
    /**
    */
    static of(object: Internal.IngredientJS_, count: number): Internal.IngredientJS;
    /**
    */
    static of(object: Internal.IngredientJS_): Internal.IngredientJS;
    static registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    static getNone(): Internal.IngredientJS;
    get all(): Internal.IngredientJS;
    get none(): Internal.IngredientJS;
    constructor();
}
/**
*/
type Ingredient_ = Ingredient;
/**
* @javaClass dev.latvian.mods.kubejs.util.JsonIO
*/
declare class JsonIO {
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static toPrimitive(element: Internal.JsonElement_): any;
    static read(path: Internal.Path_): Internal.MapJS;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    static parse(string: string): any;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static of(o: any): Internal.JsonElement;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parseRaw(string: string): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static toString(json: Internal.JsonElement_): string;
    static toObject(json: Internal.JsonElement_): any;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonElement_): void;
    constructor();
}
type JsonIO_ = JsonIO;
/**
* @javaClass net.minecraft.class_2741
*/
declare class BlockProperties {
    static readonly "MAX_RESPAWN_ANCHOR_CHARGES" : 4;
    static readonly "BAMBOO_LEAVES" : Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly "HANGING" : Internal.BooleanProperty;
    static readonly "WEST_WALL" : Internal.EnumProperty<Internal.WallSide>;
    static readonly "BOTTOM" : Internal.BooleanProperty;
    static readonly "EYE" : Internal.BooleanProperty;
    static readonly "HALF" : Internal.EnumProperty<Internal.Half>;
    static readonly "DRAG" : Internal.BooleanProperty;
    static readonly "MAX_ROTATIONS_16" : 15;
    static readonly "SOUTH" : Internal.BooleanProperty;
    static readonly "MIN_RESPAWN_ANCHOR_CHARGES" : 0;
    static readonly "DISTANCE" : Internal.IntegerProperty;
    static readonly "LOCKED" : Internal.BooleanProperty;
    static readonly "EXTENDED" : Internal.BooleanProperty;
    static readonly "SCULK_SENSOR_PHASE" : Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly "LEVEL" : Internal.IntegerProperty;
    static readonly "DOOR_HINGE" : Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly "STAIRS_SHAPE" : Internal.EnumProperty<Internal.StairsShape>;
    static readonly "EGGS" : Internal.IntegerProperty;
    static readonly "LAYERS" : Internal.IntegerProperty;
    static readonly "CONDITIONAL" : Internal.BooleanProperty;
    static readonly "EAST_WALL" : Internal.EnumProperty<Internal.WallSide>;
    static readonly "HATCH" : Internal.IntegerProperty;
    static readonly "ORIENTATION" : Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly "LEVEL_CAULDRON" : Internal.IntegerProperty;
    static readonly "RAIL_SHAPE_STRAIGHT" : Internal.EnumProperty<Internal.RailShape>;
    static readonly "SIGNAL_FIRE" : Internal.BooleanProperty;
    static readonly "STRUCTUREBLOCK_MODE" : Internal.EnumProperty<Internal.StructureMode>;
    static readonly "PISTON_TYPE" : Internal.EnumProperty<Internal.PistonType>;
    static readonly "MIN_LEVEL" : 0;
    static readonly "HAS_BOOK" : Internal.BooleanProperty;
    static readonly "ATTACH_FACE" : Internal.EnumProperty<Internal.AttachFace>;
    static readonly "WATERLOGGED" : Internal.BooleanProperty;
    static readonly "FALLING" : Internal.BooleanProperty;
    static readonly "AGE_25" : Internal.IntegerProperty;
    static readonly "TRIGGERED" : Internal.BooleanProperty;
    static readonly "MAX_LEVEL_8" : 8;
    static readonly "UNSTABLE" : Internal.BooleanProperty;
    static readonly "CHEST_TYPE" : Internal.EnumProperty<Internal.ChestType>;
    static readonly "AGE_5" : Internal.IntegerProperty;
    static readonly "SOUTH_WALL" : Internal.EnumProperty<Internal.WallSide>;
    static readonly "AGE_7" : Internal.IntegerProperty;
    static readonly "STABILITY_MAX_DISTANCE" : 7;
    static readonly "BELL_ATTACHMENT" : Internal.EnumProperty<Internal.BellAttachType>;
    static readonly "AGE_1" : Internal.IntegerProperty;
    static readonly "MAX_LEVEL_3" : 3;
    static readonly "ATTACHED" : Internal.BooleanProperty;
    static readonly "AGE_3" : Internal.IntegerProperty;
    static readonly "STAGE" : Internal.IntegerProperty;
    static readonly "AGE_2" : Internal.IntegerProperty;
    static readonly "POWER" : Internal.IntegerProperty;
    static readonly "MAX_DISTANCE" : 7;
    static readonly "HAS_BOTTLE_1" : Internal.BooleanProperty;
    static readonly "HAS_BOTTLE_0" : Internal.BooleanProperty;
    static readonly "PICKLES" : Internal.IntegerProperty;
    static readonly "HAS_BOTTLE_2" : Internal.BooleanProperty;
    static readonly "OPEN" : Internal.BooleanProperty;
    static readonly "DRIPSTONE_THICKNESS" : Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly "AGE_15" : Internal.IntegerProperty;
    static readonly "LEVEL_HONEY" : Internal.IntegerProperty;
    static readonly "CANDLES" : Internal.IntegerProperty;
    static readonly "LEVEL_COMPOSTER" : Internal.IntegerProperty;
    static readonly "LIT" : Internal.BooleanProperty;
    static readonly "EAST_REDSTONE" : Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly "OCCUPIED" : Internal.BooleanProperty;
    static readonly "MODE_COMPARATOR" : Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly "NORTH_REDSTONE" : Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly "IN_WALL" : Internal.BooleanProperty;
    static readonly "SNOWY" : Internal.BooleanProperty;
    static readonly "DOWN" : Internal.BooleanProperty;
    static readonly "WEST" : Internal.BooleanProperty;
    static readonly "NORTH_WALL" : Internal.EnumProperty<Internal.WallSide>;
    static readonly "MIN_LEVEL_CAULDRON" : 1;
    static readonly "BED_PART" : Internal.EnumProperty<Internal.BedPart>;
    static readonly "NORTH" : Internal.BooleanProperty;
    static readonly "LEVEL_FLOWING" : Internal.IntegerProperty;
    static readonly "TILT" : Internal.EnumProperty<Internal.Tilt>;
    static readonly "UP" : Internal.BooleanProperty;
    static readonly "SOUTH_REDSTONE" : Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly "MAX_AGE_15" : 15;
    static readonly "HORIZONTAL_FACING" : Internal.DirectionProperty;
    static readonly "BITES" : Internal.IntegerProperty;
    static readonly "SLAB_TYPE" : Internal.EnumProperty<Internal.SlabType>;
    static readonly "MAX_AGE_2" : 2;
    static readonly "MAX_AGE_1" : 1;
    static readonly "ROTATION_16" : Internal.IntegerProperty;
    static readonly "MAX_AGE_7" : 7;
    static readonly "STABILITY_DISTANCE" : Internal.IntegerProperty;
    static readonly "MAX_AGE_5" : 5;
    static readonly "MAX_AGE_3" : 3;
    static readonly "MAX_AGE_25" : 25;
    static readonly "DELAY" : Internal.IntegerProperty;
    static readonly "AXIS" : Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly "MAX_LEVEL_15" : 15;
    static readonly "HORIZONTAL_AXIS" : Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly "RAIL_SHAPE" : Internal.EnumProperty<Internal.RailShape>;
    static readonly "MOISTURE" : Internal.IntegerProperty;
    static readonly "VERTICAL_DIRECTION" : Internal.DirectionProperty;
    static readonly "DOUBLE_BLOCK_HALF" : Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly "NOTE" : Internal.IntegerProperty;
    static readonly "BERRIES" : Internal.BooleanProperty;
    static readonly "RESPAWN_ANCHOR_CHARGES" : Internal.IntegerProperty;
    static readonly "EAST" : Internal.BooleanProperty;
    static readonly "PERSISTENT" : Internal.BooleanProperty;
    static readonly "HAS_RECORD" : Internal.BooleanProperty;
    static readonly "FACING_HOPPER" : Internal.DirectionProperty;
    static readonly "NOTEBLOCK_INSTRUMENT" : Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly "POWERED" : Internal.BooleanProperty;
    static readonly "SHORT" : Internal.BooleanProperty;
    static readonly "VINE_END" : Internal.BooleanProperty;
    static readonly "WEST_REDSTONE" : Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly "ENABLED" : Internal.BooleanProperty;
    static readonly "INVERTED" : Internal.BooleanProperty;
    static readonly "FACING" : Internal.DirectionProperty;
    static readonly "DISARMED" : Internal.BooleanProperty;
    constructor();
}
type BlockProperties_ = BlockProperties;
/**
* @javaClass dev.latvian.mods.rhino.mod.wrapper.AABBWrapper
*/
declare interface AABB {
    ofBlock(pos: BlockPos_): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofSize(vec3: Vec3_, x: number, y: number, z: number): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    wrap(o: any): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    readonly "CUBE" : Internal.AABB;
    readonly "EMPTY" : Internal.AABB;
}
type AABB_ = AABB;
declare const AABB: AABB;
/**
* @javaClass dev.latvian.mods.kubejs.bindings.UtilsWrapper
*/
declare interface Utils {
    getRegistries(): typeof Internal.KubeJSRegistries;
    getSystemTime(): number;
    getRegistry(id: ResourceLocation_): Internal.Registrar<any>;
    listOrSelf(o: any): Internal.ListJS;
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    parseDouble(object: any, def: number): number;
    emptyList<T>(): Internal.List<T>;
    getRandom(): Internal.Random;
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    emptyMap<K, V>(): Internal.Map<K, V>;
    copy(o: any): any;
    id(namespace: string, path: string): ResourceLocation;
    id(id: ResourceLocation_): ResourceLocation;
    listOf(o: any): Internal.ListJS;
    rollChestLoot(id: ResourceLocation_): Internal.ListJS;
    rollChestLoot(id: ResourceLocation_, entity: Internal.EntityJS_): Internal.ListJS;
    getServer(): Internal.ServerJS;
    newCountingMap(): Internal.CountingMap;
    createConsole(name: string): Internal.ConsoleJS;
    newMap(): Internal.MapJS;
    newList(): Internal.ListJS;
    getClientLevel(): Internal.LevelJS;
    getRegistryIds(id: ResourceLocation_): Internal.Collection<ResourceLocation>;
    parseInt(object: any, def: number): number;
    getLevel(level: Internal.Level_): Internal.LevelJS;
    isWrapped(o: any): boolean;
    regex(s: any): Internal.Pattern;
    regex(pattern: string, flags: number): Internal.Pattern;
    newRandom(seed: number): Internal.Random;
    queueIO(runnable: Internal.Runnable_): void;
    toTitleCase(s: string): string;
    mapOf(o: any): Internal.MapJS;
    getSound(id: ResourceLocation_): Internal.SoundEvent;
}
type Utils_ = Utils;
declare const Utils: Utils;
/**
* @javaClass dev.latvian.mods.rhino.mod.wrapper.DirectionWrapper
*/
declare interface Facing {
    readonly "ALL" : {"east":Internal.Direction,"south":Internal.Direction,"north":Internal.Direction,"west":Internal.Direction,"up":Internal.Direction,"down":Internal.Direction};
    readonly "DOWN" : Internal.Direction;
    readonly "south" : Internal.Direction;
    readonly "north" : Internal.Direction;
    readonly "WEST" : Internal.Direction;
    readonly "down" : Internal.Direction;
    readonly "east" : Internal.Direction;
    readonly "NORTH" : Internal.Direction;
    readonly "west" : Internal.Direction;
    readonly "up" : Internal.Direction;
    readonly "UP" : Internal.Direction;
    readonly "SOUTH" : Internal.Direction;
    readonly "EAST" : Internal.Direction;
}
type Facing_ = Facing;
declare const Facing: Facing;
/**
* @javaClass net.minecraft.class_2382
*/
declare class Vec3i implements Internal.Comparable<Vec3i> {
    static offsetCodec($$0: number): Internal.Codec<Vec3i>;
    setY($$0: number): this;
    setX($$0: number): this;
    south($$0: number): this;
    south(): this;
    north(): this;
    north($$0: number): this;
    compareTo($$0: Vec3i_): number;
    setZ($$0: number): this;
    closerToCenterThan($$0: Internal.Position_, $$1: number): boolean;
    east($$0: number): this;
    east(): this;
    toShortString(): string;
    distManhattan($$0: Vec3i_): number;
    hashCode(): number;
    get($$0: Internal.Direction$Axis_): number;
    west(): this;
    west($$0: number): this;
    above(): this;
    above($$0: number): this;
    multiply($$0: number): this;
    offset($$0: number, $$1: number, $$2: number): this;
    offset($$0: Vec3i_): this;
    below($$0: number): this;
    below(): this;
    closerThan($$0: Vec3i_, $$1: number): boolean;
    subtract($$0: Vec3i_): this;
    distSqr($$0: Vec3i_): number;
    cross($$0: Vec3i_): this;
    distToLowCornerSqr($$0: number, $$1: number, $$2: number): number;
    distToCenterSqr($$0: number, $$1: number, $$2: number): number;
    distToCenterSqr($$0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    getZ(): number;
    equals($$0: any): boolean;
    toString(): string;
    relative($$0: Internal.Direction_, $$1: number): this;
    relative($$0: Internal.Direction$Axis_, $$1: number): this;
    relative($$0: Internal.Direction_): this;
    static readonly "ZERO" : Vec3i;
    static readonly "CODEC" : Internal.Codec<Vec3i>;
    get x(): number;
    get y(): number;
    get z(): number;
    set x($$0: number);
    set y($$0: number);
    set z($$0: number);
    constructor($$0: number, $$1: number, $$2: number);
    constructor($$0: number, $$1: number, $$2: number);
}
type Vec3i_ = Vec3i;
/**
* @javaClass dev.latvian.mods.rhino.mod.util.NBTUtils
*/
declare interface NBT {
    byteArrayTag(v: number[]): net.minecraft.nbt.Tag;
    fromTag(t: net.minecraft.nbt.Tag_): any;
    listTag(): net.minecraft.nbt.Tag;
    listTag(list: Internal.List_<any>): net.minecraft.nbt.Tag;
    toTagCompound(v: any): Internal.CompoundTag;
    compoundTag(): net.minecraft.nbt.Tag;
    compoundTag(map: Internal.Map_<any, any>): net.minecraft.nbt.Tag;
    isTagCompound(o: any): boolean;
    toTag(v: any): net.minecraft.nbt.Tag;
    floatTag(v: number): net.minecraft.nbt.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    toTagList(list: any): Internal.ListTag;
    ia(v: number[]): net.minecraft.nbt.Tag;
    intTag(v: number): net.minecraft.nbt.Tag;
    byteTag(v: number): net.minecraft.nbt.Tag;
    longArrayTag(v: number[]): net.minecraft.nbt.Tag;
    b(v: number): net.minecraft.nbt.Tag;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    d(v: number): net.minecraft.nbt.Tag;
    f(v: number): net.minecraft.nbt.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    i(v: number): net.minecraft.nbt.Tag;
    shortTag(v: number): net.minecraft.nbt.Tag;
    l(v: number): net.minecraft.nbt.Tag;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    s(v: number): net.minecraft.nbt.Tag;
    la(v: number[]): net.minecraft.nbt.Tag;
    isTagCollection(o: any): boolean;
    longTag(v: number): net.minecraft.nbt.Tag;
    intArrayTag(v: number[]): net.minecraft.nbt.Tag;
    doubleTag(v: number): net.minecraft.nbt.Tag;
    stringTag(v: string): net.minecraft.nbt.Tag;
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, net.minecraft.nbt.Tag>;
    ba(v: number[]): net.minecraft.nbt.Tag;
    readonly "COMPOUND_TYPE" : Internal.TagType<Internal.OrderedCompoundTag>;
    readonly "VALUE_UNWRAPPER" : ((arg0: Internal.SharedContextData, arg1: Internal.Scriptable, arg2: any) => any);
    readonly "LIST_TYPE" : Internal.TagType<Internal.ListTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
/**
* @javaClass dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper
*/
declare interface UUID {
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    toString(id: Internal.UUID_): string;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
* @javaClass dev.latvian.mods.kubejs.bindings.BlockWrapper
*/
declare class Block {
    static getMaterial(): Internal.Map<string, Internal.MaterialJS>;
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    static getBlock(id: ResourceLocation_): Internal.Block;
    static custom(predicate: dev.latvian.mods.kubejs.block.predicate.BlockPredicate_): dev.latvian.mods.kubejs.block.predicate.BlockPredicate;
    static getTypeList(): Internal.List<string>;
    static getFacing(): Internal.Map<string, Internal.Direction>;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    get material(): Internal.Map<string, Internal.MaterialJS>;
    get typeList(): Internal.List<string>;
    get facing(): Internal.Map<string, Internal.Direction>;
    constructor();
}
type Block_ = Block;
/**
* @javaClass dev.latvian.mods.kubejs.bindings.ComponentWrapper
*/
declare class Component {
    static green(text: any): Internal.MutableComponent;
    static prettyPrintNbt(tag: net.minecraft.nbt.Tag_): net.minecraft.network.chat.Component;
    static string(text: string): Internal.MutableComponent;
    static darkGreen(text: any): Internal.MutableComponent;
    static clickEventOf(o: any): Internal.ClickEvent;
    static lightPurple(text: any): Internal.MutableComponent;
    static yellow(text: any): Internal.MutableComponent;
    static black(text: any): Internal.MutableComponent;
    static darkBlue(text: any): Internal.MutableComponent;
    /**
    */
    static translate(key: Special.LangKey): Internal.MutableComponent;
    /**
    */
    static translate(key: Special.LangKey, ...objects: any[]): Internal.MutableComponent;
    static darkAqua(text: any): Internal.MutableComponent;
    static gold(text: any): Internal.MutableComponent;
    static red(text: any): Internal.MutableComponent;
    static aqua(text: any): Internal.MutableComponent;
    static gray(text: any): Internal.MutableComponent;
    static white(text: any): Internal.MutableComponent;
    static blue(text: any): Internal.MutableComponent;
    static darkRed(text: any): Internal.MutableComponent;
    static keybind(keybind: string): Internal.MutableComponent;
    static of(o: any): Internal.MutableComponent;
    static darkGray(text: any): Internal.MutableComponent;
    static darkPurple(text: any): Internal.MutableComponent;
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component_>): Internal.MutableComponent;
    constructor();
}
/**
*/
type Component_ = Component;
/**
* @javaClass dev.latvian.mods.kubejs.util.NBTIOWrapper
*/
declare interface NBTIO {
    read(path: Internal.Path_): Internal.CompoundTag;
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
/**
* @javaClass net.minecraft.class_2893$class_2895
*/
declare class DecorationGenerationStep extends Internal.Enum<DecorationGenerationStep> {
    static valueOf($$0: string): DecorationGenerationStep;
    static values(): DecorationGenerationStep[];
    static readonly "RAW_GENERATION" : DecorationGenerationStep;
    static readonly "UNDERGROUND_STRUCTURES" : DecorationGenerationStep;
    static readonly "LOCAL_MODIFICATIONS" : DecorationGenerationStep;
    static readonly "TOP_LAYER_MODIFICATION" : DecorationGenerationStep;
    static readonly "UNDERGROUND_DECORATION" : DecorationGenerationStep;
    static readonly "LAKES" : DecorationGenerationStep;
    static readonly "SURFACE_STRUCTURES" : DecorationGenerationStep;
    static readonly "STRONGHOLDS" : DecorationGenerationStep;
    static readonly "FLUID_SPRINGS" : DecorationGenerationStep;
    static readonly "VEGETAL_DECORATION" : DecorationGenerationStep;
    static readonly "UNDERGROUND_ORES" : DecorationGenerationStep;
}
type DecorationGenerationStep_ = "strongholds" | "underground_ores" | "underground_structures" | "top_layer_modification" | "fluid_springs" | "underground_decoration" | "raw_generation" | "lakes" | "vegetal_decoration" | "local_modifications" | "surface_structures" | DecorationGenerationStep;
/**
* @javaClass net.minecraft.class_243
*/
declare class Vec3 implements Internal.Position {
    static directionFromRotation($$0: number, $$1: number): Vec3;
    static directionFromRotation($$0: Internal.Vec2_): Vec3;
    zRot($$0: number): this;
    lerp($$0: Vec3_, $$1: number): this;
    static upFromBottomCenterOf($$0: Vec3i_, $$1: number): Vec3;
    static fromRGB24($$0: number): Vec3;
    dot($$0: Vec3_): number;
    xRot($$0: number): this;
    scale($$0: number): this;
    align($$0: Internal.EnumSet_<Internal.Direction$Axis_>): this;
    method_10215(): number;
    distanceToSqr($$0: Vec3_): number;
    distanceToSqr($$0: number, $$1: number, $$2: number): number;
    method_10214(): number;
    method_10216(): number;
    horizontalDistanceSqr(): number;
    hashCode(): number;
    get($$0: Internal.Direction$Axis_): number;
    normalize(): this;
    multiply($$0: number, $$1: number, $$2: number): this;
    multiply($$0: Vec3_): this;
    static atLowerCornerOf($$0: Vec3i_): Vec3;
    add($$0: number, $$1: number, $$2: number): this;
    add($$0: Vec3_): this;
    yRot($$0: number): this;
    subtract($$0: Vec3_): this;
    subtract($$0: number, $$1: number, $$2: number): this;
    closerThan($$0: Internal.Position_, $$1: number): boolean;
    cross($$0: Vec3_): this;
    length(): number;
    horizontalDistance(): number;
    reverse(): this;
    distanceTo($$0: Vec3_): number;
    with($$0: Internal.Direction$Axis_, $$1: number): this;
    lengthSqr(): number;
    equals($$0: any): boolean;
    vectorTo($$0: Vec3_): this;
    toString(): string;
    static atCenterOf($$0: Vec3i_): Vec3;
    static atBottomCenterOf($$0: Vec3i_): Vec3;
    static readonly "ZERO" : Vec3;
    readonly "x" : number;
    readonly "y" : number;
    readonly "z" : number;
    constructor($$0: Internal.Vector3f);
    constructor($$0: number, $$1: number, $$2: number);
}
type Vec3_ = Vec3;
/**
* @javaClass java.lang.Math
*/
declare class JavaMath {
    static multiplyFull(arg0: number, arg1: number): number;
    static copySign(arg0: number, arg1: number): number;
    static log1p(arg0: number): number;
    static expm1(arg0: number): number;
    static cos(arg0: number): number;
    static rint(arg0: number): number;
    static atan(arg0: number): number;
    static ceilDiv(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static ceilDivExact(arg0: number, arg1: number): number;
    static decrementExact(arg0: number): number;
    static absExact(arg0: number): number;
    static exp(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static tan(arg0: number): number;
    static floorDivExact(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static acos(arg0: number): number;
    static ceil(arg0: number): number;
    static divideExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static log10(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static random(): number;
    static tanh(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static sin(arg0: number): number;
    static unsignedMultiplyHigh(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static ceilMod(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static toIntExact(arg0: number): number;
    static nextDown(arg0: number): number;
    static toRadians(arg0: number): number;
    static cosh(arg0: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static round(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static asin(arg0: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static readonly "E" : 2.718281828459045;
    static readonly "PI" : 3.141592653589793;
}
type JavaMath_ = JavaMath;
/**
* @javaClass dev.latvian.mods.kubejs.fluid.FluidWrapper
*/
declare class Fluid {
    static lava(): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static getEmpty(): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    static getTypes(): Internal.List<string>;
    static water(): Internal.FluidStackJS;
    static water(amount: number): Internal.FluidStackJS;
    static readonly "LAVA_ID" : ResourceLocation;
    static readonly "WATER_ID" : ResourceLocation;
    get types(): Internal.List<string>;
    get empty(): Internal.FluidStackJS;
    constructor();
}
type Fluid_ = Fluid;
/**
* @javaClass com.almostreliable.lootjs.kube.LootEntryWrapper
*/
declare class LootEntry {
    static of(in_: Internal.ItemStackJS_, count: number, nbt: Internal.CompoundTag_): Internal.LootEntry;
    static of(in_: Internal.ItemStackJS_, nbt: Internal.CompoundTag_): Internal.LootEntry;
    static of(in_: Internal.ItemStackJS_, count: number): Internal.LootEntry;
    static of(o: any): Internal.LootEntry;
    static withChance(o: any, chance: number): Internal.LootEntry;
    constructor();
}
type LootEntry_ = LootEntry;
/**
* @javaClass dev.latvian.mods.rhino.mod.wrapper.ColorWrapper
*/
declare interface Color {
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "BLUE_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "GOLD" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "GRAY" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "MAGENTA_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "BLUE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "DARK_AQUA" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "TEXT" : {"dark_red":Internal.ChatFormatting,"green":Internal.ChatFormatting,"underline":Internal.ChatFormatting,"dark_green":Internal.ChatFormatting,"black":Internal.ChatFormatting,"yellow":Internal.ChatFormatting,"bold":Internal.ChatFormatting,"italic":Internal.ChatFormatting,"dark_blue":Internal.ChatFormatting,"dark_purple":Internal.ChatFormatting,"gold":Internal.ChatFormatting,"red":Internal.ChatFormatting,"aqua":Internal.ChatFormatting,"gray":Internal.ChatFormatting,"light_purple":Internal.ChatFormatting,"blue":Internal.ChatFormatting,"white":Internal.ChatFormatting,"dark_aqua":Internal.ChatFormatting,"dark_gray":Internal.ChatFormatting,"reset":Internal.ChatFormatting,"strikethrough":Internal.ChatFormatting,"obfuscated":Internal.ChatFormatting};
    readonly "DYE" : {"magenta":Internal.DyeColor,"pink":Internal.DyeColor,"green":Internal.DyeColor,"lime":Internal.DyeColor,"light_gray":Internal.DyeColor,"yellow":Internal.DyeColor,"black":Internal.DyeColor,"light_blue":Internal.DyeColor,"brown":Internal.DyeColor,"cyan":Internal.DyeColor,"orange":Internal.DyeColor,"red":Internal.DyeColor,"gray":Internal.DyeColor,"white":Internal.DyeColor,"blue":Internal.DyeColor,"purple":Internal.DyeColor};
    readonly "WHITE_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "DARK_RED" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "LIGHT_PURPLE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "BROWN_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "BLACK" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "GRAY_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "NONE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "LIGHT_BLUE_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "AQUA" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "WHITE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "LIGHT_GRAY_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "BLACK_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "RED_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "PURPLE_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "GREEN_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "PINK_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "DARK_BLUE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "GREEN" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "CYAN_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "RED" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "DARK_PURPLE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "ORANGE_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "YELLOW_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "DARK_GREEN" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "YELLOW" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "LIME_DYE" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "DARK_GRAY" : dev.latvian.mods.rhino.mod.util.color.Color;
    readonly "MAP" : {"":Internal.NoColor,"light_blue_dye":Internal.DyeColor,"BLUE_DYE":Internal.DyeColor,"purple_dye":Internal.DyeColor,"dark_red":Internal.NoColor,"lightGrayDye":Internal.DyeColor,"DARK_AQUA":Internal.NoColor,"none":Internal.NoColor,"green_dye":Internal.DyeColor,"blackDye":Internal.DyeColor,"dark_blue":Internal.NoColor,"red":Internal.NoColor,"pink_dye":Internal.DyeColor,"aqua":Internal.NoColor,"white":Internal.NoColor,"WHITE_DYE":Internal.DyeColor,"dark_gray":Internal.NoColor,"LIGHT_PURPLE":Internal.NoColor,"BROWN_DYE":Internal.DyeColor,"BLACK":Internal.NoColor,"darkPurple":Internal.NoColor,"NONE":Internal.NoColor,"LIGHT_BLUE_DYE":Internal.DyeColor,"AQUA":Internal.NoColor,"lightBlueDye":Internal.DyeColor,"limeDye":Internal.DyeColor,"PURPLE_DYE":Internal.DyeColor,"GREEN_DYE":Internal.DyeColor,"magenta_dye":Internal.DyeColor,"-":Internal.NoColor,"lime_dye":Internal.DyeColor,"yellowDye":Internal.DyeColor,"grayDye":Internal.DyeColor,"purpleDye":Internal.DyeColor,"DARK_PURPLE":Internal.NoColor,"ORANGE_DYE":Internal.DyeColor,"darkGray":Internal.NoColor,"brownDye":Internal.DyeColor,"YELLOW":Internal.NoColor,"LIME_DYE":Internal.DyeColor,"blueDye":Internal.DyeColor,"white_dye":Internal.DyeColor,"pinkDye":Internal.DyeColor,"blue_dye":Internal.DyeColor,"cyanDye":Internal.DyeColor,"GOLD":Internal.NoColor,"GRAY":Internal.NoColor,"MAGENTA_DYE":Internal.DyeColor,"BLUE":Internal.NoColor,"yellow":Internal.NoColor,"darkBlue":Internal.NoColor,"transparent":Internal.NoColor,"orange_dye":Internal.DyeColor,"red_dye":Internal.DyeColor,"dark_purple":Internal.NoColor,"gold":Internal.NoColor,"gray":Internal.NoColor,"light_purple":Internal.NoColor,"darkRed":Internal.NoColor,"greenDye":Internal.DyeColor,"DARK_RED":Internal.NoColor,"redDye":Internal.DyeColor,"GRAY_DYE":Internal.DyeColor,"orangeDye":Internal.DyeColor,"yellow_dye":Internal.DyeColor,"black_dye":Internal.DyeColor,"magentaDye":Internal.DyeColor,"WHITE":Internal.NoColor,"green":Internal.NoColor,"LIGHT_GRAY_DYE":Internal.DyeColor,"BLACK_DYE":Internal.DyeColor,"darkGreen":Internal.NoColor,"RED_DYE":Internal.DyeColor,"dark_green":Internal.NoColor,"black":Internal.NoColor,"lightPurple":Internal.NoColor,"PINK_DYE":Internal.DyeColor,"DARK_BLUE":Internal.NoColor,"GREEN":Internal.NoColor,"darkAqua":Internal.NoColor,"gray_dye":Internal.DyeColor,"CYAN_DYE":Internal.DyeColor,"RED":Internal.NoColor,"brown_dye":Internal.DyeColor,"cyan_dye":Internal.DyeColor,"blue":Internal.NoColor,"whiteDye":Internal.DyeColor,"dark_aqua":Internal.NoColor,"YELLOW_DYE":Internal.DyeColor,"DARK_GREEN":Internal.NoColor,"DARK_GRAY":Internal.NoColor};
}
type Color_ = Color;
declare const Color: Color;
/**
* @javaClass com.almostreliable.lootjs.core.LootContextType
*/
declare class LootType extends Internal.Enum<LootType> {
    static valueOf(name: string): LootType;
    static values(): LootType[];
    static readonly "CHEST" : LootType;
    static readonly "ADVANCEMENT_ENTITY" : LootType;
    static readonly "GIFT" : LootType;
    static readonly "ENTITY" : LootType;
    static readonly "FISHING" : LootType;
    static readonly "PIGLIN_BARTER" : LootType;
    static readonly "BLOCK" : LootType;
    static readonly "UNKNOWN" : LootType;
    static readonly "ADVANCEMENT_REWARD" : LootType;
}
type LootType_ = "gift" | "chest" | "piglin_barter" | "advancement_entity" | "advancement_reward" | "fishing" | "block" | "entity" | "unknown" | LootType;
/**
* @javaClass dev.latvian.mods.kubejs.script.PlatformWrapper
*/
declare class Platform {
    static isDevelopmentEnvironment(): boolean;
    static isClientEnvironment(): boolean;
    static getName(): string;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    static getList(): Internal.Set<string>;
    static isForge(): boolean;
    static getModVersion(): string;
    static isLoaded(modId: string): boolean;
    static getMcVersion(): string;
    static isFabric(): boolean;
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    get modVersion(): string;
    get developmentEnvironment(): boolean;
    get forge(): boolean;
    get fabric(): boolean;
    get mcVersion(): string;
    get clientEnvironment(): boolean;
    get name(): string;
    get list(): Internal.Set<string>;
    constructor();
}
type Platform_ = Platform;
/**
* @javaClass net.minecraft.class_2893$class_2894
*/
declare class CarvingGenerationStep extends Internal.Enum<CarvingGenerationStep> implements Internal.StringRepresentable {
    getName(): string;
    static valueOf($$0: string): CarvingGenerationStep;
    static values(): CarvingGenerationStep[];
    method_15434(): string;
    static byName($$0: string): CarvingGenerationStep;
    static readonly "CODEC" : Internal.Codec<CarvingGenerationStep>;
    static readonly "LIQUID" : CarvingGenerationStep;
    static readonly "AIR" : CarvingGenerationStep;
    get name(): string;
}
type CarvingGenerationStep_ = "liquid" | "air" | CarvingGenerationStep;
declare namespace me.lizardofoz.drgflares.mixin {
    /**
    * @javaClass me.lizardofoz.drgflares.mixin.RecipeManagerAccessor
    */
    interface RecipeManagerAccessor {
        setRecipes(arg0: Internal.Map_<Internal.RecipeType_<any>, Internal.Map_<ResourceLocation_, Internal.Recipe_<any>>>): void;
    }
    type RecipeManagerAccessor_ = RecipeManagerAccessor;
}
declare namespace Internal {
    /**
    * @javaClass net.combatroll.client.RollManager$CooldownInfo
    */
    class RollManager$CooldownInfo extends Internal.Record {
        elapsed(): number;
        total(): number;
        hashCode(): number;
        availableRolls(): number;
        equals(o: any): boolean;
        toString(): string;
        maxRolls(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(elapsed: number, total: number, availableRolls: number, maxRolls: number);
    }
    type RollManager$CooldownInfo_ = RollManager$CooldownInfo;
    /**
    * @javaClass net.minecraft.class_3272
    */
    class PackMetadataSection {
        getPackFormat(): number;
        getDescription(): net.minecraft.network.chat.Component;
        static readonly "SERIALIZER" : Internal.PackMetadataSectionSerializer;
        get packFormat(): number;
        get description(): net.minecraft.network.chat.Component;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: net.minecraft.network.chat.Component, $$1: number);
    }
    type PackMetadataSection_ = PackMetadataSection;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.QuestObjectType
    */
    class QuestObjectType extends Internal.Enum<Internal.QuestObjectType> implements Internal.Predicate<Internal.QuestObjectBase> {
        or(arg0: Internal.Predicate_<Internal.QuestObjectBase_>): Internal.Predicate<Internal.QuestObjectBase>;
        test(object: Internal.QuestObjectBase_): boolean;
        and(arg0: Internal.Predicate_<Internal.QuestObjectBase_>): Internal.Predicate<Internal.QuestObjectBase>;
        negate(): Internal.Predicate<Internal.QuestObjectBase>;
        static valueOf(name: string): Internal.QuestObjectType;
        static values(): Internal.QuestObjectType[];
        getColor(): Internal.ChatFormatting;
        static readonly "TASK" : Internal.QuestObjectType;
        static readonly "ALL_PROGRESSING_OR_NULL" : ((arg0: Internal.QuestObjectBase) => boolean);
        static readonly "NULL" : Internal.QuestObjectType;
        readonly "translationKey" : string;
        static readonly "NAME_MAP" : Internal.NameMap<Internal.QuestObjectType>;
        static readonly "REWARD" : Internal.QuestObjectType;
        static readonly "ALL_PROGRESSING" : ((arg0: Internal.QuestObjectBase) => boolean);
        static readonly "CHAPTER" : Internal.QuestObjectType;
        static readonly "CHAPTER_GROUP" : Internal.QuestObjectType;
        readonly "id" : string;
        static readonly "FILE" : Internal.QuestObjectType;
        static readonly "REWARD_TABLE" : Internal.QuestObjectType;
        static readonly "QUEST" : Internal.QuestObjectType;
        get color(): Internal.ChatFormatting;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type QuestObjectType_ = "reward" | "chapter" | "chapter_group" | "file" | "task" | "null" | "reward_table" | "quest" | QuestObjectType;
    /**
    * @javaClass net.minecraft.class_6375
    */
    interface LerpingModel {
        getModelRotationValues(): Internal.Map<string, Internal.Vector3f>;
    }
    type LerpingModel_ = LerpingModel;
    /**
    * @javaClass com.mojang.serialization.DynamicLike
    */
    abstract class DynamicLike <T> {
        createIntList(arg0: Internal.IntStream_): Internal.Dynamic<any>;
        createLong(arg0: number): Internal.Dynamic<T>;
        createDouble(arg0: number): Internal.Dynamic<T>;
        getElementGeneric(arg0: T, arg1: T): T;
        getElementGeneric(arg0: T): Internal.DataResult<T>;
        asLongStreamOpt(): Internal.DataResult<Internal.LongStream>;
        createLongList(arg0: Internal.LongStream_): Internal.Dynamic<any>;
        readMap<K, V>(arg0: Internal.Decoder_<K>, arg1: Internal.Decoder_<V>): Internal.DataResult<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        readMap<K, V>(arg0: Internal.Decoder_<K>, arg1: Internal.Function_<K, Internal.Decoder_<V>>): Internal.DataResult<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        readMap<R>(arg0: Internal.DataResult_<R>, arg1: Internal.Function3_<R, Internal.Dynamic_<T>, Internal.Dynamic_<T>, Internal.DataResult_<R>>): Internal.DataResult<R>;
        asListOpt<U>(arg0: Internal.Function_<Internal.Dynamic_<T>, U>): Internal.DataResult<Internal.List<U>>;
        createShort(arg0: number): Internal.Dynamic<T>;
        asStreamOpt(): Internal.DataResult<Internal.Stream<Internal.Dynamic<T>>>;
        asMap<K, V>(arg0: Internal.Function_<Internal.Dynamic_<T>, K>, arg1: Internal.Function_<Internal.Dynamic_<T>, V>): Internal.Map<K, V>;
        createByteList(arg0: Internal.ByteBuffer_): Internal.Dynamic<any>;
        asIntStream(): Internal.IntStream;
        asByteBuffer(): Internal.ByteBuffer;
        asFloat(arg0: number): number;
        decode<A>(arg0: Internal.Decoder_<A>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        asIntStreamOpt(): Internal.DataResult<Internal.IntStream>;
        asLongStream(): Internal.LongStream;
        createBoolean(arg0: boolean): Internal.Dynamic<T>;
        asList<U>(arg0: Internal.Function_<Internal.Dynamic_<T>, U>): Internal.List<U>;
        asInt(arg0: number): number;
        readList<E>(arg0: Internal.Decoder_<E>): Internal.DataResult<Internal.List<E>>;
        readList<E>(arg0: Internal.Function_<Internal.Dynamic_<any>, Internal.DataResult_<E>>): Internal.DataResult<Internal.List<E>>;
        emptyList(): Internal.Dynamic<T>;
        asShort(arg0: number): number;
        get(arg0: string): Internal.OptionalDynamic<T>;
        emptyMap(): Internal.Dynamic<T>;
        createNumeric(arg0: Internal.Number_): Internal.Dynamic<T>;
        asString(): Internal.DataResult<string>;
        asString(arg0: string): string;
        asByte(arg0: number): number;
        createList(arg0: Internal.Stream_<Internal.Dynamic_<any>>): Internal.Dynamic<T>;
        asByteBufferOpt(): Internal.DataResult<Internal.ByteBuffer>;
        read<A>(arg0: Internal.Decoder_<A>): Internal.DataResult<A>;
        getGeneric(arg0: T): Internal.DataResult<T>;
        asNumber(): Internal.DataResult<Internal.Number>;
        asNumber(arg0: Internal.Number_): Internal.Number;
        asMapOpt<K, V>(arg0: Internal.Function_<Internal.Dynamic_<T>, K>, arg1: Internal.Function_<Internal.Dynamic_<T>, V>): Internal.DataResult<Internal.Map<K, V>>;
        asMapOpt(): Internal.DataResult<Internal.Stream<com.mojang.datafixers.util.Pair<Internal.Dynamic<T>, Internal.Dynamic<T>>>>;
        createString(arg0: string): Internal.Dynamic<T>;
        asStream(): Internal.Stream<Internal.Dynamic<T>>;
        createMap(arg0: Internal.Map_<Internal.Dynamic_<any>, Internal.Dynamic_<any>>): Internal.Dynamic<T>;
        createByte(arg0: number): Internal.Dynamic<T>;
        createFloat(arg0: number): Internal.Dynamic<T>;
        asLong(arg0: number): number;
        getOps(): Internal.DynamicOps<T>;
        getElement(arg0: string, arg1: T): T;
        getElement(arg0: string): Internal.DataResult<T>;
        asDouble(arg0: number): number;
        createInt(arg0: number): Internal.Dynamic<T>;
        asBoolean(arg0: boolean): boolean;
        get ops(): Internal.DynamicOps<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.DynamicOps<T>);
    }
    type DynamicLike_<T> = DynamicLike<T>;
    /**
    * @javaClass it.unimi.dsi.fastutil.doubles.DoubleSpliterator
    */
    interface DoubleSpliterator extends Internal.Spliterator$OfDouble {
        trySplit(): this;
        tryAdvance(arg0: Internal.Consumer_<number>): boolean;
        tryAdvance(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): boolean;
        getComparator(): Internal.DoubleComparator;
        getExactSizeIfKnown(): number;
        skip(arg0: number): number;
        hasCharacteristics(arg0: number): boolean;
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
    }
    type DoubleSpliterator_ = DoubleSpliterator;
    /**
    * @javaClass dev.ftb.mods.ftbteams.property.TeamPropertyValue
    */
    class TeamPropertyValue <T> {
        toString(): string;
        copy(): Internal.TeamPropertyValue<T>;
        "value" : T;
        readonly "key" : Internal.TeamProperty<T>;
        "consumer" : ((arg0: T) => void);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(k: Internal.TeamProperty<T>, v: T);
        constructor(k: Internal.TeamProperty<T>);
    }
    type TeamPropertyValue_<T> = TeamPropertyValue<T>;
    /**
    * @javaClass com.google.gson.internal.Excluder
    */
    class Excluder implements Internal.TypeAdapterFactory, Internal.Cloneable {
        withExclusionStrategy(arg0: Internal.ExclusionStrategy_, arg1: boolean, arg2: boolean): this;
        disableInnerClassSerialization(): this;
        withModifiers(...arg0: number[]): this;
        create<T>(arg0: Internal.Gson_, arg1: com.google.gson.reflect.TypeToken_<T>): Internal.TypeAdapter<T>;
        withVersion(arg0: number): this;
        excludeClass(arg0: Internal.Class_<any>, arg1: boolean): boolean;
        excludeField(arg0: Internal.Field_, arg1: boolean): boolean;
        excludeFieldsWithoutExposeAnnotation(): this;
        static readonly "DEFAULT" : Internal.Excluder;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type Excluder_ = Excluder;
    /**
    * @javaClass net.minecraft.class_6850
    */
    class RenderRegionCache {
        createRegion($$0: Internal.Level_, $$1: BlockPos_, $$2: BlockPos_, $$3: number): Internal.RenderChunkRegion;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type RenderRegionCache_ = RenderRegionCache;
    /**
    * @javaClass dev.latvian.mods.unit.MutableNumberUnit
    */
    class MutableNumberUnit extends dev.latvian.mods.unit.Unit {
        set(value: number): void;
        get(variables: Internal.UnitVariables_): number;
        toString(builder: Internal.StringBuilder_): void;
        "value" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(value: number);
    }
    type MutableNumberUnit_ = MutableNumberUnit;
    /**
    * @javaClass net.minecraft.class_6584
    */
    class SurfaceRelativeThresholdFilter extends Internal.PlacementFilter {
        static of($$0: Internal.Heightmap$Types_, $$1: number, $$2: number): Internal.SurfaceRelativeThresholdFilter;
        method_39615(): Internal.PlacementModifierType<any>;
        static readonly "CODEC" : Internal.Codec<Internal.SurfaceRelativeThresholdFilter>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type SurfaceRelativeThresholdFilter_ = SurfaceRelativeThresholdFilter;
    /**
    * @javaClass java.lang.module.ModuleDescriptor$Exports$Modifier
    */
    class ModuleDescriptor$Exports$Modifier extends Internal.Enum<Internal.ModuleDescriptor$Exports$Modifier> {
        static valueOf(arg0: string): Internal.ModuleDescriptor$Exports$Modifier;
        static values(): Internal.ModuleDescriptor$Exports$Modifier[];
        static readonly "SYNTHETIC" : Internal.ModuleDescriptor$Exports$Modifier;
        static readonly "MANDATED" : Internal.ModuleDescriptor$Exports$Modifier;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ModuleDescriptor$Exports$Modifier_ = "synthetic" | "mandated" | ModuleDescriptor$Exports$Modifier;
    /**
    * @javaClass net.minecraft.class_1959
    */
    class Biome implements net.blay09.mods.balm.mixin.BiomeAccessor, Internal.BiomeAccessor, Internal.AccessorBiome, Internal.BiomeFTBC, net.id.incubus_core.mixin.world.BiomeAccessor, dev.itsmeow.whisperwoods.imdlib.mixin.BiomeAccessor {
        shouldFreeze($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: boolean): boolean;
        shouldFreeze($$0: Internal.LevelReader_, $$1: BlockPos_): boolean;
        getFoliageColor(): number;
        shouldSnowGolemBurn($$0: BlockPos_): boolean;
        getAmbientLoop(): Internal.Optional<Internal.SoundEvent>;
        getBackgroundMusic(): Internal.Optional<Internal.Music>;
        isHumid(): boolean;
        shouldSnow($$0: Internal.LevelReader_, $$1: BlockPos_): boolean;
        getFTBCBiomeColorIndex(): number;
        getMobSettings(): Internal.MobSpawnSettings;
        getHeightAdjustedTemperature($$0: BlockPos_): number;
        getAmbientMood(): Internal.Optional<Internal.AmbientMoodSettings>;
        warmEnoughToRain($$0: BlockPos_): boolean;
        getWaterColor(): number;
        getBaseTemperature(): number;
        getDownfall(): number;
        getSkyColor(): number;
        setFTBCBiomeColorIndex(c: number): void;
        getAmbientAdditions(): Internal.Optional<Internal.AmbientAdditionsSettings>;
        getGrassColor($$0: number, $$1: number): number;
        getGenerationSettings(): Internal.BiomeGenerationSettings;
        getAmbientParticle(): Internal.Optional<Internal.AmbientParticleSettings>;
        getFogColor(): number;
        getSpecialEffects(): Internal.BiomeSpecialEffects;
        static getBiomeCategory($$0: Internal.Holder_<Internal.Biome_>): Internal.Biome$BiomeCategory;
        getBiomeCategory(): Internal.Biome$BiomeCategory;
        shouldMeltFrozenOceanIcebergSlightly($$0: BlockPos_): boolean;
        getTemperature($$0: BlockPos_): number;
        getWaterFogColor(): number;
        coldEnoughToSnow($$0: BlockPos_): boolean;
        getPrecipitation(): Internal.Biome$Precipitation;
        readonly "climateSettings" : Internal.Biome$ClimateSettings;
        static readonly "CODEC" : Internal.Codec<Internal.Holder<Internal.Biome>>;
        static readonly "NETWORK_CODEC" : Internal.Codec<Internal.Biome>;
        static readonly "BIOME_INFO_NOISE" : Internal.PerlinSimplexNoise;
        readonly "mobSettings" : Internal.MobSpawnSettings;
        static readonly "DIRECT_CODEC" : Internal.Codec<Internal.Biome>;
        static readonly "LIST_CODEC" : Internal.Codec<Internal.HolderSet<Internal.Biome>>;
        readonly "generationSettings" : Internal.BiomeGenerationSettings;
        static readonly "TEMPERATURE_NOISE" : Internal.PerlinSimplexNoise;
        "biomeCategory" : Internal.Biome$BiomeCategory;
        get ambientAdditions(): Internal.Optional<Internal.AmbientAdditionsSettings>;
        get skyColor(): number;
        get ambientMood(): Internal.Optional<Internal.AmbientMoodSettings>;
        get waterFogColor(): number;
        get ambientParticle(): Internal.Optional<Internal.AmbientParticleSettings>;
        get fTBCBiomeColorIndex(): number;
        get downfall(): number;
        get humid(): boolean;
        get ambientLoop(): Internal.Optional<Internal.SoundEvent>;
        get backgroundMusic(): Internal.Optional<Internal.Music>;
        get waterColor(): number;
        get precipitation(): Internal.Biome$Precipitation;
        get baseTemperature(): number;
        get fogColor(): number;
        get specialEffects(): Internal.BiomeSpecialEffects;
        get foliageColor(): number;
        set fTBCBiomeColorIndex(c: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Biome_ = Special.Biome | Biome;
    /**
    * @javaClass net.minecraft.class_2494
    */
    class FloatTag extends Internal.NumericTag {
        method_39850($$0: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        static valueOf($$0: number): Internal.FloatTag;
        getAsString(): string;
        method_23258(): Internal.TagType<Internal.FloatTag>;
        method_32289($$0: Internal.TagVisitor_): void;
        method_10699(): number;
        method_10698(): number;
        method_10701(): number;
        method_10711(): number;
        method_10700(): number;
        method_10713($$0: Internal.DataOutput_): void;
        method_10702(): Internal.Number;
        hashCode(): number;
        equals($$0: any): boolean;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        copy(): this;
        method_10697(): number;
        method_10696(): number;
        static readonly "ZERO" : Internal.FloatTag;
        static readonly "TYPE" : Internal.TagType<Internal.FloatTag>;
        get asString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FloatTag_ = FloatTag;
    /**
    * @javaClass net.minecraft.class_3924
    */
    class CampfireBlockEntity extends Internal.BlockEntity implements Internal.Clearable {
        method_5448(): void;
        placeFood($$0: Internal.ItemStack_, $$1: number): boolean;
        getCookableRecipe($$0: Internal.ItemStack_): Internal.Optional<Internal.CampfireCookingRecipe>;
        dowse(): void;
        static cooldownTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.CampfireBlockEntity_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        getItems(): Internal.NonNullList<Internal.ItemStack>;
        invalidateCaps(): void;
        static cookTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.CampfireBlockEntity_): void;
        method_16887(): Internal.CompoundTag;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_11014($$0: Internal.CompoundTag_): void;
        static particleTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.CampfireBlockEntity_): void;
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket;
        get items(): Internal.NonNullList<Internal.ItemStack>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.BlockState);
    }
    type CampfireBlockEntity_ = CampfireBlockEntity;
    /**
    * @javaClass net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents$AllowKeyPress
    */
    interface ScreenKeyboardEvents$AllowKeyPress {
        allowKeyPress(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): boolean;
    }
    type ScreenKeyboardEvents$AllowKeyPress_ = ((arg0: Internal.Screen, arg1: number, arg2: number, arg3: number) => boolean) | ScreenKeyboardEvents$AllowKeyPress;
    /**
    * @javaClass net.minecraft.class_6904
    */
    class WorldStem extends Internal.Record implements Internal.AutoCloseable {
        registryAccess(): Internal.RegistryAccess$Frozen;
        static load($$0: Internal.WorldStem$InitConfig_, $$1: Internal.WorldStem$DataPackConfigSupplier_, $$2: Internal.WorldStem$WorldDataSupplier_, $$3: Internal.Executor_, $$4: Internal.Executor_): Internal.CompletableFuture<Internal.WorldStem>;
        hashCode(): number;
        equals($$0: any): boolean;
        worldData(): Internal.WorldData;
        updateGlobals(): void;
        toString(): string;
        dataPackResources(): Internal.ReloadableServerResources;
        close(): void;
        resourceManager(): Internal.CloseableResourceManager;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: (() => void), $$1: Internal.ReloadableServerResources, $$2: Internal.RegistryAccess$Frozen, $$3: Internal.WorldData);
    }
    type WorldStem_ = WorldStem;
    /**
    * @javaClass net.minecraft.class_163
    */
    class AdvancementList {
        add($$0: Internal.Map_<ResourceLocation_, Internal.Advancement$Builder_>): void;
        getRoots(): Internal.Iterable<Internal.Advancement>;
        getAllAdvancements(): Internal.Collection<Internal.Advancement>;
        get($$0: ResourceLocation_): Internal.Advancement;
        clear(): void;
        setListener($$0: Internal.AdvancementList$Listener_): void;
        remove($$0: Internal.Set_<ResourceLocation_>): void;
        get allAdvancements(): Internal.Collection<Internal.Advancement>;
        get roots(): Internal.Iterable<Internal.Advancement>;
        set listener($$0: Internal.AdvancementList$Listener_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AdvancementList_ = AdvancementList;
    /**
    * @javaClass net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder$Living
    */
    class FabricEntityTypeBuilder$Living <T> extends Internal.FabricEntityTypeBuilder<T> {
        trackable(trackRangeBlocks: number, trackedUpdateRate: number, forceTrackedVelocityUpdates: boolean): Internal.FabricEntityTypeBuilder$Living<T>;
        trackable(trackRangeBlocks: number, trackedUpdateRate: number): Internal.FabricEntityTypeBuilder$Living<T>;
        disableSummon(): Internal.FabricEntityTypeBuilder$Living<T>;
        trackedUpdateRate(rate: number): Internal.FabricEntityTypeBuilder$Living<T>;
        spawnableFarFromPlayer(): Internal.FabricEntityTypeBuilder$Living<T>;
        specificSpawnBlocks(...blocks: Internal.Block_[]): Internal.FabricEntityTypeBuilder$Living<T>;
        defaultAttributes(defaultAttributeBuilder: Internal.Supplier_<Internal.AttributeSupplier$Builder_>): Internal.FabricEntityTypeBuilder$Living<T>;
        forceTrackedVelocityUpdates(forceTrackedVelocityUpdates: boolean): Internal.FabricEntityTypeBuilder$Living<T>;
        trackRangeChunks(range: number): Internal.FabricEntityTypeBuilder$Living<T>;
        trackRangeBlocks(range: number): Internal.FabricEntityTypeBuilder$Living<T>;
        fireImmune(): Internal.FabricEntityTypeBuilder$Living<T>;
        disableSaving(): Internal.FabricEntityTypeBuilder$Living<T>;
        build(): Internal.EntityType<T>;
        entityFactory<N>(factory: Internal.EntityType$EntityFactory_<N>): Internal.FabricEntityTypeBuilder$Living<N>;
        spawnGroup(group: Internal.MobCategory_): Internal.FabricEntityTypeBuilder$Living<T>;
        dimensions(dimensions: Internal.EntityDimensions_): Internal.FabricEntityTypeBuilder$Living<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FabricEntityTypeBuilder$Living_<T> = FabricEntityTypeBuilder$Living<T>;
    /**
    * @javaClass net.minecraft.class_3619
    */
    class PushReaction extends Internal.Enum<Internal.PushReaction> {
        static valueOf($$0: string): Internal.PushReaction;
        static values(): Internal.PushReaction[];
        static readonly "DESTROY" : Internal.PushReaction;
        static readonly "BLOCK" : Internal.PushReaction;
        static readonly "PUSH_ONLY" : Internal.PushReaction;
        static readonly "IGNORE" : Internal.PushReaction;
        static readonly "NORMAL" : Internal.PushReaction;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type PushReaction_ = "normal" | "destroy" | "ignore" | "block" | "push_only" | PushReaction;
    /**
    * @javaClass net.minecraft.class_3137
    */
    class RandomBooleanFeatureConfiguration implements Internal.FeatureConfiguration {
        method_30649(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        static readonly "CODEC" : Internal.Codec<Internal.RandomBooleanFeatureConfiguration>;
        readonly "featureTrue" : Internal.Holder<Internal.PlacedFeature>;
        readonly "featureFalse" : Internal.Holder<Internal.PlacedFeature>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Holder<Internal.PlacedFeature>, $$1: Internal.Holder<Internal.PlacedFeature>);
    }
    type RandomBooleanFeatureConfiguration_ = RandomBooleanFeatureConfiguration;
    /**
    * @javaClass net.minecraft.class_1259$class_1261
    */
    class BossEvent$BossBarOverlay extends Internal.Enum<Internal.BossEvent$BossBarOverlay> {
        getName(): string;
        static valueOf($$0: string): Internal.BossEvent$BossBarOverlay;
        static values(): Internal.BossEvent$BossBarOverlay[];
        static byName($$0: string): Internal.BossEvent$BossBarOverlay;
        static readonly "NOTCHED_6" : Internal.BossEvent$BossBarOverlay;
        static readonly "NOTCHED_12" : Internal.BossEvent$BossBarOverlay;
        static readonly "PROGRESS" : Internal.BossEvent$BossBarOverlay;
        static readonly "NOTCHED_20" : Internal.BossEvent$BossBarOverlay;
        static readonly "NOTCHED_10" : Internal.BossEvent$BossBarOverlay;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BossEvent$BossBarOverlay_ = "notched_20" | "notched_10" | "progress" | "notched_6" | "notched_12" | BossEvent$BossBarOverlay;
    /**
    * @javaClass net.minecraft.class_6333
    */
    class BiasedToBottomInt extends Internal.IntProvider {
        method_35012(): Internal.IntProviderType<any>;
        static of($$0: number, $$1: number): Internal.BiasedToBottomInt;
        method_35011(): number;
        toString(): string;
        method_35009(): number;
        method_35008($$0: Internal.Random_): number;
        static readonly "CODEC" : Internal.Codec<Internal.BiasedToBottomInt>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BiasedToBottomInt_ = BiasedToBottomInt;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.RecordItemJS$Builder
    */
    class RecordItemJS$Builder extends Internal.ItemBuilder {
        analogOutput(o: number): this;
        /**
        */
        song(s: Internal.SoundEvent_): this;
        createObject(): Internal.Item;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    /**
    */
    type RecordItemJS$Builder_ = RecordItemJS$Builder;
    /**
    * @javaClass snownee.lychee.mixin.LootContextBuilderAccess
    */
    interface LootContextBuilderAccess {
        getRandom(): Internal.Random;
        getParams(): Internal.Map<Internal.LootContextParam<any>, any>;
    }
    type LootContextBuilderAccess_ = LootContextBuilderAccess;
    /**
    * @javaClass com.mojang.datafixers.types.families.TypeFamily
    */
    interface TypeFamily {
        familyOptic<A, B>(arg0: Internal.IntFunction_<Internal.OpticParts_<A, B>>): Internal.FamilyOptic<A, B>;
        apply(arg0: number): com.mojang.datafixers.types.Type<any>;
    }
    type TypeFamily_ = TypeFamily;
    /**
    * @javaClass me.jellysquid.mods.sodium.client.render.texture.SpriteExtended
    */
    interface SpriteExtended {
        setActive(arg0: boolean): void;
        isActive(): boolean;
    }
    type SpriteExtended_ = SpriteExtended;
    /**
    * @javaClass net.minecraft.class_2497
    */
    class IntTag extends Internal.NumericTag {
        method_39850($$0: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        static valueOf($$0: number): Internal.IntTag;
        getAsString(): string;
        method_23258(): Internal.TagType<Internal.IntTag>;
        method_32289($$0: Internal.TagVisitor_): void;
        method_10699(): number;
        method_10698(): number;
        method_10701(): number;
        method_10711(): number;
        method_10700(): number;
        method_10713($$0: Internal.DataOutput_): void;
        method_10702(): Internal.Number;
        hashCode(): number;
        equals($$0: any): boolean;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        copy(): this;
        method_10697(): number;
        method_10696(): number;
        static readonly "TYPE" : Internal.TagType<Internal.IntTag>;
        get asString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type IntTag_ = IntTag;
    /**
    * @javaClass me.jellysquid.mods.sodium.client.util.frustum.FrustumAdapter
    */
    interface FrustumAdapter {
        adapt(frustum: Internal.Frustum_): me.jellysquid.mods.sodium.client.util.frustum.Frustum;
        sodium$createFrustum(): me.jellysquid.mods.sodium.client.util.frustum.Frustum;
    }
    type FrustumAdapter_ = FrustumAdapter;
    /**
    * @javaClass it.unimi.dsi.fastutil.longs.LongSet
    */
    interface LongSet extends Internal.LongCollection, Internal.Set<number> {
        add(arg0: number): boolean;
        longSpliterator(): Internal.LongSpliterator;
        longIterator(): Internal.LongIterator;
        toLongArray(arg0: number[]): number[];
        spliterator(): Internal.LongSpliterator;
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: Internal.LongConsumer_): void;
        forEach(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        remove(arg0: number): boolean;
        remove(arg0: any): boolean;
        longParallelStream(): Internal.LongStream;
        removeIf(arg0: Internal.LongPredicate_): boolean;
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.longs.LongPredicate_): boolean;
        contains(arg0: any): boolean;
        iterator(): Internal.LongIterator;
        stream(): Internal.Stream<number>;
        of(arg0: number, arg1: number): this;
        of(): this;
        of(...arg0: number[]): this;
        of(arg0: number): this;
        of(arg0: number, arg1: number, arg2: number): this;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        longStream(): Internal.LongStream;
        parallelStream(): Internal.Stream<number>;
        rem(arg0: number): boolean;
    }
    type LongSet_ = LongSet;
    /**
    * @javaClass net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents$BeforeKeyPress
    */
    interface ScreenKeyboardEvents$BeforeKeyPress {
        beforeKeyPress(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
    }
    type ScreenKeyboardEvents$BeforeKeyPress_ = ((arg0: Internal.Screen, arg1: number, arg2: number, arg3: number) => void) | ScreenKeyboardEvents$BeforeKeyPress;
    /**
    * @javaClass dev.tr7zw.exordium.access.SignBufferHolder
    */
    interface SignBufferHolder {
        renderBuffered(arg0: Internal.PoseStack_, arg1: Internal.MultiBufferSource_, arg2: number): boolean;
    }
    type SignBufferHolder_ = SignBufferHolder;
    /**
    * @javaClass java.awt.event.HierarchyListener
    */
    interface HierarchyListener extends Internal.EventListener {
        hierarchyChanged(arg0: Internal.HierarchyEvent_): void;
    }
    type HierarchyListener_ = HierarchyListener;
    /**
    * @javaClass net.minecraft.class_4067
    */
    class ProgressOption extends Internal.Option {
        toValue($$0: number): number;
        toPct($$0: number): number;
        setMaxValue($$0: number): void;
        getMinValue(): number;
        method_18520($$0: Internal.Options_, $$1: number, $$2: number, $$3: number): Internal.AbstractWidget;
        set($$0: Internal.Options_, $$1: number): void;
        getMaxValue(): number;
        get($$0: Internal.Options_): number;
        getMessage($$0: Internal.Options_): net.minecraft.network.chat.Component;
        get minValue(): number;
        get maxValue(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: number, $$2: number, $$3: number, $$4: ((arg0: Internal.Options) => number), $$5: ((arg0: Internal.Options, arg1: number) => void), $$6: ((arg0: Internal.Options, arg1: Internal.ProgressOption) => net.minecraft.network.chat.Component), $$7: ((arg0: Internal.Minecraft) => Internal.List<Internal.FormattedCharSequence>));
        constructor($$0: string, $$1: number, $$2: number, $$3: number, $$4: ((arg0: Internal.Options) => number), $$5: ((arg0: Internal.Options, arg1: number) => void), $$6: ((arg0: Internal.Options, arg1: Internal.ProgressOption) => net.minecraft.network.chat.Component));
    }
    type ProgressOption_ = ProgressOption;
    /**
    * @javaClass net.coderbot.iris.mixin.texture.TextureAtlasSpriteAccessor
    */
    interface TextureAtlasSpriteAccessor {
        getMainImage(): Internal.NativeImage[];
        getX(): number;
        getY(): number;
    }
    type TextureAtlasSpriteAccessor_ = TextureAtlasSpriteAccessor;
    /**
    * @javaClass net.minecraft.class_5761
    */
    interface Bucketable {
        loadDefaultDataFromBucketTag($$0: Internal.Mob_, $$1: Internal.CompoundTag_): void;
        getBucketItemStack(): Internal.ItemStack;
        fromBucket(): boolean;
        saveToBucketTag(arg0: Internal.ItemStack_): void;
        saveDefaultDataToBucketTag($$0: Internal.Mob_, $$1: Internal.ItemStack_): void;
        getPickupSound(): Internal.SoundEvent;
        setFromBucket(arg0: boolean): void;
        loadFromBucketTag(arg0: Internal.CompoundTag_): void;
        bucketMobPickup<T>($$0: Internal.Player_, $$1: Hand_, $$2: T): Internal.Optional<Internal.InteractionResult>;
    }
    type Bucketable_ = Bucketable;
    /**
    * @javaClass java.math.MathContext
    */
    class MathContext implements Internal.Serializable {
        getRoundingMode(): Internal.RoundingMode;
        hashCode(): number;
        equals(arg0: any): boolean;
        toString(): string;
        getPrecision(): number;
        static readonly "DECIMAL128" : Internal.MathContext;
        static readonly "DECIMAL64" : Internal.MathContext;
        static readonly "DECIMAL32" : Internal.MathContext;
        static readonly "UNLIMITED" : Internal.MathContext;
        get roundingMode(): Internal.RoundingMode;
        get precision(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: string);
        constructor(arg0: number, arg1: Internal.RoundingMode);
        constructor(arg0: number);
    }
    type MathContext_ = MathContext;
    /**
    * @javaClass net.minecraft.class_5483$class_1964
    */
    class MobSpawnSettings$SpawnerData extends Internal.WeightedEntry$IntrusiveBase {
        toString(): string;
        static readonly "CODEC" : Internal.Codec<Internal.MobSpawnSettings$SpawnerData>;
        readonly "minCount" : number;
        readonly "type" : Internal.EntityType<any>;
        readonly "maxCount" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<any>, $$1: number, $$2: number, $$3: number);
        constructor($$0: Internal.EntityType<any>, $$1: Internal.Weight, $$2: number, $$3: number);
    }
    type MobSpawnSettings$SpawnerData_ = MobSpawnSettings$SpawnerData;
    /**
    * @javaClass vazkii.patchouli.mixin.client.AccessorClientAdvancements
    */
    interface AccessorClientAdvancements {
        getProgress(): Internal.Map<Internal.Advancement, Internal.AdvancementProgress>;
    }
    type AccessorClientAdvancements_ = AccessorClientAdvancements;
    /**
    * @javaClass java.lang.constant.MethodTypeDesc
    */
    interface MethodTypeDesc extends Internal.ConstantDesc, Internal.TypeDescriptor$OfMethod<Internal.ClassDesc, Internal.MethodTypeDesc> {
        parameterType(arg0: number): Internal.ClassDesc;
        dropParameterTypes(arg0: number, arg1: number): this;
        parameterCount(): number;
        changeReturnType(arg0: Internal.ClassDesc_): this;
        descriptorString(): string;
        insertParameterTypes(arg0: number, ...arg1: Internal.ClassDesc_[]): this;
        changeParameterType(arg0: number, arg1: Internal.ClassDesc_): this;
        parameterArray(): Internal.ClassDesc[];
        of(arg0: Internal.ClassDesc_, ...arg1: Internal.ClassDesc_[]): this;
        equals(arg0: any): boolean;
        parameterList(): Internal.List<Internal.ClassDesc>;
        ofDescriptor(arg0: string): this;
        displayDescriptor(): string;
        returnType(): Internal.ClassDesc;
    }
    type MethodTypeDesc_ = MethodTypeDesc;
    /**
    * @javaClass com.telepathicgrunt.repurposedstructures.mixin.entities.ShulkerEntityInvoker
    */
    interface ShulkerEntityInvoker {
        repurposedstructures_callSetAttachFace(arg0: Internal.Direction_): void;
    }
    type ShulkerEntityInvoker_ = ShulkerEntityInvoker;
    /**
    * @javaClass java.awt.Insets
    */
    class Insets implements Internal.Cloneable, Internal.Serializable {
        set(arg0: number, arg1: number, arg2: number, arg3: number): void;
        hashCode(): number;
        equals(arg0: any): boolean;
        clone(): any;
        toString(): string;
        "top" : number;
        "left" : number;
        "bottom" : number;
        "right" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: number, arg1: number, arg2: number, arg3: number);
    }
    type Insets_ = Insets;
    /**
    * @javaClass net.minecraft.class_3441
    */
    class ServerRecipeBook extends Internal.RecipeBook {
        toNbt(): Internal.CompoundTag;
        fromNbt($$0: Internal.CompoundTag_, $$1: Internal.RecipeManager_): void;
        addRecipes($$0: Internal.Collection_<Internal.Recipe_<any>>, $$1: Internal.ServerPlayer_): number;
        removeRecipes($$0: Internal.Collection_<Internal.Recipe_<any>>, $$1: Internal.ServerPlayer_): number;
        sendInitialRecipeBook($$0: Internal.ServerPlayer_): void;
        static readonly "RECIPE_BOOK_TAG" : "recipeBook";
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ServerRecipeBook_ = ServerRecipeBook;
    /**
    * @javaClass net.minecraft.class_1678
    */
    class ShulkerBullet extends Internal.Projectile {
        method_5634(): Internal.SoundSource;
        method_5718(): number;
        getStepHeight(): number;
        method_5809(): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        method_31471($$0: Internal.ClientboundAddEntityPacket_): void;
        method_5640($$0: number): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        method_5863(): boolean;
        alwaysAccepts(): boolean;
        method_5773(): void;
        method_5982(): void;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.ShulkerBullet>, $$1: Internal.Level);
        constructor($$0: Internal.Level, $$1: Internal.LivingEntity, $$2: Internal.Entity, $$3: Internal.Direction$Axis);
    }
    type ShulkerBullet_ = ShulkerBullet;
    /**
    * @javaClass com.telepathicgrunt.the_bumblezone.mixin.blocks.FlowingFluidAccessor
    */
    interface FlowingFluidAccessor {
        thebumblezone_callSourceNeighborCount(arg0: Internal.LevelReader_, arg1: BlockPos_): number;
        thebumblezone_callCanPassThroughWall(arg0: Internal.Direction_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_, arg5: Internal.BlockState_): boolean;
        thebumblezone_callSpreadToSides(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.FluidState_, arg3: Internal.BlockState_): void;
    }
    type FlowingFluidAccessor_ = FlowingFluidAccessor;
    /**
    * @javaClass com.google.common.collect.Multiset
    */
    interface Multiset <E> extends Internal.Collection<E> {
        add(arg0: E, arg1: number): number;
        add(arg0: E): boolean;
        forEachEntry(arg0: Internal.ObjIntConsumer_<E>): void;
        entrySet(): Internal.Set<Internal.Multiset$Entry<E>>;
        spliterator(): Internal.Spliterator<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        count(arg0: any): number;
        remove(arg0: any, arg1: number): number;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        contains(arg0: any): boolean;
        iterator(): Internal.Iterator<E>;
        size(): number;
        stream(): Internal.Stream<E>;
        elementSet(): Internal.Set<E>;
        hashCode(): number;
        equals(arg0: any): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<E>;
        toString(): string;
        setCount(arg0: E, arg1: number, arg2: number): boolean;
        setCount(arg0: E, arg1: number): number;
        retainAll(arg0: Internal.Collection_<any>): boolean;
    }
    type Multiset_<E> = Multiset<E>;
    /**
    * @javaClass ladysnake.satin.api.experimental.ReadableDepthFramebuffer
    */
    interface ReadableDepthFramebuffer {
        getStillDepthMap(): number;
        freezeDepthMap(): void;
    }
    type ReadableDepthFramebuffer_ = ReadableDepthFramebuffer;
    /**
    * @javaClass xaero.common.mods.SupportXaeroWorldmap
    */
    class SupportXaeroWorldmap {
        getWorldMapIgnoreHeightmaps(): boolean;
        tryToGetMultiworldId(dimId: Internal.ResourceKey_<Internal.Level_>): string;
        getPotentialMultiworldIds(dimId: Internal.ResourceKey_<Internal.Level_>): Internal.List<string>;
        getClaimsOpacity(): number;
        tryToGetMultiworldName(dimId: Internal.ResourceKey_<Internal.Level_>, multiworldId: string): string;
        getWorldMapColours(): number;
        getDisplayClaims(): boolean;
        registerHighlighters(highlighterRegistry: xaero.common.minimap.highlight.HighlighterRegistry_): void;
        getWorldMapBiomeColorsVanillaMode(): boolean;
        getWorldMapLighting(): boolean;
        getAdjustHeightForCarpetLikeBlocks(): boolean;
        worldMapIsRenderingRadar(): boolean;
        toggleChunkClaims(): void;
        drawMinimap(minimapSession: Internal.XaeroMinimapSession_, matrixStack: Internal.PoseStack_, helper: Internal.MinimapRendererHelper_, xFloored: number, zFloored: number, minViewX: number, minViewZ: number, maxViewX: number, maxViewZ: number, zooming: boolean, zoom: number, overlayBufferBuilder: Internal.VertexConsumer_, multiTextureRenderTypeRenderers: Internal.MultiTextureRenderTypeRendererProvider_): void;
        screenShouldSkipWorldRender(screen: Internal.Screen_): boolean;
        getMinimapBrightness(): number;
        createRadarRenderWrapper(radarRenderer: Internal.RadarRenderer_): void;
        getWorldMapWaypoints(): boolean;
        getWorldMapTerrainDepth(): boolean;
        openSettings(): void;
        prepareMapTexturedRect(matrix: Internal.Matrix4f_, x: number, y: number, textureX: number, textureY: number, width: number, height: number, chunk: Internal.MapTileChunk_, noLightRenderer: Internal.MultiTextureRenderTypeRenderer_, withLightrenderer: Internal.MultiTextureRenderTypeRenderer_, helper: Internal.MinimapRendererHelper_): void;
        getWorldMapTerrainSlopes(): number;
        getWorldMapFlowers(): boolean;
        getMultiworldIds(dimId: Internal.ResourceKey_<Internal.Level_>): Internal.List<string>;
        "compatibilityVersion" : number;
        static "WORLDMAP_COMPATIBILITY_VERSION" : 15;
        static readonly "black" : -16777216;
        static readonly "slime" : -2142047936;
        get worldMapBiomeColorsVanillaMode(): boolean;
        get minimapBrightness(): number;
        get worldMapTerrainSlopes(): number;
        get adjustHeightForCarpetLikeBlocks(): boolean;
        get worldMapIgnoreHeightmaps(): boolean;
        get displayClaims(): boolean;
        get claimsOpacity(): number;
        get worldMapFlowers(): boolean;
        get worldMapWaypoints(): boolean;
        get worldMapColours(): number;
        get worldMapLighting(): boolean;
        get worldMapTerrainDepth(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(modMain: Internal.AXaeroMinimap);
    }
    type SupportXaeroWorldmap_ = SupportXaeroWorldmap;
    /**
    * @javaClass net.minecraft.class_3154
    */
    class ReplaceBlockConfiguration implements Internal.FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        static readonly "CODEC" : Internal.Codec<Internal.ReplaceBlockConfiguration>;
        readonly "targetStates" : Internal.List<Internal.OreConfiguration$TargetBlockState>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockState, $$1: Internal.BlockState);
        constructor($$0: Internal.List<Internal.OreConfiguration$TargetBlockState>);
    }
    type ReplaceBlockConfiguration_ = ReplaceBlockConfiguration;
    /**
    * @javaClass net.minecraft.class_1927
    */
    class Explosion implements Internal.ExplosionHooksImpl$ExplosionExtensions, Internal.ExplosionAccessor {
        architectury_getPosition(): Vec3;
        finalizeExplosion($$0: boolean): void;
        getDamageSource(): Internal.DamageSource;
        explode(): void;
        getToBlow(): Internal.List<BlockPos>;
        redirect$fod000$lychee_getDrops(state: Internal.BlockState_, pBuilder: Internal.LootContext$Builder_): Internal.List<any>;
        getHitPlayers(): Internal.Map<Internal.Player, Vec3>;
        static getSeenPercent($$0: Vec3_, $$1: Internal.Entity_): number;
        handler$gdg000$superBang(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$cka000$Explosion_explode(ci: Internal.CallbackInfo_): void;
        handler$zil000$collectBlocksAndDamageEntitiesMixin(info: Internal.CallbackInfo_, set: Internal.Set_<any>, i: number, q: number, r: number, s: number, t: number, u: number, v: number, w: number, list: Internal.List_<any>): void;
        clearToBlow(): void;
        getSourceMob(): Internal.LivingEntity;
        readonly "level" : Internal.Level;
        readonly "blockInteraction" : Internal.Explosion$BlockInteraction;
        readonly "fire" : boolean;
        "source" : Internal.Entity;
        "radius" : number;
        get toBlow(): Internal.List<BlockPos>;
        get sourceMob(): Internal.LivingEntity;
        get hitPlayers(): Internal.Map<Internal.Player, Vec3>;
        get damageSource(): Internal.DamageSource;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Level, $$1: Internal.Entity, $$2: Internal.DamageSource, $$3: Internal.ExplosionDamageCalculator, $$4: number, $$5: number, $$6: number, $$7: number, $$8: boolean, $$9: Internal.Explosion$BlockInteraction);
        constructor($$0: Internal.Level, $$1: Internal.Entity, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean, $$7: Internal.Explosion$BlockInteraction);
        constructor($$0: Internal.Level, $$1: Internal.Entity, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean, $$7: Internal.Explosion$BlockInteraction, $$8: Internal.List<BlockPos>);
        constructor($$0: Internal.Level, $$1: Internal.Entity, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.List<BlockPos>);
        constructor($$0: Internal.Level, $$1: Internal.Entity, $$2: number, $$3: number, $$4: number, $$5: number);
    }
    type Explosion_ = Explosion;
    /**
    * @javaClass com.github.clevernucleus.dataattributes.api.util.VoidConsumer
    */
    interface VoidConsumer {
        accept(): void;
    }
    type VoidConsumer_ = (() => void) | VoidConsumer;
    /**
    * @javaClass net.minecraft.class_1662
    */
    class StackedContents {
        handler$gep000$onCountCrafts(recipe: Internal.Recipe_<any>, int_1: number, ints: Internal.IntList_, ci: Internal.CallbackInfoReturnable_<any>): void;
        static fromStackingIndex(id: number): Internal.ItemStack;
        accountSimpleStack(stack: Internal.ItemStack_): void;
        static getStackingIndex(stack: Internal.ItemStack_): number;
        getBiggestCraftableStack($$0: Internal.Recipe_<any>, $$1: Internal.IntList_): number;
        getBiggestCraftableStack($$0: Internal.Recipe_<any>, $$1: number, $$2: Internal.IntList_): number;
        clear(): void;
        canCraft($$0: Internal.Recipe_<any>, $$1: Internal.IntList_, $$2: number): boolean;
        canCraft($$0: Internal.Recipe_<any>, $$1: Internal.IntList_): boolean;
        handler$gep000$onFindRecipe(recipe: Internal.Recipe_<any>, ints: Internal.IntList_, int_1: number, ci: Internal.CallbackInfoReturnable_<any>): void;
        accountStack($$0: Internal.ItemStack_): void;
        accountStack($$0: Internal.ItemStack_, $$1: number): void;
        readonly "contents" : Internal.Int2IntMap;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type StackedContents_ = StackedContents;
    /**
    * @javaClass net.fabricmc.fabric.impl.registry.sync.FabricRegistry
    */
    interface FabricRegistry extends Internal.RegistryAttributeHolder {
        build(arg0: Internal.Set_<Internal.RegistryAttribute_>): void;
    }
    type FabricRegistry_ = FabricRegistry;
    /**
    * @javaClass java.lang.Appendable
    */
    interface Appendable {
        append(arg0: Internal.CharSequence_): this;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        append(arg0: string): this;
    }
    type Appendable_ = Appendable;
    /**
    * @javaClass java.nio.file.WatchService
    */
    interface WatchService extends Internal.Closeable {
        take(): Internal.WatchKey;
        poll(arg0: number, arg1: Internal.TimeUnit_): Internal.WatchKey;
        poll(): Internal.WatchKey;
        close(): void;
    }
    type WatchService_ = WatchService;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.SwordItemBuilder
    */
    class SwordItemBuilder extends Internal.HandheldItemBuilder {
        createObject(): Internal.Item;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type SwordItemBuilder_ = SwordItemBuilder;
    /**
    * @javaClass com.jozufozu.flywheel.api.Instancer
    */
    interface Instancer <D> {
        notifyRemoval(): void;
        createInstance(): D;
        createInstances(arr: D[]): void;
        notifyDirty(): void;
        stealInstance(arg0: D): void;
    }
    type Instancer_<D> = Instancer<D>;
    /**
    * @javaClass net.minecraft.class_5762
    */
    class Axolotl extends Internal.Animal implements Internal.LerpingModel, Internal.Bucketable {
        method_5978(): number;
        static onStopAttacking($$0: Internal.Axolotl_): void;
        method_5931($$0: Internal.Player_): boolean;
        method_5613($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): Internal.AgeableMob;
        method_5957($$0: Internal.LevelReader_): boolean;
        rehydrate(): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_33190(): boolean;
        method_35171(): Internal.SoundEvent;
        method_35170($$0: Internal.CompoundTag_): void;
        method_33191($$0: Internal.LivingEntity_): number;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        method_6094(): boolean;
        method_6091($$0: Vec3_): void;
        applySupportingEffects($$0: Internal.Player_): void;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_6453(): boolean;
        method_6454($$0: boolean): void;
        method_6452(): Internal.ItemStack;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        alwaysAccepts(): boolean;
        method_6455($$0: Internal.ItemStack_): void;
        static checkAxolotlSpawnRules($$0: Internal.EntityType_<Internal.LivingEntity_>, $$1: Internal.ServerLevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.Random_): boolean;
        method_17326(): boolean;
        method_5966(): void;
        setPlayingDead($$0: boolean): void;
        isPlayingDead(): boolean;
        method_5986(): number;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getVariant(): Internal.Axolotl$Variant;
        method_5748(): number;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        method_6481($$0: Internal.ItemStack_): boolean;
        method_18868(): Internal.Brain<Internal.Axolotl>;
        method_6046(): Internal.MobType;
        method_5992($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        method_5670(): void;
        method_6121($$0: Internal.Entity_): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_6144($$0: BlockPos_, $$1: Internal.LevelReader_): number;
        thonkutil$getId(): ResourceLocation;
        method_5974($$0: number): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5675(): boolean;
        method_36976(): Internal.Map<string, Internal.Vector3f>;
        static readonly "TOTAL_PLAYDEAD_TIME" : 200;
        static readonly "PLAYER_REGEN_DETECTION_RANGE" : 20.0;
        static readonly "VARIANT_TAG" : "Variant";
        static readonly "RARE_VARIANT_CHANCE" : 1200;
        get playingDead(): boolean;
        get variant(): Internal.Axolotl$Variant;
        get stepHeight(): number;
        set playingDead($$0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Axolotl>, $$1: Internal.Level);
    }
    type Axolotl_ = Axolotl;
    /**
    * @javaClass javax.accessibility.Accessible
    */
    interface Accessible {
        getAccessibleContext(): Internal.AccessibleContext;
    }
    type Accessible_ = Accessible;
    /**
    * @javaClass net.minecraft.class_1282
    */
    class DamageSource implements io.github.fabricators_of_create.porting_lib.mixin.common.accessor.DamageSourceAccessor, artifacts.mixin.accessors.DamageSourceAccessor, Internal.DamageSourceAccessor, Internal.AccessorDamageSource, Internal.DamageSourceInvoker {
        isBypassArmor(): boolean;
        static indirectMagic($$0: Internal.Entity_, $$1: Internal.Entity_): Internal.DamageSource;
        static thorns($$0: Internal.Entity_): Internal.DamageSource;
        static mobAttack($$0: Internal.LivingEntity_): Internal.DamageSource;
        getPlayerKJS(): Internal.PlayerJS<any>;
        static arrow($$0: Internal.AbstractArrow_, $$1: Internal.Entity_): Internal.DamageSource;
        static playerAttack($$0: Internal.Player_): Internal.DamageSource;
        getImmediateKJS(): Internal.EntityJS;
        setScalesWithDifficulty(): this;
        isProjectile(): boolean;
        static fireworks($$0: Internal.FireworkRocketEntity_, $$1: Internal.Entity_): Internal.DamageSource;
        static badRespawnPointExplosion(): Internal.DamageSource;
        bypassArmor(): this;
        setProjectile(): this;
        isBypassMagic(): boolean;
        getMsgId(): string;
        isCreativePlayer(): boolean;
        static fireball($$0: Internal.Fireball_, $$1: Internal.Entity_): Internal.DamageSource;
        setNoAggro(): this;
        isFire(): boolean;
        getActualKJS(): Internal.EntityJS;
        static trident($$0: Internal.Entity_, $$1: Internal.Entity_): Internal.DamageSource;
        static witherSkull($$0: Internal.WitherSkull_, $$1: Internal.Entity_): Internal.DamageSource;
        isFall(): boolean;
        bypassInvul(): this;
        setIsFall(): this;
        static thrown($$0: Internal.Entity_, $$1: Internal.Entity_): Internal.DamageSource;
        isBypassInvul(): boolean;
        isExplosion(): boolean;
        static sting($$0: Internal.LivingEntity_): Internal.DamageSource;
        isDamageHelmet(): boolean;
        scalesWithDifficulty(): boolean;
        setIsFire(): this;
        damageHelmet(): this;
        static explosion($$0: Internal.LivingEntity_): Internal.DamageSource;
        static explosion($$0: Internal.Explosion_): Internal.DamageSource;
        setMagic(): this;
        isMagic(): boolean;
        setExplosion(): this;
        static indirectMobAttack($$0: Internal.Entity_, $$1: Internal.LivingEntity_): Internal.DamageSource;
        getFoodExhaustion(): number;
        toString(): string;
        getLocalizedDeathMessage($$0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
        isNoAggro(): boolean;
        getSourcePosition(): Vec3;
        bypassMagic(): this;
        static readonly "IN_WALL" : Internal.DamageSource;
        static readonly "FREEZE" : Internal.DamageSource;
        static readonly "LAVA" : Internal.DamageSource;
        static readonly "OUT_OF_WORLD" : Internal.DamageSource;
        static readonly "CRAMMING" : Internal.DamageSource;
        readonly "msgId" : string;
        static readonly "IN_FIRE" : Internal.DamageSource;
        static readonly "WITHER" : Internal.DamageSource;
        static readonly "ANVIL" : Internal.DamageSource;
        static readonly "LIGHTNING_BOLT" : Internal.DamageSource;
        static readonly "MAGIC" : Internal.DamageSource;
        static readonly "ON_FIRE" : Internal.DamageSource;
        static readonly "FALL" : Internal.DamageSource;
        static readonly "DRY_OUT" : Internal.DamageSource;
        static readonly "DRAGON_BREATH" : Internal.DamageSource;
        static readonly "STARVE" : Internal.DamageSource;
        static readonly "CACTUS" : Internal.DamageSource;
        static readonly "FALLING_BLOCK" : Internal.DamageSource;
        static readonly "FLY_INTO_WALL" : Internal.DamageSource;
        static readonly "GENERIC" : Internal.DamageSource;
        static readonly "SWEET_BERRY_BUSH" : Internal.DamageSource;
        static readonly "HOT_FLOOR" : Internal.DamageSource;
        static readonly "DROWN" : Internal.DamageSource;
        static readonly "FALLING_STALACTITE" : Internal.DamageSource;
        static readonly "STALAGMITE" : Internal.DamageSource;
        get magic(): boolean;
        get actualKJS(): Internal.EntityJS;
        get fall(): boolean;
        get noAggro(): boolean;
        get creativePlayer(): boolean;
        get playerKJS(): Internal.PlayerJS<any>;
        get fire(): boolean;
        get sourcePosition(): Vec3;
        get projectile(): boolean;
        get immediateKJS(): Internal.EntityJS;
        get foodExhaustion(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string);
    }
    type DamageSource_ = "inFire" | "lightningBolt" | "onFire" | "lava" | "hotFloor" | "inWall" | "cramming" | "drown" | "starve" | "cactus" | "fall" | "flyIntoWall" | "outOfWorld" | "generic" | "magic" | "wither" | "anvil" | "fallingBlock" | "dragonBreath" | "dryout" | "sweetBerryBush" | "freeze" | "fallingStalactite" | "stalagmite" | DamageSource;
    /**
    * @javaClass net.minecraft.class_4646
    */
    class BlobFoliagePlacer extends Internal.FoliagePlacer {
        method_26989($$0: Internal.Random_, $$1: number, $$2: Internal.TreeConfiguration_): number;
        static readonly "CODEC" : Internal.Codec<Internal.BlobFoliagePlacer>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.IntProvider, $$1: Internal.IntProvider, $$2: number);
    }
    type BlobFoliagePlacer_ = BlobFoliagePlacer;
    /**
    * @javaClass net.minecraft.class_6597
    */
    class PrioritizeChunkUpdates extends Internal.Enum<Internal.PrioritizeChunkUpdates> {
        getKey(): string;
        static valueOf($$0: string): Internal.PrioritizeChunkUpdates;
        static values(): Internal.PrioritizeChunkUpdates[];
        getId(): number;
        static byId($$0: number): Internal.PrioritizeChunkUpdates;
        static readonly "NEARBY" : Internal.PrioritizeChunkUpdates;
        static readonly "NONE" : Internal.PrioritizeChunkUpdates;
        static readonly "PLAYER_AFFECTED" : Internal.PrioritizeChunkUpdates;
        get id(): number;
        get key(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type PrioritizeChunkUpdates_ = "player_affected" | "none" | "nearby" | PrioritizeChunkUpdates;
    /**
    * @javaClass net.fabricmc.fabric.mixin.gamerule.BooleanRuleAccessor
    */
    interface BooleanRuleAccessor {
    }
    type BooleanRuleAccessor_ = BooleanRuleAccessor;
    /**
    * @javaClass dev.architectury.event.EventActor
    */
    interface EventActor <T> {
        act(arg0: T): Internal.EventResult;
    }
    type EventActor_<T> = ((arg0: T) => Internal.EventResult) | EventActor<T>;
    /**
    * @javaClass net.minecraft.class_278
    */
    class AbstractUniform {
        setSafe($$0: number, $$1: number, $$2: number, $$3: number): void;
        set($$0: number): void;
        set($$0: Internal.Matrix4f_): void;
        set($$0: number, $$1: number): void;
        set($$0: number, $$1: number, $$2: number, $$3: number): void;
        set($$0: number, $$1: number, $$2: number): void;
        set($$0: Internal.Vector4f_): void;
        set($$0: Internal.Matrix3f_): void;
        set($$0: Internal.Vector3f_): void;
        set($$0: number[]): void;
        setMat2x3($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): void;
        setMat3x2($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): void;
        setMat2x2($$0: number, $$1: number, $$2: number, $$3: number): void;
        setMat3x4($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number, $$10: number, $$11: number): void;
        setMat4x3($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number, $$10: number, $$11: number): void;
        setMat4x2($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        setMat2x4($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        setMat3x3($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number): void;
        setMat4x4($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number, $$10: number, $$11: number, $$12: number, $$13: number, $$14: number, $$15: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AbstractUniform_ = AbstractUniform;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.VertexFormatExtensions
    */
    interface VertexFormatExtensions {
        getOffset(index: number): number;
    }
    type VertexFormatExtensions_ = VertexFormatExtensions;
    /**
    * @javaClass net.minecraft.class_1295
    */
    class AreaEffectCloud extends Internal.Entity implements Internal.AreaEffectCloudEntityAccessor, Internal.AreaEffectCloudTicker, Internal.IExclusiveAOECloud {
        setDuration($$0: number): void;
        getPotion(): Internal.Potion;
        setDurationOnUse($$0: number): void;
        method_18377($$0: Internal.Pose_): Internal.EntityDimensions;
        method_5657(): Internal.PushReaction;
        handler$gaf000$mcdw$nbtToTag(tag: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        getParticle(): Internal.ParticleOptions;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getOwner(): Internal.LivingEntity;
        handler$gaf000$mcdw$nbtFromTag(tag: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        addEffect($$0: Internal.MobEffectInstance_): void;
        setRadius($$0: number): void;
        setOwner($$0: Internal.LivingEntity_): void;
        superTick(): void;
        getDuration(): number;
        setWaitTime($$0: number): void;
        getRadiusPerTick(): number;
        setRadiusPerTick($$0: number): void;
        getRadiusOnUse(): number;
        alwaysAccepts(): boolean;
        method_18002(): Internal.Packet<any>;
        getWaitTime(): number;
        getDurationOnUse(): number;
        method_18382(): void;
        args$gaf000$mcdw$livingEntityGetter(args: Internal.Args_): void;
        getStepHeight(): number;
        setParticle($$0: Internal.ParticleOptions_): void;
        handler$gaf000$mcdw$pickyAOEClouds(ci: Internal.CallbackInfo_): void;
        setPotion($$0: Internal.Potion_): void;
        getColor(): number;
        getExclusions(): Internal.List<any>;
        getRadius(): number;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        setExclusions(owner: boolean, allies: boolean, enemy: boolean): void;
        setRadiusOnUse($$0: number): void;
        setFixedColor($$0: number): void;
        isWaiting(): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5773(): void;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        get owner(): Internal.LivingEntity;
        get potion(): Internal.Potion;
        get color(): number;
        get waiting(): boolean;
        get durationOnUse(): number;
        get exclusions(): Internal.List<any>;
        get radiusPerTick(): number;
        get duration(): number;
        get radiusOnUse(): number;
        get particle(): Internal.ParticleOptions;
        get radius(): number;
        get waitTime(): number;
        get stepHeight(): number;
        set fixedColor($$0: number);
        set owner($$0: Internal.LivingEntity_);
        set duration($$0: number);
        set potion($$0: Internal.Potion_);
        set radiusOnUse($$0: number);
        set durationOnUse($$0: number);
        set particle($$0: Internal.ParticleOptions_);
        set radius($$0: number);
        set radiusPerTick($$0: number);
        set waitTime($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.AreaEffectCloud>, $$1: Internal.Level);
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number);
    }
    type AreaEffectCloud_ = AreaEffectCloud;
    /**
    * @javaClass it.unimi.dsi.fastutil.BidirectionalIterator
    */
    interface BidirectionalIterator <K> extends Internal.Iterator<K> {
        previous(): K;
        hasPrevious(): boolean;
        forEachRemaining(arg0: Internal.Consumer_<K>): void;
        remove(): void;
    }
    type BidirectionalIterator_<K> = BidirectionalIterator<K>;
    /**
    * @javaClass net.minecraft.class_5657
    */
    class LootNumberProviderType extends Internal.SerializerType<Internal.NumberProvider> {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Serializer<Internal.NumberProvider>);
    }
    type LootNumberProviderType_ = Special.LootNumberProviderType | LootNumberProviderType;
    /**
    * @javaClass net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder
    */
    interface FabricLootTableBuilder {
        apply(functions: Internal.Collection_<Internal.LootItemFunction_>): Internal.LootTable$Builder;
        apply(function_: Internal.LootItemFunction_): Internal.LootTable$Builder;
        pool(pool: Internal.LootPool_): Internal.LootTable$Builder;
        pools(pools: Internal.Collection_<Internal.LootPool_>): Internal.LootTable$Builder;
        copyOf(table: Internal.LootTable_): Internal.LootTable$Builder;
        modifyPools(modifier: Internal.Consumer_<Internal.LootPool$Builder_>): Internal.LootTable$Builder;
    }
    type FabricLootTableBuilder_ = FabricLootTableBuilder;
    /**
    * @javaClass net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder
    */
    interface RegistryAttributeHolder {
        addAttribute(arg0: Internal.RegistryAttribute_): this;
        get(registry: Internal.Registry_<any>): this;
        hasAttribute(arg0: Internal.RegistryAttribute_): boolean;
    }
    type RegistryAttributeHolder_ = RegistryAttributeHolder;
    /**
    * @javaClass com.simibubi.create.content.contraptions.components.structureMovement.ContraptionRelocationPacket
    */
    class ContraptionRelocationPacket extends Internal.SimplePacketBase {
        handle(context: Internal.Supplier_<Internal.SimplePacketBase$Context_>): void;
        write(buffer: Internal.FriendlyByteBuf_): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(entityID: number);
        constructor(buffer: Internal.FriendlyByteBuf);
    }
    type ContraptionRelocationPacket_ = ContraptionRelocationPacket;
    /**
    * @javaClass net.minecraft.class_310$class_5859
    */
    abstract class Minecraft$ChatStatus extends Internal.Enum<Internal.Minecraft$ChatStatus> {
        static valueOf($$0: string): Internal.Minecraft$ChatStatus;
        static values(): Internal.Minecraft$ChatStatus[];
        getMessage(): net.minecraft.network.chat.Component;
        isChatAllowed(arg0: boolean): boolean;
        static readonly "DISABLED_BY_OPTIONS" : Internal.Minecraft$ChatStatus;
        static readonly "DISABLED_BY_PROFILE" : Internal.Minecraft$ChatStatus;
        static readonly "ENABLED" : Internal.Minecraft$ChatStatus;
        static readonly "DISABLED_BY_LAUNCHER" : Internal.Minecraft$ChatStatus;
        get message(): net.minecraft.network.chat.Component;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Minecraft$ChatStatus_ = "disabled_by_profile" | "disabled_by_launcher" | "enabled" | "disabled_by_options" | Minecraft$ChatStatus;
    /**
    * @javaClass net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext
    */
    interface TransactionContext {
        nestingDepth(): number;
        getOpenTransaction(arg0: number): Internal.Transaction;
        addOuterCloseCallback(arg0: Internal.TransactionContext$OuterCloseCallback_): void;
        addCloseCallback(arg0: Internal.TransactionContext$CloseCallback_): void;
        openNested(): Internal.Transaction;
    }
    type TransactionContext_ = TransactionContext;
    /**
    * @javaClass net.minecraft.class_5483
    */
    class MobSpawnSettings implements Internal.MobSpawnSettingsAccessor, Internal.MobSpawnInfoAccess, Internal.SpawnSettingsAccessor {
        getMobSpawnCost($$0: Internal.EntityType_<any>): Internal.MobSpawnSettings$MobSpawnCost;
        getCreatureProbability(): number;
        getMobs($$0: Internal.MobCategory_): Internal.WeightedRandomList<Internal.MobSpawnSettings$SpawnerData>;
        static readonly "CODEC" : Internal.MapCodec<Internal.MobSpawnSettings>;
        "creatureGenerationProbability" : number;
        "mobSpawnCosts" : Internal.Map<Internal.EntityType<any>, Internal.MobSpawnSettings$MobSpawnCost>;
        "spawners" : Internal.Map<Internal.MobCategory, Internal.WeightedRandomList<Internal.MobSpawnSettings$SpawnerData>>;
        static readonly "EMPTY" : Internal.MobSpawnSettings;
        static readonly "EMPTY_MOB_LIST" : Internal.WeightedRandomList<Internal.MobSpawnSettings$SpawnerData>;
        get creatureProbability(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MobSpawnSettings_ = MobSpawnSettings;
    /**
    * @javaClass com.simibubi.create.foundation.utility.WorldAttached
    */
    class WorldAttached <T> {
        static invalidateWorld(world: Internal.LevelAccessor_): void;
        get(world: Internal.LevelAccessor_): T;
        replace(world: Internal.LevelAccessor_, finalizer: Internal.Consumer_<T>): T;
        replace(world: Internal.LevelAccessor_): T;
        put(world: Internal.LevelAccessor_, entry: T): void;
        empty(finalizer: Internal.BiConsumer_<Internal.LevelAccessor_, T>): void;
        empty(finalizer: Internal.Consumer_<T>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(factory: ((arg0: Internal.LevelAccessor) => T));
    }
    type WorldAttached_<T> = WorldAttached<T>;
    /**
    * @javaClass net.minecraft.class_3609
    */
    abstract class FlowingFluid extends Internal.Fluid implements Internal.FlowingFluidAccessor {
        method_20784($$0: Internal.FluidState_): number;
        arch$registryName(): ResourceLocation;
        method_15782($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.FluidState_): Vec3;
        getFlowing($$0: number, $$1: boolean): Internal.FluidState;
        getFlowing(): Internal.Fluid;
        getSource($$0: boolean): Internal.FluidState;
        getSource(): Internal.Fluid;
        method_15779(arg0: Internal.FluidState_): number;
        method_17775($$0: Internal.FluidState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        method_15778($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FluidState_): void;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        createAttributes(): Internal.FluidAttributes;
        method_15788($$0: Internal.FluidState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): number;
        static readonly "FALLING" : Internal.BooleanProperty;
        static readonly "LEVEL" : Internal.IntegerProperty;
        get source(): Internal.Fluid;
        get flowing(): Internal.Fluid;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type FlowingFluid_ = FlowingFluid;
    /**
    * @javaClass java.util.function.IntPredicate
    */
    interface IntPredicate {
        or(arg0: Internal.IntPredicate_): this;
        test(arg0: number): boolean;
        and(arg0: Internal.IntPredicate_): this;
        negate(): this;
    }
    type IntPredicate_ = ((arg0: number) => boolean) | IntPredicate;
    /**
    * @javaClass net.minecraft.class_6759
    */
    class SavedTick <T> extends Internal.Record {
        static loadTick<T>($$0: Internal.CompoundTag_, $$1: Internal.Function_<string, Internal.Optional_<T>>): Internal.Optional<Internal.SavedTick<T>>;
        static loadTickList<T>($$0: Internal.ListTag_, $$1: Internal.Function_<string, Internal.Optional_<T>>, $$2: Internal.ChunkPos_, $$3: Internal.Consumer_<Internal.SavedTick_<T>>): void;
        delay(): number;
        pos(): BlockPos;
        hashCode(): number;
        equals($$0: any): boolean;
        save($$0: Internal.Function_<T, string>): Internal.CompoundTag;
        toString(): string;
        unpack($$0: number, $$1: number): Internal.ScheduledTick<T>;
        priority(): Internal.TickPriority;
        static saveTick<T>($$0: Internal.ScheduledTick_<T>, $$1: Internal.Function_<T, string>, $$2: number): Internal.CompoundTag;
        type(): T;
        static probe<T>($$0: T, $$1: BlockPos_): Internal.SavedTick<T>;
        static readonly "UNIQUE_TICK_HASH" : Internal.Hash$Strategy<Internal.SavedTick<any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: T, $$1: BlockPos, $$2: number, $$3: Internal.TickPriority);
    }
    type SavedTick_<T> = SavedTick<T>;
    /**
    * @javaClass net.minecraft.class_6683
    */
    class ModCheck extends Internal.Record {
        shouldReportAsModified(): boolean;
        static identify($$0: string, $$1: Internal.Supplier_<string>, $$2: string, $$3: Internal.Class_<any>): Internal.ModCheck;
        hashCode(): number;
        merge($$0: Internal.ModCheck_): this;
        confidence(): Internal.ModCheck$Confidence;
        equals($$0: any): boolean;
        description(): string;
        toString(): string;
        fullDescription(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ModCheck$Confidence, $$1: string);
    }
    type ModCheck_ = ModCheck;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.BezierConnection
    */
    class BezierConnection implements Internal.Iterable<Internal.BezierConnection$Segment> {
        getNormal(t: number): Vec3;
        getKey(): BlockPos;
        getBakedGirders(): any[];
        spliterator(): Internal.Spliterator<Internal.BezierConnection$Segment>;
        forEach(arg0: Internal.Consumer_<Internal.BezierConnection$Segment_>): void;
        getStepLUT(): number[];
        addItemsToPlayer(player: Internal.Player_): void;
        getRadius(): number;
        getBounds(): Internal.AABB;
        incrementT(currentT: number, distance: number): number;
        getGirderItemCost(): number;
        secondary(): this;
        getTrackItemCost(): number;
        spawnItems(level: Internal.Level_): void;
        getHandleLength(): number;
        iterator(): Internal.Iterator<Internal.BezierConnection$Segment>;
        getPosition(t: number): Vec3;
        getSegmentCount(): number;
        isPrimary(): boolean;
        getBakedSegments(): any[];
        getLength(): number;
        write(buffer: Internal.FriendlyByteBuf_): void;
        write(localTo: BlockPos_): Internal.CompoundTag;
        getSegmentT(index: number): number;
        spawnDestroyParticles(level: Internal.Level_): void;
        "tePositions" : Internal.Couple<BlockPos>;
        "axes" : Internal.Couple<Vec3>;
        "hasGirder" : boolean;
        "starts" : Internal.Couple<Vec3>;
        "normals" : Internal.Couple<Vec3>;
        "primary" : boolean;
        get girderItemCost(): number;
        get bakedSegments(): any[];
        get bounds(): Internal.AABB;
        get length(): number;
        get bakedGirders(): any[];
        get handleLength(): number;
        get radius(): number;
        get stepLUT(): number[];
        get key(): BlockPos;
        get trackItemCost(): number;
        get segmentCount(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(compound: Internal.CompoundTag, localTo: BlockPos);
        constructor(buffer: Internal.FriendlyByteBuf);
        constructor(positions: Internal.Couple<BlockPos>, starts: Internal.Couple<Vec3>, axes: Internal.Couple<Vec3>, normals: Internal.Couple<Vec3>, primary: boolean, girder: boolean);
    }
    type BezierConnection_ = BezierConnection;
    /**
    * @javaClass net.minecraft.class_2841
    */
    class PalettedContainer <T> implements Internal.PaletteResize<T>, Internal.PalettedContainerAccessor<any> {
        read($$0: Internal.FriendlyByteBuf_): void;
        set($$0: number, $$1: number, $$2: number, $$3: T): void;
        getAll($$0: Internal.Consumer_<T>): void;
        release(): void;
        getSerializedSize(): number;
        count($$0: Internal.PalettedContainer$CountConsumer_<T>): void;
        acquire(): void;
        static codec<T>($$0: Internal.IdMap_<T>, $$1: Internal.Codec_<T>, $$2: Internal.PalettedContainer$Strategy_, $$3: T): Internal.Codec<Internal.PalettedContainer<T>>;
        onResize($$0: number, $$1: T): number;
        get($$0: number, $$1: number, $$2: number): T;
        get($$0: number): T;
        maybeHas($$0: Internal.Predicate_<T>): boolean;
        copy(): Internal.PalettedContainer<T>;
        getAndSet($$0: number, $$1: number, $$2: number, $$3: T): T;
        write($$0: Internal.FriendlyByteBuf_): void;
        getAndSetUnchecked($$0: number, $$1: number, $$2: number, $$3: T): T;
        getData(): Internal.PalettedContainer$Data<any>;
        get serializedSize(): number;
        get data(): Internal.PalettedContainer$Data<any>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.IdMap<T>, $$1: Internal.PalettedContainer$Strategy, $$2: Internal.PalettedContainer$Configuration<T>, $$3: Internal.BitStorage, $$4: Internal.List<T>);
        constructor($$0: Internal.IdMap<T>, $$1: T, $$2: Internal.PalettedContainer$Strategy);
    }
    type PalettedContainer_<T> = PalettedContainer<T>;
    /**
    * @javaClass net.minecraft.class_1928
    */
    class GameRules implements Internal.GameRulesAccessor {
        assignFrom($$0: Internal.GameRules_, $$1: Internal.MinecraftServer_): void;
        getInt($$0: Internal.GameRules$Key_<Internal.GameRules$IntegerValue_>): number;
        createTag(): Internal.CompoundTag;
        getRule<T>($$0: Internal.GameRules$Key_<T>): T;
        static visitGameRuleTypes($$0: Internal.GameRules$GameRuleTypeVisitor_): void;
        getBoolean($$0: Internal.GameRules$Key_<Internal.GameRules$BooleanValue_>): boolean;
        copy(): this;
        static register<T>($$0: string, $$1: Internal.GameRules$Category_, $$2: Internal.GameRules$Type_<T>): Internal.GameRules$Key<T>;
        static readonly "RULE_MAX_COMMAND_CHAIN_LENGTH" : Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly "RULE_DROWNING_DAMAGE" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_LOGADMINCOMMANDS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_REDUCEDDEBUGINFO" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_WEATHER_CYCLE" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_FALL_DAMAGE" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_FORGIVE_DEAD_PLAYERS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DOINSOMNIA" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_LIMITED_CRAFTING" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "DEFAULT_RANDOM_TICK_SPEED" : 3;
        static readonly "RULE_DOFIRETICK" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_MOBGRIEFING" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_NATURAL_REGENERATION" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DISABLE_ELYTRA_MOVEMENT_CHECK" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_SHOWDEATHMESSAGES" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_MAX_ENTITY_CRAMMING" : Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly "RULE_ANNOUNCE_ADVANCEMENTS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_COMMANDBLOCKOUTPUT" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_SPAWN_RADIUS" : Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly "RULE_DOMOBSPAWNING" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_UNIVERSAL_ANGER" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DAYLIGHT" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DISABLE_RAIDS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_FIRE_DAMAGE" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_PLAYERS_SLEEPING_PERCENTAGE" : Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly "RULE_DOBLOCKDROPS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_SPECTATORSGENERATECHUNKS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_FREEZE_DAMAGE" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DO_IMMEDIATE_RESPAWN" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DOENTITYDROPS" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_KEEPINVENTORY" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_SENDCOMMANDFEEDBACK" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_RANDOMTICKING" : Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly "RULE_DO_TRADER_SPAWNING" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DOMOBLOOT" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly "RULE_DO_PATROL_SPAWNING" : Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
        constructor($$0: Internal.DynamicLike<any>);
    }
    type GameRules_ = GameRules;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.FoodBuilder
    */
    class FoodBuilder {
        saturation(s: number): this;
        build(): Internal.FoodProperties;
        removeEffect(mobEffect: Internal.MobEffect_): this;
        /**
        */
        effect(mobEffectId: Special.MobEffect, duration: number, amplifier: number, probability: number): this;
        meat(): this;
        meat(flag: boolean): this;
        alwaysEdible(flag: boolean): this;
        alwaysEdible(): this;
        fastToEat(): this;
        fastToEat(flag: boolean): this;
        eaten(e: Internal.Consumer_<Internal.ItemFoodEatenEventJS_>): this;
        hunger(h: number): this;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
        constructor(properties: Internal.FoodProperties);
    }
    /**
    */
    type FoodBuilder_ = FoodBuilder;
    /**
    * @javaClass net.minecraft.class_2568$class_5249
    */
    class HoverEvent$ItemStackInfo {
        hashCode(): number;
        equals($$0: any): boolean;
        getItemStack(): Internal.ItemStack;
        get itemStack(): Internal.ItemStack;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ItemStack);
    }
    type HoverEvent$ItemStackInfo_ = HoverEvent$ItemStackInfo;
    /**
    * @javaClass net.minecraft.class_1569
    */
    interface Enemy {
    }
    type Enemy_ = Enemy;
    /**
    * @javaClass xaero.common.minimap.waypoints.WaypointWorldRootContainer
    */
    class WaypointWorldRootContainer extends Internal.WaypointWorldContainer {
        setTeleportationEnabled(teleportation: boolean): void;
        setDefaultMultiworldId(defaultMultiworldId: string): void;
        setUsingDefaultTeleportCommand(usingDefaultTeleportCommand: boolean): void;
        loadConfig(): void;
        getSortType(): Internal.WaypointsSort;
        isUsingDefaultTeleportCommand(): boolean;
        getServerTeleportCommandRotationFormat(): string;
        setIgnoreHeightmaps(ignoreHeightmaps: boolean): void;
        isSortReversed(): boolean;
        setServerTeleportCommandRotationFormat(serverTeleportCommandRotationFormat: string): void;
        getSubWorldConnections(): Internal.WaypointWorldConnectionManager;
        isTeleportationEnabled(): boolean;
        saveConfig(): void;
        getDefaultMultiworldId(): string;
        getServerTeleportCommandFormat(): string;
        isIgnoreHeightmaps(): boolean;
        isIgnoreServerLevelId(): boolean;
        setUsingMultiworldDetection(usingMultiworldDetection: boolean): void;
        setServerTeleportCommandFormat(serverTeleportCommandFormat: string): void;
        isUsingMultiworldDetection(): boolean;
        toggleSortType(): void;
        updateConnectionsField(minimapSession: Internal.XaeroMinimapSession_): void;
        toggleSortReversed(): void;
        "configLoaded" : boolean;
        get ignoreHeightmaps(): boolean;
        get sortReversed(): boolean;
        get sortType(): Internal.WaypointsSort;
        get usingDefaultTeleportCommand(): boolean;
        get subWorldConnections(): Internal.WaypointWorldConnectionManager;
        get serverTeleportCommandRotationFormat(): string;
        get defaultMultiworldId(): string;
        get ignoreServerLevelId(): boolean;
        get usingMultiworldDetection(): boolean;
        get teleportationEnabled(): boolean;
        get serverTeleportCommandFormat(): string;
        set ignoreHeightmaps(ignoreHeightmaps: boolean);
        set usingDefaultTeleportCommand(usingDefaultTeleportCommand: boolean);
        set serverTeleportCommandRotationFormat(serverTeleportCommandRotationFormat: string);
        set defaultMultiworldId(defaultMultiworldId: string);
        set usingMultiworldDetection(usingMultiworldDetection: boolean);
        set serverTeleportCommandFormat(serverTeleportCommandFormat: string);
        set teleportationEnabled(teleportation: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(modMain: Internal.AXaeroMinimap, minimapSession: Internal.XaeroMinimapSession, key: string);
    }
    type WaypointWorldRootContainer_ = WaypointWorldRootContainer;
    /**
    * @javaClass com.mojang.datafixers.util.Function12
    */
    interface Function12 <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> {
        curry9(): Internal.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, Internal.Function3<T10, T11, T12, R>>;
        apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7, arg7: T8, arg8: T9, arg9: T10, arg10: T11, arg11: T12): R;
        curry7(): Internal.Function7<T1, T2, T3, T4, T5, T6, T7, Internal.Function5<T8, T9, T10, T11, T12, R>>;
        curry8(): Internal.Function8<T1, T2, T3, T4, T5, T6, T7, T8, Internal.Function4<T9, T10, T11, T12, R>>;
        curry5(): Internal.Function5<T1, T2, T3, T4, T5, Internal.Function7<T6, T7, T8, T9, T10, T11, T12, R>>;
        curry6(): Internal.Function6<T1, T2, T3, T4, T5, T6, Internal.Function6<T7, T8, T9, T10, T11, T12, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function9<T4, T5, T6, T7, T8, T9, T10, T11, T12, R>>;
        curry10(): Internal.Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Internal.BiFunction<T11, T12, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.Function8<T5, T6, T7, T8, T9, T10, T11, T12, R>>;
        curry11(): Internal.Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Internal.Function<T12, R>>;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function10<T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>>;
        curry(): Internal.Function<T1, Internal.Function11<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>>;
    }
    type Function12_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> = Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>;
    /**
    * @javaClass net.minecraft.class_1686
    */
    class ThrownPotion extends Internal.ThrowableItemProjectile implements Internal.ItemSupplier, Internal.PotionItemEntityExtensions {
        canRiderInteract(): boolean;
        setMilk(value: boolean): void;
        isMilk(): boolean;
        getStepHeight(): number;
        method_5749(nbt: Internal.CompoundTag_): void;
        handler$coc000$attemptPortalLight(pos: BlockPos_, ci: Internal.CallbackInfo_): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        method_5652(nbt: Internal.CompoundTag_): void;
        static readonly "WATER_SENSITIVE" : ((arg0: Internal.LivingEntity) => boolean);
        static readonly "SPLASH_RANGE" : 4.0;
        get milk(): boolean;
        get stepHeight(): number;
        set milk(value: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number);
        constructor($$0: Internal.Level, $$1: Internal.LivingEntity);
        constructor($$0: Internal.EntityType<Internal.ThrownPotion>, $$1: Internal.Level);
    }
    type ThrownPotion_ = ThrownPotion;
    /**
    * @javaClass vazkii.botania.mixin.AccessorAbstractHorse
    */
    interface AccessorAbstractHorse {
        getInventory(): Internal.SimpleContainer;
    }
    type AccessorAbstractHorse_ = AccessorAbstractHorse;
    /**
    * @javaClass java.io.Closeable
    */
    interface Closeable extends Internal.AutoCloseable {
        close(): void;
    }
    type Closeable_ = Closeable;
    /**
    * @javaClass net.minecraft.class_1355
    */
    class GoalSelector implements Internal.AccessorGoalSelector, Internal.GoalSelectorAccessor {
        addGoal($$0: number, $$1: Internal.Goal_): void;
        removeGoal($$0: Internal.Goal_): void;
        removeAllGoals(): void;
        getRunningGoals(): Internal.Stream<Internal.WrappedGoal>;
        tickRunningGoals($$0: boolean): void;
        enableControlFlag($$0: Internal.Goal$Flag_): void;
        getAvailableGoals(): Internal.Set<Internal.WrappedGoal>;
        tick(): void;
        disableControlFlag($$0: Internal.Goal$Flag_): void;
        setNewGoalRate($$0: number): void;
        setControlFlag($$0: Internal.Goal$Flag_, $$1: boolean): void;
        readonly "availableGoals" : Internal.Set<Internal.WrappedGoal>;
        get runningGoals(): Internal.Stream<Internal.WrappedGoal>;
        set newGoalRate($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: (() => Internal.ProfilerFiller));
    }
    type GoalSelector_ = GoalSelector;
    /**
    * @javaClass com.samebutdifferent.morevillagers.mixin.StructureTemplatePoolAccessor
    */
    interface StructureTemplatePoolAccessor {
        setRawTemplates(arg0: Internal.List_<com.mojang.datafixers.util.Pair_<Internal.StructurePoolElement_, number>>): void;
        setTemplates(arg0: Internal.List_<Internal.StructurePoolElement_>): void;
        getRawTemplates(): Internal.List<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>;
        getTemplates(): Internal.List<Internal.StructurePoolElement>;
    }
    type StructureTemplatePoolAccessor_ = StructureTemplatePoolAccessor;
    /**
    * @javaClass net.minecraft.class_2396
    */
    abstract class ParticleType <T> implements Internal.RegistryNameProvider {
        codec(): Internal.Codec<T>;
        getDeserializer(): Internal.ParticleOptions$Deserializer<T>;
        getOverrideLimiter(): boolean;
        getRegistryName(): ResourceLocation;
        get overrideLimiter(): boolean;
        get deserializer(): Internal.ParticleOptions$Deserializer<T>;
        get registryName(): ResourceLocation;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ParticleType_<T> = Special.ParticleType | ParticleType<T>;
    /**
    * @javaClass net.id.incubus_core.blocklikeentities.util.PostTickEntity
    */
    interface PostTickEntity {
        postTick(): void;
    }
    type PostTickEntity_ = PostTickEntity;
    /**
    * @javaClass net.kyrptonaught.inventorysorter.interfaces.SortableContainer
    */
    interface SortableContainer {
        hasSlots(): boolean;
        getInventory(): net.minecraft.world.Container;
    }
    type SortableContainer_ = SortableContainer;
    /**
    * @javaClass com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor
    */
    interface LivingEntityAccessor {
        isJumping(): boolean;
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
    /**
    * @javaClass dev.latvian.mods.kubejs.client.ModelGenerator
    */
    class ModelGenerator {
        parent(s: string): void;
        toJson(): Internal.JsonObject;
        textures(json: Internal.JsonObject_): void;
        texture(name: string, texture: string): void;
        element(consumer: Internal.Consumer_<Internal.ModelGenerator$Element_>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ModelGenerator_ = ModelGenerator;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.util.LazyOptional
    */
    class LazyOptional <T> {
        resolve(): Internal.Optional<T>;
        isPresent(): boolean;
        invalidate(): void;
        orElse(other: T): T;
        getValueUnsafer(): T;
        orElseThrow<X>(exceptionSupplier: Internal.NonNullSupplier_<X>): T;
        static empty<T>(): Internal.LazyOptional<T>;
        filter(predicate: Internal.Predicate_<T>): Internal.Optional<T>;
        cast<X>(): Internal.LazyOptional<X>;
        static ofObject<T>(o: T): Internal.LazyOptional<T>;
        static fromOptional<T>(regularOptional: Internal.Optional_<T>): Internal.LazyOptional<T>;
        orElseGet(other: Internal.NonNullSupplier_<T>): T;
        ifPresent(consumer: Internal.NonNullConsumer_<T>): void;
        static of<T>(instanceSupplier: Internal.NonNullSupplier_<T>): Internal.LazyOptional<T>;
        map<U>(mapper: Internal.NonNullFunction_<T, U>): Internal.Optional<U>;
        lazyMap<U>(mapper: Internal.NonNullFunction_<T, U>): Internal.LazyOptional<U>;
        addListener(listener: Internal.NonNullConsumer_<Internal.LazyOptional_<T>>): void;
        "supplier" : Internal.NonNullSupplier<T>;
        static readonly "EMPTY" : Internal.LazyOptional<void>;
        get valueUnsafer(): T;
        get present(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type LazyOptional_<T> = LazyOptional<T>;
    /**
    * @javaClass xaero.map.region.texture.RegionTexture
    */
    abstract class RegionTexture <T> {
        shouldDownloadFromPBO(): boolean;
        getTextureHasLight(): boolean;
        setShouldDownloadFromPBO(shouldDownloadFromPBO: boolean): void;
        isCachePrepared(): boolean;
        onTextureDeletion(): void;
        resetTimer(): void;
        setToUpload(value: boolean): void;
        uploadBuffer(highlighterHandler: xaero.map.highlight.DimensionHighlighterHandler_, textureUploader: Internal.TextureUploader_, inRegion: Internal.LeveledRegion_<T>, branchTextureRenderer: Internal.BranchTextureRenderer_, x: number, y: number): number;
        bindColorTexture(create: boolean, magFilter: number): number;
        bindColorTexture(create: boolean): number;
        deletePBOs(): void;
        shouldIncludeInCache(): boolean;
        isColorBufferCompressed(): boolean;
        shouldBeUsedForBranchUpdate(usedVersion: number): boolean;
        getTextureVersion(): number;
        hasSourceData(): boolean;
        removeHeight(x: number, z: number): void;
        getTopHeight(x: number, z: number): number;
        getColorBufferFormat(): number;
        shouldHaveContentForBranchUpdate(): boolean;
        getHeight(x: number, z: number): number;
        setCachePrepared(cachePrepared: boolean): void;
        setBufferedTextureVersion(bufferedTextureVersion: number): void;
        getGlColorTexture(): number;
        writeCacheMapData(output: Internal.DataOutputStream_, usableBuffer: number[], integerByteBuffer: number[], inRegion: Internal.LeveledRegion_<T>): void;
        getBufferedTextureVersion(): number;
        isUploaded(): boolean;
        getDirectColorBuffer(): Internal.ByteBuffer;
        putHeight(index: number, height: number): void;
        putHeight(x: number, z: number, height: number): void;
        postBufferWrite(buffer: Internal.PoolTextureDirectBufferUnit_): void;
        addDebugLines(debugLines: Internal.List_<string>): void;
        removeTopHeight(x: number, z: number): void;
        readCacheData(minorSaveVersion: number, majorSaveVersion: number, input: Internal.DataInputStream_, usableBuffer: number[], integerByteBuffer: number[], inRegion: Internal.LeveledRegion_<T>, mapProcessor: Internal.MapProcessor_, x: number, y: number, leafShouldAffectBranches: boolean): void;
        decTimer(): void;
        getColorBuffer(): Internal.PoolTextureDirectBufferUnit;
        canUpload(): boolean;
        preUpload(arg0: Internal.MapProcessor_, arg1: Internal.BlockTintProvider_, arg2: Internal.OverlayManager_, arg3: Internal.LeveledRegion_<T>, arg4: boolean, arg5: Internal.BlockStateShortShapeCache_): void;
        deleteColorBuffer(): void;
        postUpload(arg0: Internal.MapProcessor_, arg1: Internal.LeveledRegion_<T>, arg2: boolean): void;
        prepareBuffer(): void;
        getRegion(): Internal.LeveledRegion<T>;
        deleteTexturesAndBuffers(): void;
        getTimer(): number;
        putTopHeight(x: number, z: number, height: number): void;
        putTopHeight(index: number, height: number): void;
        shouldUpload(): boolean;
        static readonly "PBO_PACK_LENGTH" : 16384;
        static readonly "PBO_UNPACK_LENGTH" : 16384;
        get directColorBuffer(): Internal.ByteBuffer;
        get timer(): number;
        get colorBuffer(): Internal.PoolTextureDirectBufferUnit;
        get glColorTexture(): number;
        get colorBufferFormat(): number;
        get bufferedTextureVersion(): number;
        get cachePrepared(): boolean;
        get textureHasLight(): boolean;
        get textureVersion(): number;
        get uploaded(): boolean;
        get region(): Internal.LeveledRegion<T>;
        get colorBufferCompressed(): boolean;
        set bufferedTextureVersion(bufferedTextureVersion: number);
        set cachePrepared(cachePrepared: boolean);
        set toUpload(value: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(region: Internal.LeveledRegion<T>);
    }
    type RegionTexture_<T> = RegionTexture<T>;
    /**
    * @javaClass me.shedaniel.rei.api.common.registry.ReloadStage
    */
    class ReloadStage extends Internal.Enum<Internal.ReloadStage> {
        static valueOf(name: string): Internal.ReloadStage;
        static values(): Internal.ReloadStage[];
        static readonly "START" : Internal.ReloadStage;
        static readonly "END" : Internal.ReloadStage;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ReloadStage_ = "start" | "end" | ReloadStage;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.entity.Carriage$DimensionalCarriageEntity
    */
    class Carriage$DimensionalCarriageEntity {
        updateCutoff(leadingIsCurrent: boolean): void;
        findPivot(dimension: Internal.ResourceKey_<Internal.Level_>, leading: boolean): Internal.TrackNodeLocation;
        maxAllowedLocalCoord(): number;
        read(tag: Internal.CompoundTag_): void;
        alignEntity(entity: Internal.CarriageContraptionEntity_): void;
        discardPivot(): void;
        leadingAnchor(): Vec3;
        updatePassengerLoadout(): void;
        updateRenderedCutoff(): void;
        trailingAnchor(): Vec3;
        write(): Internal.CompoundTag;
        minAllowedLocalCoord(): number;
        "pointsInitialised" : boolean;
        "pivot" : Internal.TrackNodeLocation;
        "rotationAnchors" : Internal.Couple<Vec3>;
        "cutoff" : number;
        "positionAnchor" : Vec3;
        "entity" : Internal.WeakReference<Internal.CarriageContraptionEntity>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(this$0: Internal.Carriage);
    }
    type Carriage$DimensionalCarriageEntity_ = Carriage$DimensionalCarriageEntity;
    /**
    * @javaClass com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity
    */
    class OrientedContraptionEntity extends Internal.AbstractContraptionEntity {
        startAtInitialYaw(): void;
        getAnchorVec(): Vec3;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        isInitialOrientationPresent(): boolean;
        static createAtYaw(world: Internal.Level_, contraption: Internal.Contraption_, initialOrientation: Internal.Direction_, initialYaw: number): Internal.OrientedContraptionEntity;
        getCouplingId(): Internal.UUID;
        getYawOffset(): number;
        static create(world: Internal.Level_, contraption: Internal.Contraption_, initialOrientation: Internal.Direction_): Internal.OrientedContraptionEntity;
        getCoupledCartsIfPresent(): Internal.Couple<Internal.MinecartController>;
        setCouplingId(id: Internal.UUID_): void;
        alwaysAccepts(): boolean;
        getRotationState(): Internal.AbstractContraptionEntity$ContraptionRotationState;
        method_5647(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        getStepHeight(): number;
        method_5848(): void;
        method_5705(partialTicks: number): number;
        setInitialOrientation(direction: Internal.Direction_): void;
        getInitialYaw(): number;
        asKJS(): Internal.EntityJS;
        startAtYaw(yaw: number): void;
        canRiderInteract(): boolean;
        static handleRelocationPacket(packet: Internal.ContraptionRelocationPacket_): void;
        method_5650(p_146834_: Internal.Entity$RemovalReason_): void;
        doLocalTransforms(partialTicks: number, matrixStacks: Internal.PoseStack_[]): void;
        method_5695(partialTicks: number): number;
        getInitialOrientation(): Internal.Direction;
        reverseRotation(localPos: Vec3_, partialTicks: number): Vec3;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5674(key: Internal.EntityDataAccessor_<any>): void;
        applyRotation(localPos: Vec3_, partialTicks: number): Vec3;
        "prevYaw" : number;
        "pitch" : number;
        "nonDamageTicks" : number;
        "targetYaw" : number;
        "prevPitch" : number;
        "yaw" : number;
        get initialYaw(): number;
        get rotationState(): Internal.AbstractContraptionEntity$ContraptionRotationState;
        get initialOrientation(): Internal.Direction;
        get couplingId(): Internal.UUID;
        get coupledCartsIfPresent(): Internal.Couple<Internal.MinecartController>;
        get initialOrientationPresent(): boolean;
        get stepHeight(): number;
        get anchorVec(): Vec3;
        get yawOffset(): number;
        set initialOrientation(direction: Internal.Direction_);
        set couplingId(id: Internal.UUID_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(type: Internal.EntityType<any>, world: Internal.Level);
    }
    type OrientedContraptionEntity_ = OrientedContraptionEntity;
    /**
    * @javaClass net.minecraft.class_5872
    */
    class CarverDebugSettings {
        getWaterState(): Internal.BlockState;
        getLavaState(): Internal.BlockState;
        isDebugMode(): boolean;
        static of($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.BlockState_, $$3: Internal.BlockState_): Internal.CarverDebugSettings;
        static of($$0: boolean, $$1: Internal.BlockState_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.BlockState_): Internal.CarverDebugSettings;
        static of($$0: boolean, $$1: Internal.BlockState_): Internal.CarverDebugSettings;
        getAirState(): Internal.BlockState;
        getBarrierState(): Internal.BlockState;
        static readonly "CODEC" : Internal.Codec<Internal.CarverDebugSettings>;
        static readonly "DEFAULT" : Internal.CarverDebugSettings;
        get waterState(): Internal.BlockState;
        get airState(): Internal.BlockState;
        get debugMode(): boolean;
        get barrierState(): Internal.BlockState;
        get lavaState(): Internal.BlockState;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type CarverDebugSettings_ = CarverDebugSettings;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.ui.ContextMenuItem
    */
    class ContextMenuItem implements Internal.Comparable<Internal.ContextMenuItem> {
        setEnabled(v: boolean): this;
        setEnabled(v: Internal.BooleanSupplier_): this;
        addMouseOverText(list: Internal.TooltipList_): void;
        setYesNo(s: net.minecraft.network.chat.Component_): this;
        onClicked(panel: Internal.Panel_, button: Internal.MouseButton_): void;
        compareTo(o: Internal.ContextMenuItem_): number;
        drawIcon(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        createWidget(panel: Internal.ContextMenu_): dev.ftb.mods.ftblibrary.ui.Widget;
        setCloseMenu(v: boolean): this;
        static readonly "SEPARATOR" : Internal.ContextMenuItem;
        "icon" : Internal.Icon;
        static readonly "TRUE" : (() => boolean);
        "callback" : (() => void);
        static readonly "FALSE" : (() => boolean);
        "title" : net.minecraft.network.chat.Component;
        "yesNoText" : net.minecraft.network.chat.Component;
        "closeMenu" : boolean;
        "enabled" : (() => boolean);
        set yesNo(s: net.minecraft.network.chat.Component_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(t: net.minecraft.network.chat.Component, i: Internal.Icon, c: (() => void));
    }
    type ContextMenuItem_ = ContextMenuItem;
    /**
    * @javaClass java.util.regex.MatchResult
    */
    interface MatchResult {
        groupCount(): number;
        start(arg0: number): number;
        start(): number;
        end(arg0: number): number;
        end(): number;
        group(): string;
        group(arg0: number): string;
    }
    type MatchResult_ = MatchResult;
    /**
    * @javaClass me.shedaniel.rei.api.common.entry.type.EntryType
    */
    interface EntryType <T> extends Internal.Identifiable {
        getDefinition(): Internal.EntryDefinition<T>;
        deferred<T>(id: ResourceLocation_): Internal.EntryType<T>;
        cast<O>(): Internal.EntryType<O>;
        getIdentifier(): ResourceLocation;
        getId(): ResourceLocation;
    }
    type EntryType_<T> = EntryType<T>;
    /**
    * @javaClass net.minecraft.class_1655
    */
    interface Npc {
    }
    type Npc_ = Npc;
    /**
    * @javaClass com.mojang.serialization.KeyCompressor
    */
    class KeyCompressor <T> {
        decompress(arg0: number): T;
        size(): number;
        compress(arg0: T): number;
        compress(arg0: string): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.DynamicOps<T>, arg1: Internal.Stream<T>);
    }
    type KeyCompressor_<T> = KeyCompressor<T>;
    /**
    * @javaClass dev.latvian.mods.kubejs.player.ChestEventJS
    */
    class ChestEventJS extends Internal.InventoryEventJS {
        getWrappedInventory(): net.minecraft.world.Container;
        getBlock(): Internal.BlockContainerJS;
        getInventory(): Internal.InventoryJS;
        get wrappedInventory(): net.minecraft.world.Container;
        get block(): Internal.BlockContainerJS;
        get inventory(): Internal.InventoryJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(player: Internal.Player, menu: Internal.AbstractContainerMenu);
    }
    type ChestEventJS_ = ChestEventJS;
    /**
    * @javaClass it.unimi.dsi.fastutil.longs.Long2ObjectFunction
    */
    interface Long2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.LongFunction<V> {
        getOrDefault(arg0: any, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        put(arg0: number, arg1: V): V;
        remove(arg0: number): V;
        remove(arg0: any): V;
        defaultReturnValue(): V;
        defaultReturnValue(arg0: V): void;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        get(arg0: any): V;
        get(arg0: number): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        apply(arg0: number): V;
        containsKey(arg0: any): boolean;
        containsKey(arg0: number): boolean;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
    }
    type Long2ObjectFunction_<V> = ((arg0: number) => V) | Long2ObjectFunction<V>;
    /**
    * @javaClass com.mojang.datafixers.Products$P12
    */
    class Products$P12 <F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> {
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function12_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function12_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>>): Internal.App<F, R>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.App<F, T1>, arg1: Internal.App<F, T2>, arg2: Internal.App<F, T3>, arg3: Internal.App<F, T4>, arg4: Internal.App<F, T5>, arg5: Internal.App<F, T6>, arg6: Internal.App<F, T7>, arg7: Internal.App<F, T8>, arg8: Internal.App<F, T9>, arg9: Internal.App<F, T10>, arg10: Internal.App<F, T11>, arg11: Internal.App<F, T12>);
    }
    type Products$P12_<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> = Products$P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>;
    /**
    * @javaClass java.util.stream.Collector
    */
    interface Collector <T, A, R> {
        characteristics(): Internal.Set<Internal.Collector$Characteristics>;
        supplier(): Internal.Supplier<A>;
        of<T, A, R>(arg0: Internal.Supplier_<A>, arg1: Internal.BiConsumer_<A, T>, arg2: Internal.BinaryOperator_<A>, arg3: Internal.Function_<A, R>, ...arg4: Internal.Collector$Characteristics_[]): Internal.Collector<T, A, R>;
        of<T, R>(arg0: Internal.Supplier_<R>, arg1: Internal.BiConsumer_<R, T>, arg2: Internal.BinaryOperator_<R>, ...arg3: Internal.Collector$Characteristics_[]): Internal.Collector<T, R, R>;
        finisher(): Internal.Function<A, R>;
        accumulator(): Internal.BiConsumer<A, T>;
        combiner(): Internal.BinaryOperator<A>;
    }
    type Collector_<T, A, R> = Collector<T, A, R>;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.Reference2ReferenceFunction
    */
    interface Reference2ReferenceFunction <K, V> extends it.unimi.dsi.fastutil.Function<K, V> {
        getOrDefault(arg0: any, arg1: V): V;
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Reference2ShortFunction<K>;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2ReferenceFunction<V>;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Reference2IntFunction<K>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2ReferenceFunction<T, V>;
        put(arg0: K, arg1: V): V;
        remove(arg0: any): V;
        defaultReturnValue(arg0: V): void;
        defaultReturnValue(): V;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Reference2DoubleFunction<K>;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Reference2ObjectFunction<K, T>;
        get(arg0: any): V;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Reference2LongFunction<K>;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2ReferenceFunction<V>;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Reference2ByteFunction<K>;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Reference2FloatFunction<K>;
        apply(arg0: K): V;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2ReferenceFunction<V>;
        clear(): void;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2ReferenceFunction<V>;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Reference2CharFunction<K>;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2ReferenceFunction<T, V>;
        size(): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2ReferenceFunction<V>;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Reference2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2ReferenceFunction<V>;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2ReferenceFunction<V>;
    }
    type Reference2ReferenceFunction_<K, V> = ((arg0: any) => V) | Reference2ReferenceFunction<K, V>;
    /**
    * @javaClass com.google.common.reflect.TypeToken
    */
    abstract class TypeToken <T> extends Internal.TypeCapture<T> implements Internal.Serializable {
        getRawType(): typeof T;
        resolveType(arg0: Internal.Type_): Internal.TypeToken<any>;
        method(arg0: Internal.Method_): Internal.Invokable<T, any>;
        unwrap(): Internal.TypeToken<T>;
        isSubtypeOf(arg0: Internal.TypeToken_<any>): boolean;
        isSubtypeOf(arg0: Internal.Type_): boolean;
        getType(): Internal.Type;
        hashCode(): number;
        getComponentType(): Internal.TypeToken<any>;
        static of<T>(arg0: Internal.Class_<T>): Internal.TypeToken<T>;
        static of(arg0: Internal.Type_): Internal.TypeToken<any>;
        equals(arg0: any): boolean;
        getSubtype(arg0: Internal.Class_<any>): Internal.TypeToken<T>;
        getSupertype(arg0: Internal.Class_<T>): Internal.TypeToken<T>;
        where<X>(arg0: Internal.TypeParameter_<X>, arg1: Internal.Class_<X>): Internal.TypeToken<T>;
        where<X>(arg0: Internal.TypeParameter_<X>, arg1: Internal.TypeToken_<X>): Internal.TypeToken<T>;
        isArray(): boolean;
        toString(): string;
        getTypes(): Internal.TypeToken$TypeSet<>;
        isSupertypeOf(arg0: Internal.TypeToken_<any>): boolean;
        isSupertypeOf(arg0: Internal.Type_): boolean;
        wrap(): Internal.TypeToken<T>;
        isPrimitive(): boolean;
        get componentType(): Internal.TypeToken<any>;
        get types(): Internal.TypeToken$TypeSet<>;
        get rawType(): typeof T;
        get primitive(): boolean;
        get array(): boolean;
        get type(): Internal.Type;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TypeToken_<T> = TypeToken<T>;
    /**
    * @javaClass xaero.common.gui.widget.WidgetScreenHandler
    */
    class WidgetScreenHandler {
        handleClick(screen: Internal.Screen_, width: number, height: number, mouseX: number, mouseY: number, guiScale: number): void;
        initialize(screen: Internal.WidgetScreen_, width: number, height: number): void;
        render(matrixStack: Internal.PoseStack_, screen: Internal.WidgetScreen_, width: number, height: number, mouseX: number, mouseY: number, guiScale: number): void;
        renderTooltips(matrixStack: Internal.PoseStack_, screen: Internal.Screen_, width: number, height: number, mouseX: number, mouseY: number, guiScale: number): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type WidgetScreenHandler_ = WidgetScreenHandler;
    /**
    * @javaClass io.github.flemmli97.tenshilib.mixin.ModelPartAccessor
    */
    interface ModelPartAccessor {
        getChildren(): Internal.Map<string, Internal.ModelPart>;
        getCubes(): Internal.List<Internal.ModelPart$Cube>;
    }
    type ModelPartAccessor_ = ModelPartAccessor;
    /**
    * @javaClass net.minecraft.class_3823
    */
    class RandomBlockStateMatchTest extends Internal.RuleTest {
        method_16768($$0: Internal.BlockState_, $$1: Internal.Random_): boolean;
        static readonly "CODEC" : Internal.Codec<Internal.RandomBlockStateMatchTest>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockState, $$1: number);
    }
    type RandomBlockStateMatchTest_ = RandomBlockStateMatchTest;
    /**
    * @javaClass com.mojang.serialization.codecs.UnboundedMapCodec
    */
    class UnboundedMapCodec <K, V> implements Internal.BaseMapCodec<K, V>, Internal.Codec<Internal.Map<K, V>> {
        encode<T>(arg0: Internal.Map_<K, V>, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
        encode<T>(arg0: Internal.Map_<K, V>, arg1: Internal.DynamicOps_<T>, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
        flatComapMap<S>(arg0: Internal.Function_<Internal.Map_<K, V>, S>, arg1: Internal.Function_<S, Internal.DataResult_<Internal.Map_<K, V>>>): Internal.Codec<S>;
        dispatch<E>(arg0: Internal.Function_<E, Internal.Map_<K, V>>, arg1: Internal.Function_<Internal.Map_<K, V>, Internal.Codec_<E>>): Internal.Codec<E>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.Map_<K, V>>, arg2: Internal.Function_<Internal.Map_<K, V>, Internal.Codec_<E>>): Internal.Codec<E>;
        deprecated(arg0: number): Internal.Codec<Internal.Map<K, V>>;
        simple(): Internal.Decoder$Simple<Internal.Map<K, V>>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, Internal.Map_<K, V>>, arg2: Internal.Function_<Internal.Map_<K, V>, Internal.Codec_<E>>): Internal.MapCodec<E>;
        dispatchMap<E>(arg0: Internal.Function_<E, Internal.Map_<K, V>>, arg1: Internal.Function_<Internal.Map_<K, V>, Internal.Codec_<E>>): Internal.MapCodec<E>;
        comapFlatMap<S>(arg0: Internal.Function_<Internal.Map_<K, V>, Internal.DataResult_<S>>, arg1: Internal.Function_<S, Internal.Map_<K, V>>): Internal.Codec<S>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.Map<K, V>, T>>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.MapLike_<T>): Internal.DataResult<Internal.Map<K, V>>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.Map<K, V>, T>>;
        promotePartial(arg0: Internal.Consumer_<string>): Internal.Codec<Internal.Map<K, V>>;
        flatXmap<S>(arg0: Internal.Function_<Internal.Map_<K, V>, Internal.DataResult_<S>>, arg1: Internal.Function_<S, Internal.DataResult_<Internal.Map_<K, V>>>): Internal.Codec<S>;
        hashCode(): number;
        comap<B>(arg0: Internal.Function_<B, Internal.Map_<K, V>>): Internal.Encoder<B>;
        fieldOf(arg0: string): Internal.MapCodec<Internal.Map<K, V>>;
        xmap<S>(arg0: Internal.Function_<Internal.Map_<K, V>, S>, arg1: Internal.Function_<S, Internal.Map_<K, V>>): Internal.Codec<S>;
        listOf(): Internal.Codec<Internal.List<Internal.Map<K, V>>>;
        map<B>(arg0: Internal.Function_<Internal.Map_<K, V>, B>): Internal.Decoder<B>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.Map_<K, V>): Internal.DataResult<T>;
        optionalFieldOf(arg0: string, arg1: Internal.Map_<K, V>): Internal.MapCodec<Internal.Map<K, V>>;
        optionalFieldOf(arg0: string, arg1: Internal.Map_<K, V>, arg2: Internal.Lifecycle_): Internal.MapCodec<Internal.Map<K, V>>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<Internal.Map<K, V>>>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: Internal.Map_<K, V>, arg3: Internal.Lifecycle_): Internal.MapCodec<Internal.Map<K, V>>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult_<Internal.Map_<K, V>>>): Internal.Encoder<B>;
        keyCodec(): Internal.Codec<K>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult_<Internal.Map_<K, V>>>, arg2: Internal.Function_<Internal.Map_<K, V>, Internal.DataResult_<Internal.Codec_<E>>>): Internal.Codec<E>;
        terminal(): Internal.Decoder$Terminal<Internal.Map<K, V>>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<Internal.Map<K, V>>;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<Internal.Map<K, V>>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Codec<Internal.Map<K, V>>;
        orElse(arg0: Internal.Map_<K, V>): Internal.Codec<Internal.Map<K, V>>;
        orElse(arg0: Internal.Consumer_<string>, arg1: Internal.Map_<K, V>): Internal.Codec<Internal.Map<K, V>>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Map_<K, V>): Internal.Codec<Internal.Map<K, V>>;
        flatMap<B>(arg0: Internal.Function_<Internal.Map_<K, V>, Internal.DataResult_<B>>): Internal.Decoder<B>;
        elementCodec(): Internal.Codec<V>;
        boxed(): Internal.Decoder$Boxed<Internal.Map<K, V>>;
        dispatchStable<E>(arg0: Internal.Function_<E, Internal.Map_<K, V>>, arg1: Internal.Function_<Internal.Map_<K, V>, Internal.Codec_<E>>): Internal.Codec<E>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<Internal.Map_<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<Internal.Map_<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        orElseGet(arg0: Internal.Supplier_<Internal.Map_<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        stable(): Internal.Codec<Internal.Map<K, V>>;
        equals(arg0: any): boolean;
        mapResult(arg0: Internal.Codec$ResultFunction_<Internal.Map_<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.Codec<K>, arg1: Internal.Codec<V>);
    }
    type UnboundedMapCodec_<K, V> = UnboundedMapCodec<K, V>;
    /**
    * @javaClass com.mojang.authlib.GameProfile
    */
    class GameProfile {
        getName(): string;
        isLegacy(): boolean;
        hashCode(): number;
        getProperties(): Internal.PropertyMap;
        equals(arg0: any): boolean;
        getId(): Internal.UUID;
        toString(): string;
        isComplete(): boolean;
        get legacy(): boolean;
        get name(): string;
        get id(): Internal.UUID;
        get complete(): boolean;
        get properties(): Internal.PropertyMap;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.UUID, arg1: string);
    }
    type GameProfile_ = GameProfile;
    /**
    * @javaClass corgitaco.enhancedcelestials.mixin.access.MobSpawnInfoAccess
    */
    interface MobSpawnInfoAccess {
        getSpawners(): Internal.Map<Internal.MobCategory, Internal.List<Internal.MobSpawnSettings$SpawnerData>>;
        getMobSpawnCosts(): Internal.Map<Internal.EntityType<any>, Internal.MobSpawnSettings$MobSpawnCost>;
    }
    type MobSpawnInfoAccess_ = MobSpawnInfoAccess;
    /**
    * @javaClass net.minecraft.class_1473
    */
    class SnowGolem extends Internal.AbstractGolem implements Internal.Shearable, Internal.RangedAttackMob, Internal.IShearable {
        method_6636($$0: Internal.SoundSource_): void;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<any>;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        method_29919(): Vec3;
        method_29503(): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        canRiderInteract(): boolean;
        setPumpkin($$0: boolean): void;
        method_27072(): boolean;
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        hasPumpkin(): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_6007(): void;
        method_5652($$0: Internal.CompoundTag_): void;
        method_7105($$0: Internal.LivingEntity_, $$1: number): void;
        get stepHeight(): number;
        set pumpkin($$0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.SnowGolem>, $$1: Internal.Level);
    }
    type SnowGolem_ = SnowGolem;
    /**
    * @javaClass net.fabricmc.fabric.mixin.loot.LootTableAccessor
    */
    interface LootTableAccessor {
        fabric_getPools(): Internal.LootPool[];
        fabric_getFunctions(): Internal.LootItemFunction[];
    }
    type LootTableAccessor_ = LootTableAccessor;
    /**
    * @javaClass com.dusk.event.ISpawnGroupDataSetter
    */
    interface ISpawnGroupDataSetter {
        setMaxCap(arg0: number): void;
    }
    type ISpawnGroupDataSetter_ = ISpawnGroupDataSetter;
    /**
    * @javaClass net.minecraft.class_5862
    */
    class ConstantFloat extends Internal.FloatProvider {
        getValue(): number;
        static of($$0: number): Internal.ConstantFloat;
        method_33915(): number;
        toString(): string;
        method_33923(): Internal.FloatProviderType<any>;
        method_33921(): number;
        method_33920($$0: Internal.Random_): number;
        static readonly "ZERO" : Internal.ConstantFloat;
        static readonly "CODEC" : Internal.Codec<Internal.ConstantFloat>;
        get value(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ConstantFloat_ = ConstantFloat;
    /**
    * @javaClass java.lang.module.Configuration
    */
    class Configuration {
        findModule(arg0: string): Internal.Optional<Internal.ResolvedModule>;
        resolve(arg0: Internal.ModuleFinder_, arg1: Internal.ModuleFinder_, arg2: Internal.Collection_<string>): this;
        static resolve(arg0: Internal.ModuleFinder_, arg1: Internal.List_<Internal.Configuration_>, arg2: Internal.ModuleFinder_, arg3: Internal.Collection_<string>): Internal.Configuration;
        toString(): string;
        static resolveAndBind(arg0: Internal.ModuleFinder_, arg1: Internal.List_<Internal.Configuration_>, arg2: Internal.ModuleFinder_, arg3: Internal.Collection_<string>): Internal.Configuration;
        resolveAndBind(arg0: Internal.ModuleFinder_, arg1: Internal.ModuleFinder_, arg2: Internal.Collection_<string>): this;
        modules(): Internal.Set<Internal.ResolvedModule>;
        parents(): Internal.List<Internal.Configuration>;
        static empty(): Internal.Configuration;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Configuration_ = Configuration;
    /**
    * @javaClass net.minecraft.class_4703$class_4705
    */
    class BeeDebugRenderer$HiveInfo {
        readonly "hiveType" : string;
        readonly "sedated" : boolean;
        readonly "lastSeen" : number;
        readonly "pos" : BlockPos;
        readonly "honeyLevel" : number;
        readonly "occupantCount" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: string, $$2: number, $$3: number, $$4: boolean, $$5: number);
    }
    type BeeDebugRenderer$HiveInfo_ = BeeDebugRenderer$HiveInfo;
    /**
    * @javaClass net.minecraft.class_2902
    */
    class Heightmap {
        setRawData($$0: Internal.ChunkAccess_, $$1: Internal.Heightmap$Types_, $$2: number[]): void;
        getFirstAvailable($$0: number, $$1: number): number;
        update($$0: number, $$1: number, $$2: number, $$3: Internal.BlockState_): boolean;
        getRawData(): number[];
        setHeight($$0: number, $$1: number, $$2: number): void;
        static primeHeightmaps($$0: Internal.ChunkAccess_, $$1: Internal.Set_<Internal.Heightmap$Types_>): void;
        getHighestTaken($$0: number, $$1: number): number;
        get rawData(): number[];
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ChunkAccess, $$1: Internal.Heightmap$Types);
    }
    type Heightmap_ = Heightmap;
    /**
    * @javaClass com.epherical.croptopia.mixin.ParrotAccess
    */
    interface ParrotAccess {
    }
    type ParrotAccess_ = ParrotAccess;
    /**
    * @javaClass net.minecraft.class_1477
    */
    class Squid extends Internal.WaterAnimal {
        method_5711($$0: number): void;
        method_5931($$0: Internal.Player_): boolean;
        getStepHeight(): number;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        canRiderInteract(): boolean;
        method_6091($$0: Vec3_): void;
        setMovementVector($$0: number, $$1: number, $$2: number): void;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_6007(): void;
        hasMovementVector(): boolean;
        "oldTentacleMovement" : number;
        "tentacleAngle" : number;
        "zBodyRot" : number;
        "xBodyRot" : number;
        "zBodyRotO" : number;
        "xBodyRotO" : number;
        "tentacleMovement" : number;
        "oldTentacleAngle" : number;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Squid>, $$1: Internal.Level);
    }
    type Squid_ = Squid;
    /**
    * @javaClass com.github.clevernucleus.dataattributes.api.attribute.IEntityAttribute
    */
    interface IEntityAttribute {
        minValue(): number;
        getProperty(arg0: string): string;
        children(): Internal.Map<Internal.IEntityAttribute, number>;
        maxValue(): number;
        stackingBehaviour(): Internal.StackingBehaviour;
        hasProperty(arg0: string): boolean;
        properties(): Internal.Collection<string>;
        parents(): Internal.Map<Internal.IEntityAttribute, number>;
    }
    type IEntityAttribute_ = IEntityAttribute;
    /**
    * @javaClass net.minecraft.class_1117
    */
    interface TickableSoundInstance extends Internal.SoundInstance {
        isStopped(): boolean;
        canStartSilent(): boolean;
        tick(): void;
        canPlaySound(): boolean;
    }
    type TickableSoundInstance_ = TickableSoundInstance;
    /**
    * @javaClass dev.latvian.mods.rhino.Symbol
    */
    interface Symbol {
    }
    type Symbol_ = Symbol;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.CameraExtensions
    */
    interface CameraExtensions {
        setAnglesInternal(yaw: number, pitch: number): void;
        getBlockAtCamera(): Internal.BlockState;
    }
    type CameraExtensions_ = CameraExtensions;
    /**
    * @javaClass com.mojang.datafixers.DataFixer
    */
    interface DataFixer {
        update<T>(arg0: Internal.DSL$TypeReference_, arg1: Internal.Dynamic_<T>, arg2: number, arg3: number): Internal.Dynamic<T>;
        getSchema(arg0: number): Internal.Schema;
    }
    type DataFixer_ = DataFixer;
    /**
    * @javaClass net.minecraft.class_1681
    */
    class ThrownEgg extends Internal.ThrowableItemProjectile {
        canRiderInteract(): boolean;
        redirect$ddh000$getChickenType(): Internal.EntityType<any>;
        method_5711($$0: number): void;
        getStepHeight(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number);
        constructor($$0: Internal.Level, $$1: Internal.LivingEntity);
        constructor($$0: Internal.EntityType<Internal.ThrownEgg>, $$1: Internal.Level);
    }
    type ThrownEgg_ = ThrownEgg;
    /**
    * @javaClass net.minecraft.class_5640
    */
    class ItemModifierManager extends Internal.SimpleJsonResourceReloadListener {
        getName(): string;
        get($$0: ResourceLocation_): Internal.LootItemFunction;
        get($$0: ResourceLocation_, $$1: Internal.LootItemFunction_): Internal.LootItemFunction;
        getKeys(): Internal.Set<ResourceLocation>;
        get keys(): Internal.Set<ResourceLocation>;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.PredicateManager, $$1: Internal.LootTables);
    }
    type ItemModifierManager_ = ItemModifierManager;
    /**
    * @javaClass net.minecraft.class_5892
    */
    class ClientboundPlayerCombatKillPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        method_11051(): boolean;
        getMessage(): net.minecraft.network.chat.Component;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getKillerId(): number;
        getPlayerId(): number;
        get message(): net.minecraft.network.chat.Component;
        get killerId(): number;
        get playerId(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.FriendlyByteBuf);
        constructor($$0: number, $$1: number, $$2: net.minecraft.network.chat.Component);
        constructor($$0: Internal.CombatTracker, $$1: net.minecraft.network.chat.Component);
    }
    type ClientboundPlayerCombatKillPacket_ = ClientboundPlayerCombatKillPacket;
    /**
    * @javaClass net.minecraft.class_1536
    */
    class FishingHook extends Internal.Projectile implements Internal.SmeltingBobber, Internal.FishingBobberEntityAccessor, Internal.ExperienceBobber, Internal.FireproofEntity {
        gf_setBaseExperience(experience: number): void;
        method_5711($$0: number): void;
        method_5759($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean): void;
        isOpenWaterFishing(): boolean;
        gf_setFireproof(value: boolean): void;
        shouldStopFishing($$0: Internal.Player_): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_36209(): void;
        method_31471($$0: Internal.ClientboundAddEntityPacket_): void;
        getHookedIn(): Internal.Entity;
        method_5640($$0: number): boolean;
        alwaysAccepts(): boolean;
        gf_isFireproof(): boolean;
        method_18002(): Internal.Packet<any>;
        method_5822(): boolean;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        method_5809(): boolean;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        gf_setSmelts(value: boolean): void;
        gf_canSmelt(): boolean;
        gf_getBaseExperience(): number;
        getPlayerOwner(): Internal.Player;
        method_5650($$0: Internal.Entity$RemovalReason_): void;
        retrieve($$0: Internal.ItemStack_): number;
        method_7432($$0: Internal.Entity_): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        get playerOwner(): Internal.Player;
        get openWaterFishing(): boolean;
        get hookedIn(): Internal.Entity;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Player, $$1: Internal.Level, $$2: number, $$3: number);
        constructor($$0: Internal.EntityType<Internal.FishingHook>, $$1: Internal.Level);
    }
    type FishingHook_ = FishingHook;
    /**
    * @javaClass net.minecraft.class_5214
    */
    class GiantTrunkPlacer extends Internal.TrunkPlacer {
        method_26991($$0: Internal.LevelSimulatedReader_, $$1: Internal.BiConsumer_<BlockPos_, Internal.BlockState_>, $$2: Internal.Random_, $$3: number, $$4: BlockPos_, $$5: Internal.TreeConfiguration_): Internal.List<Internal.FoliagePlacer$FoliageAttachment>;
        static readonly "CODEC" : Internal.Codec<Internal.GiantTrunkPlacer>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number, $$2: number);
    }
    type GiantTrunkPlacer_ = GiantTrunkPlacer;
    /**
    * @javaClass com.mojang.brigadier.exceptions.DynamicCommandExceptionType
    */
    class DynamicCommandExceptionType implements Internal.CommandExceptionType {
        createWithContext(arg0: Internal.ImmutableStringReader_, arg1: any): Internal.CommandSyntaxException;
        create(arg0: any): Internal.CommandSyntaxException;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: ((arg0: any) => Internal.Message));
    }
    type DynamicCommandExceptionType_ = DynamicCommandExceptionType;
    /**
    * @javaClass it.unimi.dsi.fastutil.ints.Int2DoubleFunction
    */
    interface Int2DoubleFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntToDoubleFunction {
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        applyAsDouble(arg0: number): number;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Int2ShortFunction;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2DoubleFunction;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Int2IntFunction;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2DoubleFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        put(arg0: number, arg1: number): number;
        remove(arg0: number): number;
        remove(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        get(arg0: any): number;
        get(arg0: number): number;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Int2LongFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2DoubleFunction;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Int2ByteFunction;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Int2FloatFunction;
        apply(arg0: number): number;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        clear(): void;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2DoubleFunction;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Int2CharFunction;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2DoubleFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2DoubleFunction;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2DoubleFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2DoubleFunction;
    }
    type Int2DoubleFunction_ = ((arg0: number) => number) | Int2DoubleFunction;
    /**
    * @javaClass java.awt.image.WritableRaster
    */
    class WritableRaster extends Internal.Raster {
        getWritableParent(): this;
        setSamples(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number[]): void;
        setPixel(arg0: number, arg1: number, arg2: number[]): void;
        createWritableChild(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number[]): this;
        setPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): void;
        createWritableTranslatedChild(arg0: number, arg1: number): this;
        setRect(arg0: Internal.Raster_): void;
        setRect(arg0: number, arg1: number, arg2: Internal.Raster_): void;
        setDataElements(arg0: number, arg1: number, arg2: any): void;
        setDataElements(arg0: number, arg1: number, arg2: Internal.Raster_): void;
        setDataElements(arg0: number, arg1: number, arg2: number, arg3: number, arg4: any): void;
        setSample(arg0: number, arg1: number, arg2: number, arg3: number): void;
        get writableParent(): this;
        set rect(arg0: Internal.Raster_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type WritableRaster_ = WritableRaster;
    /**
    * @javaClass net.minecraft.class_167
    */
    class AdvancementProgress implements Internal.Comparable<Internal.AdvancementProgress>, Internal.AdvancementProgressAccessor {
        getFirstProgressDate(): Internal.Date;
        getCriterion($$0: string): Internal.CriterionProgress;
        serializeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        getProgressText(): string;
        update($$0: Internal.Map_<string, Internal.Criterion_>, $$1: string[][]): void;
        compareTo($$0: Internal.AdvancementProgress_): number;
        isDone(): boolean;
        hasProgress(): boolean;
        revokeProgress($$0: string): boolean;
        grantProgress($$0: string): boolean;
        getCompletedCriteria(): Internal.Iterable<string>;
        getRemainingCriteria(): Internal.Iterable<string>;
        getPercent(): number;
        toString(): string;
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.AdvancementProgress;
        get completedCriteria(): Internal.Iterable<string>;
        get remainingCriteria(): Internal.Iterable<string>;
        get firstProgressDate(): Internal.Date;
        get done(): boolean;
        get percent(): number;
        get progressText(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AdvancementProgress_ = AdvancementProgress;
    /**
    * @javaClass draylar.gateofbabylon.api.LungeManipulator
    */
    interface LungeManipulator {
        canLunge(): boolean;
        setLunged(): void;
    }
    type LungeManipulator_ = LungeManipulator;
    /**
    * @javaClass me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler
    */
    interface ColorSampler <T> {
        getColor(arg0: T, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: number): number;
    }
    type ColorSampler_<T> = ColorSampler<T>;
    /**
    * @javaClass net.minecraft.class_1439$class_4621
    */
    class IronGolem$Crackiness extends Internal.Enum<Internal.IronGolem$Crackiness> {
        static byFraction($$0: number): Internal.IronGolem$Crackiness;
        static valueOf($$0: string): Internal.IronGolem$Crackiness;
        static values(): Internal.IronGolem$Crackiness[];
        static readonly "HIGH" : Internal.IronGolem$Crackiness;
        static readonly "MEDIUM" : Internal.IronGolem$Crackiness;
        static readonly "LOW" : Internal.IronGolem$Crackiness;
        static readonly "NONE" : Internal.IronGolem$Crackiness;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type IronGolem$Crackiness_ = "high" | "low" | "none" | "medium" | IronGolem$Crackiness;
    /**
    * @javaClass it.unimi.dsi.fastutil.bytes.Byte2ShortFunction
    */
    interface Byte2ShortFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntUnaryOperator {
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Byte2IntFunction;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2ShortFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        put(arg0: number, arg1: number): number;
        remove(arg0: number): number;
        remove(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Byte2DoubleFunction;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Byte2ObjectFunction<T>;
        get(arg0: any): number;
        get(arg0: number): number;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Byte2LongFunction;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2ShortFunction;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Byte2ByteFunction;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Byte2FloatFunction;
        applyAsInt(arg0: number): number;
        apply(arg0: number): number;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2ShortFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2ShortFunction;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Byte2CharFunction;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2ShortFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2ShortFunction;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Byte2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2ShortFunction;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2ShortFunction;
    }
    type Byte2ShortFunction_ = ((arg0: number) => number) | Byte2ShortFunction;
    /**
    * @javaClass ru.bclib.config.ConfigKey
    */
    class ConfigKey {
        isRoot(): boolean;
        hashCode(): number;
        equals(obj: any): boolean;
        getPath(): string[];
        static realKey(key: string): Internal.Pair<string, string>;
        toString(): string;
        getEntry(): string;
        get path(): string[];
        get entry(): string;
        get root(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(entry: string, path: string[]);
        constructor(entry: string, path: ResourceLocation);
    }
    type ConfigKey_ = ConfigKey;
    /**
    * @javaClass vazkii.botania.mixin.AccessorDamageSource
    */
    interface AccessorDamageSource {
        botania_setBypassArmor(): Internal.DamageSource;
    }
    type AccessorDamageSource_ = AccessorDamageSource;
    /**
    * @javaClass net.minecraft.class_4153$class_4155
    */
    class PoiManager$Occupancy extends Internal.Enum<Internal.PoiManager$Occupancy> {
        static valueOf($$0: string): Internal.PoiManager$Occupancy;
        static values(): Internal.PoiManager$Occupancy[];
        getTest(): Internal.Predicate<Internal.PoiRecord>;
        static readonly "IS_OCCUPIED" : Internal.PoiManager$Occupancy;
        static readonly "HAS_SPACE" : Internal.PoiManager$Occupancy;
        static readonly "ANY" : Internal.PoiManager$Occupancy;
        get test(): Internal.Predicate<Internal.PoiRecord>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type PoiManager$Occupancy_ = "has_space" | "is_occupied" | "any" | PoiManager$Occupancy;
    /**
    * @javaClass xaero.common.settings.ModSettings
    */
    class ModSettings {
        getCaveMaps(manualCaveMode: boolean): boolean;
        foundOldRadarSettings(): boolean;
        loadOldWaypoints(file: Internal.File_, waypointsManager: Internal.WaypointsManager_): void;
        getUseWorldMap(): boolean;
        toggleBooleanOptionValue(par1EnumOptions: Internal.ModOptions_): void;
        waypointsGUI(waypointsManager: Internal.WaypointsManager_): boolean;
        checkWaypointsLine(args: string[], wpw: Internal.WaypointWorld_): boolean;
        getCompassScale(): number;
        getBiomeColorsVanillaMode(): boolean;
        caveMapsDisabled(): boolean;
        resetServerSettings(): void;
        convertToNewConteinerID(oldID: string, waypointsManager: Internal.WaypointsManager_): string;
        readSetting(args: string[]): void;
        getBooleanValue(o: Internal.ModOptions_): boolean;
        loadDefaultSettings(): void;
        static canEditIngameSettings(): boolean;
        getOptionDoubleValue(options: Internal.ModOptions_): number;
        getWaypointsClampDepth(fov: number, height: number): number;
        getClaimsOpacity(): number;
        getDisplayClaims(): boolean;
        getAutoUIScale(): number;
        usesWorldMapOptionValue(par1EnumOptions: Internal.ModOptions_): boolean;
        getMoreOptionValueNames(par1EnumOptions: Internal.ModOptions_): string;
        getShowCoords(): boolean;
        getSmoothDots(): boolean;
        saveWorlds(worlds: Internal.ArrayList_<Internal.WaypointWorld_>): void;
        loadSettings(): void;
        getMinimap(): boolean;
        getAdjustHeightForCarpetLikeBlocks(): boolean;
        getDeathpoints(): boolean;
        getManualCaveModeStart(): number;
        getOptionValue(par1EnumOptions: Internal.ModOptions_): any;
        getOldDeathpoints(): boolean;
        getDotNameScale(): number;
        usesWorldMapHardValue(par1EnumOptions: Internal.ModOptions_): boolean;
        getTerrainDepth(): boolean;
        setSlimeChunksSeed(seed: number, fullWorldID: string): void;
        loadWaypoints(wpw: Internal.WaypointWorld_, file: Internal.File_): void;
        getOptionValueName(par1EnumOptions: Internal.ModOptions_): string;
        loadAllWaypoints(waypointsManager: Internal.WaypointsManager_): void;
        static setServerSettings(): void;
        getSlimeChunks(waypointsManager: Internal.WaypointsManager_): boolean;
        deathpointsDisabled(): boolean;
        getShowIngameWaypoints(): boolean;
        static copyTempFilesBack(folder: Internal.Path_): void;
        getSliderOptionText(par1EnumOptions: Internal.ModOptions_): string;
        getDisplayRedstone(): boolean;
        changeZoom(direction: number): void;
        isIgnoreHeightmaps(): boolean;
        getClientBooleanValue(o: Internal.ModOptions_): boolean;
        getWaypointsIngameNameScale(): number;
        getEntityRadar(): boolean;
        getShowFlowers(): boolean;
        getWaypointsFile(w: Internal.WaypointWorld_): Internal.File;
        writeSettings(writer: Internal.PrintWriter_): void;
        getUIScale(optionValue: number, min: number, max: number): number;
        getShowWaypoints(): boolean;
        getEntityRadarBackwardsCompatibilityConfig(): Internal.EntityRadarBackwardsCompatibilityConfig;
        resetEntityRadarBackwardsCompatibilityConfig(): void;
        static getTranslation(o: boolean): string;
        convertWaypointFilesToFolders(): void;
        convertWaypointFoldersToSingleFolder(waypointsManager: Internal.WaypointsManager_): void;
        getWaypointsIngameDistanceScale(): number;
        isKeyRepeat(kb: Internal.KeyMapping_): boolean;
        getMinimapScale(): number;
        getTerrainSlopes(): number;
        getMinimapSize(): number;
        getSlimeChunksSeed(fullWorldID: string): number;
        setOptionDoubleValue(options: Internal.ModOptions_, d: number): void;
        getLockNorth(mapSize: number, shape: number): boolean;
        showWaypointsDisabled(): boolean;
        getAntiAliasing(): boolean;
        setOptionValue(par1EnumOptions: Internal.ModOptions_, value: any): void;
        saveSettings(): void;
        getDotsStyle(): number;
        getWaypointsIngameIconScale(): number;
        minimapDisabled(): boolean;
        saveAllWaypoints(waypointsManager: Internal.WaypointsManager_): void;
        saveWaypoints(wpw: Internal.WaypointWorld_): void;
        saveWaypoints(wpw: Internal.WaypointWorld_, overwrite: boolean): void;
        getLighting(): boolean;
        checkWaypointsLineOLD(args: string[], waypointsManager: Internal.WaypointsManager_): boolean;
        getMaxWaypointsDistance(): number;
        getBlockColours(): number;
        getNorthCompassColor(): number;
        customSlimeSeedNeeded(minimapSession: Internal.XaeroMinimapSession_): boolean;
        loadWaypointsFromAllSources(waypointsManager: Internal.WaypointsManager_): void;
        static readonly "RADAR_OVER_MAP_OPTIONS" : string[];
        static "keyToggleMap" : Internal.KeyMapping;
        "hideMinimapUnderScreen" : boolean;
        "alwaysShowDistance" : boolean;
        static "keyBindZoom1" : Internal.KeyMapping;
        static readonly "blockColourTypes" : string[];
        "minimapOpacity" : number;
        static readonly "ENCHANT_COLORS" : string[];
        "defaultWaypointTPCommandFormat" : string;
        "arrowColour" : number;
        "displayPacPlayers" : boolean;
        "lightOverlayType" : number;
        static "defaultSettings" : 2147483647;
        "waypointsMutualEdit" : boolean;
        "allowWrongWorldTeleportation" : boolean;
        "hideWorldNames" : number;
        "crossDimensionalTp" : boolean;
        "manualCaveModeStartAuto" : boolean;
        static "serverSettings" : 2147483647;
        "mainEntityAs" : number;
        "minimapTextAlign" : number;
        "manualCaveModeStart" : number;
        static readonly "PUSHBOX_OPTIONS" : string[];
        static "keyTogglePacPlayers" : Internal.KeyMapping;
        static "minimapItem" : null;
        "slimeChunks" : boolean;
        "showBiome" : boolean;
        "bossHealthPushBox" : number;
        "displayMultipleWaypointInfo" : number;
        static "keyToggleSlimes" : Internal.KeyMapping;
        "hideWaypointCoordinates" : boolean;
        static "keyInstantWaypoint" : Internal.KeyMapping;
        static "keyLightOverlay" : Internal.KeyMapping;
        "partialYTeleportation" : boolean;
        "caveZoom" : number;
        static "newWaypoint" : Internal.KeyMapping;
        "mapSafeMode" : boolean;
        "showLightLevel" : number;
        static "settingsButton" : false;
        "caveMapsDepth" : number;
        "potionEffectPushBox" : number;
        "smoothDots" : boolean;
        static readonly "distanceTypes" : string[];
        "showDimensionName" : boolean;
        static readonly "ENCHANT_COLOR_NAMES" : string[];
        "deleteReachedDeathpoints" : boolean;
        "arrowColourNames" : string[];
        "compassColor" : number;
        "keepUnlockedWhenEnlarged" : boolean;
        "enlargedMinimapAToggle" : boolean;
        "waypointOpacityMap" : number;
        static readonly "COMPASS_OPTIONS" : string[];
        "defaultWaypointTPCommandRotationFormat" : string;
        static "keyManualCaveMode" : Internal.KeyMapping;
        "minimapFrame" : number;
        "radarHideInvisibleEntities" : boolean;
        static "keyToggleGrid" : Internal.KeyMapping;
        "renderLayerIndex" : number;
        "lookingAtAngleVertical" : number;
        "waypointsBottom" : boolean;
        "hideMinimapUnderF3" : boolean;
        "renderAllSets" : boolean;
        static "ignoreUpdate" : 340;
        static readonly "COLORS" : number[];
        "caveMaps" : number;
        "showTime" : number;
        static readonly "format" : "§";
        static "keyToggleWaypoints" : Internal.KeyMapping;
        "lightOverlayColor" : number;
        "lookingAtAngle" : number;
        "chunkGrid" : number;
        "adjustHeightForCarpetLikeBlocks" : boolean;
        "zoomedOutEnlarged" : boolean;
        static readonly "FRAME_OPTIONS" : string[];
        "playerArrowOpacity" : number;
        static "keyToggleRadar" : Internal.KeyMapping;
        static "keyLargeMap" : Internal.KeyMapping;
        static "keyReverseEntityRadar" : Internal.KeyMapping;
        "showAngles" : boolean;
        "distance" : number;
        static "updateNotification" : true;
        "lightOverlayMinLight" : number;
        "minimapFrameColor" : number;
        static "keyAllSets" : Internal.KeyMapping;
        static readonly "DOTS_STYLES" : string[];
        static "minimapItemId" : null;
        static "keyToggleMapWaypoints" : Internal.KeyMapping;
        "openSlimeSettings" : boolean;
        "mainDotSize" : number;
        "keepWaypointNames" : boolean;
        "waypointsDistanceMin" : number;
        "differentiateByServerAddress" : boolean;
        static "arrowColours" : number[][];
        "waypointDistancePrecision" : number;
        "autoConvertWaypointDistanceToKmThreshold" : number;
        static "keyBindZoom" : Internal.KeyMapping;
        "zoom" : number;
        static readonly "zooms" : number[];
        "waypointsIngameCloseScale" : number;
        "chunkGridLineWidth" : number;
        static "keyWaypoints" : Internal.KeyMapping;
        "compassOverEverything" : boolean;
        "minimapShape" : number;
        "blockTransparency" : boolean;
        "compassLocation" : number;
        "displayCurrentClaim" : boolean;
        "debugEntityVariantIds" : boolean;
        "arrowScale" : number;
        static readonly "ENTITY_ICONS_OPTIONS" : string[];
        "centeredEnlarged" : boolean;
        "waypointOpacityIngame" : number;
        "lightOverlayMaxLight" : number;
        "debugEntityIcons" : boolean;
        "temporaryWaypointsGlobal" : boolean;
        static readonly "ENTITY_NAMES_OPTIONS" : string[];
        static "keyTogglePacChunkClaims" : Internal.KeyMapping;
        static "keySwitchSet" : Internal.KeyMapping;
        get terrainDepth(): boolean;
        get waypointsIngameDistanceScale(): number;
        get entityRadar(): boolean;
        get showFlowers(): boolean;
        get oldDeathpoints(): boolean;
        get waypointsIngameIconScale(): number;
        get claimsOpacity(): number;
        get compassScale(): number;
        get minimap(): boolean;
        get useWorldMap(): boolean;
        get dotNameScale(): number;
        get displayRedstone(): boolean;
        get waypointsIngameNameScale(): number;
        get antiAliasing(): boolean;
        get blockColours(): number;
        get autoUIScale(): number;
        get minimapSize(): number;
        get minimapScale(): number;
        get showIngameWaypoints(): boolean;
        get showCoords(): boolean;
        get lighting(): boolean;
        get deathpoints(): boolean;
        get ignoreHeightmaps(): boolean;
        get dotsStyle(): number;
        get biomeColorsVanillaMode(): boolean;
        get showWaypoints(): boolean;
        get displayClaims(): boolean;
        get maxWaypointsDistance(): number;
        get terrainSlopes(): number;
        get entityRadarBackwardsCompatibilityConfig(): Internal.EntityRadarBackwardsCompatibilityConfig;
        get northCompassColor(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(modMain: Internal.AXaeroMinimap);
    }
    type ModSettings_ = ModSettings;
    /**
    * @javaClass dev.kosmx.playerAnim.core.util.Vec3f
    */
    class Vec3f extends Internal.Vector3<number> {
        squaredDistanceTo(vec3d: Internal.Vec3d_): number;
        add(other: Internal.Vec3f_): this;
        crossProduct(other: Internal.Vec3f_): this;
        subtract(rhs: Internal.Vec3f_): this;
        scale(scalar: number): this;
        dotProduct(other: Internal.Vec3f_): number;
        distanceTo(vec3d: Internal.Vec3d_): number;
        static readonly "ZERO" : Internal.Vec3f;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(x: number, y: number, z: number);
    }
    type Vec3f_ = Vec3f;
    /**
    * @javaClass net.minecraft.class_1275
    */
    interface Nameable {
        getName(): net.minecraft.network.chat.Component;
        getCustomName(): net.minecraft.network.chat.Component;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasCustomName(): boolean;
    }
    type Nameable_ = Nameable;
    /**
    * @javaClass net.voidz.access.ServerPlayerAccess
    */
    interface ServerPlayerAccess {
        getVoidPortingBlockPos(): BlockPos;
        setVoidPortingBlockPos(arg0: BlockPos_): void;
    }
    type ServerPlayerAccess_ = ServerPlayerAccess;
    /**
    * @javaClass dev.latvian.mods.kubejs.core.LivingEntityKJS
    */
    interface LivingEntityKJS {
        foodEatenKJS(is: Internal.ItemStack_): void;
    }
    type LivingEntityKJS_ = LivingEntityKJS;
    /**
    * @javaClass dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction
    */
    abstract class IngredientAction extends Internal.IngredientActionFilter {
        static readList(buf: Internal.FriendlyByteBuf_): Internal.List<Internal.IngredientAction>;
        toJson(json: Internal.JsonObject_): void;
        toJson(): Internal.JsonObject;
        transform(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.CraftingContainer_): Internal.ItemStack;
        static writeList(buf: Internal.FriendlyByteBuf_, list: Internal.List_<Internal.IngredientAction_>): void;
        getType(): string;
        static getRemaining(container: Internal.CraftingContainer_, index: number, ingredientActions: Internal.List_<Internal.IngredientAction_>): Internal.ItemStack;
        static parseList(json: Internal.JsonElement_): Internal.List<Internal.IngredientAction>;
        static readonly "FACTORY_MAP" : {"damage":any,"custom":any,"keep":any,"replace":any};
        get type(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type IngredientAction_ = IngredientAction;
    /**
    * @javaClass it.unimi.dsi.fastutil.chars.Char2DoubleFunction
    */
    interface Char2DoubleFunction extends it.unimi.dsi.fastutil.Function<string, number>, Internal.IntToDoubleFunction {
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: string, arg1: number): number;
        applyAsDouble(arg0: number): number;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Char2ShortFunction;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2DoubleFunction;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Char2IntFunction;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2DoubleFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        put(arg0: string, arg1: number): number;
        remove(arg0: string): number;
        remove(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        get(arg0: any): number;
        get(arg0: string): number;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Char2LongFunction;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2DoubleFunction;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Char2ByteFunction;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Char2FloatFunction;
        apply(arg0: string): number;
        containsKey(arg0: string): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2DoubleFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2DoubleFunction;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Char2CharFunction;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2DoubleFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2DoubleFunction;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2DoubleFunction;
    }
    type Char2DoubleFunction_ = ((arg0: string) => number) | Char2DoubleFunction;
    /**
    * @javaClass it.unimi.dsi.fastutil.bytes.Byte2ObjectFunction
    */
    interface Byte2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.IntFunction<V> {
        getOrDefault(arg0: any, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Byte2ShortFunction;
        composeByte(arg0: Internal.Byte2ByteFunction_): Internal.Byte2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Byte2IntFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        put(arg0: number, arg1: V): V;
        remove(arg0: number): V;
        remove(arg0: any): V;
        defaultReturnValue(): V;
        defaultReturnValue(arg0: V): void;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Byte2DoubleFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Byte2ObjectFunction<T>;
        get(arg0: any): V;
        get(arg0: number): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Byte2LongFunction;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2ObjectFunction<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Byte2ByteFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Byte2FloatFunction;
        apply(arg0: number): V;
        containsKey(arg0: any): boolean;
        containsKey(arg0: number): boolean;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Byte2CharFunction;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2ObjectFunction<V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Byte2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2ObjectFunction<V>;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2ObjectFunction<V>;
    }
    type Byte2ObjectFunction_<V> = ((arg0: number) => V) | Byte2ObjectFunction<V>;
    /**
    * @javaClass net.minecraft.class_3696
    */
    interface ProfileResults {
        getTimes(arg0: string): Internal.List<Internal.ResultField>;
        getStartTimeNano(): number;
        getStartTimeTicks(): number;
        getNanoDuration(): number;
        getEndTimeNano(): number;
        getTickDuration(): number;
        demanglePath($$0: string): string;
        getProfilerResults(): string;
        getEndTimeTicks(): number;
        saveResults(arg0: Internal.Path_): boolean;
    }
    type ProfileResults_ = ProfileResults;
    /**
    * @javaClass net.minecraft.class_5455$class_6893
    */
    interface RegistryAccess$Writable extends Internal.RegistryAccess {
        allElementsLifecycle(): Internal.Lifecycle;
        registry<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Optional<Internal.Registry<E>>;
        freeze(): Internal.RegistryAccess$Frozen;
        ownedWritableRegistryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.WritableRegistry<E>;
        ownedRegistryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Registry<E>;
        ownedWritableRegistry<E>(arg0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Optional<Internal.WritableRegistry<E>>;
        registries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
        registryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Registry<E>;
        networkSafeRegistries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
    }
    type RegistryAccess$Writable_ = RegistryAccess$Writable;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.Reference2LongFunction
    */
    interface Reference2LongFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToLongFunction<K> {
        getOrDefault(arg0: any, arg1: number): number;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Reference2ShortFunction<K>;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2LongFunction;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Reference2IntFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2LongFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        put(arg0: K, arg1: number): number;
        remove(arg0: any): number;
        defaultReturnValue(): number;
        defaultReturnValue(arg0: number): void;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Reference2DoubleFunction<K>;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Reference2ObjectFunction<K, T>;
        removeLong(arg0: any): number;
        get(arg0: any): number;
        andThenLong(arg0: Internal.Long2LongFunction_): Internal.Reference2LongFunction<K>;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2LongFunction;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Reference2ByteFunction<K>;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Reference2FloatFunction<K>;
        apply(arg0: K): number;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2LongFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2LongFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Reference2CharFunction<K>;
        getLong(arg0: any): number;
        applyAsLong(arg0: K): number;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2LongFunction<T>;
        size(): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2LongFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Reference2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2LongFunction;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2LongFunction;
    }
    type Reference2LongFunction_<K> = ((arg0: any) => number) | Reference2LongFunction<K>;
    /**
    * @javaClass net.minecraft.class_536
    */
    interface SpectatorMenuListener {
        onSpectatorMenuClosed(arg0: Internal.SpectatorMenu_): void;
    }
    type SpectatorMenuListener_ = SpectatorMenuListener;
    /**
    * @javaClass net.minecraft.class_5308
    */
    class NoiseSamplingSettings extends Internal.Record {
        yFactor(): number;
        xzScale(): number;
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        yScale(): number;
        xzFactor(): number;
        static readonly "CODEC" : Internal.Codec<Internal.NoiseSamplingSettings>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number, $$2: number, $$3: number);
    }
    type NoiseSamplingSettings_ = NoiseSamplingSettings;
    /**
    * @javaClass com.simibubi.create.content.contraptions.components.structureMovement.ContraptionWorld
    */
    class ContraptionWorld extends Internal.WrappedWorld {
        method_35230<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getMoonPhase(): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity_>): Internal.Player;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        getNearbyEntities<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        method_16359($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        method_8611($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxLightLevel(): number;
        getBrightness($$0: BlockPos_): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        isEmptyBlock($$0: BlockPos_): boolean;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        canSeeSky($$0: BlockPos_): boolean;
        method_23752($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        isWaterAt($$0: BlockPos_): boolean;
        getNearestEntity<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        getNearestEntity<T>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getRecipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        method_30271(): number;
        method_8320(pos: BlockPos_): Internal.BlockState;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        method_31605(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        method_8486(x: number, y: number, z: number, p_184134_7_: Internal.SoundEvent_, p_184134_8_: Internal.SoundSource_, p_184134_9_: number, p_184134_10_: number, p_184134_11_: boolean): void;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getMoonBrightness(): number;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        method_31607(): number;
        getLightEmission($$0: BlockPos_): number;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        toComponentPacket<C>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        hasChunkAt($$0: BlockPos_): boolean;
        hasChunkAt($$0: number, $$1: number): boolean;
        method_8393($$0: number, $$1: number): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        method_8598($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        noCollision($$0: Internal.Entity_): boolean;
        noCollision($$0: Internal.AABB_): boolean;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        method_20743($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        asKJS(): Internal.LevelJS;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_): Internal.List<T>;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getTimeOfDay($$0: number): number;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_): void;
        gameEvent($$0: Internal.GameEvent_, $$1: Internal.Entity_): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Internal.Entity_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        method_8465(player: Internal.Player_, x: number, y: number, z: number, soundIn: Internal.SoundEvent_, category: Internal.SoundSource_, volume: number, pitch: number): void;
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getDifficulty(): Internal.Difficulty;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        get difficulty(): Internal.Difficulty;
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>;
        get recipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        get moonPhase(): number;
        get maxLightLevel(): number;
        get moonBrightness(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(world: Internal.Level, contraption: Internal.Contraption);
    }
    type ContraptionWorld_ = ContraptionWorld;
    /**
    * @javaClass net.minecraft.class_1669
    */
    class EvokerFangs extends Internal.Entity {
        canRiderInteract(): boolean;
        method_18002(): Internal.Packet<any>;
        method_5711($$0: number): void;
        getAnimationProgress($$0: number): number;
        getStepHeight(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getOwner(): Internal.LivingEntity;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        method_5773(): void;
        setOwner($$0: Internal.LivingEntity_): void;
        static readonly "ATTACK_DURATION" : 20;
        static readonly "ATTACK_TRIGGER_TICKS" : 14;
        static readonly "LIFE_OFFSET" : 2;
        get owner(): Internal.LivingEntity;
        get stepHeight(): number;
        set owner($$0: Internal.LivingEntity_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.EvokerFangs>, $$1: Internal.Level);
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.LivingEntity);
    }
    type EvokerFangs_ = EvokerFangs;
    /**
    * @javaClass java.awt.SecondaryLoop
    */
    interface SecondaryLoop {
        exit(): boolean;
        enter(): boolean;
    }
    type SecondaryLoop_ = SecondaryLoop;
    /**
    * @javaClass net.minecraft.class_1535
    */
    class Motive {
        getHeight(): number;
        getWidth(): number;
        static readonly "PLANT" : Internal.Motive;
        static readonly "DONKEY_KONG" : Internal.Motive;
        static readonly "KEBAB" : Internal.Motive;
        static readonly "SKELETON" : Internal.Motive;
        static readonly "WITHER" : Internal.Motive;
        static readonly "ALBAN" : Internal.Motive;
        static readonly "CREEBET" : Internal.Motive;
        static readonly "PIGSCENE" : Internal.Motive;
        static readonly "BURNING_SKULL" : Internal.Motive;
        static readonly "SUNSET" : Internal.Motive;
        static readonly "STAGE" : Internal.Motive;
        static readonly "AZTEC" : Internal.Motive;
        static readonly "FIGHTERS" : Internal.Motive;
        static readonly "BUST" : Internal.Motive;
        static readonly "COURBET" : Internal.Motive;
        static readonly "SEA" : Internal.Motive;
        static readonly "WANDERER" : Internal.Motive;
        static readonly "SKULL_AND_ROSES" : Internal.Motive;
        static readonly "GRAHAM" : Internal.Motive;
        static readonly "POINTER" : Internal.Motive;
        static readonly "POOL" : Internal.Motive;
        static readonly "VOID" : Internal.Motive;
        static readonly "BOMB" : Internal.Motive;
        static readonly "MATCH" : Internal.Motive;
        static readonly "AZTEC2" : Internal.Motive;
        static readonly "WASTELAND" : Internal.Motive;
        get width(): number;
        get height(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number);
    }
    type Motive_ = Special.Motive | Motive;
    /**
    * @javaClass java.awt.Composite
    */
    interface Composite {
        createContext(arg0: Internal.ColorModel_, arg1: Internal.ColorModel_, arg2: Internal.RenderingHints_): Internal.CompositeContext;
    }
    type Composite_ = Composite;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.RenderTargetExtensions
    */
    interface RenderTargetExtensions {
        enableStencil(): void;
        disableStencil(): void;
        isStencilEnabled(): boolean;
    }
    type RenderTargetExtensions_ = RenderTargetExtensions;
    /**
    * @javaClass me.shedaniel.rei.api.client.gui.AbstractRenderer
    */
    abstract class AbstractRenderer extends Internal.GuiComponent implements Internal.Renderer {
        fillCrashReport(report: Internal.CrashReport_, category: Internal.CrashReportCategory_): void;
        getTooltip(context: Internal.TooltipContext_): Internal.Tooltip;
        getTooltip(mouse: me.shedaniel.math.Point_): Internal.Tooltip;
        getZ(): number;
        setZ(z: number): void;
        get z(): number;
        set z(z: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AbstractRenderer_ = AbstractRenderer;
    /**
    * @javaClass net.minecraft.class_3233
    */
    class WorldGenRegion implements Internal.WorldGenLevel, Internal.ChunkRegionAccessor, Internal.WorldGenRegionAccessor, com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor {
        method_8409(): Internal.Random;
        method_8649($$0: Internal.Entity_): boolean;
        method_8406($$0: Internal.ParticleOptions_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): void;
        getSectionsCount(): number;
        method_35230<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        method_24852($$0: Internal.Direction_, $$1: boolean): number;
        getMoonPhase(): number;
        method_35237($$0: BlockPos_, $$1: Internal.Predicate_<Internal.FluidState_>): boolean;
        method_8650($$0: BlockPos_, $$1: boolean): boolean;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        method_30349(): Internal.RegistryAccess;
        method_8412(): number;
        method_8410(): Internal.ServerLevel;
        getSectionIndex($$0: number): number;
        method_18456(): Internal.List<Internal.Player>;
        method_32888($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getMinSection(): number;
        method_22385(): Internal.BiomeManager;
        method_22387($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        method_23752($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMaxBuildHeight(): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        method_8401(): Internal.LevelData;
        method_31605(): number;
        method_36972($$0: Internal.Supplier_<string>): void;
        method_8405(): Internal.LevelTickAccess<Internal.Fluid>;
        method_8404($$0: BlockPos_): Internal.DifficultyInstance;
        method_8402($$0: number, $$1: number, $$2: Internal.ChunkStatus_, $$3: boolean): Internal.ChunkAccess;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        method_31607(): number;
        method_8393($$0: number, $$1: number): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        method_8392($$0: number, $$1: number): Internal.ChunkAccess;
        method_8397(): Internal.LevelTickAccess<Internal.Block>;
        method_8396($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_, $$4: number, $$5: number): void;
        getSectionYFromSectionIndex($$0: number): number;
        method_8398(): Internal.ChunkSource;
        method_8316($$0: BlockPos_): Internal.FluidState;
        method_18023<T>($$0: Internal.EntityTypeTest_<Internal.Entity_, T>, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        noCollision($$0: Internal.Entity_): boolean;
        noCollision($$0: Internal.AABB_): boolean;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        method_30093($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_, $$3: number): boolean;
        method_30092($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number, $$3: number): boolean;
        method_20743($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getTimeOfDay($$0: number): number;
        method_39224(): number;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getMaxSection(): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        getCenter(): Internal.ChunkPos;
        addFreshEntityWithPassengers($$0: Internal.Entity_): void;
        method_8604($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity_>): Internal.Player;
        method_8608(): boolean;
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getNearbyEntities<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        method_16359($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        method_8333($$0: Internal.Entity_, $$1: Internal.AABB_, $$2: Internal.Predicate_<Internal.Entity_>): Internal.List<Internal.Entity>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        method_8611($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        method_16358($$0: BlockPos_, $$1: Internal.Predicate_<Internal.BlockState_>): boolean;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getBrightness($$0: BlockPos_): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        isEmptyBlock($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getNearestEntity<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        getNearestEntity<T>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        method_30271(): number;
        method_8320($$0: BlockPos_): Internal.BlockState;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        method_8444($$0: Internal.Player_, $$1: number, $$2: BlockPos_, $$3: number): void;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        method_8321($$0: BlockPos_): Internal.BlockEntity;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getMoonBrightness(): number;
        method_22336(): Internal.LevelLightEngine;
        method_22338($$0: number, $$1: number): Internal.BlockGetter;
        getLightEmission($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        hasChunkAt($$0: BlockPos_): boolean;
        hasChunkAt($$0: number, $$1: number): boolean;
        method_8594(): number;
        method_8598($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        method_8597(): Internal.DimensionType;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        method_8615(): number;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_): Internal.List<T>;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_): void;
        gameEvent($$0: Internal.GameEvent_, $$1: Internal.Entity_): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Internal.Entity_): void;
        method_8621(): Internal.WorldBorder;
        method_37368($$0: BlockPos_): boolean;
        getDifficulty(): Internal.Difficulty;
        method_8624($$0: Internal.Heightmap$Types_, $$1: number, $$2: number): number;
        method_8503(): Internal.MinecraftServer;
        get difficulty(): Internal.Difficulty;
        get minSection(): number;
        get center(): Internal.ChunkPos;
        get maxSection(): number;
        get sectionsCount(): number;
        get moonPhase(): number;
        get maxLightLevel(): number;
        get maxBuildHeight(): number;
        get moonBrightness(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ServerLevel, $$1: Internal.List<Internal.ChunkAccess>, $$2: Internal.ChunkStatus, $$3: number);
    }
    type WorldGenRegion_ = WorldGenRegion;
    /**
    * @javaClass xaero.common.interfaces.pushbox.FullHeightShiftPushBox
    */
    abstract class FullHeightShiftPushBox extends Internal.PushBox {
        getH(width: number, height: number): number;
        update(): void;
        push(ii: Internal.InterfaceInstance_, i: Internal.Interface_, interfaceX: number, interfaceY: number, interfaceW: number, interfaceH: number, pushX: number, pushY: number, width: number, height: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(x: number, w: number, anchorX: number);
    }
    type FullHeightShiftPushBox_ = FullHeightShiftPushBox;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.mixin.common.accessor.SlimeAccessor
    */
    interface SlimeAccessor {
        port_lib$setSize(arg0: number, arg1: boolean): void;
    }
    type SlimeAccessor_ = SlimeAccessor;
    /**
    * @javaClass java.util.stream.Collector$Characteristics
    */
    class Collector$Characteristics extends Internal.Enum<Internal.Collector$Characteristics> {
        static valueOf(arg0: string): Internal.Collector$Characteristics;
        static values(): Internal.Collector$Characteristics[];
        static readonly "IDENTITY_FINISH" : Internal.Collector$Characteristics;
        static readonly "UNORDERED" : Internal.Collector$Characteristics;
        static readonly "CONCURRENT" : Internal.Collector$Characteristics;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Collector$Characteristics_ = "unordered" | "identity_finish" | "concurrent" | Collector$Characteristics;
    /**
    * @javaClass net.minecraft.class_4885
    */
    interface ReflectionBasedSerialization {
    }
    type ReflectionBasedSerialization_ = ReflectionBasedSerialization;
    /**
    * @javaClass dev.latvian.mods.kubejs.player.ClientPlayerDataJS
    */
    class ClientPlayerDataJS extends Internal.PlayerDataJS<Internal.Player, Internal.ClientPlayerJS> {
        getLevel(): Internal.ClientLevelJS;
        getPlayer(): Internal.ClientPlayerJS;
        getMinecraftPlayer(): Internal.Player;
        getName(): string;
        getProfile(): Internal.GameProfile;
        getId(): Internal.UUID;
        getOverworld(): Internal.LevelJS;
        get level(): Internal.ClientLevelJS;
        get minecraftPlayer(): Internal.Player;
        get profile(): Internal.GameProfile;
        get name(): string;
        get id(): Internal.UUID;
        get overworld(): Internal.LevelJS;
        get player(): Internal.ClientPlayerJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(l: Internal.ClientLevelJS, p: Internal.Player, s: boolean);
    }
    type ClientPlayerDataJS_ = ClientPlayerDataJS;
    /**
    * @javaClass de.keksuccino.fancymenu.mixin.client.IMixinScreen
    */
    interface IMixinScreen {
        setItemRendererFancyMenu(arg0: Internal.ItemRenderer_): void;
        setFontFancyMenu(arg0: net.minecraft.client.gui.Font_): void;
        getRenderablesFancyMenu(): Internal.List<Internal.Widget>;
    }
    type IMixinScreen_ = IMixinScreen;
    /**
    * @javaClass net.minecraft.class_1641
    */
    class ZombieVillager extends Internal.Zombie implements Internal.VillagerDataHolder {
        method_5711($$0: number): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_6011($$0: Internal.DamageSource_): Internal.SoundEvent;
        method_6017(): number;
        alwaysAccepts(): boolean;
        method_7207(): Internal.SoundEvent;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        isConverting(): boolean;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        setVillagerXp($$0: number): void;
        method_7231(): Internal.VillagerData;
        setGossips($$0: net.minecraft.nbt.Tag_): void;
        method_7195($$0: Internal.VillagerData_): void;
        method_6002(): Internal.SoundEvent;
        getVillagerXp(): number;
        method_5992($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        method_5974($$0: number): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        method_5994(): Internal.SoundEvent;
        setTradeOffers($$0: Internal.CompoundTag_): void;
        get villagerXp(): number;
        get converting(): boolean;
        get stepHeight(): number;
        set tradeOffers($$0: Internal.CompoundTag_);
        set gossips($$0: net.minecraft.nbt.Tag_);
        set villagerXp($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.ZombieVillager>, $$1: Internal.Level);
    }
    type ZombieVillager_ = ZombieVillager;
    /**
    * @javaClass de.dafuqs.spectrum.mixin.accessors.MooshroomEntityAccessor
    */
    interface MooshroomEntityAccessor {
        setStewEffectDuration(arg0: number): void;
        getStewEffectDuration(): number;
        getStewEffect(): Internal.MobEffect;
        setStewEffect(arg0: Internal.MobEffect_): void;
    }
    type MooshroomEntityAccessor_ = MooshroomEntityAccessor;
    /**
    * @javaClass net.minecraft.class_6749
    */
    class BlendingData {
        oldNoise(): boolean;
        static getOrUpdateBlendingData($$0: Internal.WorldGenRegion_, $$1: number, $$2: number): Internal.BlendingData;
        static sideByGenerationAge($$0: Internal.WorldGenLevel_, $$1: number, $$2: number, $$3: boolean): Internal.Set<Internal.Direction8>;
        static readonly "CODEC" : Internal.Codec<Internal.BlendingData>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BlendingData_ = BlendingData;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.ui.BaseScreen
    */
    abstract class BaseScreen extends Internal.Panel implements Internal.IOpenableScreen {
        closeGui(openPrevScreen: boolean): void;
        closeGui(): void;
        shouldAddMouseOverText(): boolean;
        run(): void;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        closeContextMenu(): void;
        getGui(): this;
        openYesNo(title: net.minecraft.network.chat.Component_, desc: net.minecraft.network.chat.Component_, callback: Internal.Runnable_): void;
        mousePressed(button: Internal.MouseButton_): boolean;
        getScrollX(): number;
        getScrollY(): number;
        drawForeground(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        onInit(): boolean;
        drawBackground(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        getPartialTicks(): number;
        openGuiLater(): void;
        updateMouseOver(mouseX: number, mouseY: number): void;
        drawDefaultBackground(matrixStack: Internal.PoseStack_): boolean;
        getScreen(): com.mojang.blaze3d.platform.Window;
        getMouseY(): number;
        onClosed(): void;
        isMouseOver(x: number, y: number, w: number, h: number): boolean;
        isMouseOver(widget: dev.ftb.mods.ftblibrary.ui.Widget_): boolean;
        getTheme(): Internal.Theme;
        updateGui(mx: number, my: number, pt: number): void;
        getMouseX(): number;
        keyPressed(key: dev.ftb.mods.ftblibrary.ui.input.Key_): boolean;
        openGui(): void;
        doesGuiPauseGame(): boolean;
        getPrevScreen(): Internal.Screen;
        initGui(): void;
        draw(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        onBack(): void;
        getX(): number;
        openContextMenu(panel: Internal.Panel_): void;
        openContextMenu(menu: Internal.List_<Internal.ContextMenuItem_>): Internal.ContextMenu;
        getY(): number;
        handleClick(scheme: string, path: string): boolean;
        refreshWidgets(): void;
        alignWidgets(): void;
        openYesNoFull(title: net.minecraft.network.chat.Component_, desc: net.minecraft.network.chat.Component_, callback: Internal.BooleanConsumer_): void;
        onPostInit(): void;
        setScrollX(scroll: number): void;
        setScrollY(scroll: number): void;
        onClosedByKey(key: dev.ftb.mods.ftblibrary.ui.input.Key_): boolean;
        "itemRenderer" : Internal.ItemRenderer;
        "contextMenu" : Internal.Panel;
        get mouseX(): number;
        get prevScreen(): Internal.Screen;
        get mouseY(): number;
        get x(): number;
        get screen(): com.mojang.blaze3d.platform.Window;
        get y(): number;
        get gui(): this;
        get scrollY(): number;
        get theme(): Internal.Theme;
        get scrollX(): number;
        get partialTicks(): number;
        set scrollY(scroll: number);
        set scrollX(scroll: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type BaseScreen_ = BaseScreen;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.HoeItemBuilder
    */
    class HoeItemBuilder extends Internal.HandheldItemBuilder {
        createObject(): Internal.Item;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type HoeItemBuilder_ = HoeItemBuilder;
    /**
    * @javaClass dev.latvian.mods.kubejs.player.PlayerAdvancementEventJS
    */
    class PlayerAdvancementEventJS extends Internal.PlayerEventJS {
        getAdvancement(): Internal.AdvancementJS;
        getEntity(): Internal.EntityJS;
        canCancel(): boolean;
        get advancement(): Internal.AdvancementJS;
        get entity(): Internal.EntityJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(player: Internal.ServerPlayer, advancement: Internal.Advancement);
    }
    type PlayerAdvancementEventJS_ = PlayerAdvancementEventJS;
    /**
    * @javaClass net.minecraft.class_2799
    */
    class ServerboundClientCommandPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getAction(): Internal.ServerboundClientCommandPacket$Action;
        isSkippable(): boolean;
        get action(): Internal.ServerboundClientCommandPacket$Action;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ServerboundClientCommandPacket$Action);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ServerboundClientCommandPacket_ = ServerboundClientCommandPacket;
    /**
    * @javaClass net.minecraft.class_3803
    */
    class GrindstoneMenu extends Internal.AbstractContainerMenu {
        method_7609($$0: net.minecraft.world.Container_): void;
        modify$jah000$enchantmentOnGrinds(enchantments: Internal.Map_<any, any>, stack: Internal.ItemStack_): Internal.Map<any, any>;
        method_7597($$0: Internal.Player_): boolean;
        method_7595($$0: Internal.Player_): void;
        method_7601($$0: Internal.Player_, $$1: number): Internal.ItemStack;
        static readonly "INPUT_SLOT" : 0;
        static readonly "RESULT_SLOT" : 2;
        static readonly "ADDITIONAL_SLOT" : 1;
        static readonly "MAX_NAME_LENGTH" : 35;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: Internal.Inventory);
        constructor($$0: number, $$1: Internal.Inventory, $$2: Internal.ContainerLevelAccess);
    }
    type GrindstoneMenu_ = GrindstoneMenu;
    /**
    * @javaClass net.minecraft.class_4599
    */
    class RenderBuffers implements Internal.AccessorRenderBuffers, Internal.DrawCallTrackingRenderBuffers, Internal.RenderBuffersExt, Internal.MemoryTrackingRenderBuffers {
        endLevelRendering(): void;
        getMiscBufferAllocatedSize(): number;
        getDrawCalls(): number;
        resetDrawCounts(): void;
        getMaxBegins(): number;
        fixedBufferPack(): Internal.ChunkBufferBuilderPack;
        beginLevelRendering(): void;
        getRenderTypes(): number;
        outlineBufferSource(): Internal.OutlineBufferSource;
        bufferSource(): Internal.MultiBufferSource$BufferSource;
        getEntityBufferAllocatedSize(): number;
        freeAndDeleteBuffers(): void;
        crumblingBufferSource(): Internal.MultiBufferSource$BufferSource;
        get renderTypes(): number;
        get entityBufferAllocatedSize(): number;
        get miscBufferAllocatedSize(): number;
        get drawCalls(): number;
        get maxBegins(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type RenderBuffers_ = RenderBuffers;
    /**
    * @javaClass net.minecraft.class_5605
    */
    class CubeDeformation {
        extend($$0: number, $$1: number, $$2: number): this;
        extend($$0: number): this;
        static readonly "NONE" : Internal.CubeDeformation;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number, $$2: number);
        constructor($$0: number);
    }
    type CubeDeformation_ = CubeDeformation;
    /**
    * @javaClass xaero.common.category.ObjectCategory
    */
    abstract class ObjectCategory <D, C> {
        setSettingValue<T>(setting: Internal.ObjectCategorySetting_<T>, value: T): void;
        getName(): string;
        getDirectSubCategoryIterator(): Internal.Iterator<C>;
        getSuperCategory(): C;
        getProtection(): boolean;
        getSettingOverridesIterator(): Internal.Iterator<Internal.Map$Entry<Internal.ObjectCategorySetting<any>, any>>;
        getSettingValue<T>(setting: Internal.ObjectCategorySetting_<T>): T;
        get superCategory(): C;
        get name(): string;
        get protection(): boolean;
        get directSubCategoryIterator(): Internal.Iterator<C>;
        get settingOverridesIterator(): Internal.Iterator<Internal.Map$Entry<Internal.ObjectCategorySetting<any>, any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ObjectCategory_<D, C> = ObjectCategory<D, C>;
    /**
    * @javaClass net.minecraft.class_310
    */
    class Minecraft extends Internal.ReentrantBlockableEventLoop<Internal.Runnable> implements Internal.WindowEventHandler, Internal.MinecraftClientExtension, Internal.MinecraftAccessor, Internal.ClientUtils, Internal.MinecraftClientAccessor, Internal.MinecraftClient_BetterCombat, Internal.AccessorMinecraft, vazkii.botania.mixin.client.AccessorMinecraft, tfar.dankstorage.mixin.MinecraftClientAccessor, net.fabricmc.fabric.mixin.networking.accessor.MinecraftClientAccessor, Internal.IMixinMinecraft, Internal.PausedPartialTickAccessor, Internal.ClientAccess, me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor, Internal.AccessorMinecraftClient, Internal.IFakeMinecraft {
        handler$jcf003$onTickStart(info: Internal.CallbackInfo_): void;
        handler$jbj000$onOpenScreen(screen_1: Internal.Screen_, info: Internal.CallbackInfo_): void;
        getPlayerSocialManager(): Internal.PlayerSocialManager;
        shouldEntityAppearGlowing($$0: Internal.Entity_): boolean;
        debugFpsMeterKeyPress($$0: number): void;
        handler$zbj000$port_lib$registerParticleManagers(gameConfiguration: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        clearLevel(): void;
        clearLevel($$0: Internal.Screen_): void;
        getTextureAtlas($$0: ResourceLocation_): Internal.Function<ResourceLocation, Internal.TextureAtlasSprite>;
        handler$ibp000$spectrum$getMusicType(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$fcb000$iris$trackLastDimensionOnLeave(arg0: Internal.Screen_, arg1: Internal.CallbackInfo_): void;
        handler$zma003$tick(info: Internal.CallbackInfo_): void;
        handler$zma000$onRightClick(info: Internal.CallbackInfo_): void;
        getResourcePackRepository(): Internal.PackRepository;
        static crash($$0: Internal.CrashReport_): void;
        setLevel($$0: Internal.ClientLevel_): void;
        toggleMobLevelRenderer(): void;
        getVersionType(): string;
        getGame(): Internal.Game;
        handler$eoc000$runTick(tickWorld: boolean, callbackInfo: Internal.CallbackInfo_): void;
        getProgressListener(): Internal.StoringChunkProgressListener;
        isPaused(): boolean;
        handler$jbj001$onTickStart(info: Internal.CallbackInfo_): void;
        getSkinManager(): Internal.SkinManager;
        getCurrentServer(): Internal.ServerData;
        makeWorldStem($$0: Internal.PackRepository_, $$1: boolean, $$2: Internal.WorldStem$DataPackConfigSupplier_, $$3: Internal.WorldStem$WorldDataSupplier_): Internal.WorldStem;
        makeWorldStem($$0: Internal.LevelStorageSource$LevelStorageAccess_, $$1: boolean): Internal.WorldStem;
        getGpuWarnlistManager(): Internal.GpuWarnlistManager;
        destroy(): void;
        static useAmbientOcclusion(): boolean;
        getChatStatus(): Internal.Minecraft$ChatStatus;
        getLaunchedVersion(): string;
        getSingleplayerServer(): Internal.IntegratedServer;
        handler$jcf001$onOpenScreen(screen_1: Internal.Screen_, info: Internal.CallbackInfo_): void;
        getResourceFromResourceLocation(arg0: ResourceLocation_): Internal.InputStream;
        stop(): void;
        is64Bit(): boolean;
        handler$zma000$onLeftClick(info: Internal.CallbackInfo_): void;
        renderOnThread(): boolean;
        updateTitle(): void;
        localvar$bdh001$modifyScreen(screen: Internal.Screen_): Internal.Screen;
        getProfiler(): Internal.ProfilerFiller;
        getProxy(): Internal.Proxy;
        isBlocked($$0: Internal.UUID_): boolean;
        getSituationalMusic(): Internal.Music;
        getLevelSource(): Internal.LevelStorageSource;
        handler$dnf000$cancelItemPick(info: Internal.CallbackInfo_): void;
        getFrameTimer(): Internal.FrameTimer;
        hasSingleplayerServer(): boolean;
        getCursorTarget(): Internal.Entity;
        getFixerUpper(): Internal.DataFixer;
        static renderNames(): boolean;
        handler$hbf001$runTick(tickWorld: boolean, callbackInfo: Internal.CallbackInfo_): void;
        setScreen($$0: Internal.Screen_): void;
        close(): void;
        handler$eam000$disconnectAfter(screen_1: Internal.Screen_, info: Internal.CallbackInfo_): void;
        getRollManager(): Internal.RollManager;
        pauseGame($$0: boolean): void;
        hasTargetsInRange(): boolean;
        handler$bdh000$startUseItem(callbackInfo: Internal.CallbackInfo_, hands: Hand_[], var2: number, var3: number, hand: Hand_): void;
        isTextFilteringEnabled(): boolean;
        createLevel($$0: string, $$1: Internal.LevelSettings_, $$2: Internal.RegistryAccess_, $$3: Internal.WorldGenSettings_): void;
        handler$efa000$onGetWindowTitle(info: Internal.CallbackInfoReturnable_<any>): void;
        setConnectedToRealms($$0: boolean): void;
        getMinecraftSessionService(): Internal.MinecraftSessionService;
        getToasts(): Internal.ToastComponent;
        method_30133(): void;
        updateMaxMipLevel($$0: number): void;
        getSwingProgress(): number;
        clearResourcePacksOnError($$0: Internal.Throwable_, $$1: net.minecraft.network.chat.Component_): void;
        handler$faf00c$tick(ci: Internal.CallbackInfo_): void;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle_<Source>, Internal.Runnable_>): Internal.CompletableFuture<Source>;
        handler$zbj000$port_lib$mcTail(gameConfiguration: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        getMusicManager(): Internal.MusicManager;
        handler$zbj000$port_lib$initModelRegistry(gameConfig: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        handler$gjc000$patchouli_onLogout(screen: Internal.Screen_, info: Internal.CallbackInfo_): void;
        getProfileProperties(): Internal.PropertyMap;
        getLanguageManager(): Internal.LanguageManager;
        getItemRenderer(): Internal.ItemRenderer;
        run(): void;
        setCameraEntity($$0: Internal.Entity_): void;
        getResourceManager(): Internal.ResourceManager;
        getTutorial(): Internal.Tutorial;
        isDemo(): boolean;
        debugClientMetricsStart($$0: Internal.Consumer_<Internal.TranslatableComponent_>): boolean;
        handler$zon000$cancelSetScreen(screen: Internal.Screen_, ci: Internal.CallbackInfo_): void;
        handler$dih000$getMainRenderTarget(ci: Internal.CallbackInfoReturnable_<any>): void;
        handler$jbj000$onDisconnect(screen_1: Internal.Screen_, info: Internal.CallbackInfo_): void;
        handler$jcf001$onDisconnect(screen_1: Internal.Screen_, info: Internal.CallbackInfo_): void;
        getMainRenderTarget(): Internal.RenderTarget;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle_<Internal.Either_<Source, Internal.Exception_>>, Internal.Runnable_>): Internal.CompletableFuture<Source>;
        handler$jcf001$onJoinWorld(newWorld: Internal.ClientLevel_, info: Internal.CallbackInfo_): void;
        getEntityModels(): Internal.EntityModelSet;
        static useFancyGraphics(): boolean;
        getMobEffectTextures(): Internal.MobEffectTextureManager;
        getPaintingTextures(): Internal.PaintingTextureManager;
        getTextureManager(): Internal.TextureManager;
        allowsRealms(): boolean;
        forceSetScreen($$0: Internal.Screen_): void;
        isLocalServer(): boolean;
        handler$clc000$Minecraft_createUserApiService(yggdrasilAuthenticationService: Internal.YggdrasilAuthenticationService_, gameConfig: Internal.GameConfig_, cir: Internal.CallbackInfoReturnable_<any>): void;
        setUnfinishedSpell(value: boolean): void;
        getClientPackSource(): Internal.ClientPackSource;
        getBlockEntityRenderDispatcher(): Internal.BlockEntityRenderDispatcher;
        handler$dfo000$getMusicType(info: Internal.CallbackInfoReturnable_<any>): void;
        cancelUpswing(): void;
        tick(): void;
        handler$hen000$revelationary$onLogout(screen: Internal.Screen_, info: Internal.CallbackInfo_): void;
        delayCrash($$0: Internal.Supplier_<Internal.CrashReport_>): void;
        grabPanoramixScreenshot($$0: Internal.File_, $$1: number, $$2: number): net.minecraft.network.chat.Component;
        reloadResourcePacks(): Internal.CompletableFuture<void>;
        getUpswingTicks(): number;
        fillReport($$0: Internal.CrashReport_): Internal.CrashReport;
        static fillReport($$0: Internal.Minecraft_, $$1: Internal.LanguageManager_, $$2: string, $$3: Internal.Options_, $$4: Internal.CrashReport_): void;
        getComboCount(): number;
        showMobNameplate(): boolean;
        getDeltaFrameTime(): number;
        getBlockRenderer(): Internal.BlockRenderDispatcher;
        getSearchTree<T>($$0: Internal.SearchRegistry$Key_<T>): Internal.MutableSearchTree<T>;
        setTimer(value: number): void;
        setOverlay($$0: Internal.Overlay_): void;
        setCurrentServer($$0: Internal.ServerData_): void;
        handler$ipf000$getMusicTypeMixin(info: Internal.CallbackInfoReturnable_<any>): void;
        getWindow(): com.mojang.blaze3d.platform.Window;
        renderBuffers(): Internal.RenderBuffers;
        getUser(): Internal.User;
        getCameraEntity(): Internal.Entity;
        handler$flb000$onClientTickPost(info: Internal.CallbackInfo_): void;
        getModelManager(): Internal.ModelManager;
        createTelemetryManager(): Internal.ClientTelemetryManager;
        getSoundManager(): Internal.SoundManager;
        getFrameTime(): number;
        getConnection(): Internal.ClientPacketListener;
        prepareForMultiplayer(): void;
        isRunning(): boolean;
        shouldPlaySerpentMusic(bossBarHud: Internal.BossHealthOverlay_): boolean;
        handler$jbj000$onJoinWorld(newWorld: Internal.ClientLevel_, info: Internal.CallbackInfo_): void;
        localvar$dnf000$modifyItemPick(stack: Internal.ItemStack_): Internal.ItemStack;
        localvar$zon000$modifyScreen(screen: Internal.Screen_): Internal.Screen;
        getBlockColors(): Internal.BlockColors;
        handler$flb000$onClientTickPre(info: Internal.CallbackInfo_): void;
        getOverlay(): Internal.Overlay;
        handler$zbj000$port_lib$modsLoaded(gameConfig: Internal.GameConfig_, ci: Internal.CallbackInfo_): void;
        getHotbarManager(): Internal.HotbarManager;
        isWindowActive(): boolean;
        getResourcePackDirectory(): Internal.File;
        handler$zbj000$port_lib$onHeadJoinWorld(world: Internal.ClientLevel_, ci: Internal.CallbackInfo_): void;
        handler$zbj000$port_lib$onDisconnect(screen: Internal.Screen_, ci: Internal.CallbackInfo_): void;
        showOnlyReducedInfo(): boolean;
        isEnforceUnicode(): boolean;
        getSplashManager(): Internal.SplashManager;
        isConnectedToRealms(): boolean;
        getItemInHandRenderer(): Internal.ItemInHandRenderer;
        delayTextureReload(): Internal.CompletableFuture<void>;
        getEntityRenderDispatcher(): Internal.EntityRenderDispatcher;
        static useShaderTransparency(): boolean;
        allowsMultiplayer(): boolean;
        method_15995($$0: boolean): void;
        method_15993(): void;
        static getInstance(): Internal.Minecraft;
        getPattern(): Internal.List<any>;
        emergencySave(): void;
        static checkModStatus(): Internal.ModCheck;
        loadLevel($$0: string): void;
        readonly "itemColors" : Internal.ItemColors;
        "crosshairPickEntity" : Internal.Entity;
        "screen" : Internal.Screen;
        "cameraEntity" : Internal.Entity;
        static readonly "ON_OSX" : false;
        readonly "mouseHandler" : Internal.MouseHandler;
        static readonly "UNIFORM_FONT" : ResourceLocation;
        readonly "gameRenderer" : Internal.GameRenderer;
        "wireframe" : boolean;
        "chunkVisibility" : boolean;
        readonly "options" : Internal.Options;
        readonly "frameTimer" : Internal.FrameTimer;
        "chunkPath" : boolean;
        readonly "levelRenderer" : Internal.LevelRenderer;
        static readonly "RESOURCE_RELOAD_INITIAL_TASK" : Internal.CompletableFuture<Internal.Unit>;
        "player" : Internal.LocalPlayer;
        "level" : Internal.ClientLevel;
        "rightClickDelay" : number;
        readonly "gameDirectory" : Internal.File;
        static "fps" : 138;
        readonly "debugRenderer" : Internal.DebugRenderer;
        "toast" : Internal.ToastComponent;
        "noRender" : boolean;
        static readonly "DEFAULT_FONT" : ResourceLocation;
        "fpsString" : string;
        readonly "keyboardHandler" : Internal.KeyboardHandler;
        static readonly "UPDATE_DRIVERS_ADVICE" : "Please make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).";
        readonly "particleEngine" : Internal.ParticleEngine;
        readonly "gui" : Internal.Gui;
        readonly "blockColors" : Internal.BlockColors;
        "gameMode" : Internal.MultiPlayerGameMode;
        static readonly "ALT_FONT" : ResourceLocation;
        "hitResult" : Internal.HitResult;
        "smartCull" : boolean;
        readonly "font" : net.minecraft.client.gui.Font;
        get itemRenderer(): Internal.ItemRenderer;
        get clientPackSource(): Internal.ClientPackSource;
        get paused(): boolean;
        get instance(): Internal.Minecraft;
        get musicManager(): Internal.MusicManager;
        get mobEffectTextures(): Internal.MobEffectTextureManager;
        get mainRenderTarget(): Internal.RenderTarget;
        get progressListener(): Internal.StoringChunkProgressListener;
        get toasts(): Internal.ToastComponent;
        get hotbarManager(): Internal.HotbarManager;
        get entityModels(): Internal.EntityModelSet;
        get upswingTicks(): number;
        get connection(): Internal.ClientPacketListener;
        get itemInHandRenderer(): Internal.ItemInHandRenderer;
        get resourceManager(): Internal.ResourceManager;
        get versionType(): string;
        get situationalMusic(): Internal.Music;
        get overlay(): Internal.Overlay;
        get playerSocialManager(): Internal.PlayerSocialManager;
        get frameTime(): number;
        get deltaFrameTime(): number;
        get localServer(): boolean;
        get profiler(): Internal.ProfilerFiller;
        get languageManager(): Internal.LanguageManager;
        get paintingTextures(): Internal.PaintingTextureManager;
        get cursorTarget(): Internal.Entity;
        get proxy(): Internal.Proxy;
        get skinManager(): Internal.SkinManager;
        get minecraftSessionService(): Internal.MinecraftSessionService;
        get entityRenderDispatcher(): Internal.EntityRenderDispatcher;
        get modelManager(): Internal.ModelManager;
        get game(): Internal.Game;
        get comboCount(): number;
        get gpuWarnlistManager(): Internal.GpuWarnlistManager;
        get enforceUnicode(): boolean;
        get swingProgress(): number;
        get pattern(): Internal.List<any>;
        get textFilteringEnabled(): boolean;
        get demo(): boolean;
        get resourcePackDirectory(): Internal.File;
        get blockEntityRenderDispatcher(): Internal.BlockEntityRenderDispatcher;
        get blockRenderer(): Internal.BlockRenderDispatcher;
        get running(): boolean;
        get levelSource(): Internal.LevelStorageSource;
        get connectedToRealms(): boolean;
        get tutorial(): Internal.Tutorial;
        get splashManager(): Internal.SplashManager;
        get singleplayerServer(): Internal.IntegratedServer;
        get launchedVersion(): string;
        get chatStatus(): Internal.Minecraft$ChatStatus;
        get fixerUpper(): Internal.DataFixer;
        get resourcePackRepository(): Internal.PackRepository;
        get textureManager(): Internal.TextureManager;
        get profileProperties(): Internal.PropertyMap;
        get windowActive(): boolean;
        get soundManager(): Internal.SoundManager;
        get window(): com.mojang.blaze3d.platform.Window;
        get user(): Internal.User;
        get currentServer(): Internal.ServerData;
        get rollManager(): Internal.RollManager;
        set timer(value: number);
        set overlay($$0: Internal.Overlay_);
        set connectedToRealms($$0: boolean);
        set unfinishedSpell(value: boolean);
        set currentServer($$0: Internal.ServerData_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.GameConfig);
    }
    type Minecraft_ = Minecraft;
    /**
    * @javaClass dev.latvian.mods.rhino.ContextAction
    */
    interface ContextAction <T> {
        run(arg0: Internal.Context_): T;
    }
    type ContextAction_<T> = ContextAction<T>;
    /**
    * @javaClass net.minecraft.class_3494
    */
    class Tag <T> {
        getValues(): Internal.List<T>;
        static empty<T>(): Internal.Tag<T>;
        get values(): Internal.List<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Collection<T>);
    }
    type Tag_<T> = Tag<T>;
    /**
    * @javaClass net.minecraft.class_2599
    */
    class ComparatorBlockEntity extends Internal.BlockEntity {
        getOutputSignal(): number;
        invalidateCaps(): void;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_11014($$0: Internal.CompoundTag_): void;
        setOutputSignal($$0: number): void;
        get outputSignal(): number;
        set outputSignal($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.BlockState);
    }
    type ComparatorBlockEntity_ = ComparatorBlockEntity;
    /**
    * @javaClass dev.latvian.mods.rhino.Scriptable
    */
    interface Scriptable extends Internal.IdEnumerationIterator {
        enumerationIteratorNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        getTypeOf(): Internal.MemberType;
        hasInstance(arg0: Internal.Scriptable_): boolean;
        setParentScope(arg0: Internal.Scriptable_): void;
        getIds(): any[];
        getAllIds(): any[];
        delete(arg0: string): void;
        delete(arg0: number): void;
        put(arg0: number, arg1: Internal.Scriptable_, arg2: any): void;
        put(arg0: string, arg1: Internal.Scriptable_, arg2: any): void;
        getDefaultValue(arg0: Internal.Class_<any>): any;
        setPrototype(arg0: Internal.Scriptable_): void;
        getPrototype(): this;
        get(arg0: number, arg1: Internal.Scriptable_): any;
        get(arg0: string, arg1: Internal.Scriptable_): any;
        enumerationIteratorHasNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        has(arg0: string, arg1: Internal.Scriptable_): boolean;
        has(arg0: number, arg1: Internal.Scriptable_): boolean;
        getClassName(): string;
        getParentScope(): this;
    }
    type Scriptable_ = Scriptable;
    /**
    * @javaClass net.minecraft.class_3195
    */
    class StructureFeature <C> implements com.jtorleonstudios.awesomedungeonocean.mixins.StructureFeatureAccessor, ru.bclib.mixin.common.StructureFeatureAccessor, Internal.StructureFeatureRegisterInvoker, mod.azure.doom.mixin.StructureFeatureAccessor, net.aurelj.dungeons_arise.mixin.StructureFeatureAccessor, io.github.frqnny.mostructures.mixin.StructureFeatureAccessor, com.finndog.mvs.mixin.StructureFeatureAccessor, com.telepathicgrunt.repurposedstructures.mixin.structures.StructureFeatureAccessor, de.dafuqs.spectrum.mixin.accessors.StructureFeatureAccessor, com.telepathicgrunt.the_bumblezone.mixin.world.StructureFeatureAccessor, net.aurelj.totw_additions.mixin.StructureFeatureAccessor, Internal.StructureFeatureAccessor {
        configured($$0: C, $$1: Internal.TagKey_<Internal.Biome_>, $$2: Internal.Map_<Internal.MobCategory_, Internal.StructureSpawnOverride_>): Internal.ConfiguredStructureFeature<C, Internal.StructureFeature<C>>;
        configured($$0: C, $$1: Internal.TagKey_<Internal.Biome_>, $$2: boolean): Internal.ConfiguredStructureFeature<C, Internal.StructureFeature<C>>;
        configured($$0: C, $$1: Internal.TagKey_<Internal.Biome_>, $$2: boolean, $$3: Internal.Map_<Internal.MobCategory_, Internal.StructureSpawnOverride_>): Internal.ConfiguredStructureFeature<C, Internal.StructureFeature<C>>;
        configured($$0: C, $$1: Internal.TagKey_<Internal.Biome_>): Internal.ConfiguredStructureFeature<C, Internal.StructureFeature<C>>;
        static loadStaticStart($$0: Internal.StructurePieceSerializationContext_, $$1: Internal.CompoundTag_, $$2: number): Internal.StructureStart;
        static getLocatePos($$0: Internal.RandomSpreadStructurePlacement_, $$1: Internal.ChunkPos_): BlockPos;
        getPostPlacementProcessor(): Internal.PostPlacementProcessor;
        configuredStructureCodec(): Internal.Codec<Internal.ConfiguredStructureFeature<C, Internal.StructureFeature<C>>>;
        canGenerate($$0: Internal.RegistryAccess_, $$1: Internal.ChunkGenerator_, $$2: Internal.BiomeSource_, $$3: Internal.StructureManager_, $$4: number, $$5: Internal.ChunkPos_, $$6: C, $$7: Internal.LevelHeightAccessor_, $$8: Internal.Predicate_<Internal.Holder_<Internal.Biome_>>): boolean;
        step(): DecorationGenerationStep;
        static bootstrap(): void;
        pieceGeneratorSupplier(): Internal.PieceGeneratorSupplier<C>;
        static readonly "STRONGHOLD" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "RUINED_PORTAL" : Internal.StructureFeature<Internal.RuinedPortalConfiguration>;
        static readonly "MINESHAFT" : Internal.StructureFeature<Internal.MineshaftConfiguration>;
        static readonly "NETHER_FOSSIL" : Internal.StructureFeature<Internal.RangeConfiguration>;
        static readonly "IGLOO" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "SHIPWRECK" : Internal.StructureFeature<Internal.ShipwreckConfiguration>;
        static readonly "PILLAGER_OUTPOST" : Internal.StructureFeature<Internal.JigsawConfiguration>;
        static readonly "SWAMP_HUT" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "BASTION_REMNANT" : Internal.StructureFeature<Internal.JigsawConfiguration>;
        static readonly "JUNGLE_TEMPLE" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "OCEAN_MONUMENT" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "FORTRESS" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "VILLAGE" : Internal.StructureFeature<Internal.JigsawConfiguration>;
        static readonly "MAX_STRUCTURE_RANGE" : 8;
        static readonly "DESERT_PYRAMID" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "END_CITY" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "WOODLAND_MANSION" : Internal.StructureFeature<Internal.NoneFeatureConfiguration>;
        static readonly "BURIED_TREASURE" : Internal.StructureFeature<Internal.ProbabilityFeatureConfiguration>;
        static readonly "OCEAN_RUIN" : Internal.StructureFeature<Internal.OceanRuinConfiguration>;
        get postPlacementProcessor(): Internal.PostPlacementProcessor;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Codec<C>, $$1: ((arg0: Internal.PieceGeneratorSupplier$Context<C>) => Internal.Optional<Internal.PieceGenerator<C>>), $$2: ((arg0: Internal.WorldGenLevel, arg1: Internal.StructureFeatureManager, arg2: Internal.ChunkGenerator, arg3: Internal.Random, arg4: Internal.BoundingBox, arg5: Internal.ChunkPos, arg6: Internal.PiecesContainer) => void));
        constructor($$0: Internal.Codec<C>, $$1: ((arg0: Internal.PieceGeneratorSupplier$Context<C>) => Internal.Optional<Internal.PieceGenerator<C>>));
    }
    type StructureFeature_<C> = Special.StructureFeature | StructureFeature<C>;
    /**
    * @javaClass java.awt.AWTKeyStroke
    */
    class AWTKeyStroke implements Internal.Serializable {
        getKeyChar(): string;
        hashCode(): number;
        isOnKeyRelease(): boolean;
        equals(arg0: any): boolean;
        static getAWTKeyStrokeForEvent(arg0: Internal.KeyEvent_): Internal.AWTKeyStroke;
        toString(): string;
        getModifiers(): number;
        static getAWTKeyStroke(arg0: string, arg1: number): Internal.AWTKeyStroke;
        static getAWTKeyStroke(arg0: string): Internal.AWTKeyStroke;
        static getAWTKeyStroke(arg0: number, arg1: number): Internal.AWTKeyStroke;
        static getAWTKeyStroke(arg0: number, arg1: number, arg2: boolean): Internal.AWTKeyStroke;
        getKeyCode(): number;
        getKeyEventType(): number;
        get onKeyRelease(): boolean;
        get keyCode(): number;
        get keyEventType(): number;
        get keyChar(): string;
        get modifiers(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AWTKeyStroke_ = AWTKeyStroke;
    /**
    * @javaClass net.minecraft.class_3302$class_4045
    */
    interface PreparableReloadListener$PreparationBarrier {
        wait<T>(arg0: T): Internal.CompletableFuture<T>;
    }
    type PreparableReloadListener$PreparationBarrier_ = PreparableReloadListener$PreparationBarrier;
    /**
    * @javaClass net.minecraft.class_3765
    */
    class Raid {
        getCenter(): BlockPos;
        hasFirstWaveSpawned(): boolean;
        setBadOmenLevel($$0: number): void;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        getMaxBadOmenLevel(): number;
        isLoss(): boolean;
        getId(): number;
        getTotalRaidersAlive(): number;
        isActive(): boolean;
        absorbBadOmen($$0: Internal.Player_): void;
        addWaveMob($$0: number, $$1: Internal.Raider_, $$2: boolean): boolean;
        updateBossbar(): void;
        getTotalHealth(): number;
        getBadOmenLevel(): number;
        getAllRaiders(): Internal.Set<Internal.Raider>;
        setLeader($$0: number, $$1: Internal.Raider_): void;
        getLeader($$0: number): Internal.Raider;
        isStopped(): boolean;
        joinRaid($$0: number, $$1: Internal.Raider_, $$2: BlockPos_, $$3: boolean): void;
        addHeroOfTheVillage($$0: Internal.Entity_): void;
        getGroupsSpawned(): number;
        tick(): void;
        isStarted(): boolean;
        getNumGroups($$0: Internal.Difficulty_): number;
        getEnchantOdds(): number;
        isVictory(): boolean;
        getHealthOfLivingRaiders(): number;
        getLevel(): Internal.Level;
        stop(): void;
        isBetweenWaves(): boolean;
        removeLeader($$0: number): void;
        isOver(): boolean;
        removeFromRaid($$0: Internal.Raider_, $$1: boolean): void;
        static getLeaderBannerInstance(): Internal.ItemStack;
        static readonly "DEFAULT_MAX_BAD_OMEN_LEVEL" : 5;
        static readonly "RAID_REMOVAL_THRESHOLD_SQR" : 12544;
        static readonly "TICKS_PER_DAY" : 24000;
        static readonly "VILLAGE_RADIUS_BUFFER" : 16;
        static readonly "MAX_CELEBRATION_TICKS" : 600;
        static readonly "VALID_RAID_RADIUS_SQR" : 9216;
        static readonly "MAX_NO_ACTION_TIME" : 2400;
        get over(): boolean;
        get stopped(): boolean;
        get level(): Internal.Level;
        get center(): BlockPos;
        get victory(): boolean;
        get totalHealth(): number;
        get active(): boolean;
        get started(): boolean;
        get totalRaidersAlive(): number;
        get enchantOdds(): number;
        get healthOfLivingRaiders(): number;
        get maxBadOmenLevel(): number;
        get loss(): boolean;
        get groupsSpawned(): number;
        get allRaiders(): Internal.Set<Internal.Raider>;
        get badOmenLevel(): number;
        get betweenWaves(): boolean;
        get leaderBannerInstance(): Internal.ItemStack;
        get id(): number;
        set badOmenLevel($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: Internal.ServerLevel, $$2: BlockPos);
        constructor($$0: Internal.ServerLevel, $$1: Internal.CompoundTag);
    }
    type Raid_ = Raid;
    /**
    * @javaClass xaero.map.gui.CursorBox
    */
    class CursorBox {
        createLines(text: net.minecraft.network.chat.Component_): void;
        withWidth(boxWidth: number): this;
        drawBox(matrixStack: Internal.PoseStack_, x: number, y: number, width: number, height: number): void;
        splitWords(dest: Internal.ArrayList_<net.minecraft.network.chat.Component_>, formattedText: Internal.FormattedText_): void;
        getLine(line: number): net.minecraft.network.chat.Component;
        setAutoLinebreak(autoLinebreak: boolean): void;
        getFullCode(): string;
        setStartWidth(startWidth: number): void;
        getPlainText(): string;
        get fullCode(): string;
        get plainText(): string;
        set autoLinebreak(autoLinebreak: boolean);
        set startWidth(startWidth: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(size: number);
        constructor(directText: net.minecraft.network.chat.Component, flippedByDefault: boolean);
        constructor(directText: net.minecraft.network.chat.Component);
        constructor(code: string);
        constructor(code: string, codeStyle: Internal.Style);
        constructor(code: string, codeStyle: Internal.Style, flippedByDefault: boolean);
    }
    type CursorBox_ = CursorBox;
    /**
    * @javaClass net.minecraft.class_2623
    */
    class ClientboundBlockEventPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getBlock(): Internal.Block;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getPos(): BlockPos;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getB1(): number;
        getB0(): number;
        get pos(): BlockPos;
        get block(): Internal.Block;
        get skippable(): boolean;
        get b0(): number;
        get b1(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.Block, $$2: number, $$3: number);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundBlockEventPacket_ = ClientboundBlockEventPacket;
    /**
    * @javaClass java.time.Period
    */
    class Period implements Internal.ChronoPeriod, Internal.Serializable {
        minus(arg0: Internal.TemporalAmount_): this;
        negated(): this;
        normalized(): this;
        static ofYears(arg0: number): Internal.Period;
        getMonths(): number;
        plusDays(arg0: number): this;
        multipliedBy(arg0: number): this;
        getYears(): number;
        hashCode(): number;
        static of(arg0: number, arg1: number, arg2: number): Internal.Period;
        get(arg0: Internal.TemporalUnit_): number;
        isZero(): boolean;
        static from(arg0: Internal.TemporalAmount_): Internal.Period;
        withDays(arg0: number): this;
        getChronology(): Internal.IsoChronology;
        static between(arg0: Internal.LocalDate_, arg1: Internal.LocalDate_): Internal.Period;
        isNegative(): boolean;
        withMonths(arg0: number): this;
        minusYears(arg0: number): this;
        plusMonths(arg0: number): this;
        plusYears(arg0: number): this;
        static ofDays(arg0: number): Internal.Period;
        static parse(arg0: Internal.CharSequence_): Internal.Period;
        toTotalMonths(): number;
        plus(arg0: Internal.TemporalAmount_): this;
        minusDays(arg0: number): this;
        minusMonths(arg0: number): this;
        static ofWeeks(arg0: number): Internal.Period;
        getDays(): number;
        subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
        equals(arg0: any): boolean;
        getUnits(): Internal.List<Internal.TemporalUnit>;
        static ofMonths(arg0: number): Internal.Period;
        addTo(arg0: Internal.Temporal_): Internal.Temporal;
        toString(): string;
        withYears(arg0: number): this;
        static readonly "ZERO" : Internal.Period;
        get zero(): boolean;
        get negative(): boolean;
        get months(): number;
        get chronology(): Internal.IsoChronology;
        get days(): number;
        get units(): Internal.List<Internal.TemporalUnit>;
        get years(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Period_ = Period;
    /**
    * @javaClass java.awt.event.InputEvent
    */
    abstract class InputEvent extends Internal.ComponentEvent {
        isConsumed(): boolean;
        static getModifiersExText(arg0: number): string;
        isControlDown(): boolean;
        isAltGraphDown(): boolean;
        getWhen(): number;
        isMetaDown(): boolean;
        static getMaskForButton(arg0: number): number;
        consume(): void;
        getModifiersEx(): number;
        getModifiers(): number;
        isAltDown(): boolean;
        isShiftDown(): boolean;
        static readonly "BUTTON1_MASK" : 16;
        static readonly "SHIFT_MASK" : 1;
        static readonly "META_DOWN_MASK" : 256;
        static readonly "BUTTON3_DOWN_MASK" : 4096;
        static readonly "SHIFT_DOWN_MASK" : 64;
        static readonly "CTRL_DOWN_MASK" : 128;
        static readonly "ALT_GRAPH_MASK" : 32;
        static readonly "BUTTON2_DOWN_MASK" : 2048;
        static readonly "ALT_GRAPH_DOWN_MASK" : 8192;
        static readonly "BUTTON2_MASK" : 8;
        static readonly "BUTTON3_MASK" : 4;
        static readonly "CTRL_MASK" : 2;
        static readonly "ALT_MASK" : 8;
        static readonly "META_MASK" : 4;
        static readonly "ALT_DOWN_MASK" : 512;
        static readonly "BUTTON1_DOWN_MASK" : 1024;
        get consumed(): boolean;
        get altDown(): boolean;
        get controlDown(): boolean;
        get modifiersEx(): number;
        get shiftDown(): boolean;
        get metaDown(): boolean;
        get modifiers(): number;
        get when(): number;
        get altGraphDown(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type InputEvent_ = InputEvent;
    /**
    * @javaClass corgitaco.enhancedcelestials.mixin.access.StyleAccess
    */
    interface StyleAccess {
    }
    type StyleAccess_ = StyleAccess;
    /**
    * @javaClass com.glisco.things.mixin.access.ContainerLockAccessor
    */
    interface ContainerLockAccessor {
        things$getKey(): string;
    }
    type ContainerLockAccessor_ = ContainerLockAccessor;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.PickaxeItemBuilder
    */
    class PickaxeItemBuilder extends Internal.HandheldItemBuilder {
        createObject(): Internal.Item;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type PickaxeItemBuilder_ = PickaxeItemBuilder;
    /**
    * @javaClass java.awt.event.FocusEvent
    */
    class FocusEvent extends Internal.ComponentEvent {
        paramString(): string;
        isTemporary(): boolean;
        getOppositeComponent(): Internal.Component;
        getCause(): Internal.FocusEvent$Cause;
        static readonly "FOCUS_GAINED" : 1004;
        static readonly "FOCUS_FIRST" : 1004;
        static readonly "FOCUS_LAST" : 1005;
        static readonly "FOCUS_LOST" : 1005;
        get temporary(): boolean;
        get oppositeComponent(): Internal.Component;
        get cause(): Internal.FocusEvent$Cause;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.Component, arg1: number);
        constructor(arg0: Internal.Component, arg1: number, arg2: boolean);
        constructor(arg0: Internal.Component, arg1: number, arg2: boolean, arg3: Internal.Component, arg4: Internal.FocusEvent$Cause);
        constructor(arg0: Internal.Component, arg1: number, arg2: boolean, arg3: Internal.Component);
    }
    type FocusEvent_ = FocusEvent;
    /**
    * @javaClass net.minecraft.class_2884
    */
    class ServerboundTeleportToEntityPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        getEntity($$0: Internal.ServerLevel_): Internal.Entity;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.UUID);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ServerboundTeleportToEntityPacket_ = ServerboundTeleportToEntityPacket;
    /**
    * @javaClass java.awt.event.ContainerListener
    */
    interface ContainerListener extends Internal.EventListener {
        componentRemoved(arg0: Internal.ContainerEvent_): void;
        componentAdded(arg0: Internal.ContainerEvent_): void;
    }
    type ContainerListener_ = ContainerListener;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.ItemToolTierEventJS
    */
    class ItemToolTierEventJS extends Internal.StartupEventJS {
        add(id: string, tier: Internal.Consumer_<Internal.MutableToolTier_>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ItemToolTierEventJS_ = ItemToolTierEventJS;
    /**
    * @javaClass com.google.gson.LongSerializationPolicy
    */
    abstract class LongSerializationPolicy extends Internal.Enum<Internal.LongSerializationPolicy> {
        serialize(arg0: number): Internal.JsonElement;
        static valueOf(arg0: string): Internal.LongSerializationPolicy;
        static values(): Internal.LongSerializationPolicy[];
        static readonly "STRING" : Internal.LongSerializationPolicy;
        static readonly "DEFAULT" : Internal.LongSerializationPolicy;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type LongSerializationPolicy_ = "default" | "string" | LongSerializationPolicy;
    /**
    * @javaClass corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents$Notification
    */
    class LunarTextComponents$Notification {
        getNotificationType(): Internal.LunarTextComponents$NotificationType;
        getCustomTranslationTextComponent(): Internal.CustomTranslationTextComponent;
        static readonly "CODEC" : Internal.Codec<Internal.LunarTextComponents$Notification>;
        static readonly "DEFAULT" : Internal.LunarTextComponents$Notification;
        get notificationType(): Internal.LunarTextComponents$NotificationType;
        get customTranslationTextComponent(): Internal.CustomTranslationTextComponent;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(customTranslationTextComponent: Internal.CustomTranslationTextComponent, notificationType: Internal.LunarTextComponents$NotificationType);
    }
    type LunarTextComponents$Notification_ = LunarTextComponents$Notification;
    /**
    * @javaClass com.tiviacz.travelersbackpack.mixin.AccessorPlayerEntity
    */
    interface AccessorPlayerEntity {
        setSleepTimer(arg0: number): void;
    }
    type AccessorPlayerEntity_ = AccessorPlayerEntity;
    /**
    * @javaClass net.minecraft.class_4587
    */
    class PoseStack implements Internal.TransformStack {
        rotate(angle: number, axis: Internal.Direction$Axis_): Internal.TransformStack;
        rotate(axis: Internal.Direction_, radians: number): Internal.TransformStack;
        translateAll(v: number): Internal.TransformStack;
        scale(factorX: number, factorY: number, factorZ: number): Internal.TransformStack;
        scale($$0: number, $$1: number, $$2: number): void;
        scale(factor: number): Internal.TransformStack;
        translate(x: number, y: number, z: number): Internal.TransformStack;
        translate(x: number, y: number, z: number): void;
        translate(vec: Internal.Vector3f_): Internal.TransformStack;
        translate(vec: Vec3_): Internal.TransformStack;
        translate(vec: Vec3i_): Internal.TransformStack;
        translateZ(z: number): Internal.TransformStack;
        transform(pose: Internal.Matrix4f_, normal: Internal.Matrix3f_): Internal.TransformStack;
        transform(stack: Internal.PoseStack_): Internal.TransformStack;
        mulPoseMatrix($$0: Internal.Matrix4f_): void;
        pushPose(): Internal.TransformStack;
        pushPose(): void;
        translateY(y: number): Internal.TransformStack;
        translateX(x: number): Internal.TransformStack;
        multiply(quaternion: Internal.Quaternion_): Internal.TransformStack;
        multiply(axis: Internal.Vector3f_, angle: number): Internal.TransformStack;
        rotateX(angle: number): Internal.TransformStack;
        rotateY(angle: number): Internal.TransformStack;
        translateBack(x: number, y: number, z: number): Internal.TransformStack;
        translateBack(vec: Vec3_): Internal.TransformStack;
        translateBack(vec: Vec3i_): Internal.TransformStack;
        rotateZ(angle: number): Internal.TransformStack;
        rotateToFace(facing: Internal.Direction_): Internal.TransformStack;
        nudge(seed: number): Internal.TransformStack;
        rotateCentered(axis: Internal.Direction_, radians: number): Internal.TransformStack;
        rotateCentered(q: Internal.Quaternion_): Internal.TransformStack;
        last(): Internal.PoseStack$Pose;
        clear(): boolean;
        centre(): Internal.TransformStack;
        multiplyRadians(axis: Internal.Vector3f_, angle: number): Internal.TransformStack;
        rotateZRadians(angle: number): Internal.TransformStack;
        mulPose(q: Internal.Quaternion_): void;
        rotateYRadians(angle: number): Internal.TransformStack;
        rotateXRadians(angle: number): Internal.TransformStack;
        popPose(): Internal.TransformStack;
        popPose(): void;
        unCentre(): Internal.TransformStack;
        setIdentity(): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type PoseStack_ = PoseStack;
    /**
    * @javaClass dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$QuestEvent
    */
    class ObjectCompletedEvent$QuestEvent extends Internal.ObjectCompletedEvent<Internal.Quest> {
        getQuest(): Internal.Quest;
        get quest(): Internal.Quest;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(d: Internal.QuestProgressEventData<Internal.Quest>);
    }
    type ObjectCompletedEvent$QuestEvent_ = ObjectCompletedEvent$QuestEvent;
    /**
    * @javaClass net.coderbot.iris.texture.pbr.PBRType
    */
    class PBRType extends Internal.Enum<Internal.PBRType> {
        getSuffix(): string;
        appendToFileLocation(arg0: ResourceLocation_): ResourceLocation;
        static fromFileLocation(arg0: string): Internal.PBRType;
        static valueOf(arg0: string): Internal.PBRType;
        static values(): Internal.PBRType[];
        getDefaultValue(): number;
        static readonly "SPECULAR" : Internal.PBRType;
        static readonly "NORMAL" : Internal.PBRType;
        get defaultValue(): number;
        get suffix(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type PBRType_ = "normal" | "specular" | PBRType;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.config.NameMap
    */
    class NameMap <E> implements Internal.Iterable<E> {
        getPrevious(value: E): E;
        read(data: Internal.FriendlyByteBuf_): E;
        getName(value: E): string;
        getIndex(e: E): number;
        offset(value: E, index: number): E;
        spliterator(): Internal.Spliterator<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        getNullable(s: string): E;
        getColor(value: E): Internal.Color4I;
        getNext(value: E): E;
        withDefault(def: E): Internal.NameMap<E>;
        getIcon(v: E): Internal.Icon;
        iterator(): Internal.Iterator<E>;
        getRandom(rand: Internal.Random_): E;
        size(): number;
        getDisplayName(value: E): net.minecraft.network.chat.Component;
        static of<T>(defaultValue: T, values: Internal.List_<T>): Internal.NameMap$Builder<T>;
        static of<T>(defaultValue: T, values: T[]): Internal.NameMap$Builder<T>;
        get(s: string): E;
        get(index: number): E;
        getStringIndex(s: string): number;
        write(data: Internal.FriendlyByteBuf_, object: E): void;
        readonly "defaultValue" : E;
        readonly "keys" : Internal.List<string>;
        readonly "values" : Internal.List<E>;
        readonly "map" : Internal.Map<string, E>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type NameMap_<E> = NameMap<E>;
    /**
    * @javaClass net.minecraft.class_2744
    */
    class ClientboundSetEquipmentPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getSlots(): Internal.List<com.mojang.datafixers.util.Pair<EquipmentSlot, Internal.ItemStack>>;
        isSkippable(): boolean;
        getEntity(): number;
        get slots(): Internal.List<com.mojang.datafixers.util.Pair<EquipmentSlot, Internal.ItemStack>>;
        get skippable(): boolean;
        get entity(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: Internal.List<com.mojang.datafixers.util.Pair<EquipmentSlot, Internal.ItemStack>>);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundSetEquipmentPacket_ = ClientboundSetEquipmentPacket;
    /**
    * @javaClass java.awt.JobAttributes$SidesType
    */
    class JobAttributes$SidesType extends Internal.AttributeValue {
        static readonly "TWO_SIDED_SHORT_EDGE" : Internal.JobAttributes$SidesType;
        static readonly "TWO_SIDED_LONG_EDGE" : Internal.JobAttributes$SidesType;
        static readonly "ONE_SIDED" : Internal.JobAttributes$SidesType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type JobAttributes$SidesType_ = JobAttributes$SidesType;
    /**
    * @javaClass net.minecraft.class_1715
    */
    class CraftingContainer implements net.minecraft.world.Container, Internal.StackedContentsCompatible, Internal.AccessorCraftingContainer, Internal.CraftingContainerAccess {
        method_5438($$0: number): Internal.ItemStack;
        method_5439(): number;
        method_5447($$0: number, $$1: Internal.ItemStack_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        method_5448(): void;
        getWidth(): number;
        countItem($$0: Internal.Item_): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item_>): boolean;
        getHeight(): number;
        handler$gfk000$onMarkDirty(callbackInfo: Internal.CallbackInfo_): void;
        method_5441($$0: number): Internal.ItemStack;
        method_5431(): void;
        method_5442(): boolean;
        method_7683($$0: Internal.StackedContents_): void;
        method_5434($$0: number, $$1: number): Internal.ItemStack;
        method_5443($$0: Internal.Player_): boolean;
        stopOpen($$0: Internal.Player_): void;
        startOpen($$0: Internal.Player_): void;
        method_5444(): number;
        readonly "menu" : Internal.AbstractContainerMenu;
        get width(): number;
        get height(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.AbstractContainerMenu, $$1: number, $$2: number);
    }
    type CraftingContainer_ = CraftingContainer;
    /**
    * @javaClass de.siphalor.nbtcrafting.ingredient.IIngredient
    */
    interface IIngredient {
        nbtCrafting$getRecipeRemainder(arg0: Internal.ItemStack_, arg1: Internal.Map_<string, any>): Internal.ItemStack;
        nbtCrafting$setAdvancedEntries(arg0: Internal.Stream_<Internal.IngredientEntry_>): void;
        nbtCrafting$isAdvanced(): boolean;
    }
    type IIngredient_ = IIngredient;
    /**
    * @javaClass net.coderbot.iris.mixin.GameRendererAccessor
    */
    interface GameRendererAccessor {
        getPanoramicMode(): boolean;
        invokeGetFov(arg0: Internal.Camera_, arg1: number, arg2: boolean): number;
        invokeBobView(arg0: Internal.PoseStack_, arg1: number): void;
        getRenderHand(): boolean;
        invokeBobHurt(arg0: Internal.PoseStack_, arg1: number): void;
    }
    type GameRendererAccessor_ = GameRendererAccessor;
    /**
    * @javaClass java.util.function.LongFunction
    */
    interface LongFunction <R> {
        apply(arg0: number): R;
    }
    type LongFunction_<R> = ((arg0: number) => R) | LongFunction<R>;
    /**
    * @javaClass java.util.AbstractCollection
    */
    abstract class AbstractCollection <E> implements Internal.Collection<E> {
        add(arg0: E): boolean;
        spliterator(): Internal.Spliterator<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        isEmpty(): boolean;
        clear(): void;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        contains(arg0: any): boolean;
        iterator(): Internal.Iterator<E>;
        size(): number;
        stream(): Internal.Stream<E>;
        addAll(arg0: Internal.Collection_<E>): boolean;
        toArray(): any[];
        toArray<T>(arg0: T[]): T[];
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<E>;
        toString(): string;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractCollection_<E> = AbstractCollection<E>;
    /**
    * @javaClass java.time.ZonedDateTime
    */
    class ZonedDateTime implements Internal.Temporal, Internal.ChronoZonedDateTime<Internal.LocalDate>, Internal.Serializable {
        plusHours(arg0: number): this;
        isEqual(arg0: Internal.ChronoZonedDateTime_<any>): boolean;
        toLocalTime(): Internal.LocalTime;
        compareTo(arg0: Internal.ChronoZonedDateTime_<any>): number;
        static ofLocal(arg0: Internal.LocalDateTime_, arg1: Internal.ZoneId_, arg2: Internal.ZoneOffset_): Internal.ZonedDateTime;
        getDayOfWeek(): Internal.DayOfWeek;
        static ofStrict(arg0: Internal.LocalDateTime_, arg1: Internal.ZoneOffset_, arg2: Internal.ZoneId_): Internal.ZonedDateTime;
        plusSeconds(arg0: number): this;
        getMinute(): number;
        static from(arg0: Internal.TemporalAccessor_): Internal.ZonedDateTime;
        getMonth(): Internal.Month;
        plusNanos(arg0: number): this;
        withHour(arg0: number): this;
        plusMonths(arg0: number): this;
        plusYears(arg0: number): this;
        truncatedTo(arg0: Internal.TemporalUnit_): this;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        minusNanos(arg0: number): this;
        getNano(): number;
        format(arg0: Internal.DateTimeFormatter_): string;
        getZone(): Internal.ZoneId;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        isSupported(arg0: Internal.TemporalField_): boolean;
        plus(arg0: Internal.TemporalAmount_): this;
        plus(arg0: number, arg1: Internal.TemporalUnit_): this;
        getYear(): number;
        toEpochSecond(): number;
        toLocalDateTime(): Internal.LocalDateTime;
        withDayOfMonth(arg0: number): this;
        isAfter(arg0: Internal.ChronoZonedDateTime_<any>): boolean;
        withMonth(arg0: number): this;
        toOffsetDateTime(): Internal.OffsetDateTime;
        static ofInstant(arg0: Internal.LocalDateTime_, arg1: Internal.ZoneOffset_, arg2: Internal.ZoneId_): Internal.ZonedDateTime;
        static ofInstant(arg0: Internal.Instant_, arg1: Internal.ZoneId_): Internal.ZonedDateTime;
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        minus(arg0: Internal.TemporalAmount_): this;
        withFixedOffsetZone(): this;
        minusHours(arg0: number): this;
        getOffset(): Internal.ZoneOffset;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        withYear(arg0: number): this;
        plusMinutes(arg0: number): this;
        minusMinutes(arg0: number): this;
        plusDays(arg0: number): this;
        withLaterOffsetAtOverlap(): this;
        hashCode(): number;
        static now(): Internal.ZonedDateTime;
        static now(arg0: Internal.Clock_): Internal.ZonedDateTime;
        static now(arg0: Internal.ZoneId_): Internal.ZonedDateTime;
        static of(arg0: Internal.LocalDate_, arg1: Internal.LocalTime_, arg2: Internal.ZoneId_): Internal.ZonedDateTime;
        static of(arg0: Internal.LocalDateTime_, arg1: Internal.ZoneId_): Internal.ZonedDateTime;
        static of(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: Internal.ZoneId_): Internal.ZonedDateTime;
        get(arg0: Internal.TemporalField_): number;
        withZoneSameLocal(arg0: Internal.ZoneId_): this;
        withEarlierOffsetAtOverlap(): this;
        getDayOfYear(): number;
        plusWeeks(arg0: number): this;
        getHour(): number;
        getChronology(): Internal.Chronology;
        withMinute(arg0: number): this;
        getMonthValue(): number;
        minusYears(arg0: number): this;
        withZoneSameInstant(arg0: Internal.ZoneId_): this;
        minusWeeks(arg0: number): this;
        withDayOfYear(arg0: number): this;
        static parse(arg0: Internal.CharSequence_, arg1: Internal.DateTimeFormatter_): Internal.ZonedDateTime;
        static parse(arg0: Internal.CharSequence_): Internal.ZonedDateTime;
        toInstant(): Internal.Instant;
        isBefore(arg0: Internal.ChronoZonedDateTime_<any>): boolean;
        minusDays(arg0: number): this;
        withNano(arg0: number): this;
        getLong(arg0: Internal.TemporalField_): number;
        minusMonths(arg0: number): this;
        with(arg0: Internal.TemporalField_, arg1: number): this;
        with(arg0: Internal.TemporalAdjuster_): this;
        toLocalDate(): Internal.LocalDate;
        equals(arg0: any): boolean;
        getSecond(): number;
        until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        toString(): string;
        getDayOfMonth(): number;
        minusSeconds(arg0: number): this;
        withSecond(arg0: number): this;
        get offset(): Internal.ZoneOffset;
        get year(): number;
        get dayOfYear(): number;
        get nano(): number;
        get chronology(): Internal.Chronology;
        get minute(): number;
        get second(): number;
        get dayOfWeek(): Internal.DayOfWeek;
        get month(): Internal.Month;
        get hour(): number;
        get zone(): Internal.ZoneId;
        get dayOfMonth(): number;
        get monthValue(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ZonedDateTime_ = ZonedDateTime;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.block.ChunkUnloadListeningBlockEntity
    */
    interface ChunkUnloadListeningBlockEntity {
        onChunkUnloaded(): void;
    }
    type ChunkUnloadListeningBlockEntity_ = ChunkUnloadListeningBlockEntity;
    /**
    * @javaClass com.google.gson.JsonElement
    */
    abstract class JsonElement {
        getAsBigInteger(): Internal.BigInteger;
        getAsFloat(): number;
        getAsByte(): number;
        getAsJsonObject(): Internal.JsonObject;
        getAsBigDecimal(): Internal.BigDecimal;
        getAsJsonNull(): Internal.JsonNull;
        isJsonNull(): boolean;
        getAsNumber(): Internal.Number;
        getAsCharacter(): string;
        getAsString(): string;
        isJsonArray(): boolean;
        getAsDouble(): number;
        getAsInt(): number;
        deepCopy(): this;
        isJsonPrimitive(): boolean;
        getAsLong(): number;
        getAsJsonArray(): Internal.JsonArray;
        isJsonObject(): boolean;
        getAsJsonPrimitive(): Internal.JsonPrimitive;
        getAsBoolean(): boolean;
        toString(): string;
        getAsShort(): number;
        get asByte(): number;
        get asBigInteger(): Internal.BigInteger;
        get asJsonObject(): Internal.JsonObject;
        get asCharacter(): string;
        get jsonPrimitive(): boolean;
        get asNumber(): Internal.Number;
        get asBigDecimal(): Internal.BigDecimal;
        get jsonNull(): boolean;
        get asFloat(): number;
        get asLong(): number;
        get asInt(): number;
        get asJsonPrimitive(): Internal.JsonPrimitive;
        get asJsonNull(): Internal.JsonNull;
        get asShort(): number;
        get asDouble(): number;
        get asJsonArray(): Internal.JsonArray;
        get asString(): string;
        get jsonObject(): boolean;
        get jsonArray(): boolean;
        get asBoolean(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type JsonElement_ = JsonElement;
    /**
    * @javaClass net.minecraft.class_742
    */
    abstract class AbstractClientPlayer extends Internal.Player implements Internal.PlayerAttackAnimatable, Internal.AnimatablePlayer, dev.tr7zw.firstperson.donor.DonorProvider, Internal.DonorProvider {
        handler$hii001$getSkinTextureLocationDonor(ci: Internal.CallbackInfoReturnable_<any>): void;
        handler$jan000$onGetCapeTexture(info: Internal.CallbackInfoReturnable_<any>): void;
        playAttackAnimation(name: string, isOffHand: boolean, length: number): void;
        isElytraLoaded(): boolean;
        getAnimatedSkin(): ResourceLocation;
        handler$jca001$onGetCapeTexture(info: Internal.CallbackInfoReturnable_<any>): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getModelName(): string;
        static getSkinLocation($$0: string): ResourceLocation;
        handler$ehp000$getSkinTextureLocationDonor(ci: Internal.CallbackInfoReturnable_<any>): void;
        isCapeLoaded(): boolean;
        getCloakTextureLocation(): ResourceLocation;
        handler$emj000$gobberBowsZoom(cir: Internal.CallbackInfoReturnable_<any>, f: number): void;
        playRollAnimation(animationName: string, direction: Vec3_): void;
        foodEatenKJS(is: Internal.ItemStack_): void;
        alwaysAccepts(): boolean;
        handler$gbb000$mcdw$customBowsZoom(cir: Internal.CallbackInfoReturnable_<any>, f: number): void;
        method_7325(): boolean;
        handler$dai000$getSkinTexture(info: Internal.CallbackInfoReturnable_<any>): ResourceLocation;
        static registerSkinTexture($$0: ResourceLocation_, $$1: string): void;
        updateAnimationsOnTick(): void;
        getSkinTextureLocation(): ResourceLocation;
        getCurrentAnimation(): Internal.Optional<any>;
        clearMeshes(): void;
        getStepHeight(): number;
        isLeftHanded(): boolean;
        handler$dai000$getModel(info: Internal.CallbackInfoReturnable_<any>): string;
        isSkinLoaded(): boolean;
        getElytraTextureLocation(): ResourceLocation;
        asKJS(): Internal.EntityJS;
        handler$dem000$emeraldBowsZoom(cir: Internal.CallbackInfoReturnable_<any>, f: number): void;
        canRiderInteract(): boolean;
        getFieldOfViewModifier(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        stopAttackAnimation(): void;
        handler$zza000$newFov(cir: Internal.CallbackInfoReturnable_<any>, fov: number): void;
        thonkutil$getId(): ResourceLocation;
        method_7337(): boolean;
        "trDonorProvider" : dev.tr7zw.skinlayers.donor.DonorSkinProvider;
        static readonly "SKIN_HAT_WIDTH" : 8;
        static readonly "SKIN_HEAD_WIDTH" : 8;
        static readonly "SKIN_HAT_U" : 40;
        static readonly "SKIN_TEX_HEIGHT" : 64;
        readonly "clientLevel" : Internal.ClientLevel;
        "elytraRotZ" : number;
        "elytraRotY" : number;
        "elytraRotX" : number;
        static readonly "SKIN_HAT_HEIGHT" : 8;
        static readonly "SKIN_HEAD_HEIGHT" : 8;
        static readonly "SKIN_HEAD_V" : 8;
        static readonly "SKIN_HEAD_U" : 8;
        static readonly "SKIN_HAT_V" : 8;
        static readonly "SKIN_TEX_WIDTH" : 64;
        get elytraLoaded(): boolean;
        get modelName(): string;
        get elytraTextureLocation(): ResourceLocation;
        get currentAnimation(): Internal.Optional<any>;
        get leftHanded(): boolean;
        get skinTextureLocation(): ResourceLocation;
        get skinLoaded(): boolean;
        get cloakTextureLocation(): ResourceLocation;
        get animatedSkin(): ResourceLocation;
        get stepHeight(): number;
        get fieldOfViewModifier(): number;
        get capeLoaded(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ClientLevel, $$1: Internal.GameProfile);
    }
    type AbstractClientPlayer_ = AbstractClientPlayer;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator
    */
    interface ObjectBidirectionalIterator <K> extends Internal.ObjectIterator<K>, Internal.BidirectionalIterator<K> {
        back(arg0: number): number;
        skip(arg0: number): number;
        forEachRemaining(arg0: Internal.Consumer_<K>): void;
        remove(): void;
    }
    type ObjectBidirectionalIterator_<K> = ObjectBidirectionalIterator<K>;
    /**
    * @javaClass net.minecraft.class_1498
    */
    class Horse extends Internal.AbstractHorse {
        getMarkings(): Internal.Markings;
        method_5613($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): Internal.AgeableMob;
        method_6735(): boolean;
        getArmor(): Internal.ItemStack;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getVariant(): Internal.Variant;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_5992($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        method_6773($$0: Internal.ItemStack_): boolean;
        method_5453($$0: net.minecraft.world.Container_): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_6474($$0: Internal.Animal_): boolean;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        get armor(): Internal.ItemStack;
        get markings(): Internal.Markings;
        get variant(): Internal.Variant;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Horse>, $$1: Internal.Level);
    }
    type Horse_ = Horse;
    /**
    * @javaClass net.fabricmc.fabric.api.item.v1.FabricItem
    */
    interface FabricItem {
        getAttributeModifiers(stack: Internal.ItemStack_, slot: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Hand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
    }
    type FabricItem_ = FabricItem;
    /**
    * @javaClass dev.latvian.mods.kubejs.core.EntityTargetKJS
    */
    interface EntityTargetKJS {
        getNameKJS(): string;
        getNameKJS(target: Internal.LootContext$EntityTarget_): string;
    }
    type EntityTargetKJS_ = EntityTargetKJS;
    /**
    * @javaClass net.coderbot.iris.shadows.Matrix4fAccess
    */
    interface Matrix4fAccess {
        copyIntoArray(): number[];
        copyFromArray(arg0: number[]): void;
    }
    type Matrix4fAccess_ = Matrix4fAccess;
    /**
    * @javaClass java.lang.Record
    */
    abstract class Record {
        hashCode(): number;
        equals(arg0: any): boolean;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Record_ = Record;
    /**
    * @javaClass fuzs.puzzleslib.mixin.client.accessor.AbstractContainerScreenAccessor
    */
    interface AbstractContainerScreenAccessor {
        getYSize(): number;
        getGuiTop(): number;
        getXSize(): number;
        getGuiLeft(): number;
    }
    type AbstractContainerScreenAccessor_ = AbstractContainerScreenAccessor;
    /**
    * @javaClass java.lang.invoke.MethodType
    */
    class MethodType implements Internal.Constable, Internal.TypeDescriptor$OfMethod<Internal.Class<any>, Internal.MethodType>, Internal.Serializable {
        toMethodDescriptorString(): string;
        dropParameterTypes(arg0: number, arg1: number): this;
        changeReturnType(arg0: Internal.Class_<any>): this;
        static fromMethodDescriptorString(arg0: string, arg1: Internal.ClassLoader_): Internal.MethodType;
        lastParameterType(): typeof any;
        describeConstable(): Internal.Optional<Internal.MethodTypeDesc>;
        changeParameterType(arg0: number, arg1: Internal.Class_<any>): this;
        unwrap(): this;
        hasWrappers(): boolean;
        static methodType(arg0: Internal.Class_<any>, arg1: Internal.Class_<any>[]): Internal.MethodType;
        static methodType(arg0: Internal.Class_<any>, arg1: Internal.MethodType_): Internal.MethodType;
        static methodType(arg0: Internal.Class_<any>, arg1: Internal.Class_<any>, ...arg2: Internal.Class_<any>[]): Internal.MethodType;
        static methodType(arg0: Internal.Class_<any>, arg1: Internal.List_<Internal.Class_<any>>): Internal.MethodType;
        static methodType(arg0: Internal.Class_<any>, arg1: Internal.Class_<any>): Internal.MethodType;
        static methodType(arg0: Internal.Class_<any>): Internal.MethodType;
        parameterArray(): Internal.Class<any>[];
        hashCode(): number;
        appendParameterTypes(arg0: Internal.List_<Internal.Class_<any>>): this;
        appendParameterTypes(...arg0: Internal.Class_<any>[]): this;
        parameterType(arg0: number): typeof any;
        erase(): this;
        parameterCount(): number;
        descriptorString(): string;
        insertParameterTypes(arg0: number, arg1: Internal.List_<Internal.Class_<any>>): this;
        insertParameterTypes(arg0: number, ...arg1: Internal.Class_<any>[]): this;
        generic(): this;
        hasPrimitives(): boolean;
        equals(arg0: any): boolean;
        parameterList(): Internal.List<Internal.Class<any>>;
        toString(): string;
        static genericMethodType(arg0: number, arg1: boolean): Internal.MethodType;
        static genericMethodType(arg0: number): Internal.MethodType;
        wrap(): this;
        returnType(): typeof any;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MethodType_ = MethodType;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.QuestShape
    */
    class QuestShape extends Internal.Icon {
        drawStatic(matrixStack: Internal.PoseStack_, x: number, y: number, w: number, h: number): void;
        static reload(list: Internal.List_<string>): void;
        hashCode(): number;
        equals(o: any): boolean;
        static get(id: string): Internal.QuestShape;
        toString(): string;
        getShapePixels(): Internal.PixelBuffer;
        draw(matrixStack: Internal.PoseStack_, x: number, y: number, w: number, h: number): void;
        draw3D(matrixStack: Internal.PoseStack_): void;
        readonly "outline" : Internal.ImageIcon;
        static "idMapWithDefault" : Internal.NameMap<string>;
        readonly "shape" : Internal.ImageIcon;
        readonly "background" : Internal.ImageIcon;
        static "idMap" : Internal.NameMap<string>;
        readonly "id" : string;
        static readonly "MAP" : {"circle":Internal.QuestShape,"square":Internal.QuestShape,"rsquare":Internal.QuestShape,"diamond":Internal.QuestShape,"pentagon":Internal.QuestShape,"hexagon":Internal.QuestShape,"octagon":Internal.QuestShape,"heart":Internal.QuestShape,"gear":Internal.QuestShape};
        get shapePixels(): Internal.PixelBuffer;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: string);
    }
    type QuestShape_ = QuestShape;
    /**
    * @javaClass net.minecraft.class_3230
    */
    class TicketType <T> {
        getComparator(): Internal.Comparator<T>;
        static create<T>($$0: string, $$1: Internal.Comparator_<T>, $$2: number): Internal.TicketType<T>;
        static create<T>($$0: string, $$1: Internal.Comparator_<T>): Internal.TicketType<T>;
        toString(): string;
        timeout(): number;
        static readonly "PLAYER" : Internal.TicketType<Internal.ChunkPos>;
        static readonly "POST_TELEPORT" : Internal.TicketType<number>;
        static readonly "LIGHT" : Internal.TicketType<Internal.ChunkPos>;
        static readonly "DRAGON" : Internal.TicketType<Internal.Unit>;
        static readonly "START" : Internal.TicketType<Internal.Unit>;
        static readonly "FORCED" : Internal.TicketType<Internal.ChunkPos>;
        static readonly "UNKNOWN" : Internal.TicketType<Internal.ChunkPos>;
        static readonly "PORTAL" : Internal.TicketType<BlockPos>;
        get comparator(): Internal.Comparator<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TicketType_<T> = TicketType<T>;
    /**
    * @javaClass net.minecraft.class_1761
    */
    abstract class CreativeModeTab implements Internal.ItemGroupExtensions {
        isAlignedRight(): boolean;
        isTopRow(): boolean;
        getEnchantmentCategories(): Internal.EnchantmentCategory[];
        makeIcon(): Internal.ItemStack;
        fillItemList($$0: Internal.NonNullList_<Internal.ItemStack_>): void;
        getId(): number;
        getBackgroundSuffix(): string;
        setRecipeFolderName($$0: string): this;
        hideScroll(): this;
        hideTitle(): this;
        getDisplayName(): net.minecraft.network.chat.Component;
        showTitle(): boolean;
        getColumn(): number;
        getRecipeFolderName(): string;
        setBackgroundSuffix($$0: string): this;
        fabric_expandArray(): void;
        getIconItem(): Internal.ItemStack;
        canScroll(): boolean;
        setEnchantmentCategories(...$$0: Internal.EnchantmentCategory_[]): this;
        hasEnchantmentCategory($$0: Internal.EnchantmentCategory_): boolean;
        static readonly "TAB_MISC" : Internal.CreativeModeTab;
        static readonly "TAB_MATERIALS" : Internal.CreativeModeTab;
        static readonly "TAB_HOTBAR" : Internal.CreativeModeTab;
        static readonly "TAB_INVENTORY" : Internal.CreativeModeTab;
        static readonly "TAB_TOOLS" : Internal.CreativeModeTab;
        static readonly "TAB_BREWING" : Internal.CreativeModeTab;
        static readonly "TAB_SEARCH" : Internal.CreativeModeTab;
        static readonly "TAB_COMBAT" : Internal.CreativeModeTab;
        static readonly "TAB_BUILDING_BLOCKS" : Internal.CreativeModeTab;
        static "TABS" : Internal.CreativeModeTab[];
        static readonly "TAB_DECORATIONS" : Internal.CreativeModeTab;
        static readonly "TAB_TRANSPORTATION" : Internal.CreativeModeTab;
        static readonly "TAB_FOOD" : Internal.CreativeModeTab;
        readonly "langId" : string;
        static readonly "TAB_REDSTONE" : Internal.CreativeModeTab;
        get enchantmentCategories(): Internal.EnchantmentCategory[];
        get iconItem(): Internal.ItemStack;
        get displayName(): net.minecraft.network.chat.Component;
        get topRow(): boolean;
        get column(): number;
        get recipeFolderName(): string;
        get backgroundSuffix(): string;
        get alignedRight(): boolean;
        get id(): number;
        set enchantmentCategories(...$$0: Internal.EnchantmentCategory_[]);
        set recipeFolderName($$0: string);
        set backgroundSuffix($$0: string);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: string);
    }
    type CreativeModeTab_ = CreativeModeTab;
    /**
    * @javaClass net.minecraft.class_1920
    */
    interface BlockAndTintGetter extends Internal.BlockGetter {
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        getLightEngine(): Internal.LevelLightEngine;
        getMaxLightLevel(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getSectionsCount(): number;
        getSectionIndexFromSectionY($$0: number): number;
        getBlockEntity<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getLightEmission($$0: BlockPos_): number;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getMinSection(): number;
        canSeeSky($$0: BlockPos_): boolean;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getMaxBuildHeight(): number;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getSectionYFromSectionIndex($$0: number): number;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
    }
    type BlockAndTintGetter_ = BlockAndTintGetter;
    /**
    * @javaClass net.minecraft.class_5539
    */
    interface LevelHeightAccessor {
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        getHeight(): number;
        getMaxBuildHeight(): number;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        getSectionIndexFromSectionY($$0: number): number;
        getMinSection(): number;
        create($$0: number, $$1: number): this;
        getSectionYFromSectionIndex($$0: number): number;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
    }
    type LevelHeightAccessor_ = LevelHeightAccessor;
    /**
    * @javaClass net.minecraft.class_3773
    */
    interface StructurePieceType {
        load(arg0: Internal.StructurePieceSerializationContext_, arg1: Internal.CompoundTag_): Internal.StructurePiece;
    }
    type StructurePieceType_ = Special.StructurePieceType | StructurePieceType;
    /**
    * @javaClass net.minecraft.class_296$class_297
    */
    class VertexFormatElement$Type extends Internal.Enum<Internal.VertexFormatElement$Type> {
        getGlType(): number;
        getSize(): number;
        getName(): string;
        static valueOf($$0: string): Internal.VertexFormatElement$Type;
        static values(): Internal.VertexFormatElement$Type[];
        static readonly "UBYTE" : Internal.VertexFormatElement$Type;
        static readonly "FLOAT" : Internal.VertexFormatElement$Type;
        static readonly "BYTE" : Internal.VertexFormatElement$Type;
        static readonly "USHORT" : Internal.VertexFormatElement$Type;
        static readonly "UINT" : Internal.VertexFormatElement$Type;
        static readonly "INT" : Internal.VertexFormatElement$Type;
        static readonly "SHORT" : Internal.VertexFormatElement$Type;
        get glType(): number;
        get size(): number;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type VertexFormatElement$Type_ = "ubyte" | "byte" | "short" | "ushort" | "float" | "uint" | "int" | VertexFormatElement$Type;
    /**
    * @javaClass com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour
    */
    interface MovementBehaviour {
        writeExtraData(context: Internal.MovementContext_): void;
        createInstance(materialManager: Internal.MaterialManager_, simulationWorld: Internal.VirtualRenderWorld_, context: Internal.MovementContext_): Internal.ActorInstance;
        visitNewPosition(context: Internal.MovementContext_, pos: BlockPos_): void;
        getActiveAreaOffset(context: Internal.MovementContext_): Vec3;
        stopMoving(context: Internal.MovementContext_): void;
        tick(context: Internal.MovementContext_): void;
        isActive(context: Internal.MovementContext_): boolean;
        cancelStall(context: Internal.MovementContext_): void;
        dropItem(context: Internal.MovementContext_, stack: Internal.ItemStack_): void;
        startMoving(context: Internal.MovementContext_): void;
        renderInContraption(context: Internal.MovementContext_, renderWorld: Internal.VirtualRenderWorld_, matrices: Internal.ContraptionMatrices_, buffer: Internal.MultiBufferSource_): void;
        hasSpecialInstancedRendering(): boolean;
        renderAsNormalTileEntity(): boolean;
        onSpeedChanged(context: Internal.MovementContext_, oldMotion: Vec3_, motion: Vec3_): void;
    }
    type MovementBehaviour_ = MovementBehaviour;
    /**
    * @javaClass xaero.common.mixin.MixinChunkDeltaUpdateS2CPacketAccessor
    */
    interface MixinChunkDeltaUpdateS2CPacketAccessor {
        getSectionPos(): Internal.SectionPos;
    }
    type MixinChunkDeltaUpdateS2CPacketAccessor_ = MixinChunkDeltaUpdateS2CPacketAccessor;
    /**
    * @javaClass java.util.function.BinaryOperator
    */
    interface BinaryOperator <T> extends Internal.BiFunction<T, T, T> {
        maxBy<T>(arg0: Internal.Comparator_<T>): Internal.BinaryOperator<T>;
        minBy<T>(arg0: Internal.Comparator_<T>): Internal.BinaryOperator<T>;
        andThen<V>(arg0: Internal.Function_<T, V>): Internal.BiFunction<T, T, V>;
    }
    type BinaryOperator_<T> = BinaryOperator<T>;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.entity.Navigation
    */
    class Navigation {
        search(maxDistance: number, maxCost: number, forward: boolean, stationTest: Internal.Navigation$StationTest_): void;
        search(maxDistance: number, forward: boolean, stationTest: Internal.Navigation$StationTest_): void;
        cancelNavigation(): void;
        read(tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): void;
        findNearestApproachable(forward: boolean): Internal.GlobalStation;
        control(mp: Internal.TravellingPoint_): Internal.TravellingPoint$ITrackSelector;
        tick(level: Internal.Level_): void;
        startNavigation(destination: Internal.GlobalStation_, maxCost: number, simulate: boolean): number;
        isActive(): boolean;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        controlSignalScout(): Internal.TravellingPoint$ITrackSelector;
        "distanceToDestination" : number;
        "destination" : Internal.GlobalStation;
        "announceArrival" : boolean;
        "ticksWaitingForSignal" : number;
        "waitingForSignal" : com.simibubi.create.foundation.utility.Pair<Internal.UUID, boolean>;
        "distanceStartedAt" : number;
        "destinationBehindTrain" : boolean;
        "distanceToSignal" : number;
        "train" : Internal.Train;
        get active(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(train: Internal.Train);
    }
    type Navigation_ = Navigation;
    /**
    * Fired by different tag when the game:
    * - is initializing
    * - is post-initializing
    * @javaClass dev.latvian.mods.kubejs.event.StartupEventJS
    */
    class StartupEventJS extends Internal.EventJS {
        post(id: string): boolean;
        post(id: string, sub: string): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    /**
    * Fired by different tag when the game:
    * - is initializing
    * - is post-initializing
    */
    type StartupEventJS_ = StartupEventJS;
    /**
    * @javaClass vazkii.patchouli.mixin.client.AccessorMultiBufferSource
    */
    interface AccessorMultiBufferSource {
        getFallbackBuffer(): Internal.BufferBuilder;
        getFixedBuffers(): Internal.Map<Internal.RenderType, Internal.BufferBuilder>;
    }
    type AccessorMultiBufferSource_ = AccessorMultiBufferSource;
    /**
    * @javaClass net.minecraft.class_4149
    */
    class SensorType <U> {
        create(): U;
        static readonly "AXOLOTL_TEMPTATIONS" : Internal.SensorType<Internal.TemptingSensor>;
        static readonly "GOLEM_DETECTED" : Internal.SensorType<Internal.GolemSensor>;
        static readonly "NEAREST_ADULT" : Internal.SensorType<Internal.AdultSensor>;
        static readonly "DUMMY" : Internal.SensorType<Internal.DummySensor>;
        static readonly "AXOLOTL_ATTACKABLES" : Internal.SensorType<Internal.AxolotlAttackablesSensor>;
        static readonly "NEAREST_LIVING_ENTITIES" : Internal.SensorType<Internal.NearestLivingEntitySensor>;
        static readonly "HURT_BY" : Internal.SensorType<Internal.HurtBySensor>;
        static readonly "VILLAGER_HOSTILES" : Internal.SensorType<Internal.VillagerHostilesSensor>;
        static readonly "VILLAGER_BABIES" : Internal.SensorType<Internal.VillagerBabiesSensor>;
        static readonly "NEAREST_ITEMS" : Internal.SensorType<Internal.NearestItemSensor>;
        static readonly "NEAREST_PLAYERS" : Internal.SensorType<Internal.PlayerSensor>;
        static readonly "PIGLIN_SPECIFIC_SENSOR" : Internal.SensorType<Internal.PiglinSpecificSensor>;
        static readonly "NEAREST_BED" : Internal.SensorType<Internal.NearestBedSensor>;
        static readonly "SECONDARY_POIS" : Internal.SensorType<Internal.SecondaryPoiSensor>;
        static readonly "PIGLIN_BRUTE_SPECIFIC_SENSOR" : Internal.SensorType<Internal.PiglinBruteSpecificSensor>;
        static readonly "GOAT_TEMPTATIONS" : Internal.SensorType<Internal.TemptingSensor>;
        static readonly "HOGLIN_SPECIFIC_SENSOR" : Internal.SensorType<Internal.HoglinSpecificSensor>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type SensorType_<U> = Special.SensorType | SensorType<U>;
    /**
    * @javaClass com.telepathicgrunt.the_bumblezone.mixin.world.BiomeSourceAccessor
    */
    interface BiomeSourceAccessor {
        getPossibleBiomes(): Internal.Set<Internal.Holder<Internal.Biome>>;
    }
    type BiomeSourceAccessor_ = BiomeSourceAccessor;
    /**
    * @javaClass com.mojang.brigadier.builder.RequiredArgumentBuilder
    */
    class RequiredArgumentBuilder <S, T> extends Internal.ArgumentBuilder<S, Internal.RequiredArgumentBuilder<S, T>> {
        suggests(arg0: Internal.SuggestionProvider_<S>): Internal.RequiredArgumentBuilder<S, T>;
        static argument<S, T>(arg0: string, arg1: Internal.ArgumentType_<T>): Internal.RequiredArgumentBuilder<S, T>;
        getName(): string;
        build(): Internal.ArgumentCommandNode<S, T>;
        getType(): Internal.ArgumentType<T>;
        getSuggestionsProvider(): Internal.SuggestionProvider<S>;
        get suggestionsProvider(): Internal.SuggestionProvider<S>;
        get name(): string;
        get type(): Internal.ArgumentType<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type RequiredArgumentBuilder_<S, T> = RequiredArgumentBuilder<S, T>;
    /**
    * @javaClass net.minecraft.class_1632
    */
    class Vindicator extends Internal.AbstractIllager {
        method_16484($$0: number, $$1: boolean): void;
        method_5722($$0: Internal.Entity_): boolean;
        method_20033(): Internal.SoundEvent;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        canRiderInteract(): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_6990(): Internal.AbstractIllager$IllagerArmPose;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5665($$0: net.minecraft.network.chat.Component_): void;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Vindicator>, $$1: Internal.Level);
    }
    type Vindicator_ = Vindicator;
    /**
    * Fired when player right clicks with item on hand.
    *
    * Note that this will only be fired when hand has item.
    *
    * On cancellation, Result.SUCCESS is returned, thus making player swing his arm.
    * @javaClass dev.latvian.mods.kubejs.item.ItemRightClickEventJS
    */
    class ItemRightClickEventJS extends Internal.PlayerEventJS {
        getHand(): Hand;
        getItem(): Internal.ItemStackJS;
        getEntity(): Internal.EntityJS;
        canCancel(): boolean;
        get item(): Internal.ItemStackJS;
        get entity(): Internal.EntityJS;
        get hand(): Hand;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(player: Internal.Player, hand: Hand);
    }
    /**
    * Fired when player right clicks with item on hand.
    *
    * Note that this will only be fired when hand has item.
    *
    * On cancellation, Result.SUCCESS is returned, thus making player swing his arm.
    */
    type ItemRightClickEventJS_ = ItemRightClickEventJS;
    /**
    * @javaClass fr.atesab.customcursormod.fabric.mixin.HandledScreenMixin
    */
    interface HandledScreenMixin {
        getFocusedSlot(): Internal.Slot;
    }
    type HandledScreenMixin_ = HandledScreenMixin;
    /**
    * @javaClass me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapter
    */
    interface EntrySettingsAdapter <T, S> {
        provide(arg0: Internal.EntryStack_<T>, arg1: Internal.EntryStack$Settings_<S>, arg2: S): S;
        empty<T, S>(): Internal.EntrySettingsAdapter<T, S>;
    }
    type EntrySettingsAdapter_<T, S> = ((arg0: Internal.EntryStack<T>, arg1: Internal.EntryStack$Settings<S>, arg2: S) => S) | EntrySettingsAdapter<T, S>;
    /**
    * @javaClass xaero.map.biome.BiomeGetter
    */
    class BiomeGetter {
        getBiome(world: Internal.Level_, pos: BlockPos_, biomeRegistry: Internal.Registry_<Internal.Biome_>): Internal.BiomeKey;
        readonly "UNKNOWN_BIOME" : Internal.BiomeKey;
        readonly "PLACEHOLDER_BIOME" : Internal.BiomeKey;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(biomeKeyManager: any);
    }
    type BiomeGetter_ = BiomeGetter;
    /**
    * @javaClass net.minecraft.class_1941
    */
    interface CollisionGetter extends Internal.BlockGetter {
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        getEntityCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getSectionsCount(): number;
        getBlockEntity<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getLightEmission($$0: BlockPos_): number;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionYFromSectionIndex($$0: number): number;
        getSectionIndex($$0: number): number;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxLightLevel(): number;
        noCollision($$0: Internal.Entity_): boolean;
        noCollision($$0: Internal.AABB_): boolean;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getChunkForCollisions(arg0: number, arg1: number): Internal.BlockGetter;
        getSectionIndexFromSectionY($$0: number): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3>;
        getMinSection(): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getMaxBuildHeight(): number;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getMaxSection(): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getWorldBorder(): Internal.WorldBorder;
    }
    type CollisionGetter_ = CollisionGetter;
    /**
    * @javaClass net.minecraft.class_1092
    */
    class ModelManager extends Internal.SimplePreparableReloadListener<Internal.ModelBakery> implements Internal.AutoCloseable, Internal.AccessorModelManager, Internal.BakedModelManagerHooks, Internal.IdentifiableResourceReloadListener {
        handler$zbl000$port_lib$onModelBake(modelLoader: Internal.ModelBakery_, resourceManager: Internal.ResourceManager_, profiler: Internal.ProfilerFiller_, ci: Internal.CallbackInfo_): void;
        getModel($$0: Internal.ModelResourceLocation_): Internal.BakedModel;
        getName(): string;
        updateMaxMipLevel($$0: number): void;
        requiresRender($$0: Internal.BlockState_, $$1: Internal.BlockState_): boolean;
        getMissingModel(): Internal.BakedModel;
        getFabricId(): ResourceLocation;
        getBlockModelShaper(): Internal.BlockModelShaper;
        fabric_getModel(id: ResourceLocation_): Internal.BakedModel;
        close(): void;
        handler$gjd000$insertBookModel(loader: Internal.ModelBakery_, manager: Internal.ResourceManager_, profiler: Internal.ProfilerFiller_, info: Internal.CallbackInfo_): void;
        getAtlas($$0: ResourceLocation_): Internal.TextureAtlas;
        getFabricDependencies(): Internal.Collection<any>;
        get fabricDependencies(): Internal.Collection<any>;
        get blockModelShaper(): Internal.BlockModelShaper;
        get fabricId(): ResourceLocation;
        get name(): string;
        get missingModel(): Internal.BakedModel;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.TextureManager, $$1: Internal.BlockColors, $$2: number);
    }
    type ModelManager_ = ModelManager;
    /**
    * @javaClass me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry
    */
    interface ItemComparatorRegistry extends Internal.EntryComparatorRegistry<Internal.ItemStack, Internal.Item> {
        getStage(): Internal.ReloadStage;
        acceptPlugin(plugin: Internal.REIPlugin_<any>): void;
        acceptPlugin(plugin: Internal.REIPlugin_<any>, stage: Internal.ReloadStage_): void;
        startReload(stage: Internal.ReloadStage_): void;
        afterReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>): void;
        registerNbt(item: Internal.Item_): void;
        registerNbt(...items: Internal.Item_[]): void;
        endReload(stage: Internal.ReloadStage_): void;
        endReload(): void;
        beforeReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>): void;
        isConcurrent(): boolean;
        getInstance(): this;
        afterReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>, plugin: Internal.REIPlugin_<any>): void;
        beforeReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>, plugin: Internal.REIPlugin_<any>): void;
        register(comparator: Internal.EntryComparator_<Internal.ItemStack_>, ...entries: Internal.Item_[]): void;
    }
    type ItemComparatorRegistry_ = ItemComparatorRegistry;
    /**
    * @javaClass net.minecraft.class_34
    */
    class LevelSummary implements Internal.Comparable<Internal.LevelSummary> {
        getInfo(): net.minecraft.network.chat.Component;
        getSettings(): Internal.LevelSettings;
        levelVersion(): Internal.LevelVersion;
        askToOpenWorld(): boolean;
        getGameMode(): Internal.GameType;
        compareTo($$0: Internal.LevelSummary_): number;
        getLevelName(): string;
        requiresManualConversion(): boolean;
        isCompatible(): boolean;
        getIcon(): Internal.File;
        isHardcore(): boolean;
        hasCheats(): boolean;
        backupStatus(): Internal.LevelSummary$BackupStatus;
        getWorldVersionName(): Internal.MutableComponent;
        getLastPlayed(): number;
        isLocked(): boolean;
        markVersionInList(): boolean;
        isDisabled(): boolean;
        getLevelId(): string;
        get settings(): Internal.LevelSettings;
        get compatible(): boolean;
        get hardcore(): boolean;
        get levelId(): string;
        get icon(): Internal.File;
        get worldVersionName(): Internal.MutableComponent;
        get levelName(): string;
        get disabled(): boolean;
        get gameMode(): Internal.GameType;
        get locked(): boolean;
        get lastPlayed(): number;
        get info(): net.minecraft.network.chat.Component;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.LevelSettings, $$1: Internal.LevelVersion, $$2: string, $$3: boolean, $$4: boolean, $$5: Internal.File);
    }
    type LevelSummary_ = LevelSummary;
    /**
    * @javaClass net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents$BeforeMouseScroll
    */
    interface ScreenMouseEvents$BeforeMouseScroll {
        beforeMouseScroll(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number, arg4: number): void;
    }
    type ScreenMouseEvents$BeforeMouseScroll_ = ((arg0: Internal.Screen, arg1: number, arg2: number, arg3: number, arg4: number) => void) | ScreenMouseEvents$BeforeMouseScroll;
    /**
    * @javaClass com.mojang.datafixers.types.Type$TypeMatcher
    */
    interface Type$TypeMatcher <FT, FR> {
        match<S>(arg0: com.mojang.datafixers.types.Type_<S>): Internal.Either<Internal.TypedOptic<S, any, FT, FR>, Internal.Type$FieldNotFoundException>;
    }
    type Type$TypeMatcher_<FT, FR> = Type$TypeMatcher<FT, FR>;
    /**
    * @javaClass dev.latvian.mods.kubejs.player.ServerPlayerDataJS
    */
    class ServerPlayerDataJS extends Internal.PlayerDataJS<Internal.ServerPlayer, Internal.ServerPlayerJS> {
        getServer(): Internal.ServerJS;
        getPlayer(): Internal.ServerPlayerJS;
        getMinecraftPlayer(): Internal.ServerPlayer;
        getName(): string;
        getProfile(): Internal.GameProfile;
        hasClientMod(): boolean;
        getId(): Internal.UUID;
        getOverworld(): Internal.LevelJS;
        get server(): Internal.ServerJS;
        get minecraftPlayer(): Internal.ServerPlayer;
        get profile(): Internal.GameProfile;
        get name(): string;
        get id(): Internal.UUID;
        get overworld(): Internal.LevelJS;
        get player(): Internal.ServerPlayerJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(s: Internal.ServerJS, i: Internal.UUID, n: string, h: boolean);
    }
    type ServerPlayerDataJS_ = ServerPlayerDataJS;
    /**
    * @javaClass xaero.common.category.rule.ObjectCategoryExcludeList
    */
    class ObjectCategoryExcludeList <E, S> extends Internal.ObjectCategoryListRule<E, S> {
        isFollowedBy(object: E, context: any): boolean;
        getExcludeMode(): Internal.ExcludeListMode;
        spliterator(): Internal.Spliterator<string>;
        forEach(arg0: Internal.Consumer_<string>): void;
        get excludeMode(): Internal.ExcludeListMode;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ObjectCategoryExcludeList_<E, S> = ObjectCategoryExcludeList<E, S>;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.config.NumberConfig
    */
    abstract class NumberConfig <T> extends Internal.ConfigFromString<T> {
        getStringForGUI(v: T): net.minecraft.network.chat.Component;
        getColor(v: T): Internal.Color4I;
        fader(v: boolean): Internal.NumberConfig<T>;
        readonly "min" : T;
        readonly "max" : T;
        static readonly "COLOR" : Internal.Color4I;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(mn: T, mx: T);
    }
    type NumberConfig_<T> = NumberConfig<T>;
    /**
    * @javaClass com.mojang.authlib.minecraft.UserApiService$UserProperties
    */
    class UserApiService$UserProperties extends Internal.Record {
        flag(arg0: Internal.UserApiService$UserFlag_): boolean;
        hashCode(): number;
        equals(arg0: any): boolean;
        flags(): Internal.Set<Internal.UserApiService$UserFlag>;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(flags: Internal.Set<Internal.UserApiService$UserFlag>);
    }
    type UserApiService$UserProperties_ = UserApiService$UserProperties;
    /**
    * @javaClass ru.bclib.recipes.AnvilRecipe$Builder
    */
    class AnvilRecipe$Builder {
        checkConfig(config: Internal.PathConfig_): this;
        build(): void;
        setInputCount(count: number): this;
        setAnvilLevel(level: number): this;
        setToolLevel(level: number): this;
        setDamage(damage: number): this;
        setOutput(output: Internal.ItemLike_, amount: number): this;
        setOutput(output: Internal.ItemLike_): this;
        setInput(...inputItems: Internal.ItemLike_[]): this;
        setInput(inputTag: Internal.TagKey_<Internal.Item_>): this;
        setInput(ingredient: Internal.Ingredient_): this;
        set output(output: Internal.ItemLike_);
        set input(...inputItems: Internal.ItemLike_[]);
        set damage(damage: number);
        set anvilLevel(level: number);
        set toolLevel(level: number);
        set inputCount(count: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AnvilRecipe$Builder_ = AnvilRecipe$Builder;
    /**
    * @javaClass net.minecraft.class_1271
    */
    class InteractionResultHolder <T> {
        static fail<T>($$0: T): Internal.InteractionResultHolder<T>;
        getObject(): T;
        static pass<T>($$0: T): Internal.InteractionResultHolder<T>;
        static success<T>($$0: T): Internal.InteractionResultHolder<T>;
        getResult(): Internal.InteractionResult;
        static consume<T>($$0: T): Internal.InteractionResultHolder<T>;
        static sidedSuccess<T>($$0: T, $$1: boolean): Internal.InteractionResultHolder<T>;
        get result(): Internal.InteractionResult;
        get object(): T;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.InteractionResult, $$1: T);
    }
    type InteractionResultHolder_<T> = InteractionResultHolder<T>;
    /**
    * @javaClass uk.me.desert_island.rer.mixin.FluidBlockHooks
    */
    interface FluidBlockHooks {
        getFluid(): Internal.FlowingFluid;
    }
    type FluidBlockHooks_ = FluidBlockHooks;
    /**
    * @javaClass corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClient
    */
    abstract class LunarEventClient <T> implements Internal.SkyRenderable {
        getMoonSize(): number;
        getMoonTextureLocation(): ResourceLocation;
        getSoundTrack(): Internal.SoundEvent;
        getColorSettings(): Internal.ColorSettings;
        renderSky(matrixStackIn: Internal.PoseStack_, partialTicks: number): void;
        get moonSize(): number;
        get moonTextureLocation(): ResourceLocation;
        get soundTrack(): Internal.SoundEvent;
        get colorSettings(): Internal.ColorSettings;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(clientSettings: T);
    }
    type LunarEventClient_<T> = LunarEventClient<T>;
    /**
    * @javaClass net.blay09.mods.balm.api.entity.BalmEntity
    */
    interface BalmEntity {
        setBalmData(arg0: Internal.CompoundTag_): void;
        getBalmData(): Internal.CompoundTag;
    }
    type BalmEntity_ = BalmEntity;
    /**
    * @javaClass java.util.Locale
    */
    class Locale implements Internal.Cloneable, Internal.Serializable {
        stripExtensions(): this;
        static forLanguageTag(arg0: string): Internal.Locale;
        getUnicodeLocaleAttributes(): Internal.Set<string>;
        getCountry(): string;
        getUnicodeLocaleKeys(): Internal.Set<string>;
        getISO3Country(): string;
        static lookupTag(arg0: Internal.List_<Internal.Locale$LanguageRange_>, arg1: Internal.Collection_<string>): string;
        getDisplayCountry(): string;
        getDisplayCountry(arg0: Internal.Locale_): string;
        getISO3Language(): string;
        static getISOCountries(arg0: Internal.Locale$IsoCountryCode_): Internal.Set<string>;
        static getISOCountries(): string[];
        hashCode(): number;
        getExtensionKeys(): Internal.Set<string>;
        getDisplayVariant(): string;
        getDisplayVariant(arg0: Internal.Locale_): string;
        static filterTags(arg0: Internal.List_<Internal.Locale$LanguageRange_>, arg1: Internal.Collection_<string>): Internal.List<string>;
        static filterTags(arg0: Internal.List_<Internal.Locale$LanguageRange_>, arg1: Internal.Collection_<string>, arg2: Internal.Locale$FilteringMode_): Internal.List<string>;
        static getISOLanguages(): string[];
        toLanguageTag(): string;
        static getAvailableLocales(): Internal.Locale[];
        getDisplayScript(arg0: Internal.Locale_): string;
        getDisplayScript(): string;
        static lookup(arg0: Internal.List_<Internal.Locale$LanguageRange_>, arg1: Internal.Collection_<Internal.Locale_>): Internal.Locale;
        getLanguage(): string;
        getExtension(arg0: string): string;
        getVariant(): string;
        static getDefault(arg0: Internal.Locale$Category_): Internal.Locale;
        static getDefault(): Internal.Locale;
        static setDefault(arg0: Internal.Locale$Category_, arg1: Internal.Locale_): void;
        static setDefault(arg0: Internal.Locale_): void;
        hasExtensions(): boolean;
        static filter(arg0: Internal.List_<Internal.Locale$LanguageRange_>, arg1: Internal.Collection_<Internal.Locale_>): Internal.List<Internal.Locale>;
        static filter(arg0: Internal.List_<Internal.Locale$LanguageRange_>, arg1: Internal.Collection_<Internal.Locale_>, arg2: Internal.Locale$FilteringMode_): Internal.List<Internal.Locale>;
        getDisplayName(): string;
        getDisplayName(arg0: Internal.Locale_): string;
        equals(arg0: any): boolean;
        clone(): any;
        toString(): string;
        getDisplayLanguage(): string;
        getDisplayLanguage(arg0: Internal.Locale_): string;
        getScript(): string;
        getUnicodeLocaleType(arg0: string): string;
        static readonly "PRC" : Internal.Locale;
        static readonly "CANADA" : Internal.Locale;
        static readonly "ENGLISH" : Internal.Locale;
        static readonly "ROOT" : Internal.Locale;
        static readonly "TAIWAN" : Internal.Locale;
        static readonly "CHINA" : Internal.Locale;
        static readonly "ITALY" : Internal.Locale;
        static readonly "CHINESE" : Internal.Locale;
        static readonly "KOREA" : Internal.Locale;
        static readonly "FRENCH" : Internal.Locale;
        static readonly "FRANCE" : Internal.Locale;
        static readonly "TRADITIONAL_CHINESE" : Internal.Locale;
        static readonly "CANADA_FRENCH" : Internal.Locale;
        static readonly "GERMANY" : Internal.Locale;
        static readonly "ITALIAN" : Internal.Locale;
        static readonly "PRIVATE_USE_EXTENSION" : "x";
        static readonly "UK" : Internal.Locale;
        static readonly "JAPAN" : Internal.Locale;
        static readonly "JAPANESE" : Internal.Locale;
        static readonly "UNICODE_LOCALE_EXTENSION" : "u";
        static readonly "SIMPLIFIED_CHINESE" : Internal.Locale;
        static readonly "GERMAN" : Internal.Locale;
        static readonly "US" : Internal.Locale;
        static readonly "KOREAN" : Internal.Locale;
        get unicodeLocaleKeys(): Internal.Set<string>;
        get country(): string;
        get displayName(): string;
        get iSOLanguages(): string[];
        get displayVariant(): string;
        get language(): string;
        get displayLanguage(): string;
        get script(): string;
        get iSO3Country(): string;
        get availableLocales(): Internal.Locale[];
        get iSOCountries(): string[];
        get unicodeLocaleAttributes(): Internal.Set<string>;
        get default(): Internal.Locale;
        get displayCountry(): string;
        get variant(): string;
        get extensionKeys(): Internal.Set<string>;
        get displayScript(): string;
        get iSO3Language(): string;
        set default(arg0: Internal.Locale_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: string);
        constructor(arg0: string, arg1: string, arg2: string);
        constructor(arg0: string, arg1: string);
    }
    type Locale_ = Locale;
    /**
    * @javaClass eu.ha3.presencefootsteps.sound.Isolator
    */
    interface Isolator {
        getVariator(): Internal.Variator;
        getGolemMap(): Internal.Lookup<Internal.EntityType<any>>;
        getPrimitiveMap(): Internal.Lookup<Internal.SoundType>;
        getStepPlayer(): Internal.StepSoundPlayer;
        getBlockMap(): Internal.Lookup<Internal.BlockState>;
        getSolver(): Internal.Solver;
        getLocomotionMap(): Internal.Index<Internal.Entity, Internal.Locomotion>;
        getSoundPlayer(): Internal.SoundPlayer;
        getAcoustics(): Internal.AcousticLibrary;
    }
    type Isolator_ = Isolator;
    /**
    * @javaClass net.minecraft.class_6019
    */
    class UniformInt extends Internal.IntProvider {
        method_35012(): Internal.IntProviderType<any>;
        static of($$0: number, $$1: number): Internal.UniformInt;
        method_35011(): number;
        toString(): string;
        method_35009(): number;
        method_35008($$0: Internal.Random_): number;
        static readonly "CODEC" : Internal.Codec<Internal.UniformInt>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type UniformInt_ = UniformInt;
    /**
    * @javaClass net.fabricmc.fabric.api.loot.v1.FabricLootPool
    */
    interface FabricLootPool {
        getEntries(): Internal.List<Internal.LootPoolEntryContainer>;
        getRolls(): Internal.NumberProvider;
        getFunctions(): Internal.List<Internal.LootItemFunction>;
        getConditions(): Internal.List<Internal.LootItemCondition>;
        asVanilla(): Internal.LootPool;
    }
    type FabricLootPool_ = FabricLootPool;
    /**
    * @javaClass net.minecraft.class_778
    */
    class ModelBlockRenderer implements Internal.AccessBlockModelRenderer {
        static enableCaching(): void;
        fabric_updateShape(blockView: Internal.BlockAndTintGetter_, blockState: Internal.BlockState_, pos: BlockPos_, vertexData: number[], face: Internal.Direction_, aoData: number[], controlBits: Internal.BitSet_): void;
        tesselateWithAO($$0: Internal.BlockAndTintGetter_, $$1: Internal.BakedModel_, $$2: Internal.BlockState_, $$3: BlockPos_, $$4: Internal.PoseStack_, $$5: Internal.VertexConsumer_, $$6: boolean, $$7: Internal.Random_, $$8: number, $$9: number): boolean;
        tesselateBlock($$0: Internal.BlockAndTintGetter_, $$1: Internal.BakedModel_, $$2: Internal.BlockState_, $$3: BlockPos_, $$4: Internal.PoseStack_, $$5: Internal.VertexConsumer_, $$6: boolean, $$7: Internal.Random_, $$8: number, $$9: number): boolean;
        static clearCache(): void;
        renderModel(entry: Internal.PoseStack$Pose_, vertexConsumer: Internal.VertexConsumer_, blockState: Internal.BlockState_, bakedModel: Internal.BakedModel_, red: number, green: number, blue: number, light: number, overlay: number): void;
        tesselateWithoutAO($$0: Internal.BlockAndTintGetter_, $$1: Internal.BakedModel_, $$2: Internal.BlockState_, $$3: BlockPos_, $$4: Internal.PoseStack_, $$5: Internal.VertexConsumer_, $$6: boolean, $$7: Internal.Random_, $$8: number, $$9: number): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockColors);
    }
    type ModelBlockRenderer_ = ModelBlockRenderer;
    /**
    * @javaClass com.minelittlepony.common.client.gui.dimension.Padding
    */
    class Padding {
        setVertical(padding: number): void;
        setHorizontal(padding: number): void;
        setAll(padding: number): void;
        "top" : number;
        "left" : number;
        "bottom" : number;
        "right" : number;
        set all(padding: number);
        set horizontal(padding: number);
        set vertical(padding: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(top: number, left: number, bottom: number, right: number);
    }
    type Padding_ = Padding;
    /**
    * @javaClass me.shedaniel.rei.api.common.plugins.PluginManager
    */
    interface PluginManager <P> extends Internal.ParentReloadable<P> {
        getStage(): Internal.ReloadStage;
        isReloading(): boolean;
        startReload(stage: Internal.ReloadStage_): void;
        startReload(): void;
        getClientInstance(): Internal.PluginManager<Internal.REIClientPlugin>;
        isConcurrent(): boolean;
        endReload(): void;
        endReload(stage: Internal.ReloadStage_): void;
        beforeReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<P>): void;
        afterReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<P>, plugin: P): void;
        getPluginProviders(): Internal.List<Internal.REIPluginProvider<P>>;
        acceptPlugin(plugin: P): void;
        acceptPlugin(plugin: P, stage: Internal.ReloadStage_): void;
        view(): Internal.PluginView<P>;
        areAnyReloading(): boolean;
        afterReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<P>): void;
        getActiveInstances(): Internal.List<Internal.PluginManager<Internal.REIPlugin<any>>>;
        get<T>(arg0: Internal.Class_<T>): T;
        getPlugins(): Internal.Iterable<P>;
        getServerInstance(): Internal.PluginManager<Internal.REIServerPlugin>;
        getInstance(): Internal.PluginManager<Internal.REIPlugin<any>>;
        beforeReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<P>, plugin: P): void;
    }
    type PluginManager_<P> = PluginManager<P>;
    /**
    * @javaClass net.minecraft.class_6795
    */
    class HeightRangePlacement extends Internal.PlacementModifier {
        static uniform($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_): Internal.HeightRangePlacement;
        static of($$0: Internal.HeightProvider_): Internal.HeightRangePlacement;
        method_14452($$0: Internal.PlacementContext_, $$1: Internal.Random_, $$2: BlockPos_): Internal.Stream<BlockPos>;
        static triangle($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_): Internal.HeightRangePlacement;
        method_39615(): Internal.PlacementModifierType<any>;
        static readonly "CODEC" : Internal.Codec<Internal.HeightRangePlacement>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type HeightRangePlacement_ = HeightRangePlacement;
    /**
    * @javaClass net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder
    */
    class FabricEntityTypeBuilder <T> {
        trackable(trackRangeBlocks: number, trackedUpdateRate: number, forceTrackedVelocityUpdates: boolean): Internal.FabricEntityTypeBuilder<T>;
        trackable(trackRangeBlocks: number, trackedUpdateRate: number): Internal.FabricEntityTypeBuilder<T>;
        disableSummon(): Internal.FabricEntityTypeBuilder<T>;
        trackedUpdateRate(rate: number): Internal.FabricEntityTypeBuilder<T>;
        spawnableFarFromPlayer(): Internal.FabricEntityTypeBuilder<T>;
        specificSpawnBlocks(...blocks: Internal.Block_[]): Internal.FabricEntityTypeBuilder<T>;
        forceTrackedVelocityUpdates(forceTrackedVelocityUpdates: boolean): Internal.FabricEntityTypeBuilder<T>;
        trackRangeChunks(range: number): Internal.FabricEntityTypeBuilder<T>;
        trackRangeBlocks(range: number): Internal.FabricEntityTypeBuilder<T>;
        fireImmune(): Internal.FabricEntityTypeBuilder<T>;
        static createMob<T>(): Internal.FabricEntityTypeBuilder$Mob<T>;
        disableSaving(): Internal.FabricEntityTypeBuilder<T>;
        build(): Internal.EntityType<T>;
        static create<T>(spawnGroup: Internal.MobCategory_, factory: Internal.EntityType$EntityFactory_<T>): Internal.FabricEntityTypeBuilder<T>;
        static create<T>(spawnGroup: Internal.MobCategory_): Internal.FabricEntityTypeBuilder<T>;
        static create<T>(): Internal.FabricEntityTypeBuilder<T>;
        static createLiving<T>(): Internal.FabricEntityTypeBuilder$Living<T>;
        entityFactory<N>(factory: Internal.EntityType$EntityFactory_<N>): Internal.FabricEntityTypeBuilder<N>;
        spawnGroup(group: Internal.MobCategory_): Internal.FabricEntityTypeBuilder<T>;
        dimensions(dimensions: Internal.EntityDimensions_): Internal.FabricEntityTypeBuilder<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FabricEntityTypeBuilder_<T> = FabricEntityTypeBuilder<T>;
    /**
    * @javaClass net.blay09.mods.balm.mixin.ScreenAccessor
    */
    interface ScreenAccessor {
        balm_getChildren(): Internal.List<Internal.GuiEventListener>;
        balm_getRenderables(): Internal.List<Internal.Widget>;
        balm_getNarratables(): Internal.List<Internal.NarratableEntry>;
    }
    type ScreenAccessor_ = ScreenAccessor;
    /**
    * @javaClass net.minecraft.class_1613
    */
    class Skeleton extends Internal.AbstractSkeleton {
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        method_35191(): boolean;
        canRiderInteract(): boolean;
        setFreezeConverting($$0: boolean): void;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_32316(): boolean;
        isFreezeConverting(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        static readonly "CONVERSION_TAG" : "StrayConversionTime";
        get freezeConverting(): boolean;
        get stepHeight(): number;
        set freezeConverting($$0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Skeleton>, $$1: Internal.Level);
    }
    type Skeleton_ = Skeleton;
    /**
    * @javaClass draylar.gofish.api.SmeltingBobber
    */
    interface SmeltingBobber {
        gf_setSmelts(arg0: boolean): void;
        gf_canSmelt(): boolean;
    }
    type SmeltingBobber_ = SmeltingBobber;
    /**
    * @javaClass wraith.waystones.mixin.ClientPlayerEntityAccessor
    */
    interface ClientPlayerEntityAccessor {
        getNetworkHandler(): Internal.ClientPacketListener;
    }
    type ClientPlayerEntityAccessor_ = ClientPlayerEntityAccessor;
    /**
    * @javaClass me.shedaniel.rei.api.client.registry.category.CategoryRegistry$CategoryConfiguration
    */
    interface CategoryRegistry$CategoryConfiguration <T> extends Internal.Identifiable {
        removePlusButton(): void;
        addWorkstations(...stations: Internal.EntryStack_<any>[]): void;
        addWorkstations(...arg0: Internal.EntryIngredient_[]): void;
        getPlusButtonArea(): Internal.Optional<Internal.ButtonArea>;
        getWorkstations(): Internal.List<Internal.EntryIngredient>;
        registerExtension(arg0: Internal.CategoryExtensionProvider_<T>): void;
        getCategoryIdentifier(): Internal.CategoryIdentifier<any>;
        getIdentifier(): ResourceLocation;
        getCategory(): Internal.DisplayCategory<T>;
        setPlusButtonArea(arg0: Internal.ButtonArea_): void;
        getView(arg0: T): Internal.DisplayCategoryView<T>;
    }
    type CategoryRegistry$CategoryConfiguration_<T> = CategoryRegistry$CategoryConfiguration<T>;
    /**
    * @javaClass net.minecraft.class_1697
    */
    class MinecartCommandBlock extends Internal.AbstractMinecart {
        method_7518(): Internal.AbstractMinecart$Type;
        method_7517(): Internal.BlockState;
        method_7506($$0: number, $$1: number, $$2: number, $$3: boolean): void;
        method_5833(): boolean;
        getStepHeight(): number;
        getMaxSpeedOnRail(): number;
        getCommandBlock(): Internal.BaseCommandBlock;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        alwaysAccepts(): boolean;
        method_5688($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        get stepHeight(): number;
        get maxSpeedOnRail(): number;
        get commandBlock(): Internal.BaseCommandBlock;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.MinecartCommandBlock>, $$1: Internal.Level);
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number);
    }
    type MinecartCommandBlock_ = MinecartCommandBlock;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.ShovelItemBuilder
    */
    class ShovelItemBuilder extends Internal.HandheldItemBuilder {
        createObject(): Internal.Item;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type ShovelItemBuilder_ = ShovelItemBuilder;
    /**
    * @javaClass com.mojang.authlib.GameProfileRepository
    */
    interface GameProfileRepository {
        findProfilesByNames(arg0: string[], arg1: Internal.Agent_, arg2: Internal.ProfileLookupCallback_): void;
    }
    type GameProfileRepository_ = GameProfileRepository;
    /**
    * @javaClass net.minecraft.class_1842
    */
    class Potion implements Internal.RegistryUtil {
        getEffects(): Internal.List<Internal.MobEffectInstance>;
        getName($$0: string): string;
        hasInstantEffects(): boolean;
        static byName($$0: string): Internal.Potion;
        thonkutil$getId(): ResourceLocation;
        readonly "name" : string;
        get effects(): Internal.List<Internal.MobEffectInstance>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: Internal.MobEffectInstance[]);
        constructor($$0: Internal.MobEffectInstance[]);
    }
    type Potion_ = Special.Potion | Potion;
    /**
    * @javaClass net.minecraft.class_5780
    */
    class GlowLichenConfiguration implements Internal.FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        readonly "canPlaceOnWall" : boolean;
        readonly "chanceOfSpreading" : number;
        static readonly "CODEC" : Internal.Codec<Internal.GlowLichenConfiguration>;
        readonly "canPlaceOnCeiling" : boolean;
        readonly "validDirections" : Internal.List<Internal.Direction>;
        readonly "searchRange" : number;
        readonly "canPlaceOnFloor" : boolean;
        readonly "canBePlacedOn" : Internal.HolderSet<Internal.Block>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: boolean, $$2: boolean, $$3: boolean, $$4: number, $$5: Internal.HolderSet<Internal.Block>);
    }
    type GlowLichenConfiguration_ = GlowLichenConfiguration;
    /**
    * @javaClass net.minecraft.class_1677
    */
    class SmallFireball extends Internal.Fireball {
        canRiderInteract(): boolean;
        getStepHeight(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        method_5863(): boolean;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number);
        constructor($$0: Internal.Level, $$1: Internal.LivingEntity, $$2: number, $$3: number, $$4: number);
        constructor($$0: Internal.EntityType<Internal.SmallFireball>, $$1: Internal.Level);
    }
    type SmallFireball_ = SmallFireball;
    /**
    * @javaClass java.nio.CharBuffer
    */
    abstract class CharBuffer extends Internal.Buffer implements Internal.Comparable<Internal.CharBuffer>, Internal.Appendable, Internal.CharSequence, Internal.Readable {
        compact(): this;
        compareTo(arg0: Internal.CharBuffer_): number;
        asReadOnlyBuffer(): this;
        put(arg0: Internal.CharBuffer_): this;
        put(arg0: string, arg1: number, arg2: number): this;
        put(arg0: number, arg1: string[]): this;
        put(arg0: number, arg1: string): this;
        put(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        put(arg0: string[]): this;
        put(arg0: string[], arg1: number, arg2: number): this;
        put(arg0: number, arg1: Internal.CharBuffer_, arg2: number, arg3: number): this;
        put(arg0: string): this;
        slice(): this;
        slice(arg0: number, arg1: number): this;
        array(): string[];
        hashCode(): number;
        get(): string;
        get(arg0: number): string;
        get(arg0: string[], arg1: number, arg2: number): this;
        get(arg0: string[]): this;
        get(arg0: number, arg1: string[]): this;
        get(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        limit(arg0: number): this;
        arrayOffset(): number;
        flip(): this;
        codePoints(): Internal.IntStream;
        order(): Internal.ByteOrder;
        hasArray(): boolean;
        read(arg0: Internal.CharBuffer_): number;
        isEmpty(): boolean;
        clear(): this;
        length(): number;
        duplicate(): this;
        subSequence(arg0: number, arg1: number): this;
        static allocate(arg0: number): Internal.CharBuffer;
        rewind(): this;
        mismatch(arg0: Internal.CharBuffer_): number;
        equals(arg0: any): boolean;
        reset(): this;
        toString(): string;
        position(arg0: number): this;
        isDirect(): boolean;
        static wrap(arg0: string[], arg1: number, arg2: number): Internal.CharBuffer;
        static wrap(arg0: string[]): Internal.CharBuffer;
        static wrap(arg0: Internal.CharSequence_): Internal.CharBuffer;
        static wrap(arg0: Internal.CharSequence_, arg1: number, arg2: number): Internal.CharBuffer;
        mark(): this;
        chars(): Internal.IntStream;
        charAt(arg0: number): string;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        append(arg0: Internal.CharSequence_): this;
        append(arg0: string): this;
        get direct(): boolean;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type CharBuffer_ = CharBuffer;
    /**
    * @javaClass xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer
    */
    class MultiTextureRenderTypeRenderer {
        begin(mode: Internal.VertexFormat$Mode_, format: Internal.VertexFormat_, textureId: number): Internal.BufferBuilder;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MultiTextureRenderTypeRenderer_ = MultiTextureRenderTypeRenderer;
    /**
    * @javaClass net.darkhax.bookshelf.mixin.client.AccessorFontManager
    */
    interface AccessorFontManager {
        bookshelf$getFonts(): Internal.Map<ResourceLocation, Internal.FontSet>;
    }
    type AccessorFontManager_ = AccessorFontManager;
    /**
    * @javaClass net.minecraft.class_1668
    */
    abstract class AbstractHurtingProjectile extends Internal.Projectile {
        method_18002(): Internal.Packet<any>;
        method_5718(): number;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        method_31471($$0: Internal.ClientboundAddEntityPacket_): void;
        method_5871(): number;
        method_5640($$0: number): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        method_5863(): boolean;
        alwaysAccepts(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        "zPower" : number;
        "yPower" : number;
        "xPower" : number;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.AbstractHurtingProjectile>, $$1: Internal.LivingEntity, $$2: number, $$3: number, $$4: number, $$5: Internal.Level);
        constructor($$0: Internal.EntityType<Internal.AbstractHurtingProjectile>, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: Internal.Level);
    }
    type AbstractHurtingProjectile_ = AbstractHurtingProjectile;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.entity.TravellingPoint$IPortalListener
    */
    interface TravellingPoint$IPortalListener extends Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>> {
        or(arg0: Internal.Predicate_<Internal.Couple_<Internal.TrackNodeLocation_>>): Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>>;
        and(arg0: Internal.Predicate_<Internal.Couple_<Internal.TrackNodeLocation_>>): Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>>;
        negate(): Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>>;
    }
    type TravellingPoint$IPortalListener_ = TravellingPoint$IPortalListener;
    /**
    * @javaClass it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap
    */
    abstract class AbstractLong2ObjectMap <V> extends Internal.AbstractLong2ObjectFunction<V> implements Internal.Long2ObjectMap<V>, Internal.Serializable {
        getOrDefault(arg0: any, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        computeIfAbsent(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.LongFunction_<V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        values(): Internal.ObjectCollection<V>;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        replace(arg0: number, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        computeIfAbsentPartial(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        put(arg0: number, arg1: V): V;
        remove(arg0: number): V;
        remove(arg0: any): V;
        remove(arg0: number, arg1: any): boolean;
        remove(arg0: any, arg1: any): boolean;
        containsValue(arg0: any): boolean;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        hashCode(): number;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        get(arg0: any): V;
        putAll(arg0: Internal.Map_<number, V>): void;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        keySet(): Internal.LongSet;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<number, V>>;
        apply(arg0: number): V;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        isEmpty(): boolean;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        equals(arg0: any): boolean;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        toString(): string;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractLong2ObjectMap_<V> = AbstractLong2ObjectMap<V>;
    /**
    * @javaClass java.util.function.ToLongFunction
    */
    interface ToLongFunction <T> {
        applyAsLong(arg0: T): number;
    }
    type ToLongFunction_<T> = ((arg0: T) => number) | ToLongFunction<T>;
    /**
    * @javaClass website.skylorbeck.minecraft.skylorlib.mixin.ScreenHandlerMixin
    */
    interface ScreenHandlerMixin {
        setSlots(arg0: Internal.NonNullList_<Internal.Slot_>): void;
        setTrackedStacks(arg0: Internal.NonNullList_<Internal.ItemStack_>): void;
        setPreviousTrackedStacks(arg0: Internal.NonNullList_<Internal.ItemStack_>): void;
    }
    type ScreenHandlerMixin_ = ScreenHandlerMixin;
    /**
    * @javaClass it.unimi.dsi.fastutil.longs.AbstractLong2ObjectFunction
    */
    abstract class AbstractLong2ObjectFunction <V> implements Internal.Long2ObjectFunction<V>, Internal.Serializable {
        getOrDefault(arg0: any, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        put(arg0: number, arg1: V): V;
        remove(arg0: number): V;
        remove(arg0: any): V;
        defaultReturnValue(arg0: V): void;
        defaultReturnValue(): V;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        get(arg0: any): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        apply(arg0: number): V;
        containsKey(arg0: any): boolean;
        containsKey(arg0: number): boolean;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractLong2ObjectFunction_<V> = AbstractLong2ObjectFunction<V>;
    /**
    * @javaClass com.google.gson.TypeAdapter
    */
    abstract class TypeAdapter <T> {
        toJson(arg0: T): string;
        toJson(arg0: Internal.Writer_, arg1: T): void;
        read(arg0: Internal.JsonReader_): T;
        toJsonTree(arg0: T): Internal.JsonElement;
        fromJson(arg0: string): T;
        fromJson(arg0: Internal.Reader_): T;
        nullSafe(): Internal.TypeAdapter<T>;
        write(arg0: Internal.JsonWriter_, arg1: T): void;
        fromJsonTree(arg0: Internal.JsonElement_): T;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type TypeAdapter_<T> = TypeAdapter<T>;
    /**
    * @javaClass net.minecraft.class_1296
    */
    abstract class AgeableMob extends Internal.PathfinderMob {
        method_6109(): boolean;
        getAge(): number;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getBreedOffspring(arg0: Internal.ServerLevel_, arg1: Internal.AgeableMob_): this;
        canBreed(): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_7217($$0: boolean): void;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_6007(): void;
        ageUp($$0: number, $$1: boolean): void;
        ageUp($$0: number): void;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        setAge($$0: number): void;
        static readonly "BABY_START_AGE" : -24000;
        get stepHeight(): number;
        get age(): number;
        set age($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AgeableMob_ = AgeableMob;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.DependencyRequirement
    */
    class DependencyRequirement extends Internal.Enum<Internal.DependencyRequirement> {
        static valueOf(name: string): Internal.DependencyRequirement;
        static values(): Internal.DependencyRequirement[];
        static readonly "ONE_STARTED" : Internal.DependencyRequirement;
        static readonly "ALL_STARTED" : Internal.DependencyRequirement;
        static readonly "NAME_MAP" : Internal.NameMap<Internal.DependencyRequirement>;
        readonly "one" : boolean;
        readonly "id" : string;
        readonly "completed" : boolean;
        static readonly "ALL_COMPLETED" : Internal.DependencyRequirement;
        static readonly "ONE_COMPLETED" : Internal.DependencyRequirement;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type DependencyRequirement_ = "one_completed" | "all_completed" | "one_started" | "all_started" | DependencyRequirement;
    /**
    * @javaClass dev.latvian.mods.kubejs.integration.rei.HideREIEventJS
    */
    class HideREIEventJS <T> extends Internal.EventJS {
        hide(o: any): void;
        getAllIngredients(): Internal.Collection<T>;
        hideAll(): void;
        get allIngredients(): Internal.Collection<T>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(registry: Internal.EntryRegistry, type: Internal.EntryType<T>, entryWrapper: any);
    }
    type HideREIEventJS_<T> = HideREIEventJS<T>;
    /**
    * @javaClass dev.latvian.mods.kubejs.level.LevelEventJS
    */
    abstract class LevelEventJS extends Internal.EventJS {
        getServer(): Internal.ServerJS;
        getLevel(): Internal.LevelJS;
        post(id: string): boolean;
        post(id: string, sub: string): boolean;
        get server(): Internal.ServerJS;
        get level(): Internal.LevelJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type LevelEventJS_ = LevelEventJS;
    /**
    * @javaClass com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityTypeExtension
    */
    interface BlockEntityTypeExtension <T> {
        flywheel$setInstancingController(arg0: Internal.BlockEntityInstancingController_<T>): void;
        flywheel$getInstancingController(): Internal.BlockEntityInstancingController<T>;
    }
    type BlockEntityTypeExtension_<T> = BlockEntityTypeExtension<T>;
    /**
    * @javaClass net.minecraft.class_2810
    */
    interface FeatureAccess {
        setAllReferences(arg0: Internal.Map_<Internal.ConfiguredStructureFeature_<any, any>, Internal.LongSet_>): void;
        setStartForFeature(arg0: Internal.ConfiguredStructureFeature_<any, any>, arg1: Internal.StructureStart_): void;
        getAllReferences(): Internal.Map<Internal.ConfiguredStructureFeature<any, any>, Internal.LongSet>;
        addReferenceForFeature(arg0: Internal.ConfiguredStructureFeature_<any, any>, arg1: number): void;
        getReferencesForFeature(arg0: Internal.ConfiguredStructureFeature_<any, any>): Internal.LongSet;
        getStartForFeature(arg0: Internal.ConfiguredStructureFeature_<any, any>): Internal.StructureStart;
    }
    type FeatureAccess_ = FeatureAccess;
    /**
    * @javaClass com.tterrag.registrate.fabric.FluidData
    */
    class FluidData extends Internal.Record {
        translationKey(): string;
        light(): number;
        hashCode(): number;
        equals(o: any): boolean;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(translationKey: string, light: number);
    }
    type FluidData_ = FluidData;
    /**
    * @javaClass net.minecraft.class_1528
    */
    class WitherBoss extends Internal.Monster implements Internal.PowerableMob, Internal.RangedAttackMob, Internal.AccessorWitherEntity {
        method_5837($$0: Internal.ServerPlayer_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getHeadYRot($$0: number): number;
        makeInvulnerable(): void;
        getAlternativeTarget($$0: number): number;
        setAlternativeTarget($$0: number, $$1: number): void;
        getInvulnerableTicks(): number;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_6872(): boolean;
        setInvulnerableTicks($$0: number): void;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        method_5665($$0: net.minecraft.network.chat.Component_): void;
        method_5742($$0: Internal.ServerPlayer_): void;
        alwaysAccepts(): boolean;
        method_7105($$0: Internal.LivingEntity_, $$1: number): void;
        method_5982(): void;
        method_5747($$0: number, $$1: number, $$2: Internal.DamageSource_): boolean;
        method_5822(): boolean;
        method_5844($$0: Internal.BlockState_, $$1: Vec3_): void;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        static canDestroy($$0: Internal.BlockState_): boolean;
        asKJS(): Internal.EntityJS;
        getHeadXRot($$0: number): number;
        canRiderInteract(): boolean;
        method_37222($$0: Internal.MobEffectInstance_, $$1: Internal.Entity_): boolean;
        method_6046(): Internal.MobType;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        method_6007(): void;
        method_5652($$0: Internal.CompoundTag_): void;
        method_6049($$0: Internal.MobEffectInstance_): boolean;
        get invulnerableTicks(): number;
        get stepHeight(): number;
        set invulnerableTicks($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.WitherBoss>, $$1: Internal.Level);
    }
    type WitherBoss_ = WitherBoss;
    /**
    * @javaClass dev.ftb.mods.ftbteams.property.TeamPropertyType
    */
    class TeamPropertyType <T> {
        static read(buf: Internal.FriendlyByteBuf_): Internal.TeamProperty<any>;
        static write(buf: Internal.FriendlyByteBuf_, p: Internal.TeamProperty_<any>): void;
        static register<Y>(id: string, p: Internal.TeamPropertyType$FromNet_<Y>): Internal.TeamPropertyType<Y>;
        static readonly "ENUM" : Internal.TeamPropertyType<string>;
        static readonly "PRIVACY_MODE" : Internal.TeamPropertyType<Internal.PrivacyMode>;
        static readonly "COLOR" : Internal.TeamPropertyType<Internal.Color4I>;
        static readonly "STRING" : Internal.TeamPropertyType<string>;
        readonly "deserializer" : Internal.TeamPropertyType$FromNet<T>;
        static readonly "DOUBLE" : Internal.TeamPropertyType<number>;
        readonly "id" : string;
        static readonly "MAP" : {"boolean":Internal.TeamPropertyType<any>,"string":Internal.TeamPropertyType<any>,"color":Internal.TeamPropertyType<any>,"double":Internal.TeamPropertyType<any>,"privacy_mode":Internal.TeamPropertyType<any>,"int":Internal.TeamPropertyType<any>,"enum":Internal.TeamPropertyType<any>};
        static readonly "BOOLEAN" : Internal.TeamPropertyType<boolean>;
        static readonly "INT" : Internal.TeamPropertyType<number>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TeamPropertyType_<T> = TeamPropertyType<T>;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.TrackNodeLocation
    */
    class TrackNodeLocation extends Vec3i {
        static receive(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): Internal.TrackNodeLocation;
        getLocation(): Vec3;
        static read(tag: Internal.CompoundTag_, dimensions: Internal.DimensionPalette_): Internal.TrackNodeLocation;
        in(level: Internal.Level_): this;
        in(dimension: Internal.ResourceKey_<Internal.Level_>): this;
        hashCode(): number;
        allAdjacent(): Internal.Collection<BlockPos>;
        equals(pOther: any): boolean;
        getDimension(): Internal.ResourceKey<Internal.Level>;
        equalsIgnoreDim(pOther: any): boolean;
        send(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        "dimension" : Internal.ResourceKey<Internal.Level>;
        get location(): Vec3;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(p_121865_: number, p_121866_: number, p_121867_: number);
        constructor(vec: Vec3);
    }
    type TrackNodeLocation_ = TrackNodeLocation;
    /**
    * @javaClass xaero.map.gui.message.render.MessageBoxRenderer
    */
    class MessageBoxRenderer {
        render(matrixStack: Internal.PoseStack_, messageBox: Internal.MessageBox_, font: net.minecraft.client.gui.Font_, x: number, y: number, rightAlign: boolean): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type MessageBoxRenderer_ = MessageBoxRenderer;
    /**
    * @javaClass xaero.map.region.texture.BranchRegionTexture
    */
    class BranchRegionTexture extends Internal.RegionTexture<Internal.BranchRegionTexture> {
        preUpload(mapProcessor: Internal.MapProcessor_, blockTintProvider: Internal.BlockTintProvider_, overlayManager: Internal.OverlayManager_, region: Internal.LeveledRegion_<Internal.BranchRegionTexture_>, detailedDebug: boolean, blockStateShortShapeCache: Internal.BlockStateShortShapeCache_): void;
        postUpload(mapProcessor: Internal.MapProcessor_, leveledRegion: Internal.LeveledRegion_<Internal.BranchRegionTexture_>, cleanAndCacheRequestsBlocked: boolean): void;
        readCacheData(minorSaveVersion: number, majorSaveVersion: number, input: Internal.DataInputStream_, usableBuffer: number[], integerByteBuffer: number[], inRegion: Internal.LeveledRegion_<Internal.BranchRegionTexture_>, mapProcessor: Internal.MapProcessor_, x: number, y: number, leafShouldAffectBranches: boolean): void;
        onTextureDeletion(): void;
        writeCacheMapData(output: Internal.DataOutputStream_, usableBuffer: number[], integerByteBuffer: number[], inRegion: Internal.LeveledRegion_<Internal.BranchRegionTexture_>): void;
        uploadBuffer(highlighterHandler: xaero.map.highlight.DimensionHighlighterHandler_, textureUploader: Internal.TextureUploader_, inRegion: Internal.LeveledRegion_<Internal.BranchRegionTexture_>, branchTextureRenderer: Internal.BranchTextureRenderer_, x: number, y: number): number;
        requestDownload(): void;
        checkForUpdates(topLeft: Internal.RegionTexture_<any>, topRight: Internal.RegionTexture_<any>, bottomLeft: Internal.RegionTexture_<any>, bottomRight: Internal.RegionTexture_<any>, childRegion: Internal.LeveledRegion_<any>): boolean;
        addDebugLines(lines: Internal.List_<string>): void;
        hasSourceData(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(region: Internal.LeveledRegion<Internal.BranchRegionTexture>);
    }
    type BranchRegionTexture_ = BranchRegionTexture;
    /**
    * @javaClass java.lang.Thread$UncaughtExceptionHandler
    */
    interface Thread$UncaughtExceptionHandler {
        uncaughtException(arg0: Internal.Thread_, arg1: Internal.Throwable_): void;
    }
    type Thread$UncaughtExceptionHandler_ = ((arg0: Internal.Thread, arg1: Internal.Throwable) => void) | Thread$UncaughtExceptionHandler;
    /**
    * @javaClass com.mojang.authlib.minecraft.MinecraftProfileTexture
    */
    class MinecraftProfileTexture {
        getUrl(): string;
        getMetadata(arg0: string): string;
        getHash(): string;
        toString(): string;
        static readonly "PROFILE_TEXTURE_COUNT" : 3;
        get url(): string;
        get hash(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: string, arg1: Internal.Map<string, string>);
    }
    type MinecraftProfileTexture_ = MinecraftProfileTexture;
    /**
    * @javaClass dev.tr7zw.exordium.access.ChatAccess
    */
    interface ChatAccess {
        hasActiveAnimations(arg0: number): boolean;
    }
    type ChatAccess_ = ChatAccess;
    /**
    * @javaClass dev.latvian.mods.kubejs.integration.rei.AddREIEventJS
    */
    class AddREIEventJS extends Internal.EventJS {
        add(o: any): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(registry: Internal.EntryRegistry, entryWrapper: any);
    }
    type AddREIEventJS_ = AddREIEventJS;
    /**
    * @javaClass com.mojang.brigadier.SingleRedirectModifier
    */
    interface SingleRedirectModifier <S> {
        apply(arg0: Internal.CommandContext_<S>): S;
    }
    type SingleRedirectModifier_<S> = ((arg0: Internal.CommandContext<S>) => S) | SingleRedirectModifier<S>;
    /**
    * @javaClass net.coderbot.batchedentityrendering.mixin.CompositeStateAccessor
    */
    interface CompositeStateAccessor {
        getTransparency(): Internal.RenderStateShard$TransparencyStateShard;
    }
    type CompositeStateAccessor_ = CompositeStateAccessor;
    /**
    * @javaClass java.util.EventObject
    */
    class EventObject implements Internal.Serializable {
        getSource(): any;
        toString(): string;
        get source(): any;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: any);
    }
    type EventObject_ = EventObject;
    /**
    * @javaClass net.minecraft.class_5267
    */
    class SerializationContext {
        serializeConditions($$0: Internal.LootItemCondition_[]): Internal.JsonElement;
        static readonly "INSTANCE" : Internal.SerializationContext;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type SerializationContext_ = SerializationContext;
    /**
    * @javaClass ru.bclib.util.Pair
    */
    class Pair <A, B> {
        hashCode(): number;
        equals(o: any): boolean;
        toString(): string;
        readonly "first" : A;
        readonly "second" : B;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(first: A, second: B);
    }
    type Pair_<A, B> = Pair<A, B>;
    /**
    * @javaClass com.simibubi.create.foundation.collision.Matrix3d
    */
    class Matrix3d {
        add(matrix: Internal.Matrix3d_): this;
        transform(vec: Vec3_): Vec3;
        asIdentity(): this;
        asYRotation(radians: number): this;
        getAsMatrix4f(): Internal.Matrix4f;
        scale(d: number): this;
        asXRotation(radians: number): this;
        transpose(): this;
        copy(): this;
        multiply(m: Internal.Matrix3d_): this;
        asZRotation(radians: number): this;
        get asMatrix4f(): Internal.Matrix4f;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type Matrix3d_ = Matrix3d;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.TrackGraph
    */
    class TrackGraph {
        static nextNodeId(): number;
        connectNodes(reader: Internal.LevelAccessor_, location: Internal.TrackNodeLocation_, location2: Internal.TrackNodeLocation_, turn: Internal.BezierConnection_): void;
        addNode(node: Internal.TrackNode_): void;
        markDirty(): void;
        deferIntersectionUpdate(edge: Internal.TrackEdge_): void;
        removePoint<T>(type: Internal.EdgePointType_<T>, id: Internal.UUID_): T;
        getChecksum(): number;
        getBounds(level: Internal.Level_): Internal.TrackGraphBounds;
        getConnection(nodes: Internal.Couple_<Internal.TrackNode_>): Internal.TrackEdge;
        createNodeIfAbsent(location: Internal.TrackNodeLocation$DiscoveredLocation_): boolean;
        disconnectNodes(node1: Internal.TrackNode_, node2: Internal.TrackNode_): void;
        tickPoints(preTrains: boolean): void;
        setId(id: Internal.UUID_): void;
        getPoints<T>(type: Internal.EdgePointType_<T>): Internal.Collection<T>;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        resolveIntersectingEdgeGroups(level: Internal.Level_): void;
        removeNode(level: Internal.LevelAccessor_, location: Internal.TrackNodeLocation_): boolean;
        static nextGraphId(): number;
        getPoint<T>(type: Internal.EdgePointType_<T>, id: Internal.UUID_): T;
        static read(tag: Internal.CompoundTag_, dimensions: Internal.DimensionPalette_): Internal.TrackGraph;
        getNodes(): Internal.Set<Internal.TrackNodeLocation>;
        findDisconnectedGraphs(level: Internal.LevelAccessor_, splitSubGraphs: Internal.Map_<number, com.simibubi.create.foundation.utility.Pair_<number, Internal.UUID_>>): Internal.Set<Internal.TrackGraph>;
        isEmpty(): boolean;
        locateNode(level: Internal.Level_, position: Vec3_): Internal.TrackNode;
        locateNode(position: Internal.TrackNodeLocation_): Internal.TrackNode;
        distanceToLocationSqr(level: Internal.Level_, location: Vec3_): number;
        addPoint<T>(type: Internal.EdgePointType_<T>, point: T): void;
        getConnectionsFrom(node: Internal.TrackNode_): Internal.Map<Internal.TrackNode, Internal.TrackEdge>;
        transfer(level: Internal.LevelAccessor_, node: Internal.TrackNode_, target: Internal.TrackGraph_): void;
        transferAll(toOther: Internal.TrackGraph_): void;
        putConnection(node1: Internal.TrackNode_, node2: Internal.TrackNode_, edge: Internal.TrackEdge_): boolean;
        loadNode(location: Internal.TrackNodeLocation_, netId: number, normal: Vec3_): void;
        invalidateBounds(): void;
        getNode(netId: number): Internal.TrackNode;
        addNodeIfAbsent(node: Internal.TrackNode_): boolean;
        setNetId(id: number): void;
        static readonly "graphNetIdGenerator" : Internal.AtomicInteger;
        static readonly "nodeNetIdGenerator" : Internal.AtomicInteger;
        "color" : com.simibubi.create.foundation.utility.Color;
        "id" : Internal.UUID;
        get nodes(): Internal.Set<Internal.TrackNodeLocation>;
        get checksum(): number;
        get empty(): boolean;
        set netId(id: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
        constructor(graphID: Internal.UUID);
    }
    type TrackGraph_ = TrackGraph;
    /**
    * @javaClass net.minecraft.class_3678
    */
    interface WindowEventHandler {
        resizeDisplay(): void;
        cursorEntered(): void;
        setWindowActive(arg0: boolean): void;
    }
    type WindowEventHandler_ = WindowEventHandler;
    /**
    * @javaClass net.minecraft.class_6904$class_6905
    */
    interface WorldStem$DataPackConfigSupplier extends Internal.Supplier<Internal.DataPackConfig> {
        loadFromWorld($$0: Internal.LevelStorageSource$LevelStorageAccess_): this;
    }
    type WorldStem$DataPackConfigSupplier_ = WorldStem$DataPackConfigSupplier;
    /**
    * @javaClass io.netty.channel.ChannelConfig
    */
    interface ChannelConfig {
        setWriteBufferLowWaterMark(arg0: number): this;
        setMessageSizeEstimator(arg0: Internal.MessageSizeEstimator_): this;
        getWriteBufferLowWaterMark(): number;
        getMessageSizeEstimator(): Internal.MessageSizeEstimator;
        setRecvByteBufAllocator(arg0: Internal.RecvByteBufAllocator_): this;
        getOption<T>(arg0: Internal.ChannelOption_<T>): T;
        isAutoClose(): boolean;
        getRecvByteBufAllocator<T>(): T;
        setAllocator(arg0: Internal.ByteBufAllocator_): this;
        getAllocator(): Internal.ByteBufAllocator;
        isAutoRead(): boolean;
        setOptions(arg0: Internal.Map_<Internal.ChannelOption_<any>, any>): boolean;
        setConnectTimeoutMillis(arg0: number): this;
        setWriteBufferWaterMark(arg0: Internal.WriteBufferWaterMark_): this;
        setOption<T>(arg0: Internal.ChannelOption_<T>, arg1: T): boolean;
        setWriteSpinCount(arg0: number): this;
        getConnectTimeoutMillis(): number;
        setWriteBufferHighWaterMark(arg0: number): this;
        getMaxMessagesPerRead(): number;
        getWriteBufferHighWaterMark(): number;
        setAutoRead(arg0: boolean): this;
        getWriteSpinCount(): number;
        setMaxMessagesPerRead(arg0: number): this;
        getOptions(): Internal.Map<Internal.ChannelOption<any>, any>;
        getWriteBufferWaterMark(): Internal.WriteBufferWaterMark;
        setAutoClose(arg0: boolean): this;
    }
    type ChannelConfig_ = ChannelConfig;
    /**
    * @javaClass net.minecraft.class_3443
    */
    abstract class StructurePiece implements com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePieceAccessor {
        setOrientation($$0: Internal.Direction_): void;
        getMirror(): Internal.Mirror;
        move($$0: number, $$1: number, $$2: number): void;
        getGenDepth(): number;
        static findCollisionPiece($$0: Internal.List_<Internal.StructurePiece_>, $$1: Internal.BoundingBox_): Internal.StructurePiece;
        getWorldY($$0: number): number;
        getWorldX($$0: number, $$1: number): number;
        static reorient($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.BlockState;
        getRotation(): Internal.Rotation;
        getWorldZ($$0: number, $$1: number): number;
        getBoundingBox(): Internal.BoundingBox;
        static createBoundingBox($$0: Internal.Stream_<Internal.StructurePiece_>): Internal.BoundingBox;
        placeBlock($$0: Internal.WorldGenLevel_, $$1: Internal.BlockState_, $$2: number, $$3: number, $$4: number, $$5: Internal.BoundingBox_): void;
        getOrientation(): Internal.Direction;
        isCloseToChunk($$0: Internal.ChunkPos_, $$1: number): boolean;
        createTag($$0: Internal.StructurePieceSerializationContext_): Internal.CompoundTag;
        getType(): Internal.StructurePieceType;
        addChildren($$0: Internal.StructurePiece_, $$1: Internal.StructurePieceAccessor_, $$2: Internal.Random_): void;
        getNoiseEffect(): Internal.NoiseEffect;
        postProcess(arg0: Internal.WorldGenLevel_, arg1: Internal.StructureFeatureManager_, arg2: Internal.ChunkGenerator_, arg3: Internal.Random_, arg4: Internal.BoundingBox_, arg5: Internal.ChunkPos_, arg6: BlockPos_): void;
        getLocatorPosition(): BlockPos;
        "orientation" : Internal.Direction;
        "mirror" : Internal.Mirror;
        "rotation" : Internal.Rotation;
        get boundingBox(): Internal.BoundingBox;
        get genDepth(): number;
        get locatorPosition(): BlockPos;
        get type(): Internal.StructurePieceType;
        get noiseEffect(): Internal.NoiseEffect;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.StructurePieceType, $$1: Internal.CompoundTag);
    }
    type StructurePiece_ = StructurePiece;
    /**
    * @javaClass net.fabricmc.fabric.api.item.v1.CustomDamageHandler
    */
    interface CustomDamageHandler {
        damage(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.LivingEntity_, arg3: Internal.Consumer_<Internal.LivingEntity_>): number;
    }
    type CustomDamageHandler_ = ((arg0: Internal.ItemStack, arg1: number, arg2: Internal.LivingEntity, arg3: Internal.Consumer<Internal.LivingEntity>) => number) | CustomDamageHandler;
    /**
    * @javaClass net.minecraft.class_4095$class_5303
    */
    class Brain$Provider <E> {
        makeBrain($$0: Internal.Dynamic_<any>): Internal.Brain<E>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Brain$Provider_<E> = Brain$Provider<E>;
    /**
    * @javaClass dev.isxander.zoomify.mixins.AccessorMinecraftClient
    */
    interface AccessorMinecraftClient {
        getUserApiService(): Internal.UserApiService;
    }
    type AccessorMinecraftClient_ = AccessorMinecraftClient;
    /**
    * @javaClass net.minecraft.class_3037
    */
    interface FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
    }
    type FeatureConfiguration_ = FeatureConfiguration;
    /**
    * @javaClass me.shedaniel.rei.api.common.transfer.info.MenuInfo
    */
    interface MenuInfo <T, D> {
        getRecipeFinderPopulator(): Internal.RecipeFinderPopulator<T, D>;
        markDirty(context: Internal.MenuInfoContext_<T, Internal.ServerPlayer_, D>): void;
        getInputsIndexed(context: Internal.MenuInfoContext_<T, any, D>, fill: boolean): Internal.List<Internal.InputIngredient<Internal.ItemStack>>;
        save(context: Internal.MenuSerializationContext_<T, any, D>, display: D): Internal.CompoundTag;
        getInputs(context: Internal.MenuInfoContext_<T, any, D>, fill: boolean): Internal.List<Internal.List<Internal.ItemStack>>;
        renderMissingInput(context: Internal.MenuInfoContext_<T, any, D>, inputs: Internal.List_<Internal.List_<Internal.ItemStack_>>, missingIndices: Internal.IntList_, matrices: Internal.PoseStack_, mouseX: number, mouseY: number, delta: number, widgets: Internal.List_<me.shedaniel.rei.api.client.gui.widgets.Widget_>, bounds: me.shedaniel.math.Rectangle_): void;
        renderMissingInput(context: Internal.MenuInfoContext_<T, any, D>, inputs: Internal.List_<Internal.InputIngredient_<Internal.ItemStack_>>, missing: Internal.List_<Internal.InputIngredient_<Internal.ItemStack_>>, missingIndices: Internal.IntSet_, matrices: Internal.PoseStack_, mouseX: number, mouseY: number, delta: number, widgets: Internal.List_<me.shedaniel.rei.api.client.gui.widgets.Widget_>, bounds: me.shedaniel.math.Rectangle_): void;
        getInputCleanHandler(): Internal.InputCleanHandler<T, D>;
        getInputSlots(arg0: Internal.MenuInfoContext_<T, any, D>): Internal.Iterable<me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor>;
        getInventorySlots(arg0: Internal.MenuInfoContext_<T, any, D>): Internal.Iterable<me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor>;
        getDisplay(): D;
        validate(context: Internal.MenuInfoContext_<T, any, D>): void;
    }
    type MenuInfo_<T, D> = MenuInfo<T, D>;
    /**
    * @javaClass dev.latvian.mods.kubejs.util.ListJS
    */
    class ListJS extends Internal.ArrayList<any> implements Internal.StringBuilderAppendable, Internal.ChangeListener<any>, Internal.Copyable, Internal.JsonSerializable, Internal.NBTSerializable {
        static nbt(list: any): Internal.CollectionTag<any>;
        shift(): any;
        remove(index: number): any;
        remove(o: any): boolean;
        pop(): any;
        toNBT(): Internal.CollectionTag<any>;
        stream(): Internal.Stream<any>;
        static of(o: any): Internal.ListJS;
        static of(array: number[]): Internal.ListJS;
        static of(array: string[]): Internal.ListJS;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static orSelf(o: any): Internal.ListJS;
        static json(array: any): Internal.JsonArray;
        parallelStream(): Internal.Stream<any>;
        copy(): this;
        map(transformer: Internal.Function_<any, any>): this;
        add(index: number, value: any): void;
        add(value: any): boolean;
        appendString(builder: Internal.StringBuilder_): void;
        onChanged(o: any): void;
        splice(pos: number, deleteCount: number, ...items: any[]): this;
        clear(): void;
        static ofArray(array: any): Internal.ListJS;
        reverse(): this;
        push(...o: any[]): this;
        filter(predicate: Internal.Predicate_<any>): this;
        toJson(): Internal.JsonArray;
        addAll(index: number, c: Internal.Collection_<any>): boolean;
        addAll(c: Internal.Collection_<any>): boolean;
        getLength(): number;
        unshift(...o: any[]): this;
        toString(): string;
        "changeListener" : ((arg0: Internal.ListJS) => void);
        get length(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(s: number);
        constructor();
    }
    type ListJS_ = ListJS;
    /**
    * @javaClass xaero.map.region.MapTileChunk
    */
    class MapTileChunk {
        hasHighlightsIfUndiscovered(): boolean;
        getLeafTexture(): Internal.LeafRegionTexture;
        getLoadState(): number;
        updateBuffers(mapProcessor: Internal.MapProcessor_, blockTintProvider: Internal.BlockTintProvider_, overlayManager: Internal.OverlayManager_, detailedDebug: boolean, blockStateShortShapeCache: Internal.BlockStateShortShapeCache_): void;
        setHasHadTerrain(): void;
        includeInSave(): boolean;
        getGlColorTexture(): number;
        setHasHighlightsIfUndiscovered(hasHighlightsIfUndiscovered: boolean): void;
        hasHadTerrain(): boolean;
        hasHighlights(): boolean;
        setTile(x: number, z: number, tile: Internal.MapTile_, blockStateShortShapeCache: Internal.BlockStateShortShapeCache_): void;
        getTile(x: number, z: number): Internal.MapTile;
        getNeighbourTileChunk(directionX: number, directionZ: number, mapProcessor: Internal.MapProcessor_, crossRegion: boolean): this;
        setLoadState(loadState: number): void;
        readCacheData(minorSaveVersion: number, majorSaveVersion: number, input: Internal.DataInputStream_, usableBuffer: number[], integerByteBuffer: number[], mapProcessor: Internal.MapProcessor_, x: number, y: number): void;
        getTileGridsCache(): number[][];
        decTimer(): void;
        putColour(x: number, y: number, red: number, green: number, blue: number, alpha: number, buffer: Internal.ByteBuffer_, size: number): void;
        clean(mapProcessor: Internal.MapProcessor_): void;
        setHasHighlights(hasHighlights: boolean): void;
        getX(): number;
        resetHeights(): void;
        getZ(): number;
        setToUpdateBuffers(toUpdateBuffers: boolean): void;
        wasChanged(): boolean;
        writeCacheData(output: Internal.DataOutputStream_, usableBuffer: number[], integerByteBuffer: number[], inRegion2: Internal.LeveledRegion_<Internal.LeafRegionTexture_>): void;
        toString(): string;
        setChanged(changed: boolean): void;
        unincludeInSave(): void;
        getToUpdateBuffers(): boolean;
        getTimer(): number;
        getInRegion(): Internal.MapRegion;
        static readonly "SIDE_LENGTH" : 4;
        get loadState(): number;
        get timer(): number;
        get glColorTexture(): number;
        get tileGridsCache(): number[][];
        get x(): number;
        get z(): number;
        get leafTexture(): Internal.LeafRegionTexture;
        get inRegion(): Internal.MapRegion;
        get toUpdateBuffers(): boolean;
        set toUpdateBuffers(toUpdateBuffers: boolean);
        set changed(changed: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(r: Internal.MapRegion, x: number, z: number);
    }
    type MapTileChunk_ = MapTileChunk;
    /**
    * @javaClass xaero.map.file.worldsave.WorldDataHandler
    */
    class WorldDataHandler {
        getWorldDir(): Internal.Path;
        getWorldServer(): Internal.ServerLevel;
        getWorldDataReader(): Internal.WorldDataReader;
        buildRegion(region: Internal.MapRegion_, world: Internal.Level_, loading: boolean, chunkCountDest: number[]): Internal.WorldDataHandler$Result;
        static onServerWorldUnload(sw: Internal.ServerLevel_): void;
        prepareSingleplayer(world: Internal.Level_, mapProcessor: Internal.MapProcessor_): void;
        get worldServer(): Internal.ServerLevel;
        get worldDir(): Internal.Path;
        get worldDataReader(): Internal.WorldDataReader;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(worldDataReader: Internal.WorldDataReader);
    }
    type WorldDataHandler_ = WorldDataHandler;
    /**
    * @javaClass com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour$StepContext
    */
    class ScrollValueBehaviour$StepContext {
        "forward" : boolean;
        "shift" : boolean;
        "control" : boolean;
        "currentValue" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ScrollValueBehaviour$StepContext_ = ScrollValueBehaviour$StepContext;
    /**
    * @javaClass virtuoel.pehkui.api.ScaleData
    */
    class ScaleData {
        setScaleTickDelay(ticks: number): void;
        getInitialScale(): number;
        toPacket(buffer: Internal.FriendlyByteBuf_): Internal.FriendlyByteBuf;
        averagedFromScales(scaleData: Internal.ScaleData_, ...scales: Internal.ScaleData_[]): this;
        hasDefaultValues(): boolean;
        getPrevBaseScale(): number;
        getScaleType(): Internal.ScaleType;
        writeNbt(tag: Internal.CompoundTag_): Internal.CompoundTag;
        getPersistence(): boolean;
        getBaseValueModifiers(): Internal.SortedSet<Internal.ScaleModifier>;
        hashCode(): number;
        resetScale(notifyListener: boolean): this;
        resetScale(): this;
        isReset(): boolean;
        getEasing(): Internal.Float2FloatFunction;
        fromScale(scaleData: Internal.ScaleData_): this;
        fromScale(scaleData: Internal.ScaleData_, notifyListener: boolean): this;
        setEasing(easing: Internal.Float2FloatFunction_): void;
        markForSync(sync: boolean): void;
        getTargetScale(): number;
        setScale(scale: number): void;
        tick(): void;
        getEntity(): Internal.Entity;
        readNbt(tag: Internal.CompoundTag_): void;
        getPrevScale(): number;
        getScaleTickDelay(): number;
        shouldSync(): boolean;
        getScale(delta: number): number;
        getScale(): number;
        equals(obj: any): boolean;
        equals(other: Internal.ScaleData_): boolean;
        getBaseScale(delta: number): number;
        getBaseScale(): number;
        setBaseScale(scale: number): void;
        setPersistence(persistent: boolean): void;
        shouldPersist(): boolean;
        setTargetScale(targetScale: number): void;
        onUpdate(): void;
        get initialScale(): number;
        get scale(): number;
        get easing(): Internal.Float2FloatFunction;
        get prevScale(): number;
        get scaleTickDelay(): number;
        get baseScale(): number;
        get baseValueModifiers(): Internal.SortedSet<Internal.ScaleModifier>;
        get scaleType(): Internal.ScaleType;
        get targetScale(): number;
        get prevBaseScale(): number;
        get persistence(): boolean;
        get reset(): boolean;
        get entity(): Internal.Entity;
        set scaleTickDelay(ticks: number);
        set baseScale(scale: number);
        set targetScale(targetScale: number);
        set persistence(persistent: boolean);
        set scale(scale: number);
        set easing(easing: Internal.Float2FloatFunction_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ScaleData_ = ScaleData;
    /**
    * @javaClass net.minecraft.class_3505$class_6863
    */
    class TagManager$LoadResult <T> extends Internal.Record {
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        key(): Internal.ResourceKey<Internal.Registry<T>>;
        tags(): Internal.Map<ResourceLocation, Internal.Tag<Internal.Holder<T>>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ResourceKey<Internal.Registry<T>>, $$1: Internal.Map<ResourceLocation, Internal.Tag<Internal.Holder<T>>>);
    }
    type TagManager$LoadResult_<T> = TagManager$LoadResult<T>;
    /**
    * @javaClass xaero.common.gui.MyOptions
    */
    class MyOptions extends Internal.OptionsScreen {
        method_25406($$0: number, $$1: number, $$2: number): boolean;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        method_25407($$0: boolean): boolean;
        setInitialFocus($$0: Internal.GuiEventListener_): void;
        drawCenteredLabel(matrices: Internal.PoseStack_, text: net.minecraft.network.chat.Component_, x: number, y: number, color: number, zIndex: number): void;
        method_25400($$0: string, $$1: number): boolean;
        method_25402($$0: number, $$1: number, $$2: number): boolean;
        method_25401($$0: number, $$1: number, $$2: number): boolean;
        getAllBounds(): Internal.Set<Internal.Bounds>;
        method_25426(): void;
        drawTextBlock(matrices: Internal.PoseStack_, text: Internal.FormattedText_, x: number, y: number, maxWidth: number, color: number): void;
        method_25403($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        method_16803($$0: number, $$1: number, $$2: number): boolean;
        getFont(): net.minecraft.client.gui.Font;
        drawLabel(matrices: Internal.PoseStack_, text: net.minecraft.network.chat.Component_, x: number, y: number, color: number, zIndex: number): void;
        getContentBounds(): Internal.Bounds;
        mouseMoved($$0: number, $$1: number): void;
        get allBounds(): Internal.Set<Internal.Bounds>;
        get contentBounds(): Internal.Bounds;
        get font(): net.minecraft.client.gui.Font;
        set initialFocus($$0: Internal.GuiEventListener_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(buttonName: string, settingsScreen: Internal.GuiSettings, par1GuiScreen: Internal.Screen, par2GameSettings: Internal.Options);
    }
    type MyOptions_ = MyOptions;
    /**
    * @javaClass io.netty.channel.ChannelInboundHandlerAdapter
    */
    class ChannelInboundHandlerAdapter extends Internal.ChannelHandlerAdapter implements Internal.ChannelInboundHandler {
        channelInactive(arg0: Internal.ChannelHandlerContext_): void;
        channelUnregistered(arg0: Internal.ChannelHandlerContext_): void;
        channelReadComplete(arg0: Internal.ChannelHandlerContext_): void;
        channelActive(arg0: Internal.ChannelHandlerContext_): void;
        exceptionCaught(arg0: Internal.ChannelHandlerContext_, arg1: Internal.Throwable_): void;
        userEventTriggered(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        channelRegistered(arg0: Internal.ChannelHandlerContext_): void;
        channelRead(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        channelWritabilityChanged(arg0: Internal.ChannelHandlerContext_): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ChannelInboundHandlerAdapter_ = ChannelInboundHandlerAdapter;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.transfer.cache.ClientBlockApiCache
    */
    interface ClientBlockApiCache {
        init(): void;
        invalidate(): void;
    }
    type ClientBlockApiCache_ = ClientBlockApiCache;
    /**
    * @javaClass java.lang.ref.WeakReference
    */
    class WeakReference <T> extends Internal.Reference<T> {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: T);
        constructor(arg0: T, arg1: any);
    }
    type WeakReference_<T> = WeakReference<T>;
    /**
    * @javaClass me.shedaniel.rei.api.client.gui.drag.DraggableStack
    */
    interface DraggableStack extends Internal.DraggableComponent<Internal.EntryStack<any>> {
        getHeight(): number;
        getOriginBounds(mouse: me.shedaniel.math.Point_): me.shedaniel.math.Rectangle;
        ifMatches<A>(consumer: Internal.Consumer_<A>, ...typeHack: A[]): boolean;
        ifMatches<A>(consumer: Internal.Predicate_<A>, ...typeHack: A[]): boolean;
        release(result: Internal.DraggedAcceptorResult_): void;
        get(): Internal.EntryStack<any>;
        getIf<A>(...typeHack: A[]): Internal.Optional<Internal.DraggableComponent<A>>;
        getStack(): Internal.EntryStack<any>;
        from(component: Internal.DraggableComponent_<Internal.EntryStack_<any>>): this;
        drag(): void;
        getWidth(): number;
        render(matrices: Internal.PoseStack_, bounds: me.shedaniel.math.Rectangle_, mouseX: number, mouseY: number, delta: number): void;
        render(matrices: Internal.PoseStack_, position: me.shedaniel.math.Point_, mouseX: number, mouseY: number, delta: number): void;
    }
    type DraggableStack_ = DraggableStack;
    /**
    * @javaClass net.minecraft.class_1937
    */
    abstract class Level implements Internal.LevelAccessor, Internal.AutoCloseable, Internal.ComponentProvider, Internal.EnhancedCelestialsWorldData, Internal.LoadedChunksCache, Internal.LevelKJS, Internal.ExtendedWorld, Internal.LevelExtensions {
        method_8409(): Internal.Random;
        setRainLevel($$0: number): void;
        disconnect(): void;
        method_8406($$0: Internal.ParticleOptions_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): void;
        getSectionsCount(): number;
        method_35230<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getGameRules(): Internal.GameRules;
        isLoaded($$0: BlockPos_): boolean;
        getMoonPhase(): number;
        method_35237($$0: BlockPos_, $$1: Internal.Predicate_<Internal.FluidState_>): boolean;
        dimensionTypeRegistration(): Internal.Holder<Internal.DimensionType>;
        method_8650($$0: BlockPos_, $$1: boolean): boolean;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity_>): Internal.Player;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        explode($$0: Internal.Entity_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: boolean, $$6: Internal.Explosion$BlockInteraction_): Internal.Explosion;
        explode($$0: Internal.Entity_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: Internal.Explosion$BlockInteraction_): Internal.Explosion;
        explode($$0: Internal.Entity_, $$1: Internal.DamageSource_, $$2: Internal.ExplosionDamageCalculator_, $$3: number, $$4: number, $$5: number, $$6: number, $$7: boolean, $$8: Internal.Explosion$BlockInteraction_): Internal.Explosion;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        handler$zei000$port_lib$onStartExplosion(exploder: Internal.Entity_, damageSource: Internal.DamageSource_, context: Internal.ExplosionDamageCalculator_, x: number, y: number, z: number, size: number, causesFire: boolean, mode: Internal.Explosion$BlockInteraction_, cir: Internal.CallbackInfoReturnable_<any>, explosion: Internal.Explosion_): void;
        method_8652($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        getSectionIndex($$0: number): number;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getRainLevel($$0: number): number;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        noSave(): boolean;
        setSpawnSettings($$0: boolean, $$1: boolean): void;
        isNight(): boolean;
        onBlockStateChange($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Internal.BlockState_): void;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getMinSection(): number;
        getBestNeighborSignal($$0: BlockPos_): number;
        setBlockAndUpdate($$0: BlockPos_, $$1: Internal.BlockState_): boolean;
        method_22385(): Internal.BiomeManager;
        playLocalSound($$0: number, $$1: number, $$2: number, $$3: Internal.SoundEvent_, $$4: Internal.SoundSource_, $$5: number, $$6: number, $$7: boolean): void;
        method_23752($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMaxBuildHeight(): number;
        getGameTime(): number;
        loadedAndEntityCanStandOn($$0: BlockPos_, $$1: Internal.Entity_): boolean;
        loadedAndEntityCanStandOnFace($$0: BlockPos_, $$1: Internal.Entity_, $$2: Internal.Direction_): boolean;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        method_8401(): Internal.LevelData;
        method_31605(): number;
        isRaining(): boolean;
        method_8404($$0: BlockPos_): Internal.DifficultyInstance;
        setLunarContext(lunarContext: Internal.LunarContext_): Internal.LunarContext;
        method_8402($$0: number, $$1: number, $$2: Internal.ChunkStatus_, $$3: boolean): Internal.ChunkAccess;
        getDayTime(): number;
        getProfiler(): Internal.ProfilerFiller;
        getFreeMapId(): number;
        updateNeighborsAt($$0: BlockPos_, $$1: Internal.Block_): void;
        isInWorldBounds($$0: BlockPos_): boolean;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        method_31607(): number;
        snapshotParticipant(): Internal.SnapshotParticipant<any>;
        handler$cke000$Level_updateNeighborsAt(blockPos: BlockPos_, block: Internal.Block_, ci: Internal.CallbackInfo_): void;
        blockEvent($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: number): void;
        fabric_markUnloaded(chunk: Internal.LevelChunk_): void;
        shouldTickBlocksAt($$0: number): boolean;
        method_8393($$0: number, $$1: number): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getLunarContext(): Internal.LunarContext;
        method_8396($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_, $$4: number, $$5: number): void;
        getMapData(arg0: string): Internal.MapItemSavedData;
        shouldTickDeath($$0: Internal.Entity_): boolean;
        playSound(arg0: Internal.Player_, arg1: Internal.Entity_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        playSound(arg0: Internal.Player_, arg1: number, arg2: number, arg3: number, arg4: Internal.SoundEvent_, arg5: Internal.SoundSource_, arg6: number, arg7: number): void;
        setSkyFlashTime($$0: number): void;
        neighborChanged($$0: BlockPos_, $$1: Internal.Block_, $$2: BlockPos_): void;
        getSectionYFromSectionIndex($$0: number): number;
        getScoreboard(): Internal.Scoreboard;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        method_8316($$0: BlockPos_): Internal.FluidState;
        close(): void;
        method_18023<T>($$0: Internal.EntityTypeTest_<Internal.Entity_, T>, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        globalLevelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        noCollision($$0: Internal.Entity_): boolean;
        noCollision($$0: Internal.AABB_): boolean;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getDirectSignalTo($$0: BlockPos_): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        method_30093($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_, $$3: number): boolean;
        method_30092($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number, $$3: number): boolean;
        getEntity(arg0: number): Internal.Entity;
        method_20743($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getComponentContainer(): Internal.ComponentContainer;
        setMapData(arg0: string, arg1: Internal.MapItemSavedData_): void;
        getThunderLevel($$0: number): number;
        getProfilerSupplier(): Internal.Supplier<Internal.ProfilerFiller>;
        getBlockRandomPos($$0: number, $$1: number, $$2: number, $$3: number): BlockPos;
        getTimeOfDay($$0: number): number;
        method_39224(): number;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        handler$zei000$port_lib$lightBlock(pos: BlockPos_, state: Internal.BlockState_, flags: number, recursionLeft: number, cir: Internal.CallbackInfoReturnable_<any>, levelChunk: Internal.LevelChunk_, block: Internal.Block_, blockstate: Internal.BlockState_, blockstate1: Internal.BlockState_): void;
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getMaxSection(): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getPartEntityMap(): Internal.Int2ObjectMap<any>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        static isInSpawnableBounds($$0: BlockPos_): boolean;
        fabric_getLoadedChunks(): Internal.Set<any>;
        method_8608(): boolean;
        fillReportDetails($$0: Internal.CrashReport_): Internal.CrashReportCategory;
        addFreshBlockEntities(beList: Internal.Collection_<any>): void;
        updateSkyBrightness(): void;
        guardEntityTick<T>($$0: Internal.Consumer_<T>, $$1: T): void;
        addParticle($$0: Internal.ParticleOptions_, $$1: boolean, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        sendBlockUpdated(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.BlockState_, arg3: number): void;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        updateNeighbourForOutputSignal($$0: BlockPos_, $$1: Internal.Block_): void;
        getNearbyEntities<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        method_16359($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        updateNeighborsAtExceptFromFacing($$0: BlockPos_, $$1: Internal.Block_, $$2: Internal.Direction_): void;
        method_8333($$0: Internal.Entity_, $$1: Internal.AABB_, $$2: Internal.Predicate_<Internal.Entity_>): Internal.List<Internal.Entity>;
        handler$zei000$port_lib$pendingBlockEntities(ci: Internal.CallbackInfo_): void;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        createFireworks($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.CompoundTag_): void;
        method_8611($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        method_16358($$0: BlockPos_, $$1: Internal.Predicate_<Internal.BlockState_>): boolean;
        removeBlockEntity($$0: BlockPos_): void;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getRecipeManager(): Internal.RecipeManager;
        getBrightness($$0: BlockPos_): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        isEmptyBlock($$0: BlockPos_): boolean;
        addAlwaysVisibleParticle($$0: Internal.ParticleOptions_, $$1: boolean, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        addAlwaysVisibleParticle($$0: Internal.ParticleOptions_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): void;
        canSeeSky($$0: BlockPos_): boolean;
        sendPacketToServer($$0: Internal.Packet_<any>): void;
        blockEntityChanged($$0: BlockPos_): void;
        isWaterAt($$0: BlockPos_): boolean;
        getNearestEntity<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        getNearestEntity<T>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        isRainingAt($$0: BlockPos_): boolean;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getRecipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        method_30271(): number;
        method_8320($$0: BlockPos_): Internal.BlockState;
        handler$cke000$Level_updateNeighborsAtExceptFromFacing(blockPos: BlockPos_, block: Internal.Block_, direction: Internal.Direction_, ci: Internal.CallbackInfo_): void;
        getChunkAt($$0: BlockPos_): Internal.LevelChunk;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        method_8321($$0: BlockPos_): Internal.BlockEntity;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getMoonBrightness(): number;
        fabric_markLoaded(chunk: Internal.LevelChunk_): void;
        gatherChunkSourceStats(): string;
        method_22336(): Internal.LevelLightEngine;
        method_22338($$0: number, $$1: number): Internal.BlockGetter;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        handler$zei000$port_lib$updateNeighbourForOutputSignal(pos: BlockPos_, block: Internal.Block_, ci: Internal.CallbackInfo_, var3: Internal.Iterator_<any>, direction: Internal.Direction_, offset: BlockPos_, state: Internal.BlockState_): void;
        handler$zei000$port_lib$onBlockEntitiesLoad(ci: Internal.CallbackInfo_): void;
        setBlocksDirty($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Internal.BlockState_): void;
        getLightEmission($$0: BlockPos_): number;
        modifyExpressionValue$zei000$port_lib$getRedstoneSignal(conductor: boolean, pos: BlockPos_, facing: Internal.Direction_): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        toComponentPacket<C>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        hasChunkAt($$0: BlockPos_): boolean;
        hasChunkAt($$0: number, $$1: number): boolean;
        setThunderLevel($$0: number): void;
        setBlockEntity($$0: Internal.BlockEntity_): void;
        addDestroyBlockEffect($$0: BlockPos_, $$1: Internal.BlockState_): void;
        isDebug(): boolean;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        method_8594(): number;
        method_8598($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        method_8597(): Internal.DimensionType;
        addFreshEntity($$0: Internal.Entity_): boolean;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        dimension(): Internal.ResourceKey<Internal.Level>;
        mayInteract($$0: Internal.Player_, $$1: BlockPos_): boolean;
        addBlockEntityTicker($$0: Internal.TickingBlockEntity_): void;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        method_8615(): number;
        getSunAngle($$0: number): number;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        asKJS(): Internal.LevelJS;
        isDay(): boolean;
        handler$jcj000$onClose(info: Internal.CallbackInfo_): void;
        destroyBlockProgress(arg0: number, arg1: BlockPos_, arg2: number): void;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_): Internal.List<T>;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        isHumidAt($$0: BlockPos_): boolean;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_): void;
        gameEvent($$0: Internal.GameEvent_, $$1: Internal.Entity_): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Internal.Entity_): void;
        getChunk($$0: number, $$1: number): Internal.LevelChunk;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        isThundering(): boolean;
        method_8621(): Internal.WorldBorder;
        broadcastEntityEvent($$0: Internal.Entity_, $$1: number): void;
        getDifficulty(): Internal.Difficulty;
        method_8624($$0: Internal.Heightmap$Types_, $$1: number, $$2: number): number;
        method_8503(): Internal.MinecraftServer;
        static readonly "LONG_PARTICLE_CLIP_RANGE" : 512;
        readonly "isClientSide" : boolean;
        readonly "random" : Internal.Random;
        static readonly "OVERWORLD" : Internal.ResourceKey<Internal.Level>;
        static readonly "TICKS_PER_DAY" : 24000;
        static readonly "MAX_ENTITY_SPAWN_Y" : 20000000;
        static readonly "NETHER" : Internal.ResourceKey<Internal.Level>;
        static readonly "RESOURCE_KEY_CODEC" : Internal.Codec<Internal.ResourceKey<Internal.Level>>;
        static readonly "MAX_BRIGHTNESS" : 15;
        static readonly "END" : Internal.ResourceKey<Internal.Level>;
        static readonly "MAX_LEVEL_SIZE" : 30000000;
        static readonly "SHORT_PARTICLE_CLIP_RANGE" : 32;
        static readonly "MIN_ENTITY_SPAWN_Y" : -20000000;
        get raining(): boolean;
        get maxSection(): number;
        get partEntityMap(): Internal.Int2ObjectMap<any>;
        get maxLightLevel(): number;
        get maxBuildHeight(): number;
        get moonBrightness(): number;
        get dayTime(): number;
        get gameRules(): Internal.GameRules;
        get gameTime(): number;
        get recipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        get scoreboard(): Internal.Scoreboard;
        get moonPhase(): number;
        get day(): boolean;
        get debug(): boolean;
        get night(): boolean;
        get freeMapId(): number;
        get thundering(): boolean;
        get profiler(): Internal.ProfilerFiller;
        get sectionsCount(): number;
        get lunarContext(): Internal.LunarContext;
        get difficulty(): Internal.Difficulty;
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>;
        get profilerSupplier(): Internal.Supplier<Internal.ProfilerFiller>;
        get minSection(): number;
        get recipeManager(): Internal.RecipeManager;
        get componentContainer(): Internal.ComponentContainer;
        set lunarContext(lunarContext: Internal.LunarContext_);
        set thunderLevel($$0: number);
        set blockEntity($$0: Internal.BlockEntity_);
        set skyFlashTime($$0: number);
        set rainLevel($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Level_ = Special.Level | Level;
    /**
    * @javaClass net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions
    */
    interface NetworkHandlerExtensions {
        getAddon(): Internal.AbstractNetworkAddon<any>;
    }
    type NetworkHandlerExtensions_ = NetworkHandlerExtensions;
    /**
    * @javaClass com.mojang.authlib.minecraft.TelemetrySession
    */
    interface TelemetrySession {
        eventSetupFunction(arg0: Internal.Consumer_<Internal.TelemetryPropertyContainer_>): void;
        isEnabled(): boolean;
        globalProperties(): Internal.TelemetryPropertyContainer;
        createNewEvent(arg0: string): Internal.TelemetryEvent;
    }
    type TelemetrySession_ = TelemetrySession;
    /**
    * @javaClass net.minecraft.class_2568$class_5247
    */
    class HoverEvent$Action <T> {
        getName(): string;
        serializeArg($$0: any): Internal.JsonElement;
        deserializeFromLegacy($$0: net.minecraft.network.chat.Component_): Internal.HoverEvent;
        static getByName($$0: string): Internal.HoverEvent$Action<any>;
        toString(): string;
        deserialize($$0: Internal.JsonElement_): Internal.HoverEvent;
        isAllowedFromServer(): boolean;
        static readonly "SHOW_ITEM" : Internal.HoverEvent$Action<Internal.HoverEvent$ItemStackInfo>;
        static readonly "SHOW_ENTITY" : Internal.HoverEvent$Action<Internal.HoverEvent$EntityTooltipInfo>;
        static readonly "SHOW_TEXT" : Internal.HoverEvent$Action<net.minecraft.network.chat.Component>;
        get allowedFromServer(): boolean;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: boolean, $$2: ((arg0: Internal.JsonElement) => T), $$3: ((arg0: T) => Internal.JsonElement), $$4: ((arg0: net.minecraft.network.chat.Component) => T));
    }
    type HoverEvent$Action_<T> = HoverEvent$Action<T>;
    /**
    * @javaClass net.minecraft.class_2582
    */
    class BannerPattern extends Internal.Enum<Internal.BannerPattern> {
        getFilename(): string;
        static byHash($$0: string): Internal.BannerPattern;
        getHashname(): string;
        static valueOf($$0: string): Internal.BannerPattern;
        static values(): Internal.BannerPattern[];
        static byFilename($$0: string): Internal.BannerPattern;
        location($$0: boolean): ResourceLocation;
        static readonly "TRIANGLE_TOP" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_NAGA" : Internal.BannerPattern;
        static readonly "DIAGONAL_RIGHT_MIRROR" : Internal.BannerPattern;
        static readonly "STRAIGHT_CROSS" : Internal.BannerPattern;
        static readonly "SKULL" : Internal.BannerPattern;
        static readonly "CIRCLE_MIDDLE" : Internal.BannerPattern;
        static readonly "HALF_VERTICAL_MIRROR" : Internal.BannerPattern;
        static readonly "BRICKS" : Internal.BannerPattern;
        static readonly "TRIANGLES_BOTTOM" : Internal.BannerPattern;
        static readonly "SQUARE_TOP_LEFT" : Internal.BannerPattern;
        static readonly "FLOWER" : Internal.BannerPattern;
        static readonly "STRIPE_SMALL" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_PHANTOMS" : Internal.BannerPattern;
        static readonly "TRIANGLES_TOP" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_ALPHA_YETI" : Internal.BannerPattern;
        static readonly "AVAILABLE_PATTERNS" : 34;
        static readonly "STRIPE_DOWNLEFT" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_MINOSHROOM" : Internal.BannerPattern;
        static readonly "BORDER" : Internal.BannerPattern;
        static readonly "MOJANG" : Internal.BannerPattern;
        static readonly "HALF_VERTICAL" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_UR_GHAST" : Internal.BannerPattern;
        static readonly "COUNT" : 50;
        static readonly "SQUARE_BOTTOM_RIGHT" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_QUEST_RAM" : Internal.BannerPattern;
        static readonly "STRIPE_BOTTOM" : Internal.BannerPattern;
        static readonly "GLOBE" : Internal.BannerPattern;
        static readonly "SQUARE_TOP_RIGHT" : Internal.BannerPattern;
        static readonly "STRIPE_MIDDLE" : Internal.BannerPattern;
        static readonly "HALF_HORIZONTAL_MIRROR" : Internal.BannerPattern;
        static readonly "STRIPE_TOP" : Internal.BannerPattern;
        static readonly "STRIPE_CENTER" : Internal.BannerPattern;
        static readonly "SQUARE_BOTTOM_LEFT" : Internal.BannerPattern;
        static readonly "RHOMBUS_MIDDLE" : Internal.BannerPattern;
        static readonly "HALF_HORIZONTAL" : Internal.BannerPattern;
        static readonly "GRADIENT" : Internal.BannerPattern;
        static readonly "BASE" : Internal.BannerPattern;
        static readonly "STRIPE_RIGHT" : Internal.BannerPattern;
        static readonly "CREEPER" : Internal.BannerPattern;
        static readonly "STRIPE_LEFT" : Internal.BannerPattern;
        static readonly "TRIANGLE_BOTTOM" : Internal.BannerPattern;
        static readonly "CURLY_BORDER" : Internal.BannerPattern;
        static readonly "DIAGONAL_RIGHT" : Internal.BannerPattern;
        static readonly "PATTERN_ITEM_COUNT" : 15;
        static readonly "TWILIGHTFOREST_LICH" : Internal.BannerPattern;
        static readonly "DIAGONAL_LEFT_MIRROR" : Internal.BannerPattern;
        static readonly "STRIPE_DOWNRIGHT" : Internal.BannerPattern;
        static readonly "PIGLIN" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_SNOW_QUEEN" : Internal.BannerPattern;
        static readonly "GRADIENT_UP" : Internal.BannerPattern;
        static readonly "DIAGONAL_LEFT" : Internal.BannerPattern;
        static readonly "TWILIGHTFOREST_HYDRA" : Internal.BannerPattern;
        static readonly "CROSS" : Internal.BannerPattern;
        get filename(): string;
        get hashname(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BannerPattern_ = "triangle_bottom" | "circle_middle" | "stripe_right" | "twilightforest_alpha_yeti" | "stripe_downleft" | "triangles_top" | "square_bottom_left" | "twilightforest_hydra" | "triangles_bottom" | "mojang" | "twilightforest_ur_ghast" | "rhombus_middle" | "border" | "stripe_small" | "gradient_up" | "half_vertical_mirror" | "globe" | "twilightforest_lich" | "square_bottom_right" | "stripe_middle" | "stripe_center" | "creeper" | "twilightforest_snow_queen" | "twilightforest_phantoms" | "straight_cross" | "diagonal_left_mirror" | "stripe_bottom" | "diagonal_right_mirror" | "half_horizontal_mirror" | "triangle_top" | "square_top_left" | "piglin" | "twilightforest_quest_ram" | "skull" | "twilightforest_naga" | "stripe_left" | "bricks" | "twilightforest_minoshroom" | "gradient" | "cross" | "diagonal_right" | "half_vertical" | "curly_border" | "stripe_top" | "flower" | "stripe_downright" | "diagonal_left" | "square_top_right" | "base" | "half_horizontal" | BannerPattern;
    /**
    * @javaClass java.net.FileNameMap
    */
    interface FileNameMap {
        getContentTypeFor(arg0: string): string;
    }
    type FileNameMap_ = FileNameMap;
    /**
    * @javaClass com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType
    */
    class BehaviourType <T> {
        getName(): string;
        hashCode(): number;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(name: string);
        constructor();
    }
    type BehaviourType_<T> = BehaviourType<T>;
    /**
    * @javaClass net.minecraft.class_783
    */
    class BlockElementFace {
        readonly "uv" : Internal.BlockFaceUV;
        readonly "tintIndex" : number;
        readonly "cullForDirection" : Internal.Direction;
        readonly "texture" : string;
        static readonly "NO_TINT" : -1;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Direction, $$1: number, $$2: string, $$3: Internal.BlockFaceUV);
    }
    type BlockElementFace_ = BlockElementFace;
    /**
    * @javaClass net.kyrptonaught.customportalapi.mixin.client.ChunkRendererRegionAccessor
    */
    interface ChunkRendererRegionAccessor {
        getWorld(): Internal.Level;
    }
    type ChunkRendererRegionAccessor_ = ChunkRendererRegionAccessor;
    /**
    * @javaClass net.coderbot.iris.mixin.ProgramTypeAccessor
    */
    interface ProgramTypeAccessor {
    }
    type ProgramTypeAccessor_ = ProgramTypeAccessor;
    /**
    * @javaClass xaero.common.minimap.waypoints.Waypoint
    */
    class Waypoint implements Internal.Comparable<Internal.Waypoint> {
        setName(name: string): void;
        setY(y: number): void;
        setX(x: number): void;
        getActualColor(): number;
        getName(): string;
        setOneoffDestination(oneoffDestination: boolean): void;
        setYIncluded(yIncluded: boolean): void;
        setDisabled(b: boolean): void;
        isTemporary(): boolean;
        compareTo(other: Internal.Waypoint_): number;
        setZ(z: number): void;
        isOneoffDestination(): boolean;
        static getStringFromStringSafe(stringSafe: string, replacement: string): string;
        getCreatedAt(): number;
        getComparisonAngleCos(camera: Internal.Camera_, dimDiv: number): number;
        getLocalizedName(): string;
        getDistanceSq(x: number, y: number, z: number): number;
        isRotation(): boolean;
        isYIncluded(): boolean;
        isDisabled(): boolean;
        getComparisonDistance(camera: Internal.Camera_, dimDiv: number): number;
        setTemporary(temporary: boolean): void;
        getNameSafe(replacement: string): string;
        getSymbolSafe(replacement: string): string;
        getVisibilityType(): number;
        getColor(): number;
        setRotation(rotation: boolean): void;
        setType(type: number): void;
        setVisibilityType(visibilityType: number): void;
        setYaw(yaw: number): void;
        getYaw(): number;
        getX(dimDiv: number): number;
        getX(): number;
        getY(): number;
        setColor(c: number): void;
        getZ(): number;
        getZ(dimDiv: number): number;
        getWaypointType(): number;
        getType(): number;
        isGlobal(): boolean;
        getComparisonName(): string;
        isServerWaypoint(): boolean;
        getSymbol(): string;
        setSymbol(symbol: string): void;
        static readonly "ONEOFF_DESTINATION_SAFE_FOR" : 5000;
        static readonly "ONEOFF_DESTINATION_REMOVE_DISTANCE" : 4;
        static "RENDER_SORTING_POS" : Vec3;
        get temporary(): boolean;
        get yIncluded(): boolean;
        get symbol(): string;
        get localizedName(): string;
        get serverWaypoint(): boolean;
        get color(): number;
        get rotation(): boolean;
        get waypointType(): number;
        get global(): boolean;
        get type(): number;
        get comparisonName(): string;
        get yaw(): number;
        get createdAt(): number;
        get actualColor(): number;
        get name(): string;
        get x(): number;
        get oneoffDestination(): boolean;
        get y(): number;
        get disabled(): boolean;
        get z(): number;
        get visibilityType(): number;
        set symbol(symbol: string);
        set temporary(temporary: boolean);
        set yIncluded(yIncluded: boolean);
        set color(c: number);
        set rotation(rotation: boolean);
        set type(type: number);
        set yaw(yaw: number);
        set x(x: number);
        set name(name: string);
        set oneoffDestination(oneoffDestination: boolean);
        set y(y: number);
        set z(z: number);
        set disabled(b: boolean);
        set visibilityType(visibilityType: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(x: number, y: number, z: number, name: string, symbol: string, color: number);
        constructor(x: number, y: number, z: number, name: string, symbol: string, color: number, type: number, temp: boolean, yIncluded: boolean);
        constructor(x: number, y: number, z: number, name: string, symbol: string, color: number, type: number);
        constructor(x: number, y: number, z: number, name: string, symbol: string, color: number, type: number, temp: boolean);
    }
    type Waypoint_ = Waypoint;
    /**
    * @javaClass io.netty.channel.ChannelInboundInvoker
    */
    interface ChannelInboundInvoker {
        fireChannelRead(arg0: any): this;
        fireChannelInactive(): this;
        fireChannelReadComplete(): this;
        fireChannelWritabilityChanged(): this;
        fireExceptionCaught(arg0: Internal.Throwable_): this;
        fireChannelActive(): this;
        fireUserEventTriggered(arg0: any): this;
        fireChannelRegistered(): this;
        fireChannelUnregistered(): this;
    }
    type ChannelInboundInvoker_ = ChannelInboundInvoker;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.config.ConfigValue
    */
    abstract class ConfigValue <T> implements Internal.Comparable<Internal.ConfigValue<T>> {
        init(g: Internal.ConfigGroup_, i: string, v: T, c: Internal.Consumer_<T>, def: T): Internal.ConfigValue<T>;
        getName(): string;
        setCanEdit(e: boolean): Internal.ConfigValue<T>;
        isEqual(v1: T, v2: T): boolean;
        getColor(v: T): Internal.Color4I;
        addInfo(list: Internal.TooltipList_): void;
        compareTo(o: Internal.ConfigValue_<T>): number;
        getIcon(v: T): Internal.Icon;
        getCanEdit(): boolean;
        setIcon(i: Internal.Icon_): Internal.ConfigValue<T>;
        setOrder(o: number): Internal.ConfigValue<T>;
        getNameKey(): string;
        setNameKey(key: string): Internal.ConfigValue<T>;
        getTooltip(): string;
        getStringForGUI(v: T): net.minecraft.network.chat.Component;
        onClicked(arg0: Internal.MouseButton_, arg1: Internal.ConfigCallback_): void;
        getPath(): string;
        setCurrentValue(v: T): boolean;
        copy(value: T): T;
        static info(key: string, value: any): net.minecraft.network.chat.Component;
        "defaultValue" : T;
        "id" : string;
        static readonly "NULL_TEXT" : Internal.TextComponent;
        "setter" : ((arg0: T) => void);
        "value" : T;
        "group" : Internal.ConfigGroup;
        get path(): string;
        get nameKey(): string;
        get canEdit(): boolean;
        get name(): string;
        get tooltip(): string;
        set nameKey(key: string);
        set canEdit(e: boolean);
        set icon(i: Internal.Icon_);
        set currentValue(v: T);
        set order(o: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ConfigValue_<T> = ConfigValue<T>;
    /**
    * @javaClass net.minecraft.class_4050
    */
    class Pose extends Internal.Enum<Internal.Pose> {
        static valueOf($$0: string): Internal.Pose;
        static values(): Internal.Pose[];
        static readonly "SLEEPING" : Internal.Pose;
        static readonly "FALL_FLYING" : Internal.Pose;
        static readonly "LONG_JUMPING" : Internal.Pose;
        static readonly "DYING" : Internal.Pose;
        static readonly "CROUCHING" : Internal.Pose;
        static readonly "STANDING" : Internal.Pose;
        static readonly "SWIMMING" : Internal.Pose;
        static readonly "SPIN_ATTACK" : Internal.Pose;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Pose_ = "standing" | "swimming" | "crouching" | "long_jumping" | "dying" | "fall_flying" | "spin_attack" | "sleeping" | Pose;
    /**
    * @javaClass net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel
    */
    interface FabricBakedModel {
        emitItemQuads(arg0: Internal.ItemStack_, arg1: Internal.Supplier_<Internal.Random_>, arg2: net.fabricmc.fabric.api.renderer.v1.render.RenderContext_): void;
        emitBlockQuads(arg0: Internal.BlockAndTintGetter_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Supplier_<Internal.Random_>, arg4: net.fabricmc.fabric.api.renderer.v1.render.RenderContext_): void;
        isVanillaAdapter(): boolean;
    }
    type FabricBakedModel_ = FabricBakedModel;
    /**
    * @javaClass net.minecraft.class_1474
    */
    class TropicalFish extends Internal.AbstractSchoolingFish {
        getBaseColor(): number[];
        static getBaseColor($$0: number): Internal.DyeColor;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getVariant(): number;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        method_5969($$0: number): boolean;
        static getFishTypeName($$0: number): string;
        getPatternTextureLocation(): ResourceLocation;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        static getPredefinedName($$0: number): string;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        getBaseTextureLocation(): ResourceLocation;
        foodEatenKJS(is: Internal.ItemStack_): void;
        static checkTropicalFishSpawnRules($$0: Internal.EntityType_<Internal.TropicalFish_>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.Random_): boolean;
        setVariant($$0: number): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_6452(): Internal.ItemStack;
        getPatternColor(): number[];
        static getPatternColor($$0: number): Internal.DyeColor;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_6455($$0: Internal.ItemStack_): void;
        getBaseVariant(): number;
        static getBaseVariant($$0: number): number;
        static readonly "BASE_LARGE" : 1;
        static readonly "BASE_SMALL" : 0;
        static readonly "BUCKET_VARIANT_TAG" : "BucketVariantTag";
        static readonly "COMMON_VARIANTS" : number[];
        get patternColor(): number[];
        get baseTextureLocation(): ResourceLocation;
        get variant(): number;
        get baseColor(): number[];
        get stepHeight(): number;
        get patternTextureLocation(): ResourceLocation;
        get baseVariant(): number;
        set variant($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.TropicalFish>, $$1: Internal.Level);
    }
    type TropicalFish_ = TropicalFish;
    /**
    * @javaClass net.minecraft.class_1299$class_4049
    */
    interface EntityType$EntityFactory <T> {
        create(arg0: Internal.EntityType_<T>, arg1: Internal.Level_): T;
    }
    type EntityType$EntityFactory_<T> = EntityType$EntityFactory<T>;
    /**
    * @javaClass eu.ha3.presencefootsteps.mixins.ILivingEntity
    */
    interface ILivingEntity {
        isJumping(): boolean;
    }
    type ILivingEntity_ = ILivingEntity;
    /**
    * @javaClass net.minecraft.class_6661
    */
    abstract class PlacementFilter extends Internal.PlacementModifier {
        method_14452($$0: Internal.PlacementContext_, $$1: Internal.Random_, $$2: BlockPos_): Internal.Stream<BlockPos>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type PlacementFilter_ = PlacementFilter;
    /**
    * @javaClass net.minecraft.class_2776
    */
    class StructureMode extends Internal.Enum<Internal.StructureMode> implements Internal.StringRepresentable {
        getDisplayName(): net.minecraft.network.chat.Component;
        static valueOf($$0: string): Internal.StructureMode;
        static values(): Internal.StructureMode[];
        method_15434(): string;
        static readonly "CORNER" : Internal.StructureMode;
        static readonly "LOAD" : Internal.StructureMode;
        static readonly "DATA" : Internal.StructureMode;
        static readonly "SAVE" : Internal.StructureMode;
        get displayName(): net.minecraft.network.chat.Component;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type StructureMode_ = "load" | "corner" | "data" | "save" | StructureMode;
    /**
    * @javaClass net.coderbot.iris.texture.pbr.TextureAtlasSpriteExtension
    */
    interface TextureAtlasSpriteExtension {
        getPBRHolder(): Internal.PBRSpriteHolder;
        getOrCreatePBRHolder(): Internal.PBRSpriteHolder;
    }
    type TextureAtlasSpriteExtension_ = TextureAtlasSpriteExtension;
    /**
    * @javaClass net.minecraft.class_5691
    */
    class DripstoneThickness extends Internal.Enum<Internal.DripstoneThickness> implements Internal.StringRepresentable {
        static valueOf($$0: string): Internal.DripstoneThickness;
        static values(): Internal.DripstoneThickness[];
        method_15434(): string;
        toString(): string;
        static readonly "TIP_MERGE" : Internal.DripstoneThickness;
        static readonly "FRUSTUM" : Internal.DripstoneThickness;
        static readonly "TIP" : Internal.DripstoneThickness;
        static readonly "MIDDLE" : Internal.DripstoneThickness;
        static readonly "BASE" : Internal.DripstoneThickness;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type DripstoneThickness_ = "middle" | "tip_merge" | "frustum" | "tip" | "base" | DripstoneThickness;
    /**
    * @javaClass com.google.common.collect.BaseImmutableMultimap
    */
    abstract class BaseImmutableMultimap <K, V> extends Internal.AbstractMultimap<K, V> {
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BaseImmutableMultimap_<K, V> = BaseImmutableMultimap<K, V>;
    /**
    * @javaClass net.minecraft.class_5713
    */
    interface GameEventDispatcher {
        post(arg0: Internal.GameEvent_, arg1: Internal.Entity_, arg2: BlockPos_): void;
        unregister(arg0: Internal.GameEventListener_): void;
        isEmpty(): boolean;
        register(arg0: Internal.GameEventListener_): void;
    }
    type GameEventDispatcher_ = GameEventDispatcher;
    /**
    * @javaClass net.minecraft.class_337
    */
    class BossHealthOverlay extends Internal.GuiComponent implements Internal.BossBarHudAccessor {
        shouldCreateWorldFog(): boolean;
        handler$bco000$renderPre(poseStack: Internal.PoseStack_, callbackInfo: Internal.CallbackInfo_): void;
        shouldDarkenScreen(): boolean;
        reset(): void;
        update($$0: Internal.ClientboundBossEventPacket_): void;
        handler$bco000$renderPost(poseStack: Internal.PoseStack_, callbackInfo: Internal.CallbackInfo_): void;
        render($$0: Internal.PoseStack_): void;
        shouldPlayMusic(): boolean;
        handler$jap000$onRenderBossBar(matrices: Internal.PoseStack_, x: number, y: number, bossBar: Internal.BossEvent_, info: Internal.CallbackInfo_): void;
        readonly "events" : Internal.Map<Internal.UUID, Internal.LerpingBossEvent>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Minecraft);
    }
    type BossHealthOverlay_ = BossHealthOverlay;
    /**
    * @javaClass snownee.minieffects.mixin.MixinLivingEntity
    */
    interface MixinLivingEntity {
    }
    type MixinLivingEntity_ = MixinLivingEntity;
    /**
    * @javaClass net.coderbot.iris.vertices.ExtendingBufferBuilder
    */
    interface ExtendingBufferBuilder {
        iris$beginWithoutExtending(arg0: Internal.VertexFormat$Mode_, arg1: Internal.VertexFormat_): void;
    }
    type ExtendingBufferBuilder_ = ExtendingBufferBuilder;
    /**
    * @javaClass de.siphalor.nbtcrafting.ingredient.IngredientEntry
    */
    abstract class IngredientEntry {
        toJson(): Internal.JsonElement;
        getRecipeRemainder(stack: Internal.ItemStack_, reference: Internal.Map_<string, any>): Internal.ItemStack;
        setRecipeRemainder(stack: Internal.ItemStack_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        matches(arg0: Internal.ItemStack_): boolean;
        getPreviewStacks(arg0: boolean): Internal.Collection<Internal.ItemStack>;
        getPreviewStacks(): Internal.Collection<Internal.ItemStack>;
        get previewStacks(): Internal.Collection<Internal.ItemStack>;
        set recipeRemainder(stack: Internal.ItemStack_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type IngredientEntry_ = IngredientEntry;
    /**
    * @javaClass net.minecraft.class_1160
    */
    class Vector3f implements Internal.Vector3fExtensions {
        add($$0: number, $$1: number, $$2: number): void;
        add($$0: Internal.Vector3f_): void;
        sub($$0: Internal.Vector3f_): void;
        setY(y: number): void;
        setX(x: number): void;
        set($$0: number, $$1: number, $$2: number): void;
        lerp($$0: Internal.Vector3f_, $$1: number): void;
        mul($$0: number, $$1: number, $$2: number): void;
        mul($$0: number): void;
        rotation($$0: number): Internal.Quaternion;
        cross($$0: Internal.Vector3f_): void;
        dot($$0: Internal.Vector3f_): number;
        setZ(z: number): void;
        transform($$0: Internal.Quaternion_): void;
        transform($$0: Internal.Matrix3f_): void;
        load($$0: Internal.Vector3f_): void;
        hashCode(): number;
        normalize(): boolean;
        rotationDegrees($$0: number): Internal.Quaternion;
        equals($$0: any): boolean;
        x(): number;
        y(): number;
        z(): number;
        toString(): string;
        copy(): this;
        map($$0: Internal.Float2FloatFunction_): void;
        clamp($$0: Internal.Vector3f_, $$1: Internal.Vector3f_): void;
        clamp($$0: number, $$1: number): void;
        static "ZERO" : Internal.Vector3f;
        static readonly "CODEC" : Internal.Codec<Internal.Vector3f>;
        static "ZN" : Internal.Vector3f;
        static "YN" : Internal.Vector3f;
        static "XN" : Internal.Vector3f;
        static "ZP" : Internal.Vector3f;
        static "YP" : Internal.Vector3f;
        static "XP" : Internal.Vector3f;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Vec3);
        constructor($$0: Internal.Vector4f);
        constructor($$0: number, $$1: number, $$2: number);
        constructor();
    }
    type Vector3f_ = Vector3f;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.model.IModelConfiguration
    */
    interface IModelConfiguration {
        getPartVisibility(part: Internal.IModelGeometryPart_): boolean;
        getPartVisibility(part: Internal.IModelGeometryPart_, fallback: boolean): boolean;
        getOwnerModel(): Internal.UnbakedModel;
        getCombinedTransform(): Internal.ModelState;
        isTexturePresent(arg0: string): boolean;
        isShadedInGui(): boolean;
        useSmoothLighting(): boolean;
        getCameraTransforms(): Internal.ItemTransforms;
        getModelName(): string;
        isSideLit(): boolean;
        resolveTexture(arg0: string): Internal.Material;
    }
    type IModelConfiguration_ = IModelConfiguration;
    /**
    * @javaClass net.minecraft.class_2775
    */
    class ClientboundTakeItemEntityPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getItemId(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getPlayerId(): number;
        getAmount(): number;
        get itemId(): number;
        get amount(): number;
        get skippable(): boolean;
        get playerId(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number, $$2: number);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundTakeItemEntityPacket_ = ClientboundTakeItemEntityPacket;
    /**
    * @javaClass net.minecraft.class_1617
    */
    abstract class SpellcasterIllager extends Internal.AbstractIllager implements Internal.SpellcastingIllagerEntityAccessor {
        isCastingSpell(): boolean;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        setIsCastingSpell($$0: Internal.SpellcasterIllager$IllagerSpell_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_6990(): Internal.AbstractIllager$IllagerArmPose;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        get castingSpell(): boolean;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type SpellcasterIllager_ = SpellcasterIllager;
    /**
    * @javaClass net.minecraft.class_4668$class_4676
    */
    class RenderStateShard$LightmapStateShard extends Internal.RenderStateShard$BooleanStateShard {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: boolean);
    }
    type RenderStateShard$LightmapStateShard_ = RenderStateShard$LightmapStateShard;
    /**
    * @javaClass net.minecraft.class_1694
    */
    class MinecartChest extends Internal.AbstractMinecartContainer {
        method_7518(): Internal.AbstractMinecart$Type;
        getMaxStackSize(): number;
        method_5439(): number;
        method_7517(): Internal.BlockState;
        method_7516($$0: Internal.DamageSource_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        method_7526(): number;
        getStepHeight(): number;
        getMaxSpeedOnRail(): number;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        countItem($$0: Internal.Item_): number;
        canRiderInteract(): boolean;
        hasAnyOf($$0: Internal.Set_<Internal.Item_>): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        alwaysAccepts(): boolean;
        method_17357($$0: number, $$1: Internal.Inventory_): Internal.AbstractContainerMenu;
        stopOpen($$0: Internal.Player_): void;
        startOpen($$0: Internal.Player_): void;
        get maxStackSize(): number;
        get stepHeight(): number;
        get maxSpeedOnRail(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.MinecartChest>, $$1: Internal.Level);
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number);
    }
    type MinecartChest_ = MinecartChest;
    /**
    * @javaClass net.minecraft.class_1621
    */
    class Slime extends Internal.Mob implements Internal.Enemy, Internal.SlimeAccessor, Internal.ISlime, Internal.SlimeEntityAccessor {
        method_5978(): number;
        be_setSlimeSize(size: number, heal: boolean): void;
        isTiny(): boolean;
        method_18377($$0: Internal.Pose_): Internal.EntityDimensions;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        method_18382(): void;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        static checkSlimeSpawnRules($$0: Internal.EntityType_<Internal.Slime_>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.Random_): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        getSize(): number;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_5694($$0: Internal.Player_): void;
        method_5650($$0: Internal.Entity$RemovalReason_): void;
        entityRemove(removalReason: Internal.Entity$RemovalReason_): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_5864(): Internal.EntityType<Internal.Slime>;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        method_5697($$0: Internal.Entity_): void;
        static readonly "MIN_SIZE" : 1;
        "wasOnGround" : boolean;
        "oSquish" : number;
        "targetSquish" : number;
        static readonly "MAX_SIZE" : 127;
        "squish" : number;
        get size(): number;
        get tiny(): boolean;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Slime>, $$1: Internal.Level);
    }
    type Slime_ = Slime;
    /**
    * @javaClass dev.cammiescorner.arcanus.core.util.MagicUser
    */
    interface MagicUser {
        setMana(arg0: number): void;
        setKnownSpell(arg0: ResourceLocation_): void;
        getKnownSpells(): Internal.List<Internal.Spell>;
        setActiveSpell(arg0: Internal.Spell_, arg1: number): void;
        getMaxBurnout(): number;
        setLastCastTime(arg0: number): void;
        isManaVisible(): boolean;
        addMana(arg0: number): void;
        getMaxMana(): number;
        shouldShowMana(arg0: boolean): void;
        getBurnout(): number;
        addBurnout(arg0: number): void;
        getMana(): number;
        setBurnout(arg0: number): void;
    }
    type MagicUser_ = MagicUser;
    /**
    * @javaClass de.siphalor.amecs.impl.duck.IMouse
    */
    interface IMouse {
        amecs$getMouseScrolledEventUsed(): boolean;
    }
    type IMouse_ = IMouse;
    /**
    * @javaClass net.minecraft.class_2750
    */
    class DoorHingeSide extends Internal.Enum<Internal.DoorHingeSide> implements Internal.StringRepresentable {
        static valueOf($$0: string): Internal.DoorHingeSide;
        static values(): Internal.DoorHingeSide[];
        method_15434(): string;
        toString(): string;
        static readonly "LEFT" : Internal.DoorHingeSide;
        static readonly "RIGHT" : Internal.DoorHingeSide;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type DoorHingeSide_ = "left" | "right" | DoorHingeSide;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.ItemModificationProperties
    */
    class ItemModificationProperties {
        setBurnTime(i: number): void;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorToughness(armorToughness: number): void;
        setMaxDamage(i: number): void;
        setMaxStackSize(i: number): void;
        setCraftingRemainder(i: Internal.Item_): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder_>): void;
        setRarity(r: Rarity_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier_>): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDigSpeed(speed: number): void;
        setAttackSpeed(attackSpeed: number): void;
        setFireResistant(b: boolean): void;
        setArmorProtection(armorProtection: number): void;
        getDigSpeed(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setAttackDamage(attackDamage: number): void;
        readonly "item" : Internal.ItemKJS;
        get digSpeed(): number;
        set maxStackSize(i: number);
        set maxDamage(i: number);
        set digSpeed(speed: number);
        set armorProtection(armorProtection: number);
        set fireResistant(b: boolean);
        set armorToughness(armorToughness: number);
        set tier(c: Internal.Consumer_<Internal.MutableToolTier_>);
        set armorKnockbackResistance(knockbackResistance: number);
        set burnTime(i: number);
        set attackSpeed(attackSpeed: number);
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder_>);
        set craftingRemainder(i: Internal.Item_);
        set attackDamage(attackDamage: number);
        set rarity(r: Rarity_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: Internal.ItemKJS);
    }
    type ItemModificationProperties_ = ItemModificationProperties;
    /**
    * @javaClass net.minecraft.class_1011
    */
    class NativeImage implements Internal.AutoCloseable {
        static getG($$0: number): number;
        upload($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: boolean, $$8: boolean): void;
        upload($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: boolean, $$8: boolean, $$9: boolean, $$10: boolean): void;
        upload($$0: number, $$1: number, $$2: number, $$3: boolean): void;
        resizeSubRectTo($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.NativeImage_): void;
        blendPixel($$0: number, $$1: number, $$2: number): void;
        downloadDepthBuffer($$0: number): void;
        makePixelArray(): number[];
        getWidth(): number;
        static fromBase64($$0: string): Internal.NativeImage;
        static getR($$0: number): number;
        fillRect($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): void;
        writeToFile($$0: string): void;
        writeToFile($$0: Internal.File_): void;
        writeToFile($$0: Internal.Path_): void;
        getPixelRGBA($$0: number, $$1: number): number;
        getHeight(): number;
        setPixelRGBA($$0: number, $$1: number, $$2: number): void;
        getLuminanceOrAlpha($$0: number, $$1: number): number;
        copyFromFont($$0: Internal.STBTTFontinfo_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number): void;
        untrack(): void;
        drawPixels(): void;
        getRedOrLuminance($$0: number, $$1: number): number;
        static getA($$0: number): number;
        static getB($$0: number): number;
        flipY(): void;
        close(): void;
        static combine($$0: number, $$1: number, $$2: number, $$3: number): number;
        static read($$0: Internal.NativeImage$Format_, $$1: Internal.ByteBuffer_): Internal.NativeImage;
        static read($$0: Internal.NativeImage$Format_, $$1: Internal.InputStream_): Internal.NativeImage;
        static read($$0: Internal.ByteBuffer_): Internal.NativeImage;
        static read($$0: Internal.InputStream_): Internal.NativeImage;
        format(): Internal.NativeImage$Format;
        copyFrom($$0: Internal.NativeImage_): void;
        setPixelLuminance($$0: number, $$1: number, $$2: number): void;
        copyRect($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean, $$7: boolean): void;
        asByteArray(): number[];
        downloadTexture($$0: number, $$1: boolean): void;
        toString(): string;
        getBlueOrLuminance($$0: number, $$1: number): number;
        getGreenOrLuminance($$0: number, $$1: number): number;
        "pixels" : number;
        readonly "useStbFree" : boolean;
        get width(): number;
        get height(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.NativeImage$Format, $$1: number, $$2: number, $$3: boolean);
        constructor($$0: number, $$1: number, $$2: boolean);
    }
    type NativeImage_ = NativeImage;
    /**
    * @javaClass net.minecraft.class_1739
    */
    class AirItem extends Internal.Item {
        getAttributeModifiers(stack: Internal.ItemStack_, slot: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Hand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getToughness(itemStack: Internal.ItemStack_): number;
        getLightEmission(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getAttackDamage(itemStack: Internal.ItemStack_): number;
        method_7851($$0: Internal.ItemStack_, $$1: Internal.Level_, $$2: Internal.List_<net.minecraft.network.chat.Component_>, $$3: Internal.TooltipFlag_): void;
        getProtection(itemStack: Internal.ItemStack_): number;
        thonkutil$getId(): ResourceLocation;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        method_7876(): string;
        onStackCreated(itemStack: Internal.ItemStack_, count: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Block, $$1: Internal.Item$Properties);
    }
    type AirItem_ = AirItem;
    /**
    * @javaClass dev.latvian.mods.kubejs.loot.LootEventJS
    */
    abstract class LootEventJS extends Internal.EventJS {
        modify(id: ResourceLocation_, b: Internal.Consumer_<Internal.LootBuilder_>): void;
        removeAll(): void;
        getType(): string;
        getDirectory(): string;
        addJson(id: ResourceLocation_, json: Internal.JsonObject_): void;
        get type(): string;
        get directory(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(c: Internal.Map<ResourceLocation, Internal.JsonElement>);
    }
    type LootEventJS_ = LootEventJS;
    /**
    * @javaClass net.minecraft.class_2716
    */
    class ClientboundRemoveEntitiesPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getEntityIds(): Internal.IntList;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean;
        get entityIds(): Internal.IntList;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.FriendlyByteBuf);
        constructor($$0: number[]);
        constructor($$0: Internal.IntList);
    }
    type ClientboundRemoveEntitiesPacket_ = ClientboundRemoveEntitiesPacket;
    /**
    * @javaClass it.unimi.dsi.fastutil.Hash$Strategy
    */
    interface Hash$Strategy <K> {
        hashCode(arg0: K): number;
        equals(arg0: K, arg1: K): boolean;
    }
    type Hash$Strategy_<K> = Hash$Strategy<K>;
    /**
    * @javaClass net.minecraft.class_3414
    */
    class SoundEvent implements com.terraformersmc.cinderscapes.mixin.SoundEventAccessor, Internal.SoundEventAccessor {
        getLocation(): ResourceLocation;
        static readonly "CODEC" : Internal.Codec<Internal.SoundEvent>;
        get location(): ResourceLocation;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: ResourceLocation);
    }
    type SoundEvent_ = Special.SoundEvent | SoundEvent;
    /**
    * @javaClass net.minecraft.class_19
    */
    class MapFrame {
        static load($$0: Internal.CompoundTag_): Internal.MapFrame;
        getPos(): BlockPos;
        static frameId($$0: BlockPos_): string;
        getRotation(): number;
        save(): Internal.CompoundTag;
        getId(): string;
        getEntityId(): number;
        get pos(): BlockPos;
        get rotation(): number;
        get entityId(): number;
        get id(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: number, $$2: number);
    }
    type MapFrame_ = MapFrame;
    /**
    * @javaClass net.fabricmc.fabric.mixin.object.builder.PointOfInterestTypeAccessor
    */
    interface PointOfInterestTypeAccessor {
    }
    type PointOfInterestTypeAccessor_ = PointOfInterestTypeAccessor;
    /**
    * @javaClass net.minecraft.class_116
    */
    interface FunctionUserBuilder <T> {
        apply(arg0: Internal.LootItemFunction$Builder_): T;
        unwrap(): T;
    }
    type FunctionUserBuilder_<T> = FunctionUserBuilder<T>;
    /**
    * @javaClass java.awt.ImageCapabilities
    */
    class ImageCapabilities implements Internal.Cloneable {
        isAccelerated(): boolean;
        isTrueVolatile(): boolean;
        clone(): any;
        get trueVolatile(): boolean;
        get accelerated(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: boolean);
    }
    type ImageCapabilities_ = ImageCapabilities;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.TeamData
    */
    class TeamData {
        clearCachedProgress(): void;
        handler$hbp000$canStartTasks(quest: Internal.Quest_, cir: Internal.CallbackInfoReturnable_<any>): void;
        setCanEdit(mode: boolean): boolean;
        setProgress(task: Internal.Task_, progress: number): void;
        save(): void;
        resetProgress(task: Internal.Task_): void;
        getProgress(task: Internal.Task_): number;
        getProgress(task: number): number;
        getCanEdit(): boolean;
        serializeNBT(): Internal.SNBTCompoundTag;
        getRewardClaimTime(player: Internal.UUID_, reward: Internal.Reward_): Internal.Date;
        getClaimType(player: Internal.UUID_, reward: Internal.Reward_): Internal.RewardClaimType;
        deleteReward(reward: Internal.Reward_): void;
        setStarted(id: number, time: Internal.Date_): boolean;
        canStartTasks(quest: Internal.Quest_): boolean;
        isLocked(): boolean;
        static get(player: Internal.Player_): Internal.TeamData;
        getStartedTime(id: number): Internal.Date;
        setAutoPin(auto: boolean): void;
        getCompletedTime(id: number): Internal.Date;
        write(buffer: Internal.FriendlyByteBuf_, self: boolean): void;
        isCompleted(object: Internal.QuestObject_): boolean;
        setQuestPinned(id: number, pinned: boolean): void;
        isQuestPinned(id: number): boolean;
        read(buffer: Internal.FriendlyByteBuf_, self: boolean): void;
        hasUnclaimedRewards(player: Internal.UUID_, object: Internal.QuestObject_): boolean;
        getRelativeProgress(object: Internal.QuestObject_): number;
        checkAutoCompletion(quest: Internal.Quest_): void;
        deserializeNBT(nbt: Internal.SNBTCompoundTag_): void;
        isStarted(object: Internal.QuestObject_): boolean;
        setCompleted(id: number, time: Internal.Date_): boolean;
        addProgress(task: Internal.Task_, p: number): void;
        setLocked(b: boolean): boolean;
        copyData(from: Internal.TeamData_): void;
        mergeData(from: Internal.TeamData_): void;
        resetReward(player: Internal.UUID_, reward: Internal.Reward_): boolean;
        areDependenciesComplete(quest: Internal.Quest_): boolean;
        getOnlineMembers(): Internal.List<Internal.ServerPlayer>;
        getAutoPin(): boolean;
        isRewardClaimed(player: Internal.UUID_, reward: Internal.Reward_): boolean;
        claimReward(player: Internal.ServerPlayer_, reward: Internal.Reward_, notify: boolean): void;
        claimReward(player: Internal.UUID_, reward: Internal.Reward_, date: number): boolean;
        toString(): string;
        "file" : Internal.QuestFile;
        readonly "pinnedQuests" : Internal.LongOpenHashSet;
        static "VERSION" : 1;
        "name" : string;
        "shouldSave" : boolean;
        readonly "uuid" : Internal.UUID;
        get onlineMembers(): Internal.List<Internal.ServerPlayer>;
        get canEdit(): boolean;
        get locked(): boolean;
        get autoPin(): boolean;
        set canEdit(mode: boolean);
        set locked(b: boolean);
        set autoPin(auto: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(id: Internal.UUID);
    }
    type TeamData_ = TeamData;
    /**
    * @javaClass com.simibubi.create.foundation.tileEntity.SyncedTileEntity
    */
    abstract class SyncedTileEntity extends Internal.BlockEntity implements Internal.BlockEntityExtensions, Internal.CustomDataPacketHandlingBlockEntity, Internal.CustomUpdateTagHandlingBlockEntity {
        causeBlockUpdate(): void;
        writeClient(tag: Internal.CompoundTag_): Internal.CompoundTag;
        sendData(): void;
        deserializeNBT(state: Internal.BlockState_, nbt: Internal.CompoundTag_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        readClient(tag: Internal.CompoundTag_): void;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        invalidateCaps(): void;
        notifyUpdate(): void;
        containedChunk(): Internal.LevelChunk;
        onDataPacket(connection: Internal.Connection_, packet: Internal.ClientboundBlockEntityDataPacket_): void;
        method_16887(): Internal.CompoundTag;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        handleUpdateTag(tag: Internal.CompoundTag_): void;
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(type: Internal.BlockEntityType<any>, pos: BlockPos, state: Internal.BlockState);
    }
    type SyncedTileEntity_ = SyncedTileEntity;
    /**
    * @javaClass me.shedaniel.rei.api.client.entry.region.RegionEntry
    */
    interface RegionEntry <T> {
        asFavorite(): Internal.FavoriteEntry;
        getMenuEntries(): Internal.Optional<Internal.Supplier<Internal.Collection<Internal.FavoriteMenuEntry>>>;
        getUuid(): Internal.UUID;
        toStack(): Internal.EntryStack<any>;
        copy(): T;
        doAction(button: number): boolean;
        isEntryInvalid(): boolean;
    }
    type RegionEntry_<T> = RegionEntry<T>;
    /**
    * @javaClass net.minecraft.class_2624
    */
    abstract class BaseContainerBlockEntity extends Internal.BlockEntity implements net.minecraft.world.Container, Internal.MenuProvider, Internal.Nameable, Internal.LockableContainerBlockEntityAccessor {
        getMaxStackSize(): number;
        createMenu($$0: number, $$1: Internal.Inventory_, $$2: Internal.Player_): Internal.AbstractContainerMenu;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        setCustomName($$0: net.minecraft.network.chat.Component_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        countItem($$0: Internal.Item_): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item_>): boolean;
        invalidateCaps(): void;
        static canUnlock($$0: Internal.Player_, $$1: Internal.LockCode_, $$2: net.minecraft.network.chat.Component_): boolean;
        hasCustomName(): boolean;
        canOpen($$0: Internal.Player_): boolean;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5797(): net.minecraft.network.chat.Component;
        method_11014($$0: Internal.CompoundTag_): void;
        method_5476(): net.minecraft.network.chat.Component;
        stopOpen($$0: Internal.Player_): void;
        startOpen($$0: Internal.Player_): void;
        method_5477(): net.minecraft.network.chat.Component;
        "lockKey" : Internal.LockCode;
        get maxStackSize(): number;
        set customName($$0: net.minecraft.network.chat.Component_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BaseContainerBlockEntity_ = BaseContainerBlockEntity;
    /**
    * @javaClass org.lwjgl.system.NativeResource
    */
    interface NativeResource extends Internal.AutoCloseable {
        free(): void;
        close(): void;
    }
    type NativeResource_ = NativeResource;
    /**
    * @javaClass xaero.map.region.MapBlock
    */
    class MapBlock extends Internal.MapPixel {
        setSlopeUnknown(slopeUnknown: boolean): void;
        getParametres(): number;
        getPixelColour(result_dest: number[], mapWriter: Internal.MapWriter_, world: Internal.Level_, tileChunk: Internal.MapTileChunk_, prevChunk: Internal.MapTileChunk_, prevChunkDiagonal: Internal.MapTileChunk_, prevChunkHorisontal: Internal.MapTileChunk_, mapTile: Internal.MapTile_, x: number, z: number, mutableGlobalPos: Internal.BlockPos$MutableBlockPos_, biomeRegistry: Internal.Registry_<Internal.Biome_>, shadowR: number, shadowG: number, shadowB: number, blockTintProvider: Internal.BlockTintProvider_, mapProcessor: Internal.MapProcessor_, overlayManager: Internal.OverlayManager_, effectiveHeight: number, blockStateShortShapeCache: Internal.BlockStateShortShapeCache_): void;
        getTopHeight(): number;
        setVerticalSlope(slope: number): void;
        equalsSlopesExcluded(p: Internal.MapBlock_): boolean;
        getHeight(): number;
        getNumberOfOverlays(): number;
        getDiagonalSlope(): number;
        fixHeightType(x: number, z: number, mapTile: Internal.MapTile_, tileChunk: Internal.MapTileChunk_, prevChunk: Internal.MapTileChunk_, prevChunkDiagonal: Internal.MapTileChunk_, prevChunkHorisontal: Internal.MapTileChunk_, height: number, useSourceData: boolean, blockStateShortShapeCache: Internal.BlockStateShortShapeCache_): void;
        setDiagonalSlope(slope: number): void;
        getEffectiveHeight(blockStateShortShapeCache: Internal.BlockStateShortShapeCache_): number;
        getEffectiveHeight(subtractOne: boolean): number;
        prepareForWriting(defaultHeight: number): void;
        setBiome(biome: Internal.BiomeKey_): void;
        write(state: Internal.BlockState_, height: number, topHeight: number, biomeIn: Internal.BiomeKey_, light: number, glowing: boolean, cave: boolean): void;
        addOverlay(o: xaero.map.region.Overlay_): void;
        getBiome(): Internal.BiomeKey;
        isCaveBlock(): boolean;
        isGrass(): boolean;
        setTopHeight(h: number): void;
        setCaveBlock(caveBlock: boolean): void;
        setHeight(h: number): void;
        getEffectiveTopHeight(subtractOne: boolean): number;
        toRenderString(biomeRegistry: Internal.Registry_<Internal.Biome_>): string;
        getVerticalSlope(): number;
        getOverlays(): Internal.ArrayList<xaero.map.region.Overlay>;
        equals(p: Internal.MapBlock_, equalsSlopesExcluded: boolean): boolean;
        get topHeight(): number;
        get parametres(): number;
        get numberOfOverlays(): number;
        get biome(): Internal.BiomeKey;
        get caveBlock(): boolean;
        get grass(): boolean;
        get overlays(): Internal.ArrayList<xaero.map.region.Overlay>;
        get verticalSlope(): number;
        get height(): number;
        get diagonalSlope(): number;
        set topHeight(h: number);
        set caveBlock(caveBlock: boolean);
        set biome(biome: Internal.BiomeKey_);
        set verticalSlope(slope: number);
        set slopeUnknown(slopeUnknown: boolean);
        set height(h: number);
        set diagonalSlope(slope: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type MapBlock_ = MapBlock;
    /**
    * @javaClass com.mojang.datafixers.util.Function7
    */
    interface Function7 <T1, T2, T3, T4, T5, T6, T7, R> {
        apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7): R;
        curry5(): Internal.Function5<T1, T2, T3, T4, T5, Internal.BiFunction<T6, T7, R>>;
        curry6(): Internal.Function6<T1, T2, T3, T4, T5, T6, Internal.Function<T7, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function4<T4, T5, T6, T7, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.Function3<T5, T6, T7, R>>;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function5<T3, T4, T5, T6, T7, R>>;
        curry(): Internal.Function<T1, Internal.Function6<T2, T3, T4, T5, T6, T7, R>>;
    }
    type Function7_<T1, T2, T3, T4, T5, T6, T7, R> = Function7<T1, T2, T3, T4, T5, T6, T7, R>;
    /**
    * @javaClass com.simibubi.create.foundation.utility.IPartialSafeNBT
    */
    interface IPartialSafeNBT {
        writeSafe(arg0: Internal.CompoundTag_): void;
    }
    type IPartialSafeNBT_ = IPartialSafeNBT;
    /**
    * @javaClass net.minecraft.class_6953
    */
    class NoiseRouter extends Internal.Record {
        oreVeinsPositionalRandomFactory(): Internal.PositionalRandomFactory;
        spawnTarget(): Internal.List<Internal.Climate$ParameterPoint>;
        aquiferPositionalRandomFactory(): Internal.PositionalRandomFactory;
        finalDensity(): Internal.DensityFunction;
        initialDensityWithoutJaggedness(): Internal.DensityFunction;
        fluidLevelFloodednessNoise(): Internal.DensityFunction;
        veinRidged(): Internal.DensityFunction;
        barrierNoise(): Internal.DensityFunction;
        continents(): Internal.DensityFunction;
        veinToggle(): Internal.DensityFunction;
        lavaNoise(): Internal.DensityFunction;
        veinGap(): Internal.DensityFunction;
        fluidLevelSpreadNoise(): Internal.DensityFunction;
        depth(): Internal.DensityFunction;
        hashCode(): number;
        ridges(): Internal.DensityFunction;
        equals($$0: any): boolean;
        erosion(): Internal.DensityFunction;
        temperature(): Internal.DensityFunction;
        humidity(): Internal.DensityFunction;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.DensityFunction, $$1: Internal.DensityFunction, $$2: Internal.DensityFunction, $$3: Internal.DensityFunction, $$4: Internal.PositionalRandomFactory, $$5: Internal.PositionalRandomFactory, $$6: Internal.DensityFunction, $$7: Internal.DensityFunction, $$8: Internal.DensityFunction, $$9: Internal.DensityFunction, $$10: Internal.DensityFunction, $$11: Internal.DensityFunction, $$12: Internal.DensityFunction, $$13: Internal.DensityFunction, $$14: Internal.DensityFunction, $$15: Internal.DensityFunction, $$16: Internal.DensityFunction, $$17: Internal.List<Internal.Climate$ParameterPoint>);
    }
    type NoiseRouter_ = NoiseRouter;
    /**
    * @javaClass net.minecraft.server.MinecraftServer$class_6897
    */
    class MinecraftServer$ReloadableResources extends Internal.Record implements Internal.AutoCloseable {
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        close(): void;
        resourceManager(): Internal.CloseableResourceManager;
        managers(): Internal.ReloadableServerResources;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MinecraftServer$ReloadableResources_ = MinecraftServer$ReloadableResources;
    /**
    * @javaClass net.minecraft.class_6686$class_6708
    */
    interface SurfaceRules$RuleSource extends Internal.Function<Internal.SurfaceRules$Context, Internal.SurfaceRules$SurfaceRule> {
        codec(): Internal.Codec<Internal.SurfaceRules$RuleSource>;
        compose<V>(arg0: Internal.Function_<V, Internal.SurfaceRules$Context_>): Internal.Function<V, Internal.SurfaceRules$SurfaceRule>;
        bootstrap($$0: Internal.Registry_<Internal.Codec_<Internal.SurfaceRules$RuleSource_>>): Internal.Codec<Internal.SurfaceRules$RuleSource>;
        andThen<V>(arg0: Internal.Function_<Internal.SurfaceRules$SurfaceRule_, V>): Internal.Function<Internal.SurfaceRules$Context, V>;
    }
    type SurfaceRules$RuleSource_ = (() => Internal.Codec<Internal.SurfaceRules$RuleSource>) | SurfaceRules$RuleSource;
    /**
    * @javaClass net.minecraft.class_2777
    */
    class ClientboundTeleportEntityPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getxRot(): number;
        getyRot(): number;
        getX(): number;
        getY(): number;
        getZ(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getId(): number;
        isOnGround(): boolean;
        isSkippable(): boolean;
        get onGround(): boolean;
        get yRot(): number;
        get xRot(): number;
        get x(): number;
        get y(): number;
        get z(): number;
        get id(): number;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Entity);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundTeleportEntityPacket_ = ClientboundTeleportEntityPacket;
    /**
    * @javaClass net.minecraft.class_642
    */
    class ServerData {
        isLan(): boolean;
        static read($$0: Internal.CompoundTag_): Internal.ServerData;
        getResourcePackStatus(): Internal.ServerData$ServerPackStatus;
        setResourcePackStatus($$0: Internal.ServerData$ServerPackStatus_): void;
        getIconB64(): string;
        write(): Internal.CompoundTag;
        setIconB64($$0: string): void;
        copyFrom($$0: Internal.ServerData_): void;
        "motd" : net.minecraft.network.chat.Component;
        "protocol" : number;
        "ping" : number;
        "ip" : string;
        "playerList" : Internal.List<net.minecraft.network.chat.Component>;
        "name" : string;
        "pinged" : boolean;
        "version" : net.minecraft.network.chat.Component;
        "status" : net.minecraft.network.chat.Component;
        get resourcePackStatus(): Internal.ServerData$ServerPackStatus;
        get lan(): boolean;
        get iconB64(): string;
        set resourcePackStatus($$0: Internal.ServerData$ServerPackStatus_);
        set iconB64($$0: string);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: string, $$2: boolean);
    }
    type ServerData_ = ServerData;
    /**
    * @javaClass net.fabricmc.fabric.api.networking.v1.PacketSender
    */
    interface PacketSender {
        sendPacket(channel: ResourceLocation_, buf: Internal.FriendlyByteBuf_): void;
        sendPacket(channel: ResourceLocation_, buf: Internal.FriendlyByteBuf_, callback: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<void>>): void;
        sendPacket(arg0: Internal.Packet_<any>): void;
        sendPacket(arg0: Internal.Packet_<any>, arg1: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<void>>): void;
        createPacket(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Packet<any>;
    }
    type PacketSender_ = PacketSender;
    /**
    * @javaClass corgitaco.mobifier.common.player.IsInsideStructureTracker$Access
    */
    interface IsInsideStructureTracker$Access {
        getIsInsideStructureTracker(): Internal.IsInsideStructureTracker;
    }
    type IsInsideStructureTracker$Access_ = IsInsideStructureTracker$Access;
    /**
    * @javaClass java.lang.StringBuilder
    */
    class StringBuilder extends Internal.AbstractStringBuilder implements Internal.Serializable, Internal.Comparable<Internal.StringBuilder>, Internal.CharSequence {
        deleteCharAt(arg0: number): this;
        appendCodePoint(arg0: number): this;
        lastIndexOf(arg0: string, arg1: number): number;
        lastIndexOf(arg0: string): number;
        isEmpty(): boolean;
        replace(arg0: number, arg1: number, arg2: string): this;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: string): this;
        insert(arg0: number, arg1: any): this;
        insert(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        insert(arg0: number, arg1: Internal.CharSequence_, arg2: number, arg3: number): this;
        insert(arg0: number, arg1: Internal.CharSequence_): this;
        insert(arg0: number, arg1: string[]): this;
        insert(arg0: number, arg1: boolean): this;
        toString(): string;
        compareTo(arg0: Internal.StringBuilder_): number;
        reverse(): this;
        delete(arg0: number, arg1: number): this;
        indexOf(arg0: string): number;
        indexOf(arg0: string, arg1: number): number;
        append(arg0: Internal.StringBuffer_): this;
        append(arg0: Internal.CharSequence_): this;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        append(arg0: string[]): this;
        append(arg0: any): this;
        append(arg0: string): this;
        append(arg0: number): this;
        append(arg0: boolean): this;
        append(arg0: string[], arg1: number, arg2: number): this;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.CharSequence);
        constructor(arg0: string);
        constructor(arg0: number);
        constructor();
    }
    type StringBuilder_ = StringBuilder;
    /**
    * @javaClass me.shedaniel.rei.api.client.registry.entry.EntryRegistry
    */
    interface EntryRegistry extends Internal.Reloadable<Internal.REIClientPlugin> {
        isReloading(): boolean;
        removeEntry(arg0: Internal.EntryStack_<any>): boolean;
        endReload(stage: Internal.ReloadStage_): void;
        endReload(): void;
        refilter(): void;
        alreadyContain(arg0: Internal.EntryStack_<any>): boolean;
        removeEntryExactHashIf(arg0: Internal.LongPredicate_): boolean;
        beforeReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>, plugin: Internal.REIClientPlugin_): void;
        removeEntryFuzzyHashIf(arg0: Internal.LongPredicate_): boolean;
        getStage(): Internal.ReloadStage;
        addEntriesAfter(afterStack: Internal.EntryStack_<any>, ...stacks: Internal.EntryStack_<any>[]): void;
        addEntriesAfter(arg0: Internal.EntryStack_<any>, arg1: Internal.Collection_<Internal.EntryStack_<any>>): void;
        startReload(stage: Internal.ReloadStage_): void;
        beforeReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>): void;
        isConcurrent(): boolean;
        addEntryAfter(arg0: Internal.EntryStack_<any>, arg1: Internal.EntryStack_<any>): void;
        getEntryStacks(): Internal.Stream<Internal.EntryStack<any>>;
        appendStacksForItem(arg0: Internal.Item_): Internal.List<Internal.ItemStack>;
        afterReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>, plugin: Internal.REIClientPlugin_): void;
        removeEntryIf(arg0: Internal.Predicate_<Internal.EntryStack_<any>>): boolean;
        addEntries(...stacks: Internal.EntryStack_<any>[]): void;
        addEntries(stacks: Internal.Collection_<Internal.EntryStack_<any>>): void;
        acceptPlugin(plugin: Internal.REIClientPlugin_): void;
        acceptPlugin(plugin: Internal.REIClientPlugin_, stage: Internal.ReloadStage_): void;
        getPreFilteredList(): Internal.List<Internal.EntryStack<any>>;
        afterReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>): void;
        addEntry(stack: Internal.EntryStack_<any>): void;
        size(): number;
        getInstance(): this;
        refilterNew(arg0: boolean, arg1: Internal.Collection_<Internal.EntryStack_<any>>): Internal.Collection<Internal.EntryStack<any>>;
    }
    type EntryRegistry_ = EntryRegistry;
    /**
    * @javaClass dev.latvian.mods.kubejs.misc.PotionBuilder
    */
    class PotionBuilder extends Internal.BuilderBase<Internal.Potion> {
        getRegistryType(): Internal.RegistryObjectBuilderTypes<Internal.Potion>;
        effect(effect: Internal.MobEffect_, duration: number, amplifier: number, ambient: boolean, visible: boolean): this;
        effect(effect: Internal.MobEffect_, duration: number, amplifier: number, ambient: boolean, visible: boolean, showIcon: boolean): this;
        effect(effect: Internal.MobEffect_, duration: number, amplifier: number, ambient: boolean, visible: boolean, showIcon: boolean, hiddenEffect: Internal.MobEffectInstance_): this;
        effect(effect: Internal.MobEffect_, duration: number): this;
        effect(effect: Internal.MobEffect_, duration: number, amplifier: number): this;
        effect(effect: Internal.MobEffect_): this;
        addEffect(effect: Internal.MobEffectInstance_): this;
        createObject(): Internal.Potion;
        get registryType(): Internal.RegistryObjectBuilderTypes<Internal.Potion>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type PotionBuilder_ = PotionBuilder;
    /**
    * @javaClass it.unimi.dsi.fastutil.doubles.DoubleIterator
    */
    interface DoubleIterator extends Internal.PrimitiveIterator$OfDouble {
        next(): number;
        skip(arg0: number): number;
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
        remove(): void;
        nextDouble(): number;
    }
    type DoubleIterator_ = DoubleIterator;
    /**
    * @javaClass dev.latvian.mods.kubejs.entity.CheckLivingEntitySpawnEventJS
    */
    class CheckLivingEntitySpawnEventJS extends Internal.LivingEntityEventJS {
        getLevel(): Internal.LevelJS;
        getBlock(): Internal.BlockContainerJS;
        getType(): Internal.MobSpawnType;
        getEntity(): Internal.EntityJS;
        canCancel(): boolean;
        readonly "x" : number;
        readonly "y" : number;
        readonly "z" : number;
        readonly "type" : Internal.MobSpawnType;
        get level(): Internal.LevelJS;
        get block(): Internal.BlockContainerJS;
        get entity(): Internal.EntityJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(entity: Internal.LivingEntity, level: Internal.Level, x: number, y: number, z: number, type: Internal.MobSpawnType);
    }
    type CheckLivingEntitySpawnEventJS_ = CheckLivingEntitySpawnEventJS;
    /**
    * @javaClass net.minecraft.class_853
    */
    class RenderChunkRegion implements Internal.BlockAndTintGetter, Internal.BiomeView, Internal.ChunkRendererRegionAccessor, Internal.RenderDataObjectConsumer, Internal.RenderAttachedBlockView {
        method_22336(): Internal.LevelLightEngine;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        getSectionsCount(): number;
        getBlockEntity<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        method_31607(): number;
        getLightEmission($$0: BlockPos_): number;
        method_24852($$0: Internal.Direction_, $$1: boolean): number;
        fabric_acceptRenderDataObjects(renderDataObjects: Internal.Long2ObjectOpenHashMap_<any>): void;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionYFromSectionIndex($$0: number): number;
        getSectionIndex($$0: number): number;
        method_8316($$0: BlockPos_): Internal.FluidState;
        getBiome(pos: BlockPos_): Internal.Holder<any>;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxLightLevel(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getSectionIndexFromSectionY($$0: number): number;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getMinSection(): number;
        canSeeSky($$0: BlockPos_): boolean;
        method_23752($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getMaxBuildHeight(): number;
        method_8320($$0: BlockPos_): Internal.BlockState;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        method_31605(): number;
        method_8321($$0: BlockPos_): Internal.BlockEntity;
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getMaxSection(): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        get minSection(): number;
        get maxSection(): number;
        get sectionsCount(): number;
        get maxLightLevel(): number;
        get maxBuildHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type RenderChunkRegion_ = RenderChunkRegion;
    /**
    * @javaClass it.unimi.dsi.fastutil.shorts.Short2CharFunction
    */
    interface Short2CharFunction extends it.unimi.dsi.fastutil.Function<number, string>, Internal.IntUnaryOperator {
        getOrDefault(arg0: any, arg1: string): string;
        getOrDefault(arg0: number, arg1: string): string;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Short2ShortFunction;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2CharFunction;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Short2IntFunction;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2CharFunction<T>;
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        put(arg0: number, arg1: string): string;
        remove(arg0: number): string;
        remove(arg0: any): string;
        defaultReturnValue(arg0: string): void;
        defaultReturnValue(): string;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Short2DoubleFunction;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        get(arg0: any): string;
        get(arg0: number): string;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Short2LongFunction;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2CharFunction;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Short2ByteFunction;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Short2FloatFunction;
        applyAsInt(arg0: number): number;
        apply(arg0: number): string;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2CharFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2CharFunction;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2CharFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2CharFunction;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2CharFunction;
    }
    type Short2CharFunction_ = ((arg0: number) => string) | Short2CharFunction;
    /**
    * @javaClass com.mojang.serialization.Encoder
    */
    interface Encoder <A> {
        encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult_<A>>): Internal.Encoder<B>;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.Encoder<B>;
        fieldOf(arg0: string): Internal.MapEncoder<A>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Encoder<A>;
        error<A>(arg0: string): Internal.Encoder<A>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: A): Internal.DataResult<T>;
        empty<A>(): Internal.MapEncoder<A>;
    }
    type Encoder_<A> = Encoder<A>;
    /**
    * @javaClass net.minecraft.class_299
    */
    class ClientRecipeBook extends Internal.RecipeBook {
        getCollection($$0: Internal.RecipeBookCategories_): Internal.List<Internal.RecipeCollection>;
        setupCollections($$0: Internal.Iterable_<Internal.Recipe_<any>>): void;
        getCollections(): Internal.List<Internal.RecipeCollection>;
        get collections(): Internal.List<Internal.RecipeCollection>;
        set upCollections($$0: Internal.Iterable_<Internal.Recipe_<any>>);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ClientRecipeBook_ = ClientRecipeBook;
    /**
    * @javaClass net.minecraft.class_6121
    */
    class ConstantHeight extends Internal.HeightProvider {
        getValue(): Internal.VerticalAnchor;
        method_35388(): Internal.HeightProviderType<any>;
        static of($$0: Internal.VerticalAnchor_): Internal.ConstantHeight;
        toString(): string;
        method_35391($$0: Internal.Random_, $$1: Internal.WorldGenerationContext_): number;
        static readonly "ZERO" : Internal.ConstantHeight;
        static readonly "CODEC" : Internal.Codec<Internal.ConstantHeight>;
        get value(): Internal.VerticalAnchor;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ConstantHeight_ = ConstantHeight;
    /**
    * Fired when a block is broken by player. This will not be fired by other means, like TNT.
    *
    * On fabric, the experience returned is always `null`.
    * @javaClass dev.latvian.mods.kubejs.block.BlockBreakEventJS
    */
    class BlockBreakEventJS extends Internal.PlayerEventJS {
        getBlock(): Internal.BlockContainerJS;
        getXp(): number;
        getEntity(): Internal.EntityJS;
        setXp(xp: number): void;
        canCancel(): boolean;
        get xp(): number;
        get block(): Internal.BlockContainerJS;
        get entity(): Internal.EntityJS;
        set xp(xp: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(entity: Internal.ServerPlayer, level: Internal.Level, pos: BlockPos, state: Internal.BlockState, xp: any);
    }
    /**
    * Fired when a block is broken by player. This will not be fired by other means, like TNT.
    *
    * On fabric, the experience returned is always `null`.
    */
    type BlockBreakEventJS_ = BlockBreakEventJS;
    /**
    * @javaClass xaero.common.gui.GuiSettings
    */
    abstract class GuiSettings extends Internal.ScreenBase implements Internal.WidgetScreen {
        method_25406($$0: number, $$1: number, $$2: number): boolean;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        method_25407($$0: boolean): boolean;
        getIndex(child: Internal.GuiEventListener_): number;
        setInitialFocus($$0: Internal.GuiEventListener_): void;
        method_25400(c: string, i: number): boolean;
        addButtonVisible(button: Internal.AbstractWidget_): void;
        getEntriesCopy(): any[];
        method_25402(p_mouseClicked_1_: number, p_mouseClicked_3_: number, p_mouseClicked_5_: number): boolean;
        restoreFocus(index: number): void;
        method_25401($$0: number, $$1: number, $$2: number): boolean;
        method_25426(): void;
        method_25404(par1: number, par2: number, par3: number): boolean;
        method_25403($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        mouseMoved($$0: number, $$1: number): void;
        getScreen<S>(): S;
        drawCenteredLabel(matrices: Internal.PoseStack_, text: net.minecraft.network.chat.Component_, x: number, y: number, color: number, zIndex: number): void;
        getAllBounds(): Internal.Set<Internal.Bounds>;
        drawTextBlock(matrices: Internal.PoseStack_, text: Internal.FormattedText_, x: number, y: number, maxWidth: number, color: number): void;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        method_16803($$0: number, $$1: number, $$2: number): boolean;
        method_25394(matrixStack: Internal.PoseStack_, par1: number, par2: number, par3: number): void;
        method_25393(): void;
        method_25395(guiEventListener: Internal.GuiEventListener_): void;
        getFont(): net.minecraft.client.gui.Font;
        drawLabel(matrices: Internal.PoseStack_, text: net.minecraft.network.chat.Component_, x: number, y: number, color: number, zIndex: number): void;
        getContentBounds(): Internal.Bounds;
        get allBounds(): Internal.Set<Internal.Bounds>;
        get entriesCopy(): any[];
        get screen(): S;
        get contentBounds(): Internal.Bounds;
        get font(): net.minecraft.client.gui.Font;
        set initialFocus($$0: Internal.GuiEventListener_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(modMain: Internal.AXaeroMinimap, title: net.minecraft.network.chat.Component, backScreen: Internal.Screen, escScreen: Internal.Screen);
    }
    type GuiSettings_ = GuiSettings;
    /**
    * @javaClass net.minecraft.class_1044
    */
    abstract class AbstractTexture implements Internal.AutoCloseable, Internal.AbstractTextureExtensions, Internal.ExtendedTexture {
        restoreLastBlurMipmap(): void;
        setBlurMipmap(blur: boolean, mipmap: boolean): void;
        bind(): void;
        load(arg0: Internal.ResourceManager_): void;
        setFilterSave(bilinear: boolean, mipmap: boolean): void;
        releaseId(): void;
        restoreLastFilter(): void;
        reset($$0: Internal.TextureManager_, $$1: Internal.ResourceManager_, $$2: ResourceLocation_, $$3: Internal.Executor_): void;
        getId(): number;
        close(): void;
        setFilter($$0: boolean, $$1: boolean): void;
        static readonly "NOT_ASSIGNED" : -1;
        get id(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AbstractTexture_ = AbstractTexture;
    /**
    * @javaClass ladysnake.satin.mixin.client.render.RenderLayerMixin$MultiPhaseParametersAccessor
    */
    interface RenderLayerMixin$MultiPhaseParametersAccessor {
        getShader(): Internal.RenderStateShard$ShaderStateShard;
        getTarget(): Internal.RenderStateShard$OutputStateShard;
        getDepthTest(): Internal.RenderStateShard$DepthTestStateShard;
        getLayering(): Internal.RenderStateShard$LayeringStateShard;
        getLineWidth(): Internal.RenderStateShard$LineStateShard;
        getOutlineMode(): Internal.RenderType$OutlineProperty;
        getLightmap(): Internal.RenderStateShard$LightmapStateShard;
        getCull(): Internal.RenderStateShard$CullStateShard;
        getTexturing(): Internal.RenderStateShard$TexturingStateShard;
        getOverlay(): Internal.RenderStateShard$OverlayStateShard;
        getTexture(): Internal.RenderStateShard$EmptyTextureStateShard;
        getTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        getWriteMaskState(): Internal.RenderStateShard$WriteMaskStateShard;
    }
    type RenderLayerMixin$MultiPhaseParametersAccessor_ = RenderLayerMixin$MultiPhaseParametersAccessor;
    /**
    * @javaClass net.minecraft.class_2612
    */
    class ClientboundAddPaintingPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getDirection(): Internal.Direction;
        getUUID(): Internal.UUID;
        getMotive(): Internal.Motive;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getPos(): BlockPos;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getId(): number;
        isSkippable(): boolean;
        get motive(): Internal.Motive;
        get pos(): BlockPos;
        get id(): number;
        get skippable(): boolean;
        get uUID(): Internal.UUID;
        get direction(): Internal.Direction;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Painting);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundAddPaintingPacket_ = ClientboundAddPaintingPacket;
    /**
    * @javaClass net.minecraft.class_322
    */
    interface BlockColor {
        getColor(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: number): number;
    }
    type BlockColor_ = BlockColor;
    /**
    * @javaClass net.minecraft.class_274
    */
    class ObjectiveCriteria {
        getName(): string;
        isReadOnly(): boolean;
        static getCustomCriteriaNames(): Internal.Set<string>;
        static byName($$0: string): Internal.Optional<Internal.ObjectiveCriteria>;
        getDefaultRenderType(): Internal.ObjectiveCriteria$RenderType;
        static readonly "DEATH_COUNT" : Internal.ObjectiveCriteria;
        static readonly "ARMOR" : Internal.ObjectiveCriteria;
        static readonly "TRIGGER" : Internal.ObjectiveCriteria;
        static readonly "KILL_COUNT_ALL" : Internal.ObjectiveCriteria;
        static readonly "AIR" : Internal.ObjectiveCriteria;
        static readonly "LEVEL" : Internal.ObjectiveCriteria;
        static readonly "DUMMY" : Internal.ObjectiveCriteria;
        static readonly "EXPERIENCE" : Internal.ObjectiveCriteria;
        static readonly "HEALTH" : Internal.ObjectiveCriteria;
        static readonly "KILL_COUNT_PLAYERS" : Internal.ObjectiveCriteria;
        static readonly "TEAM_KILL" : Internal.ObjectiveCriteria[];
        static readonly "KILLED_BY_TEAM" : Internal.ObjectiveCriteria[];
        static readonly "FOOD" : Internal.ObjectiveCriteria;
        get defaultRenderType(): Internal.ObjectiveCriteria$RenderType;
        get name(): string;
        get readOnly(): boolean;
        get customCriteriaNames(): Internal.Set<string>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ObjectiveCriteria_ = ObjectiveCriteria;
    /**
    * @javaClass net.minecraft.class_3824
    */
    class RandomBlockMatchTest extends Internal.RuleTest {
        method_16768($$0: Internal.BlockState_, $$1: Internal.Random_): boolean;
        static readonly "CODEC" : Internal.Codec<Internal.RandomBlockMatchTest>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Block, $$1: number);
    }
    type RandomBlockMatchTest_ = RandomBlockMatchTest;
    /**
    * @javaClass net.minecraft.class_4066
    */
    class ParticleStatus extends Internal.Enum<Internal.ParticleStatus> {
        getKey(): string;
        static valueOf($$0: string): Internal.ParticleStatus;
        static values(): Internal.ParticleStatus[];
        getId(): number;
        static byId($$0: number): Internal.ParticleStatus;
        static readonly "ALL" : Internal.ParticleStatus;
        static readonly "DECREASED" : Internal.ParticleStatus;
        static readonly "MINIMAL" : Internal.ParticleStatus;
        get id(): number;
        get key(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ParticleStatus_ = "all" | "minimal" | "decreased" | ParticleStatus;
    /**
    * @javaClass net.minecraft.class_3565
    */
    interface LightEventListener {
        updateSectionStatus($$0: BlockPos_, $$1: boolean): void;
        updateSectionStatus(arg0: Internal.SectionPos_, arg1: boolean): void;
        runUpdates(arg0: number, arg1: boolean, arg2: boolean): number;
        enableLightSources(arg0: Internal.ChunkPos_, arg1: boolean): void;
        checkBlock(arg0: BlockPos_): void;
        onBlockEmissionIncrease(arg0: BlockPos_, arg1: number): void;
        hasLightWork(): boolean;
    }
    type LightEventListener_ = LightEventListener;
    /**
    * @javaClass net.minecraft.class_868
    */
    class PathfindingRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        static renderPath($$0: net.minecraft.world.level.pathfinder.Path_, $$1: number, $$2: boolean, $$3: boolean, $$4: number, $$5: number, $$6: number): void;
        static renderPathLine($$0: net.minecraft.world.level.pathfinder.Path_, $$1: number, $$2: number, $$3: number): void;
        method_23109($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        clear(): void;
        addPath($$0: number, $$1: net.minecraft.world.level.pathfinder.Path_, $$2: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type PathfindingRenderer_ = PathfindingRenderer;
    /**
    * @javaClass net.minecraft.class_777
    */
    class BakedQuad implements Internal.BakedQuadAccess, Internal.ModelQuadView {
        getNormal(idx: number): number;
        getLight(idx: number): number;
        getTexV(idx: number): number;
        getTexU(idx: number): number;
        getColorIndex(): number;
        getTintIndex(): number;
        getDirection(): Internal.Direction;
        getColor(idx: number): number;
        isShade(): boolean;
        getSprite(): Internal.TextureAtlasSprite;
        getX(idx: number): number;
        getY(idx: number): number;
        getZ(idx: number): number;
        getVertices(): number[];
        getFlags(): number;
        isTinted(): boolean;
        get tintIndex(): number;
        get vertices(): number[];
        get tinted(): boolean;
        get shade(): boolean;
        get sprite(): Internal.TextureAtlasSprite;
        get flags(): number;
        get colorIndex(): number;
        get direction(): Internal.Direction;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number[], $$1: number, $$2: Internal.Direction, $$3: Internal.TextureAtlasSprite, $$4: boolean);
    }
    type BakedQuad_ = BakedQuad;
    /**
    * @javaClass net.minecraft.class_4597$class_4598
    */
    class MultiBufferSource$BufferSource implements Internal.MultiBufferSource, Internal.MemoryTrackingBuffer, Internal.AccessorMultiBufferSource {
        getBuffer($$0: Internal.RenderType_): Internal.VertexConsumer;
        endLastBatch(): void;
        getUsedSize(): number;
        freeAndDeleteBuffer(): void;
        endBatch($$0: Internal.RenderType_): void;
        endBatch(): void;
        getAllocatedSize(): number;
        get allocatedSize(): number;
        get usedSize(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MultiBufferSource$BufferSource_ = MultiBufferSource$BufferSource;
    /**
    * @javaClass de.cristelknight999.unstructured.mixin.StructureFeatureAccessor
    */
    interface StructureFeatureAccessor {
    }
    type StructureFeatureAccessor_ = StructureFeatureAccessor;
    /**
    * @javaClass net.minecraft.class_6686$class_6692
    */
    interface SurfaceRules$Condition {
        test(): boolean;
    }
    type SurfaceRules$Condition_ = SurfaceRules$Condition;
    /**
    * @javaClass com.jozufozu.flywheel.util.box.ImmutableBox
    */
    interface ImmutableBox {
        hasPowerOf2Sides(): boolean;
        intersect(other: Internal.ImmutableBox_): Internal.GridAlignedBB;
        intersects(other: Internal.ImmutableBox_): boolean;
        intersects(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): boolean;
        getMaxX(): number;
        forEachContained(func: Internal.CoordinateConsumer_): void;
        getMaxY(): number;
        union(other: Internal.ImmutableBox_): this;
        getMaxZ(): number;
        empty(): boolean;
        volume(): number;
        sizeX(): number;
        contains(x: number, y: number, z: number): boolean;
        contains(other: Internal.ImmutableBox_): boolean;
        isContainedBy(other: Internal.GridAlignedBB_): boolean;
        toAABB(): Internal.AABB;
        copy(): Internal.GridAlignedBB;
        getMinZ(): number;
        sizeY(): number;
        getMinX(): number;
        sizeZ(): number;
        getMinY(): number;
        sameAs(other: Internal.ImmutableBox_): boolean;
        sameAs(other: Internal.AABB_): boolean;
        sameAs(other: Internal.ImmutableBox_, margin: number): boolean;
    }
    type ImmutableBox_ = ImmutableBox;
    /**
    * @javaClass com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor
    */
    interface BoundingBoxAccessor {
        setMinY(arg0: number): void;
        setMinX(arg0: number): void;
        setMaxZ(arg0: number): void;
        setMinZ(arg0: number): void;
        setMaxY(arg0: number): void;
        setMaxX(arg0: number): void;
    }
    type BoundingBoxAccessor_ = BoundingBoxAccessor;
    /**
    * @javaClass net.minecraft.class_776
    */
    class BlockRenderDispatcher implements Internal.ResourceManagerReloadListener, io.github.fabricators_of_create.porting_lib.mixin.client.accessor.BlockRenderDispatcherAccessor, Internal.IdentifiableResourceReloadListener, Internal.BlockRenderDispatcherAccessor {
        method_14491($$0: Internal.ResourceManager_): void;
        renderSingleBlock($$0: Internal.BlockState_, $$1: Internal.PoseStack_, $$2: Internal.MultiBufferSource_, $$3: number, $$4: number): void;
        getName(): string;
        renderBreakingTexture($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.BlockAndTintGetter_, $$3: Internal.PoseStack_, $$4: Internal.VertexConsumer_): void;
        getFabricId(): ResourceLocation;
        getBlockModelShaper(): Internal.BlockModelShaper;
        renderLiquid($$0: BlockPos_, $$1: Internal.BlockAndTintGetter_, $$2: Internal.VertexConsumer_, $$3: Internal.BlockState_, $$4: Internal.FluidState_): boolean;
        getModelRenderer(): Internal.ModelBlockRenderer;
        getBlockModel($$0: Internal.BlockState_): Internal.BakedModel;
        method_25931($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        renderBatched($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.BlockAndTintGetter_, $$3: Internal.PoseStack_, $$4: Internal.VertexConsumer_, $$5: boolean, $$6: Internal.Random_): boolean;
        getFabricDependencies(): Internal.Collection<any>;
        get fabricDependencies(): Internal.Collection<any>;
        get blockModelShaper(): Internal.BlockModelShaper;
        get fabricId(): ResourceLocation;
        get modelRenderer(): Internal.ModelBlockRenderer;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockModelShaper, $$1: Internal.BlockEntityWithoutLevelRenderer, $$2: Internal.BlockColors);
    }
    type BlockRenderDispatcher_ = BlockRenderDispatcher;
    /**
    * @javaClass java.time.chrono.ChronoLocalDate
    */
    interface ChronoLocalDate extends Internal.Temporal, Internal.TemporalAdjuster, Internal.Comparable<Internal.ChronoLocalDate> {
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        minus(arg0: Internal.TemporalAmount_): this;
        toEpochDay(): number;
        isEqual(arg0: Internal.ChronoLocalDate_): boolean;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        compareTo(arg0: Internal.ChronoLocalDate_): number;
        lengthOfYear(): number;
        lengthOfMonth(): number;
        getEra(): Internal.Era;
        hashCode(): number;
        get(arg0: Internal.TemporalField_): number;
        from(arg0: Internal.TemporalAccessor_): this;
        getChronology(): Internal.Chronology;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        format(arg0: Internal.DateTimeFormatter_): string;
        isLeapYear(): boolean;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        isSupported(arg0: Internal.TemporalField_): boolean;
        isBefore(arg0: Internal.ChronoLocalDate_): boolean;
        plus(arg0: number, arg1: Internal.TemporalUnit_): this;
        plus(arg0: Internal.TemporalAmount_): this;
        atTime(arg0: Internal.LocalTime_): Internal.ChronoLocalDateTime<any>;
        with(arg0: Internal.TemporalAdjuster_): this;
        with(arg0: Internal.TemporalField_, arg1: number): this;
        equals(arg0: any): boolean;
        timeLineOrder(): Internal.Comparator<Internal.ChronoLocalDate>;
        until(arg0: Internal.ChronoLocalDate_): Internal.ChronoPeriod;
        until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        toString(): string;
        isAfter(arg0: Internal.ChronoLocalDate_): boolean;
    }
    type ChronoLocalDate_ = ChronoLocalDate;
    /**
    * @javaClass net.minecraft.class_1270
    */
    interface MenuConstructor {
        createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
    }
    type MenuConstructor_ = ((arg0: number, arg1: Internal.Inventory, arg2: Internal.Player) => Internal.AbstractContainerMenu) | MenuConstructor;
    /**
    * @javaClass net.minecraft.class_4185$class_5316
    */
    interface Button$OnTooltip {
        narrateTooltip($$0: Internal.Consumer_<net.minecraft.network.chat.Component_>): void;
        onTooltip(arg0: Internal.Button_, arg1: Internal.PoseStack_, arg2: number, arg3: number): void;
    }
    type Button$OnTooltip_ = Button$OnTooltip;
    /**
    * @javaClass java.lang.module.ResolvedModule
    */
    class ResolvedModule {
        reference(): Internal.ModuleReference;
        configuration(): Internal.Configuration;
        hashCode(): number;
        equals(arg0: any): boolean;
        reads(): Internal.Set<Internal.ResolvedModule>;
        name(): string;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ResolvedModule_ = ResolvedModule;
    /**
    * @javaClass net.darkhax.bookshelf.mixin.inventory.AccessorCraftingContainer
    */
    interface AccessorCraftingContainer {
        bookshelf$getMenu(): Internal.AbstractContainerMenu;
    }
    type AccessorCraftingContainer_ = AccessorCraftingContainer;
    /**
    * @javaClass net.minecraft.class_6544$class_6546
    */
    class Climate$Parameter extends Internal.Record {
        min(): number;
        distance($$0: number): number;
        distance($$0: Internal.Climate$Parameter_): number;
        max(): number;
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        static point($$0: number): Internal.Climate$Parameter;
        static span($$0: Internal.Climate$Parameter_, $$1: Internal.Climate$Parameter_): Internal.Climate$Parameter;
        span($$0: Internal.Climate$Parameter_): this;
        static span($$0: number, $$1: number): Internal.Climate$Parameter;
        static readonly "CODEC" : Internal.Codec<Internal.Climate$Parameter>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number);
    }
    type Climate$Parameter_ = Climate$Parameter;
    /**
    * @javaClass com.google.common.collect.AbstractMultimap
    */
    abstract class AbstractMultimap <K, V> implements Internal.Multimap<K, V> {
        containsEntry(arg0: any, arg1: any): boolean;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        asMap(): Internal.Map<K, Internal.Collection<V>>;
        keys(): Internal.Multiset<K>;
        values(): Internal.Collection<V>;
        isEmpty(): boolean;
        replaceValues(arg0: K, arg1: Internal.Iterable_<V>): Internal.Collection<V>;
        containsValue(arg0: any): boolean;
        put(arg0: K, arg1: V): boolean;
        remove(arg0: any, arg1: any): boolean;
        entries(): Internal.Collection<Internal.Map$Entry<K, V>>;
        hashCode(): number;
        putAll(arg0: K, arg1: Internal.Iterable_<V>): boolean;
        putAll(arg0: Internal.Multimap_<K, V>): boolean;
        equals(arg0: any): boolean;
        toString(): string;
        keySet(): Internal.Set<K>;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractMultimap_<K, V> = AbstractMultimap<K, V>;
    /**
    * @javaClass net.fabricmc.fabric.mixin.networking.accessor.EntityTrackerAccessor
    */
    interface EntityTrackerAccessor {
        getPlayersTracking(): Internal.Set<Internal.ServerPlayerConnection>;
    }
    type EntityTrackerAccessor_ = EntityTrackerAccessor;
    /**
    * @javaClass com.simibubi.create.foundation.gui.widget.ScrollInput
    */
    class ScrollInput extends Internal.AbstractSimiWidget {
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        withShiftStep(step: number): this;
        onChanged(): void;
        standardStep(): Internal.Function<Internal.ScrollValueBehaviour$StepContext, number>;
        writingTo(label: Internal.Label_): this;
        format(formatter: Internal.Function_<number, net.minecraft.network.chat.Component_>): this;
        method_25401(mouseX: number, mouseY: number, delta: number): boolean;
        withRange(min: number, max: number): this;
        getState(): number;
        calling(onScroll: Internal.Consumer_<number>): this;
        setState(state: number): this;
        charTyped($$0: string, $$1: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        removeCallback(): this;
        mouseMoved($$0: number, $$1: number): void;
        titled(title: Internal.MutableComponent_): this;
        inverted(): this;
        withStepFunction(step: Internal.Function_<Internal.ScrollValueBehaviour$StepContext_, number>): this;
        get state(): number;
        set state(state: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(xIn: number, yIn: number, widthIn: number, heightIn: number);
    }
    type ScrollInput_ = ScrollInput;
    /**
    * @javaClass java.awt.JobAttributes$DialogType
    */
    class JobAttributes$DialogType extends Internal.AttributeValue {
        static readonly "NATIVE" : Internal.JobAttributes$DialogType;
        static readonly "COMMON" : Internal.JobAttributes$DialogType;
        static readonly "NONE" : Internal.JobAttributes$DialogType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type JobAttributes$DialogType_ = JobAttributes$DialogType;
    /**
    * Fired by different tag when the server:
    * - loads
    * - ticks
    * - unloads
    * @javaClass dev.latvian.mods.kubejs.server.ServerEventJS
    */
    class ServerEventJS extends Internal.EventJS {
        getServer(): Internal.ServerJS;
        get server(): Internal.ServerJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    /**
    * Fired by different tag when the server:
    * - loads
    * - ticks
    * - unloads
    */
    type ServerEventJS_ = ServerEventJS;
    /**
    * @javaClass java.awt.im.InputMethodRequests
    */
    interface InputMethodRequests {
        getCommittedTextLength(): number;
        getSelectedText(arg0: Internal.AttributedCharacterIterator$Attribute_[]): Internal.AttributedCharacterIterator;
        getInsertPositionOffset(): number;
        getCommittedText(arg0: number, arg1: number, arg2: Internal.AttributedCharacterIterator$Attribute_[]): Internal.AttributedCharacterIterator;
        getLocationOffset(arg0: number, arg1: number): Internal.TextHitInfo;
        cancelLatestCommittedText(arg0: Internal.AttributedCharacterIterator$Attribute_[]): Internal.AttributedCharacterIterator;
        getTextLocation(arg0: Internal.TextHitInfo_): Internal.Rectangle;
    }
    type InputMethodRequests_ = InputMethodRequests;
    /**
    * @javaClass net.minecraft.class_5321
    */
    class ResourceKey <T> implements Internal.RegistryKeyAccess, Internal.SpecialEquality {
        static elementKey<T>($$0: Internal.ResourceKey_<Internal.Registry_<T>>): Internal.Function<ResourceLocation, Internal.ResourceKey<T>>;
        registry(): ResourceLocation;
        static codec<T>($$0: Internal.ResourceKey_<Internal.Registry_<T>>): Internal.Codec<Internal.ResourceKey<T>>;
        rhino$getPath(): string;
        cast<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Optional<Internal.ResourceKey<E>>;
        isFor($$0: Internal.ResourceKey_<Internal.Registry_<any>>): boolean;
        static createRegistryKey<T>($$0: ResourceLocation_): Internal.ResourceKey<Internal.Registry<T>>;
        rhino$getNamespace(): string;
        static create<T>($$0: Internal.ResourceKey_<Internal.Registry_<T>>, $$1: ResourceLocation_): Internal.ResourceKey<T>;
        location(): ResourceLocation;
        toString(): string;
        specialEquals(o: any, shallow: boolean): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ResourceKey_<T> = ResourceKey<T>;
    /**
    * @javaClass net.fabricmc.fabric.mixin.object.builder.VillagerProfessionAccessor
    */
    interface VillagerProfessionAccessor {
    }
    type VillagerProfessionAccessor_ = VillagerProfessionAccessor;
    /**
    * @javaClass net.minecraft.class_2792
    */
    interface ServerGamePacketListener extends Internal.ServerPacketListener {
        handleAnimate(arg0: Internal.ServerboundSwingPacket_): void;
        handleInteract(arg0: Internal.ServerboundInteractPacket_): void;
        method_40065(): boolean;
        handleSetCarriedItem(arg0: Internal.ServerboundSetCarriedItemPacket_): void;
        handleBlockEntityTagQuery(arg0: Internal.ServerboundBlockEntityTagQuery_): void;
        handleRecipeBookSeenRecipePacket(arg0: Internal.ServerboundRecipeBookSeenRecipePacket_): void;
        handlePlayerAbilities(arg0: Internal.ServerboundPlayerAbilitiesPacket_): void;
        handleResourcePackResponse(arg0: Internal.ServerboundResourcePackPacket_): void;
        handleMovePlayer(arg0: Internal.ServerboundMovePlayerPacket_): void;
        handleSetCreativeModeSlot(arg0: Internal.ServerboundSetCreativeModeSlotPacket_): void;
        handlePlayerCommand(arg0: Internal.ServerboundPlayerCommandPacket_): void;
        handleLockDifficulty(arg0: Internal.ServerboundLockDifficultyPacket_): void;
        handleChat(arg0: Internal.ServerboundChatPacket_): void;
        handleSeenAdvancements(arg0: Internal.ServerboundSeenAdvancementsPacket_): void;
        handleTeleportToEntityPacket(arg0: Internal.ServerboundTeleportToEntityPacket_): void;
        handleContainerClose(arg0: Internal.ServerboundContainerClosePacket_): void;
        handleCustomCommandSuggestions(arg0: Internal.ServerboundCommandSuggestionPacket_): void;
        handlePlayerInput(arg0: Internal.ServerboundPlayerInputPacket_): void;
        handleJigsawGenerate(arg0: Internal.ServerboundJigsawGeneratePacket_): void;
        handleSetCommandBlock(arg0: Internal.ServerboundSetCommandBlockPacket_): void;
        handleEntityTagQuery(arg0: Internal.ServerboundEntityTagQuery_): void;
        handlePlayerAction(arg0: Internal.ServerboundPlayerActionPacket_): void;
        handleUseItemOn(arg0: Internal.ServerboundUseItemOnPacket_): void;
        handleContainerButtonClick(arg0: Internal.ServerboundContainerButtonClickPacket_): void;
        handlePaddleBoat(arg0: Internal.ServerboundPaddleBoatPacket_): void;
        handleClientCommand(arg0: Internal.ServerboundClientCommandPacket_): void;
        handleAcceptTeleportPacket(arg0: Internal.ServerboundAcceptTeleportationPacket_): void;
        handleContainerClick(arg0: Internal.ServerboundContainerClickPacket_): void;
        handleUseItem(arg0: Internal.ServerboundUseItemPacket_): void;
        handleClientInformation(arg0: Internal.ServerboundClientInformationPacket_): void;
        handlePlaceRecipe(arg0: Internal.ServerboundPlaceRecipePacket_): void;
        handleSetJigsawBlock(arg0: Internal.ServerboundSetJigsawBlockPacket_): void;
        handleSetBeaconPacket(arg0: Internal.ServerboundSetBeaconPacket_): void;
        handleEditBook(arg0: Internal.ServerboundEditBookPacket_): void;
        handleRecipeBookChangeSettingsPacket(arg0: Internal.ServerboundRecipeBookChangeSettingsPacket_): void;
        handleKeepAlive(arg0: Internal.ServerboundKeepAlivePacket_): void;
        handleCustomPayload(arg0: Internal.ServerboundCustomPayloadPacket_): void;
        handleSelectTrade(arg0: Internal.ServerboundSelectTradePacket_): void;
        handlePickItem(arg0: Internal.ServerboundPickItemPacket_): void;
        handlePong(arg0: Internal.ServerboundPongPacket_): void;
        handleSignUpdate(arg0: Internal.ServerboundSignUpdatePacket_): void;
        handleSetCommandMinecart(arg0: Internal.ServerboundSetCommandMinecartPacket_): void;
        handleChangeDifficulty(arg0: Internal.ServerboundChangeDifficultyPacket_): void;
        handleSetStructureBlock(arg0: Internal.ServerboundSetStructureBlockPacket_): void;
        handleRenameItem(arg0: Internal.ServerboundRenameItemPacket_): void;
        handleMoveVehicle(arg0: Internal.ServerboundMoveVehiclePacket_): void;
    }
    type ServerGamePacketListener_ = ServerGamePacketListener;
    /**
    * @javaClass net.minecraft.class_4647$class_5208
    */
    class FoliagePlacer$FoliageAttachment {
        radiusOffset(): number;
        doubleTrunk(): boolean;
        pos(): BlockPos;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: number, $$2: boolean);
    }
    type FoliagePlacer$FoliageAttachment_ = FoliagePlacer$FoliageAttachment;
    /**
    * @javaClass dev.latvian.mods.rhino.ContextFactory$Listener
    */
    interface ContextFactory$Listener {
        contextReleased(arg0: Internal.Context_): void;
        contextCreated(arg0: Internal.Context_): void;
    }
    type ContextFactory$Listener_ = ContextFactory$Listener;
    /**
    * @javaClass net.minecraft.class_1683
    */
    class ThrownExperienceBottle extends Internal.ThrowableItemProjectile {
        canRiderInteract(): boolean;
        getStepHeight(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Level, $$1: number, $$2: number, $$3: number);
        constructor($$0: Internal.Level, $$1: Internal.LivingEntity);
        constructor($$0: Internal.EntityType<Internal.ThrownExperienceBottle>, $$1: Internal.Level);
    }
    type ThrownExperienceBottle_ = ThrownExperienceBottle;
    /**
    * @javaClass net.minecraft.class_2861
    */
    class RegionFile implements Internal.AutoCloseable {
        flush(): void;
        hasChunk($$0: Internal.ChunkPos_): boolean;
        clear($$0: Internal.ChunkPos_): void;
        close(): void;
        getChunkDataOutputStream($$0: Internal.ChunkPos_): Internal.DataOutputStream;
        getChunkDataInputStream($$0: Internal.ChunkPos_): Internal.DataInputStream;
        doesChunkExist($$0: Internal.ChunkPos_): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Path, $$1: Internal.Path, $$2: boolean);
        constructor($$0: Internal.Path, $$1: Internal.Path, $$2: any, $$3: boolean);
    }
    type RegionFile_ = RegionFile;
    /**
    * @javaClass net.minecraft.class_4565
    */
    class CommandStorage {
        set($$0: ResourceLocation_, $$1: Internal.CompoundTag_): void;
        keys(): Internal.Stream<ResourceLocation>;
        get($$0: ResourceLocation_): Internal.CompoundTag;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.DimensionDataStorage);
    }
    type CommandStorage_ = CommandStorage;
    /**
    * @javaClass corgitaco.mobifier.common.player.IsInsideStructureTracker
    */
    class IsInsideStructureTracker {
        setInside(world: Internal.Level_, entity: Internal.Entity_, isInside: Internal.IsInsideStructureTracker$IsInside_): void;
        getTracker(): Internal.IsInsideStructureTracker$IsInside;
        get tracker(): Internal.IsInsideStructureTracker$IsInside;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type IsInsideStructureTracker_ = IsInsideStructureTracker;
    /**
    * @javaClass org.popcraft.chunky.mixin.ServerChunkManagerMixin
    */
    interface ServerChunkManagerMixin {
        tick(): boolean;
    }
    type ServerChunkManagerMixin_ = ServerChunkManagerMixin;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.TransformationExtensions
    */
    interface TransformationExtensions {
        getNormalMatrix(): Internal.Matrix3f;
        blockCornerToCenter(): Internal.Transformation;
        applyOrigin(origin: Internal.Vector3f_): Internal.Transformation;
        rotateTransform(facing: Internal.Direction_): Internal.Direction;
        isIdentity(): boolean;
        transformPosition(position: Internal.Vector4f_): void;
        transformNormal(normal: Internal.Vector3f_): void;
        push(stack: Internal.PoseStack_): void;
        blockCenterToCorner(): Internal.Transformation;
    }
    type TransformationExtensions_ = TransformationExtensions;
    /**
    * @javaClass io.netty.channel.ChannelMetadata
    */
    class ChannelMetadata {
        hasDisconnect(): boolean;
        defaultMaxMessagesPerRead(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: boolean);
        constructor(arg0: boolean, arg1: number);
    }
    type ChannelMetadata_ = ChannelMetadata;
    /**
    * @javaClass net.minecraft.class_2481
    */
    class ByteTag extends Internal.NumericTag {
        method_39850($$0: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        static valueOf($$0: number): Internal.ByteTag;
        static valueOf($$0: boolean): Internal.ByteTag;
        getAsString(): string;
        method_23258(): Internal.TagType<Internal.ByteTag>;
        method_32289($$0: Internal.TagVisitor_): void;
        method_10699(): number;
        method_10698(): number;
        method_10701(): number;
        method_10711(): number;
        method_10700(): number;
        method_10713($$0: Internal.DataOutput_): void;
        method_10702(): Internal.Number;
        hashCode(): number;
        equals($$0: any): boolean;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        copy(): this;
        method_10697(): number;
        method_10696(): number;
        static readonly "ZERO" : Internal.ByteTag;
        static readonly "ONE" : Internal.ByteTag;
        static readonly "TYPE" : Internal.TagType<Internal.ByteTag>;
        get asString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ByteTag_ = ByteTag;
    /**
    * @javaClass net.minecraft.class_1427
    */
    abstract class AbstractGolem extends Internal.PathfinderMob {
        canRiderInteract(): boolean;
        method_5747($$0: number, $$1: number, $$2: Internal.DamageSource_): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getStepHeight(): number;
        method_5970(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_5974($$0: number): boolean;
        asKJS(): Internal.EntityJS;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractGolem_ = AbstractGolem;
    /**
    * @javaClass java.nio.channels.spi.AbstractInterruptibleChannel
    */
    abstract class AbstractInterruptibleChannel implements Internal.Channel, Internal.InterruptibleChannel {
        isOpen(): boolean;
        close(): void;
        get open(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractInterruptibleChannel_ = AbstractInterruptibleChannel;
    /**
    * @javaClass net.minecraft.class_2734
    */
    class ClientboundSetCameraPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getEntity($$0: Internal.Level_): Internal.Entity;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Entity);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundSetCameraPacket_ = ClientboundSetCameraPacket;
    /**
    * @javaClass net.minecraft.class_1940
    */
    class LevelSettings {
        getDataPackConfig(): Internal.DataPackConfig;
        gameRules(): Internal.GameRules;
        difficulty(): Internal.Difficulty;
        gameType(): Internal.GameType;
        hardcore(): boolean;
        withDataPackConfig($$0: Internal.DataPackConfig_): this;
        withDifficulty($$0: Internal.Difficulty_): this;
        levelName(): string;
        copy(): this;
        allowCommands(): boolean;
        static parse($$0: Internal.Dynamic_<any>, $$1: Internal.DataPackConfig_): Internal.LevelSettings;
        withGameType($$0: Internal.GameType_): this;
        get dataPackConfig(): Internal.DataPackConfig;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: Internal.GameType, $$2: boolean, $$3: Internal.Difficulty, $$4: boolean, $$5: Internal.GameRules, $$6: Internal.DataPackConfig);
    }
    type LevelSettings_ = LevelSettings;
    /**
    * @javaClass java.util.SortedMap
    */
    interface SortedMap <K, V> extends Internal.Map<K, V> {
        getOrDefault(arg0: any, arg1: V): V;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        subMap(arg0: K, arg1: K): Internal.SortedMap<K, V>;
        values(): Internal.Collection<V>;
        replace(arg0: K, arg1: V): V;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        remove(arg0: any, arg1: any): boolean;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        comparator(): Internal.Comparator<K>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        firstKey(): K;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        lastKey(): K;
        headMap(arg0: K): Internal.SortedMap<K, V>;
        putIfAbsent(arg0: K, arg1: V): V;
        keySet(): Internal.Set<K>;
        tailMap(arg0: K): Internal.SortedMap<K, V>;
    }
    type SortedMap_<K, V> = SortedMap<K, V>;
    /**
    * @javaClass java.awt.dnd.DragSourceMotionListener
    */
    interface DragSourceMotionListener extends Internal.EventListener {
        dragMouseMoved(arg0: Internal.DragSourceDragEvent_): void;
    }
    type DragSourceMotionListener_ = DragSourceMotionListener;
    /**
    * @javaClass net.minecraft.class_82
    */
    interface LootPoolEntry {
        getWeight(arg0: number): number;
        createItemStack(arg0: Internal.Consumer_<Internal.ItemStack_>, arg1: Internal.LootContext_): void;
    }
    type LootPoolEntry_ = LootPoolEntry;
    /**
    * @javaClass net.minecraft.class_3310$class_3181
    */
    class SpikeFeature$EndSpike {
        getHeight(): number;
        getTopBoundingBox(): Internal.AABB;
        isCenterWithinChunk($$0: BlockPos_): boolean;
        isGuarded(): boolean;
        getCenterZ(): number;
        getRadius(): number;
        getCenterX(): number;
        static readonly "CODEC" : Internal.Codec<Internal.SpikeFeature$EndSpike>;
        get guarded(): boolean;
        get centerZ(): number;
        get topBoundingBox(): Internal.AABB;
        get centerX(): number;
        get radius(): number;
        get height(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean);
    }
    type SpikeFeature$EndSpike_ = SpikeFeature$EndSpike;
    /**
    * @javaClass net.minecraft.class_2625
    */
    class SignBlockEntity extends Internal.BlockEntity implements net.darkhax.bookshelf.mixin.block.entity.AccessorSignBlockEntity, Internal.SignBufferHolder, net.darkhax.pigpen.mixin.AccessorSignBlockEntity, Internal.AccessorSignBlockEntity {
        renderBuffered(poseStack: Internal.PoseStack_, multiBufferSource: Internal.MultiBufferSource_, light: number): boolean;
        getRenderMessages($$0: boolean, $$1: Internal.Function_<net.minecraft.network.chat.Component_, Internal.FormattedCharSequence_>): Internal.FormattedCharSequence[];
        getColor(): Internal.DyeColor;
        getMessage($$0: number, $$1: boolean): net.minecraft.network.chat.Component;
        setAllowedPlayerEditor($$0: Internal.UUID_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        setMessage($$0: number, $$1: net.minecraft.network.chat.Component_): void;
        setMessage($$0: number, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_): void;
        hasGlowingText(): boolean;
        getMessages($$0: boolean): net.minecraft.network.chat.Component[];
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        invalidateCaps(): void;
        setEditable($$0: boolean): void;
        executeClickCommands($$0: Internal.ServerPlayer_): boolean;
        setColor($$0: Internal.DyeColor_): boolean;
        isEditable(): boolean;
        setHasGlowingText($$0: boolean): boolean;
        method_16887(): Internal.CompoundTag;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_11011(): boolean;
        getPlayerWhoMayEdit(): Internal.UUID;
        createCommandSourceStack($$0: Internal.ServerPlayer_): Internal.CommandSourceStack;
        method_11014($$0: Internal.CompoundTag_): void;
        static readonly "LINES" : 4;
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket;
        get color(): Internal.DyeColor;
        get editable(): boolean;
        get playerWhoMayEdit(): Internal.UUID;
        set color($$0: Internal.DyeColor_);
        set editable($$0: boolean);
        set allowedPlayerEditor($$0: Internal.UUID_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.BlockState);
    }
    type SignBlockEntity_ = SignBlockEntity;
    /**
    * @javaClass net.coderbot.iris.mixin.LightTextureAccessor
    */
    interface LightTextureAccessor {
        getLightTexture(): Internal.DynamicTexture;
    }
    type LightTextureAccessor_ = LightTextureAccessor;
    /**
    * @javaClass java.time.OffsetDateTime
    */
    class OffsetDateTime implements Internal.Temporal, Internal.TemporalAdjuster, Internal.Comparable<Internal.OffsetDateTime>, Internal.Serializable {
        plusHours(arg0: number): this;
        isEqual(arg0: Internal.OffsetDateTime_): boolean;
        toLocalTime(): Internal.LocalTime;
        compareTo(arg0: Internal.OffsetDateTime_): number;
        withOffsetSameLocal(arg0: Internal.ZoneOffset_): this;
        getDayOfWeek(): Internal.DayOfWeek;
        plusSeconds(arg0: number): this;
        getMinute(): number;
        static from(arg0: Internal.TemporalAccessor_): Internal.OffsetDateTime;
        getMonth(): Internal.Month;
        plusNanos(arg0: number): this;
        atZoneSameInstant(arg0: Internal.ZoneId_): Internal.ZonedDateTime;
        withHour(arg0: number): this;
        plusMonths(arg0: number): this;
        plusYears(arg0: number): this;
        truncatedTo(arg0: Internal.TemporalUnit_): this;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        minusNanos(arg0: number): this;
        getNano(): number;
        format(arg0: Internal.DateTimeFormatter_): string;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        isSupported(arg0: Internal.TemporalField_): boolean;
        plus(arg0: number, arg1: Internal.TemporalUnit_): this;
        plus(arg0: Internal.TemporalAmount_): this;
        getYear(): number;
        toEpochSecond(): number;
        toLocalDateTime(): Internal.LocalDateTime;
        withDayOfMonth(arg0: number): this;
        withMonth(arg0: number): this;
        isAfter(arg0: Internal.OffsetDateTime_): boolean;
        static ofInstant(arg0: Internal.Instant_, arg1: Internal.ZoneId_): Internal.OffsetDateTime;
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        minus(arg0: Internal.TemporalAmount_): this;
        toOffsetTime(): Internal.OffsetTime;
        minusHours(arg0: number): this;
        getOffset(): Internal.ZoneOffset;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        withYear(arg0: number): this;
        plusMinutes(arg0: number): this;
        minusMinutes(arg0: number): this;
        plusDays(arg0: number): this;
        atZoneSimilarLocal(arg0: Internal.ZoneId_): Internal.ZonedDateTime;
        hashCode(): number;
        static now(arg0: Internal.Clock_): Internal.OffsetDateTime;
        static now(): Internal.OffsetDateTime;
        static now(arg0: Internal.ZoneId_): Internal.OffsetDateTime;
        static of(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: Internal.ZoneOffset_): Internal.OffsetDateTime;
        static of(arg0: Internal.LocalDateTime_, arg1: Internal.ZoneOffset_): Internal.OffsetDateTime;
        static of(arg0: Internal.LocalDate_, arg1: Internal.LocalTime_, arg2: Internal.ZoneOffset_): Internal.OffsetDateTime;
        get(arg0: Internal.TemporalField_): number;
        getDayOfYear(): number;
        plusWeeks(arg0: number): this;
        getHour(): number;
        withMinute(arg0: number): this;
        getMonthValue(): number;
        toZonedDateTime(): Internal.ZonedDateTime;
        minusYears(arg0: number): this;
        minusWeeks(arg0: number): this;
        withDayOfYear(arg0: number): this;
        static parse(arg0: Internal.CharSequence_): Internal.OffsetDateTime;
        static parse(arg0: Internal.CharSequence_, arg1: Internal.DateTimeFormatter_): Internal.OffsetDateTime;
        toInstant(): Internal.Instant;
        isBefore(arg0: Internal.OffsetDateTime_): boolean;
        minusDays(arg0: number): this;
        withNano(arg0: number): this;
        getLong(arg0: Internal.TemporalField_): number;
        minusMonths(arg0: number): this;
        with(arg0: Internal.TemporalAdjuster_): this;
        with(arg0: Internal.TemporalField_, arg1: number): this;
        toLocalDate(): Internal.LocalDate;
        withOffsetSameInstant(arg0: Internal.ZoneOffset_): this;
        equals(arg0: any): boolean;
        getSecond(): number;
        static timeLineOrder(): Internal.Comparator<Internal.OffsetDateTime>;
        until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        toString(): string;
        getDayOfMonth(): number;
        minusSeconds(arg0: number): this;
        withSecond(arg0: number): this;
        static readonly "MIN" : Internal.OffsetDateTime;
        static readonly "MAX" : Internal.OffsetDateTime;
        get dayOfWeek(): Internal.DayOfWeek;
        get month(): Internal.Month;
        get offset(): Internal.ZoneOffset;
        get hour(): number;
        get year(): number;
        get dayOfYear(): number;
        get dayOfMonth(): number;
        get monthValue(): number;
        get nano(): number;
        get minute(): number;
        get second(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type OffsetDateTime_ = OffsetDateTime;
    /**
    * @javaClass net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents$AfterMouseScroll
    */
    interface ScreenMouseEvents$AfterMouseScroll {
        afterMouseScroll(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number, arg4: number): void;
    }
    type ScreenMouseEvents$AfterMouseScroll_ = ((arg0: Internal.Screen, arg1: number, arg2: number, arg3: number, arg4: number) => void) | ScreenMouseEvents$AfterMouseScroll;
    /**
    * @javaClass net.minecraft.class_3002
    */
    class CustomBossEvent extends Internal.ServerBossEvent {
        setMax($$0: number): void;
        method_14094(): void;
        setPlayers($$0: Internal.Collection_<Internal.ServerPlayer_>): boolean;
        method_14088($$0: Internal.ServerPlayer_): void;
        onPlayerDisconnect($$0: Internal.ServerPlayer_): void;
        getMax(): number;
        save(): Internal.CompoundTag;
        getTextId(): ResourceLocation;
        onPlayerConnect($$0: Internal.ServerPlayer_): void;
        getValue(): number;
        static load($$0: Internal.CompoundTag_, $$1: ResourceLocation_): Internal.CustomBossEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        setValue($$0: number): void;
        addOfflinePlayer($$0: Internal.UUID_): void;
        method_14089($$0: Internal.ServerPlayer_): void;
        get textId(): ResourceLocation;
        get max(): number;
        get displayName(): net.minecraft.network.chat.Component;
        get value(): number;
        set max($$0: number);
        set players($$0: Internal.Collection_<Internal.ServerPlayer_>);
        set value($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: ResourceLocation, $$1: net.minecraft.network.chat.Component);
    }
    type CustomBossEvent_ = CustomBossEvent;
    /**
    * @javaClass net.minecraft.class_3031
    */
    abstract class Feature <FC> {
        static isDirt($$0: Internal.BlockState_): boolean;
        static isGrassOrDirt($$0: Internal.LevelSimulatedReader_, $$1: BlockPos_): boolean;
        configuredCodec(): Internal.Codec<Internal.ConfiguredFeature<FC, Internal.Feature<FC>>>;
        static checkNeighbors($$0: Internal.Function_<BlockPos_, Internal.BlockState_>, $$1: BlockPos_, $$2: Internal.Predicate_<Internal.BlockState_>): boolean;
        static isReplaceable($$0: Internal.TagKey_<Internal.Block_>): Internal.Predicate<Internal.BlockState>;
        place(arg0: Internal.FeaturePlaceContext_<FC>): boolean;
        place($$0: FC, $$1: Internal.WorldGenLevel_, $$2: Internal.ChunkGenerator_, $$3: Internal.Random_, $$4: BlockPos_): boolean;
        static isAdjacentToAir($$0: Internal.Function_<BlockPos_, Internal.BlockState_>, $$1: BlockPos_): boolean;
        static isAir($$0: Internal.LevelSimulatedReader_, $$1: BlockPos_): boolean;
        static readonly "VEGETATION_PATCH" : Internal.Feature<Internal.VegetationPatchConfiguration>;
        static readonly "CHORUS_PLANT" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "MONSTER_ROOM" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "FREEZE_TOP_LAYER" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "BLOCK_COLUMN" : Internal.Feature<Internal.BlockColumnConfiguration>;
        static readonly "REPLACE_SINGLE_BLOCK" : Internal.Feature<Internal.ReplaceBlockConfiguration>;
        static readonly "GLOW_LICHEN" : Internal.Feature<Internal.GlowLichenConfiguration>;
        static readonly "FLOWER" : Internal.Feature<Internal.RandomPatchConfiguration>;
        static readonly "BLOCK_PILE" : Internal.Feature<Internal.BlockPileConfiguration>;
        static readonly "SPRING" : Internal.Feature<Internal.SpringConfiguration>;
        static readonly "UNDERWATER_MAGMA" : Internal.Feature<Internal.UnderwaterMagmaConfiguration>;
        static readonly "BAMBOO" : Internal.Feature<Internal.ProbabilityFeatureConfiguration>;
        static readonly "DELTA_FEATURE" : Internal.Feature<Internal.DeltaFeatureConfiguration>;
        static readonly "ROOT_SYSTEM" : Internal.Feature<Internal.RootSystemConfiguration>;
        static readonly "NETHER_FOREST_VEGETATION" : Internal.Feature<Internal.NetherForestVegetationConfig>;
        static readonly "WEEPING_VINES" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "LAKE" : Internal.Feature<Internal.LakeFeature$Configuration>;
        static readonly "TWISTING_VINES" : Internal.Feature<Internal.TwistingVinesConfig>;
        static readonly "HUGE_RED_MUSHROOM" : Internal.Feature<Internal.HugeMushroomFeatureConfiguration>;
        static readonly "SIMPLE_BLOCK" : Internal.Feature<Internal.SimpleBlockConfiguration>;
        static readonly "RANDOM_SELECTOR" : Internal.Feature<Internal.RandomFeatureConfiguration>;
        static readonly "END_ISLAND" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "REPLACE_BLOBS" : Internal.Feature<Internal.ReplaceSphereConfiguration>;
        static readonly "VINES" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "TREE" : Internal.Feature<Internal.TreeConfiguration>;
        static readonly "CORAL_CLAW" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "DISK" : Internal.Feature<Internal.DiskConfiguration>;
        static readonly "FOSSIL" : Internal.Feature<Internal.FossilFeatureConfiguration>;
        static readonly "FILL_LAYER" : Internal.Feature<Internal.LayerConfiguration>;
        static readonly "SIMPLE_RANDOM_SELECTOR" : Internal.Feature<Internal.SimpleRandomFeatureConfiguration>;
        static readonly "ICE_SPIKE" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "NO_BONEMEAL_FLOWER" : Internal.Feature<Internal.RandomPatchConfiguration>;
        static readonly "ORE" : Internal.Feature<Internal.OreConfiguration>;
        static readonly "ICEBERG" : Internal.Feature<Internal.BlockStateConfiguration>;
        static readonly "BASALT_COLUMNS" : Internal.Feature<Internal.ColumnFeatureConfiguration>;
        static readonly "RANDOM_BOOLEAN_SELECTOR" : Internal.Feature<Internal.RandomBooleanFeatureConfiguration>;
        static readonly "RANDOM_PATCH" : Internal.Feature<Internal.RandomPatchConfiguration>;
        static readonly "LARGE_DRIPSTONE" : Internal.Feature<Internal.LargeDripstoneConfiguration>;
        static readonly "SEAGRASS" : Internal.SeagrassFeature;
        static readonly "POINTED_DRIPSTONE" : Internal.Feature<Internal.PointedDripstoneConfiguration>;
        static readonly "GLOWSTONE_BLOB" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "WATERLOGGED_VEGETATION_PATCH" : Internal.Feature<Internal.VegetationPatchConfiguration>;
        static readonly "CORAL_MUSHROOM" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "VOID_START_PLATFORM" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "DESERT_WELL" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "HUGE_BROWN_MUSHROOM" : Internal.Feature<Internal.HugeMushroomFeatureConfiguration>;
        static readonly "END_GATEWAY" : Internal.Feature<Internal.EndGatewayConfiguration>;
        static readonly "END_SPIKE" : Internal.Feature<Internal.SpikeConfiguration>;
        static readonly "BASALT_PILLAR" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "FOREST_ROCK" : Internal.Feature<Internal.BlockStateConfiguration>;
        static readonly "HUGE_FUNGUS" : Internal.Feature<Internal.HugeFungusConfiguration>;
        static readonly "BLUE_ICE" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "NO_OP" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "SEA_PICKLE" : Internal.Feature<Internal.CountConfiguration>;
        static readonly "BONUS_CHEST" : Internal.BonusChestFeature;
        static readonly "SCATTERED_ORE" : Internal.Feature<Internal.OreConfiguration>;
        static readonly "CORAL_TREE" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        static readonly "DRIPSTONE_CLUSTER" : Internal.Feature<Internal.DripstoneClusterConfiguration>;
        static readonly "ICE_PATCH" : Internal.Feature<Internal.DiskConfiguration>;
        static readonly "GEODE" : Internal.Feature<Internal.GeodeConfiguration>;
        static readonly "KELP" : Internal.Feature<Internal.NoneFeatureConfiguration>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Codec<FC>);
    }
    type Feature_<FC> = Special.Feature | Feature<FC>;
    /**
    * @javaClass xaero.common.minimap.render.MinimapRendererHelper
    */
    class MinimapRendererHelper {
        addColoredLineToExistingBuffer(matrices: Internal.PoseStack$Pose_, vertexBuffer: Internal.VertexConsumer_, x1: number, y1: number, x2: number, y2: number, r: number, g: number, b: number, a: number): void;
        addColoredRectToExistingBuffer(matrix: Internal.Matrix4f_, vertexBuffer: Internal.VertexConsumer_, x: number, y: number, w: number, h: number, color: number): void;
        addColoredRectToExistingBuffer(matrix: Internal.Matrix4f_, vertexBuffer: Internal.VertexConsumer_, x: number, y: number, w: number, h: number, r: number, g: number, b: number, a: number): void;
        drawMyColoredRect(matrixStack: Internal.PoseStack_, x1: number, y1: number, x2: number, y2: number): void;
        drawMyColoredRect(matrix: Internal.Matrix4f_, x1: number, y1: number, x2: number, y2: number, color: number): void;
        prepareMyTexturedColoredModalRect(matrix: Internal.Matrix4f_, x: number, y: number, textureX: number, textureY: number, width: number, height: number, theight: number, factor: number, textureId: number, r: number, g: number, b: number, a: number, renderer: Internal.MultiTextureRenderTypeRenderer_): void;
        drawIconOutline(matrixStack: Internal.PoseStack_, x: number, y: number, textureX: number, textureY: number, width: number, height: number, theight: number, factor: number, discardAlpha: number): void;
        static restoreDefaultShaderBlendState(): void;
        prepareMyTexturedModalRect(matrix: Internal.Matrix4f_, x: number, y: number, textureX: number, textureY: number, width: number, height: number, theight: number, factor: number, textureId: number, renderer: Internal.MultiTextureRenderTypeRenderer_): void;
        drawMyTexturedModalRect(matrixStack: Internal.PoseStack_, x: number, y: number, textureX: number, textureY: number, width: number, height: number, theight: number, factor: number): void;
        drawMyTexturedModalRect(matrixStack: Internal.PoseStack_, x: number, y: number, textureX: number, textureY: number, width: number, height: number, theight: number, factor: number, discardAlpha: number, blend: boolean): void;
        addTexturedColoredRectToExistingBuffer(matrix: Internal.Matrix4f_, vertexBuffer: Internal.VertexConsumer_, x: number, y: number, u: number, v: number, w: number, h: number, r: number, g: number, b: number, a: number, factor: number): void;
        addTexturedColoredRectToExistingBuffer(matrix: Internal.Matrix4f_, vertexBuffer: Internal.VertexConsumer_, x: number, y: number, u: number, v: number, w: number, h: number, tw: number, th: number, r: number, g: number, b: number, a: number, factor: number): void;
        defaultOrtho(framebuffer: Internal.RenderTarget_): void;
        addTexturedRectToExistingBuffer(matrix: Internal.Matrix4f_, vertexBuffer: Internal.VertexConsumer_, x: number, y: number, u: number, v: number, w: number, h: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type MinimapRendererHelper_ = MinimapRendererHelper;
    /**
    * @javaClass net.minecraft.class_6836$class_6838
    */
    class StreamTagVisitor$ValueResult extends Internal.Enum<Internal.StreamTagVisitor$ValueResult> {
        static valueOf($$0: string): Internal.StreamTagVisitor$ValueResult;
        static values(): Internal.StreamTagVisitor$ValueResult[];
        static readonly "CONTINUE" : Internal.StreamTagVisitor$ValueResult;
        static readonly "HALT" : Internal.StreamTagVisitor$ValueResult;
        static readonly "BREAK" : Internal.StreamTagVisitor$ValueResult;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type StreamTagVisitor$ValueResult_ = "halt" | "break" | "continue" | StreamTagVisitor$ValueResult;
    /**
    * @javaClass net.minecraft.class_2759
    */
    class ClientboundSetDefaultSpawnPositionPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getAngle(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getPos(): BlockPos;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get pos(): BlockPos;
        get angle(): number;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: number);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundSetDefaultSpawnPositionPacket_ = ClientboundSetDefaultSpawnPositionPacket;
    /**
    * @javaClass java.lang.ModuleLayer
    */
    class ModuleLayer {
        findModule(arg0: string): Internal.Optional<Internal.Module>;
        static defineModulesWithManyLoaders(arg0: Internal.Configuration_, arg1: Internal.List_<Internal.ModuleLayer_>, arg2: Internal.ClassLoader_): Internal.ModuleLayer$Controller;
        defineModulesWithManyLoaders(arg0: Internal.Configuration_, arg1: Internal.ClassLoader_): this;
        findLoader(arg0: string): Internal.ClassLoader;
        configuration(): Internal.Configuration;
        toString(): string;
        static defineModulesWithOneLoader(arg0: Internal.Configuration_, arg1: Internal.List_<Internal.ModuleLayer_>, arg2: Internal.ClassLoader_): Internal.ModuleLayer$Controller;
        defineModulesWithOneLoader(arg0: Internal.Configuration_, arg1: Internal.ClassLoader_): this;
        static boot(): Internal.ModuleLayer;
        modules(): Internal.Set<Internal.Module>;
        defineModules(arg0: Internal.Configuration_, arg1: Internal.Function_<string, Internal.ClassLoader_>): this;
        static defineModules(arg0: Internal.Configuration_, arg1: Internal.List_<Internal.ModuleLayer_>, arg2: Internal.Function_<string, Internal.ClassLoader_>): Internal.ModuleLayer$Controller;
        parents(): Internal.List<Internal.ModuleLayer>;
        static empty(): Internal.ModuleLayer;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ModuleLayer_ = ModuleLayer;
    /**
    * @javaClass java.net.URLStreamHandlerFactory
    */
    interface URLStreamHandlerFactory {
        createURLStreamHandler(arg0: string): Internal.URLStreamHandler;
    }
    type URLStreamHandlerFactory_ = URLStreamHandlerFactory;
    /**
    * @javaClass net.minecraft.class_1917
    */
    abstract class BaseSpawner implements Internal.BaseSpawnerAccessor {
        broadcastEvent(arg0: Internal.Level_, arg1: BlockPos_, arg2: number): void;
        onEventTriggered($$0: Internal.Level_, $$1: number): boolean;
        getOrCreateDisplayEntity($$0: Internal.Level_): Internal.Entity;
        setNextSpawnData($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.SpawnData_): void;
        load($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.CompoundTag_): void;
        setEntityId($$0: Internal.EntityType_<any>): void;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        serverTick($$0: Internal.ServerLevel_, $$1: BlockPos_): void;
        getSpin(): number;
        clientTick($$0: Internal.Level_, $$1: BlockPos_): void;
        getoSpin(): number;
        "spawnDelay" : number;
        "maxNearbyEntities" : number;
        "spawnCount" : number;
        "spawnRange" : number;
        get oSpin(): number;
        get spin(): number;
        set entityId($$0: Internal.EntityType_<any>);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type BaseSpawner_ = BaseSpawner;
    /**
    * @javaClass xaero.common.category.rule.ObjectCategoryListRule
    */
    abstract class ObjectCategoryListRule <E, S> extends Internal.ObjectCategoryRule<E, any> implements Internal.Iterable<string> {
        iterator(): Internal.Iterator<string>;
        spliterator(): Internal.Spliterator<string>;
        forEach(arg0: Internal.Consumer_<string>): void;
        getIncludeInSuperCategory(): boolean;
        inList(object: E): boolean;
        getStringValidator(): Internal.Predicate<string>;
        get stringValidator(): Internal.Predicate<string>;
        get includeInSuperCategory(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ObjectCategoryListRule_<E, S> = ObjectCategoryListRule<E, S>;
    /**
    * @javaClass net.minecraft.class_3867
    */
    class BellAttachType extends Internal.Enum<Internal.BellAttachType> implements Internal.StringRepresentable {
        static valueOf($$0: string): Internal.BellAttachType;
        static values(): Internal.BellAttachType[];
        method_15434(): string;
        static readonly "FLOOR" : Internal.BellAttachType;
        static readonly "DOUBLE_WALL" : Internal.BellAttachType;
        static readonly "CEILING" : Internal.BellAttachType;
        static readonly "SINGLE_WALL" : Internal.BellAttachType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BellAttachType_ = "ceiling" | "single_wall" | "floor" | "double_wall" | BellAttachType;
    /**
    * @javaClass java.nio.file.WatchEvent
    */
    interface WatchEvent <T> {
        kind(): Internal.WatchEvent$Kind<T>;
        count(): number;
        context(): T;
    }
    type WatchEvent_<T> = WatchEvent<T>;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.AbstractTextureExtensions
    */
    interface AbstractTextureExtensions {
        restoreLastBlurMipmap(): void;
        setBlurMipmap(blur: boolean, mipmap: boolean): void;
    }
    type AbstractTextureExtensions_ = AbstractTextureExtensions;
    /**
    * @javaClass dev.latvian.mods.kubejs.event.EventsJS$ScriptEventHandler
    */
    class EventsJS$ScriptEventHandler {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type EventsJS$ScriptEventHandler_ = EventsJS$ScriptEventHandler;
    /**
    * @javaClass net.minecraft.class_1123
    */
    interface MutableSearchTree <T> extends Internal.SearchTree<T> {
        add(arg0: T): void;
        clear(): void;
        refresh(): void;
    }
    type MutableSearchTree_<T> = MutableSearchTree<T>;
    /**
    * @javaClass java.time.ZoneOffset
    */
    class ZoneOffset extends Internal.ZoneId implements Internal.TemporalAccessor, Internal.TemporalAdjuster, Internal.Comparable<Internal.ZoneOffset>, Internal.Serializable {
        getTotalSeconds(): number;
        static ofHoursMinutes(arg0: number, arg1: number): Internal.ZoneOffset;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        getId(): string;
        isSupported(arg0: Internal.TemporalField_): boolean;
        compareTo(arg0: Internal.ZoneOffset_): number;
        getLong(arg0: Internal.TemporalField_): number;
        static ofHours(arg0: number): Internal.ZoneOffset;
        hashCode(): number;
        static of(arg0: string): Internal.ZoneOffset;
        equals(arg0: any): boolean;
        get(arg0: Internal.TemporalField_): number;
        static from(arg0: Internal.TemporalAccessor_): Internal.ZoneOffset;
        toString(): string;
        getRules(): Internal.ZoneRules;
        static ofHoursMinutesSeconds(arg0: number, arg1: number, arg2: number): Internal.ZoneOffset;
        static ofTotalSeconds(arg0: number): Internal.ZoneOffset;
        static readonly "MIN" : Internal.ZoneOffset;
        static readonly "UTC" : Internal.ZoneOffset;
        static readonly "MAX" : Internal.ZoneOffset;
        get totalSeconds(): number;
        get rules(): Internal.ZoneRules;
        get id(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ZoneOffset_ = ZoneOffset;
    /**
    * @javaClass net.minecraft.class_2746
    */
    class BooleanProperty extends Internal.Property<boolean> {
        method_11799(): number;
        method_11898(): Internal.Collection<boolean>;
        method_11900($$0: string): Internal.Optional<boolean>;
        getName($$0: boolean): string;
        equals($$0: any): boolean;
        static create($$0: string): Internal.BooleanProperty;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BooleanProperty_ = BooleanProperty;
    /**
    * @javaClass me.jellysquid.mods.sodium.client.render.chunk.ChunkTracker
    */
    class ChunkTracker {
        loadChunk(x: number, z: number): boolean;
        hasMergedFlags(x: number, z: number, flags: number): boolean;
        unloadChunk(x: number, z: number): boolean;
        update(): void;
        getChunks(flags: number): Internal.LongStream;
        onLightDataAdded(x: number, z: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ChunkTracker_ = ChunkTracker;
    /**
    * @javaClass dev.latvian.mods.rhino.SharedContextData
    */
    class SharedContextData {
        getWrapFactory(): Internal.WrapFactory;
        newClassSerialNumber(): number;
        hasTypeWrappers(): boolean;
        setWrapFactory(wrapFactory: Internal.WrapFactory_): void;
        getRemapper(): Internal.Remapper;
        getTypeWrappers(): Internal.TypeWrappers;
        getExtraProperty(key: string): any;
        setRemapper(remapper: Internal.Remapper_): void;
        setClassShutter(shutter: Internal.ClassShutter_): void;
        addCustomJavaToJsWrapper<T>(predicate: Internal.Predicate_<T>, provider: Internal.CustomJavaToJsWrapperProvider_<T>): void;
        addCustomJavaToJsWrapper<T>(type: Internal.Class_<T>, provider: Internal.CustomJavaToJsWrapperProvider_<T>): void;
        getClassDataCache(): Internal.ClassDataCache;
        getClassShutter(): Internal.ClassShutter;
        static get(scope: Internal.Scriptable_): Internal.SharedContextData;
        static get(cx: Internal.Context_, scope: Internal.Scriptable_): Internal.SharedContextData;
        addToTopLevelScope(name: string, value: any): void;
        setExtraProperty(key: string, value: any): void;
        wrapCustomJavaToJs(javaObject: any): Internal.CustomJavaToJsWrapper;
        static readonly "AKEY" : "ClassCache";
        readonly "topLevelScope" : Internal.Scriptable;
        get typeWrappers(): Internal.TypeWrappers;
        get remapper(): Internal.Remapper;
        get wrapFactory(): Internal.WrapFactory;
        get classDataCache(): Internal.ClassDataCache;
        get classShutter(): Internal.ClassShutter;
        set remapper(remapper: Internal.Remapper_);
        set wrapFactory(wrapFactory: Internal.WrapFactory_);
        set classShutter(shutter: Internal.ClassShutter_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(scope: Internal.Scriptable);
    }
    type SharedContextData_ = SharedContextData;
    /**
    * @javaClass net.minecraft.class_5869$class_6107
    */
    class CanyonCarverConfiguration$CanyonShapeConfiguration {
        static readonly "CODEC" : Internal.Codec<Internal.CanyonCarverConfiguration$CanyonShapeConfiguration>;
        readonly "thickness" : Internal.FloatProvider;
        readonly "distanceFactor" : Internal.FloatProvider;
        readonly "horizontalRadiusFactor" : Internal.FloatProvider;
        readonly "widthSmoothness" : number;
        readonly "verticalRadiusDefaultFactor" : number;
        readonly "verticalRadiusCenterFactor" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.FloatProvider, $$1: Internal.FloatProvider, $$2: number, $$3: Internal.FloatProvider, $$4: number, $$5: number);
    }
    type CanyonCarverConfiguration$CanyonShapeConfiguration_ = CanyonCarverConfiguration$CanyonShapeConfiguration;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.QuestObject
    */
    abstract class QuestObject extends Internal.QuestObjectBase {
        getProgressColor(data: Internal.TeamData_): Internal.Color4I;
        getProgressColor(data: Internal.TeamData_, dim: boolean): Internal.Color4I;
        readData(nbt: Internal.CompoundTag_): void;
        readNetData(buffer: Internal.FriendlyByteBuf_): void;
        onCompleted(data: Internal.QuestProgressEventData_<any>): void;
        isVisible(data: Internal.TeamData_): boolean;
        writeData(nbt: Internal.CompoundTag_): void;
        getConfig(config: Internal.ConfigGroup_): void;
        writeNetData(buffer: Internal.FriendlyByteBuf_): void;
        forceProgress(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        getChildren(): Internal.Collection<Internal.QuestObject>;
        isCompletedRaw(data: Internal.TeamData_): boolean;
        static getRelativeProgressFromChildren(progressSum: number, count: number): number;
        getRelativeProgressFromChildren(arg0: Internal.TeamData_): number;
        onStarted(data: Internal.QuestProgressEventData_<any>): void;
        hasUnclaimedRewardsRaw(teamData: Internal.TeamData_, player: Internal.UUID_): boolean;
        cacheProgress(): boolean;
        "disableToast" : boolean;
        get children(): Internal.Collection<Internal.QuestObject>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type QuestObject_ = QuestObject;
    /**
    * @javaClass com.almostreliable.lootjs.core.LootEntry
    */
    class LootEntry implements Internal.LootFunctionsContainer<Internal.LootEntry>, Internal.Function<Internal.LootContext, Internal.ItemStack> {
        setName(component: net.minecraft.network.chat.Component_): this;
        enchantWithLevels(numberProvider: Internal.NumberProvider_, allowTreasure: boolean): this;
        enchantWithLevels(numberProvider: Internal.NumberProvider_): this;
        damage(numberProvider: Internal.NumberProvider_): this;
        functions(filter: ItemFilter_, action: Internal.Consumer_<Internal.LootFunctionsContainer_<Internal.LootEntry_>>): this;
        getWeight(): number;
        addAttributes(action: Internal.Consumer_<Internal.AddAttributesFunction$Builder_>): this;
        andThen<V>(arg0: Internal.Function_<Internal.ItemStack_, V>): Internal.Function<Internal.LootContext, V>;
        applyBinomialDistributionBonus(enchantment: Internal.Enchantment_, probability: number, n: number): this;
        applyOreBonus(enchantment: Internal.Enchantment_): this;
        withChance(chance: number): this;
        applyLootingBonus(numberProvider: Internal.NumberProvider_): this;
        smeltLoot(): this;
        simulateExplosionDecay(): this;
        addFunction(lootItemFunction: Internal.LootItemFunction_): this;
        addFunction(builder: Internal.LootItemFunction$Builder_): this;
        withWeight(weight: number): this;
        apply(context: Internal.LootContext_): Internal.ItemStack;
        limitCount(numberProviderMin: Internal.NumberProvider_, numberProviderMax: Internal.NumberProvider_): this;
        limitCount(numberProvider: Internal.NumberProvider_): this;
        applyBonus(enchantment: Internal.Enchantment_, multiplier: number): this;
        addNbt(tag: Internal.CompoundTag_): this;
        addNBT(tag: Internal.CompoundTag_): this;
        replaceLore(...components: net.minecraft.network.chat.Component_[]): this;
        addLore(...components: net.minecraft.network.chat.Component_[]): this;
        hasWeight(): boolean;
        compose<V>(arg0: Internal.Function_<V, Internal.LootContext_>): Internal.Function<V, Internal.ItemStack>;
        addPotion(potion: Internal.Potion_): this;
        enchantRandomly(): this;
        enchantRandomly(enchantments: Internal.Enchantment_[]): this;
        get weight(): number;
        set name(component: net.minecraft.network.chat.Component_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(item: Internal.Item);
        constructor(itemStack: Internal.ItemStack);
    }
    type LootEntry_ = LootEntry;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.mixin.common.accessor.StructureTemplateAccessor
    */
    interface StructureTemplateAccessor {
    }
    type StructureTemplateAccessor_ = StructureTemplateAccessor;
    /**
    * @javaClass javax.accessibility.AccessibleBundle
    */
    abstract class AccessibleBundle {
        toDisplayString(): string;
        toDisplayString(arg0: Internal.Locale_): string;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AccessibleBundle_ = AccessibleBundle;
    /**
    * @javaClass dev.ftb.mods.ftbteams.data.TeamBase
    */
    abstract class TeamBase {
        isAlly(profile: Internal.UUID_): boolean;
        getProperty<T>(property: Internal.TeamProperty_<T>): T;
        getName(): net.minecraft.network.chat.Component;
        getHighestRank(playerId: Internal.UUID_): Internal.TeamRank;
        isValid(): boolean;
        getExtraData(): Internal.CompoundTag;
        save(): void;
        getColor(): number;
        getId(): Internal.UUID;
        isMember(uuid: Internal.UUID_): boolean;
        getRanked(rank: Internal.TeamRank_): Internal.Map<Internal.UUID, Internal.TeamRank>;
        getDescription(): string;
        isOfficer(profile: Internal.UUID_): boolean;
        isFreeToJoin(): boolean;
        getColoredName(): net.minecraft.network.chat.Component;
        getStringID(): string;
        isInvited(profile: Internal.UUID_): boolean;
        getDisplayName(): string;
        getType(): Internal.TeamType;
        hashCode(): number;
        setProperty<T>(property: Internal.TeamProperty_<T>, value: T): void;
        equals(o: any): boolean;
        toString(): string;
        getMembers(): Internal.Set<Internal.UUID>;
        static readonly "FREE_TO_JOIN" : dev.ftb.mods.ftbteams.property.BooleanProperty;
        static readonly "DESCRIPTION" : Internal.StringProperty;
        static readonly "COLOR" : Internal.ColorProperty;
        readonly "messageHistory" : Internal.List<Internal.TeamMessage>;
        static readonly "DISPLAY_NAME" : Internal.StringProperty;
        readonly "properties" : Internal.TeamProperties;
        get valid(): boolean;
        get stringID(): string;
        get color(): number;
        get extraData(): Internal.CompoundTag;
        get displayName(): string;
        get members(): Internal.Set<Internal.UUID>;
        get name(): net.minecraft.network.chat.Component;
        get description(): string;
        get id(): Internal.UUID;
        get type(): Internal.TeamType;
        get coloredName(): net.minecraft.network.chat.Component;
        get freeToJoin(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type TeamBase_ = TeamBase;
    /**
    * @javaClass java.awt.geom.Point2D
    */
    abstract class Point2D implements Internal.Cloneable {
        getX(): number;
        getY(): number;
        static distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
        distance(arg0: Internal.Point2D_): number;
        distance(arg0: number, arg1: number): number;
        setLocation(arg0: number, arg1: number): void;
        setLocation(arg0: Internal.Point2D_): void;
        hashCode(): number;
        equals(arg0: any): boolean;
        clone(): any;
        distanceSq(arg0: number, arg1: number): number;
        distanceSq(arg0: Internal.Point2D_): number;
        static distanceSq(arg0: number, arg1: number, arg2: number, arg3: number): number;
        get x(): number;
        get y(): number;
        set location(arg0: Internal.Point2D_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Point2D_ = Point2D;
    /**
    * @javaClass com.simibubi.create.foundation.utility.Couple
    */
    class Couple <T> extends com.simibubi.create.foundation.utility.Pair<T, T> implements Internal.Iterable<T> {
        mapNotNullWithParam<S, R>(function_: Internal.BiFunction_<T, R, S>, value: R): Internal.Couple<S>;
        serializeEach(serializer: Internal.Function_<T, Internal.CompoundTag_>): Internal.ListTag;
        set(first: boolean, value: T): void;
        forEachWithParams<S>(function_: Internal.BiConsumer_<T, S>, values: Internal.Couple_<S>): void;
        spliterator(): Internal.Spliterator<T>;
        swap(): Internal.Couple<T>;
        mapWithParams<S, R>(function_: Internal.BiFunction_<T, R, S>, values: Internal.Couple_<R>): Internal.Couple<S>;
        forEach(consumer: Internal.Consumer_<T>): void;
        replace(function_: Internal.Function_<T, T>): void;
        both(test: Internal.Predicate_<T>): boolean;
        either(test: Internal.Predicate_<T>): boolean;
        iterator(): Internal.Iterator<T>;
        static createWithContext<T>(factory: Internal.Function_<boolean, T>): Internal.Couple<T>;
        stream(): Internal.Stream<T>;
        get(first: boolean): T;
        static deserializeEach<S>(list: Internal.ListTag_, deserializer: Internal.Function_<Internal.CompoundTag_, S>): Internal.Couple<S>;
        replaceWithContext(function_: Internal.BiFunction_<T, boolean, T>): void;
        static create<T>(factory: Internal.Supplier_<T>): Internal.Couple<T>;
        static create<T>(first: T, second: T): Internal.Couple<T>;
        replaceWithParams<S>(function_: Internal.BiFunction_<T, S, T>, values: Internal.Couple_<S>): void;
        forEachWithContext(consumer: Internal.BiConsumer_<T, boolean>): void;
        copy(): Internal.Couple<T>;
        mapWithContext<S>(function_: Internal.BiFunction_<T, boolean, S>): Internal.Couple<S>;
        map<S>(function_: Internal.Function_<T, S>): Internal.Couple<S>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Couple_<T> = Couple<T>;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Boots
    */
    class ArmorItemBuilder$Boots extends Internal.ArmorItemBuilder {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type ArmorItemBuilder$Boots_ = ArmorItemBuilder$Boots;
    /**
    * @javaClass net.minecraft.class_1959$class_1963
    */
    class Biome$Precipitation extends Internal.Enum<Internal.Biome$Precipitation> implements Internal.StringRepresentable {
        getName(): string;
        static valueOf($$0: string): Internal.Biome$Precipitation;
        static values(): Internal.Biome$Precipitation[];
        method_15434(): string;
        static byName($$0: string): Internal.Biome$Precipitation;
        static readonly "RAIN" : Internal.Biome$Precipitation;
        static readonly "CODEC" : Internal.Codec<Internal.Biome$Precipitation>;
        static readonly "SNOW" : Internal.Biome$Precipitation;
        static readonly "NONE" : Internal.Biome$Precipitation;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Biome$Precipitation_ = "rain" | "snow" | "none" | Biome$Precipitation;
    /**
    * @javaClass java.util.Vector
    */
    class Vector <E> extends Internal.AbstractList<E> implements Internal.List<E>, Internal.RandomAccess, Internal.Cloneable, Internal.Serializable {
        firstElement(): E;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        remove(arg0: number): E;
        remove(arg0: any): boolean;
        capacity(): number;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        iterator(): Internal.Iterator<E>;
        setSize(arg0: number): void;
        stream(): Internal.Stream<E>;
        setElementAt(arg0: E, arg1: number): void;
        hashCode(): number;
        get(arg0: number): E;
        removeElementAt(arg0: number): void;
        elementAt(arg0: number): E;
        toArray<T>(arg0: T[]): T[];
        toArray(): any[];
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<E>;
        indexOf(arg0: any): number;
        indexOf(arg0: any, arg1: number): number;
        removeAllElements(): void;
        add(arg0: E): boolean;
        add(arg0: number, arg1: E): void;
        subList(arg0: number, arg1: number): Internal.List<E>;
        trimToSize(): void;
        set(arg0: number, arg1: E): E;
        spliterator(): Internal.Spliterator<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        copyInto(arg0: any[]): void;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        isEmpty(): boolean;
        clear(): void;
        sort(arg0: Internal.Comparator_<E>): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        lastIndexOf(arg0: any, arg1: number): number;
        lastIndexOf(arg0: any): number;
        contains(arg0: any): boolean;
        insertElementAt(arg0: E, arg1: number): void;
        size(): number;
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        addAll(arg0: Internal.Collection_<E>): boolean;
        lastElement(): E;
        elements(): Internal.Enumeration<E>;
        equals(arg0: any): boolean;
        clone(): any;
        listIterator(): Internal.ListIterator<E>;
        listIterator(arg0: number): Internal.ListIterator<E>;
        toString(): string;
        addElement(arg0: E): void;
        ensureCapacity(arg0: number): void;
        removeElement(arg0: any): boolean;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.Collection<E>);
        constructor();
        constructor(arg0: number);
        constructor(arg0: number, arg1: number);
    }
    type Vector_<E> = Vector<E>;
    /**
    * @javaClass net.minecraft.class_270$class_272
    */
    class Team$Visibility extends Internal.Enum<Internal.Team$Visibility> {
        getDisplayName(): net.minecraft.network.chat.Component;
        static valueOf($$0: string): Internal.Team$Visibility;
        static values(): Internal.Team$Visibility[];
        static byName($$0: string): Internal.Team$Visibility;
        static getAllNames(): string[];
        static readonly "HIDE_FOR_OTHER_TEAMS" : Internal.Team$Visibility;
        static readonly "NEVER" : Internal.Team$Visibility;
        readonly "name" : string;
        readonly "id" : number;
        static readonly "ALWAYS" : Internal.Team$Visibility;
        static readonly "HIDE_FOR_OWN_TEAM" : Internal.Team$Visibility;
        get allNames(): string[];
        get displayName(): net.minecraft.network.chat.Component;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Team$Visibility_ = "always" | "never" | "hide_for_other_teams" | "hide_for_own_team" | Team$Visibility;
    /**
    * @javaClass net.minecraft.class_2693
    */
    class ClientboundOpenSignEditorPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getPos(): BlockPos;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get pos(): BlockPos;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundOpenSignEditorPacket_ = ClientboundOpenSignEditorPacket;
    /**
    * @javaClass net.minecraft.class_4597
    */
    interface MultiBufferSource {
        getBuffer(arg0: Internal.RenderType_): Internal.VertexConsumer;
        immediate($$0: Internal.BufferBuilder_): Internal.MultiBufferSource$BufferSource;
        immediateWithBuffers($$0: Internal.Map_<Internal.RenderType_, Internal.BufferBuilder_>, $$1: Internal.BufferBuilder_): Internal.MultiBufferSource$BufferSource;
    }
    type MultiBufferSource_ = MultiBufferSource;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.ui.input.KeyModifiers
    */
    class KeyModifiers {
        capsLock(): boolean;
        onlyControl(): boolean;
        shift(): boolean;
        alt(): boolean;
        start(): boolean;
        numLock(): boolean;
        control(): boolean;
        static readonly "NONE" : Internal.KeyModifiers;
        readonly "modifiers" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(m: number);
    }
    type KeyModifiers_ = KeyModifiers;
    /**
    * @javaClass dev.latvian.mods.kubejs.block.MaterialJS
    */
    class MaterialJS {
        getMinecraftMaterial(): net.minecraft.world.level.material.Material;
        getId(): string;
        getSound(): Internal.SoundType;
        get minecraftMaterial(): net.minecraft.world.level.material.Material;
        get sound(): Internal.SoundType;
        get id(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: string, m: net.minecraft.world.level.material.Material, s: Internal.SoundType);
    }
    type MaterialJS_ = "sponge" | "explosive" | "wool" | "ice" | "air" | "vegetable" | "clay" | "slime" | "lava" | "leaves" | "web" | "grass" | "cake" | "honey" | "wood" | "dragon_egg" | "portal" | "glass" | "metal" | "dirt" | "water" | "lantern" | "stone" | "sand" | "snow" | "plant" | "berry_bush" | "crop" | MaterialJS;
    /**
    * @javaClass net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt
    */
    interface Blaze3dRenderTargetExt {
        iris$getColorBufferVersion(): number;
        iris$getDepthBufferVersion(): number;
    }
    type Blaze3dRenderTargetExt_ = Blaze3dRenderTargetExt;
    /**
    * @javaClass me.shedaniel.rei.api.client.favorites.FavoriteEntry
    */
    abstract class FavoriteEntry implements Internal.RegionEntry<Internal.FavoriteEntry> {
        static fromEntryStack(stack: Internal.EntryStack_<any>): Internal.FavoriteEntry;
        getRenderer(arg0: boolean): Internal.Renderer;
        asFavorite(): this;
        static read(object: Internal.CompoundTag_): Internal.FavoriteEntry;
        getMenuEntries(): Internal.Optional<Internal.Supplier<Internal.Collection<Internal.FavoriteMenuEntry>>>;
        save(tag: Internal.CompoundTag_): Internal.CompoundTag;
        static delegateResult(supplier: Internal.Supplier_<Internal.DataResult_<Internal.FavoriteEntry_>>, toJson: Internal.Supplier_<Internal.CompoundTag_>): Internal.FavoriteEntry;
        toStack(): Internal.EntryStack<any>;
        isInvalid(): boolean;
        static delegate(supplier: Internal.Supplier_<Internal.FavoriteEntry_>, toJson: Internal.Supplier_<Internal.CompoundTag_>): Internal.FavoriteEntry;
        getType(): ResourceLocation;
        static readDelegated(object: Internal.CompoundTag_): Internal.FavoriteEntry;
        hashCode(): number;
        getUuid(): Internal.UUID;
        equals(o: any): boolean;
        getUnwrapped(): this;
        isSame(arg0: Internal.FavoriteEntry_): boolean;
        hashIgnoreAmount(): number;
        static readResult(object: Internal.CompoundTag_): Internal.DataResult<Internal.FavoriteEntry>;
        copy(): this;
        doAction(arg0: number): boolean;
        isEntryInvalid(): boolean;
        static readonly "TYPE_KEY" : "type";
        get menuEntries(): Internal.Optional<Internal.Supplier<Internal.Collection<Internal.FavoriteMenuEntry>>>;
        get entryInvalid(): boolean;
        get invalid(): boolean;
        get type(): ResourceLocation;
        get uuid(): Internal.UUID;
        get unwrapped(): this;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type FavoriteEntry_ = FavoriteEntry;
    /**
    * @javaClass dev.latvian.mods.kubejs.misc.VillagerTypeBuilder
    */
    class VillagerTypeBuilder extends Internal.BuilderBase<Internal.VillagerType> {
        getRegistryType(): Internal.RegistryObjectBuilderTypes<Internal.VillagerType>;
        createObject(): Internal.VillagerType;
        get registryType(): Internal.RegistryObjectBuilderTypes<Internal.VillagerType>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type VillagerTypeBuilder_ = VillagerTypeBuilder;
    /**
    * @javaClass net.minecraft.class_1627
    */
    class Stray extends Internal.AbstractSkeleton {
        canRiderInteract(): boolean;
        static checkStraySpawnRules($$0: Internal.EntityType_<Internal.Stray_>, $$1: Internal.ServerLevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.Random_): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getStepHeight(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Stray>, $$1: Internal.Level);
    }
    type Stray_ = Stray;
    /**
    * @javaClass java.awt.event.WindowFocusListener
    */
    interface WindowFocusListener extends Internal.EventListener {
        windowLostFocus(arg0: Internal.WindowEvent_): void;
        windowGainedFocus(arg0: Internal.WindowEvent_): void;
    }
    type WindowFocusListener_ = WindowFocusListener;
    /**
    * @javaClass xaero.common.gui.IScreenBase
    */
    interface IScreenBase {
        shouldSkipWorldRender(): boolean;
    }
    type IScreenBase_ = IScreenBase;
    /**
    * @javaClass java.awt.dnd.DragGestureEvent
    */
    class DragGestureEvent extends Internal.EventObject {
        getSourceAsDragGestureRecognizer(): Internal.DragGestureRecognizer;
        getDragAction(): number;
        iterator(): Internal.Iterator<Internal.InputEvent>;
        getTriggerEvent(): Internal.InputEvent;
        getDragOrigin(): Internal.Point;
        getDragSource(): Internal.DragSource;
        startDrag(arg0: Internal.Cursor_, arg1: Internal.Image_, arg2: Internal.Point_, arg3: Internal.Transferable_, arg4: Internal.DragSourceListener_): void;
        startDrag(arg0: Internal.Cursor_, arg1: Internal.Transferable_, arg2: Internal.DragSourceListener_): void;
        startDrag(arg0: Internal.Cursor_, arg1: Internal.Transferable_): void;
        toArray(arg0: any[]): any[];
        toArray(): any[];
        getComponent(): Internal.Component;
        get component(): Internal.Component;
        get sourceAsDragGestureRecognizer(): Internal.DragGestureRecognizer;
        get triggerEvent(): Internal.InputEvent;
        get dragAction(): number;
        get dragSource(): Internal.DragSource;
        get dragOrigin(): Internal.Point;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.DragGestureRecognizer, arg1: number, arg2: Internal.Point, arg3: Internal.List<Internal.InputEvent>);
    }
    type DragGestureEvent_ = DragGestureEvent;
    /**
    * @javaClass dev.latvian.mods.kubejs.block.custom.FenceBlockBuilder
    */
    class FenceBlockBuilder extends Internal.ShapedBlockBuilder {
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        createObject(): Internal.Block;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type FenceBlockBuilder_ = FenceBlockBuilder;
    /**
    * @javaClass it.unimi.dsi.fastutil.doubles.Double2LongFunction
    */
    interface Double2LongFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToLongFunction {
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Double2ShortFunction;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2LongFunction;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Double2IntFunction;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2LongFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        put(arg0: number, arg1: number): number;
        remove(arg0: number): number;
        remove(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Double2DoubleFunction;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        get(arg0: any): number;
        get(arg0: number): number;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2LongFunction;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Double2ByteFunction;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Double2FloatFunction;
        apply(arg0: number): number;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2LongFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2LongFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Double2CharFunction;
        applyAsLong(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2LongFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2LongFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2LongFunction;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
    }
    type Double2LongFunction_ = ((arg0: number) => number) | Double2LongFunction;
    /**
    * @javaClass dev.architectury.event.EventResult
    */
    class EventResult {
        interruptsFurtherEvaluation(): boolean;
        isTrue(): boolean;
        static pass(): Internal.EventResult;
        static interrupt(value: boolean): Internal.EventResult;
        isEmpty(): boolean;
        static interruptFalse(): Internal.EventResult;
        isPresent(): boolean;
        isFalse(): boolean;
        static interruptDefault(): Internal.EventResult;
        value(): boolean;
        asMinecraft(): Internal.InteractionResult;
        static interruptTrue(): Internal.EventResult;
        get true(): boolean;
        get false(): boolean;
        get present(): boolean;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type EventResult_ = EventResult;
    /**
    * @javaClass net.minecraft.class_5843
    */
    interface VerticalAnchor {
        belowTop($$0: number): this;
        top(): this;
        absolute($$0: number): this;
        bottom(): this;
        resolveY(arg0: Internal.WorldGenerationContext_): number;
        aboveBottom($$0: number): this;
    }
    type VerticalAnchor_ = VerticalAnchor;
    /**
    * @javaClass net.minecraft.class_787
    */
    class BlockFaceUV {
        getV($$0: number): number;
        getReverseIndex($$0: number): number;
        setMissingUv($$0: number[]): void;
        getU($$0: number): number;
        "uvs" : number[];
        readonly "rotation" : number;
        set missingUv($$0: number[]);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number[], $$1: number);
    }
    type BlockFaceUV_ = BlockFaceUV;
    /**
    * @javaClass dev.tr7zw.entityculling.access.Cullable
    */
    interface Cullable {
        setTimeout(): void;
        setOutOfCamera(arg0: boolean): void;
        isForcedVisible(): boolean;
        isOutOfCamera(): boolean;
        isCulled(): boolean;
        setCulled(arg0: boolean): void;
    }
    type Cullable_ = Cullable;
    /**
    * @javaClass me.shedaniel.clothconfig2.api.ScrollingContainer
    */
    abstract class ScrollingContainer {
        static ease(start: number, end: number, amount: number, easingMethod: Internal.EasingMethod_): number;
        updateDraggingState(mouseX: number, mouseY: number, button: number): boolean;
        getMaxScroll(): number;
        updatePosition(delta: number): void;
        getScrollBarX(): number;
        mouseDragged(mouseX: number, mouseY: number, button: number, dx: number, dy: number): boolean;
        mouseDragged(mouseX: number, mouseY: number, button: number, dx: number, dy: number, snapToRows: boolean, rowSize: number): boolean;
        offset(value: number, animated: boolean): void;
        hasScrollBar(): boolean;
        static clampExtension(v: number, maxScroll: number, clampExtension: number): number;
        static clampExtension(value: number, maxScroll: number): number;
        getMaxScrollHeight(): number;
        getScissorBounds(): me.shedaniel.math.Rectangle;
        static handleScrollingPosition(target: number[], scroll: number, maxScroll: number, delta: number, start: number, duration: number, bounceBackMultiplier: number, easingMethod: Internal.EasingMethod_): number;
        static handleScrollingPosition(target: number[], scroll: number, maxScroll: number, delta: number, start: number, duration: number): number;
        getBounds(): me.shedaniel.math.Rectangle;
        scrollTo(value: number, animated: boolean, duration: number): void;
        scrollTo(value: number, animated: boolean): void;
        clamp(v: number): number;
        clamp(v: number, clampExtension: number): number;
        renderScrollBar(): void;
        renderScrollBar(background: number, alpha: number, scrollBarAlphaOffset: number): void;
        "duration" : number;
        "start" : number;
        "draggingScrollBar" : boolean;
        "scrollAmount" : number;
        "scrollTarget" : number;
        get maxScrollHeight(): number;
        get scissorBounds(): me.shedaniel.math.Rectangle;
        get bounds(): me.shedaniel.math.Rectangle;
        get scrollBarX(): number;
        get maxScroll(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ScrollingContainer_ = ScrollingContainer;
    /**
    * @javaClass dev.architectury.registry.level.biome.BiomeModifications$BiomeContext
    */
    interface BiomeModifications$BiomeContext {
        getKey(): ResourceLocation;
        hasTag(arg0: Internal.TagKey_<Internal.Biome_>): boolean;
        getProperties(): Internal.BiomeProperties;
    }
    type BiomeModifications$BiomeContext_ = BiomeModifications$BiomeContext;
    /**
    * @javaClass dev.latvian.mods.kubejs.client.painter.PainterObjectStorage
    */
    class PainterObjectStorage {
        createScreenObjects(): any[];
        getObject(key: string): Internal.PainterObject;
        clear(): void;
        handle(root: Internal.CompoundTag_): void;
        remove(id: string): void;
        getObjects(): Internal.Collection<Internal.PainterObject>;
        get objects(): Internal.Collection<Internal.PainterObject>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type PainterObjectStorage_ = PainterObjectStorage;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.entity.CarriageSounds
    */
    class CarriageSounds {
        finalizeSharedVolume(volume: number): void;
        stop(): void;
        tick(dce: Internal.Carriage$DimensionalCarriageEntity_): void;
        submitSharedSoundVolume(location: Vec3_, volume: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(entity: Internal.CarriageContraptionEntity);
    }
    type CarriageSounds_ = CarriageSounds;
    /**
    * @javaClass java.util.stream.IntStream
    */
    interface IntStream extends Internal.BaseStream<number, Internal.IntStream> {
        average(): Internal.OptionalDouble;
        sequential(): this;
        takeWhile(arg0: Internal.IntPredicate_): this;
        distinct(): this;
        range(arg0: number, arg1: number): this;
        findFirst(): Internal.OptionalInt;
        sum(): number;
        skip(arg0: number): this;
        asLongStream(): Internal.LongStream;
        allMatch(arg0: Internal.IntPredicate_): boolean;
        mapToObj<U>(arg0: Internal.IntFunction_<U>): Internal.Stream<U>;
        empty(): this;
        mapMulti(arg0: Internal.IntStream$IntMapMultiConsumer_): this;
        iterator(): Internal.PrimitiveIterator$OfInt;
        asDoubleStream(): Internal.DoubleStream;
        min(): Internal.OptionalInt;
        mapToLong(arg0: Internal.IntToLongFunction_): Internal.LongStream;
        parallel(): this;
        noneMatch(arg0: Internal.IntPredicate_): boolean;
        findAny(): Internal.OptionalInt;
        of(arg0: number): this;
        of(...arg0: number[]): this;
        limit(arg0: number): this;
        builder(): Internal.IntStream$Builder;
        toArray(): number[];
        forEachOrdered(arg0: Internal.IntConsumer_): void;
        generate(arg0: Internal.IntSupplier_): this;
        anyMatch(arg0: Internal.IntPredicate_): boolean;
        map(arg0: Internal.IntUnaryOperator_): this;
        mapToDouble(arg0: Internal.IntToDoubleFunction_): Internal.DoubleStream;
        iterate(arg0: number, arg1: Internal.IntUnaryOperator_): this;
        iterate(arg0: number, arg1: Internal.IntPredicate_, arg2: Internal.IntUnaryOperator_): this;
        reduce(arg0: number, arg1: Internal.IntBinaryOperator_): number;
        reduce(arg0: Internal.IntBinaryOperator_): Internal.OptionalInt;
        spliterator(): Internal.Spliterator$OfInt;
        max(): Internal.OptionalInt;
        forEach(arg0: Internal.IntConsumer_): void;
        count(): number;
        concat(arg0: Internal.IntStream_, arg1: Internal.IntStream_): this;
        dropWhile(arg0: Internal.IntPredicate_): this;
        peek(arg0: Internal.IntConsumer_): this;
        flatMap(arg0: Internal.IntFunction_<Internal.IntStream_>): this;
        filter(arg0: Internal.IntPredicate_): this;
        sorted(): this;
        boxed(): Internal.Stream<number>;
        summaryStatistics(): Internal.IntSummaryStatistics;
        rangeClosed(arg0: number, arg1: number): this;
        collect<R>(arg0: Internal.Supplier_<R>, arg1: Internal.ObjIntConsumer_<R>, arg2: Internal.BiConsumer_<R, R>): R;
    }
    type IntStream_ = IntStream;
    /**
    * @javaClass com.jozufozu.flywheel.api.vertex.VertexType
    */
    interface VertexType {
        createWriter(arg0: Internal.ByteBuffer_): Internal.VertexWriter;
        getLayout(): Internal.BufferLayout;
        getStride(): number;
        byteOffset(vertexIndex: number): number;
        createReader(arg0: Internal.ByteBuffer_, arg1: number): Internal.VertexList;
        getShaderHeader(): string;
    }
    type VertexType_ = VertexType;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.Object2IntMap
    */
    interface Object2IntMap <K> extends Internal.Object2IntFunction<K>, Internal.Map<K, number> {
        getOrDefault(arg0: any, arg1: number): number;
        computeIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        computeIfAbsent(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
        values(): Internal.IntCollection;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        replace(arg0: K, arg1: number, arg2: number): boolean;
        replace(arg0: K, arg1: number): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        andThenInt(arg0: Internal.Int2IntFunction_): Internal.Object2IntFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        containsValue(arg0: any): boolean;
        containsValue(arg0: number): boolean;
        put(arg0: K, arg1: number): number;
        remove(arg0: any, arg1: any): boolean;
        remove(arg0: any): number;
        remove(arg0: any, arg1: number): boolean;
        mergeInt(arg0: K, arg1: number, arg2: it.unimi.dsi.fastutil.ints.IntBinaryOperator_): number;
        mergeInt(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        mergeInt(arg0: K, arg1: number, arg2: Internal.IntBinaryOperator_): number;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        defaultReturnValue(): number;
        defaultReturnValue(arg0: number): void;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        get(arg0: any): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        computeInt(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        keySet(): Internal.ObjectSet<K>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        object2IntEntrySet(): Internal.ObjectSet<Internal.Object2IntMap$Entry<K>>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        applyAsInt(arg0: K): number;
        computeIntIfAbsentPartial(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        removeInt(arg0: any): number;
        apply(arg0: K): number;
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, number>>;
        containsKey(arg0: any): boolean;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        computeIntIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        size(): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        computeIntIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        putIfAbsent(arg0: K, arg1: number): number;
    }
    type Object2IntMap_<K> = Object2IntMap<K>;
    /**
    * @javaClass net.bettercombat.mixin.client.MinecraftClientAccessor
    */
    interface MinecraftClientAccessor {
        getEntityRenderDispatcher(): Internal.EntityRenderDispatcher;
        getAttackCooldown(): number;
        setAttackCooldown(arg0: number): void;
    }
    type MinecraftClientAccessor_ = MinecraftClientAccessor;
    /**
    * @javaClass dev.latvian.mods.kubejs.script.ScriptPack
    */
    class ScriptPack {
        readonly "manager" : Internal.ScriptManager;
        "scope" : Internal.Scriptable;
        "context" : Internal.Context;
        readonly "scripts" : Internal.List<Internal.ScriptFile>;
        readonly "info" : Internal.ScriptPackInfo;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(m: Internal.ScriptManager, i: Internal.ScriptPackInfo);
    }
    type ScriptPack_ = ScriptPack;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint
    */
    abstract class TrackEdgePoint {
        read(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        read(nbt: Internal.CompoundTag_, migration: boolean, dimensions: Internal.DimensionPalette_): void;
        tileAdded(arg0: Internal.BlockEntity_, arg1: boolean): void;
        getId(): Internal.UUID;
        invalidate(arg0: Internal.LevelAccessor_): void;
        tick(graph: Internal.TrackGraph_, preTrains: boolean): void;
        setType(type: Internal.EdgePointType_<any>): void;
        getLocationOn(edge: Internal.TrackEdge_): number;
        canNavigateVia(side: Internal.TrackNode_): boolean;
        tileRemoved(arg0: BlockPos_, arg1: boolean): void;
        setLocation(nodes: Internal.Couple_<Internal.TrackNodeLocation_>, position: number): void;
        getType(): Internal.EdgePointType<any>;
        isPrimary(node1: Internal.TrackNode_): boolean;
        canCoexistWith(otherType: Internal.EdgePointType_<any>, front: boolean): boolean;
        setId(id: Internal.UUID_): void;
        canMerge(): boolean;
        onRemoved(graph: Internal.TrackGraph_): void;
        write(nbt: Internal.CompoundTag_, dimensions: Internal.DimensionPalette_): void;
        write(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        "edgeLocation" : Internal.Couple<Internal.TrackNodeLocation>;
        "id" : Internal.UUID;
        "position" : number;
        get type(): Internal.EdgePointType<any>;
        set type(type: Internal.EdgePointType_<any>);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type TrackEdgePoint_ = TrackEdgePoint;
    /**
    * @javaClass net.minecraft.class_2675
    */
    class ClientboundLevelParticlesPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getXDist(): number;
        getX(): number;
        getY(): number;
        isOverrideLimiter(): boolean;
        getZ(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getParticle(): Internal.ParticleOptions;
        getMaxSpeed(): number;
        isSkippable(): boolean;
        getCount(): number;
        getYDist(): number;
        getZDist(): number;
        get overrideLimiter(): boolean;
        get xDist(): number;
        get yDist(): number;
        get zDist(): number;
        get x(): number;
        get count(): number;
        get y(): number;
        get z(): number;
        get particle(): Internal.ParticleOptions;
        get maxSpeed(): number;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: T, $$1: boolean, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundLevelParticlesPacket_ = ClientboundLevelParticlesPacket;
    /**
    * @javaClass de.keksuccino.konkrete.mixin.mixins.client.IMixinEditBox
    */
    interface IMixinEditBox {
        getIsEditableKonkrete(): boolean;
        onValueChangeInvokerKonkrete(arg0: string): void;
        getHighlightPosKonkrete(): number;
        getMaxLengthKonkrete(): number;
    }
    type IMixinEditBox_ = IMixinEditBox;
    /**
    * @javaClass dev.latvian.mods.kubejs.command.ArgumentTypeWrapper
    */
    class ArgumentTypeWrapper extends Internal.Enum<Internal.ArgumentTypeWrapper> {
        static valueOf(name: string): Internal.ArgumentTypeWrapper;
        getResult(context: Internal.CommandContext_<Internal.CommandSourceStack_>, input: string): any;
        static values(): Internal.ArgumentTypeWrapper[];
        create(event: Internal.CommandRegistryEventJS_): Internal.ArgumentType<any>;
        create(): Internal.ArgumentType<any>;
        static byName(name: ResourceLocation_): typeof any;
        static printAll(): void;
        static readonly "ROTATION" : Internal.ArgumentTypeWrapper;
        static readonly "VEC2_CENTERED" : Internal.ArgumentTypeWrapper;
        static readonly "FLOAT" : Internal.ArgumentTypeWrapper;
        static readonly "PARTICLE" : Internal.ArgumentTypeWrapper;
        static readonly "INT_RANGE" : Internal.ArgumentTypeWrapper;
        static readonly "BLOCK_STATE" : Internal.ArgumentTypeWrapper;
        static readonly "NBT_TAG" : Internal.ArgumentTypeWrapper;
        static readonly "NBT_PATH" : Internal.ArgumentTypeWrapper;
        static readonly "ANGLE" : Internal.ArgumentTypeWrapper;
        static readonly "ITEM_PREDICATE" : Internal.ArgumentTypeWrapper;
        static readonly "BLOCK_POS_LOADED" : Internal.ArgumentTypeWrapper;
        static readonly "BLOCK_POS" : Internal.ArgumentTypeWrapper;
        static readonly "MESSAGE" : Internal.ArgumentTypeWrapper;
        static readonly "ITEM_SLOT" : Internal.ArgumentTypeWrapper;
        static readonly "ENTITY" : Internal.ArgumentTypeWrapper;
        static readonly "BLOCK_PREDICATE" : Internal.ArgumentTypeWrapper;
        static readonly "DIMENSION" : Internal.ArgumentTypeWrapper;
        static readonly "VEC2" : Internal.ArgumentTypeWrapper;
        static readonly "COLOR" : Internal.ArgumentTypeWrapper;
        static readonly "VEC3" : Internal.ArgumentTypeWrapper;
        static readonly "ITEM_STACK" : Internal.ArgumentTypeWrapper;
        static readonly "SWIZZLE" : Internal.ArgumentTypeWrapper;
        static readonly "DOUBLE" : Internal.ArgumentTypeWrapper;
        static readonly "ENTITIES" : Internal.ArgumentTypeWrapper;
        static readonly "UUID" : Internal.ArgumentTypeWrapper;
        static readonly "INTEGER" : Internal.ArgumentTypeWrapper;
        static readonly "LONG" : Internal.ArgumentTypeWrapper;
        static readonly "WORD" : Internal.ArgumentTypeWrapper;
        static readonly "ITEM_ENCHANTMENT" : Internal.ArgumentTypeWrapper;
        static readonly "VEC3_CENTERED" : Internal.ArgumentTypeWrapper;
        static readonly "TIME" : Internal.ArgumentTypeWrapper;
        static readonly "GREEDY_STRING" : Internal.ArgumentTypeWrapper;
        static readonly "NBT_COMPOUND" : Internal.ArgumentTypeWrapper;
        static readonly "BOOLEAN" : Internal.ArgumentTypeWrapper;
        static readonly "PLAYER" : Internal.ArgumentTypeWrapper;
        static readonly "RESOURCE_LOCATION" : Internal.ArgumentTypeWrapper;
        static readonly "FLOAT_RANGE" : Internal.ArgumentTypeWrapper;
        static readonly "PLAYERS" : Internal.ArgumentTypeWrapper;
        static readonly "ENTITY_SUMMON" : Internal.ArgumentTypeWrapper;
        static readonly "GAME_PROFILE" : Internal.ArgumentTypeWrapper;
        static readonly "COLUMN_POS" : Internal.ArgumentTypeWrapper;
        static readonly "STRING" : Internal.ArgumentTypeWrapper;
        static readonly "COMPONENT" : Internal.ArgumentTypeWrapper;
        static readonly "MOB_EFFECT" : Internal.ArgumentTypeWrapper;
        static readonly "ENTITY_ANCHOR" : Internal.ArgumentTypeWrapper;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ArgumentTypeWrapper_ = "swizzle" | "nbt_path" | "string" | "color" | "item_slot" | "integer" | "mob_effect" | "float" | "uuid" | "long" | "resource_location" | "block_pos_loaded" | "block_predicate" | "game_profile" | "angle" | "particle" | "int_range" | "dimension" | "nbt_compound" | "player" | "double" | "greedy_string" | "players" | "float_range" | "block_pos" | "rotation" | "vec3" | "vec2" | "message" | "nbt_tag" | "column_pos" | "vec2_centered" | "vec3_centered" | "component" | "boolean" | "item_enchantment" | "entities" | "block_state" | "entity_summon" | "item_stack" | "entity_anchor" | "time" | "word" | "entity" | "item_predicate" | ArgumentTypeWrapper;
    /**
    * @javaClass net.minecraft.class_5357
    */
    class UpgradeRecipe implements Internal.Recipe<net.minecraft.world.Container>, Internal.SmithingRecipeAccessor, vazkii.patchouli.mixin.AccessorSmithingRecipe, Internal.AccessorSmithingRecipe {
        isAdditionIngredient($$0: Internal.ItemStack_): boolean;
        getRemainingItems(inventory: net.minecraft.world.Container_): Internal.NonNullList<any>;
        method_31584(): boolean;
        method_17716(): Internal.RecipeType<any>;
        isSpecial(): boolean;
        method_8110(): Internal.ItemStack;
        getGroup(): string;
        method_8115($$0: net.minecraft.world.Container_, $$1: Internal.Level_): boolean;
        method_8114(): ResourceLocation;
        method_8113($$0: number, $$1: number): boolean;
        handler$hbn000$getRemainder(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>): void;
        method_8119(): Internal.RecipeSerializer<any>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        method_17447(): Internal.ItemStack;
        method_8116($$0: net.minecraft.world.Container_): Internal.ItemStack;
        readonly "base" : Internal.Ingredient;
        readonly "addition" : Internal.Ingredient;
        get special(): boolean;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>;
        get group(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: ResourceLocation, $$1: Internal.Ingredient, $$2: Internal.Ingredient, $$3: Internal.ItemStack);
    }
    type UpgradeRecipe_ = UpgradeRecipe;
    /**
    * @javaClass it.unimi.dsi.fastutil.doubles.DoubleCollection
    */
    interface DoubleCollection extends Internal.Collection<number>, Internal.DoubleIterable {
        add(arg0: number): boolean;
        spliterator(): Internal.DoubleSpliterator;
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: Internal.DoubleConsumer_): void;
        forEach(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        containsAll(arg0: Internal.DoubleCollection_): boolean;
        doubleSpliterator(): Internal.DoubleSpliterator;
        doubleStream(): Internal.DoubleStream;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): boolean;
        doubleParallelStream(): Internal.DoubleStream;
        removeAll(arg0: Internal.DoubleCollection_): boolean;
        contains(arg0: number): boolean;
        contains(arg0: any): boolean;
        iterator(): Internal.DoubleIterator;
        addAll(arg0: Internal.DoubleCollection_): boolean;
        stream(): Internal.Stream<number>;
        toDoubleArray(arg0: number[]): number[];
        toDoubleArray(): number[];
        toArray(arg0: number[]): number[];
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<number>;
        rem(arg0: number): boolean;
        doubleIterator(): Internal.DoubleIterator;
        retainAll(arg0: Internal.DoubleCollection_): boolean;
    }
    type DoubleCollection_ = DoubleCollection;
    /**
    * @javaClass net.fabricmc.fabric.impl.transfer.item.SpecialLogicInventory
    */
    interface SpecialLogicInventory {
        fabric_setSuppress(arg0: boolean): void;
        fabric_onFinalCommit(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_): void;
    }
    type SpecialLogicInventory_ = SpecialLogicInventory;
    /**
    * @javaClass dev.latvian.mods.kubejs.misc.BasicMobEffect$Builder
    */
    class BasicMobEffect$Builder extends Internal.MobEffectBuilder {
        createObject(): Internal.MobEffect;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type BasicMobEffect$Builder_ = BasicMobEffect$Builder;
    /**
    * @javaClass net.minecraft.class_1144
    */
    class SoundManager extends Internal.SimplePreparableReloadListener<any> implements Internal.IMixinSoundManager, Internal.SoundManagerAccessor, Internal.IdentifiableResourceReloadListener {
        play($$0: Internal.SoundInstance_): void;
        resume(): void;
        getName(): string;
        getSoundEvent($$0: ResourceLocation_): Internal.WeighedSoundEvents;
        playDelayed($$0: Internal.SoundInstance_, $$1: number): void;
        destroy(): void;
        tick($$0: boolean): void;
        removeListener($$0: Internal.SoundEventListener_): void;
        updateSourceVolume($$0: Internal.SoundSource_, $$1: number): void;
        isActive($$0: Internal.SoundInstance_): boolean;
        getAvailableSoundDevices(): Internal.List<string>;
        pause(): void;
        reload(): void;
        getDebugString(): string;
        updateSource($$0: Internal.Camera_): void;
        queueTickingSound($$0: Internal.TickableSoundInstance_): void;
        stop($$0: ResourceLocation_, $$1: Internal.SoundSource_): void;
        stop($$0: Internal.SoundInstance_): void;
        stop(): void;
        getFabricId(): ResourceLocation;
        getAvailableSounds(): Internal.Collection<ResourceLocation>;
        getFabricDependencies(): Internal.Collection<any>;
        addListener($$0: Internal.SoundEventListener_): void;
        static readonly "EMPTY_SOUND" : Internal.Sound;
        readonly "soundEngine" : Internal.SoundEngine;
        get fabricDependencies(): Internal.Collection<any>;
        get debugString(): string;
        get availableSoundDevices(): Internal.List<string>;
        get fabricId(): ResourceLocation;
        get availableSounds(): Internal.Collection<ResourceLocation>;
        get name(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ResourceManager, $$1: Internal.Options);
    }
    type SoundManager_ = SoundManager;
    /**
    * @javaClass com.mojang.authlib.minecraft.UserApiService$UserFlag
    */
    class UserApiService$UserFlag extends Internal.Enum<Internal.UserApiService$UserFlag> {
        static valueOf(arg0: string): Internal.UserApiService$UserFlag;
        static values(): Internal.UserApiService$UserFlag[];
        static readonly "CHAT_ALLOWED" : Internal.UserApiService$UserFlag;
        static readonly "TELEMETRY_ENABLED" : Internal.UserApiService$UserFlag;
        static readonly "REALMS_ALLOWED" : Internal.UserApiService$UserFlag;
        static readonly "PROFANITY_FILTER_ENABLED" : Internal.UserApiService$UserFlag;
        static readonly "SERVERS_ALLOWED" : Internal.UserApiService$UserFlag;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type UserApiService$UserFlag_ = "telemetry_enabled" | "profanity_filter_enabled" | "realms_allowed" | "chat_allowed" | "servers_allowed" | UserApiService$UserFlag;
    /**
    * @javaClass net.minecraft.class_1512
    */
    abstract class AbstractDragonPhaseInstance implements Internal.DragonPhaseInstance {
        method_6846(): number;
        method_6847(): number;
        method_6855(): void;
        method_6856(): void;
        method_6848(): boolean;
        method_6850($$0: Internal.EndCrystal_, $$1: BlockPos_, $$2: Internal.DamageSource_, $$3: Internal.Player_): void;
        method_6853(): void;
        method_6854(): void;
        method_6851(): Vec3;
        method_6852($$0: Internal.DamageSource_, $$1: number): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EnderDragon);
    }
    type AbstractDragonPhaseInstance_ = AbstractDragonPhaseInstance;
    /**
    * @javaClass dev.latvian.mods.kubejs.util.MapJS
    */
    class MapJS extends Internal.LinkedHashMap<string, any> implements Internal.StringBuilderAppendable, Internal.ChangeListener<any>, Internal.Copyable, Internal.JsonSerializable, Internal.NBTSerializable {
        static nbt(map: any): Internal.CompoundTag;
        appendString(builder: Internal.StringBuilder_): void;
        onChanged(o: any): void;
        containsAll(other: Internal.MapJS_): boolean;
        containsAny(other: Internal.MapJS_): boolean;
        clear(): void;
        put(key: string, value: any): any;
        remove(key: any): any;
        toJson(): Internal.JsonObject;
        toNBT(): Internal.CompoundTag;
        getOrNewList(id: string): Internal.ListJS;
        getOrNewMap(id: string): this;
        putAll(m: Internal.Map_<string, any>): void;
        static of(o: any): Internal.MapJS;
        static json(map: any): Internal.JsonObject;
        getLength(): number;
        toString(): string;
        copy(): this;
        "changeListener" : ((arg0: Internal.MapJS) => void);
        get length(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
        constructor(s: number);
    }
    type MapJS_ = MapJS;
    /**
    * @javaClass net.minecraft.class_4660
    */
    class CocoaDecorator extends Internal.TreeDecorator {
        method_23469($$0: Internal.LevelSimulatedReader_, $$1: Internal.BiConsumer_<BlockPos_, Internal.BlockState_>, $$2: Internal.Random_, $$3: Internal.List_<BlockPos_>, $$4: Internal.List_<BlockPos_>): void;
        static readonly "CODEC" : Internal.Codec<Internal.CocoaDecorator>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number);
    }
    type CocoaDecorator_ = CocoaDecorator;
    /**
    * @javaClass java.io.Reader
    */
    abstract class Reader implements Internal.Readable, Internal.Closeable {
        read(arg0: string[]): number;
        read(arg0: string[], arg1: number, arg2: number): number;
        read(arg0: Internal.CharBuffer_): number;
        read(): number;
        static nullReader(): Internal.Reader;
        ready(): boolean;
        markSupported(): boolean;
        reset(): void;
        skip(arg0: number): number;
        transferTo(arg0: Internal.Writer_): number;
        close(): void;
        mark(arg0: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Reader_ = Reader;
    /**
    * @javaClass net.minecraft.class_846$class_4690
    */
    class ChunkRenderDispatcher$ChunkTaskResult extends Internal.Enum<Internal.ChunkRenderDispatcher$ChunkTaskResult> {
        static valueOf($$0: string): Internal.ChunkRenderDispatcher$ChunkTaskResult;
        static values(): Internal.ChunkRenderDispatcher$ChunkTaskResult[];
        static readonly "CANCELLED" : null;
        static readonly "SUCCESSFUL" : null;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ChunkRenderDispatcher$ChunkTaskResult_ = "cancelled" | "successful" | ChunkRenderDispatcher$ChunkTaskResult;
    /**
    * @javaClass it.unimi.dsi.fastutil.shorts.Short2IntFunction
    */
    interface Short2IntFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntUnaryOperator {
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Short2ShortFunction;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2IntFunction;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2IntFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        put(arg0: number, arg1: number): number;
        remove(arg0: number): number;
        remove(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Short2DoubleFunction;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        get(arg0: any): number;
        get(arg0: number): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Short2LongFunction;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Short2ByteFunction;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Short2FloatFunction;
        applyAsInt(arg0: number): number;
        apply(arg0: number): number;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2IntFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2IntFunction;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Short2CharFunction;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2IntFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2IntFunction;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2IntFunction;
    }
    type Short2IntFunction_ = ((arg0: number) => number) | Short2IntFunction;
    /**
    * @javaClass java.awt.Color
    */
    class Color implements Internal.Paint, Internal.Serializable {
        brighter(): this;
        static getColor(arg0: string, arg1: number): Internal.Color;
        static getColor(arg0: string, arg1: Internal.Color_): Internal.Color;
        static getColor(arg0: string): Internal.Color;
        static HSBtoRGB(arg0: number, arg1: number, arg2: number): number;
        static decode(arg0: string): Internal.Color;
        getColorSpace(): Internal.ColorSpace;
        getBlue(): number;
        createContext(arg0: Internal.ColorModel_, arg1: Internal.Rectangle_, arg2: Internal.Rectangle2D_, arg3: Internal.AffineTransform_, arg4: Internal.RenderingHints_): Internal.PaintContext;
        getRGBColorComponents(arg0: number[]): number[];
        getTransparency(): number;
        getAlpha(): number;
        getColorComponents(arg0: number[]): number[];
        getColorComponents(arg0: Internal.ColorSpace_, arg1: number[]): number[];
        getGreen(): number;
        darker(): this;
        getRed(): number;
        getRGBComponents(arg0: number[]): number[];
        hashCode(): number;
        equals(arg0: any): boolean;
        getComponents(arg0: number[]): number[];
        getComponents(arg0: Internal.ColorSpace_, arg1: number[]): number[];
        toString(): string;
        static RGBtoHSB(arg0: number, arg1: number, arg2: number, arg3: number[]): number[];
        static getHSBColor(arg0: number, arg1: number, arg2: number): Internal.Color;
        getRGB(): number;
        static readonly "lightGray" : Internal.Color;
        static readonly "magenta" : Internal.Color;
        static readonly "GRAY" : Internal.Color;
        static readonly "pink" : Internal.Color;
        static readonly "BLUE" : Internal.Color;
        static readonly "yellow" : Internal.Color;
        static readonly "cyan" : Internal.Color;
        static readonly "red" : Internal.Color;
        static readonly "gray" : Internal.Color;
        static readonly "PINK" : Internal.Color;
        static readonly "white" : Internal.Color;
        static readonly "BLACK" : Internal.Color;
        static readonly "ORANGE" : Internal.Color;
        static readonly "WHITE" : Internal.Color;
        static readonly "green" : Internal.Color;
        static readonly "black" : Internal.Color;
        static readonly "GREEN" : Internal.Color;
        static readonly "RED" : Internal.Color;
        static readonly "orange" : Internal.Color;
        static readonly "LIGHT_GRAY" : Internal.Color;
        static readonly "blue" : Internal.Color;
        static readonly "darkGray" : Internal.Color;
        static readonly "MAGENTA" : Internal.Color;
        static readonly "YELLOW" : Internal.Color;
        static readonly "DARK_GRAY" : Internal.Color;
        static readonly "CYAN" : Internal.Color;
        get colorSpace(): Internal.ColorSpace;
        get transparency(): number;
        get alpha(): number;
        get rGB(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: number, arg1: number, arg2: number, arg3: number);
        constructor(arg0: number);
        constructor(arg0: number, arg1: boolean);
        constructor(arg0: number, arg1: number, arg2: number);
        constructor(arg0: number, arg1: number, arg2: number);
        constructor(arg0: Internal.ColorSpace, arg1: number[], arg2: number);
        constructor(arg0: number, arg1: number, arg2: number, arg3: number);
    }
    type Color_ = Color;
    /**
    * @javaClass java.lang.Enum
    */
    abstract class Enum <E> implements Internal.Constable, Internal.Comparable<E>, Internal.Serializable {
        getDeclaringClass(): typeof E;
        static valueOf<T>(arg0: Internal.Class_<T>, arg1: string): T;
        hashCode(): number;
        equals(arg0: any): boolean;
        name(): string;
        toString(): string;
        compareTo(arg0: E): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<E>>;
        ordinal(): number;
        get declaringClass(): typeof E;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Enum_<E> = Enum<E>;
    /**
    * @javaClass vazkii.botania.mixin.client.AccessorRenderType
    */
    interface AccessorRenderType {
    }
    type AccessorRenderType_ = AccessorRenderType;
    /**
    * Fired when you need to modify properties of a block.
    * @javaClass dev.latvian.mods.kubejs.block.BlockModificationEventJS
    */
    class BlockModificationEventJS extends Internal.EventJS {
        modify(predicate: BlockStatePredicate_, c: Internal.Consumer_<Internal.BlockModificationProperties_>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    /**
    * Fired when you need to modify properties of a block.
    */
    type BlockModificationEventJS_ = BlockModificationEventJS;
    /**
    * @javaClass dev.latvian.mods.kubejs.block.custom.StairBlockBuilder
    */
    class StairBlockBuilder extends Internal.ShapedBlockBuilder {
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        createObject(): Internal.Block;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type StairBlockBuilder_ = StairBlockBuilder;
    /**
    * @javaClass dev.architectury.fluid.FluidStack
    */
    class FluidStack {
        getRawFluidSupplier(): Internal.Supplier<Internal.Fluid>;
        getRawFluid(): Internal.Fluid;
        getName(): net.minecraft.network.chat.Component;
        isTagEqual(other: Internal.FluidStack_): boolean;
        getOrCreateChildTag(childName: string): Internal.CompoundTag;
        copyWithAmount(amount: number): this;
        static empty(): Internal.FluidStack;
        getChildTag(childName: string): Internal.CompoundTag;
        hashCode(): number;
        static create(stack: Internal.FluidStack_, amount: number): Internal.FluidStack;
        static create(fluid: Internal.Supplier_<Internal.Fluid_>, amount: number, tag: Internal.CompoundTag_): Internal.FluidStack;
        static create(fluid: Internal.Supplier_<Internal.Fluid_>, amount: number): Internal.FluidStack;
        static create(fluid: Internal.Fluid_, amount: number, tag: Internal.CompoundTag_): Internal.FluidStack;
        static create(fluid: Internal.Fluid_, amount: number): Internal.FluidStack;
        setTag(tag: Internal.CompoundTag_): void;
        copy(): this;
        setAmount(amount: number): void;
        write(tag: Internal.CompoundTag_): Internal.CompoundTag;
        write(buf: Internal.FriendlyByteBuf_): void;
        isFluidEqual(other: Internal.FluidStack_): boolean;
        getAmount(): number;
        static init(): void;
        removeChildTag(childName: string): void;
        grow(amount: number): void;
        static read(buf: Internal.FriendlyByteBuf_): Internal.FluidStack;
        static read(tag: Internal.CompoundTag_): Internal.FluidStack;
        hasTag(): boolean;
        shrink(amount: number): void;
        getTranslationKey(): string;
        isEmpty(): boolean;
        getTag(): Internal.CompoundTag;
        isFluidStackEqual(other: Internal.FluidStack_): boolean;
        static bucketAmount(): number;
        getOrCreateTag(): Internal.CompoundTag;
        equals(o: any): boolean;
        getFluid(): Internal.Fluid;
        get orCreateTag(): Internal.CompoundTag;
        get rawFluid(): Internal.Fluid;
        get amount(): number;
        get rawFluidSupplier(): Internal.Supplier<Internal.Fluid>;
        get translationKey(): string;
        get name(): net.minecraft.network.chat.Component;
        get fluid(): Internal.Fluid;
        get tag(): Internal.CompoundTag;
        set amount(amount: number);
        set tag(tag: Internal.CompoundTag_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FluidStack_ = FluidStack;
    /**
    * @javaClass snownee.lychee.mixin.IntsAccess
    */
    interface IntsAccess {
    }
    type IntsAccess_ = IntsAccess;
    /**
    * @javaClass net.fabricmc.fabric.mixin.networking.accessor.CustomPayloadC2SPacketAccessor
    */
    interface CustomPayloadC2SPacketAccessor {
        getChannel(): ResourceLocation;
        getData(): Internal.FriendlyByteBuf;
    }
    type CustomPayloadC2SPacketAccessor_ = CustomPayloadC2SPacketAccessor;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.util.NonNullFunction
    */
    interface NonNullFunction <T, R> extends Internal.Function<T, R> {
        compose<V>(arg0: Internal.Function_<V, T>): Internal.Function<V, R>;
        andThen<V>(after: Internal.NonNullFunction_<R, V>): Internal.NonNullFunction<T, V>;
        andThen<V>(arg0: Internal.Function_<R, V>): Internal.Function<T, V>;
    }
    type NonNullFunction_<T, R> = NonNullFunction<T, R>;
    /**
    * @javaClass it.unimi.dsi.fastutil.floats.FloatCollection
    */
    interface FloatCollection extends Internal.Collection<number>, Internal.FloatIterable {
        add(arg0: number): boolean;
        spliterator(): Internal.FloatSpliterator;
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: Internal.FloatConsumer_): void;
        forEach(arg0: Internal.DoubleConsumer_): void;
        containsAll(arg0: Internal.FloatCollection_): boolean;
        doubleSpliterator(): Internal.DoubleSpliterator;
        toFloatArray(arg0: number[]): number[];
        toFloatArray(): number[];
        doubleStream(): Internal.DoubleStream;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.FloatPredicate_): boolean;
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        doubleParallelStream(): Internal.DoubleStream;
        removeAll(arg0: Internal.FloatCollection_): boolean;
        contains(arg0: number): boolean;
        contains(arg0: any): boolean;
        iterator(): Internal.FloatIterator;
        addAll(arg0: Internal.FloatCollection_): boolean;
        stream(): Internal.Stream<number>;
        toArray(arg0: number[]): number[];
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<number>;
        rem(arg0: number): boolean;
        doubleIterator(): Internal.DoubleIterator;
        retainAll(arg0: Internal.FloatCollection_): boolean;
    }
    type FloatCollection_ = FloatCollection;
    /**
    * @javaClass net.minecraft.class_1543
    */
    abstract class AbstractIllager extends Internal.Raider {
        canRiderInteract(): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getStepHeight(): number;
        method_18395($$0: Internal.LivingEntity_): boolean;
        method_6046(): Internal.MobType;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        getArmPose(): Internal.AbstractIllager$IllagerArmPose;
        get armPose(): Internal.AbstractIllager$IllagerArmPose;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractIllager_ = AbstractIllager;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMapData
    */
    interface StationMapData {
        toggleStation(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.StationTileEntity_): boolean;
        addStationMarker(arg0: Internal.StationMarker_): void;
    }
    type StationMapData_ = StationMapData;
    /**
    * @javaClass java.util.PrimitiveIterator
    */
    interface PrimitiveIterator <T, T_CONS> extends Internal.Iterator<T> {
        forEachRemaining(arg0: T_CONS): void;
        forEachRemaining(arg0: Internal.Consumer_<T>): void;
        remove(): void;
    }
    type PrimitiveIterator_<T, T_CONS> = PrimitiveIterator<T, T_CONS>;
    /**
    * @javaClass net.minecraft.server.MinecraftServer
    */
    abstract class MinecraftServer extends Internal.ReentrantBlockableEventLoop<Internal.TickTask> implements Internal.CommandSource, Internal.AutoCloseable, io.github.fabricators_of_create.porting_lib.mixin.common.accessor.MinecraftServerAccessor, Internal.MinecraftServerKJS, de.siphalor.tweed4.mixin.MinecraftServerAccessor, Internal.MinecraftServerAccessor {
        publishServer($$0: Internal.GameType_, $$1: boolean, $$2: number): boolean;
        onServerExit(): void;
        getFunctionCompilationLevel(): number;
        getPlayerCount(): number;
        isCommandBlockEnabled(): boolean;
        getItemModifierManager(): Internal.ItemModifierManager;
        getGameRules(): Internal.GameRules;
        getStatus(): Internal.ServerStatus;
        getCommands(): Internal.Commands;
        isSingleplayer(): boolean;
        stopTimeProfiler(): Internal.ProfileResults;
        areNpcsEnabled(): boolean;
        isNetherEnabled(): boolean;
        getSpawnRadius($$0: Internal.ServerLevel_): number;
        method_5384(): boolean;
        isRecordingMetrics(): boolean;
        getAverageTickTime(): number;
        alwaysAccepts(): boolean;
        stopServer(): void;
        getCustomBossEvents(): Internal.CustomBossEvents;
        getServerVersion(): string;
        setDemo($$0: boolean): void;
        saveEverything($$0: boolean, $$1: boolean, $$2: boolean): boolean;
        setDefaultGameType($$0: Internal.GameType_): void;
        setEnforceWhitelist($$0: boolean): void;
        createCommandSourceStack(): Internal.CommandSourceStack;
        getPlayerList(): Internal.PlayerList;
        isShutdown(): boolean;
        startRecordingMetrics($$0: Internal.Consumer_<Internal.ProfileResults_>, $$1: Internal.Consumer_<Internal.Path_>): void;
        method_3777(): Internal.Thread;
        getProfiler(): Internal.ProfilerFiller;
        getLocalIp(): string;
        getProxy(): Internal.Proxy;
        hasGui(): boolean;
        getSessionService(): Internal.MinecraftSessionService;
        getAllLevels(): Internal.Iterable<Internal.ServerLevel>;
        setPort($$0: number): void;
        getFrameTimer(): Internal.FrameTimer;
        tickServer($$0: Internal.BooleanSupplier_): void;
        getResourcePackPrompt(): net.minecraft.network.chat.Component;
        fillSystemReport($$0: Internal.SystemReport_): Internal.SystemReport;
        getForcedGameType(): Internal.GameType;
        getFixerUpper(): Internal.DataFixer;
        getAbsoluteMaxWorldSize(): number;
        setMotd($$0: string): void;
        setLocalIp($$0: string): void;
        getScoreboard(): Internal.ServerScoreboard;
        setPvpAllowed($$0: boolean): void;
        addTickable($$0: Internal.Runnable_): void;
        close(): void;
        forceSynchronousWrites(): boolean;
        registryAccess(): Internal.RegistryAccess$Frozen;
        usesAuthentication(): boolean;
        isStopped(): boolean;
        invalidateStatus(): void;
        getPredicateManager(): Internal.PredicateManager;
        isPublished(): boolean;
        localvar$ckh000$MinecraftServer_stopServer(serverlevel1: Internal.ServerLevel_): Internal.ServerLevel;
        isPvpAllowed(): boolean;
        hidesOnlinePlayers(): boolean;
        getMaxPlayers(): number;
        setPlayerList($$0: Internal.PlayerList_): void;
        isResourcePackRequired(): boolean;
        getDefaultGameType(): Internal.GameType;
        halt($$0: boolean): void;
        getLevel($$0: Internal.ResourceKey_<Internal.Level_>): Internal.ServerLevel;
        handler$ioa002$onShutdown(callbackInfo: Internal.CallbackInfo_): void;
        setPreventProxyConnections($$0: boolean): void;
        getPort(): number;
        getOperatorUserPermissionLevel(): number;
        shouldRconBroadcast(): boolean;
        isFlightAllowed(): boolean;
        static spin<S>($$0: Internal.Function_<Internal.Thread_, S>): S;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle_<Source>, Internal.TickTask_>): Internal.CompletableFuture<Source>;
        getWorldPath($$0: Internal.LevelResource_): Internal.Path;
        handler$ioa000$onConstructed(callbackInfo: Internal.CallbackInfo_): void;
        startTimeProfiler(): void;
        getRateLimitPacketsPerSecond(): number;
        createGameModeForPlayer($$0: Internal.ServerPlayer_): Internal.ServerPlayerGameMode;
        isEnforceWhitelist(): boolean;
        isUnderSpawnProtection($$0: Internal.ServerLevel_, $$1: BlockPos_, $$2: Internal.Player_): boolean;
        isEpollEnabled(): boolean;
        isSingleplayerOwner(arg0: Internal.GameProfile_): boolean;
        getCompressionThreshold(): number;
        method_16075(): boolean;
        getMotd(): string;
        getResourceManager(): Internal.ResourceManager;
        isDemo(): boolean;
        getFile($$0: string): Internal.File;
        getWorldScreenshotFile(): Internal.Optional<Internal.Path>;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle_<Internal.Either_<Source, Internal.Exception_>>, Internal.TickTask_>): Internal.CompletableFuture<Source>;
        getKeyPair(): Internal.KeyPair;
        reloadResources($$0: Internal.Collection_<string>): Internal.CompletableFuture<void>;
        getStructureManager(): Internal.StructureManager;
        getLootTables(): Internal.LootTables;
        setResourcePack($$0: string, $$1: string): void;
        getServerDirectory(): Internal.File;
        getProfileCache(): Internal.GameProfileCache;
        repliesToStatus(): boolean;
        getPackRepository(): Internal.PackRepository;
        getScaledTrackingDistance($$0: number): number;
        getRecipeManager(): Internal.RecipeManager;
        getPlayerNames(): string[];
        setFlightAllowed($$0: boolean): void;
        getResourcePackHash(): string;
        setSingleplayerName($$0: string): void;
        fillServerSystemReport(arg0: Internal.SystemReport_): Internal.SystemReport;
        getModdedStatus(): Internal.ModCheck;
        overworld(): Internal.ServerLevel;
        isSpawningMonsters(): boolean;
        getServerModName(): string;
        getNextTickTime(): number;
        tickChildren($$0: Internal.BooleanSupplier_): void;
        stopRecordingMetrics(): void;
        getAdvancements(): Internal.ServerAdvancementManager;
        getResourcePack(): string;
        static configurePackRepository($$0: Internal.PackRepository_, $$1: Internal.DataPackConfig_, $$2: boolean): Internal.DataPackConfig;
        getSingleplayerName(): string;
        getProfilePermissions($$0: Internal.GameProfile_): number;
        method_40000($$0: Internal.Runnable_): void;
        isReady(): boolean;
        isSpawningAnimals(): boolean;
        createTextFilterForPlayer($$0: Internal.ServerPlayer_): Internal.TextFilter;
        setDifficulty($$0: Internal.Difficulty_, $$1: boolean): void;
        isTimeProfilerRunning(): boolean;
        getPlayerIdleTimeout(): number;
        getConnection(): Internal.ServerConnectionListener;
        kickUnlistedPlayers($$0: Internal.CommandSourceStack_): void;
        setDifficultyLocked($$0: boolean): void;
        method_9200(): boolean;
        isRunning(): boolean;
        getPreventProxyConnections(): boolean;
        finishRecordingMetrics(): void;
        method_9203($$0: net.minecraft.network.chat.Component_, $$1: Internal.UUID_): void;
        method_9202(): boolean;
        method_9201(): boolean;
        levelKeys(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        getProfileRepository(): Internal.GameProfileRepository;
        setPlayerIdleTimeout($$0: number): void;
        setUsesAuthentication($$0: boolean): void;
        getFunctions(): Internal.ServerFunctionManager;
        isCurrentlySaving(): boolean;
        getCommandStorage(): Internal.CommandStorage;
        asKJS(): Internal.ServerJS;
        getTickCount(): number;
        isHardcore(): boolean;
        isDedicatedServer(): boolean;
        getSpawnProtectionRadius(): number;
        getWorldData(): Internal.WorldData;
        localvar$fmc000$wrapResourceManager(original: Internal.CloseableResourceManager_): Internal.CloseableResourceManager;
        dumpServerProperties($$0: Internal.Path_): void;
        saveAllChunks($$0: boolean, $$1: boolean, $$2: boolean): boolean;
        static readonly "VANILLA_BRAND" : "vanilla";
        static readonly "MS_PER_TICK" : 50;
        static readonly "MAP_RESOURCE_FILE" : "resources.zip";
        static readonly "START_CHUNK_RADIUS" : 11;
        static readonly "ANONYMOUS_PLAYER_PROFILE" : Internal.GameProfile;
        readonly "tickTimes" : number[];
        static readonly "LEVEL_STORAGE_PROTOCOL" : "level";
        static readonly "LEVEL_STORAGE_SCHEMA" : "level://";
        static readonly "ABSOLUTE_MAX_WORLD_SIZE" : 29999984;
        static readonly "USERID_CACHE_FILE" : Internal.File;
        static readonly "DEMO_SETTINGS" : Internal.LevelSettings;
        get serverVersion(): string;
        get commandStorage(): Internal.CommandStorage;
        get resourcePackHash(): string;
        get customBossEvents(): Internal.CustomBossEvents;
        get timeProfilerRunning(): boolean;
        get functions(): Internal.ServerFunctionManager;
        get playerCount(): number;
        get profileCache(): Internal.GameProfileCache;
        get pvpAllowed(): boolean;
        get defaultGameType(): Internal.GameType;
        get forcedGameType(): Internal.GameType;
        get tickCount(): number;
        get itemModifierManager(): Internal.ItemModifierManager;
        get frameTimer(): Internal.FrameTimer;
        get currentlySaving(): boolean;
        get profileRepository(): Internal.GameProfileRepository;
        get connection(): Internal.ServerConnectionListener;
        get scoreboard(): Internal.ServerScoreboard;
        get commands(): Internal.Commands;
        get resourceManager(): Internal.ResourceManager;
        get motd(): string;
        get moddedStatus(): Internal.ModCheck;
        get maxPlayers(): number;
        get flightAllowed(): boolean;
        get functionCompilationLevel(): number;
        get serverDirectory(): Internal.File;
        get dedicatedServer(): boolean;
        get profiler(): Internal.ProfilerFiller;
        get published(): boolean;
        get spawningAnimals(): boolean;
        get netherEnabled(): boolean;
        get rateLimitPacketsPerSecond(): number;
        get proxy(): Internal.Proxy;
        get port(): number;
        get worldData(): Internal.WorldData;
        get keyPair(): Internal.KeyPair;
        get shutdown(): boolean;
        get status(): Internal.ServerStatus;
        get predicateManager(): Internal.PredicateManager;
        get singleplayerName(): string;
        get demo(): boolean;
        get recordingMetrics(): boolean;
        get gameRules(): Internal.GameRules;
        get running(): boolean;
        get packRepository(): Internal.PackRepository;
        get serverModName(): string;
        get advancements(): Internal.ServerAdvancementManager;
        get resourcePack(): string;
        get lootTables(): Internal.LootTables;
        get operatorUserPermissionLevel(): number;
        get nextTickTime(): number;
        get ready(): boolean;
        get localIp(): string;
        get absoluteMaxWorldSize(): number;
        get sessionService(): Internal.MinecraftSessionService;
        get playerNames(): string[];
        get epollEnabled(): boolean;
        get fixerUpper(): Internal.DataFixer;
        get preventProxyConnections(): boolean;
        get stopped(): boolean;
        get enforceWhitelist(): boolean;
        get hardcore(): boolean;
        get playerIdleTimeout(): number;
        get averageTickTime(): number;
        get singleplayer(): boolean;
        get resourcePackRequired(): boolean;
        get commandBlockEnabled(): boolean;
        get allLevels(): Internal.Iterable<Internal.ServerLevel>;
        get compressionThreshold(): number;
        get worldScreenshotFile(): Internal.Optional<Internal.Path>;
        get structureManager(): Internal.StructureManager;
        get playerList(): Internal.PlayerList;
        get recipeManager(): Internal.RecipeManager;
        get resourcePackPrompt(): net.minecraft.network.chat.Component;
        get spawningMonsters(): boolean;
        get spawnProtectionRadius(): number;
        set preventProxyConnections($$0: boolean);
        set motd($$0: string);
        set enforceWhitelist($$0: boolean);
        set flightAllowed($$0: boolean);
        set port($$0: number);
        set playerList($$0: Internal.PlayerList_);
        set playerIdleTimeout($$0: number);
        set pvpAllowed($$0: boolean);
        set defaultGameType($$0: Internal.GameType_);
        set localIp($$0: string);
        set difficultyLocked($$0: boolean);
        set singleplayerName($$0: string);
        set demo($$0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Thread, $$1: Internal.LevelStorageSource$LevelStorageAccess, $$2: Internal.PackRepository, $$3: Internal.WorldStem, $$4: Internal.Proxy, $$5: Internal.DataFixer, $$6: Internal.MinecraftSessionService, $$7: Internal.GameProfileRepository, $$8: Internal.GameProfileCache, $$9: Internal.ChunkProgressListenerFactory);
    }
    type MinecraftServer_ = MinecraftServer;
    /**
    * @javaClass net.id.incubus_core.mixin.woodtypefactory.chest.ChestBlockEntityAccessor
    */
    interface ChestBlockEntityAccessor {
    }
    type ChestBlockEntityAccessor_ = ChestBlockEntityAccessor;
    /**
    * @javaClass com.telepathicgrunt.the_bumblezone.mixin.world.NoiseGeneratorSettingsInvoker
    */
    interface NoiseGeneratorSettingsInvoker {
        thebumblezone_callDisableMobGeneration(): boolean;
    }
    type NoiseGeneratorSettingsInvoker_ = NoiseGeneratorSettingsInvoker;
    /**
    * @javaClass dev.latvian.mods.kubejs.player.PlayerEventJS
    */
    abstract class PlayerEventJS extends Internal.LivingEntityEventJS {
        addGameStage(stage: string): void;
        /**
        */
        getPlayer(): Internal.PlayerJS_<Internal.Player_>;
        getMinecraftPlayer(): Internal.Player;
        hasGameStage(stage: string): boolean;
        removeGameStage(stage: string): void;
        get minecraftPlayer(): Internal.Player;
        /**
        */
        get player(): Internal.PlayerJS_<Internal.Player_>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    /**
    */
    type PlayerEventJS_ = PlayerEventJS;
    /**
    * @javaClass net.minecraft.class_185
    */
    class DisplayInfo implements Internal.DisplayInfoFTBL {
        serializeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        getFrame(): Internal.FrameType;
        getDescription(): net.minecraft.network.chat.Component;
        shouldShowToast(): boolean;
        isHidden(): boolean;
        getIcon(): Internal.ItemStack;
        getX(): number;
        getY(): number;
        getTitle(): net.minecraft.network.chat.Component;
        serializeToJson(): Internal.JsonElement;
        shouldAnnounceChat(): boolean;
        setLocation($$0: number, $$1: number): void;
        static fromJson($$0: Internal.JsonObject_): Internal.DisplayInfo;
        getBackground(): ResourceLocation;
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.DisplayInfo;
        get hidden(): boolean;
        get background(): ResourceLocation;
        get icon(): Internal.ItemStack;
        get x(): number;
        get description(): net.minecraft.network.chat.Component;
        get y(): number;
        get title(): net.minecraft.network.chat.Component;
        get frame(): Internal.FrameType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ItemStack, $$1: net.minecraft.network.chat.Component, $$2: net.minecraft.network.chat.Component, $$3: ResourceLocation, $$4: Internal.FrameType, $$5: boolean, $$6: boolean, $$7: boolean);
    }
    type DisplayInfo_ = DisplayInfo;
    /**
    * @javaClass dev.latvian.mods.rhino.Wrapper
    */
    interface Wrapper {
        unwrapped(o: any): any;
        unwrap(): any;
    }
    type Wrapper_ = Wrapper;
    /**
    * @javaClass net.minecraft.class_4970$class_2251
    */
    class BlockBehaviour$Properties implements Internal.AbstractBlockSettingsAccessor {
        isSuffocating($$0: Internal.BlockBehaviour$StatePredicate_): this;
        explosionResistance($$0: number): this;
        emissiveRendering($$0: Internal.BlockBehaviour$StatePredicate_): this;
        strength($$0: number, $$1: number): this;
        strength($$0: number): this;
        color($$0: Internal.MaterialColor_): this;
        noOcclusion(): this;
        sound($$0: Internal.SoundType_): this;
        air(): this;
        requiresCorrectToolForDrops(): this;
        isViewBlocking($$0: Internal.BlockBehaviour$StatePredicate_): this;
        isRedstoneConductor($$0: Internal.BlockBehaviour$StatePredicate_): this;
        noCollission(): this;
        static of($$0: net.minecraft.world.level.material.Material_, $$1: Internal.Function_<Internal.BlockState_, Internal.MaterialColor_>): Internal.BlockBehaviour$Properties;
        static of($$0: net.minecraft.world.level.material.Material_): Internal.BlockBehaviour$Properties;
        static of($$0: net.minecraft.world.level.material.Material_, $$1: Internal.MaterialColor_): Internal.BlockBehaviour$Properties;
        static of($$0: net.minecraft.world.level.material.Material_, $$1: Internal.DyeColor_): Internal.BlockBehaviour$Properties;
        dynamicShape(): this;
        static copy($$0: Internal.BlockBehaviour_): Internal.BlockBehaviour$Properties;
        hasPostProcess($$0: Internal.BlockBehaviour$StatePredicate_): this;
        randomTicks(): this;
        jumpFactor($$0: number): this;
        isValidSpawn($$0: Internal.BlockBehaviour$StateArgumentPredicate_<Internal.EntityType_<any>>): this;
        instabreak(): this;
        noDrops(): this;
        speedFactor($$0: number): this;
        friction($$0: number): this;
        lightLevel($$0: Internal.ToIntFunction_<Internal.BlockState_>): this;
        destroyTime($$0: number): this;
        dropsLike($$0: Internal.Block_): this;
        "isRandomlyTicking" : boolean;
        "materialColor" : ((arg0: Internal.BlockState) => Internal.MaterialColor);
        "canOcclude" : boolean;
        "lightEmission" : ((arg0: Internal.BlockState) => number);
        "drops" : ResourceLocation;
        "material" : net.minecraft.world.level.material.Material;
        "isAir" : boolean;
        "hasCollision" : boolean;
        "soundType" : Internal.SoundType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: net.minecraft.world.level.material.Material, $$1: ((arg0: Internal.BlockState) => Internal.MaterialColor));
    }
    type BlockBehaviour$Properties_ = BlockBehaviour$Properties;
    /**
    * @javaClass net.minecraft.class_5348$class_5245
    */
    interface FormattedText$ContentConsumer <T> {
        accept(arg0: string): Internal.Optional<T>;
    }
    type FormattedText$ContentConsumer_<T> = FormattedText$ContentConsumer<T>;
    /**
    * @javaClass net.minecraft.class_5399
    */
    class LavaSubmergedBlockProcessor extends Internal.StructureProcessor {
        method_15110($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: BlockPos_, $$3: Internal.StructureTemplate$StructureBlockInfo_, $$4: Internal.StructureTemplate$StructureBlockInfo_, $$5: Internal.StructurePlaceSettings_): Internal.StructureTemplate$StructureBlockInfo;
        static readonly "CODEC" : Internal.Codec<Internal.LavaSubmergedBlockProcessor>;
        static readonly "INSTANCE" : Internal.LavaSubmergedBlockProcessor;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type LavaSubmergedBlockProcessor_ = LavaSubmergedBlockProcessor;
    /**
    * @javaClass ru.betterend.interfaces.BETargetChecker
    */
    interface BETargetChecker {
        be_setTarget(arg0: boolean): void;
        be_isTarget(): boolean;
    }
    type BETargetChecker_ = BETargetChecker;
    /**
    * @javaClass net.minecraft.class_846$class_849
    */
    class ChunkRenderDispatcher$CompiledChunk {
        facesCanSeeEachother($$0: Internal.Direction_, $$1: Internal.Direction_): boolean;
        isEmpty($$0: Internal.RenderType_): boolean;
        getRenderableBlockEntities(): Internal.List<Internal.BlockEntity>;
        hasNoRenderableLayers(): boolean;
        static readonly "UNCOMPILED" : Internal.ChunkRenderDispatcher$CompiledChunk;
        get renderableBlockEntities(): Internal.List<Internal.BlockEntity>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ChunkRenderDispatcher$CompiledChunk_ = ChunkRenderDispatcher$CompiledChunk;
    /**
    * @javaClass com.simibubi.create.content.contraptions.components.structureMovement.MovingInteractionBehaviour
    */
    abstract class MovingInteractionBehaviour {
        handleEntityCollision(entity: Internal.Entity_, localPos: BlockPos_, contraptionEntity: Internal.AbstractContraptionEntity_): void;
        handlePlayerInteraction(player: Internal.Player_, activeHand: Hand_, localPos: BlockPos_, contraptionEntity: Internal.AbstractContraptionEntity_): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type MovingInteractionBehaviour_ = MovingInteractionBehaviour;
    /**
    * @javaClass net.fabricmc.fabric.impl.client.model.BakedModelManagerHooks
    */
    interface BakedModelManagerHooks {
        fabric_getModel(arg0: ResourceLocation_): Internal.BakedModel;
    }
    type BakedModelManagerHooks_ = BakedModelManagerHooks;
    /**
    * @javaClass com.mojang.datafixers.kinds.K1
    */
    interface K1 {
    }
    type K1_ = K1;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.StructureTemplateExtensions
    */
    interface StructureTemplateExtensions {
        processEntityInfos(template: Internal.StructureTemplate_, world: Internal.LevelAccessor_, blockPos: BlockPos_, settings: Internal.StructurePlaceSettings_, infos: Internal.List_<Internal.StructureTemplate$StructureEntityInfo_>): Internal.List<Internal.StructureTemplate$StructureEntityInfo>;
        addEntitiesToWorld(world: Internal.ServerLevelAccessor_, blockPos: BlockPos_, settings: Internal.StructurePlaceSettings_): void;
        getEntities(): Internal.List<Internal.StructureTemplate$StructureEntityInfo>;
        transformedVec3d(placementIn: Internal.StructurePlaceSettings_, pos: Vec3_): Vec3;
    }
    type StructureTemplateExtensions_ = StructureTemplateExtensions;
    /**
    * @javaClass me.shedaniel.rei.api.common.category.CategoryIdentifier
    */
    interface CategoryIdentifier <D> extends Internal.Identifiable {
        cast<O>(): Internal.CategoryIdentifier<O>;
        getNamespace(): string;
        of<D>(str: string): Internal.CategoryIdentifier<D>;
        of<D>(identifier: ResourceLocation_): Internal.CategoryIdentifier<D>;
        of<D>(namespace: string, path: string): Internal.CategoryIdentifier<D>;
        getPath(): string;
    }
    type CategoryIdentifier_<D> = CategoryIdentifier<D>;
    /**
    * @javaClass net.fabricmc.fabric.impl.renderer.SpriteFinderImpl
    */
    class SpriteFinderImpl implements Internal.SpriteFinder {
        find(quad: Internal.QuadView_, textureIndex: number): Internal.TextureAtlasSprite;
        find(u: number, v: number): Internal.TextureAtlasSprite;
        static get(atlas: Internal.TextureAtlas_): Internal.SpriteFinderImpl;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(sprites: Internal.Map<ResourceLocation, Internal.TextureAtlasSprite>, spriteAtlasTexture: Internal.TextureAtlas);
    }
    type SpriteFinderImpl_ = SpriteFinderImpl;
    /**
    * @javaClass io.netty.channel.EventLoop
    */
    interface EventLoop extends Internal.OrderedEventExecutor, Internal.EventLoopGroup {
        parent(): Internal.EventLoopGroup;
        spliterator(): Internal.Spliterator<Internal.EventExecutor>;
        forEach(arg0: Internal.Consumer_<Internal.EventExecutor_>): void;
    }
    type EventLoop_ = EventLoop;
    /**
    * @javaClass com.google.common.reflect.TypeCapture
    */
    abstract class TypeCapture <T> {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TypeCapture_<T> = TypeCapture<T>;
    /**
    * @javaClass eu.ha3.presencefootsteps.sound.acoustics.Acoustic
    */
    interface Acoustic {
        playSound(arg0: Internal.SoundPlayer_, arg1: Internal.LivingEntity_, arg2: Internal.State_, arg3: eu.ha3.presencefootsteps.sound.Options_): void;
    }
    type Acoustic_ = Acoustic;
    /**
    * @javaClass net.minecraft.class_6647
    */
    interface BlockPredicateType <P> {
        codec(): Internal.Codec<P>;
    }
    type BlockPredicateType_<P> = Special.BlockPredicateType | BlockPredicateType<P>;
    /**
    * @javaClass net.minecraft.class_4282
    */
    class ClientboundSetChunkCacheCenterPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getX(): number;
        getZ(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get x(): number;
        get z(): number;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundSetChunkCacheCenterPacket_ = ClientboundSetChunkCacheCenterPacket;
    /**
    * @javaClass net.minecraft.class_4668$class_4671
    */
    class RenderStateShard$CullStateShard extends Internal.RenderStateShard$BooleanStateShard {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: boolean);
    }
    type RenderStateShard$CullStateShard_ = RenderStateShard$CullStateShard;
    /**
    * @javaClass java.util.Properties
    */
    class Properties extends Internal.Hashtable<any, any> {
        getOrDefault(arg0: any, arg1: any): any;
        loadFromXML(arg0: Internal.InputStream_): void;
        keys(): Internal.Enumeration<any>;
        computeIfAbsent(arg0: any, arg1: Internal.Function_<any, any>): any;
        values(): Internal.Collection<any>;
        save(arg0: Internal.OutputStream_, arg1: string): void;
        replace(arg0: any, arg1: any): any;
        replace(arg0: any, arg1: any, arg2: any): boolean;
        replaceAll(arg0: Internal.BiFunction_<any, any, any>): void;
        containsValue(arg0: any): boolean;
        put(arg0: any, arg1: any): any;
        remove(arg0: any, arg1: any): boolean;
        remove(arg0: any): any;
        compute(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        load(arg0: Internal.Reader_): void;
        load(arg0: Internal.InputStream_): void;
        hashCode(): number;
        putAll(arg0: Internal.Map_<any, any>): void;
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        get(arg0: any): any;
        keySet(): Internal.Set<any>;
        getProperty(arg0: string, arg1: string): string;
        getProperty(arg0: string): string;
        entrySet(): Internal.Set<Internal.Map$Entry<any, any>>;
        containsKey(arg0: any): boolean;
        forEach(arg0: Internal.BiConsumer_<any, any>): void;
        stringPropertyNames(): Internal.Set<string>;
        isEmpty(): boolean;
        clear(): void;
        store(arg0: Internal.OutputStream_, arg1: string): void;
        store(arg0: Internal.Writer_, arg1: string): void;
        list(arg0: Internal.PrintWriter_): void;
        list(arg0: Internal.PrintStream_): void;
        storeToXML(arg0: Internal.OutputStream_, arg1: string, arg2: string): void;
        storeToXML(arg0: Internal.OutputStream_, arg1: string, arg2: Internal.Charset_): void;
        storeToXML(arg0: Internal.OutputStream_, arg1: string): void;
        contains(arg0: any): boolean;
        computeIfPresent(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        size(): number;
        propertyNames(): Internal.Enumeration<any>;
        setProperty(arg0: string, arg1: string): any;
        elements(): Internal.Enumeration<any>;
        equals(arg0: any): boolean;
        clone(): any;
        toString(): string;
        putIfAbsent(arg0: any, arg1: any): any;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.Properties);
        constructor(arg0: number);
        constructor();
    }
    type Properties_ = Properties;
    /**
    * @javaClass it.unimi.dsi.fastutil.shorts.ShortIterable
    */
    interface ShortIterable extends Internal.Iterable<number> {
        iterator(): Internal.ShortIterator;
        spliterator(): Internal.ShortSpliterator;
        forEach(arg0: Internal.ShortConsumer_): void;
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: Internal.IntConsumer_): void;
        intIterator(): Internal.IntIterator;
        intSpliterator(): Internal.IntSpliterator;
    }
    type ShortIterable_ = ShortIterable;
    /**
    * @javaClass xaero.common.category.ui.setting.CategorySettingsUIEditorSettingType$SettingDataBuilderFactory
    */
    interface CategorySettingsUIEditorSettingType$SettingDataBuilderFactory {
        apply<V>(arg0: Internal.ListFactory_): Internal.IGuiCategoryUIEditorSettingDataBuilder<V, any>;
    }
    type CategorySettingsUIEditorSettingType$SettingDataBuilderFactory_ = ((arg0: Internal.ListFactory) => Internal.IGuiCategoryUIEditorSettingDataBuilder<V, any>) | CategorySettingsUIEditorSettingType$SettingDataBuilderFactory;
    /**
    * @javaClass net.minecraft.class_1688$class_1689
    */
    class AbstractMinecart$Type extends Internal.Enum<Internal.AbstractMinecart$Type> {
        static valueOf($$0: string): Internal.AbstractMinecart$Type;
        static values(): Internal.AbstractMinecart$Type[];
        static readonly "CHEST" : Internal.AbstractMinecart$Type;
        static readonly "FURNACE" : Internal.AbstractMinecart$Type;
        static readonly "RIDEABLE" : Internal.AbstractMinecart$Type;
        static readonly "COMMAND_BLOCK" : Internal.AbstractMinecart$Type;
        static readonly "TNT" : Internal.AbstractMinecart$Type;
        static readonly "SPAWNER" : Internal.AbstractMinecart$Type;
        static readonly "HOPPER" : Internal.AbstractMinecart$Type;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractMinecart$Type_ = "chest" | "spawner" | "command_block" | "furnace" | "rideable" | "tnt" | "hopper" | AbstractMinecart$Type;
    /**
    * @javaClass com.jozufozu.flywheel.api.instance.DynamicInstance
    */
    interface DynamicInstance extends Internal.Instance {
        decreaseFramerateWithDistance(): boolean;
        beginFrame(): void;
    }
    type DynamicInstance_ = DynamicInstance;
    /**
    * @javaClass java.awt.PageAttributes$OriginType
    */
    class PageAttributes$OriginType extends Internal.AttributeValue {
        static readonly "PRINTABLE" : Internal.PageAttributes$OriginType;
        static readonly "PHYSICAL" : Internal.PageAttributes$OriginType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type PageAttributes$OriginType_ = PageAttributes$OriginType;
    /**
    * @javaClass it.unimi.dsi.fastutil.booleans.Boolean2ByteFunction
    */
    interface Boolean2ByteFunction extends it.unimi.dsi.fastutil.Function<boolean, number> {
        getOrDefault(arg0: boolean, arg1: number): number;
        getOrDefault(arg0: any, arg1: number): number;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Boolean2ShortFunction;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2ByteFunction;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Boolean2IntFunction;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2ByteFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<boolean, T>;
        put(arg0: boolean, arg1: number): number;
        remove(arg0: any): number;
        remove(arg0: boolean): number;
        defaultReturnValue(arg0: number): void;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Boolean2DoubleFunction;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Boolean2ObjectFunction<T>;
        get(arg0: any): number;
        get(arg0: boolean): number;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Boolean2LongFunction;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2ByteFunction;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Boolean2FloatFunction;
        apply(arg0: boolean): number;
        containsKey(arg0: any): boolean;
        containsKey(arg0: boolean): boolean;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2ByteFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2ByteFunction;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Boolean2CharFunction;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2ByteFunction<T>;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, number>;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2ByteFunction;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Boolean2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2ByteFunction;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2ByteFunction;
    }
    type Boolean2ByteFunction_ = ((arg0: boolean) => number) | Boolean2ByteFunction;
    /**
    * @javaClass com.google.common.collect.ForwardingMultimap
    */
    abstract class ForwardingMultimap <K, V> extends Internal.ForwardingObject implements Internal.Multimap<K, V> {
        containsEntry(arg0: any, arg1: any): boolean;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        asMap(): Internal.Map<K, Internal.Collection<V>>;
        keys(): Internal.Multiset<K>;
        containsKey(arg0: any): boolean;
        values(): Internal.Collection<V>;
        isEmpty(): boolean;
        clear(): void;
        replaceValues(arg0: K, arg1: Internal.Iterable_<V>): Internal.Collection<V>;
        containsValue(arg0: any): boolean;
        put(arg0: K, arg1: V): boolean;
        remove(arg0: any, arg1: any): boolean;
        removeAll(arg0: any): Internal.Collection<V>;
        entries(): Internal.Collection<Internal.Map$Entry<K, V>>;
        size(): number;
        hashCode(): number;
        putAll(arg0: Internal.Multimap_<K, V>): boolean;
        putAll(arg0: K, arg1: Internal.Iterable_<V>): boolean;
        equals(arg0: any): boolean;
        get(arg0: K): Internal.Collection<V>;
        keySet(): Internal.Set<K>;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ForwardingMultimap_<K, V> = ForwardingMultimap<K, V>;
    /**
    * @javaClass net.coderbot.batchedentityrendering.impl.BlendingStateHolder
    */
    interface BlendingStateHolder {
        getTransparencyType(): Internal.TransparencyType;
    }
    type BlendingStateHolder_ = BlendingStateHolder;
    /**
    * @javaClass dev.latvian.mods.kubejs.level.FireworksJS
    */
    class FireworksJS {
        static of(o: any): Internal.FireworksJS;
        createFireworkRocket(w: Internal.Level_, x: number, y: number, z: number): Internal.FireworkRocketEntity;
        "flight" : number;
        "lifetime" : number;
        readonly "explosions" : Internal.List<Internal.FireworksJS$Explosion>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type FireworksJS_ = FireworksJS;
    /**
    * @javaClass com.mojang.datafixers.Products$P15
    */
    class Products$P15 <F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> {
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function15_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function15_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R>>): Internal.App<F, R>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.App<F, T1>, arg1: Internal.App<F, T2>, arg2: Internal.App<F, T3>, arg3: Internal.App<F, T4>, arg4: Internal.App<F, T5>, arg5: Internal.App<F, T6>, arg6: Internal.App<F, T7>, arg7: Internal.App<F, T8>, arg8: Internal.App<F, T9>, arg9: Internal.App<F, T10>, arg10: Internal.App<F, T11>, arg11: Internal.App<F, T12>, arg12: Internal.App<F, T13>, arg13: Internal.App<F, T14>, arg14: Internal.App<F, T15>);
    }
    type Products$P15_<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> = Products$P15<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>;
    /**
    * @javaClass io.netty.util.concurrent.ProgressiveFuture
    */
    interface ProgressiveFuture <V> extends io.netty.util.concurrent.Future<V> {
        removeListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<V>>[]): Internal.ProgressiveFuture<V>;
        syncUninterruptibly(): Internal.ProgressiveFuture<V>;
        await(): Internal.ProgressiveFuture<V>;
        awaitUninterruptibly(): Internal.ProgressiveFuture<V>;
        removeListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<V>>): Internal.ProgressiveFuture<V>;
        addListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<V>>[]): Internal.ProgressiveFuture<V>;
        sync(): Internal.ProgressiveFuture<V>;
        addListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<V>>): Internal.ProgressiveFuture<V>;
    }
    type ProgressiveFuture_<V> = ProgressiveFuture<V>;
    /**
    * @javaClass net.minecraft.class_2871
    */
    class ServerboundSetCommandMinecartPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getCommand(): string;
        getCommandBlock($$0: Internal.Level_): Internal.BaseCommandBlock;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        isTrackOutput(): boolean;
        get trackOutput(): boolean;
        get skippable(): boolean;
        get command(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: string, $$2: boolean);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ServerboundSetCommandMinecartPacket_ = ServerboundSetCommandMinecartPacket;
    /**
    * @javaClass com.glisco.numismaticoverhaul.villagers.data.NumismaticTradeOfferExtensions
    */
    interface NumismaticTradeOfferExtensions {
        numismatic$setReputation(arg0: number): void;
        numismatic$getReputation(): number;
    }
    type NumismaticTradeOfferExtensions_ = NumismaticTradeOfferExtensions;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.util.NonNullSupplier
    */
    interface NonNullSupplier <T> extends Internal.Supplier<T> {
        of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
    }
    type NonNullSupplier_<T> = NonNullSupplier<T>;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.reward.RewardClaimType
    */
    class RewardClaimType extends Internal.Enum<Internal.RewardClaimType> {
        cantClaim(): boolean;
        canClaim(): boolean;
        static valueOf(name: string): Internal.RewardClaimType;
        static values(): Internal.RewardClaimType[];
        isClaimed(): boolean;
        static readonly "CLAIMED" : Internal.RewardClaimType;
        static readonly "CAN_CLAIM" : Internal.RewardClaimType;
        static readonly "CANT_CLAIM" : Internal.RewardClaimType;
        get claimed(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type RewardClaimType_ = "can_claim" | "claimed" | "cant_claim" | RewardClaimType;
    /**
    * @javaClass net.minecraft.class_1581
    */
    class Illusioner extends Internal.SpellcasterIllager implements Internal.RangedAttackMob {
        method_16484($$0: number, $$1: boolean): void;
        method_5722($$0: Internal.Entity_): boolean;
        method_20033(): Internal.SoundEvent;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        getStepHeight(): number;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        canRiderInteract(): boolean;
        getIllusionOffsets($$0: number): Vec3[];
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_6990(): Internal.AbstractIllager$IllagerArmPose;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_5830(): Internal.AABB;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_6007(): void;
        method_7105($$0: Internal.LivingEntity_, $$1: number): void;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Illusioner>, $$1: Internal.Level);
    }
    type Illusioner_ = Illusioner;
    /**
    * @javaClass de.dafuqs.spectrum.mixin.accessors.SlimeEntityAccessor
    */
    interface SlimeEntityAccessor {
        invokeSetSize(arg0: number, arg1: boolean): void;
        invokeGetSoundVolume(): number;
        invokeGetParticles(): Internal.ParticleOptions;
        invokeGetSquishSound(): Internal.SoundEvent;
    }
    type SlimeEntityAccessor_ = SlimeEntityAccessor;
    /**
    * @javaClass dev.latvian.mods.rhino.util.wrap.TypeWrappers
    */
    class TypeWrappers {
        getWrapperFactory(target: Internal.Class_<any>, from: any): Internal.TypeWrapperFactory<any>;
        register<T>(target: Internal.Class_<T>, factory: Internal.TypeWrapperFactory_<T>): void;
        register<T>(target: Internal.Class_<T>, validator: Internal.Predicate_<any>, factory: Internal.TypeWrapperFactory_<T>): void;
        register<F, T>(id: string, from: Internal.Class_<F>, to: Internal.Class_<T>, factory: Internal.Function_<F, T>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type TypeWrappers_ = TypeWrappers;
    /**
    * @javaClass net.minecraft.class_4966
    */
    class NoiseColumn implements Internal.BlockColumn {
        method_32892($$0: number): Internal.BlockState;
        method_38092($$0: number, $$1: Internal.BlockState_): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: Internal.BlockState[]);
    }
    type NoiseColumn_ = NoiseColumn;
    /**
    * @javaClass com.almostreliable.lootjs.fabric.LootTableExtension
    */
    interface LootTableExtension {
        lootjs$setLootTableId(arg0: ResourceLocation_): void;
        lootjs$getLootTableId(): ResourceLocation;
    }
    type LootTableExtension_ = LootTableExtension;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBoundary
    */
    class SignalBoundary extends Internal.TrackEdgePoint {
        updateTilePower(tile: Internal.SignalTileEntity_): void;
        read(nbt: Internal.CompoundTag_, migration: boolean, dimensions: Internal.DimensionPalette_): void;
        read(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        cycleSignalType(pos: BlockPos_): void;
        getStateFor(tile: BlockPos_): Internal.SignalTileEntity$SignalState;
        setGroupAndUpdate(side: Internal.TrackNode_, groupId: Internal.UUID_): void;
        tileAdded(tile: Internal.BlockEntity_, front: boolean): void;
        getTypeFor(tile: BlockPos_): Internal.SignalBlock$SignalType;
        invalidate(level: Internal.LevelAccessor_): void;
        tick(graph: Internal.TrackGraph_, preTrains: boolean): void;
        canNavigateVia(side: Internal.TrackNode_): boolean;
        tileRemoved(tilePos: BlockPos_, front: boolean): void;
        setGroup(primary: boolean, groupId: Internal.UUID_): void;
        getOverlayFor(tile: BlockPos_): Internal.SignalTileEntity$OverlayState;
        isForcedRed(side: Internal.TrackNode_): boolean;
        isForcedRed(primary: boolean): boolean;
        canCoexistWith(otherType: Internal.EdgePointType_<any>, front: boolean): boolean;
        getGroup(side: Internal.TrackNode_): Internal.UUID;
        canMerge(): boolean;
        onRemoved(graph: Internal.TrackGraph_): void;
        queueUpdate(side: Internal.TrackNode_): void;
        write(nbt: Internal.CompoundTag_, dimensions: Internal.DimensionPalette_): void;
        write(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        "sidesToUpdate" : Internal.Couple<boolean>;
        "types" : Internal.Couple<Internal.SignalBlock$SignalType>;
        "cachedStates" : Internal.Couple<Internal.SignalTileEntity$SignalState>;
        "groups" : Internal.Couple<Internal.UUID>;
        "blockEntities" : Internal.Couple<Internal.Map<BlockPos, boolean>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type SignalBoundary_ = SignalBoundary;
    /**
    * @javaClass dev.latvian.mods.kubejs.player.PlayerStatsJS
    */
    class PlayerStatsJS {
        getPlayer(): Internal.PlayerJS<any>;
        getPlayTime(): number;
        getCrouchDistance(): number;
        getDamageAbsorbed(): number;
        getWalkDistance(): number;
        getItemsPickedUp(item: Internal.Item_): number;
        getFishCaught(): number;
        getDamageDealt_absorbed(): number;
        getDeaths(): number;
        getSwimDistance(): number;
        getItemsCrafted(item: Internal.Item_): number;
        getBlocksMined(block: Internal.Block_): number;
        getPlayerKills(): number;
        getDamageDealt_resisted(): number;
        get(id: ResourceLocation_): number;
        getTimeSinceDeath(): number;
        getDamageBlocked_by_shield(): number;
        getKilled(entity: Internal.EntityType_<any>): number;
        getTimeCrouchTime(): number;
        getDamageTaken(): number;
        add(id: ResourceLocation_, value: number): void;
        getItemsDropped(item: Internal.Item_): number;
        set(id: ResourceLocation_, value: number): void;
        getJumps(): number;
        getDamageResisted(): number;
        getAnimalsBred(): number;
        getItemsBroken(item: Internal.Item_): number;
        getMobKills(): number;
        getSprintDistance(): number;
        getTimeSinceRest(): number;
        getKilledBy(entity: Internal.EntityType_<any>): number;
        getDamageDealt(): number;
        getItemsUsed(item: Internal.Item_): number;
        get playerKills(): number;
        get animalsBred(): number;
        get walkDistance(): number;
        get damageDealt_resisted(): number;
        get crouchDistance(): number;
        get damageAbsorbed(): number;
        get damageResisted(): number;
        get jumps(): number;
        get damageDealt_absorbed(): number;
        get timeSinceDeath(): number;
        get timeCrouchTime(): number;
        get damageBlocked_by_shield(): number;
        get fishCaught(): number;
        get mobKills(): number;
        get sprintDistance(): number;
        get timeSinceRest(): number;
        get swimDistance(): number;
        get playTime(): number;
        get deaths(): number;
        get damageDealt(): number;
        get player(): Internal.PlayerJS<any>;
        get damageTaken(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(p: Internal.PlayerJS<any>, s: Internal.StatsCounter);
    }
    type PlayerStatsJS_ = PlayerStatsJS;
    /**
    * @javaClass me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider
    */
    interface CategoryExtensionProvider <T> {
        provide(arg0: T, arg1: Internal.DisplayCategory_<T>, arg2: Internal.DisplayCategoryView_<T>): Internal.DisplayCategoryView<T>;
    }
    type CategoryExtensionProvider_<T> = ((arg0: T, arg1: Internal.DisplayCategory<T>, arg2: Internal.DisplayCategoryView<T>) => Internal.DisplayCategoryView<T>) | CategoryExtensionProvider<T>;
    /**
    * @javaClass com.telepathicgrunt.repurposedstructures.mixin.structures.StructureProcessorAccessor
    */
    interface StructureProcessorAccessor {
        callGetType(): Internal.StructureProcessorType<any>;
    }
    type StructureProcessorAccessor_ = StructureProcessorAccessor;
    /**
    * @javaClass net.minecraft.class_2757
    */
    class ClientboundSetScorePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getObjectiveName(): string;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getMethod(): Internal.ServerScoreboard$Method;
        isSkippable(): boolean;
        getOwner(): string;
        getScore(): number;
        get owner(): string;
        get score(): number;
        get method(): Internal.ServerScoreboard$Method;
        get skippable(): boolean;
        get objectiveName(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.ServerScoreboard$Method, $$1: string, $$2: string, $$3: number);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundSetScorePacket_ = ClientboundSetScorePacket;
    /**
    * @javaClass java.util.Spliterator
    */
    interface Spliterator <T> {
        trySplit(): Internal.Spliterator<T>;
        tryAdvance(arg0: Internal.Consumer_<T>): boolean;
        characteristics(): number;
        getComparator(): Internal.Comparator<T>;
        getExactSizeIfKnown(): number;
        estimateSize(): number;
        hasCharacteristics(arg0: number): boolean;
        forEachRemaining(arg0: Internal.Consumer_<T>): void;
    }
    type Spliterator_<T> = Spliterator<T>;
    /**
    * @javaClass com.almostreliable.lootjs.kube.builder.EntityPredicateBuilderJS
    */
    class EntityPredicateBuilderJS implements Internal.ExtendedEntityFlagsPredicate$IBuilder<Internal.EntityPredicate> {
        isBaby(flag: boolean): this;
        nbt(nbt: Internal.CompoundTag_): this;
        isIllegarMob(flag: boolean): this;
        isSwimming(flag: boolean): this;
        anyType(...resolvers: Internal.Resolver_[]): this;
        isInWater(flag: boolean): this;
        isWaterMob(flag: boolean): this;
        isCrouching(flag: boolean): this;
        isUnderWater(flag: boolean): this;
        isSprinting(flag: boolean): this;
        catType(type: ResourceLocation_): this;
        isUndeadMob(flag: boolean): this;
        matchFluid(resolver: Internal.Resolver_): this;
        isCreature(flag: boolean): this;
        build(): Internal.EntityPredicate;
        isMonster(flag: boolean): this;
        matchBlock(resolver: Internal.Resolver_, propertyMap: Internal.Map_<string, string>): this;
        matchBlock(resolver: Internal.Resolver_): this;
        matchMount(action: Internal.Consumer_<Internal.EntityPredicateBuilderJS_>): this;
        isOnFire(flag: boolean): this;
        isArthropodMob(flag: boolean): this;
        isOnGround(flag: boolean): this;
        matchSlot(slot: EquipmentSlot_, itemFilter: ItemFilter_): this;
        hasEffect(effect: Internal.MobEffect_): this;
        hasEffect(effect: Internal.MobEffect_, amplifier: number): this;
        matchTargetedEntity(action: Internal.Consumer_<Internal.EntityPredicateBuilderJS_>): this;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type EntityPredicateBuilderJS_ = EntityPredicateBuilderJS;
    /**
    * @javaClass net.minecraft.class_5889
    */
    class ClientboundInitializeBorderPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getNewCenterZ(): number;
        getNewSize(): number;
        getLerpTime(): number;
        getNewCenterX(): number;
        getWarningBlocks(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getOldSize(): number;
        getWarningTime(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getNewAbsoluteMaxSize(): number;
        get newAbsoluteMaxSize(): number;
        get newSize(): number;
        get lerpTime(): number;
        get newCenterX(): number;
        get warningBlocks(): number;
        get skippable(): boolean;
        get newCenterZ(): number;
        get warningTime(): number;
        get oldSize(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.FriendlyByteBuf);
        constructor($$0: Internal.WorldBorder);
    }
    type ClientboundInitializeBorderPacket_ = ClientboundInitializeBorderPacket;
    /**
    * @javaClass net.minecraft.class_3179
    */
    class SimpleRandomFeatureConfiguration implements Internal.FeatureConfiguration {
        method_30649(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        readonly "features" : Internal.HolderSet<Internal.PlacedFeature>;
        static readonly "CODEC" : Internal.Codec<Internal.SimpleRandomFeatureConfiguration>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.HolderSet<Internal.PlacedFeature>);
    }
    type SimpleRandomFeatureConfiguration_ = SimpleRandomFeatureConfiguration;
    /**
    * @javaClass net.minecraft.class_2627$class_2628
    */
    class ShulkerBoxBlockEntity$AnimationStatus extends Internal.Enum<Internal.ShulkerBoxBlockEntity$AnimationStatus> {
        static valueOf($$0: string): Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static values(): Internal.ShulkerBoxBlockEntity$AnimationStatus[];
        static readonly "CLOSED" : Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static readonly "CLOSING" : Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static readonly "OPENING" : Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static readonly "OPENED" : Internal.ShulkerBoxBlockEntity$AnimationStatus;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ShulkerBoxBlockEntity$AnimationStatus_ = "closing" | "closed" | "opened" | "opening" | ShulkerBoxBlockEntity$AnimationStatus;
    /**
    * @javaClass corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings
    */
    abstract class LunarEventClientSettings {
        createClient(): Internal.LunarEventClient<any>;
        codec(): Internal.Codec<Internal.LunarEventClientSettings>;
        getMoonSize(): number;
        getMoonTextureLocation(): ResourceLocation;
        getSoundTrack(): Internal.SoundEvent;
        getColorSettings(): Internal.ColorSettings;
        static readonly "CODEC" : Internal.Codec<Internal.LunarEventClientSettings>;
        get moonSize(): number;
        get moonTextureLocation(): ResourceLocation;
        get soundTrack(): Internal.SoundEvent;
        get colorSettings(): Internal.ColorSettings;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(colorSettings: Internal.ColorSettings, moonSize: number, moonTextureLocation: ResourceLocation, soundTrack: Internal.SoundEvent);
    }
    type LunarEventClientSettings_ = LunarEventClientSettings;
    /**
    * @javaClass xaero.map.file.RegionDetection
    */
    class RegionDetection implements Internal.MapRegionInfo {
        getWorldId(): string;
        shouldCache(): boolean;
        getRegionX(): number;
        setCacheFile(cacheFile: Internal.File_): void;
        isHasHadTerrain(): boolean;
        setShouldCache(shouldCache: boolean, fsdfs: string): void;
        transferInfoTo(to: Internal.MapRegion_): void;
        hasLookedForCache(): boolean;
        getCacheFile(): Internal.File;
        transferInfoFrom(from: Internal.MapRegion_): void;
        transferInfoPostAddTo(to: Internal.MapRegion_, mapProcessor: Internal.MapProcessor_): void;
        getRegionFile(): Internal.File;
        getRegionZ(): number;
        getMwId(): string;
        getDimId(): string;
        getInitialVersion(): number;
        get dimId(): string;
        get cacheFile(): Internal.File;
        get regionFile(): Internal.File;
        get worldId(): string;
        get hasHadTerrain(): boolean;
        get mwId(): string;
        get regionX(): number;
        get initialVersion(): number;
        get regionZ(): number;
        set cacheFile(cacheFile: Internal.File_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(worldId: string, dimId: string, mwId: string, regionX: number, regionZ: number, regionFile: Internal.File, globalVersion: number, hasHadTerrain: boolean);
    }
    type RegionDetection_ = RegionDetection;
    /**
    * @javaClass java.awt.RenderingHints$Key
    */
    abstract class RenderingHints$Key {
        isCompatibleValue(arg0: any): boolean;
        hashCode(): number;
        equals(arg0: any): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type RenderingHints$Key_ = RenderingHints$Key;
    /**
    * @javaClass net.minecraft.class_1507
    */
    class ZombieHorse extends Internal.AbstractHorse {
        canRiderInteract(): boolean;
        method_5613($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): Internal.AgeableMob;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getStepHeight(): number;
        method_6046(): Internal.MobType;
        method_5992($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.ZombieHorse>, $$1: Internal.Level);
    }
    type ZombieHorse_ = ZombieHorse;
    /**
    * @javaClass virtuoel.pehkui.api.ScaleModifier
    */
    class ScaleModifier implements Internal.Comparable<Internal.ScaleModifier> {
        modifyScale(scaleData: Internal.ScaleData_, modifiedScale: number, delta: number): number;
        getPriority(): number;
        compareTo(o: Internal.ScaleModifier_): number;
        modifyPrevScale(scaleData: Internal.ScaleData_, modifiedScale: number): number;
        get priority(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
        constructor(priority: number);
    }
    type ScaleModifier_ = ScaleModifier;
    /**
    * @javaClass net.minecraft.class_1713
    */
    class ClickType extends Internal.Enum<Internal.ClickType> {
        static valueOf($$0: string): Internal.ClickType;
        static values(): Internal.ClickType[];
        static readonly "QUICK_MOVE" : Internal.ClickType;
        static readonly "SWAP" : Internal.ClickType;
        static readonly "PICKUP_ALL" : Internal.ClickType;
        static readonly "THROW" : Internal.ClickType;
        static readonly "QUICK_CRAFT" : Internal.ClickType;
        static readonly "PICKUP" : Internal.ClickType;
        static readonly "CLONE" : Internal.ClickType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ClickType_ = "swap" | "throw" | "quick_craft" | "clone" | "pickup" | "quick_move" | "pickup_all" | ClickType;
    /**
    * @javaClass com.google.common.collect.ImmutableList$Builder
    */
    class ImmutableList$Builder <E> extends Internal.ImmutableCollection$Builder<E> {
        add(arg0: E): Internal.ImmutableList$Builder<E>;
        add(...arg0: E[]): Internal.ImmutableList$Builder<E>;
        build(): Internal.ImmutableList<E>;
        addAll(arg0: Internal.Iterator_<E>): Internal.ImmutableList$Builder<E>;
        addAll(arg0: Internal.Iterable_<E>): Internal.ImmutableList$Builder<E>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ImmutableList$Builder_<E> = ImmutableList$Builder<E>;
    /**
    * @javaClass net.minecraft.class_3806$class_7044
    */
    class DedicatedServerProperties$WorldGenProperties extends Internal.Record {
        levelSeed(): string;
        generatorSettings(): Internal.JsonObject;
        generateStructures(): boolean;
        levelType(): string;
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: Internal.JsonObject, $$2: boolean, $$3: string);
    }
    type DedicatedServerProperties$WorldGenProperties_ = DedicatedServerProperties$WorldGenProperties;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.extensions.ITeleporter
    */
    interface ITeleporter {
        getPortalInfo(entity: Internal.Entity_, destWorld: Internal.ServerLevel_, defaultPortalInfo: Internal.Function_<Internal.ServerLevel_, Internal.PortalInfo_>): Internal.PortalInfo;
        isVanilla(): boolean;
        playTeleportSound(player: Internal.ServerPlayer_, sourceWorld: Internal.ServerLevel_, destWorld: Internal.ServerLevel_): boolean;
        placeEntity(entity: Internal.Entity_, currentWorld: Internal.ServerLevel_, destWorld: Internal.ServerLevel_, yaw: number, repositionEntity: Internal.Function_<boolean, Internal.Entity_>): Internal.Entity;
    }
    type ITeleporter_ = ITeleporter;
    /**
    * @javaClass dev.latvian.mods.kubejs.fluid.FluidBlockBuilder
    */
    class FluidBlockBuilder extends Internal.BlockBuilder {
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        item(i: Internal.Consumer_<Internal.BlockItemBuilder_>): Internal.BlockBuilder;
        createObject(): Internal.Block;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(b: Internal.FluidBuilder);
    }
    type FluidBlockBuilder_ = FluidBlockBuilder;
    /**
    * @javaClass java.io.File
    */
    class File implements Internal.Serializable, Internal.Comparable<Internal.File> {
        getUsableSpace(): number;
        static listRoots(): Internal.File[];
        renameTo(arg0: Internal.File_): boolean;
        getName(): string;
        setExecutable(arg0: boolean): boolean;
        setExecutable(arg0: boolean, arg1: boolean): boolean;
        canRead(): boolean;
        getCanonicalFile(): this;
        compareTo(arg0: Internal.File_): number;
        delete(): boolean;
        setReadable(arg0: boolean): boolean;
        setReadable(arg0: boolean, arg1: boolean): boolean;
        getTotalSpace(): number;
        hashCode(): number;
        getParentFile(): this;
        getPath(): string;
        getAbsoluteFile(): this;
        listFiles(arg0: Internal.FileFilter_): Internal.File[];
        listFiles(arg0: Internal.FilenameFilter_): Internal.File[];
        listFiles(): Internal.File[];
        mkdir(): boolean;
        deleteOnExit(): void;
        canExecute(): boolean;
        getCanonicalPath(): string;
        toURL(): Internal.URL;
        getParent(): string;
        setWritable(arg0: boolean): boolean;
        setWritable(arg0: boolean, arg1: boolean): boolean;
        isFile(): boolean;
        getAbsolutePath(): string;
        toURI(): Internal.URI;
        getFreeSpace(): number;
        length(): number;
        canWrite(): boolean;
        static createTempFile(arg0: string, arg1: string): Internal.File;
        static createTempFile(arg0: string, arg1: string, arg2: Internal.File_): Internal.File;
        list(): string[];
        list(arg0: Internal.FilenameFilter_): string[];
        isHidden(): boolean;
        toPath(): Internal.Path;
        mkdirs(): boolean;
        equals(arg0: any): boolean;
        exists(): boolean;
        isAbsolute(): boolean;
        toString(): string;
        lastModified(): number;
        createNewFile(): boolean;
        setLastModified(arg0: number): boolean;
        isDirectory(): boolean;
        setReadOnly(): boolean;
        static readonly "pathSeparator" : ";";
        static readonly "pathSeparatorChar" : ";";
        static readonly "separatorChar" : "\\";
        static readonly "separator" : "\\";
        get parent(): string;
        get parentFile(): this;
        get hidden(): boolean;
        get freeSpace(): number;
        get usableSpace(): number;
        get totalSpace(): number;
        get canonicalFile(): this;
        get directory(): boolean;
        get path(): string;
        get absoluteFile(): this;
        get file(): boolean;
        get absolute(): boolean;
        get name(): string;
        get canonicalPath(): string;
        get absolutePath(): string;
        set readable(arg0: boolean);
        set executable(arg0: boolean);
        set writable(arg0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: string);
        constructor(arg0: string, arg1: string);
        constructor(arg0: Internal.URI);
        constructor(arg0: Internal.File, arg1: string);
    }
    type File_ = File;
    /**
    * @javaClass dev.ftb.mods.ftbchunks.core.BiomeFTBC
    */
    interface BiomeFTBC {
        getFTBCBiomeColorIndex(): number;
        setFTBCBiomeColorIndex(arg0: number): void;
    }
    type BiomeFTBC_ = BiomeFTBC;
    /**
    * @javaClass java.lang.ClassLoader
    */
    abstract class ClassLoader {
        static getSystemResources(arg0: string): Internal.Enumeration<Internal.URL>;
        getParent(): this;
        getResource(arg0: string): Internal.URL;
        static getPlatformClassLoader(): Internal.ClassLoader;
        getName(): string;
        getResourceAsStream(arg0: string): Internal.InputStream;
        setDefaultAssertionStatus(arg0: boolean): void;
        resources(arg0: string): Internal.Stream<Internal.URL>;
        static getSystemClassLoader(): Internal.ClassLoader;
        static getSystemResource(arg0: string): Internal.URL;
        setPackageAssertionStatus(arg0: string, arg1: boolean): void;
        setClassAssertionStatus(arg0: string, arg1: boolean): void;
        getDefinedPackage(arg0: string): Internal.Package;
        static getSystemResourceAsStream(arg0: string): Internal.InputStream;
        clearAssertionStatus(): void;
        isRegisteredAsParallelCapable(): boolean;
        getResources(arg0: string): Internal.Enumeration<Internal.URL>;
        loadClass(arg0: string): typeof any;
        getDefinedPackages(): Internal.Package[];
        getUnnamedModule(): Internal.Module;
        get parent(): this;
        get systemClassLoader(): Internal.ClassLoader;
        get unnamedModule(): Internal.Module;
        get name(): string;
        get registeredAsParallelCapable(): boolean;
        get platformClassLoader(): Internal.ClassLoader;
        get definedPackages(): Internal.Package[];
        set defaultAssertionStatus(arg0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ClassLoader_ = ClassLoader;
    /**
    * @javaClass io.github.ladysnake.pal.AbilitySource
    */
    class AbilitySource implements Internal.Comparable<Internal.AbilitySource> {
        grants(player: Internal.Player_, ability: Internal.PlayerAbility_): boolean;
        grantTo(player: Internal.Player_, ability: Internal.PlayerAbility_): void;
        getPriority(): number;
        revokeFrom(player: Internal.Player_, ability: Internal.PlayerAbility_): void;
        isActivelyGranting(player: Internal.Player_, ability: Internal.PlayerAbility_): boolean;
        getId(): ResourceLocation;
        toString(): string;
        compareTo(o: Internal.AbilitySource_): number;
        static readonly "CONSUMABLE" : -1000;
        static readonly "FREE" : 2000;
        static readonly "RENEWABLE" : 1000;
        static readonly "DEFAULT" : 0;
        get id(): ResourceLocation;
        get priority(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbilitySource_ = AbilitySource;
    /**
    * @javaClass java.util.regex.Matcher
    */
    class Matcher implements Internal.MatchResult {
        hasTransparentBounds(): boolean;
        requireEnd(): boolean;
        useTransparentBounds(arg0: boolean): this;
        pattern(): Internal.Pattern;
        replaceFirst(arg0: string): string;
        replaceFirst(arg0: Internal.Function_<Internal.MatchResult_, string>): string;
        regionStart(): number;
        replaceAll(arg0: string): string;
        replaceAll(arg0: Internal.Function_<Internal.MatchResult_, string>): string;
        lookingAt(): boolean;
        toMatchResult(): Internal.MatchResult;
        static quoteReplacement(arg0: string): string;
        find(): boolean;
        find(arg0: number): boolean;
        end(arg0: string): number;
        end(): number;
        end(arg0: number): number;
        results(): Internal.Stream<Internal.MatchResult>;
        group(arg0: number): string;
        group(): string;
        group(arg0: string): string;
        start(): number;
        start(arg0: string): number;
        start(arg0: number): number;
        regionEnd(): number;
        matches(): boolean;
        hasAnchoringBounds(): boolean;
        appendReplacement(arg0: Internal.StringBuffer_, arg1: string): this;
        appendReplacement(arg0: Internal.StringBuilder_, arg1: string): this;
        appendTail(arg0: Internal.StringBuilder_): Internal.StringBuilder;
        appendTail(arg0: Internal.StringBuffer_): Internal.StringBuffer;
        groupCount(): number;
        reset(): this;
        reset(arg0: Internal.CharSequence_): this;
        toString(): string;
        region(arg0: number, arg1: number): this;
        useAnchoringBounds(arg0: boolean): this;
        hitEnd(): boolean;
        usePattern(arg0: Internal.Pattern_): this;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Matcher_ = Matcher;
    /**
    * @javaClass net.fabricmc.fabric.mixin.container.ServerPlayerEntityAccessor
    */
    interface ServerPlayerEntityAccessor {
        getScreenHandlerSyncId(): number;
        setScreenHandlerSyncId(arg0: number): void;
        callOnScreenHandlerOpened(arg0: Internal.AbstractContainerMenu_): void;
    }
    type ServerPlayerEntityAccessor_ = ServerPlayerEntityAccessor;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.util.INBTSerializable
    */
    interface INBTSerializable <T> {
        serializeNBT(): T;
        deserializeNBT(arg0: T): void;
    }
    type INBTSerializable_<T> = INBTSerializable<T>;
    /**
    * @javaClass java.nio.FloatBuffer
    */
    abstract class FloatBuffer extends Internal.Buffer implements Internal.Comparable<Internal.FloatBuffer> {
        hasArray(): boolean;
        compact(): this;
        clear(): this;
        duplicate(): this;
        compareTo(arg0: Internal.FloatBuffer_): number;
        asReadOnlyBuffer(): this;
        put(arg0: number[]): this;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        put(arg0: number, arg1: number[]): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        put(arg0: number, arg1: Internal.FloatBuffer_, arg2: number, arg3: number): this;
        put(arg0: Internal.FloatBuffer_): this;
        put(arg0: number, arg1: number): this;
        put(arg0: number): this;
        static allocate(arg0: number): Internal.FloatBuffer;
        rewind(): this;
        slice(arg0: number, arg1: number): this;
        slice(): this;
        array(): number[];
        hashCode(): number;
        mismatch(arg0: Internal.FloatBuffer_): number;
        equals(arg0: any): boolean;
        get(): number;
        get(arg0: number, arg1: number[]): this;
        get(arg0: number): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        get(arg0: number[], arg1: number, arg2: number): this;
        get(arg0: number[]): this;
        limit(arg0: number): this;
        reset(): this;
        arrayOffset(): number;
        toString(): string;
        position(arg0: number): this;
        flip(): this;
        isDirect(): boolean;
        static wrap(arg0: number[]): Internal.FloatBuffer;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.FloatBuffer;
        mark(): this;
        order(): Internal.ByteOrder;
        get direct(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FloatBuffer_ = FloatBuffer;
    /**
    * @javaClass net.minecraft.class_2586
    */
    abstract class BlockEntity implements Internal.INBTSerializable<any>, Internal.BlockEntityExtensions, Internal.BlockEntityAccessor, Internal.ComponentProvider, Internal.AccessorBlockEntity, Internal.Cullable, Internal.RenderAttachmentBlockEntity, Internal.BlockEntityMixin {
        getBlockPos(): BlockPos;
        getRenderAttachmentData(): any;
        setOutOfCamera(value: boolean): void;
        isOutOfCamera(): boolean;
        toComponentPacket(key: Internal.ComponentKey_<any>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        setCulled(value: boolean): void;
        setRemoved(): void;
        setLevel($$0: Internal.Level_): void;
        getUpdatePacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        invalidateCaps(): void;
        serializeNBT(): Internal.CompoundTag;
        isRemoved(): boolean;
        static getPosFromTag($$0: Internal.CompoundTag_): BlockPos;
        load($$0: Internal.CompoundTag_): void;
        hasLevel(): boolean;
        saveWithoutMetadata(): Internal.CompoundTag;
        isCulled(): boolean;
        handler$zck000$port_lib$invalidate(ci: Internal.CallbackInfo_): void;
        saveWithId(): Internal.CompoundTag;
        getUpdateTag(): Internal.CompoundTag;
        fillCrashReportCategory($$0: Internal.CrashReportCategory_): void;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        deserializeNBT(state: Internal.BlockState_, nbt: Internal.CompoundTag_): void;
        saveToItem($$0: Internal.ItemStack_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        setBlockState($$0: Internal.BlockState_): void;
        getComponentContainer(): Internal.ComponentContainer;
        static loadStatic($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Internal.CompoundTag_): Internal.BlockEntity;
        getLevel(): Internal.Level;
        static addEntityType($$0: Internal.CompoundTag_, $$1: Internal.BlockEntityType_<any>): void;
        setTimeout(): void;
        onlyOpCanSetNbt(): boolean;
        getRecipientsForComponentSync(): Internal.Iterator<any>;
        getType(): Internal.BlockEntityType<any>;
        isForcedVisible(): boolean;
        onLoad(): void;
        getExtraCustomData(): Internal.CompoundTag;
        triggerEvent($$0: number, $$1: number): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        clearRemoved(): void;
        setChanged(): void;
        getBlockState(): Internal.BlockState;
        get updateTag(): Internal.CompoundTag;
        get forcedVisible(): boolean;
        get blockState(): Internal.BlockState;
        get culled(): boolean;
        get blockPos(): BlockPos;
        get level(): Internal.Level;
        get extraCustomData(): Internal.CompoundTag;
        get type(): Internal.BlockEntityType<any>;
        get renderAttachmentData(): any;
        get updatePacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        get removed(): boolean;
        get recipientsForComponentSync(): Internal.Iterator<any>;
        get outOfCamera(): boolean;
        get componentContainer(): Internal.ComponentContainer;
        set blockState($$0: Internal.BlockState_);
        set culled(value: boolean);
        set level($$0: Internal.Level_);
        set outOfCamera(value: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockEntityType<any>, $$1: BlockPos, $$2: Internal.BlockState);
    }
    type BlockEntity_ = BlockEntity;
    /**
    * @javaClass com.mojang.datafixers.Products$P4
    */
    class Products$P4 <F, T1, T2, T3, T4> {
        t4(): Internal.App<F, T4>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function4_<T1, T2, T3, T4, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function4_<T1, T2, T3, T4, R>>): Internal.App<F, R>;
        and<T5, T6, T7>(arg0: Internal.Products$P3_<F, T5, T6, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        and<T5, T6, T7, T8>(arg0: Internal.Products$P4_<F, T5, T6, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        and<T5, T6>(arg0: Internal.Products$P2_<F, T5, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
        and<T5>(arg0: Internal.App_<F, T5>): Internal.Products$P5<F, T1, T2, T3, T4, T5>;
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        t3(): Internal.App<F, T3>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.App<F, T1>, arg1: Internal.App<F, T2>, arg2: Internal.App<F, T3>, arg3: Internal.App<F, T4>);
    }
    type Products$P4_<F, T1, T2, T3, T4> = Products$P4<F, T1, T2, T3, T4>;
    /**
    * @javaClass net.fabricmc.fabric.mixin.datagen.DynamicRegistryManagerAccessor
    */
    interface DynamicRegistryManagerAccessor {
    }
    type DynamicRegistryManagerAccessor_ = DynamicRegistryManagerAccessor;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour
    */
    class TrackTargetingBehaviour <T> extends Internal.TileEntityBehaviour {
        createEdgePoint(): T;
        getTrack(): Internal.ITrackBlock;
        getTrackBlockState(): Internal.BlockState;
        getTargetBezier(): Internal.BezierTrackPointLocation;
        read(nbt: Internal.CompoundTag_, clientPacket: boolean): void;
        getEdgePoint(): T;
        getTargetDirection(): Internal.Direction$AxisDirection;
        isOnCurve(): boolean;
        tick(): void;
        getPositionForMapMarker(): BlockPos;
        determineGraphLocation(): Internal.GraphLocation;
        hasValidTrack(): boolean;
        remove(): void;
        getGlobalPosition(): BlockPos;
        transform(transform: Internal.StructureTransform_): void;
        isOrthogonal(): boolean;
        getType(): Internal.BehaviourType<any>;
        isSafeNBT(): boolean;
        invalidateEdgePoint(migrationData: Internal.CompoundTag_): void;
        static render(level: Internal.LevelAccessor_, pos: BlockPos_, direction: Internal.Direction$AxisDirection_, bezier: Internal.BezierTrackPointLocation_, ms: Internal.PoseStack_, buffer: Internal.MultiBufferSource_, light: number, overlay: number, type: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType_, scale: number): void;
        write(nbt: Internal.CompoundTag_, clientPacket: boolean): void;
        static readonly "TYPE" : Internal.BehaviourType<Internal.TrackTargetingBehaviour<any>>;
        get orthogonal(): boolean;
        get positionForMapMarker(): BlockPos;
        get targetBezier(): Internal.BezierTrackPointLocation;
        get targetDirection(): Internal.Direction$AxisDirection;
        get trackBlockState(): Internal.BlockState;
        get globalPosition(): BlockPos;
        get track(): Internal.ITrackBlock;
        get type(): Internal.BehaviourType<any>;
        get safeNBT(): boolean;
        get edgePoint(): T;
        get onCurve(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(te: Internal.SmartTileEntity, edgePointType: Internal.EdgePointType<T>);
    }
    type TrackTargetingBehaviour_<T> = TrackTargetingBehaviour<T>;
    /**
    * @javaClass com.google.common.collect.UnmodifiableIterator
    */
    abstract class UnmodifiableIterator <E> implements Internal.Iterator<E> {
        forEachRemaining(arg0: Internal.Consumer_<E>): void;
        remove(): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type UnmodifiableIterator_<E> = UnmodifiableIterator<E>;
    /**
    * @javaClass com.jozufozu.flywheel.api.vertex.VertexWriter
    */
    interface VertexWriter {
        seekToVertex(arg0: number): void;
        writeVertexList(list: Internal.VertexList_): void;
        writeVertex(arg0: Internal.VertexList_, arg1: number): void;
        intoReader(): Internal.VertexList;
    }
    type VertexWriter_ = VertexWriter;
    /**
    * @javaClass net.coderbot.batchedentityrendering.mixin.RenderStateShardAccessor
    */
    interface RenderStateShardAccessor {
    }
    type RenderStateShardAccessor_ = RenderStateShardAccessor;
    /**
    * @javaClass java.awt.EventQueue
    */
    class EventQueue {
        static getCurrentEvent(): Internal.AWTEvent;
        createSecondaryLoop(): Internal.SecondaryLoop;
        static getMostRecentEventTime(): number;
        peekEvent(arg0: number): Internal.AWTEvent;
        peekEvent(): Internal.AWTEvent;
        getNextEvent(): Internal.AWTEvent;
        static isDispatchThread(): boolean;
        static invokeLater(arg0: Internal.Runnable_): void;
        static invokeAndWait(arg0: Internal.Runnable_): void;
        push(arg0: Internal.EventQueue_): void;
        postEvent(arg0: Internal.AWTEvent_): void;
        get dispatchThread(): boolean;
        get currentEvent(): Internal.AWTEvent;
        get mostRecentEventTime(): number;
        get nextEvent(): Internal.AWTEvent;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type EventQueue_ = EventQueue;
    /**
    * @javaClass net.minecraft.class_4668
    */
    abstract class RenderStateShard implements net.coderbot.iris.mixin.rendertype.RenderStateShardAccessor, Internal.RenderStateShardAccessor, Internal.RenderPhaseAccessor {
        setupRenderState(): void;
        clearRenderState(): void;
        toString(): string;
        static readonly "NEW_ENTITY_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ARMOR_CUTOUT_NO_CULL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "POSITION_COLOR_TEX_LIGHTMAP_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "POSITION_COLOR_LIGHTMAP_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "TRANSLUCENT_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "RENDERTYPE_ENTITY_DECAL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "OVERLAY" : Internal.RenderStateShard$OverlayStateShard;
        static readonly "BLOCK_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ARMOR_GLINT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_ALPHA_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "TRANSLUCENT_TRANSPARENCY" : Internal.RenderStateShard$TransparencyStateShard;
        static readonly "RENDERTYPE_ENTITY_CUTOUT_NO_CULL_Z_OFFSET_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "PARTICLES_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "RENDERTYPE_GLINT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "POSITION_COLOR_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "CRUMBLING_TRANSPARENCY" : Internal.RenderStateShard$TransparencyStateShard;
        static readonly "RENDERTYPE_LIGHTNING_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_SOLID_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_CRUMBLING_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_EYES_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_WATER_MASK_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_CUTOUT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "COLOR_DEPTH_WRITE" : Internal.RenderStateShard$WriteMaskStateShard;
        static readonly "NO_TEXTURE" : Internal.RenderStateShard$EmptyTextureStateShard;
        static readonly "RENDERTYPE_TRIPWIRE_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_CUTOUT_NO_CULL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_SHADOW_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "LIGHTNING_TRANSPARENCY" : Internal.RenderStateShard$TransparencyStateShard;
        static readonly "RENDERTYPE_TRANSLUCENT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "GLINT_TEXTURING" : Internal.RenderStateShard$TexturingStateShard;
        static readonly "ENTITY_GLINT_TEXTURING" : Internal.RenderStateShard$TexturingStateShard;
        static readonly "RENDERTYPE_TRANSLUCENT_NO_CRUMBLING_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_END_GATEWAY_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENERGY_SWIRL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "POSITION_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_GLINT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_BEACON_BEAM_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_TEXT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_CUTOUT_MIPPED_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "DEPTH_WRITE" : Internal.RenderStateShard$WriteMaskStateShard;
        static readonly "RENDERTYPE_OUTLINE_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "CLOUDS_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "POSITION_TEX_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "LIGHTMAP" : Internal.RenderStateShard$LightmapStateShard;
        static readonly "RENDERTYPE_ENTITY_CUTOUT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "ADDITIVE_TRANSPARENCY" : Internal.RenderStateShard$TransparencyStateShard;
        static readonly "NO_LIGHTMAP" : Internal.RenderStateShard$LightmapStateShard;
        static readonly "MAIN_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "RENDERTYPE_GLINT_TRANSLUCENT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_END_PORTAL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "WEATHER_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "LEQUAL_DEPTH_TEST" : Internal.RenderStateShard$DepthTestStateShard;
        static readonly "DEFAULT_LINE" : Internal.RenderStateShard$LineStateShard;
        static readonly "OUTLINE_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "RENDERTYPE_LINES_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "BLOCK_SHEET_MIPPED" : Internal.RenderStateShard$TextureStateShard;
        static readonly "RENDERTYPE_ENTITY_SOLID_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "NO_DEPTH_TEST" : Internal.RenderStateShard$DepthTestStateShard;
        static readonly "POSITION_COLOR_TEX_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_TRANSLUCENT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_NO_OUTLINE_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_TRANSLUCENT_CULL_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "POLYGON_OFFSET_LAYERING" : Internal.RenderStateShard$LayeringStateShard;
        static readonly "NO_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "COLOR_WRITE" : Internal.RenderStateShard$WriteMaskStateShard;
        static readonly "ITEM_ENTITY_TARGET" : Internal.RenderStateShard$OutputStateShard;
        static readonly "RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "DEFAULT_TEXTURING" : Internal.RenderStateShard$TexturingStateShard;
        static readonly "EQUAL_DEPTH_TEST" : Internal.RenderStateShard$DepthTestStateShard;
        static readonly "GLINT_TRANSPARENCY" : Internal.RenderStateShard$TransparencyStateShard;
        static readonly "VIEW_SCALE_Z_EPSILON" : 0.99975586;
        static readonly "RENDERTYPE_TEXT_SEE_THROUGH_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_TEXT_INTENSITY_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "CULL" : Internal.RenderStateShard$CullStateShard;
        static readonly "NO_TRANSPARENCY" : Internal.RenderStateShard$TransparencyStateShard;
        static readonly "VIEW_OFFSET_Z_LAYERING" : Internal.RenderStateShard$LayeringStateShard;
        static readonly "RENDERTYPE_GLINT_DIRECT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "NO_LAYERING" : Internal.RenderStateShard$LayeringStateShard;
        static readonly "RENDERTYPE_TEXT_INTENSITY_SEE_THROUGH_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_TRANSLUCENT_MOVING_BLOCK_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_ENTITY_SMOOTH_CUTOUT_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "RENDERTYPE_LEASH_SHADER" : Internal.RenderStateShard$ShaderStateShard;
        static readonly "NO_OVERLAY" : Internal.RenderStateShard$OverlayStateShard;
        static readonly "BLOCK_SHEET" : Internal.RenderStateShard$TextureStateShard;
        static readonly "NO_CULL" : Internal.RenderStateShard$CullStateShard;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: (() => void), $$2: (() => void));
    }
    type RenderStateShard_ = RenderStateShard;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.management.edgePoint.observer.TrackObserver
    */
    class TrackObserver extends Internal.SingleTileEdgePoint {
        getCurrentTrain(): Internal.UUID;
        getFilter(): Internal.ItemStack;
        keepAlive(train: Internal.Train_): void;
        read(nbt: Internal.CompoundTag_, migration: boolean, dimensions: Internal.DimensionPalette_): void;
        read(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        setFilterAndNotify(level: Internal.Level_, filter: Internal.ItemStack_): void;
        tileAdded(tile: Internal.BlockEntity_, front: boolean): void;
        isActivated(): boolean;
        tick(graph: Internal.TrackGraph_, preTrains: boolean): void;
        write(nbt: Internal.CompoundTag_, dimensions: Internal.DimensionPalette_): void;
        write(buffer: Internal.FriendlyByteBuf_, dimensions: Internal.DimensionPalette_): void;
        get filter(): Internal.ItemStack;
        get currentTrain(): Internal.UUID;
        get activated(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type TrackObserver_ = TrackObserver;
    /**
    * @javaClass net.minecraft.class_539
    */
    class SpectatorPage {
        getSelectedSlot(): number;
        getItem($$0: number): Internal.SpectatorMenuItem;
        static readonly "NO_SELECTION" : -1;
        get selectedSlot(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.List<Internal.SpectatorMenuItem>, $$1: number);
    }
    type SpectatorPage_ = SpectatorPage;
    /**
    * @javaClass com.glisco.things.mixin.access.LockableContainerBlockEntityAccessor
    */
    interface LockableContainerBlockEntityAccessor {
        things$getLock(): Internal.LockCode;
        things$setLock(arg0: Internal.LockCode_): void;
    }
    type LockableContainerBlockEntityAccessor_ = LockableContainerBlockEntityAccessor;
    /**
    * @javaClass net.coderbot.batchedentityrendering.impl.TransparencyType
    */
    class TransparencyType extends Internal.Enum<Internal.TransparencyType> {
        static valueOf(arg0: string): Internal.TransparencyType;
        static values(): Internal.TransparencyType[];
        static readonly "DECAL" : Internal.TransparencyType;
        static readonly "GENERAL_TRANSPARENT" : Internal.TransparencyType;
        static readonly "OPAQUE" : Internal.TransparencyType;
        static readonly "WATER_MASK" : Internal.TransparencyType;
        static readonly "LINES" : Internal.TransparencyType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TransparencyType_ = "water_mask" | "opaque" | "general_transparent" | "lines" | "decal" | TransparencyType;
    /**
    * @javaClass net.minecraft.class_293$class_5595
    */
    class VertexFormat$IndexType extends Internal.Enum<Internal.VertexFormat$IndexType> {
        static valueOf($$0: string): Internal.VertexFormat$IndexType;
        static values(): Internal.VertexFormat$IndexType[];
        static least($$0: number): Internal.VertexFormat$IndexType;
        readonly "bytes" : number;
        static readonly "BYTE" : Internal.VertexFormat$IndexType;
        readonly "asGLType" : number;
        static readonly "INT" : Internal.VertexFormat$IndexType;
        static readonly "SHORT" : Internal.VertexFormat$IndexType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type VertexFormat$IndexType_ = "byte" | "short" | "int" | VertexFormat$IndexType;
    /**
    * @javaClass vazkii.botania.mixin.AccessorSoundType
    */
    interface AccessorSoundType {
        botania_getBreakSound(): Internal.SoundEvent;
    }
    type AccessorSoundType_ = AccessorSoundType;
    /**
    * @javaClass net.minecraft.class_4985
    */
    class Strider extends Internal.Animal implements Internal.ItemSteerable, Internal.Saddleable {
        method_6725(): boolean;
        method_5956(): boolean;
        isSuffocating(): boolean;
        setSuffocating($$0: boolean): void;
        method_26319($$0: Internal.FluidState_): boolean;
        method_5957($$0: Internal.LevelReader_): boolean;
        method_29503(): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_26316(): number;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        method_26315($$0: Vec3_): void;
        method_6091($$0: Vec3_): void;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        method_5621(): number;
        alwaysAccepts(): boolean;
        method_6576($$0: Internal.SoundSource_): void;
        method_6577(): boolean;
        method_5642(): Internal.Entity;
        static checkStriderSpawnRules($$0: Internal.EntityType_<Internal.Strider_>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.Random_): boolean;
        method_5943($$0: Internal.ServerLevelAccessor_, $$1: Internal.DifficultyInstance_, $$2: Internal.MobSpawnType_, $$3: Internal.SpawnGroupData_, $$4: Internal.CompoundTag_): Internal.SpawnGroupData;
        method_24829($$0: Internal.LivingEntity_): Vec3;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        method_29919(): Vec3;
        method_5809(): boolean;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        getMoveSpeed(): number;
        method_6481($$0: Internal.ItemStack_): boolean;
        method_5992($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_6144($$0: BlockPos_, $$1: Internal.LevelReader_): number;
        travel($$0: Internal.Mob_, $$1: Internal.ItemBasedSteering_, $$2: Vec3_): boolean;
        method_6765(): boolean;
        thonkutil$getId(): ResourceLocation;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5773(): void;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        get suffocating(): boolean;
        get moveSpeed(): number;
        get stepHeight(): number;
        set suffocating($$0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Strider>, $$1: Internal.Level);
    }
    type Strider_ = Strider;
    /**
    * @javaClass net.minecraft.class_5455$class_6890
    */
    interface RegistryAccess$Frozen extends Internal.RegistryAccess {
        allElementsLifecycle(): Internal.Lifecycle;
        registry<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Optional<Internal.Registry<E>>;
        ownedRegistryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Registry<E>;
        registries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
        registryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry_<E>>): Internal.Registry<E>;
        networkSafeRegistries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
        method_40316(): this;
    }
    type RegistryAccess$Frozen_ = RegistryAccess$Frozen;
    /**
    * @javaClass com.simibubi.create.foundation.tileEntity.CachedRenderBBTileEntity
    */
    abstract class CachedRenderBBTileEntity extends Internal.SyncedTileEntity implements Internal.CustomRenderBoundingBoxBlockEntity {
        invalidateCaps(): void;
        getInfiniteBoundingBox(): Internal.AABB;
        getRenderBoundingBox(): Internal.AABB;
        self(): Internal.BlockEntity;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        get renderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(type: Internal.BlockEntityType<any>, pos: BlockPos, state: Internal.BlockState);
    }
    type CachedRenderBBTileEntity_ = CachedRenderBBTileEntity;
    /**
    * @javaClass xaero.map.WorldMapSession
    */
    class WorldMapSession {
        init(): void;
        isUsable(): boolean;
        getControlsHandler(): Internal.ControlsHandler;
        cleanup(): void;
        static getCurrentSession(): Internal.WorldMapSession;
        static getForPlayer(player: Internal.LocalPlayer_): Internal.WorldMapSession;
        getMapProcessor(): Internal.MapProcessor;
        get usable(): boolean;
        get currentSession(): Internal.WorldMapSession;
        get mapProcessor(): Internal.MapProcessor;
        get controlsHandler(): Internal.ControlsHandler;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type WorldMapSession_ = WorldMapSession;
    /**
    * @javaClass net.minecraft.class_542$class_545
    */
    class GameConfig$GameData {
        readonly "versionType" : string;
        readonly "disableChat" : boolean;
        readonly "disableMultiplayer" : boolean;
        readonly "launchVersion" : string;
        readonly "demo" : boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: boolean, $$1: string, $$2: string, $$3: boolean, $$4: boolean);
    }
    type GameConfig$GameData_ = GameConfig$GameData;
    /**
    * @javaClass net.minecraft.class_9
    */
    class Node {
        static createFromStream($$0: Internal.FriendlyByteBuf_): Internal.Node;
        distanceTo($$0: Internal.Node_): number;
        distanceTo($$0: BlockPos_): number;
        distanceToSqr($$0: Internal.Node_): number;
        distanceToSqr($$0: BlockPos_): number;
        writeToStream($$0: Internal.FriendlyByteBuf_): void;
        asVec3(): Vec3;
        inOpenSet(): boolean;
        distanceManhattan($$0: Internal.Node_): number;
        distanceManhattan($$0: BlockPos_): number;
        asBlockPos(): BlockPos;
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        static createHash($$0: number, $$1: number, $$2: number): number;
        cloneAndMove($$0: number, $$1: number, $$2: number): this;
        "cameFrom" : Internal.Node;
        "f" : number;
        "g" : number;
        readonly "x" : number;
        "h" : number;
        readonly "y" : number;
        "closed" : boolean;
        readonly "z" : number;
        "walkedDistance" : number;
        "costMalus" : number;
        "type" : Internal.BlockPathTypes;
        "heapIdx" : number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: number, $$2: number);
    }
    type Node_ = Node;
    /**
    * @javaClass com.telepathicgrunt.repurposedstructures.mixin.structures.TemplateAccessor
    */
    interface TemplateAccessor {
        repurposedstructures_getPalettes(): Internal.List<Internal.StructureTemplate$Palette>;
    }
    type TemplateAccessor_ = TemplateAccessor;
    /**
    * @javaClass net.minecraft.class_4703
    */
    class BeeDebugRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        addOrUpdateHiveInfo($$0: Internal.BeeDebugRenderer$HiveInfo_): void;
        method_23109($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        addOrUpdateBeeInfo($$0: Internal.BeeDebugRenderer$BeeInfo_): void;
        method_20414(): void;
        removeBeeInfo($$0: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Minecraft);
    }
    type BeeDebugRenderer_ = BeeDebugRenderer;
    /**
    * @javaClass com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld
    */
    class WrappedWorld extends Internal.Level {
        method_8649(entityIn: Internal.Entity_): boolean;
        method_35230<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        method_24852(p_230487_1_: Internal.Direction_, p_230487_2_: boolean): number;
        getMoonPhase(): number;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity_>): Internal.Player;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        method_30349(): Internal.RegistryAccess;
        method_17889(): number;
        method_8652(pos: BlockPos_, newState: Internal.BlockState_, flags: number): boolean;
        method_18456(): Internal.List<Internal.Player>;
        method_32888(pEntity: Internal.Entity_, pEvent: Internal.GameEvent_, pPos: BlockPos_): void;
        method_8413(pos: BlockPos_, oldState: Internal.BlockState_, newState: Internal.BlockState_, flags: number): void;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getMaxLightLevel(): number;
        method_8517(breakerId: number, pos: BlockPos_, progress: number): void;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        method_22387(p_225604_1_: number, p_225604_2_: number, p_225604_3_: number): Internal.Holder<Internal.Biome>;
        method_23752($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        method_32890(): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        method_32891(): number;
        method_31604(sectionIndex: number): number;
        method_31605(): number;
        method_31602(y: number): number;
        method_31603(sectionY: number): number;
        method_31600(): number;
        method_8405(): Internal.LevelTickAccess<Internal.Fluid>;
        method_31601(y: number): boolean;
        method_8428(): Internal.Scoreboard;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        method_31606(pos: BlockPos_): boolean;
        method_31607(): number;
        method_8393($$0: number, $$1: number): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        method_8397(): Internal.LevelTickAccess<Internal.Block>;
        method_8433(): Internal.RecipeManager;
        method_8398(): Internal.ChunkSource;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        noCollision($$0: Internal.Entity_): boolean;
        noCollision($$0: Internal.AABB_): boolean;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        method_20743($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getLevel(): Internal.Level;
        getTimeOfDay($$0: number): number;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        method_31597(): number;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getNearbyEntities<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        method_16359($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        method_8455(p_175666_1_: BlockPos_, p_175666_2_: Internal.Block_): void;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        setChunkSource(source: Internal.ChunkSource_): void;
        method_8611($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        method_16358(p_217375_1_: BlockPos_, p_217375_2_: Internal.Predicate_<Internal.BlockState_>): boolean;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getBrightness($$0: BlockPos_): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        isEmptyBlock($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getNearestEntity<T>($$0: Internal.Class_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        getNearestEntity<T>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getRecipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        method_30271(): number;
        method_8320(pos: BlockPos_): Internal.BlockState;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        method_8444(player: Internal.Player_, type: number, pos: BlockPos_, data: number): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        method_8321(pos: BlockPos_): Internal.BlockEntity;
        method_8449(p_217384_1_: Internal.Player_, p_217384_2_: Internal.Entity_, p_217384_3_: Internal.SoundEvent_, p_217384_4_: Internal.SoundSource_, p_217384_5_: number, p_217384_6_: number): void;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getMoonBrightness(): number;
        method_22336(): Internal.LevelLightEngine;
        method_22339(pos: BlockPos_): number;
        getLightEmission($$0: BlockPos_): number;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        toComponentPacket<C>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        hasChunkAt($$0: BlockPos_): boolean;
        hasChunkAt($$0: number, $$1: number): boolean;
        method_8598($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        method_17891(mapName: string): Internal.MapItemSavedData;
        method_31419(): string;
        method_17890(pMapId: string, pData: Internal.MapItemSavedData_): void;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        asKJS(): Internal.LevelJS;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_): Internal.List<T>;
        getEntitiesOfClass<T>($$0: Internal.Class_<T>, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_): void;
        gameEvent($$0: Internal.GameEvent_, $$1: Internal.Entity_): void;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Internal.Entity_): void;
        method_8465(player: Internal.Player_, x: number, y: number, z: number, soundIn: Internal.SoundEvent_, category: Internal.SoundSource_, volume: number, pitch: number): void;
        getDifficulty(): Internal.Difficulty;
        method_8469(id: number): Internal.Entity;
        get difficulty(): Internal.Difficulty;
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>;
        get recipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        get level(): Internal.Level;
        get moonPhase(): number;
        get maxLightLevel(): number;
        get moonBrightness(): number;
        set chunkSource(source: Internal.ChunkSource_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(world: Internal.Level);
    }
    type WrappedWorld_ = WrappedWorld;
    /**
    * @javaClass dev.tr7zw.entityculling.access.EntityRendererInter
    */
    interface EntityRendererInter <T> {
        shadowRenderNameTag(arg0: T, arg1: net.minecraft.network.chat.Component_, arg2: Internal.PoseStack_, arg3: Internal.MultiBufferSource_, arg4: number): void;
        shadowShouldShowName(arg0: T): boolean;
    }
    type EntityRendererInter_<T> = EntityRendererInter<T>;
    /**
    * @javaClass net.fabricmc.fabric.api.client.screen.v1.ScreenEvents$Remove
    */
    interface ScreenEvents$Remove {
        onRemove(arg0: Internal.Screen_): void;
    }
    type ScreenEvents$Remove_ = ((arg0: Internal.Screen) => void) | ScreenEvents$Remove;
    /**
    * @javaClass me.cominixo.betterf3.ducks.ClientChunkManagerAccess
    */
    interface ClientChunkManagerAccess {
        getChunks(): Internal.ClientChunkCache$Storage;
    }
    type ClientChunkManagerAccess_ = ClientChunkManagerAccess;
    /**
    * @javaClass net.minecraft.class_5709
    */
    class EntityPositionSource implements Internal.PositionSource {
        method_32955(): Internal.PositionSourceType<any>;
        method_32956($$0: Internal.Level_): Internal.Optional<BlockPos>;
        static readonly "CODEC" : Internal.Codec<Internal.EntityPositionSource>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number);
    }
    type EntityPositionSource_ = EntityPositionSource;
    /**
    * @javaClass dev.latvian.mods.kubejs.core.PlayerKJS
    */
    interface PlayerKJS {
        setStagesKJS(arg0: Internal.Stages_): void;
        getStagesRawKJS(): Internal.Stages;
        getStagesKJS(): Internal.Stages;
    }
    type PlayerKJS_ = PlayerKJS;
    /**
    * @javaClass net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon
    */
    abstract class AbstractChanneledNetworkAddon <H> extends Internal.AbstractNetworkAddon<H> implements Internal.PacketSender {
        sendPacket(packet: Internal.Packet_<any>, callback: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<void>>): void;
        sendPacket(packet: Internal.Packet_<any>): void;
        sendPacket(channel: ResourceLocation_, buf: Internal.FriendlyByteBuf_): void;
        sendPacket(channel: ResourceLocation_, buf: Internal.FriendlyByteBuf_, callback: Internal.GenericFutureListener_<io.netty.util.concurrent.Future_<void>>): void;
        getSendableChannels(): Internal.Set<ResourceLocation>;
        lateInit(): void;
        get sendableChannels(): Internal.Set<ResourceLocation>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractChanneledNetworkAddon_<H> = AbstractChanneledNetworkAddon<H>;
    /**
    * @javaClass ladysnake.satin.mixin.client.render.RenderPhaseAccessor
    */
    interface RenderPhaseAccessor {
        getName(): string;
    }
    type RenderPhaseAccessor_ = RenderPhaseAccessor;
    /**
    * @javaClass com.mojang.serialization.Dynamic
    */
    class Dynamic <T> extends Internal.DynamicLike<T> {
        updateGeneric(arg0: T, arg1: Internal.Function_<T, T>): Internal.Dynamic<T>;
        getElementGeneric(arg0: T): Internal.DataResult<T>;
        updateMapValues(arg0: Internal.Function_<com.mojang.datafixers.util.Pair_<Internal.Dynamic_<any>, Internal.Dynamic_<any>>, com.mojang.datafixers.util.Pair_<Internal.Dynamic_<any>, Internal.Dynamic_<any>>>): Internal.Dynamic<T>;
        asLongStreamOpt(): Internal.DataResult<Internal.LongStream>;
        asStreamOpt(): Internal.DataResult<Internal.Stream<Internal.Dynamic<T>>>;
        update(arg0: string, arg1: Internal.Function_<Internal.Dynamic_<any>, Internal.Dynamic_<any>>): Internal.Dynamic<T>;
        convert<R>(arg0: Internal.DynamicOps_<R>): Internal.Dynamic<R>;
        static convert<S, T>(arg0: Internal.DynamicOps_<S>, arg1: Internal.DynamicOps_<T>, arg2: S): T;
        decode<A>(arg0: Internal.Decoder_<A>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        asIntStreamOpt(): Internal.DataResult<Internal.IntStream>;
        remove(arg0: string): Internal.Dynamic<T>;
        getMapValues(): Internal.DataResult<Internal.Map<Internal.Dynamic<T>, Internal.Dynamic<T>>>;
        into<V>(arg0: Internal.Function_<Internal.Dynamic_<T>, V>): V;
        cast<U>(arg0: Internal.DynamicOps_<U>): U;
        hashCode(): number;
        merge(arg0: Internal.Dynamic_<any>): Internal.OptionalDynamic<T>;
        merge(arg0: Internal.Dynamic_<any>, arg1: Internal.Dynamic_<any>): Internal.OptionalDynamic<T>;
        get(arg0: string): Internal.OptionalDynamic<T>;
        asString(): Internal.DataResult<string>;
        map(arg0: Internal.Function_<T, T>): Internal.Dynamic<T>;
        asByteBufferOpt(): Internal.DataResult<Internal.ByteBuffer>;
        set(arg0: string, arg1: Internal.Dynamic_<any>): Internal.Dynamic<T>;
        getGeneric(arg0: T): Internal.DataResult<T>;
        asNumber(): Internal.DataResult<Internal.Number>;
        asMapOpt(): Internal.DataResult<Internal.Stream<com.mojang.datafixers.util.Pair<Internal.Dynamic<T>, Internal.Dynamic<T>>>>;
        castTyped<U>(arg0: Internal.DynamicOps_<U>): Internal.Dynamic<U>;
        getValue(): T;
        getElement(arg0: string): Internal.DataResult<T>;
        equals(arg0: any): boolean;
        toString(): string;
        get mapValues(): Internal.DataResult<Internal.Map<Internal.Dynamic<T>, Internal.Dynamic<T>>>;
        get value(): T;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.DynamicOps<T>);
        constructor(arg0: Internal.DynamicOps<T>, arg1: T);
    }
    type Dynamic_<T> = Dynamic<T>;
    /**
    * @javaClass net.minecraft.class_6383
    */
    interface NarrationSupplier {
        updateNarration(arg0: Internal.NarrationElementOutput_): void;
    }
    type NarrationSupplier_ = NarrationSupplier;
    /**
    * @javaClass net.minecraft.class_4661
    */
    class LeaveVineDecorator extends Internal.TreeDecorator {
        method_23469($$0: Internal.LevelSimulatedReader_, $$1: Internal.BiConsumer_<BlockPos_, Internal.BlockState_>, $$2: Internal.Random_, $$3: Internal.List_<BlockPos_>, $$4: Internal.List_<BlockPos_>): void;
        static readonly "CODEC" : Internal.Codec<Internal.LeaveVineDecorator>;
        static readonly "INSTANCE" : Internal.LeaveVineDecorator;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type LeaveVineDecorator_ = LeaveVineDecorator;
    /**
    * @javaClass net.minecraft.class_542$class_547
    */
    class GameConfig$UserData {
        readonly "proxy" : Internal.Proxy;
        readonly "userProperties" : Internal.PropertyMap;
        readonly "profileProperties" : Internal.PropertyMap;
        readonly "user" : Internal.User;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.User, $$1: Internal.PropertyMap, $$2: Internal.PropertyMap, $$3: Internal.Proxy);
    }
    type GameConfig$UserData_ = GameConfig$UserData;
    /**
    * @javaClass net.minecraft.class_1058
    */
    class TextureAtlasSprite implements Internal.AutoCloseable, Internal.TextureAtlasSpriteExtensions, Internal.SpriteExtension, Internal.SpriteAccessor, Internal.TextureAtlasSpriteAccessor, Internal.TextureAtlasSpriteExtension, Internal.SpriteExtended {
        getPBRHolder(): Internal.PBRSpriteHolder;
        getName(): ResourceLocation;
        upload($$0: number, $$1: number, $$2: Internal.NativeImage_[]): void;
        atlas(): Internal.TextureAtlas;
        getU1(): number;
        getU0(): number;
        getWidth(): number;
        getFrameCount(): number;
        isActive(): boolean;
        getU($$0: number): number;
        getUOffset($$0: number): number;
        getHeight(): number;
        getPixelRGBA(frameIndex: number, x: number, y: number): number;
        isTransparent($$0: number, $$1: number, $$2: number): boolean;
        setEmissiveSprite(sprite: Internal.TextureAtlasSprite_): void;
        close(): void;
        getEmissiveSprite(): this;
        getOrCreatePBRHolder(): Internal.PBRSpriteHolder;
        getAnimationTicker(): Internal.Tickable;
        getV1(): number;
        uvShrinkRatio(): number;
        getV0(): number;
        getUniqueFrames(): Internal.IntStream;
        getV($$0: number): number;
        getX(): number;
        getY(): number;
        setActive(active: boolean): void;
        uploadFirstFrame(): void;
        toString(): string;
        getVOffset($$0: number): number;
        wrap($$0: Internal.VertexConsumer_): Internal.VertexConsumer;
        readonly "mainImage" : Internal.NativeImage[];
        readonly "width" : number;
        readonly "height" : number;
        get animationTicker(): Internal.Tickable;
        get pBRHolder(): Internal.PBRSpriteHolder;
        get uniqueFrames(): Internal.IntStream;
        get emissiveSprite(): this;
        get active(): boolean;
        get orCreatePBRHolder(): Internal.PBRSpriteHolder;
        get frameCount(): number;
        get name(): ResourceLocation;
        get x(): number;
        get y(): number;
        get v0(): number;
        get u0(): number;
        get v1(): number;
        get u1(): number;
        set emissiveSprite(sprite: Internal.TextureAtlasSprite_);
        set active(active: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TextureAtlasSprite_ = TextureAtlasSprite;
    /**
    * @javaClass net.minecraft.class_4482
    */
    class BeehiveBlockEntity extends Internal.BlockEntity {
        emptyAllLivingFromHive($$0: Internal.Player_, $$1: Internal.BlockState_, $$2: Internal.BeehiveBlockEntity$BeeReleaseStatus_): void;
        addOccupantWithPresetTicks($$0: Internal.Entity_, $$1: boolean, $$2: number): void;
        isEmpty(): boolean;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BeehiveBlockEntity_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        static getHoneyLevel($$0: Internal.BlockState_): number;
        isFireNearby(): boolean;
        invalidateCaps(): void;
        addOccupant($$0: Internal.Entity_, $$1: boolean): void;
        writeBees(): Internal.ListTag;
        getOccupantCount(): number;
        storeBee($$0: Internal.CompoundTag_, $$1: number, $$2: boolean): void;
        onLoad(): void;
        method_5431(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        isFull(): boolean;
        isSedated(): boolean;
        method_11014($$0: Internal.CompoundTag_): void;
        static readonly "MIN_OCCUPATION_TICKS" : "MinOccupationTicks";
        static readonly "HAS_NECTAR" : "HasNectar";
        static readonly "ENTITY_DATA" : "EntityData";
        static readonly "TICKS_IN_HIVE" : "TicksInHive";
        static readonly "MIN_OCCUPATION_TICKS_NECTARLESS" : 600;
        static readonly "TAG_FLOWER_POS" : "FlowerPos";
        static readonly "MAX_OCCUPANTS" : 3;
        static readonly "BEES" : "Bees";
        get sedated(): boolean;
        get fireNearby(): boolean;
        get occupantCount(): number;
        get empty(): boolean;
        get full(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.BlockState);
    }
    type BeehiveBlockEntity_ = BeehiveBlockEntity;
    /**
    * @javaClass it.unimi.dsi.fastutil.ints.IntCollection
    */
    interface IntCollection extends Internal.Collection<number>, Internal.IntIterable {
        add(arg0: number): boolean;
        spliterator(): Internal.IntSpliterator;
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: Internal.IntConsumer_): void;
        forEach(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        containsAll(arg0: Internal.IntCollection_): boolean;
        intIterator(): Internal.IntIterator;
        intSpliterator(): Internal.IntSpliterator;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: Internal.IntPredicate_): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.ints.IntPredicate_): boolean;
        intStream(): Internal.IntStream;
        removeAll(arg0: Internal.IntCollection_): boolean;
        contains(arg0: any): boolean;
        contains(arg0: number): boolean;
        iterator(): Internal.IntIterator;
        addAll(arg0: Internal.IntCollection_): boolean;
        stream(): Internal.Stream<number>;
        toIntArray(arg0: number[]): number[];
        toIntArray(): number[];
        toArray(arg0: number[]): number[];
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<number>;
        rem(arg0: number): boolean;
        intParallelStream(): Internal.IntStream;
        retainAll(arg0: Internal.IntCollection_): boolean;
    }
    type IntCollection_ = IntCollection;
    /**
    * @javaClass io.netty.channel.RecvByteBufAllocator
    */
    interface RecvByteBufAllocator {
        newHandle(): Internal.RecvByteBufAllocator$Handle;
    }
    type RecvByteBufAllocator_ = RecvByteBufAllocator;
    /**
    * @javaClass vazkii.botania.client.core.SkyblockWorldInfo
    */
    interface SkyblockWorldInfo {
        isGardenOfGlass(): boolean;
        markGardenOfGlass(): void;
    }
    type SkyblockWorldInfo_ = SkyblockWorldInfo;
    /**
    * @javaClass com.glisco.victus.mixin.SpellcastingIllagerEntityAccessor
    */
    interface SpellcastingIllagerEntityAccessor {
        victus_invokeGetCastSpellSound(): Internal.SoundEvent;
        victus_setSpellTicks(arg0: number): void;
    }
    type SpellcastingIllagerEntityAccessor_ = SpellcastingIllagerEntityAccessor;
    /**
    * @javaClass tfar.dankstorage.mixin.SimpleContainerAccess
    */
    interface SimpleContainerAccess {
        getItems(): Internal.NonNullList<Internal.ItemStack>;
        setSize(arg0: number): void;
        setItems(arg0: Internal.NonNullList_<Internal.ItemStack_>): void;
    }
    type SimpleContainerAccess_ = SimpleContainerAccess;
    /**
    * @javaClass net.minecraft.class_3288
    */
    class Pack implements Internal.AutoCloseable {
        isRequired(): boolean;
        getId(): string;
        getChatLink($$0: boolean): net.minecraft.network.chat.Component;
        getDescription(): net.minecraft.network.chat.Component;
        getTitle(): net.minecraft.network.chat.Component;
        isFixedPosition(): boolean;
        hashCode(): number;
        getCompatibility(): Internal.PackCompatibility;
        equals($$0: any): boolean;
        getDefaultPosition(): Internal.Pack$Position;
        static create($$0: string, $$1: boolean, $$2: Internal.Supplier_<Internal.PackResources_>, $$3: Internal.Pack$PackConstructor_, $$4: Internal.Pack$Position_, $$5: Internal.PackSource_): Internal.Pack;
        close(): void;
        getPackSource(): Internal.PackSource;
        open(): Internal.PackResources;
        get defaultPosition(): Internal.Pack$Position;
        get packSource(): Internal.PackSource;
        get description(): net.minecraft.network.chat.Component;
        get fixedPosition(): boolean;
        get id(): string;
        get title(): net.minecraft.network.chat.Component;
        get compatibility(): Internal.PackCompatibility;
        get required(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: string, $$1: net.minecraft.network.chat.Component, $$2: boolean, $$3: (() => Internal.PackResources), $$4: Internal.PackMetadataSection, $$5: Internal.PackType, $$6: Internal.Pack$Position, $$7: Internal.PackSource);
        constructor($$0: string, $$1: boolean, $$2: (() => Internal.PackResources), $$3: net.minecraft.network.chat.Component, $$4: net.minecraft.network.chat.Component, $$5: Internal.PackCompatibility, $$6: Internal.Pack$Position, $$7: boolean, $$8: Internal.PackSource);
    }
    type Pack_ = Pack;
    /**
    * @javaClass java.nio.ShortBuffer
    */
    abstract class ShortBuffer extends Internal.Buffer implements Internal.Comparable<Internal.ShortBuffer> {
        hasArray(): boolean;
        compact(): this;
        clear(): this;
        duplicate(): this;
        compareTo(arg0: Internal.ShortBuffer_): number;
        asReadOnlyBuffer(): this;
        put(arg0: number[]): this;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        put(arg0: number, arg1: number[]): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        put(arg0: number, arg1: Internal.ShortBuffer_, arg2: number, arg3: number): this;
        put(arg0: Internal.ShortBuffer_): this;
        put(arg0: number, arg1: number): this;
        put(arg0: number): this;
        static allocate(arg0: number): Internal.ShortBuffer;
        rewind(): this;
        slice(arg0: number, arg1: number): this;
        slice(): this;
        array(): number[];
        hashCode(): number;
        mismatch(arg0: Internal.ShortBuffer_): number;
        equals(arg0: any): boolean;
        get(): number;
        get(arg0: number, arg1: number[]): this;
        get(arg0: number): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        get(arg0: number[], arg1: number, arg2: number): this;
        get(arg0: number[]): this;
        limit(arg0: number): this;
        reset(): this;
        arrayOffset(): number;
        toString(): string;
        position(arg0: number): this;
        flip(): this;
        isDirect(): boolean;
        static wrap(arg0: number[]): Internal.ShortBuffer;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.ShortBuffer;
        mark(): this;
        order(): Internal.ByteOrder;
        get direct(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ShortBuffer_ = ShortBuffer;
    /**
    * @javaClass com.simibubi.create.content.logistics.trains.TrackEdge
    */
    class TrackEdge {
        getNormal(node1: Internal.TrackNode_, node2: Internal.TrackNode_, t: number): Vec3;
        static read(node1: Internal.TrackNode_, node2: Internal.TrackNode_, tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): Internal.TrackEdge;
        getDirection(fromFirst: boolean): Vec3;
        getDirectionAt(t: number): Vec3;
        isTurn(): boolean;
        canTravelTo(other: Internal.TrackEdge_): boolean;
        isInterDimensional(): boolean;
        incrementT(currentT: number, distance: number): number;
        getIntersection(node1: Internal.TrackNode_, node2: Internal.TrackNode_, other: Internal.TrackEdge_, other1: Internal.TrackNode_, other2: Internal.TrackNode_): Internal.Collection<number[]>;
        getEdgeData(): Internal.EdgeData;
        getPosition(t: number): Vec3;
        getTurn(): Internal.BezierConnection;
        getLength(): number;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        "node2" : Internal.TrackNode;
        "node1" : Internal.TrackNode;
        get interDimensional(): boolean;
        get length(): number;
        get turn(): Internal.BezierConnection;
        get edgeData(): Internal.EdgeData;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(node1: Internal.TrackNode, node2: Internal.TrackNode, turn: Internal.BezierConnection);
    }
    type TrackEdge_ = TrackEdge;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.ItemStackJS
    */
    class ItemStackJS implements Internal.IngredientJS, Internal.NBTSerializable, Internal.ChangeListener<net.minecraft.nbt.Tag>, Internal.SpecialEquality {
        getItemIds(): Internal.Set<string>;
        getNbt(): Internal.CompoundTag;
        isBlock(): boolean;
        getName(): net.minecraft.network.chat.Component;
        getStacks(): Internal.Set<Internal.ItemStackJS>;
        getVanillaItems(): Internal.Set<Internal.Item>;
        static findGroup(id: string): Internal.CreativeModeTab;
        getItem(): Internal.Item;
        hasEnchantment(enchantment: Internal.Enchantment_, level: number): boolean;
        getTags(): Internal.Collection<ResourceLocation>;
        getItemGroup(): string;
        setChance(c: number): void;
        static getList(): Internal.List<Internal.ItemStackJS>;
        getFirst(): this;
        withChance(c: number): this;
        withName(displayName: net.minecraft.network.chat.Component_): this;
        getCount(): number;
        setCount(count: number): void;
        hasTag(tag: ResourceLocation_): boolean;
        testVanillaItem(item: Internal.Item_): boolean;
        test(other: Internal.ItemStackJS_): boolean;
        hasChance(): boolean;
        asIngredientStack(): Internal.IngredientStackJS;
        static getRawItem(o: any): Internal.Item;
        getNbtString(): string;
        createVanillaIngredient(): Internal.Ingredient;
        toJson(): Internal.JsonElement;
        isNBTEqual(other: Internal.ItemStack_): boolean;
        isNBTEqual(other: Internal.ItemStackJS_): boolean;
        withCount(c: number): this;
        static getListJS(): Internal.ListJS;
        specialEquals(o: any, shallow: boolean): boolean;
        anyStackMatches(ingredient: Internal.IngredientJS_): boolean;
        hasNBT(): boolean;
        areItemsEqual(other: Internal.ItemStackJS_): boolean;
        areItemsEqual(other: Internal.ItemStack_): boolean;
        getMod(): string;
        getChance(): number;
        isInvalidRecipeIngredient(): boolean;
        /**
        */
        getId(): Special.Item & `${string}:${string}`;
        weakNBT(): Internal.IngredientJS;
        static clearListCache(): void;
        not(): Internal.IngredientJS;
        toNBT(): Internal.CompoundTag;
        getHarvestSpeed(block: Internal.BlockContainerJS_): number;
        getHarvestSpeed(): number;
        hashCode(): number;
        toRawResultJson(): Internal.JsonElement;
        static of(o: any): Internal.ItemStackJS;
        getItemStack(): Internal.ItemStack;
        copy(): this;
        withNBT(nbt: Internal.CompoundTag_): this;
        toResultJson(): Internal.JsonElement;
        onChanged(o: net.minecraft.nbt.Tag_): void;
        static getTypeList(): Internal.ListJS;
        isEmpty(): boolean;
        strongEquals(o: any): boolean;
        getVanillaPredicate(): Internal.Predicate<Internal.ItemStack>;
        filter(filter: Internal.IngredientJS_): Internal.IngredientJS;
        getEnchantments(): Internal.MapJS;
        getFluidStack(): Internal.FluidStackJS;
        removeNBT(): this;
        static resultFromRecipeJson(json: Internal.JsonElement_): Internal.ItemStackJS;
        unwrapStackIngredient(): Internal.List<Internal.IngredientJS>;
        enchant(enchantment: Internal.Enchantment_, level: number): this;
        enchant(enchantments: Internal.MapJS_): this;
        testVanilla(other: Internal.ItemStack_): boolean;
        equals(o: any): boolean;
        x(c: number): Internal.IngredientJS;
        ignoreNBT(): Internal.IngredientJS;
        getTypeData(): Internal.CompoundTag;
        toString(): string;
        removeChance(): void;
        setNbt(tag: Internal.CompoundTag_): void;
        static readonly "EMPTY" : Internal.ItemStackJS;
        get nbt(): Internal.CompoundTag;
        get itemStack(): Internal.ItemStack;
        get mod(): string;
        get itemIds(): Internal.Set<string>;
        get vanillaItems(): Internal.Set<Internal.Item>;
        get empty(): boolean;
        get harvestSpeed(): number;
        get typeList(): Internal.ListJS;
        get nbtString(): string;
        get block(): boolean;
        /**
        */
        get id(): Special.Item & `${string}:${string}`;
        get invalidRecipeIngredient(): boolean;
        get itemGroup(): string;
        get item(): Internal.Item;
        get chance(): number;
        get stacks(): Internal.Set<Internal.ItemStackJS>;
        get count(): number;
        get list(): Internal.List<Internal.ItemStackJS>;
        get enchantments(): Internal.MapJS;
        get typeData(): Internal.CompoundTag;
        get listJS(): Internal.ListJS;
        get tags(): Internal.Collection<ResourceLocation>;
        get name(): net.minecraft.network.chat.Component;
        get fluidStack(): Internal.FluidStackJS;
        get first(): this;
        get vanillaPredicate(): Internal.Predicate<Internal.ItemStack>;
        set nbt(tag: Internal.CompoundTag_);
        set chance(c: number);
        set count(count: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(s: Internal.ItemStack);
    }
    /**
    */
    type ItemStackJS_ = Internal.Item_ | ItemStackJS;
    /**
    * @javaClass com.google.common.collect.ImmutableList
    */
    abstract class ImmutableList <E> extends Internal.ImmutableCollection<E> implements Internal.List<E>, Internal.RandomAccess {
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        asList(): Internal.ImmutableList<E>;
        remove(arg0: number): E;
        static sortedCopyOf<E>(arg0: Internal.Comparator_<E>, arg1: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static sortedCopyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        iterator(): Internal.UnmodifiableIterator<E>;
        stream(): Internal.Stream<E>;
        hashCode(): number;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.ImmutableList<E>;
        static of<E>(): Internal.ImmutableList<E>;
        static of<E>(arg0: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E, arg11: E, ...arg12: E[]): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E): Internal.ImmutableList<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static builder<E>(): Internal.ImmutableList$Builder<E>;
        parallelStream(): Internal.Stream<E>;
        indexOf(arg0: any): number;
        add(arg0: number, arg1: E): void;
        subList(arg0: number, arg1: number): Internal.ImmutableList<E>;
        set(arg0: number, arg1: E): E;
        spliterator(): Internal.Spliterator<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        sort(arg0: Internal.Comparator_<E>): void;
        reverse(): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: E[]): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        static builderWithExpectedSize<E>(arg0: number): Internal.ImmutableList$Builder<E>;
        lastIndexOf(arg0: any): number;
        contains(arg0: any): boolean;
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        equals(arg0: any): boolean;
        static toImmutableList<E>(): Internal.Collector<E, any, Internal.ImmutableList<E>>;
        listIterator(arg0: number): Internal.UnmodifiableListIterator<E>;
        listIterator(): Internal.UnmodifiableListIterator<E>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ImmutableList_<E> = ImmutableList<E>;
    /**
    * @javaClass net.fabricmc.fabric.impl.client.model.ModelLoaderHooks
    */
    interface ModelLoaderHooks {
        fabric_addModel(arg0: ResourceLocation_): void;
        fabric_loadModel(arg0: ResourceLocation_): Internal.UnbakedModel;
    }
    type ModelLoaderHooks_ = ModelLoaderHooks;
    /**
    * @javaClass net.minecraft.class_1706
    */
    class AnvilMenu extends Internal.ItemCombinerMenu implements Internal.AnvilScreenHandlerExtended, Internal.DragonAnvilInterface {
        be_getRecipes(): Internal.List<any>;
        handler$ijn000$outputCheckOverride(player: Internal.Player_, present: boolean, cir: Internal.CallbackInfoReturnable_<any>): void;
        modify$jaf000$enchantmentOnAnvil(enchantments: Internal.Map_<any, any>, newOne: Internal.ItemStack_): Internal.Map<any, any>;
        handler$bfm000$be_initAnvilLevel(syncId: number, inventory: Internal.Inventory_, context: Internal.ContainerLevelAccess_, info: Internal.CallbackInfo_): void;
        be_previousRecipe(): void;
        handler$bfm000$be_updateOutput(info: Internal.CallbackInfo_): void;
        handler$dek000$emeraldUpdateResult(ci: Internal.CallbackInfo_): void;
        handler$bfm000$be_setNewItemName(string: string, info: Internal.CallbackInfo_): void;
        handler$cjl000$onCreateAnvilResult(info: Internal.CallbackInfo_): void;
        handler$gda000$canUse(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        method_7604(player: Internal.Player_, id: number): boolean;
        method_24923($$0: Internal.Player_, $$1: Internal.ItemStack_): void;
        method_24925($$0: Internal.BlockState_): boolean;
        method_24928(): void;
        handler$gfc000$onNewItemNameSet(newNewItemName: string, callbackInfo: Internal.CallbackInfo_): void;
        setDragonAnvil(string: string): void;
        be_nextRecipe(): void;
        handler$dek000$emeraldCanTakeOutput(player: Internal.Player_, present: boolean, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$gfc000$onTakeItemTop(player: Internal.Player_, stack: Internal.ItemStack_, ci: Internal.CallbackInfo_): void;
        handler$gfc000$onItemTaken(player: Internal.Player_, stack: Internal.ItemStack_, ci: Internal.CallbackInfo_): void;
        be_getCurrentRecipe(): Internal.AnvilRecipe;
        handler$gfc000$canTakeItemsTop(player: Internal.Player_, present: boolean, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$ijn000$setOutput(ci: Internal.CallbackInfo_): void;
        handler$gfc000$updateResult(callbackInfo: Internal.CallbackInfo_): void;
        getCost(): number;
        static calculateIncreasedRepairCost($$0: number): number;
        be_updateCurrentRecipe(recipe: Internal.AnvilRecipe_): void;
        setItemName($$0: string): void;
        "isDragonAnvil" : boolean;
        static readonly "MAX_NAME_LENGTH" : 50;
        get cost(): number;
        set itemName($$0: string);
        set dragonAnvil(string: string);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: Internal.Inventory);
        constructor($$0: number, $$1: Internal.Inventory, $$2: Internal.ContainerLevelAccess);
    }
    type AnvilMenu_ = AnvilMenu;
    /**
    * @javaClass dev.latvian.mods.kubejs.core.BlockStateKJS
    */
    interface BlockStateKJS {
        setDestroySpeedKJS(arg0: number): void;
        setLightEmissionKJS(arg0: number): void;
        setRequiresToolKJS(arg0: boolean): void;
        setMaterialKJS(arg0: net.minecraft.world.level.material.Material_): void;
    }
    type BlockStateKJS_ = BlockStateKJS;
    /**
    * @javaClass net.minecraft.class_1111$class_1112
    */
    class Sound$Type extends Internal.Enum<Internal.Sound$Type> {
        static valueOf($$0: string): Internal.Sound$Type;
        static values(): Internal.Sound$Type[];
        static getByName($$0: string): Internal.Sound$Type;
        static readonly "SOUND_EVENT" : Internal.Sound$Type;
        static readonly "FILE" : Internal.Sound$Type;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Sound$Type_ = "file" | "sound_event" | Sound$Type;
    /**
    * @javaClass net.minecraft.class_2740
    */
    class ClientboundSetEntityLinkPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getDestId(): number;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getSourceId(): number;
        get sourceId(): number;
        get destId(): number;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Entity, $$1: Internal.Entity);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundSetEntityLinkPacket_ = ClientboundSetEntityLinkPacket;
    /**
    * @javaClass net.minecraft.class_1928$class_4312
    */
    class GameRules$IntegerValue extends Internal.GameRules$Value<Internal.GameRules$IntegerValue> implements Internal.IntRuleAccessor {
        method_20781(): number;
        set($$0: number, $$1: Internal.MinecraftServer_): void;
        setFrom($$0: Internal.GameRules$IntegerValue_, $$1: Internal.MinecraftServer_): void;
        get(): number;
        static create($$0: number): Internal.GameRules$Type<Internal.GameRules$IntegerValue>;
        static create($$0: number, $$1: Internal.BiConsumer_<Internal.MinecraftServer_, Internal.GameRules$IntegerValue_>): Internal.GameRules$Type<Internal.GameRules$IntegerValue>;
        method_20779(): string;
        tryDeserialize($$0: string): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.GameRules$Type<Internal.GameRules$IntegerValue>, $$1: number);
    }
    type GameRules$IntegerValue_ = GameRules$IntegerValue;
    /**
    * @javaClass java.awt.JobAttributes$MultipleDocumentHandlingType
    */
    class JobAttributes$MultipleDocumentHandlingType extends Internal.AttributeValue {
        static readonly "SEPARATE_DOCUMENTS_COLLATED_COPIES" : Internal.JobAttributes$MultipleDocumentHandlingType;
        static readonly "SEPARATE_DOCUMENTS_UNCOLLATED_COPIES" : Internal.JobAttributes$MultipleDocumentHandlingType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type JobAttributes$MultipleDocumentHandlingType_ = JobAttributes$MultipleDocumentHandlingType;
    /**
    * @javaClass it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap
    */
    abstract class AbstractInt2ObjectMap <V> extends Internal.AbstractInt2ObjectFunction<V> implements Internal.Int2ObjectMap<V>, Internal.Serializable {
        getOrDefault(arg0: any, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        computeIfAbsent(arg0: number, arg1: Internal.Int2ObjectFunction_<V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.IntFunction_<V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        values(): Internal.ObjectCollection<V>;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        replace(arg0: number, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Int2ShortFunction;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2ObjectFunction<V>;
        computeIfAbsentPartial(arg0: number, arg1: Internal.Int2ObjectFunction_<V>): V;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Int2IntFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        put(arg0: number, arg1: V): V;
        remove(arg0: number): V;
        remove(arg0: any): V;
        remove(arg0: number, arg1: any): boolean;
        remove(arg0: any, arg1: any): boolean;
        containsValue(arg0: any): boolean;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Int2DoubleFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Int2ObjectFunction<T>;
        hashCode(): number;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        get(arg0: any): V;
        putAll(arg0: Internal.Map_<number, V>): void;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Int2LongFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2ObjectFunction<V>;
        keySet(): Internal.IntSet;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Int2ByteFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Int2FloatFunction;
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<number, V>>;
        apply(arg0: number): V;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2IntFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        isEmpty(): boolean;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Int2CharFunction;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2ObjectFunction<V>;
        equals(arg0: any): boolean;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Int2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2ObjectFunction<V>;
        toString(): string;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractInt2ObjectMap_<V> = AbstractInt2ObjectMap<V>;
    /**
    * Fired when a living entity is hurt.
    *
    * If cancelled, the attack will do no effect.
    * @javaClass dev.latvian.mods.kubejs.entity.LivingEntityHurtEventJS
    */
    class LivingEntityHurtEventJS extends Internal.LivingEntityEventJS {
        getDamage(): number;
        getSource(): Internal.DamageSource;
        getEntity(): Internal.EntityJS;
        canCancel(): boolean;
        get damage(): number;
        get source(): Internal.DamageSource;
        get entity(): Internal.EntityJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(entity: Internal.LivingEntity, source: Internal.DamageSource, amount: number);
    }
    /**
    * Fired when a living entity is hurt.
    *
    * If cancelled, the attack will do no effect.
    */
    type LivingEntityHurtEventJS_ = LivingEntityHurtEventJS;
    /**
    * @javaClass dev.architectury.hooks.level.biome.GenerationProperties
    */
    interface GenerationProperties {
        getFeatures(arg0: DecorationGenerationStep_): Internal.Iterable<Internal.Holder<Internal.PlacedFeature>>;
        getFeatures(): Internal.List<Internal.Iterable<Internal.Holder<Internal.PlacedFeature>>>;
        getCarvers(arg0: CarvingGenerationStep_): Internal.Iterable<Internal.Holder<Internal.ConfiguredWorldCarver<any>>>;
    }
    type GenerationProperties_ = GenerationProperties;
    /**
    * @javaClass net.minecraft.class_5636
    */
    class FogType extends Internal.Enum<Internal.FogType> {
        static valueOf($$0: string): Internal.FogType;
        static values(): Internal.FogType[];
        static readonly "LAVA" : Internal.FogType;
        static readonly "POWDER_SNOW" : Internal.FogType;
        static readonly "NONE" : Internal.FogType;
        static readonly "WATER" : Internal.FogType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FogType_ = "powder_snow" | "lava" | "none" | "water" | FogType;
    /**
    * @javaClass net.minecraft.class_2824
    */
    class ServerboundInteractPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        static createInteractionPacket($$0: Internal.Entity_, $$1: boolean, $$2: Hand_): Internal.ServerboundInteractPacket;
        static createInteractionPacket($$0: Internal.Entity_, $$1: boolean, $$2: Hand_, $$3: Vec3_): Internal.ServerboundInteractPacket;
        getTarget($$0: Internal.ServerLevel_): Internal.Entity;
        dispatch($$0: Internal.ServerboundInteractPacket$Handler_): void;
        static createAttackPacket($$0: Internal.Entity_, $$1: boolean): Internal.ServerboundInteractPacket;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        isUsingSecondaryAction(): boolean;
        get skippable(): boolean;
        get usingSecondaryAction(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ServerboundInteractPacket_ = ServerboundInteractPacket;
    /**
    * @javaClass com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices
    */
    class ContraptionMatrices {
        getLight(): Internal.Matrix4f;
        getWorld(): Internal.Matrix4f;
        getModel(): Internal.PoseStack;
        static clearStack(ms: Internal.PoseStack_): void;
        static transform(ms: Internal.PoseStack_, transform: Internal.PoseStack_): void;
        getViewProjection(): Internal.PoseStack;
        isReady(): boolean;
        getModelViewProjection(): Internal.PoseStack;
        clear(): void;
        setup(viewProjection: Internal.PoseStack_, entity: Internal.AbstractContraptionEntity_): void;
        static translateToEntity(matrix: Internal.Matrix4f_, entity: Internal.Entity_, partialTicks: number): void;
        get viewProjection(): Internal.PoseStack;
        get world(): Internal.Matrix4f;
        get light(): Internal.Matrix4f;
        get ready(): boolean;
        get model(): Internal.PoseStack;
        get modelViewProjection(): Internal.PoseStack;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ContraptionMatrices_ = ContraptionMatrices;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim
    */
    class RewardAutoClaim extends Internal.Enum<Internal.RewardAutoClaim> {
        static valueOf(name: string): Internal.RewardAutoClaim;
        static values(): Internal.RewardAutoClaim[];
        static readonly "DISABLED" : Internal.RewardAutoClaim;
        static readonly "NO_TOAST" : Internal.RewardAutoClaim;
        static readonly "INVISIBLE" : Internal.RewardAutoClaim;
        static readonly "NAME_MAP" : Internal.NameMap<Internal.RewardAutoClaim>;
        static readonly "NAME_MAP_NO_DEFAULT" : Internal.NameMap<Internal.RewardAutoClaim>;
        static readonly "ENABLED" : Internal.RewardAutoClaim;
        "id" : string;
        static readonly "DEFAULT" : Internal.RewardAutoClaim;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type RewardAutoClaim_ = "default" | "invisible" | "disabled" | "enabled" | "no_toast" | RewardAutoClaim;
    /**
    * @javaClass io.github.frqnny.mostructures.mixin.StructureSetAccessor
    */
    interface StructureSetAccessor {
        setStructures(arg0: Internal.List_<Internal.StructureSet$StructureSelectionEntry_>): void;
    }
    type StructureSetAccessor_ = StructureSetAccessor;
    /**
    * @javaClass me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry
    */
    interface CollapsibleEntryRegistry extends Internal.Reloadable<Internal.REIClientPlugin> {
        getStage(): Internal.ReloadStage;
        acceptPlugin(plugin: Internal.REIClientPlugin_): void;
        acceptPlugin(plugin: Internal.REIClientPlugin_, stage: Internal.ReloadStage_): void;
        startReload(stage: Internal.ReloadStage_): void;
        afterReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>): void;
        endReload(stage: Internal.ReloadStage_): void;
        endReload(): void;
        beforeReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>): void;
        isConcurrent(): boolean;
        getInstance(): this;
        afterReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>, plugin: Internal.REIClientPlugin_): void;
        beforeReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIClientPlugin_>, plugin: Internal.REIClientPlugin_): void;
        group<T>(id: ResourceLocation_, name: net.minecraft.network.chat.Component_, type: Internal.EntryType_<T>, predicate: Internal.Predicate_<Internal.EntryStack_<T>>): void;
        group<T>(id: ResourceLocation_, name: net.minecraft.network.chat.Component_, ...stacks: Internal.EntryStack_<T>[]): void;
        group<T>(arg0: ResourceLocation_, arg1: net.minecraft.network.chat.Component_, arg2: Internal.List_<Internal.EntryStack_<T>>): void;
        group(arg0: ResourceLocation_, arg1: net.minecraft.network.chat.Component_, arg2: Internal.Predicate_<Internal.EntryStack_<any>>): void;
    }
    type CollapsibleEntryRegistry_ = CollapsibleEntryRegistry;
    /**
    * @javaClass net.dragonloot.access.DragonAnvilInterface
    */
    interface DragonAnvilInterface {
        setDragonAnvil(arg0: string): void;
    }
    type DragonAnvilInterface_ = DragonAnvilInterface;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.config.ConfigWithVariants
    */
    abstract class ConfigWithVariants <T> extends Internal.ConfigValue<T> {
        getIteration(arg0: T, arg1: boolean): T;
        onClicked(button: Internal.MouseButton_, callback: Internal.ConfigCallback_): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ConfigWithVariants_<T> = ConfigWithVariants<T>;
    /**
    * @javaClass dev.latvian.mods.rhino.mod.util.ChangeListener
    */
    interface ChangeListener <T> {
        onChanged(arg0: T): void;
    }
    type ChangeListener_<T> = ((arg0: T) => void) | ChangeListener<T>;
    /**
    * @javaClass net.minecraft.class_3950
    */
    interface ChunkProgressListenerFactory {
        create(arg0: number): Internal.ChunkProgressListener;
    }
    type ChunkProgressListenerFactory_ = ChunkProgressListenerFactory;
    /**
    * @javaClass it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap
    */
    class Long2ObjectOpenHashMap <V> extends Internal.AbstractLong2ObjectMap<V> implements Internal.Serializable, Internal.Cloneable, Internal.Hash {
        long2ObjectEntrySet(): Internal.Long2ObjectMap$FastEntrySet<V>;
        getOrDefault(arg0: number, arg1: V): V;
        getOrDefault(arg0: any, arg1: V): V;
        computeIfAbsent(arg0: number, arg1: Internal.LongFunction_<V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        values(): Internal.ObjectCollection<V>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        replace(arg0: number, arg1: V): V;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        computeIfAbsentPartial(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        containsValue(arg0: any): boolean;
        put(arg0: number, arg1: V): V;
        remove(arg0: number, arg1: any): boolean;
        remove(arg0: number): V;
        remove(arg0: any): V;
        remove(arg0: any, arg1: any): boolean;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        trim(arg0: number): boolean;
        trim(): boolean;
        hashCode(): number;
        putAll(arg0: Internal.Map_<number, V>): void;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        get(arg0: number): V;
        get(arg0: any): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        keySet(): Internal.LongSet;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<number, V>>;
        apply(arg0: number): V;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        containsKey(arg0: number): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        isEmpty(): boolean;
        clear(): void;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        size(): number;
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        clone(): Internal.Long2ObjectOpenHashMap<V>;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.Map<number, V>);
        constructor(arg0: Internal.Long2ObjectMap<V>, arg1: number);
        constructor(arg0: Internal.Long2ObjectMap<V>);
        constructor(arg0: number[], arg1: V[], arg2: number);
        constructor(arg0: number[], arg1: V[]);
        constructor(arg0: number, arg1: number);
        constructor(arg0: number);
        constructor();
        constructor(arg0: Internal.Map<number, V>, arg1: number);
    }
    type Long2ObjectOpenHashMap_<V> = Long2ObjectOpenHashMap<V>;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.Object2ShortFunction
    */
    interface Object2ShortFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToIntFunction<K> {
        getOrDefault(arg0: any, arg1: number): number;
        andThenShort(arg0: Internal.Short2ShortFunction_): Internal.Object2ShortFunction<K>;
        removeShort(arg0: any): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Object2IntFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ShortFunction<T>;
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        put(arg0: K, arg1: number): number;
        remove(arg0: any): number;
        defaultReturnValue(): number;
        defaultReturnValue(arg0: number): void;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        get(arg0: any): number;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Object2LongFunction<K>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ShortFunction;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Object2ByteFunction<K>;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Object2FloatFunction<K>;
        applyAsInt(arg0: K): number;
        apply(arg0: K): number;
        getShort(arg0: any): number;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ShortFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ShortFunction;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Object2CharFunction<K>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ShortFunction<T>;
        size(): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ShortFunction;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ShortFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ShortFunction;
    }
    type Object2ShortFunction_<K> = ((arg0: any) => number) | Object2ShortFunction<K>;
    /**
    * @javaClass net.minecraft.class_1324
    */
    class AttributeInstance implements Internal.MutableAttributeInstance, Internal.IEntityAttributeInstance {
        replaceFrom($$0: Internal.AttributeInstance_): void;
        actionModifier(consumerIn: Internal.VoidConsumer_, instanceIn: Internal.AttributeInstance_, modifierIn: Internal.AttributeModifier_, isWasAdded: boolean): void;
        getModifier($$0: Internal.UUID_): Internal.AttributeModifier;
        save(): Internal.CompoundTag;
        refresh(): void;
        getId(): ResourceLocation;
        setBaseValue($$0: number): void;
        getBaseValue(): number;
        addTransientModifier($$0: Internal.AttributeModifier_): void;
        updateModifier(uuid: Internal.UUID_, value: number): void;
        updateId(identifierIn: ResourceLocation_): void;
        getValue(): number;
        removePermanentModifier($$0: Internal.UUID_): boolean;
        getAttribute(): Internal.Attribute;
        load($$0: Internal.CompoundTag_): void;
        removeModifiers(): void;
        hasModifier($$0: Internal.AttributeModifier_): boolean;
        setContainerCallback(containerIn: Internal.AttributeMap_): void;
        addPermanentModifier($$0: Internal.AttributeModifier_): void;
        getModifiers(): Internal.Set<Internal.AttributeModifier>;
        getModifiers($$0: Internal.AttributeModifier$Operation_): Internal.Set<Internal.AttributeModifier>;
        removeModifier($$0: Internal.AttributeModifier_): void;
        removeModifier($$0: Internal.UUID_): void;
        get baseValue(): number;
        get id(): ResourceLocation;
        get attribute(): Internal.Attribute;
        get modifiers(): Internal.Set<Internal.AttributeModifier>;
        get value(): number;
        set containerCallback(containerIn: Internal.AttributeMap_);
        set baseValue($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Attribute, $$1: ((arg0: Internal.AttributeInstance) => void));
    }
    type AttributeInstance_ = AttributeInstance;
    /**
    * @javaClass me.shedaniel.clothconfig2.impl.EasingMethod
    */
    interface EasingMethod {
        apply(arg0: number): number;
    }
    type EasingMethod_ = EasingMethod;
    /**
    * @javaClass net.minecraft.class_79
    */
    abstract class LootPoolEntryContainer implements Internal.ComposableEntryContainer {
        getType(): Internal.LootPoolEntryType;
        method_16778($$0: Internal.ComposableEntryContainer_): Internal.ComposableEntryContainer;
        method_385($$0: Internal.ComposableEntryContainer_): Internal.ComposableEntryContainer;
        validate($$0: Internal.ValidationContext_): void;
        get type(): Internal.LootPoolEntryType;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type LootPoolEntryContainer_ = LootPoolEntryContainer;
    /**
    * @javaClass dev.architectury.extensions.injected.InjectedLiquidBlockExtension
    */
    interface InjectedLiquidBlockExtension {
        arch$getFluid(): Internal.FlowingFluid;
    }
    type InjectedLiquidBlockExtension_ = InjectedLiquidBlockExtension;
    /**
    * @javaClass net.minecraft.class_1538
    */
    class LightningBolt extends Internal.Entity {
        setVisualOnly($$0: boolean): void;
        method_18002(): Internal.Packet<any>;
        method_5634(): Internal.SoundSource;
        handler$zmc000$handleLightning(ci: Internal.CallbackInfo_, list: Internal.List_<any>): void;
        getStepHeight(): number;
        setCause($$0: Internal.ServerPlayer_): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getCause(): Internal.ServerPlayer;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        getHitEntities(): Internal.Stream<Internal.Entity>;
        method_5640($$0: number): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        getBlocksSetOnFire(): number;
        alwaysAccepts(): boolean;
        method_5773(): void;
        "seed" : number;
        "visualOnly" : boolean;
        get cause(): Internal.ServerPlayer;
        get hitEntities(): Internal.Stream<Internal.Entity>;
        get stepHeight(): number;
        get blocksSetOnFire(): number;
        set cause($$0: Internal.ServerPlayer_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.LightningBolt>, $$1: Internal.Level);
    }
    type LightningBolt_ = LightningBolt;
    /**
    * @javaClass dev.latvian.mods.kubejs.block.custom.CropBlockBuilder
    */
    class CropBlockBuilder extends Internal.BlockBuilder {
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        survive(surviveCallback: Internal.CropBlockBuilder$SurviveCallback_): this;
        randomTick(randomTickCallback: Internal.Consumer_<Internal.RandomTickCallbackJS_>): Internal.BlockBuilder;
        texture(id: string, tex: string): Internal.BlockBuilder;
        dropSeed(dropSeed: boolean): this;
        bonemeal(bonemealCallback: Internal.ToIntFunction_<Internal.RandomTickCallbackJS_>): this;
        crop(output: any, chance: number): this;
        crop(output: any): this;
        age(age: number): this;
        age(age: number, builder: Internal.Consumer_<Internal.CropBlockBuilder$ShapeBuilder_>): this;
        growTick(growSpeedCallback: Internal.ToDoubleFunction_<Internal.RandomTickCallbackJS_>): this;
        createObject(): Internal.Block;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(i: ResourceLocation);
    }
    type CropBlockBuilder_ = CropBlockBuilder;
    /**
    * @javaClass dev.architectury.extensions.injected.InjectedRegistryEntryExtension
    */
    interface InjectedRegistryEntryExtension <T> {
        arch$registryName(): ResourceLocation;
        arch$holder(): Internal.Holder<T>;
    }
    type InjectedRegistryEntryExtension_<T> = InjectedRegistryEntryExtension<T>;
    /**
    * @javaClass dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback
    */
    interface ModifyRecipeResultCallback {
        modify(arg0: Internal.ModifyRecipeCraftingGrid_, arg1: Internal.ItemStackJS_): Internal.ItemStackJS;
    }
    type ModifyRecipeResultCallback_ = ((arg0: Internal.ModifyRecipeCraftingGrid, arg1: Internal.ItemStackJS) => Internal.ItemStackJS) | ModifyRecipeResultCallback;
    /**
    * @javaClass net.minecraft.class_3989
    */
    class WanderingTrader extends Internal.AbstractVillager {
        setWanderTarget($$0: BlockPos_): void;
        method_5613($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): Internal.AgeableMob;
        openTradingScreen($$0: Internal.Player_, $$1: net.minecraft.network.chat.Component_, $$2: number): void;
        getDespawnDelay(): number;
        method_18010(): Internal.SoundEvent;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        setDespawnDelay($$0: number): void;
        method_19270(): boolean;
        canRestock(): boolean;
        handler$emg003$gobberInteractMob(player: Internal.Player_, hand: Hand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        method_5992($$0: Internal.Player_, $$1: Hand_): Internal.InteractionResult;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        method_6007(): void;
        method_5974($$0: number): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        get stepHeight(): number;
        get despawnDelay(): number;
        set wanderTarget($$0: BlockPos_);
        set despawnDelay($$0: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.WanderingTrader>, $$1: Internal.Level);
    }
    type WanderingTrader_ = WanderingTrader;
    /**
    * @javaClass dev.latvian.mods.unit.function.FunctionFactory$Arg1
    */
    interface FunctionFactory$Arg1 extends Internal.FunctionFactory$FuncSupplier {
        createArg(arg0: dev.latvian.mods.unit.Unit_): dev.latvian.mods.unit.Unit;
        create(args: dev.latvian.mods.unit.Unit_[]): dev.latvian.mods.unit.Unit;
    }
    type FunctionFactory$Arg1_ = ((arg0: dev.latvian.mods.unit.Unit) => dev.latvian.mods.unit.Unit) | FunctionFactory$Arg1;
    /**
    * @javaClass java.nio.file.OpenOption
    */
    interface OpenOption {
    }
    type OpenOption_ = OpenOption;
    /**
    * @javaClass net.minecraft.class_6555
    */
    class TerrainShaper extends Internal.Record {
        jaggednessSampler(): Internal.CubicSpline<Internal.TerrainShaper$Point>;
        offset($$0: Internal.TerrainShaper$Point_): number;
        static makePoint($$0: number, $$1: number, $$2: number): Internal.TerrainShaper$Point;
        static makePoint($$0: Internal.DensityFunction$FunctionContext_): Internal.TerrainShaper$PointCustom;
        offsetSampler(): Internal.CubicSpline<Internal.TerrainShaper$Point>;
        static overworld($$0: boolean): Internal.TerrainShaper;
        jaggedness($$0: Internal.TerrainShaper$Point_): number;
        addDebugBiomesToVisualizeSplinePoints($$0: Internal.Consumer_<com.mojang.datafixers.util.Pair_<Internal.Climate$ParameterPoint_, Internal.ResourceKey_<Internal.Biome_>>>): void;
        hashCode(): number;
        factorSampler(): Internal.CubicSpline<Internal.TerrainShaper$Point>;
        static peaksAndValleys($$0: number): number;
        equals($$0: any): boolean;
        toString(): string;
        factor($$0: Internal.TerrainShaper$Point_): number;
        static readonly "CODEC" : Internal.Codec<Internal.TerrainShaper>;
        static readonly "SPLINE_CUSTOM_CODEC" : Internal.Codec<Internal.CubicSpline<Internal.TerrainShaper$PointCustom>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.CubicSpline<Internal.TerrainShaper$Point>, $$1: Internal.CubicSpline<Internal.TerrainShaper$Point>, $$2: Internal.CubicSpline<Internal.TerrainShaper$Point>);
    }
    type TerrainShaper_ = TerrainShaper;
    /**
    * @javaClass me.shedaniel.rei.api.common.entry.EntrySerializer
    */
    interface EntrySerializer <T> {
        read(arg0: Internal.CompoundTag_): T;
        supportSaving(): boolean;
        save(arg0: Internal.EntryStack_<T>, arg1: T): Internal.CompoundTag;
        supportReading(): boolean;
    }
    type EntrySerializer_<T> = EntrySerializer<T>;
    /**
    * @javaClass java.io.OutputStream
    */
    abstract class OutputStream implements Internal.Closeable, Internal.Flushable {
        flush(): void;
        static nullOutputStream(): Internal.OutputStream;
        close(): void;
        write(arg0: number[]): void;
        write(arg0: number[], arg1: number, arg2: number): void;
        write(arg0: number): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type OutputStream_ = OutputStream;
    /**
    * @javaClass dev.latvian.mods.kubejs.core.MinecraftServerKJS
    */
    interface MinecraftServerKJS extends Internal.AsKJS<Internal.ServerJS> {
        getReloadableResourcesKJS(): Internal.MinecraftServer$ReloadableResources;
        asKJS(): Internal.ServerJS;
    }
    type MinecraftServerKJS_ = MinecraftServerKJS;
    /**
    * @javaClass net.minecraft.class_2643
    */
    class TheEndGatewayBlockEntity extends Internal.TheEndPortalBlockEntity {
        getCooldownPercent($$0: number): number;
        static beamAnimationTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.TheEndGatewayBlockEntity_): void;
        static teleportEntity($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Entity_, $$4: Internal.TheEndGatewayBlockEntity_): void;
        isCoolingDown(): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        isSpawning(): boolean;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        invalidateCaps(): void;
        getSpawnPercent($$0: number): number;
        static teleportTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.TheEndGatewayBlockEntity_): void;
        method_16887(): Internal.CompoundTag;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        static canEntityTeleport($$0: Internal.Entity_): boolean;
        method_11014($$0: Internal.CompoundTag_): void;
        setExitPosition($$0: BlockPos_, $$1: boolean): void;
        getParticleAmount(): number;
        method_11400($$0: Internal.Direction_): boolean;
        method_11004($$0: number, $$1: number): boolean;
        get spawning(): boolean;
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket;
        get coolingDown(): boolean;
        get particleAmount(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.BlockState);
    }
    type TheEndGatewayBlockEntity_ = TheEndGatewayBlockEntity;
    /**
    * @javaClass io.github.lucaargolo.kibe.mixed.PlayerEntityMixed
    */
    interface PlayerEntityMixed {
        getKibe_activeRingsList(): Internal.List<kotlin.Pair<Internal.ItemStack, number>>;
    }
    type PlayerEntityMixed_ = PlayerEntityMixed;
    /**
    * @javaClass java.time.Duration
    */
    class Duration implements Internal.TemporalAmount, Internal.Comparable<Internal.Duration>, Internal.Serializable {
        negated(): this;
        plusHours(arg0: number): this;
        isPositive(): boolean;
        compareTo(arg0: Internal.Duration_): number;
        multipliedBy(arg0: number): this;
        plusSeconds(arg0: number): this;
        toMillis(): number;
        static from(arg0: Internal.TemporalAmount_): Internal.Duration;
        plusNanos(arg0: number): this;
        static ofMinutes(arg0: number): Internal.Duration;
        static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Internal.Duration;
        static ofSeconds(arg0: number, arg1: number): Internal.Duration;
        static ofSeconds(arg0: number): Internal.Duration;
        truncatedTo(arg0: Internal.TemporalUnit_): this;
        minusNanos(arg0: number): this;
        getNano(): number;
        toMillisPart(): number;
        plus(arg0: number, arg1: Internal.TemporalUnit_): this;
        plus(arg0: Internal.Duration_): this;
        toMinutesPart(): number;
        toNanos(): number;
        toMinutes(): number;
        toHours(): number;
        plusMillis(arg0: number): this;
        subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
        toSecondsPart(): number;
        static ofMillis(arg0: number): Internal.Duration;
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        minus(arg0: Internal.Duration_): this;
        minusHours(arg0: number): this;
        withSeconds(arg0: number): this;
        minusMillis(arg0: number): this;
        plusMinutes(arg0: number): this;
        toSeconds(): number;
        dividedBy(arg0: number): this;
        dividedBy(arg0: Internal.Duration_): number;
        minusMinutes(arg0: number): this;
        plusDays(arg0: number): this;
        hashCode(): number;
        static of(arg0: number, arg1: Internal.TemporalUnit_): Internal.Duration;
        get(arg0: Internal.TemporalUnit_): number;
        isZero(): boolean;
        toDays(): number;
        toNanosPart(): number;
        isNegative(): boolean;
        static ofDays(arg0: number): Internal.Duration;
        static parse(arg0: Internal.CharSequence_): Internal.Duration;
        minusDays(arg0: number): this;
        toHoursPart(): number;
        toDaysPart(): number;
        static ofNanos(arg0: number): Internal.Duration;
        getSeconds(): number;
        abs(): this;
        static ofHours(arg0: number): Internal.Duration;
        withNanos(arg0: number): this;
        equals(arg0: any): boolean;
        getUnits(): Internal.List<Internal.TemporalUnit>;
        addTo(arg0: Internal.Temporal_): Internal.Temporal;
        toString(): string;
        minusSeconds(arg0: number): this;
        static readonly "ZERO" : Internal.Duration;
        get zero(): boolean;
        get negative(): boolean;
        get seconds(): number;
        get nano(): number;
        get positive(): boolean;
        get units(): Internal.List<Internal.TemporalUnit>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Duration_ = Duration;
    /**
    * @javaClass org.apache.logging.log4j.util.MessageSupplier
    */
    interface MessageSupplier {
        get(): org.apache.logging.log4j.message.Message;
    }
    type MessageSupplier_ = MessageSupplier;
    /**
    * @javaClass xaero.common.gui.GuiHelper
    */
    abstract class GuiHelper {
        getMyOptions(): Internal.MyOptions;
        openInterfaceSettings(arg0: number): void;
        openMinimapSettingsFromScreen(parent: Internal.Screen_, escScreen: Internal.Screen_): void;
        onResetCancel(arg0: Internal.Screen_, arg1: Internal.Screen_): void;
        getMainSettingsScreen(arg0: Internal.Screen_): Internal.GuiSettings;
        openMainSettingsFromScreen(arg0: Internal.Screen_, arg1: Internal.Screen_): void;
        openSettingsGui(returnModOptions: Internal.ModOptions_): void;
        get myOptions(): Internal.MyOptions;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(modMain: Internal.AXaeroMinimap);
    }
    type GuiHelper_ = GuiHelper;
    /**
    * @javaClass net.minecraft.class_1510
    */
    class EnderDragon extends Internal.Mob implements Internal.Enemy {
        getHeadPartYOffset($$0: number, $$1: number[], $$2: number[]): number;
        method_5634(): Internal.SoundSource;
        getLatencyPos($$0: number, $$1: number): number[];
        method_18395($$0: Internal.LivingEntity_): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getSubEntities(): Internal.EnderDragonPart[];
        onCrystalDestroyed($$0: Internal.EndCrystal_, $$1: BlockPos_, $$2: Internal.DamageSource_): void;
        getPhaseManager(): Internal.EnderDragonPhaseManager;
        foodEatenKJS(is: Internal.ItemStack_): void;
        findClosestNode($$0: number, $$1: number, $$2: number): number;
        findClosestNode(): number;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        method_5863(): boolean;
        alwaysAccepts(): boolean;
        method_5982(): void;
        method_33579($$0: Internal.ClientboundAddMobPacket_): void;
        method_5801(): void;
        method_5768(): void;
        method_5822(): boolean;
        getHeadLookVector($$0: number): Vec3;
        getStepHeight(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        asKJS(): Internal.EntityJS;
        canRiderInteract(): boolean;
        method_37222($$0: Internal.MobEffectInstance_, $$1: Internal.Entity_): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        getDragonFight(): Internal.EndDragonFight;
        findPath($$0: number, $$1: number, $$2: Internal.Node_): net.minecraft.world.level.pathfinder.Path;
        thonkutil$getId(): ResourceLocation;
        method_6007(): void;
        method_5776(): boolean;
        method_5652($$0: Internal.CompoundTag_): void;
        method_5674($$0: Internal.EntityDataAccessor_<any>): void;
        hurt($$0: Internal.EnderDragonPart_, $$1: Internal.DamageSource_, $$2: number): boolean;
        readonly "head" : Internal.EnderDragonPart;
        "flapTime" : number;
        "yRotA" : number;
        "posPointer" : number;
        "oFlapTime" : number;
        "nearestCrystal" : Internal.EndCrystal;
        static readonly "DATA_PHASE" : Internal.EntityDataAccessor<number>;
        readonly "positions" : number[][];
        "dragonDeathTime" : number;
        "inWall" : boolean;
        get dragonFight(): Internal.EndDragonFight;
        get phaseManager(): Internal.EnderDragonPhaseManager;
        get stepHeight(): number;
        get subEntities(): Internal.EnderDragonPart[];
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.EnderDragon>, $$1: Internal.Level);
    }
    type EnderDragon_ = EnderDragon;
    /**
    * @javaClass net.minecraft.class_5739
    */
    class GameEventListenerRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        trackGameEvent($$0: Internal.GameEvent_, $$1: BlockPos_): void;
        method_23109($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        trackListener($$0: Internal.PositionSource_, $$1: number): void;
        clear(): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Minecraft);
    }
    type GameEventListenerRenderer_ = GameEventListenerRenderer;
    /**
    * @javaClass net.minecraft.class_3895
    */
    class ClientboundOpenBookPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        getHand(): Hand;
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean;
        get hand(): Hand;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Hand);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundOpenBookPacket_ = ClientboundOpenBookPacket;
    /**
    * Fired by different tag when the level:
    * - loads
    * - ticks
    * - unloads
    * @javaClass dev.latvian.mods.kubejs.level.SimpleLevelEventJS
    */
    class SimpleLevelEventJS extends Internal.LevelEventJS {
        getLevel(): Internal.LevelJS;
        get level(): Internal.LevelJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(l: Internal.LevelJS);
    }
    /**
    * Fired by different tag when the level:
    * - loads
    * - ticks
    * - unloads
    */
    type SimpleLevelEventJS_ = SimpleLevelEventJS;
    /**
    * @javaClass net.minecraft.class_6603
    */
    class ClientboundLevelChunkPacketData {
        getHeightmaps(): Internal.CompoundTag;
        getBlockEntitiesTagsConsumer($$0: number, $$1: number): Internal.Consumer<Internal.ClientboundLevelChunkPacketData$BlockEntityTagOutput>;
        static extractChunkData($$0: Internal.FriendlyByteBuf_, $$1: Internal.LevelChunk_): void;
        getReadBuffer(): Internal.FriendlyByteBuf;
        write($$0: Internal.FriendlyByteBuf_): void;
        get readBuffer(): Internal.FriendlyByteBuf;
        get heightmaps(): Internal.CompoundTag;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.LevelChunk);
        constructor($$0: Internal.FriendlyByteBuf, $$1: number, $$2: number);
    }
    type ClientboundLevelChunkPacketData_ = ClientboundLevelChunkPacketData;
    /**
    * @javaClass net.minecraft.class_2799$class_2800
    */
    class ServerboundClientCommandPacket$Action extends Internal.Enum<Internal.ServerboundClientCommandPacket$Action> {
        static valueOf($$0: string): Internal.ServerboundClientCommandPacket$Action;
        static values(): Internal.ServerboundClientCommandPacket$Action[];
        static readonly "REQUEST_STATS" : Internal.ServerboundClientCommandPacket$Action;
        static readonly "PERFORM_RESPAWN" : Internal.ServerboundClientCommandPacket$Action;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ServerboundClientCommandPacket$Action_ = "perform_respawn" | "request_stats" | ServerboundClientCommandPacket$Action;
    /**
    * @javaClass java.nio.file.FileSystem
    */
    abstract class FileSystem implements Internal.Closeable {
        isReadOnly(): boolean;
        isOpen(): boolean;
        supportedFileAttributeViews(): Internal.Set<string>;
        provider(): Internal.FileSystemProvider;
        getFileStores(): Internal.Iterable<Internal.FileStore>;
        getRootDirectories(): Internal.Iterable<Internal.Path>;
        getPath(arg0: string, ...arg1: string[]): Internal.Path;
        getSeparator(): string;
        getPathMatcher(arg0: string): Internal.PathMatcher;
        newWatchService(): Internal.WatchService;
        close(): void;
        getUserPrincipalLookupService(): Internal.UserPrincipalLookupService;
        get rootDirectories(): Internal.Iterable<Internal.Path>;
        get readOnly(): boolean;
        get userPrincipalLookupService(): Internal.UserPrincipalLookupService;
        get separator(): string;
        get open(): boolean;
        get fileStores(): Internal.Iterable<Internal.FileStore>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type FileSystem_ = FileSystem;
    /**
    * @javaClass java.nio.channels.SeekableByteChannel
    */
    interface SeekableByteChannel extends Internal.ByteChannel {
        read(arg0: Internal.ByteBuffer_): number;
        truncate(arg0: number): this;
        size(): number;
        position(): number;
        position(arg0: number): this;
        write(arg0: Internal.ByteBuffer_): number;
    }
    type SeekableByteChannel_ = SeekableByteChannel;
    /**
    * @javaClass net.minecraft.class_5138
    */
    class StructureFeatureManager {
        registryAccess(): Internal.RegistryAccess;
        setStartForFeature($$0: Internal.SectionPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>, $$2: Internal.StructureStart_, $$3: Internal.FeatureAccess_): void;
        getStructureWithPieceAt($$0: BlockPos_, $$1: Internal.ResourceKey_<Internal.ConfiguredStructureFeature_<any, any>>): Internal.StructureStart;
        getStructureWithPieceAt($$0: BlockPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>): Internal.StructureStart;
        structureHasPieceAt($$0: BlockPos_, $$1: Internal.StructureStart_): boolean;
        addReferenceForFeature($$0: Internal.SectionPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>, $$2: number, $$3: Internal.FeatureAccess_): void;
        fillStartsForFeature($$0: Internal.ConfiguredStructureFeature_<any, any>, $$1: Internal.LongSet_, $$2: Internal.Consumer_<Internal.StructureStart_>): void;
        addReference($$0: Internal.StructureStart_): void;
        hasAnyStructureAt($$0: BlockPos_): boolean;
        getAllStructuresAt($$0: BlockPos_): Internal.Map<Internal.ConfiguredStructureFeature<any, any>, Internal.LongSet>;
        startsForFeature($$0: Internal.SectionPos_, $$1: Internal.Predicate_<Internal.ConfiguredStructureFeature_<any, any>>): Internal.List<Internal.StructureStart>;
        startsForFeature($$0: Internal.SectionPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>): Internal.List<Internal.StructureStart>;
        getStructureAt($$0: BlockPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>): Internal.StructureStart;
        getStartForFeature($$0: Internal.SectionPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>, $$2: Internal.FeatureAccess_): Internal.StructureStart;
        checkStructurePresence($$0: Internal.ChunkPos_, $$1: Internal.ConfiguredStructureFeature_<any, any>, $$2: boolean): Internal.StructureCheckResult;
        shouldGenerateFeatures(): boolean;
        forWorldGenRegion($$0: Internal.WorldGenRegion_): this;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.LevelAccessor, $$1: Internal.WorldGenSettings, $$2: any);
    }
    type StructureFeatureManager_ = StructureFeatureManager;
    /**
    * @javaClass net.minecraft.class_6783
    */
    class InsideWorldBoundsPredicate implements Internal.BlockPredicate {
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel_, BlockPos_>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        test($$0: Internal.WorldGenLevel_, $$1: BlockPos_): boolean;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel_, BlockPos_>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        method_38873(): Internal.BlockPredicateType<any>;
        static readonly "CODEC" : Internal.Codec<Internal.InsideWorldBoundsPredicate>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Vec3i);
    }
    type InsideWorldBoundsPredicate_ = InsideWorldBoundsPredicate;
    /**
    * @javaClass java.lang.invoke.MethodHandles$Lookup
    */
    class MethodHandles$Lookup {
        findStaticVarHandle(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.Class_<any>): Internal.VarHandle;
        hasFullPrivilegeAccess(): boolean;
        findStaticGetter(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.Class_<any>): Internal.MethodHandle;
        lookupClass(): typeof any;
        defineHiddenClass(arg0: number[], arg1: boolean, ...arg2: any[]): this;
        unreflectSetter(arg0: Internal.Field_): Internal.MethodHandle;
        findVirtual(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.MethodType_): Internal.MethodHandle;
        findConstructor(arg0: Internal.Class_<any>, arg1: Internal.MethodType_): Internal.MethodHandle;
        dropLookupMode(arg0: number): this;
        findStaticSetter(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.Class_<any>): Internal.MethodHandle;
        bind(arg0: any, arg1: string, arg2: Internal.MethodType_): Internal.MethodHandle;
        findGetter(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.Class_<any>): Internal.MethodHandle;
        hasPrivateAccess(): boolean;
        unreflectGetter(arg0: Internal.Field_): Internal.MethodHandle;
        accessClass(arg0: Internal.Class_<any>): typeof any;
        findSpecial(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.MethodType_, arg3: Internal.Class_<any>): Internal.MethodHandle;
        in(arg0: Internal.Class_<any>): this;
        defineClass(arg0: number[]): typeof any;
        unreflectConstructor(arg0: Internal.Constructor_<any>): Internal.MethodHandle;
        unreflectVarHandle(arg0: Internal.Field_): Internal.VarHandle;
        findClass(arg0: string): typeof any;
        defineHiddenClassWithClassData(arg0: number[], arg1: any, arg2: boolean, ...arg3: any[]): this;
        unreflectSpecial(arg0: Internal.Method_, arg1: Internal.Class_<any>): Internal.MethodHandle;
        lookupModes(): number;
        findStatic(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.MethodType_): Internal.MethodHandle;
        ensureInitialized(arg0: Internal.Class_<any>): typeof any;
        unreflect(arg0: Internal.Method_): Internal.MethodHandle;
        findVarHandle(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.Class_<any>): Internal.VarHandle;
        findSetter(arg0: Internal.Class_<any>, arg1: string, arg2: Internal.Class_<any>): Internal.MethodHandle;
        toString(): string;
        previousLookupClass(): typeof any;
        revealDirect(arg0: Internal.MethodHandle_): Internal.MethodHandleInfo;
        static readonly "MODULE" : 16;
        static readonly "PACKAGE" : 8;
        static readonly "PUBLIC" : 1;
        static readonly "ORIGINAL" : 64;
        static readonly "UNCONDITIONAL" : 32;
        static readonly "PROTECTED" : 4;
        static readonly "PRIVATE" : 2;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MethodHandles$Lookup_ = MethodHandles$Lookup;
    /**
    * @javaClass net.minecraft.class_897
    */
    abstract class EntityRenderer <T> implements Internal.EntityRendererInter<any> {
        getRenderOffset($$0: T, $$1: number): Vec3;
        getTextureLocation(arg0: T): ResourceLocation;
        getFont(): net.minecraft.client.gui.Font;
        shouldRender($$0: T, $$1: Internal.Frustum_, $$2: number, $$3: number, $$4: number): boolean;
        getPackedLightCoords($$0: T, $$1: number): number;
        shadowRenderNameTag(entity: Internal.Entity_, component: net.minecraft.network.chat.Component_, poseStack: Internal.PoseStack_, multiBufferSource: Internal.MultiBufferSource_, light: number): void;
        render($$0: T, $$1: number, $$2: number, $$3: Internal.PoseStack_, $$4: Internal.MultiBufferSource_, $$5: number): void;
        shadowShouldShowName(entity: Internal.Entity_): boolean;
        get font(): net.minecraft.client.gui.Font;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type EntityRenderer_<T> = EntityRenderer<T>;
    /**
    * @javaClass net.minecraft.class_1071$class_1072
    */
    interface SkinManager$SkinTextureCallback {
        onSkinTextureAvailable(arg0: Internal.MinecraftProfileTexture$Type_, arg1: ResourceLocation_, arg2: Internal.MinecraftProfileTexture_): void;
    }
    type SkinManager$SkinTextureCallback_ = SkinManager$SkinTextureCallback;
    /**
    * @javaClass dev.ftb.mods.ftbquests.quest.Movable
    */
    interface Movable {
        drawMoved(matrixStack: Internal.PoseStack_): void;
        getHeight(): number;
        getX(): number;
        move(arg0: Internal.Chapter_, arg1: number, arg2: number): void;
        getY(): number;
        getShape(): string;
        getWidth(): number;
        getChapter(): Internal.Chapter;
    }
    type Movable_ = Movable;
    /**
    * @javaClass com.mojang.datafixers.types.templates.TypeTemplate
    */
    interface TypeTemplate {
        toSimpleType(): com.mojang.datafixers.types.Type<any>;
        hmap(arg0: Internal.TypeFamily_, arg1: Internal.IntFunction_<Internal.RewriteResult_<any, any>>): Internal.IntFunction<Internal.RewriteResult<any, any>>;
        size(): number;
        applyO<A, B>(arg0: Internal.FamilyOptic_<A, B>, arg1: com.mojang.datafixers.types.Type_<A>, arg2: com.mojang.datafixers.types.Type_<B>): Internal.FamilyOptic<A, B>;
        apply(arg0: Internal.TypeFamily_): Internal.TypeFamily;
        findFieldOrType<A, B>(arg0: number, arg1: string, arg2: com.mojang.datafixers.types.Type_<A>, arg3: com.mojang.datafixers.types.Type_<B>): Internal.Either<Internal.TypeTemplate, Internal.Type$FieldNotFoundException>;
    }
    type TypeTemplate_ = TypeTemplate;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.Reference2BooleanFunction
    */
    interface Reference2BooleanFunction <K> extends it.unimi.dsi.fastutil.Function<K, boolean>, Internal.Predicate<K> {
        getOrDefault(arg0: any, arg1: boolean): boolean;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Reference2ShortFunction<K>;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2BooleanFunction;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Reference2IntFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2BooleanFunction<T>;
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<K, T>;
        put(arg0: K, arg1: boolean): boolean;
        remove(arg0: any): boolean;
        defaultReturnValue(): boolean;
        defaultReturnValue(arg0: boolean): void;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Reference2DoubleFunction<K>;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Reference2ObjectFunction<K, T>;
        and(arg0: Internal.Predicate_<K>): Internal.Predicate<K>;
        get(arg0: any): boolean;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Reference2LongFunction<K>;
        removeBoolean(arg0: any): boolean;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2BooleanFunction;
        getBoolean(arg0: any): boolean;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Reference2ByteFunction<K>;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Reference2FloatFunction<K>;
        or(arg0: Internal.Predicate_<K>): Internal.Predicate<K>;
        test(arg0: K): boolean;
        apply(arg0: K): boolean;
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2BooleanFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2BooleanFunction;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Reference2CharFunction<K>;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2BooleanFunction<T>;
        size(): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, boolean>;
        negate(): Internal.Predicate<K>;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2BooleanFunction;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Reference2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2BooleanFunction;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2BooleanFunction;
    }
    type Reference2BooleanFunction_<K> = ((arg0: any) => boolean) | Reference2BooleanFunction<K>;
    /**
    * @javaClass xaero.map.region.LeveledRegionManager
    */
    class LeveledRegionManager {
        getLoadedRegion(index: number): Internal.LeveledRegion<any>;
        getUnsyncedList(): Internal.List<Internal.LeveledRegion<any>>;
        getLoadedListUnsynced(): Internal.List<Internal.LeveledRegion<any>>;
        addLoadedRegion(reg: Internal.LeveledRegion_<any>): void;
        bumpLoadedRegion(reg: Internal.MapRegion_): void;
        bumpLoadedRegion(reg: Internal.LeveledRegion_<any>): void;
        clear(): void;
        putLeaf(X: number, Z: number, leaf: Internal.MapRegion_): void;
        remove(leveledX: number, leveledZ: number, level: number): boolean;
        removeListRegion(reg: Internal.LeveledRegion_<any>): void;
        removeLoadedRegion(reg: Internal.LeveledRegion_<any>): void;
        size(): number;
        addListRegion(reg: Internal.LeveledRegion_<any>): void;
        getLeaf(X: number, Z: number): Internal.MapRegion;
        get(leveledX: number, leveledZ: number, level: number): Internal.LeveledRegion<any>;
        getListRegion(index: number): Internal.LeveledRegion<any>;
        loadedCount(): number;
        static readonly "MAX_LEVEL" : 3;
        get loadedListUnsynced(): Internal.List<Internal.LeveledRegion<any>>;
        get unsyncedList(): Internal.List<Internal.LeveledRegion<any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type LeveledRegionManager_ = LeveledRegionManager;
    /**
    * @javaClass net.minecraft.class_1576
    */
    class Husk extends Internal.Zombie {
        canRiderInteract(): boolean;
        static checkHuskSpawnRules($$0: Internal.EntityType_<Internal.Husk_>, $$1: Internal.ServerLevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.Random_): boolean;
        foodEatenKJS(is: Internal.ItemStack_): void;
        getStepHeight(): number;
        method_6121($$0: Internal.Entity_): boolean;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        thonkutil$getId(): ResourceLocation;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EntityType<Internal.Husk>, $$1: Internal.Level);
    }
    type Husk_ = Husk;
    /**
    * @javaClass pm.c7.scout.screen.BagSlot
    */
    class BagSlot extends Internal.Slot {
        setEnabled(state: boolean): void;
        method_7671(amount: number): Internal.ItemStack;
        method_7682(): boolean;
        method_7680(stack: Internal.ItemStack_): boolean;
        method_7675(): number;
        method_7674(playerEntity: Internal.Player_): boolean;
        method_7673(stack: Internal.ItemStack_): void;
        setInventory(inventory: net.minecraft.world.Container_): void;
        method_7668(): void;
        method_7677(): Internal.ItemStack;
        "inventory" : net.minecraft.world.Container;
        set enabled(state: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(index: number, x: number, y: number);
    }
    type BagSlot_ = BagSlot;
    /**
    * @javaClass xaero.common.minimap.waypoints.WaypointWorldConnectionManager
    */
    class WaypointWorldConnectionManager {
        renameDimension(oldName: string, newName: string): void;
        removeConnection(world1: Internal.WaypointWorld_, world2: Internal.WaypointWorld_): void;
        isConnected(world1: Internal.WaypointWorld_, world2: Internal.WaypointWorld_): boolean;
        save(writer: Internal.PrintWriter_): void;
        isEmpty(): boolean;
        addConnection(world1: Internal.WaypointWorld_, world2: Internal.WaypointWorld_): void;
        swapConnections(world1: Internal.WaypointWorld_, world2: Internal.WaypointWorld_): void;
        get empty(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type WaypointWorldConnectionManager_ = WaypointWorldConnectionManager;
    /**
    * @javaClass net.minecraft.class_6798
    */
    interface PlacementModifierType <P> {
        codec(): Internal.Codec<P>;
    }
    type PlacementModifierType_<P> = Special.PlacementModifierType | PlacementModifierType<P>;
    /**
    * @javaClass net.minecraft.class_5558
    */
    interface BlockEntityTicker <T> {
        tick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: T): void;
    }
    type BlockEntityTicker_<T> = ((arg0: Internal.Level, arg1: BlockPos, arg2: Internal.BlockState, arg3: T) => void) | BlockEntityTicker<T>;
    /**
    * @javaClass net.minecraft.class_4094
    */
    interface ReputationEventHandler {
        onReputationEventFrom(arg0: Internal.ReputationEventType_, arg1: Internal.Entity_): void;
    }
    type ReputationEventHandler_ = ReputationEventHandler;
    /**
    * @javaClass java.nio.charset.CodingErrorAction
    */
    class CodingErrorAction {
        toString(): string;
        static readonly "REPORT" : Internal.CodingErrorAction;
        static readonly "IGNORE" : Internal.CodingErrorAction;
        static readonly "REPLACE" : Internal.CodingErrorAction;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type CodingErrorAction_ = CodingErrorAction;
    /**
    * @javaClass com.telepathicgrunt.repurposedstructures.mixin.world.WorldGenRegionAccessor
    */
    interface WorldGenRegionAccessor {
        getStructureFeatureManager(): Internal.StructureFeatureManager;
    }
    type WorldGenRegionAccessor_ = WorldGenRegionAccessor;
    /**
    * @javaClass dev.latvian.mods.kubejs.misc.EnchantmentBuilder$DamageBonusFunction
    */
    interface EnchantmentBuilder$DamageBonusFunction {
        getDamageBonus(arg0: number, arg1: string): number;
    }
    type EnchantmentBuilder$DamageBonusFunction_ = ((arg0: number, arg1: string) => number) | EnchantmentBuilder$DamageBonusFunction;
    /**
    * @javaClass it.unimi.dsi.fastutil.objects.ObjectIterator
    */
    interface ObjectIterator <K> extends Internal.Iterator<K> {
        skip(arg0: number): number;
        forEachRemaining(arg0: Internal.Consumer_<K>): void;
        remove(): void;
    }
    type ObjectIterator_<K> = ObjectIterator<K>;
    /**
    * @javaClass me.shedaniel.rei.api.common.fluid.FluidSupportProvider
    */
    interface FluidSupportProvider extends Internal.Reloadable<Internal.REIPlugin<any>>, Internal.List<Internal.FluidSupportProvider$Provider> {
        getStage(): Internal.ReloadStage;
        startReload(stage: Internal.ReloadStage_): void;
        spliterator(): Internal.Spliterator<Internal.FluidSupportProvider$Provider>;
        forEach(arg0: Internal.Consumer_<Internal.FluidSupportProvider$Provider_>): void;
        sort(arg0: Internal.Comparator_<Internal.FluidSupportProvider$Provider_>): void;
        endReload(stage: Internal.ReloadStage_): void;
        endReload(): void;
        beforeReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>): void;
        isConcurrent(): boolean;
        replaceAll(arg0: Internal.UnaryOperator_<Internal.FluidSupportProvider$Provider_>): void;
        afterReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>, plugin: Internal.REIPlugin_<any>): void;
        removeIf(arg0: Internal.Predicate_<Internal.FluidSupportProvider$Provider_>): boolean;
        acceptPlugin(plugin: Internal.REIPlugin_<any>): void;
        acceptPlugin(plugin: Internal.REIPlugin_<any>, stage: Internal.ReloadStage_): void;
        afterReloadable(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>): void;
        stream(): Internal.Stream<Internal.FluidSupportProvider$Provider>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<Internal.FluidSupportProvider$Provider>;
        itemToFluids(arg0: Internal.EntryStack_<Internal.ItemStack_>): Internal.Optional<Internal.Stream<Internal.EntryStack<Internal.FluidStack>>>;
        getInstance(): this;
        beforeReloadablePlugin(stage: Internal.ReloadStage_, other: Internal.Reloadable_<Internal.REIPlugin_<any>>, plugin: Internal.REIPlugin_<any>): void;
        register(arg0: Internal.FluidSupportProvider$Provider_): void;
    }
    type FluidSupportProvider_ = FluidSupportProvider;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.config.ItemStackConfig
    */
    class ItemStackConfig extends Internal.ConfigValue<Internal.ItemStack> {
        getStringForGUI(v: Internal.ItemStack_): net.minecraft.network.chat.Component;
        onClicked(button: Internal.MouseButton_, callback: Internal.ConfigCallback_): void;
        copy(value: Internal.ItemStack_): Internal.ItemStack;
        readonly "allowEmpty" : boolean;
        readonly "singleItemOnly" : boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(single: boolean, empty: boolean);
    }
    type ItemStackConfig_ = ItemStackConfig;
    /**
    * @javaClass net.minecraft.class_2877
    */
    class ServerboundSignUpdatePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        getPos(): BlockPos;
        getLines(): string[];
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        get pos(): BlockPos;
        get skippable(): boolean;
        get lines(): string[];
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: string, $$2: string, $$3: string, $$4: string);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ServerboundSignUpdatePacket_ = ServerboundSignUpdatePacket;
    /**
    * @javaClass javax.swing.text.AttributeSet
    */
    interface AttributeSet {
        getResolveParent(): this;
        getAttribute(arg0: any): any;
        getAttributeNames(): Internal.Enumeration<any>;
        containsAttributes(arg0: Internal.AttributeSet_): boolean;
        isEqual(arg0: Internal.AttributeSet_): boolean;
        isDefined(arg0: any): boolean;
        containsAttribute(arg0: any, arg1: any): boolean;
        copyAttributes(): this;
        getAttributeCount(): number;
    }
    type AttributeSet_ = AttributeSet;
    /**
    * @javaClass net.minecraft.class_1255
    */
    abstract class BlockableEventLoop <R> implements Internal.ProfilerMeasured, Internal.ProcessorHandle<R>, Internal.Executor {
        managedBlock($$0: Internal.BooleanSupplier_): void;
        executeIfPossible($$0: Internal.Runnable_): void;
        submit($$0: Internal.Runnable_): Internal.CompletableFuture<void>;
        submit<V>($$0: Internal.Supplier_<V>): Internal.CompletableFuture<V>;
        tell($$0: R): void;
        isSameThread(): boolean;
        execute($$0: Internal.Runnable_): void;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle_<Internal.Either_<Source, Internal.Exception_>>, R>): Internal.CompletableFuture<Source>;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle_<Source>, R>): Internal.CompletableFuture<Source>;
        method_16898(): string;
        pollTask(): boolean;
        method_34705(): Internal.List<Internal.MetricSampler>;
        getPendingTasksCount(): number;
        executeBlocking($$0: Internal.Runnable_): void;
        close(): void;
        get pendingTasksCount(): number;
        get sameThread(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BlockableEventLoop_<R> = BlockableEventLoop<R>;
    /**
    * @javaClass net.minecraft.class_5866
    */
    class UniformFloat extends Internal.FloatProvider {
        static of($$0: number, $$1: number): Internal.UniformFloat;
        method_33915(): number;
        toString(): string;
        method_33923(): Internal.FloatProviderType<any>;
        method_33921(): number;
        method_33920($$0: Internal.Random_): number;
        static readonly "CODEC" : Internal.Codec<Internal.UniformFloat>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type UniformFloat_ = UniformFloat;
    /**
    * @javaClass net.minecraft.class_5929
    */
    class RandomizedIntStateProvider extends Internal.BlockStateProvider {
        method_23455($$0: Internal.Random_, $$1: BlockPos_): Internal.BlockState;
        static readonly "CODEC" : Internal.Codec<Internal.RandomizedIntStateProvider>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockStateProvider, $$1: Internal.IntegerProperty, $$2: Internal.IntProvider);
        constructor($$0: Internal.BlockStateProvider, $$1: string, $$2: Internal.IntProvider);
    }
    type RandomizedIntStateProvider_ = RandomizedIntStateProvider;
    /**
    * @javaClass net.minecraft.class_3917
    */
    class MenuType <T> {
        create($$0: number, $$1: Internal.Inventory_): T;
        static readonly "BREWING_STAND" : Internal.MenuType<Internal.BrewingStandMenu>;
        static readonly "ENCHANTMENT" : Internal.MenuType<Internal.EnchantmentMenu>;
        static readonly "LOOM" : Internal.MenuType<Internal.LoomMenu>;
        static readonly "BLAST_FURNACE" : Internal.MenuType<Internal.BlastFurnaceMenu>;
        static readonly "SMOKER" : Internal.MenuType<Internal.SmokerMenu>;
        static readonly "SMITHING" : Internal.MenuType<Internal.SmithingMenu>;
        static readonly "CARTOGRAPHY_TABLE" : Internal.MenuType<Internal.CartographyTableMenu>;
        static readonly "BEACON" : Internal.MenuType<Internal.BeaconMenu>;
        static readonly "HOPPER" : Internal.MenuType<Internal.HopperMenu>;
        static readonly "MERCHANT" : Internal.MenuType<Internal.MerchantMenu>;
        static readonly "FURNACE" : Internal.MenuType<Internal.FurnaceMenu>;
        static readonly "ANVIL" : Internal.MenuType<Internal.AnvilMenu>;
        static readonly "STONECUTTER" : Internal.MenuType<Internal.StonecutterMenu>;
        static readonly "GENERIC_3x3" : Internal.MenuType<Internal.DispenserMenu>;
        static readonly "CRAFTING" : Internal.MenuType<Internal.CraftingMenu>;
        static readonly "LECTERN" : Internal.MenuType<Internal.LecternMenu>;
        static readonly "GRINDSTONE" : Internal.MenuType<Internal.GrindstoneMenu>;
        static readonly "SHULKER_BOX" : Internal.MenuType<Internal.ShulkerBoxMenu>;
        static readonly "GENERIC_9x1" : Internal.MenuType<Internal.ChestMenu>;
        static readonly "GENERIC_9x2" : Internal.MenuType<Internal.ChestMenu>;
        static readonly "GENERIC_9x3" : Internal.MenuType<Internal.ChestMenu>;
        static readonly "GENERIC_9x4" : Internal.MenuType<Internal.ChestMenu>;
        static readonly "GENERIC_9x5" : Internal.MenuType<Internal.ChestMenu>;
        static readonly "GENERIC_9x6" : Internal.MenuType<Internal.ChestMenu>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: any);
    }
    type MenuType_<T> = Special.MenuType | MenuType<T>;
    /**
    * @javaClass eu.ha3.presencefootsteps.sound.player.SoundPlayer
    */
    interface SoundPlayer {
        think(): void;
        playSound(arg0: Internal.LivingEntity_, arg1: string, arg2: number, arg3: number, arg4: eu.ha3.presencefootsteps.sound.Options_): void;
        getRNG(): Internal.Random;
    }
    type SoundPlayer_ = SoundPlayer;
    /**
    * @javaClass java.util.function.ObjDoubleConsumer
    */
    interface ObjDoubleConsumer <T> {
        accept(arg0: T, arg1: number): void;
    }
    type ObjDoubleConsumer_<T> = ((arg0: T, arg1: number) => void) | ObjDoubleConsumer<T>;
    /**
    * @javaClass net.fabricmc.fabric.api.loot.v1.FabricLootSupplier
    */
    interface FabricLootSupplier {
        getType(): Internal.LootContextParamSet;
        getFunctions(): Internal.List<Internal.LootItemFunction>;
        asVanilla(): Internal.LootTable;
        getPools(): Internal.List<Internal.LootPool>;
    }
    type FabricLootSupplier_ = FabricLootSupplier;
    /**
    * @javaClass me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider
    */
    interface DraggableBoundsProvider {
        fromRectangle(bounds: me.shedaniel.math.Rectangle_): Internal.VoxelShape;
        bounds(): Internal.VoxelShape;
        concat(providers: Internal.Iterable_<Internal.DraggableBoundsProvider_>): this;
        ofRectangle(bounds: me.shedaniel.math.Rectangle_): this;
        ofRectangles(bounds: Internal.Iterable_<me.shedaniel.math.Rectangle_>): this;
        ofShapes(shapes: Internal.Iterable_<Internal.VoxelShape_>): this;
        ofShape(shape: Internal.VoxelShape_): this;
        empty(): this;
    }
    type DraggableBoundsProvider_ = (() => Internal.VoxelShape) | DraggableBoundsProvider;
    /**
    * @javaClass net.minecraft.class_1508
    */
    class EnderDragonPart extends Internal.Entity {
        canRiderInteract(): boolean;
        method_5779($$0: Internal.Entity_): boolean;
        method_18002(): Internal.Packet<any>;
        method_18377($$0: Internal.Pose_): Internal.EntityDimensions;
        getStepHeight(): number;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_31746(): boolean;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_5643($$0: Internal.DamageSource_, $$1: number): boolean;
        method_5863(): boolean;
        alwaysAccepts(): boolean;
        asKJS(): Internal.EntityJS;
        readonly "parentMob" : Internal.EnderDragon;
        readonly "name" : string;
        get stepHeight(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.EnderDragon, $$1: string, $$2: number, $$3: number);
    }
    type EnderDragonPart_ = EnderDragonPart;
    /**
    * @javaClass java.util.AbstractSet
    */
    abstract class AbstractSet <E> extends Internal.AbstractCollection<E> implements Internal.Set<E> {
        removeAll(arg0: Internal.Collection_<any>): boolean;
        spliterator(): Internal.Spliterator<E>;
        stream(): Internal.Stream<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        hashCode(): number;
        equals(arg0: any): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type AbstractSet_<E> = AbstractSet<E>;
    /**
    * @javaClass net.minecraft.class_1952
    */
    class SpawnData extends Internal.Record {
        customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        getCustomSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        getEntityToSpawn(): Internal.CompoundTag;
        hashCode(): number;
        equals($$0: any): boolean;
        toString(): string;
        entityToSpawn(): Internal.CompoundTag;
        static readonly "CODEC" : Internal.Codec<Internal.SpawnData>;
        static readonly "DEFAULT_TYPE" : "minecraft:pig";
        static readonly "LIST_CODEC" : Internal.Codec<Internal.SimpleWeightedRandomList<Internal.SpawnData>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
        constructor($$0: Internal.CompoundTag, $$1: Internal.Optional<Internal.SpawnData$CustomSpawnRules>);
    }
    type SpawnData_ = SpawnData;
    /**
    * @javaClass xaero.common.minimap.element.render.MinimapElementRendererHandler
    */
    abstract class MinimapElementRendererHandler {
        add(renderer: Internal.MinimapElementRenderer_<any, any>): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type MinimapElementRendererHandler_ = MinimapElementRendererHandler;
    /**
    * @javaClass net.minecraft.class_5865
    */
    class TrapezoidFloat extends Internal.FloatProvider {
        static of($$0: number, $$1: number, $$2: number): Internal.TrapezoidFloat;
        method_33915(): number;
        toString(): string;
        method_33923(): Internal.FloatProviderType<any>;
        method_33921(): number;
        method_33920($$0: Internal.Random_): number;
        static readonly "CODEC" : Internal.Codec<Internal.TrapezoidFloat>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type TrapezoidFloat_ = TrapezoidFloat;
    /**
    * @javaClass java.lang.Iterable
    */
    interface Iterable <T> {
        iterator(): Internal.Iterator<T>;
        spliterator(): Internal.Spliterator<T>;
        forEach(arg0: Internal.Consumer_<T>): void;
    }
    type Iterable_<T> = Iterable<T>;
    /**
    * @javaClass net.minecraft.class_3317
    */
    class IpBanList extends Internal.StoredUserList<string, Internal.IpBanListEntry> {
        get($$0: Internal.SocketAddress_): Internal.IpBanListEntry;
        isBanned($$0: string): boolean;
        isBanned($$0: Internal.SocketAddress_): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.File);
    }
    type IpBanList_ = IpBanList;
    /**
    * @javaClass net.minecraft.class_3213
    */
    class ServerBossEvent extends Internal.BossEvent {
        setVisible($$0: boolean): void;
        method_5416($$0: Internal.BossEvent$BossBarColor_): void;
        method_5406($$0: boolean): Internal.BossEvent;
        removeAllPlayers(): void;
        method_5409($$0: Internal.BossEvent$BossBarOverlay_): void;
        addPlayer($$0: Internal.ServerPlayer_): void;
        method_5408($$0: number): void;
        isVisible(): boolean;
        method_5413($$0: net.minecraft.network.chat.Component_): void;
        getPlayers(): Internal.Collection<Internal.ServerPlayer>;
        method_5410($$0: boolean): Internal.BossEvent;
        removePlayer($$0: Internal.ServerPlayer_): void;
        method_5411($$0: boolean): Internal.BossEvent;
        get visible(): boolean;
        get players(): Internal.Collection<Internal.ServerPlayer>;
        set visible($$0: boolean);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: net.minecraft.network.chat.Component, $$1: Internal.BossEvent$BossBarColor, $$2: Internal.BossEvent$BossBarOverlay);
    }
    type ServerBossEvent_ = ServerBossEvent;
    /**
    * @javaClass java.time.chrono.IsoEra
    */
    class IsoEra extends Internal.Enum<Internal.IsoEra> implements Internal.Era {
        getLong(arg0: Internal.TemporalField_): number;
        getValue(): number;
        getDisplayName(arg0: Internal.TextStyle_, arg1: Internal.Locale_): string;
        static valueOf(arg0: string): Internal.IsoEra;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        get(arg0: Internal.TemporalField_): number;
        static of(arg0: number): Internal.IsoEra;
        static values(): Internal.IsoEra[];
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        isSupported(arg0: Internal.TemporalField_): boolean;
        static readonly "CE" : Internal.IsoEra;
        static readonly "BCE" : Internal.IsoEra;
        get value(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type IsoEra_ = "ce" | "bce" | IsoEra;
    /**
    * @javaClass com.github.clevernucleus.dataattributes.api.attribute.IEntityAttributeInstance
    */
    interface IEntityAttributeInstance {
        updateModifier(arg0: Internal.UUID_, arg1: number): void;
    }
    type IEntityAttributeInstance_ = IEntityAttributeInstance;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.ItemHandler
    */
    interface ItemHandler extends Internal.Iterable<Internal.ItemStack> {
        getHeight(): number;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        extractItem(arg0: number, arg1: number, arg2: boolean): Internal.ItemStack;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack_>): void;
        getSlotLimit(arg0: number): number;
        isItemValid(arg0: number, arg1: Internal.ItemStack_): boolean;
        getSlots(): number;
        getWidth(): number;
        getStackInSlot(arg0: number): Internal.ItemStack;
        insertItem(arg0: number, arg1: Internal.ItemStack_, arg2: boolean): Internal.ItemStack;
    }
    type ItemHandler_ = ItemHandler;
    /**
    * @javaClass me.shedaniel.rei.api.client.registry.screen.OverlayDecider
    */
    interface OverlayDecider extends Internal.Comparable<Internal.OverlayDecider> {
        shouldRecalculateArea(location: Internal.DisplayPanelLocation_, rectangle: me.shedaniel.math.Rectangle_): boolean;
        isHandingScreen<R>(arg0: Internal.Class_<R>): boolean;
        getPriority(): number;
        isInZone(mouseX: number, mouseY: number): Internal.InteractionResult;
        compareTo(o: Internal.OverlayDecider_): number;
        shouldScreenBeOverlaid(screen: Internal.Class_<any>): Internal.InteractionResult;
        shouldScreenBeOverlaid<R>(screen: R): Internal.InteractionResult;
    }
    type OverlayDecider_ = OverlayDecider;
    /**
    * @javaClass net.minecraft.class_2641
    */
    class ClientboundCommandsPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getRoot(): Internal.RootCommandNode<Internal.SharedSuggestionProvider>;
        get root(): Internal.RootCommandNode<Internal.SharedSuggestionProvider>;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.RootCommandNode<Internal.SharedSuggestionProvider>);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundCommandsPacket_ = ClientboundCommandsPacket;
    /**
    * @javaClass ca.spottedleaf.starlight.common.light.StarLightLightingProvider
    */
    interface StarLightLightingProvider {
        getLightEngine(): Internal.StarLightInterface;
        clientUpdateLight(arg0: Internal.LightLayer_, arg1: Internal.SectionPos_, arg2: Internal.DataLayer_, arg3: boolean): void;
        clientRemoveLightData(arg0: Internal.ChunkPos_): void;
        clientChunkLoad(arg0: Internal.ChunkPos_, arg1: Internal.LevelChunk_): void;
    }
    type StarLightLightingProvider_ = StarLightLightingProvider;
    /**
    * @javaClass net.minecraft.class_6658
    */
    class BlockPredicateFilter extends Internal.PlacementFilter {
        static forPredicate($$0: Internal.BlockPredicate_): Internal.BlockPredicateFilter;
        method_39615(): Internal.PlacementModifierType<any>;
        static readonly "CODEC" : Internal.Codec<Internal.BlockPredicateFilter>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type BlockPredicateFilter_ = BlockPredicateFilter;
    /**
    * @javaClass dev.latvian.mods.kubejs.client.painter.PaintEventJS
    */
    class PaintEventJS extends Internal.ClientEventJS {
        vertex(m: Internal.Matrix4f_, x: number, y: number, z: number, col: number, u: number, v: number): void;
        vertex(m: Internal.Matrix4f_, x: number, y: number, z: number, col: number): void;
        setShaderTexture(tex: ResourceLocation_): void;
        beginQuads(texture: boolean): void;
        beginQuads(format: Internal.VertexFormat_): void;
        bindTextureForSetup(tex: ResourceLocation_): void;
        scale(x: number, y: number, z: number): void;
        translate(x: number, y: number, z: number): void;
        push(): void;
        setShaderColor(r: number, g: number, b: number, a: number): void;
        setShaderInstance(shader: Internal.Supplier_<Internal.ShaderInstance_>): void;
        pop(): void;
        setPositionColorShader(): void;
        getMatrix(): Internal.Matrix4f;
        resetShaderColor(): void;
        end(): void;
        multiply(q: Internal.Quaternion_): void;
        setPositionColorTextureShader(): void;
        begin(type: Internal.VertexFormat$Mode_, format: Internal.VertexFormat_): void;
        multiplyWithMatrix(m: Internal.Matrix4f_): void;
        readonly "mc" : Internal.Minecraft;
        readonly "delta" : number;
        readonly "screen" : Internal.Screen;
        readonly "tesselator" : Internal.Tesselator;
        readonly "buffer" : Internal.BufferBuilder;
        readonly "matrices" : Internal.PoseStack;
        readonly "font" : net.minecraft.client.gui.Font;
        get matrix(): Internal.Matrix4f;
        set shaderTexture(tex: ResourceLocation_);
        set shaderInstance(shader: Internal.Supplier_<Internal.ShaderInstance_>);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(m: Internal.Minecraft, p: Internal.PoseStack, d: number, s: Internal.Screen);
    }
    type PaintEventJS_ = PaintEventJS;
    /**
    * @javaClass com.mojang.authlib.minecraft.TelemetryEvent
    */
    interface TelemetryEvent extends Internal.TelemetryPropertyContainer {
        send(): void;
    }
    type TelemetryEvent_ = TelemetryEvent;
    /**
    * @javaClass dev.kosmx.playerAnim.api.layered.AnimationStack
    */
    class AnimationStack implements Internal.IAnimation {
        removeLayer(layerLevel: number): boolean;
        removeLayer(layer: Internal.IAnimation_): boolean;
        setupAnim(tickDelta: number): void;
        get3DTransform(modelName: string, type: Internal.TransformType_, tickDelta: number, value0: Internal.Vec3f_): Internal.Vec3f;
        tick(): void;
        isActive(): boolean;
        addAnimLayer(priority: number, layer: Internal.IAnimation_): void;
        get active(): boolean;
        set upAnim(tickDelta: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AnimationStack_ = AnimationStack;
    /**
    * @javaClass net.minecraft.class_1334
    */
    class JumpControl implements Internal.Control {
        tick(): void;
        jump(): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Mob);
    }
    type JumpControl_ = JumpControl;
    /**
    * @javaClass java.net.InetAddress
    */
    class InetAddress implements Internal.Serializable {
        isReachable(arg0: Internal.NetworkInterface_, arg1: number, arg2: number): boolean;
        isReachable(arg0: number): boolean;
        isMCSiteLocal(): boolean;
        static getAllByName(arg0: string): Internal.InetAddress[];
        isMCGlobal(): boolean;
        getHostName(): string;
        isMCOrgLocal(): boolean;
        getCanonicalHostName(): string;
        isAnyLocalAddress(): boolean;
        isLinkLocalAddress(): boolean;
        static getLocalHost(): Internal.InetAddress;
        isMCLinkLocal(): boolean;
        isLoopbackAddress(): boolean;
        isSiteLocalAddress(): boolean;
        isMulticastAddress(): boolean;
        hashCode(): number;
        equals(arg0: any): boolean;
        static getByName(arg0: string): Internal.InetAddress;
        static getLoopbackAddress(): Internal.InetAddress;
        static getByAddress(arg0: number[]): Internal.InetAddress;
        static getByAddress(arg0: string, arg1: number[]): Internal.InetAddress;
        getAddress(): number[];
        toString(): string;
        getHostAddress(): string;
        isMCNodeLocal(): boolean;
        get linkLocalAddress(): boolean;
        get hostName(): string;
        get loopbackAddress(): Internal.InetAddress;
        get address(): number[];
        get canonicalHostName(): string;
        get mCOrgLocal(): boolean;
        get siteLocalAddress(): boolean;
        get mCNodeLocal(): boolean;
        get mCGlobal(): boolean;
        get localHost(): Internal.InetAddress;
        get mCLinkLocal(): boolean;
        get multicastAddress(): boolean;
        get hostAddress(): string;
        get mCSiteLocal(): boolean;
        get anyLocalAddress(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type InetAddress_ = InetAddress;
    /**
    * @javaClass net.minecraft.class_3270
    */
    interface MetadataSectionSerializer <T> {
        getMetadataSectionName(): string;
        fromJson(arg0: Internal.JsonObject_): T;
    }
    type MetadataSectionSerializer_<T> = MetadataSectionSerializer<T>;
    /**
    * @javaClass xaero.map.capabilities.ServerWorldLoaded
    */
    class ServerWorldLoaded {
        "loaded" : boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type ServerWorldLoaded_ = ServerWorldLoaded;
    /**
    * @javaClass net.minecraft.class_4095
    */
    class Brain <E> {
        serializeStart<T>($$0: Internal.DynamicOps_<T>): Internal.DataResult<T>;
        eraseMemory<U>($$0: Internal.MemoryModuleType_<U>): void;
        setCoreActivities($$0: Internal.Set_<Internal.Activity_>): void;
        addActivityAndRemoveMemoriesWhenStopped($$0: Internal.Activity_, $$1: Internal.ImmutableList_<com.mojang.datafixers.util.Pair_<number, Internal.Behavior_<E>>>, $$2: Internal.Set_<com.mojang.datafixers.util.Pair_<Internal.MemoryModuleType_<any>, Internal.MemoryStatus_>>, $$3: Internal.Set_<Internal.MemoryModuleType_<any>>): void;
        isActive($$0: Internal.Activity_): boolean;
        setMemory<U>($$0: Internal.MemoryModuleType_<U>, $$1: U): void;
        setMemory<U>($$0: Internal.MemoryModuleType_<U>, $$1: Internal.Optional_<U>): void;
        getSchedule(): Internal.Schedule;
        getRunningBehaviors(): Internal.List<Internal.Behavior<E>>;
        setActiveActivityToFirstValid($$0: Internal.List_<Internal.Activity_>): void;
        stopAll($$0: Internal.ServerLevel_, $$1: E): void;
        checkMemory($$0: Internal.MemoryModuleType_<any>, $$1: Internal.MemoryStatus_): boolean;
        static provider<E>($$0: Internal.Collection_<Internal.MemoryModuleType_<any>>, $$1: Internal.Collection_<Internal.SensorType_<Internal.Sensor_<E>>>): Internal.Brain$Provider<E>;
        removeAllBehaviors(): void;
        setActiveActivityIfPossible($$0: Internal.Activity_): void;
        useDefaultActivity(): void;
        isMemoryValue<U>($$0: Internal.MemoryModuleType_<U>, $$1: U): boolean;
        getTimeUntilExpiry<U>($$0: Internal.MemoryModuleType_<U>): number;
        addActivityWithConditions($$0: Internal.Activity_, $$1: Internal.ImmutableList_<com.mojang.datafixers.util.Pair_<number, Internal.Behavior_<E>>>, $$2: Internal.Set_<com.mojang.datafixers.util.Pair_<Internal.MemoryModuleType_<any>, Internal.MemoryStatus_>>): void;
        setSchedule($$0: Internal.Schedule_): void;
        addActivityAndRemoveMemoryWhenStopped($$0: Internal.Activity_, $$1: number, $$2: Internal.ImmutableList_<Internal.Behavior_<E>>, $$3: Internal.MemoryModuleType_<any>): void;
        setMemoryWithExpiry<U>($$0: Internal.MemoryModuleType_<U>, $$1: U, $$2: number): void;
        copyWithoutBehaviors(): Internal.Brain<E>;
        updateActivityFromSchedule($$0: number, $$1: number): void;
        addActivity($$0: Internal.Activity_, $$1: Internal.ImmutableList_<com.mojang.datafixers.util.Pair_<number, Internal.Behavior_<E>>>): void;
        addActivity($$0: Internal.Activity_, $$1: number, $$2: Internal.ImmutableList_<Internal.Behavior_<E>>): void;
        tick($$0: Internal.ServerLevel_, $$1: E): void;
        getMemory<U>($$0: Internal.MemoryModuleType_<U>): Internal.Optional<U>;
        static codec<E>($$0: Internal.Collection_<Internal.MemoryModuleType_<any>>, $$1: Internal.Collection_<Internal.SensorType_<Internal.Sensor_<E>>>): Internal.Codec<Internal.Brain<E>>;
        getActiveNonCoreActivity(): Internal.Optional<Internal.Activity>;
        setDefaultActivity($$0: Internal.Activity_): void;
        getMemories(): Internal.Map<Internal.MemoryModuleType<any>, Internal.Optional<Internal.ExpirableValue<any>>>;
        hasMemoryValue($$0: Internal.MemoryModuleType_<any>): boolean;
        getActiveActivities(): Internal.Set<Internal.Activity>;
        get schedule(): Internal.Schedule;
        get activeNonCoreActivity(): Internal.Optional<Internal.Activity>;
        get activeActivities(): Internal.Set<Internal.Activity>;
        get memories(): Internal.Map<Internal.MemoryModuleType<any>, Internal.Optional<Internal.ExpirableValue<any>>>;
        get runningBehaviors(): Internal.List<Internal.Behavior<E>>;
        set schedule($$0: Internal.Schedule_);
        set defaultActivity($$0: Internal.Activity_);
        set coreActivities($$0: Internal.Set_<Internal.Activity_>);
        set activeActivityIfPossible($$0: Internal.Activity_);
        set activeActivityToFirstValid($$0: Internal.List_<Internal.Activity_>);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.Collection<Internal.MemoryModuleType<any>>, $$1: Internal.Collection<Internal.SensorType<Internal.Sensor<E>>>, $$2: Internal.ImmutableList<any>, $$3: (() => Internal.Codec<Internal.Brain<E>>));
    }
    type Brain_<E> = Brain<E>;
    /**
    * @javaClass com.google.common.collect.ImmutableCollection$Builder
    */
    abstract class ImmutableCollection$Builder <E> {
        add(arg0: E): Internal.ImmutableCollection$Builder<E>;
        add(...arg0: E[]): Internal.ImmutableCollection$Builder<E>;
        build(): Internal.ImmutableCollection<E>;
        addAll(arg0: Internal.Iterator_<E>): Internal.ImmutableCollection$Builder<E>;
        addAll(arg0: Internal.Iterable_<E>): Internal.ImmutableCollection$Builder<E>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ImmutableCollection$Builder_<E> = ImmutableCollection$Builder<E>;
    /**
    * @javaClass dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$TaskEvent
    */
    class ObjectCompletedEvent$TaskEvent extends Internal.ObjectCompletedEvent<Internal.Task> {
        getTask(): Internal.Task;
        get task(): Internal.Task;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(d: Internal.QuestProgressEventData<Internal.Task>);
    }
    type ObjectCompletedEvent$TaskEvent_ = ObjectCompletedEvent$TaskEvent;
    /**
    * @javaClass dev.onyxstudios.cca.api.v3.component.ComponentContainer
    */
    interface ComponentContainer extends Internal.NbtSerializable {
        fromTag(arg0: Internal.CompoundTag_): void;
        toDynamic<T>(dynamic: Internal.Dynamic_<T>): Internal.Dynamic<T>;
        keys(): Internal.Set<Internal.ComponentKey<any>>;
        fromDynamic(dynamic: Internal.Dynamic_<any>): void;
        toTag(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        tickClientComponents(): void;
        hasComponents(): boolean;
        tickServerComponents(): void;
        copyFrom(arg0: Internal.ComponentContainer_): void;
    }
    type ComponentContainer_ = ComponentContainer;
    /**
    * @javaClass net.minecraft.class_744
    */
    class Input {
        hasForwardImpulse(): boolean;
        getMoveVector(): Internal.Vec2;
        tick($$0: boolean): void;
        "forwardImpulse" : number;
        "jumping" : boolean;
        "left" : boolean;
        "leftImpulse" : number;
        "shiftKeyDown" : boolean;
        "up" : boolean;
        "right" : boolean;
        "down" : boolean;
        get moveVector(): Internal.Vec2;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type Input_ = Input;
    /**
    * @javaClass javax.crypto.Cipher
    */
    class Cipher {
        static getMaxAllowedParameterSpec(arg0: string): Internal.AlgorithmParameterSpec;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameters_): void;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameterSpec_): void;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.SecureRandom_): void;
        init(arg0: number, arg1: Internal.Key_): void;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameterSpec_, arg3: Internal.SecureRandom_): void;
        init(arg0: number, arg1: Internal.Certificate_): void;
        init(arg0: number, arg1: Internal.Certificate_, arg2: Internal.SecureRandom_): void;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameters_, arg3: Internal.SecureRandom_): void;
        getAlgorithm(): string;
        update(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number): number;
        update(arg0: number[], arg1: number, arg2: number, arg3: number[]): number;
        update(arg0: number[], arg1: number, arg2: number): number[];
        update(arg0: number[]): number[];
        update(arg0: Internal.ByteBuffer_, arg1: Internal.ByteBuffer_): number;
        getOutputSize(arg0: number): number;
        updateAAD(arg0: Internal.ByteBuffer_): void;
        updateAAD(arg0: number[], arg1: number, arg2: number): void;
        updateAAD(arg0: number[]): void;
        doFinal(arg0: number[], arg1: number): number;
        doFinal(arg0: number[]): number[];
        doFinal(): number[];
        doFinal(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number): number;
        doFinal(arg0: Internal.ByteBuffer_, arg1: Internal.ByteBuffer_): number;
        doFinal(arg0: number[], arg1: number, arg2: number): number[];
        doFinal(arg0: number[], arg1: number, arg2: number, arg3: number[]): number;
        static getMaxAllowedKeyLength(arg0: string): number;
        unwrap(arg0: number[], arg1: string, arg2: number): Internal.Key;
        getExemptionMechanism(): Internal.ExemptionMechanism;
        getBlockSize(): number;
        getIV(): number[];
        getParameters(): Internal.AlgorithmParameters;
        getProvider(): Internal.Provider;
        toString(): string;
        static getInstance(arg0: string): Internal.Cipher;
        static getInstance(arg0: string, arg1: Internal.Provider_): Internal.Cipher;
        static getInstance(arg0: string, arg1: string): Internal.Cipher;
        wrap(arg0: Internal.Key_): number[];
        static readonly "WRAP_MODE" : 3;
        static readonly "UNWRAP_MODE" : 4;
        static readonly "ENCRYPT_MODE" : 1;
        static readonly "PUBLIC_KEY" : 1;
        static readonly "PRIVATE_KEY" : 2;
        static readonly "SECRET_KEY" : 3;
        static readonly "DECRYPT_MODE" : 2;
        get provider(): Internal.Provider;
        get exemptionMechanism(): Internal.ExemptionMechanism;
        get iV(): number[];
        get parameters(): Internal.AlgorithmParameters;
        get blockSize(): number;
        get algorithm(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type Cipher_ = Cipher;
    /**
    * @javaClass dev.latvian.mods.rhino.mod.util.StringBuilderAppendable
    */
    interface StringBuilderAppendable {
        appendString(arg0: Internal.StringBuilder_): void;
    }
    type StringBuilderAppendable_ = StringBuilderAppendable;
    /**
    * @javaClass net.minecraft.class_2556
    */
    class ChatType extends Internal.Enum<Internal.ChatType> {
        shouldInterrupt(): boolean;
        getIndex(): number;
        static valueOf($$0: string): Internal.ChatType;
        static values(): Internal.ChatType[];
        static getForIndex($$0: number): Internal.ChatType;
        static readonly "SYSTEM" : Internal.ChatType;
        static readonly "CHAT" : Internal.ChatType;
        static readonly "GAME_INFO" : Internal.ChatType;
        get index(): number;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type ChatType_ = "system" | "chat" | "game_info" | ChatType;
    /**
    * @javaClass io.github.fabricators_of_create.porting_lib.entity.ExtraSpawnDataEntity
    */
    interface ExtraSpawnDataEntity {
        createExtraDataSpawnPacket(entity: Internal.Entity_): Internal.Packet<any>;
        createExtraDataSpawnPacket(entity: Internal.ExtraSpawnDataEntity_, basePacket: Internal.ClientboundAddEntityPacket_): Internal.Packet<any>;
        readSpawnData(arg0: Internal.FriendlyByteBuf_): void;
        initClientNetworking(): void;
        writeSpawnData(arg0: Internal.FriendlyByteBuf_): void;
    }
    type ExtraSpawnDataEntity_ = ExtraSpawnDataEntity;
    /**
    * @javaClass net.minecraft.class_6044
    */
    class AxolotlAttackablesSensor extends Internal.NearestVisibleLivingEntitySensor {
        static readonly "TARGET_DETECTION_DISTANCE" : 8.0;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type AxolotlAttackablesSensor_ = AxolotlAttackablesSensor;
    /**
    * @javaClass pm.c7.scout.mixin.HandledScreenAccessor
    */
    interface HandledScreenAccessor {
        getX(): number;
        getY(): number;
    }
    type HandledScreenAccessor_ = HandledScreenAccessor;
    /**
    * @javaClass com.almostreliable.lootjs.loot.AddAttributesFunction$Modifier$Builder
    */
    class AddAttributesFunction$Modifier$Builder {
        setSlots(slots: EquipmentSlot_[]): void;
        setName(name: string): void;
        build(): Internal.AddAttributesFunction$Modifier;
        setOperation(operation: Internal.AttributeModifier$Operation_): void;
        setProbability(probability: number): void;
        setUuid(uuid: Internal.UUID_): void;
        set slots(slots: EquipmentSlot_[]);
        set probability(probability: number);
        set name(name: string);
        set uuid(uuid: Internal.UUID_);
        set operation(operation: Internal.AttributeModifier$Operation_);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(attribute: Internal.Attribute, amount: Internal.NumberProvider);
    }
    type AddAttributesFunction$Modifier$Builder_ = AddAttributesFunction$Modifier$Builder;
    /**
    * @javaClass xaero.map.highlight.HighlighterRegistry
    */
    class HighlighterRegistry {
        end(): void;
        getHighlighters(): Internal.List<xaero.map.highlight.AbstractHighlighter>;
        register(highlighter: xaero.map.highlight.AbstractHighlighter_): void;
        get highlighters(): Internal.List<xaero.map.highlight.AbstractHighlighter>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type HighlighterRegistry_ = HighlighterRegistry;
    /**
    * @javaClass dev.ftb.mods.ftblibrary.ui.Panel
    */
    abstract class Panel extends dev.ftb.mods.ftblibrary.ui.Widget {
        closeGui(openPrevScreen: boolean): void;
        closeGui(): void;
        getContentHeight(): number;
        run(): void;
        isDefaultScrollVertical(): boolean;
        align(layout: Internal.WidgetLayout_): number;
        mousePressed(button: Internal.MouseButton_): boolean;
        drawBackground(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        setOffset(flag: boolean): void;
        drawOffsetBackground(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        updateMouseOver(mouseX: number, mouseY: number): void;
        getScrollStep(): number;
        add(widget: dev.ftb.mods.ftblibrary.ui.Widget_): void;
        onClosed(): void;
        keyPressed(key: dev.ftb.mods.ftblibrary.ui.input.Key_): boolean;
        getWidget(index: number): dev.ftb.mods.ftblibrary.ui.Widget;
        openGui(): void;
        setOnlyInteractWithWidgetsInside(value: boolean): void;
        setOnlyRenderWidgetsInside(value: boolean): void;
        tick(): void;
        addMouseOverText(list: Internal.TooltipList_): void;
        refreshWidgets(): void;
        isOffset(): boolean;
        alignWidgets(): void;
        charTyped(c: string, modifiers: Internal.KeyModifiers_): boolean;
        mouseDoubleClicked(button: Internal.MouseButton_): boolean;
        mouseScrolled(scroll: number): boolean;
        drawWidget(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, widget: dev.ftb.mods.ftblibrary.ui.Widget_, index: number, x: number, y: number, w: number, h: number): void;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        closeContextMenu(): void;
        isMouseOverAnyWidget(): boolean;
        mouseReleased(button: Internal.MouseButton_): void;
        getScrollX(): number;
        getScrollY(): number;
        getContentWidth(): number;
        openGuiLater(): void;
        clearWidgets(): void;
        keyReleased(key: dev.ftb.mods.ftblibrary.ui.input.Key_): void;
        getCursor(): Internal.CursorType;
        setScrollStep(s: number): void;
        movePanelScroll(dx: number, dy: number): boolean;
        draw(matrixStack: Internal.PoseStack_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        getOnlyRenderWidgetsInside(): boolean;
        getOnlyInteractWithWidgetsInside(): boolean;
        addWidgets(): void;
        openContextMenu(panel: Internal.Panel_): void;
        getX(): number;
        getY(): number;
        addAll(list: Internal.Iterable_<dev.ftb.mods.ftblibrary.ui.Widget_>): void;
        scrollPanel(scroll: number): boolean;
        setScrollX(scroll: number): void;
        getIngredientUnderMouse(): any;
        setScrollY(scroll: number): void;
        "attachedScrollbar" : Internal.PanelScrollBar;
        "contentWidthExtra" : number;
        readonly "widgets" : Internal.List<dev.ftb.mods.ftblibrary.ui.Widget>;
        "contentHeightExtra" : number;
        get cursor(): Internal.CursorType;
        get ingredientUnderMouse(): any;
        get defaultScrollVertical(): boolean;
        get onlyInteractWithWidgetsInside(): boolean;
        get offset(): boolean;
        get scrollStep(): number;
        get contentHeight(): number;
        get contentWidth(): number;
        get onlyRenderWidgetsInside(): boolean;
        get mouseOverAnyWidget(): boolean;
        get x(): number;
        get y(): number;
        get scrollY(): number;
        get scrollX(): number;
        set onlyInteractWithWidgetsInside(value: boolean);
        set offset(flag: boolean);
        set onlyRenderWidgetsInside(value: boolean);
        set scrollY(scroll: number);
        set scrollStep(s: number);
        set scrollX(scroll: number);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(panel: Internal.Panel);
    }
    type Panel_ = Panel;
    /**
    * @javaClass dev.latvian.mods.kubejs.server.CommandEventJS
    */
    class CommandEventJS extends Internal.ServerEventJS {
        getException(): Internal.Throwable;
        getParseResults(): Internal.ParseResults<Internal.CommandSourceStack>;
        setException(exception: Internal.Throwable_): void;
        setParseResults(parse: Internal.ParseResults_<Internal.CommandSourceStack_>): void;
        canCancel(): boolean;
        get exception(): Internal.Throwable;
        get parseResults(): Internal.ParseResults<Internal.CommandSourceStack>;
        set exception(exception: Internal.Throwable_);
        set parseResults(parse: Internal.ParseResults_<Internal.CommandSourceStack_>);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(e: any);
    }
    type CommandEventJS_ = CommandEventJS;
    /**
    * @javaClass com.telepathicgrunt.the_bumblezone.mixin.items.PlayerDamageShieldInvoker
    */
    interface PlayerDamageShieldInvoker {
        thebumblezone_callDamagedShield(arg0: number): void;
    }
    type PlayerDamageShieldInvoker_ = PlayerDamageShieldInvoker;
    /**
    * @javaClass net.minecraft.class_1854
    */
    class FireworkStarFadeRecipe extends Internal.CustomRecipe {
        method_17716(): Internal.RecipeType<any>;
        getRemainingItems(inventory: net.minecraft.world.Container_): Internal.NonNullList<any>;
        getGroup(): string;
        method_8113($$0: number, $$1: number): boolean;
        handler$hbn000$getRemainder(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getToastSymbol(): Internal.ItemStack;
        assemble($$0: Internal.CraftingContainer_): Internal.ItemStack;
        method_8119(): Internal.RecipeSerializer<any>;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isIncomplete(): boolean;
        get toastSymbol(): Internal.ItemStack;
        get incomplete(): boolean;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>;
        get group(): string;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: ResourceLocation);
    }
    type FireworkStarFadeRecipe_ = FireworkStarFadeRecipe;
    /**
    * @javaClass xaero.common.minimap.waypoints.WaypointWorld
    */
    class WaypointWorld {
        hasSomethingToRemoveOnSave(): boolean;
        getSets(): Internal.HashMap<string, Internal.WaypointSet>;
        onSaveCleanup(worldFile: Internal.File_): void;
        getContainer(): Internal.WaypointWorldContainer;
        getCurrentSet(): Internal.WaypointSet;
        getFullId(): string;
        getId(): string;
        requestRemovalOnSave(name: string): void;
        getServerWaypointsDisabled(): Internal.HashMap<string, boolean>;
        addSet(s: string): void;
        getServerWaypoints(): Internal.HashMap<number, Internal.Waypoint>;
        setId(id: string): void;
        getInternalWorldKey(): string;
        getCurrent(): string;
        setContainer(container: Internal.WaypointWorldContainer_): void;
        setCurrent(current: string): void;
        get container(): Internal.WaypointWorldContainer;
        get serverWaypoints(): Internal.HashMap<number, Internal.Waypoint>;
        get current(): string;
        get sets(): Internal.HashMap<string, Internal.WaypointSet>;
        get internalWorldKey(): string;
        get fullId(): string;
        get id(): string;
        get currentSet(): Internal.WaypointSet;
        get serverWaypointsDisabled(): Internal.HashMap<string, boolean>;
        set container(container: Internal.WaypointWorldContainer_);
        set current(current: string);
        set id(id: string);
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(container: Internal.WaypointWorldContainer, id: string);
    }
    type WaypointWorld_ = WaypointWorld;
    /**
    * @javaClass com.mojang.datafixers.TypedOptic
    */
    class TypedOptic <S, T, A, B> {
        static adapter<S, T>(arg0: com.mojang.datafixers.types.Type_<S>, arg1: com.mojang.datafixers.types.Type_<T>): Internal.TypedOptic<S, T, S, T>;
        tType(): com.mojang.datafixers.types.Type<T>;
        aType(): com.mojang.datafixers.types.Type<A>;
        apply<P, Proof2>(arg0: Internal.TypeToken_<Proof2>, arg1: Internal.App_<Proof2, P>, arg2: Internal.App2_<P, A, B>): Internal.App2<P, S, T>;
        static proj2<F, G, G2>(arg0: com.mojang.datafixers.types.Type_<F>, arg1: com.mojang.datafixers.types.Type_<G>, arg2: com.mojang.datafixers.types.Type_<G2>): Internal.TypedOptic<com.mojang.datafixers.util.Pair<F, G>, com.mojang.datafixers.util.Pair<F, G2>, G, G2>;
        upCast<Proof2>(arg0: Internal.TypeToken_<Proof2>): Internal.Optional<Internal.Optic<Proof2, S, T, A, B>>;
        static proj1<F, G, F2>(arg0: com.mojang.datafixers.types.Type_<F>, arg1: com.mojang.datafixers.types.Type_<G>, arg2: com.mojang.datafixers.types.Type_<F2>): Internal.TypedOptic<com.mojang.datafixers.util.Pair<F, G>, com.mojang.datafixers.util.Pair<F2, G>, F, F2>;
        static compoundListElements<K, V, V2>(arg0: com.mojang.datafixers.types.Type_<K>, arg1: com.mojang.datafixers.types.Type_<V>, arg2: com.mojang.datafixers.types.Type_<V2>): Internal.TypedOptic<Internal.List<com.mojang.datafixers.util.Pair<K, V>>, Internal.List<com.mojang.datafixers.util.Pair<K, V2>>, V, V2>;
        static list<A, B>(arg0: com.mojang.datafixers.types.Type_<A>, arg1: com.mojang.datafixers.types.Type_<B>): Internal.TypedOptic<Internal.List<A>, Internal.List<B>, A, B>;
        static instanceOf<Proof2>(arg0: Internal.Collection_<Internal.TypeToken_<Internal.K1_>>, arg1: Internal.TypeToken_<Proof2>): boolean;
        bType(): com.mojang.datafixers.types.Type<B>;
        sType(): com.mojang.datafixers.types.Type<S>;
        static compoundListKeys<K, V, K2>(arg0: com.mojang.datafixers.types.Type_<K>, arg1: com.mojang.datafixers.types.Type_<K2>, arg2: com.mojang.datafixers.types.Type_<V>): Internal.TypedOptic<Internal.List<com.mojang.datafixers.util.Pair<K, V>>, Internal.List<com.mojang.datafixers.util.Pair<K2, V>>, K, K2>;
        static tagged<K, A, B>(arg0: Internal.TaggedChoice$TaggedChoiceType_<K>, arg1: K, arg2: com.mojang.datafixers.types.Type_<A>, arg3: com.mojang.datafixers.types.Type_<B>): Internal.TypedOptic<com.mojang.datafixers.util.Pair<K, any>, com.mojang.datafixers.util.Pair<K, any>, A, B>;
        compose<A1, B1>(arg0: Internal.TypedOptic_<A, B, A1, B1>): Internal.TypedOptic<S, T, A1, B1>;
        bounds(): Internal.Set<Internal.TypeToken<Internal.K1>>;
        static inj2<F, G, G2>(arg0: com.mojang.datafixers.types.Type_<F>, arg1: com.mojang.datafixers.types.Type_<G>, arg2: com.mojang.datafixers.types.Type_<G2>): Internal.TypedOptic<Internal.Either<F, G>, Internal.Either<F, G2>, G, G2>;
        optic(): Internal.Optic<any, S, T, A, B>;
        static inj1<F, G, F2>(arg0: com.mojang.datafixers.types.Type_<F>, arg1: com.mojang.datafixers.types.Type_<G>, arg2: com.mojang.datafixers.types.Type_<F2>): Internal.TypedOptic<Internal.Either<F, G>, Internal.Either<F2, G>, F, F2>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(arg0: Internal.TypeToken<Internal.K1>, arg1: com.mojang.datafixers.types.Type<S>, arg2: com.mojang.datafixers.types.Type<T>, arg3: com.mojang.datafixers.types.Type<A>, arg4: com.mojang.datafixers.types.Type<B>, arg5: Internal.Optic<any, S, T, A, B>);
        constructor(arg0: Internal.Set<Internal.TypeToken<Internal.K1>>, arg1: com.mojang.datafixers.types.Type<S>, arg2: com.mojang.datafixers.types.Type<T>, arg3: com.mojang.datafixers.types.Type<A>, arg4: com.mojang.datafixers.types.Type<B>, arg5: Internal.Optic<any, S, T, A, B>);
    }
    type TypedOptic_<S, T, A, B> = TypedOptic<S, T, A, B>;
    /**
    * @javaClass dev.latvian.mods.kubejs.item.ItemFoodEatenEventJS
    */
    class ItemFoodEatenEventJS extends Internal.PlayerEventJS {
        getItem(): Internal.ItemStackJS;
        getEntity(): Internal.EntityJS;
        canCancel(): boolean;
        get item(): Internal.ItemStackJS;
        get entity(): Internal.EntityJS;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor(p: Internal.ServerPlayer, is: Internal.ItemStack);
    }
    type ItemFoodEatenEventJS_ = ItemFoodEatenEventJS;
    /**
    * @javaClass net.minecraft.class_2168
    */
    class CommandSourceStack implements Internal.SharedSuggestionProvider {
        withPermission($$0: number): this;
        withEntity($$0: Internal.Entity_): this;
        getRotation(): Internal.Vec2;
        getPlayerOrException(): Internal.ServerPlayer;
        facing($$0: Vec3_): this;
        facing($$0: Internal.Entity_, $$1: Internal.EntityAnchorArgument$Anchor_): this;
        withLevel($$0: Internal.ServerLevel_): this;
        getAbsoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        getTextName(): string;
        withRotation($$0: Internal.Vec2_): this;
        method_41213($$0: Internal.ResourceKey_<Internal.Registry_<any>>, $$1: Internal.SharedSuggestionProvider$ElementSuggestionType_, $$2: Internal.SuggestionsBuilder_, $$3: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        method_9262(): Internal.Collection<string>;
        method_9261($$0: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        suggestRegistryElements($$0: Internal.Registry_<any>, $$1: Internal.SharedSuggestionProvider$ElementSuggestionType_, $$2: Internal.SuggestionsBuilder_): void;
        withMaximumPermission($$0: number): this;
        method_9267(): Internal.Collection<string>;
        sendSuccess($$0: net.minecraft.network.chat.Component_, $$1: boolean): void;
        getRelevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        getServer(): Internal.MinecraftServer;
        sendFailure($$0: net.minecraft.network.chat.Component_): void;
        withCallback($$0: Internal.ResultConsumer_<Internal.CommandSourceStack_>, $$1: Internal.BinaryOperator_<Internal.ResultConsumer_<Internal.CommandSourceStack_>>): this;
        withCallback($$0: Internal.ResultConsumer_<Internal.CommandSourceStack_>): this;
        getEntity(): Internal.Entity;
        withPosition($$0: Vec3_): this;
        withSuppressedOutput(): this;
        onCommandComplete($$0: Internal.CommandContext_<Internal.CommandSourceStack_>, $$1: boolean, $$2: number): void;
        method_9273(): Internal.Stream<ResourceLocation>;
        getLevel(): Internal.ServerLevel;
        method_30497(): Internal.RegistryAccess;
        getAnchor(): Internal.EntityAnchorArgument$Anchor;
        getPosition(): Vec3;
        method_9254(): Internal.Collection<ResourceLocation>;
        getDisplayName(): net.minecraft.network.chat.Component;
        method_29310(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        withAnchor($$0: Internal.EntityAnchorArgument$Anchor_): this;
        getSelectedEntities(): Internal.Collection<string>;
        method_9259($$0: number): boolean;
        getEntityOrException(): Internal.Entity;
        withSource($$0: Internal.CommandSource_): this;
        static readonly "ERROR_NOT_ENTITY" : Internal.SimpleCommandExceptionType;
        static readonly "ERROR_NOT_PLAYER" : Internal.SimpleCommandExceptionType;
        get server(): Internal.MinecraftServer;
        get playerOrException(): Internal.ServerPlayer;
        get level(): Internal.ServerLevel;
        get relevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        get displayName(): net.minecraft.network.chat.Component;
        get rotation(): Internal.Vec2;
        get selectedEntities(): Internal.Collection<string>;
        get absoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        get textName(): string;
        get anchor(): Internal.EntityAnchorArgument$Anchor;
        get position(): Vec3;
        get entityOrException(): Internal.Entity;
        get entity(): Internal.Entity;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.CommandSource, $$1: Vec3, $$2: Internal.Vec2, $$3: Internal.ServerLevel, $$4: number, $$5: string, $$6: net.minecraft.network.chat.Component, $$7: Internal.MinecraftServer, $$8: Internal.Entity);
    }
    type CommandSourceStack_ = CommandSourceStack;
    /**
    * @javaClass com.almostreliable.lootjs.core.ILootAction
    */
    interface ILootAction extends Internal.ILootHandler {
    }
    type ILootAction_ = ILootAction;
    /**
    * @javaClass dev.latvian.mods.kubejs.net.PainterUpdatedEventJS
    */
    class PainterUpdatedEventJS extends Internal.ClientEventJS {
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type PainterUpdatedEventJS_ = PainterUpdatedEventJS;
    /**
    * @javaClass net.minecraft.class_2835
    */
    interface PaletteResize <T> {
        onResize(arg0: number, arg1: T): number;
    }
    type PaletteResize_<T> = PaletteResize<T>;
    /**
    * @javaClass xaero.common.minimap.render.radar.element.RadarRenderer
    */
    class RadarRenderer extends Internal.MinimapElementRenderer<Internal.Entity, any> {
        postRender(location: number, renderEntity: Internal.Entity_, player: Internal.Player_, renderX: number, renderY: number, renderZ: number, modMain: Internal.AXaeroMinimap_, renderTypeBuffers: Internal.MultiBufferSource$BufferSource_, multiTextureRenderTypeRenderers: Internal.MultiTextureRenderTypeRendererProvider_): void;
        renderElement(location: number, highlit: boolean, outOfBounds: boolean, matrixStack: Internal.PoseStack_, renderTypeBuffers: Internal.MultiBufferSource$BufferSource_, font: net.minecraft.client.gui.Font_, framebuffer: Internal.RenderTarget_, helper: Internal.MinimapRendererHelper_, renderEntity: Internal.Entity_, player: Internal.Player_, renderX: number, renderY: number, renderZ: number, elementIndex: number, optionalDepth: number, optionalScale: number, e: Internal.Entity_, partialX: number, partialY: number, cave: boolean, partialTicks: number): boolean;
        preRender(location: number, renderEntity: Internal.Entity_, player: Internal.Player_, renderX: number, renderY: number, renderZ: number, modMain: Internal.AXaeroMinimap_, renderTypeBuffers: Internal.MultiBufferSource$BufferSource_, multiTextureRenderTypeRenderers: Internal.MultiTextureRenderTypeRendererProvider_): void;
        renderEntityDotToFBO(location: number, highlit: boolean, matrixStack: Internal.PoseStack_, minimap: Internal.MinimapProcessor_, p: Internal.Player_, renderEntity: Internal.Entity_, e: Internal.Entity_, partial: number, name: boolean, icon: boolean, minimapRadar: Internal.MinimapRadar_, style: number, smooth: boolean, debug: boolean, debugEntityVariantIds: boolean, cave: boolean, dotNameScale: number, textRenderTypeBuffer: Internal.MultiBufferSource$BufferSource_, dotsRenderType: Internal.RenderType_, dotsBufferBuilder: Internal.VertexConsumer_, iconsRenderer: Internal.MultiTextureRenderTypeRenderer_, nameBgBuilder: Internal.VertexConsumer_, dotIndex: number, displayNameWhenIconFails: boolean, heightLimit: number, heightBasedFade: boolean, startFadingAt: number, iconScale: number, dotSize: number, colorIndex: number, displayY: boolean, category: Internal.EntityRadarCategory_, helper: Internal.MinimapRendererHelper_, font: net.minecraft.client.gui.Font_, framebuffer: Internal.RenderTarget_, minimapScale: number): void;
        shouldRender(location: number): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
    }
    type RadarRenderer_ = RadarRenderer;
    /**
    * @javaClass net.minecraft.class_6122
    */
    abstract class HeightProvider {
        getType(): Internal.HeightProviderType<any>;
        sample(arg0: Internal.Random_, arg1: Internal.WorldGenerationContext_): number;
        static readonly "CODEC" : Internal.Codec<Internal.HeightProvider>;
        get type(): Internal.HeightProviderType<any>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor();
    }
    type HeightProvider_ = HeightProvider;
    /**
    * @javaClass net.minecraft.class_4634
    */
    class BlockPileConfiguration implements Internal.FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        static readonly "CODEC" : Internal.Codec<Internal.BlockPileConfiguration>;
        readonly "stateProvider" : Internal.BlockStateProvider;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockStateProvider);
    }
    type BlockPileConfiguration_ = BlockPileConfiguration;
    /**
    * @javaClass net.minecraft.class_2718
    */
    class ClientboundRemoveMobEffectPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        method_11052($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEffect(): Internal.MobEffect;
        isSkippable(): boolean;
        getEntity($$0: Internal.Level_): Internal.Entity;
        get effect(): Internal.MobEffect;
        get skippable(): boolean;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: number, $$1: Internal.MobEffect);
        constructor($$0: Internal.FriendlyByteBuf);
    }
    type ClientboundRemoveMobEffectPacket_ = ClientboundRemoveMobEffectPacket;
    /**
    * @javaClass net.darkhax.bookshelf.mixin.entity.AccessorEntity
    */
    interface AccessorEntity {
        bookshelf$createHoverEvent(): Internal.HoverEvent;
    }
    type AccessorEntity_ = AccessorEntity;
    /**
    * @javaClass me.shedaniel.rei.api.client.gui.widgets.Tooltip$Entry
    */
    interface Tooltip$Entry {
        isTooltipComponent(): boolean;
        getAsTooltipComponent(): Internal.TooltipComponent;
        getAsComponent(): Internal.ClientTooltipComponent;
        getAsText(): net.minecraft.network.chat.Component;
        isText(): boolean;
    }
    type Tooltip$Entry_ = Tooltip$Entry;
    /**
    * @javaClass java.awt.image.WritableRenderedImage
    */
    interface WritableRenderedImage extends Internal.RenderedImage {
        getWritableTileIndices(): Internal.Point[];
        getWritableTile(arg0: number, arg1: number): Internal.WritableRaster;
        removeTileObserver(arg0: Internal.TileObserver_): void;
        setData(arg0: Internal.Raster_): void;
        hasTileWriters(): boolean;
        isTileWritable(arg0: number, arg1: number): boolean;
        releaseWritableTile(arg0: number, arg1: number): void;
        addTileObserver(arg0: Internal.TileObserver_): void;
    }
    type WritableRenderedImage_ = WritableRenderedImage;
    /**
    * @javaClass corgitaco.enhancedcelestials.mixin.access.ColorAccess
    */
    interface ColorAccess {
        getColorRaw(): number;
    }
    type ColorAccess_ = ColorAccess;
    /**
    * @javaClass net.minecraft.class_3175
    */
    class SimpleBlockConfiguration extends Internal.Record implements Internal.FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        hashCode(): number;
        equals($$0: any): boolean;
        toPlace(): Internal.BlockStateProvider;
        toString(): string;
        static readonly "CODEC" : Internal.Codec<Internal.SimpleBlockConfiguration>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: Internal.BlockStateProvider);
    }
    type SimpleBlockConfiguration_ = SimpleBlockConfiguration;
    /**
    * @javaClass net.minecraft.class_2611
    */
    class EnderChestBlockEntity extends Internal.BlockEntity implements Internal.LidBlockEntity {
        invalidateCaps(): void;
        stillValid($$0: Internal.Player_): boolean;
        method_11274($$0: number): number;
        onLoad(): void;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        static lidAnimateTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.EnderChestBlockEntity_): void;
        stopOpen($$0: Internal.Player_): void;
        startOpen($$0: Internal.Player_): void;
        method_11004($$0: number, $$1: number): boolean;
        recheckOpen(): void;
        /**
        * Internal constructor, this means that it's not valid unless you use `java()`.
        */
        constructor($$0: BlockPos, $$1: Internal.BlockState);
    }
    type EnderChestBlockEntity_ = EnderChestBlockEntity;
    /**
    * @javaClass java.awt.event.ComponentListener
    */
    interface ComponentListener extends Internal.EventListener {
        componentHidden(arg0: Internal.ComponentEvent_): void;
        componentResized(arg0: Internal.ComponentEvent_): void;
        componentShown(arg0: Internal.ComponentEvent_): void;
        componentMoved(arg0: Internal.ComponentEvent_): void;
    }
    type ComponentListener_ = ComponentListener;
    /**
    * @javaClass net.minecraft.class_2821
    */
    class ImposterProtoChunk extends Internal.ProtoChunk implements Internal.ComponentProvider, Internal.ExtendedChunk {
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        getSectionsCount(): number;
        setBlockEmptinessMap(emptinessMap: boolean[]): void;
        clipWithInteractionOverride($$0: Vec3_, $$1: Vec3_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSkyEmptinessMap(): boolean[];
        method_12034($$0: Internal.Map_<Internal.ConfiguredStructureFeature_<any, any>, Internal.StructureStart_>): void;
        method_16359($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        method_12032($$0: Internal.Heightmap$Types_): Internal.Heightmap;
        getSectionIndex($$0: number): number;
        method_12038(): boolean;
        getBlockEmptinessMap(): boolean[];
        method_12039($$0: BlockPos_): void;
        method_12037($$0: Internal.Heightmap$Types_, $$1: number[]): void;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        handler$zcl000$port_lib$lightLevel(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        method_12180($$0: Internal.ConfiguredStructureFeature_<any, any>): Internal.LongSet;
        method_12181($$0: Internal.ConfiguredStructureFeature_<any, any>): Internal.StructureStart;
        method_12184($$0: Internal.ConfiguredStructureFeature_<any, any>, $$1: Internal.StructureStart_): void;
        method_12020($$0: boolean): void;
        getSectionIndexFromSectionY($$0: number): number;
        method_12182($$0: Internal.ConfiguredStructureFeature_<any, any>, $$1: number): void;
        method_12183($$0: Internal.Map_<Internal.ConfiguredStructureFeature_<any, any>, Internal.LongSet_>): void;
        getMinSection(): number;
        getWrapped(): Internal.LevelChunk;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape_>): number;
        getMaxBuildHeight(): number;
        getRecipientsForComponentSync(): Internal.Iterator<Internal.ServerPlayer>;
        method_8320($$0: BlockPos_): Internal.BlockState;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        method_12308($$0: Internal.ChunkStatus_): void;
        getSkyNibbles(): any[];
        method_12024($$0: BlockPos_): Internal.CompoundTag;
        getComponent<C>(key: Internal.ComponentKey_<C>): C;
        method_8321($$0: BlockPos_): Internal.BlockEntity;
        method_12025($$0: CarvingGenerationStep_): Internal.CarvingMask;
        setBlockNibbles(nibbles: any[]): void;
        method_39294($$0: Internal.BlendingData_): void;
        method_39296(): Internal.ChunkAccess$TicksToSave;
        getBlockEntity<T>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        method_39299(): Internal.BlendingData;
        getLightEmission($$0: BlockPos_): number;
        method_28510($$0: CarvingGenerationStep_): Internal.CarvingMask;
        toComponentPacket<C>(buf: Internal.FriendlyByteBuf_, key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        toComponentPacket<C>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        method_20598($$0: BlockPos_): Internal.CompoundTag;
        method_12018(): Internal.Stream<BlockPos>;
        method_12013(): Internal.TickContainerAccess<Internal.Block>;
        getSectionYFromSectionIndex($$0: number): number;
        method_12010($$0: BlockPos_, $$1: Internal.BlockState_, $$2: boolean): Internal.BlockState;
        setSkyEmptinessMap(emptinessMap: boolean[]): void;
        method_12016(): Internal.Map<Internal.ConfiguredStructureFeature<any, any>, Internal.StructureStart>;
        method_8316($$0: BlockPos_): Internal.FluidState;
        method_12014(): Internal.TickContainerAccess<Internal.Fluid>;
        method_12179(): Internal.Map<Internal.ConfiguredStructureFeature<any, any>, Internal.LongSet>;
        method_8315(): number;
        method_12041($$0: BlockPos_): void;
        method_12042($$0: Internal.CompoundTag_): void;
        getBlockNibbles(): any[];
        getComponentContainer(): Internal.ComponentContainer;
        method_12009(): Internal.ChunkStatus;
        setSkyNibbles(nibbles: any[]): void;
        method_12007($$0: Internal.BlockEntity_): void;
        method_12008($$0: boolean): void;
        method_38257($$0: Internal.BiomeResolver_, $$1: Internal.Climate$Sampler_): void;
        method_12002($$0: Internal.Entity_): void;
        method_38259($$0: number): Internal.LevelChunkSection;
        method_12044(): boolean;
        method_12005($$0: Internal.Heightmap$Types_, $$1: number, $$2: number): number;
        method_12006(): Internal.LevelChunkSection[];
        getMaxSection(): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        method_12004(): Internal.ChunkPos;
        get skyNibbles(): any[];
        get minSection(): number;
        get recipientsForComponentSync(): Internal.Iterator<Intern